// gpu/ipc/common/sync_token.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'gpu/ipc/common/sync_token.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('gpu.mojom');


  var CommandBufferNamespace = {};
  CommandBufferNamespace.INVALID = -1;
  CommandBufferNamespace.GPU_IO = 0;
  CommandBufferNamespace.IN_PROCESS = 1;
  CommandBufferNamespace.VIZ_SKIA_OUTPUT_SURFACE = 2;
  CommandBufferNamespace.VIZ_SKIA_OUTPUT_SURFACE_NON_DDL = 3;
  CommandBufferNamespace.GPU_CHANNEL_SHARED_IMAGE_INTERFACE = 4;
  CommandBufferNamespace.WEBNN_CONTEXT_INTERFACE = 5;
  CommandBufferNamespace.MIN_VALUE = -1;
  CommandBufferNamespace.MAX_VALUE = 5;

  CommandBufferNamespace.isKnownEnumValue = function(value) {
    switch (value) {
    case -1:
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
      return true;
    }
    return false;
  };

  CommandBufferNamespace.toKnownEnumValue = function(value) {
    return value;
  };

  CommandBufferNamespace.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function SyncToken(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SyncToken.prototype.initDefaults_ = function() {
    this.verifiedFlush = false;
    this.namespaceId = 0;
    this.commandBufferId = 0;
    this.releaseCount = 0;
  };
  SyncToken.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SyncToken.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate SyncToken.namespaceId
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, CommandBufferNamespace);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  SyncToken.encodedSize = codec.kStructHeaderSize + 24;

  SyncToken.decode = function(decoder) {
    var packed;
    var val = new SyncToken();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.verifiedFlush = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.namespaceId =
        decoder.decodeStruct(new codec.Enum(CommandBufferNamespace));
    val.commandBufferId =
        decoder.decodeStruct(codec.Uint64);
    val.releaseCount =
        decoder.decodeStruct(codec.Uint64);
    return val;
  };

  SyncToken.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SyncToken.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.verifiedFlush & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.namespaceId);
    encoder.encodeStruct(codec.Uint64, val.commandBufferId);
    encoder.encodeStruct(codec.Uint64, val.releaseCount);
  };
  exports.CommandBufferNamespace = CommandBufferNamespace;
  exports.SyncToken = SyncToken;
})();