// gpu/ipc/common/vulkan_info.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'gpu/ipc/common/vulkan_info.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('gpu.mojom');
  var vulkan_types$ =
      mojo.internal.exposeNamespace('gpu.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'gpu/ipc/common/vulkan_types.mojom', 'vulkan_types.mojom.js');
  }



  function VulkanPhysicalDeviceInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  VulkanPhysicalDeviceInfo.prototype.initDefaults_ = function() {
    this.properties = null;
    this.extensions = null;
    this.features = null;
    this.featureSamplerYcbcrConversion = false;
    this.featureProtectedMemory = false;
    this.queueFamilies = null;
  };
  VulkanPhysicalDeviceInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  VulkanPhysicalDeviceInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VulkanPhysicalDeviceInfo.properties
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, vulkan_types$.VkPhysicalDeviceProperties, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VulkanPhysicalDeviceInfo.extensions
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(vulkan_types$.VkExtensionProperties), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VulkanPhysicalDeviceInfo.features
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, vulkan_types$.VkPhysicalDeviceFeatures, false);
    if (err !== validator.validationError.NONE)
        return err;




    // validate VulkanPhysicalDeviceInfo.queueFamilies
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 32, 8, new codec.PointerTo(vulkan_types$.VkQueueFamilyProperties), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  VulkanPhysicalDeviceInfo.encodedSize = codec.kStructHeaderSize + 40;

  VulkanPhysicalDeviceInfo.decode = function(decoder) {
    var packed;
    var val = new VulkanPhysicalDeviceInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.properties =
        decoder.decodeStructPointer(vulkan_types$.VkPhysicalDeviceProperties);
    val.extensions =
        decoder.decodeArrayPointer(new codec.PointerTo(vulkan_types$.VkExtensionProperties));
    val.features =
        decoder.decodeStructPointer(vulkan_types$.VkPhysicalDeviceFeatures);
    packed = decoder.readUint8();
    val.featureSamplerYcbcrConversion = (packed >> 0) & 1 ? true : false;
    val.featureProtectedMemory = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.queueFamilies =
        decoder.decodeArrayPointer(new codec.PointerTo(vulkan_types$.VkQueueFamilyProperties));
    return val;
  };

  VulkanPhysicalDeviceInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(VulkanPhysicalDeviceInfo.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(vulkan_types$.VkPhysicalDeviceProperties, val.properties);
    encoder.encodeArrayPointer(new codec.PointerTo(vulkan_types$.VkExtensionProperties), val.extensions);
    encoder.encodeStructPointer(vulkan_types$.VkPhysicalDeviceFeatures, val.features);
    packed = 0;
    packed |= (val.featureSamplerYcbcrConversion & 1) << 0
    packed |= (val.featureProtectedMemory & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(new codec.PointerTo(vulkan_types$.VkQueueFamilyProperties), val.queueFamilies);
  };
  function VulkanInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  VulkanInfo.prototype.initDefaults_ = function() {
    this.apiVersion = 0;
    this.usedApiVersion = 0;
    this.instanceExtensions = null;
    this.enabledInstanceExtensions = null;
    this.instanceLayers = null;
    this.physicalDevices = null;
  };
  VulkanInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  VulkanInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;




    // validate VulkanInfo.instanceExtensions
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(vulkan_types$.VkExtensionProperties), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VulkanInfo.enabledInstanceExtensions
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 8, codec.String, false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VulkanInfo.instanceLayers
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 24, 8, new codec.PointerTo(vulkan_types$.VkLayerProperties), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VulkanInfo.physicalDevices
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 32, 8, new codec.PointerTo(VulkanPhysicalDeviceInfo), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  VulkanInfo.encodedSize = codec.kStructHeaderSize + 40;

  VulkanInfo.decode = function(decoder) {
    var packed;
    var val = new VulkanInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.apiVersion =
        decoder.decodeStruct(codec.Uint32);
    val.usedApiVersion =
        decoder.decodeStruct(codec.Uint32);
    val.instanceExtensions =
        decoder.decodeArrayPointer(new codec.PointerTo(vulkan_types$.VkExtensionProperties));
    val.enabledInstanceExtensions =
        decoder.decodeArrayPointer(codec.String);
    val.instanceLayers =
        decoder.decodeArrayPointer(new codec.PointerTo(vulkan_types$.VkLayerProperties));
    val.physicalDevices =
        decoder.decodeArrayPointer(new codec.PointerTo(VulkanPhysicalDeviceInfo));
    return val;
  };

  VulkanInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(VulkanInfo.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.apiVersion);
    encoder.encodeStruct(codec.Uint32, val.usedApiVersion);
    encoder.encodeArrayPointer(new codec.PointerTo(vulkan_types$.VkExtensionProperties), val.instanceExtensions);
    encoder.encodeArrayPointer(codec.String, val.enabledInstanceExtensions);
    encoder.encodeArrayPointer(new codec.PointerTo(vulkan_types$.VkLayerProperties), val.instanceLayers);
    encoder.encodeArrayPointer(new codec.PointerTo(VulkanPhysicalDeviceInfo), val.physicalDevices);
  };
  exports.VulkanPhysicalDeviceInfo = VulkanPhysicalDeviceInfo;
  exports.VulkanInfo = VulkanInfo;
})();