// gpu/ipc/common/vulkan_types.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../mojo/public/js/bindings.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const VkPhysicalDeviceTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const VkPhysicalDeviceType = {
  
  OTHER: 0,
  INTEGRATED_GPU: 1,
  DISCRETE_GPU: 2,
  VIRTUAL_GPU: 3,
  CPU: 4,
  INVALID_VALUE: -1,
  MIN_VALUE: -1,
  MAX_VALUE: 4,
};


/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VkExtensionPropertiesSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VkLayerPropertiesSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VkPhysicalDeviceLimitsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VkPhysicalDeviceSparsePropertiesSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VkPhysicalDevicePropertiesSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VkPhysicalDeviceFeaturesSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VkExtent3DSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VkQueueFamilyPropertiesSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    VkExtensionPropertiesSpec.$,
    'VkExtensionProperties',
    [
      mojo.internal.StructField(
        'extensionName', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'specVersion', 8,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);


export const VkExtensionProperties_Deserialize =
    mojo.internal.createStructDeserializer(VkExtensionPropertiesSpec.$);


/**
 * @record
 */
export class VkExtensionProperties {
  constructor() {
    /** @type { !string } */
    this.extensionName;
    /** @type { !number } */
    this.specVersion;
  }
}



mojo.internal.Struct(
    VkLayerPropertiesSpec.$,
    'VkLayerProperties',
    [
      mojo.internal.StructField(
        'layerName', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'specVersion', 8,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'implementationVersion', 12,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'description', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);


export const VkLayerProperties_Deserialize =
    mojo.internal.createStructDeserializer(VkLayerPropertiesSpec.$);


/**
 * @record
 */
export class VkLayerProperties {
  constructor() {
    /** @type { !string } */
    this.layerName;
    /** @type { !number } */
    this.specVersion;
    /** @type { !number } */
    this.implementationVersion;
    /** @type { !string } */
    this.description;
  }
}



mojo.internal.Struct(
    VkPhysicalDeviceLimitsSpec.$,
    'VkPhysicalDeviceLimits',
    [
      mojo.internal.StructField(
        'maxImageDimension1D', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxImageDimension2D', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxImageDimension3D', 8,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxImageDimensionCube', 12,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxImageArrayLayers', 16,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxTexelBufferElements', 20,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxUniformBufferRange', 24,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxStorageBufferRange', 28,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxPushConstantsSize', 32,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxMemoryAllocationCount', 36,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxSamplerAllocationCount', 40,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'bufferImageGranularity', 48,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sparseAddressSpaceSize', 56,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxBoundDescriptorSets', 44,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxPerStageDescriptorSamplers', 64,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxPerStageDescriptorUniformBuffers', 68,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxPerStageDescriptorStorageBuffers', 72,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxPerStageDescriptorSampledImages', 76,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxPerStageDescriptorStorageImages', 80,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxPerStageDescriptorInputAttachments', 84,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxPerStageResources', 88,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxDescriptorSetSamplers', 92,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxDescriptorSetUniformBuffers', 96,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxDescriptorSetUniformBuffersDynamic', 100,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxDescriptorSetStorageBuffers', 104,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxDescriptorSetStorageBuffersDynamic', 108,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxDescriptorSetSampledImages', 112,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxDescriptorSetStorageImages', 116,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxDescriptorSetInputAttachments', 120,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxVertexInputAttributes', 124,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxVertexInputBindings', 128,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxVertexInputAttributeOffset', 132,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxVertexInputBindingStride', 136,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxVertexOutputComponents', 140,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxTessellationGenerationLevel', 144,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxTessellationPatchSize', 148,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxTessellationControlPerVertexInputComponents', 152,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxTessellationControlPerVertexOutputComponents', 156,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxTessellationControlPerPatchOutputComponents', 160,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxTessellationControlTotalOutputComponents', 164,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxTessellationEvaluationInputComponents', 168,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxTessellationEvaluationOutputComponents', 172,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxGeometryShaderInvocations', 176,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxGeometryInputComponents', 180,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxGeometryOutputComponents', 184,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxGeometryOutputVertices', 188,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxGeometryTotalOutputComponents', 192,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxFragmentInputComponents', 196,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxFragmentOutputAttachments', 200,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxFragmentDualSrcAttachments', 204,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxFragmentCombinedOutputResources', 208,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxComputeSharedMemorySize', 212,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxComputeWorkGroupCount', 216,
        0,
        mojo.internal.Array(mojo.internal.Uint32, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxComputeWorkGroupInvocations', 224,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxComputeWorkGroupSize', 232,
        0,
        mojo.internal.Array(mojo.internal.Uint32, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'subPixelPrecisionBits', 228,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'subTexelPrecisionBits', 240,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'mipmapPrecisionBits', 244,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxDrawIndexedIndexValue', 248,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxDrawIndirectCount', 252,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxSamplerLodBias', 256,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxSamplerAnisotropy', 260,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxViewports', 264,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxViewportDimensions', 272,
        0,
        mojo.internal.Array(mojo.internal.Uint32, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'viewportBoundsRange', 280,
        0,
        mojo.internal.Array(mojo.internal.Float, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'viewportSubPixelBits', 268,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'minMemoryMapAlignment', 288,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'minTexelBufferOffsetAlignment', 296,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'minUniformBufferOffsetAlignment', 304,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'minStorageBufferOffsetAlignment', 312,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'minTexelOffset', 320,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxTexelOffset', 324,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'minTexelGatherOffset', 328,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxTexelGatherOffset', 332,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'minInterpolationOffset', 336,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxInterpolationOffset', 340,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'subPixelInterpolationOffsetBits', 344,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxFramebufferWidth', 348,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxFramebufferHeight', 352,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxFramebufferLayers', 356,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'framebufferColorSampleCounts', 360,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'framebufferDepthSampleCounts', 364,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'framebufferStencilSampleCounts', 368,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'framebufferNoAttachmentsSampleCounts', 372,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxColorAttachments', 376,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sampledImageColorSampleCounts', 380,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sampledImageIntegerSampleCounts', 384,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sampledImageDepthSampleCounts', 388,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sampledImageStencilSampleCounts', 392,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'storageImageSampleCounts', 396,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxSampleMaskWords', 400,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'timestampComputeAndGraphics', 404,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'timestampPeriod', 408,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxClipDistances', 412,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxCullDistances', 416,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxCombinedClipAndCullDistances', 420,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'discreteQueuePriorities', 424,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'pointSizeRange', 432,
        0,
        mojo.internal.Array(mojo.internal.Float, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'lineWidthRange', 440,
        0,
        mojo.internal.Array(mojo.internal.Float, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'pointSizeGranularity', 428,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'lineWidthGranularity', 448,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'strictLines', 404,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'standardSampleLocations', 404,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'optimalBufferCopyOffsetAlignment', 456,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'optimalBufferCopyRowPitchAlignment', 464,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'nonCoherentAtomSize', 472,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 488],]);


export const VkPhysicalDeviceLimits_Deserialize =
    mojo.internal.createStructDeserializer(VkPhysicalDeviceLimitsSpec.$);


/**
 * @record
 */
export class VkPhysicalDeviceLimits {
  constructor() {
    /** @type { !number } */
    this.maxImageDimension1D;
    /** @type { !number } */
    this.maxImageDimension2D;
    /** @type { !number } */
    this.maxImageDimension3D;
    /** @type { !number } */
    this.maxImageDimensionCube;
    /** @type { !number } */
    this.maxImageArrayLayers;
    /** @type { !number } */
    this.maxTexelBufferElements;
    /** @type { !number } */
    this.maxUniformBufferRange;
    /** @type { !number } */
    this.maxStorageBufferRange;
    /** @type { !number } */
    this.maxPushConstantsSize;
    /** @type { !number } */
    this.maxMemoryAllocationCount;
    /** @type { !number } */
    this.maxSamplerAllocationCount;
    /** @type { !bigint } */
    this.bufferImageGranularity;
    /** @type { !bigint } */
    this.sparseAddressSpaceSize;
    /** @type { !number } */
    this.maxBoundDescriptorSets;
    /** @type { !number } */
    this.maxPerStageDescriptorSamplers;
    /** @type { !number } */
    this.maxPerStageDescriptorUniformBuffers;
    /** @type { !number } */
    this.maxPerStageDescriptorStorageBuffers;
    /** @type { !number } */
    this.maxPerStageDescriptorSampledImages;
    /** @type { !number } */
    this.maxPerStageDescriptorStorageImages;
    /** @type { !number } */
    this.maxPerStageDescriptorInputAttachments;
    /** @type { !number } */
    this.maxPerStageResources;
    /** @type { !number } */
    this.maxDescriptorSetSamplers;
    /** @type { !number } */
    this.maxDescriptorSetUniformBuffers;
    /** @type { !number } */
    this.maxDescriptorSetUniformBuffersDynamic;
    /** @type { !number } */
    this.maxDescriptorSetStorageBuffers;
    /** @type { !number } */
    this.maxDescriptorSetStorageBuffersDynamic;
    /** @type { !number } */
    this.maxDescriptorSetSampledImages;
    /** @type { !number } */
    this.maxDescriptorSetStorageImages;
    /** @type { !number } */
    this.maxDescriptorSetInputAttachments;
    /** @type { !number } */
    this.maxVertexInputAttributes;
    /** @type { !number } */
    this.maxVertexInputBindings;
    /** @type { !number } */
    this.maxVertexInputAttributeOffset;
    /** @type { !number } */
    this.maxVertexInputBindingStride;
    /** @type { !number } */
    this.maxVertexOutputComponents;
    /** @type { !number } */
    this.maxTessellationGenerationLevel;
    /** @type { !number } */
    this.maxTessellationPatchSize;
    /** @type { !number } */
    this.maxTessellationControlPerVertexInputComponents;
    /** @type { !number } */
    this.maxTessellationControlPerVertexOutputComponents;
    /** @type { !number } */
    this.maxTessellationControlPerPatchOutputComponents;
    /** @type { !number } */
    this.maxTessellationControlTotalOutputComponents;
    /** @type { !number } */
    this.maxTessellationEvaluationInputComponents;
    /** @type { !number } */
    this.maxTessellationEvaluationOutputComponents;
    /** @type { !number } */
    this.maxGeometryShaderInvocations;
    /** @type { !number } */
    this.maxGeometryInputComponents;
    /** @type { !number } */
    this.maxGeometryOutputComponents;
    /** @type { !number } */
    this.maxGeometryOutputVertices;
    /** @type { !number } */
    this.maxGeometryTotalOutputComponents;
    /** @type { !number } */
    this.maxFragmentInputComponents;
    /** @type { !number } */
    this.maxFragmentOutputAttachments;
    /** @type { !number } */
    this.maxFragmentDualSrcAttachments;
    /** @type { !number } */
    this.maxFragmentCombinedOutputResources;
    /** @type { !number } */
    this.maxComputeSharedMemorySize;
    /** @type { !Array<!number> } */
    this.maxComputeWorkGroupCount;
    /** @type { !number } */
    this.maxComputeWorkGroupInvocations;
    /** @type { !Array<!number> } */
    this.maxComputeWorkGroupSize;
    /** @type { !number } */
    this.subPixelPrecisionBits;
    /** @type { !number } */
    this.subTexelPrecisionBits;
    /** @type { !number } */
    this.mipmapPrecisionBits;
    /** @type { !number } */
    this.maxDrawIndexedIndexValue;
    /** @type { !number } */
    this.maxDrawIndirectCount;
    /** @type { !number } */
    this.maxSamplerLodBias;
    /** @type { !number } */
    this.maxSamplerAnisotropy;
    /** @type { !number } */
    this.maxViewports;
    /** @type { !Array<!number> } */
    this.maxViewportDimensions;
    /** @type { !Array<!number> } */
    this.viewportBoundsRange;
    /** @type { !number } */
    this.viewportSubPixelBits;
    /** @type { !bigint } */
    this.minMemoryMapAlignment;
    /** @type { !bigint } */
    this.minTexelBufferOffsetAlignment;
    /** @type { !bigint } */
    this.minUniformBufferOffsetAlignment;
    /** @type { !bigint } */
    this.minStorageBufferOffsetAlignment;
    /** @type { !number } */
    this.minTexelOffset;
    /** @type { !number } */
    this.maxTexelOffset;
    /** @type { !number } */
    this.minTexelGatherOffset;
    /** @type { !number } */
    this.maxTexelGatherOffset;
    /** @type { !number } */
    this.minInterpolationOffset;
    /** @type { !number } */
    this.maxInterpolationOffset;
    /** @type { !number } */
    this.subPixelInterpolationOffsetBits;
    /** @type { !number } */
    this.maxFramebufferWidth;
    /** @type { !number } */
    this.maxFramebufferHeight;
    /** @type { !number } */
    this.maxFramebufferLayers;
    /** @type { !number } */
    this.framebufferColorSampleCounts;
    /** @type { !number } */
    this.framebufferDepthSampleCounts;
    /** @type { !number } */
    this.framebufferStencilSampleCounts;
    /** @type { !number } */
    this.framebufferNoAttachmentsSampleCounts;
    /** @type { !number } */
    this.maxColorAttachments;
    /** @type { !number } */
    this.sampledImageColorSampleCounts;
    /** @type { !number } */
    this.sampledImageIntegerSampleCounts;
    /** @type { !number } */
    this.sampledImageDepthSampleCounts;
    /** @type { !number } */
    this.sampledImageStencilSampleCounts;
    /** @type { !number } */
    this.storageImageSampleCounts;
    /** @type { !number } */
    this.maxSampleMaskWords;
    /** @type { !boolean } */
    this.timestampComputeAndGraphics;
    /** @type { !number } */
    this.timestampPeriod;
    /** @type { !number } */
    this.maxClipDistances;
    /** @type { !number } */
    this.maxCullDistances;
    /** @type { !number } */
    this.maxCombinedClipAndCullDistances;
    /** @type { !number } */
    this.discreteQueuePriorities;
    /** @type { !Array<!number> } */
    this.pointSizeRange;
    /** @type { !Array<!number> } */
    this.lineWidthRange;
    /** @type { !number } */
    this.pointSizeGranularity;
    /** @type { !number } */
    this.lineWidthGranularity;
    /** @type { !boolean } */
    this.strictLines;
    /** @type { !boolean } */
    this.standardSampleLocations;
    /** @type { !bigint } */
    this.optimalBufferCopyOffsetAlignment;
    /** @type { !bigint } */
    this.optimalBufferCopyRowPitchAlignment;
    /** @type { !bigint } */
    this.nonCoherentAtomSize;
  }
}



mojo.internal.Struct(
    VkPhysicalDeviceSparsePropertiesSpec.$,
    'VkPhysicalDeviceSparseProperties',
    [
      mojo.internal.StructField(
        'residencyStandard2DBlockShape', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'residencyStandard2DMultisampleBlockShape', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'residencyStandard3DBlockShape', 0,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'residencyAlignedMipSize', 0,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'residencyNonResidentStrict', 0,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);


export const VkPhysicalDeviceSparseProperties_Deserialize =
    mojo.internal.createStructDeserializer(VkPhysicalDeviceSparsePropertiesSpec.$);


/**
 * @record
 */
export class VkPhysicalDeviceSparseProperties {
  constructor() {
    /** @type { !boolean } */
    this.residencyStandard2DBlockShape;
    /** @type { !boolean } */
    this.residencyStandard2DMultisampleBlockShape;
    /** @type { !boolean } */
    this.residencyStandard3DBlockShape;
    /** @type { !boolean } */
    this.residencyAlignedMipSize;
    /** @type { !boolean } */
    this.residencyNonResidentStrict;
  }
}



mojo.internal.Struct(
    VkPhysicalDevicePropertiesSpec.$,
    'VkPhysicalDeviceProperties',
    [
      mojo.internal.StructField(
        'apiVersion', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'driverVersion', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'vendorID', 8,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'deviceID', 12,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'deviceType', 16,
        0,
        VkPhysicalDeviceTypeSpec.$,
        -1,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'deviceName', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'pipelineCacheUUID', 32,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'limits', 40,
        0,
        VkPhysicalDeviceLimitsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sparseProperties', 48,
        0,
        VkPhysicalDeviceSparsePropertiesSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 64],]);


export const VkPhysicalDeviceProperties_Deserialize =
    mojo.internal.createStructDeserializer(VkPhysicalDevicePropertiesSpec.$);


/**
 * @record
 */
export class VkPhysicalDeviceProperties {
  constructor() {
    /** @type { !number } */
    this.apiVersion;
    /** @type { !number } */
    this.driverVersion;
    /** @type { !number } */
    this.vendorID;
    /** @type { !number } */
    this.deviceID;
    /** @type { !VkPhysicalDeviceType } */
    this.deviceType;
    /** @type { !string } */
    this.deviceName;
    /** @type { !Array<!number> } */
    this.pipelineCacheUUID;
    /** @type { !VkPhysicalDeviceLimits } */
    this.limits;
    /** @type { !VkPhysicalDeviceSparseProperties } */
    this.sparseProperties;
  }
}



mojo.internal.Struct(
    VkPhysicalDeviceFeaturesSpec.$,
    'VkPhysicalDeviceFeatures',
    [
      mojo.internal.StructField(
        'robustBufferAccess', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'fullDrawIndexUint32', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'imageCubeArray', 0,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'independentBlend', 0,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'geometryShader', 0,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'tessellationShader', 0,
        5,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sampleRateShading', 0,
        6,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'dualSrcBlend', 0,
        7,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'logicOp', 1,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'multiDrawIndirect', 1,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'drawIndirectFirstInstance', 1,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'depthClamp', 1,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'depthBiasClamp', 1,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'fillModeNonSolid', 1,
        5,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'depthBounds', 1,
        6,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'wideLines', 1,
        7,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'largePoints', 2,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'alphaToOne', 2,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'multiViewport', 2,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'samplerAnisotropy', 2,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'textureCompressionETC2', 2,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'textureCompressionASTCLDR', 2,
        5,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'textureCompressionBC', 2,
        6,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'occlusionQueryPrecise', 2,
        7,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'pipelineStatisticsQuery', 3,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'vertexPipelineStoresAndAtomics', 3,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'fragmentStoresAndAtomics', 3,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'shaderTessellationAndGeometryPointSize', 3,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'shaderImageGatherExtended', 3,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'shaderStorageImageExtendedFormats', 3,
        5,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'shaderStorageImageMultisample', 3,
        6,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'shaderStorageImageReadWithoutFormat', 3,
        7,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'shaderStorageImageWriteWithoutFormat', 4,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'shaderUniformBufferArrayDynamicIndexing', 4,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'shaderSampledImageArrayDynamicIndexing', 4,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'shaderStorageBufferArrayDynamicIndexing', 4,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'shaderStorageImageArrayDynamicIndexing', 4,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'shaderClipDistance', 4,
        5,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'shaderCullDistance', 4,
        6,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'shaderFloat64', 4,
        7,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'shaderInt64', 5,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'shaderInt16', 5,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'shaderResourceResidency', 5,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'shaderResourceMinLod', 5,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sparseBinding', 5,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sparseResidencyBuffer', 5,
        5,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sparseResidencyImage2D', 5,
        6,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sparseResidencyImage3D', 5,
        7,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sparseResidency2Samples', 6,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sparseResidency4Samples', 6,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sparseResidency8Samples', 6,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sparseResidency16Samples', 6,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sparseResidencyAliased', 6,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'variableMultisampleRate', 6,
        5,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'inheritedQueries', 6,
        6,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);


export const VkPhysicalDeviceFeatures_Deserialize =
    mojo.internal.createStructDeserializer(VkPhysicalDeviceFeaturesSpec.$);


/**
 * @record
 */
export class VkPhysicalDeviceFeatures {
  constructor() {
    /** @type { !boolean } */
    this.robustBufferAccess;
    /** @type { !boolean } */
    this.fullDrawIndexUint32;
    /** @type { !boolean } */
    this.imageCubeArray;
    /** @type { !boolean } */
    this.independentBlend;
    /** @type { !boolean } */
    this.geometryShader;
    /** @type { !boolean } */
    this.tessellationShader;
    /** @type { !boolean } */
    this.sampleRateShading;
    /** @type { !boolean } */
    this.dualSrcBlend;
    /** @type { !boolean } */
    this.logicOp;
    /** @type { !boolean } */
    this.multiDrawIndirect;
    /** @type { !boolean } */
    this.drawIndirectFirstInstance;
    /** @type { !boolean } */
    this.depthClamp;
    /** @type { !boolean } */
    this.depthBiasClamp;
    /** @type { !boolean } */
    this.fillModeNonSolid;
    /** @type { !boolean } */
    this.depthBounds;
    /** @type { !boolean } */
    this.wideLines;
    /** @type { !boolean } */
    this.largePoints;
    /** @type { !boolean } */
    this.alphaToOne;
    /** @type { !boolean } */
    this.multiViewport;
    /** @type { !boolean } */
    this.samplerAnisotropy;
    /** @type { !boolean } */
    this.textureCompressionETC2;
    /** @type { !boolean } */
    this.textureCompressionASTCLDR;
    /** @type { !boolean } */
    this.textureCompressionBC;
    /** @type { !boolean } */
    this.occlusionQueryPrecise;
    /** @type { !boolean } */
    this.pipelineStatisticsQuery;
    /** @type { !boolean } */
    this.vertexPipelineStoresAndAtomics;
    /** @type { !boolean } */
    this.fragmentStoresAndAtomics;
    /** @type { !boolean } */
    this.shaderTessellationAndGeometryPointSize;
    /** @type { !boolean } */
    this.shaderImageGatherExtended;
    /** @type { !boolean } */
    this.shaderStorageImageExtendedFormats;
    /** @type { !boolean } */
    this.shaderStorageImageMultisample;
    /** @type { !boolean } */
    this.shaderStorageImageReadWithoutFormat;
    /** @type { !boolean } */
    this.shaderStorageImageWriteWithoutFormat;
    /** @type { !boolean } */
    this.shaderUniformBufferArrayDynamicIndexing;
    /** @type { !boolean } */
    this.shaderSampledImageArrayDynamicIndexing;
    /** @type { !boolean } */
    this.shaderStorageBufferArrayDynamicIndexing;
    /** @type { !boolean } */
    this.shaderStorageImageArrayDynamicIndexing;
    /** @type { !boolean } */
    this.shaderClipDistance;
    /** @type { !boolean } */
    this.shaderCullDistance;
    /** @type { !boolean } */
    this.shaderFloat64;
    /** @type { !boolean } */
    this.shaderInt64;
    /** @type { !boolean } */
    this.shaderInt16;
    /** @type { !boolean } */
    this.shaderResourceResidency;
    /** @type { !boolean } */
    this.shaderResourceMinLod;
    /** @type { !boolean } */
    this.sparseBinding;
    /** @type { !boolean } */
    this.sparseResidencyBuffer;
    /** @type { !boolean } */
    this.sparseResidencyImage2D;
    /** @type { !boolean } */
    this.sparseResidencyImage3D;
    /** @type { !boolean } */
    this.sparseResidency2Samples;
    /** @type { !boolean } */
    this.sparseResidency4Samples;
    /** @type { !boolean } */
    this.sparseResidency8Samples;
    /** @type { !boolean } */
    this.sparseResidency16Samples;
    /** @type { !boolean } */
    this.sparseResidencyAliased;
    /** @type { !boolean } */
    this.variableMultisampleRate;
    /** @type { !boolean } */
    this.inheritedQueries;
  }
}



mojo.internal.Struct(
    VkExtent3DSpec.$,
    'VkExtent3D',
    [
      mojo.internal.StructField(
        'width', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'height', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'depth', 8,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);


export const VkExtent3D_Deserialize =
    mojo.internal.createStructDeserializer(VkExtent3DSpec.$);


/**
 * @record
 */
export class VkExtent3D {
  constructor() {
    /** @type { !number } */
    this.width;
    /** @type { !number } */
    this.height;
    /** @type { !number } */
    this.depth;
  }
}



mojo.internal.Struct(
    VkQueueFamilyPropertiesSpec.$,
    'VkQueueFamilyProperties',
    [
      mojo.internal.StructField(
        'queueFlags', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'queueCount', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'timestampValidBits', 8,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'minImageTransferGranularity', 16,
        0,
        VkExtent3DSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);


export const VkQueueFamilyProperties_Deserialize =
    mojo.internal.createStructDeserializer(VkQueueFamilyPropertiesSpec.$);


/**
 * @record
 */
export class VkQueueFamilyProperties {
  constructor() {
    /** @type { !number } */
    this.queueFlags;
    /** @type { !number } */
    this.queueCount;
    /** @type { !number } */
    this.timestampValidBits;
    /** @type { !VkExtent3D } */
    this.minImageTransferGranularity;
  }
}

