// media/mojo/mojom/cdm_document_service.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../mojo/public/js/bindings.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class CdmDocumentServicePendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media.mojom.CdmDocumentService', scope);
  }
}

/** @interface */
export class CdmDocumentServiceInterface {
  
  /**
   * @param { !string } serviceId
   * @param { !string } challenge
   * @return {!Promise<{
        success: !boolean,
        signedData: !string,
        signedDataSignature: !string,
        platformKeyCertificate: !string,
   *  }>}
   */

  challengePlatform(serviceId, challenge) {}
  
  /**
   * @param { !number } version
   * @return {!Promise<{
        version: !number,
        storageId: !Array<!number>,
   *  }>}
   */

  getStorageId(version) {}
  
  /**
   * @return {!Promise<{
        enabled: !boolean,
   *  }>}
   */

  isVerifiedAccessEnabled() {}
}

/**
 * @implements { CdmDocumentServiceInterface }
 */
export class CdmDocumentServiceRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!CdmDocumentServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          CdmDocumentServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!CdmDocumentServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !string } serviceId
   * @param { !string } challenge
   * @return {!Promise<{
        success: !boolean,
        signedData: !string,
        signedDataSignature: !string,
        platformKeyCertificate: !string,
   *  }>}
   */

  challengePlatform(
      serviceId,
      challenge) {
    return this.proxy.sendMessage(
        0,
        CdmDocumentService_ChallengePlatform_ParamsSpec.$,
        CdmDocumentService_ChallengePlatform_ResponseParamsSpec.$,
        [
          serviceId,
          challenge
        ],
        false);
  }

  
  /**
   * @param { !number } version
   * @return {!Promise<{
        version: !number,
        storageId: !Array<!number>,
   *  }>}
   */

  getStorageId(
      version) {
    return this.proxy.sendMessage(
        1,
        CdmDocumentService_GetStorageId_ParamsSpec.$,
        CdmDocumentService_GetStorageId_ResponseParamsSpec.$,
        [
          version
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        enabled: !boolean,
   *  }>}
   */

  isVerifiedAccessEnabled() {
    return this.proxy.sendMessage(
        2,
        CdmDocumentService_IsVerifiedAccessEnabled_ParamsSpec.$,
        CdmDocumentService_IsVerifiedAccessEnabled_ResponseParamsSpec.$,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the CdmDocumentService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class CdmDocumentServiceReceiver {
  /**
   * @param {!CdmDocumentServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!CdmDocumentServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        CdmDocumentServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!CdmDocumentServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        CdmDocumentService_ChallengePlatform_ParamsSpec.$,
        CdmDocumentService_ChallengePlatform_ResponseParamsSpec.$,
        impl.challengePlatform.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        CdmDocumentService_GetStorageId_ParamsSpec.$,
        CdmDocumentService_GetStorageId_ResponseParamsSpec.$,
        impl.getStorageId.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        CdmDocumentService_IsVerifiedAccessEnabled_ParamsSpec.$,
        CdmDocumentService_IsVerifiedAccessEnabled_ResponseParamsSpec.$,
        impl.isVerifiedAccessEnabled.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class CdmDocumentService {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.CdmDocumentService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!CdmDocumentServiceRemote}
   */
  static getRemote() {
    let remote = new CdmDocumentServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the CdmDocumentService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class CdmDocumentServiceCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      CdmDocumentServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!CdmDocumentServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.challengePlatform =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        CdmDocumentService_ChallengePlatform_ParamsSpec.$,
        CdmDocumentService_ChallengePlatform_ResponseParamsSpec.$,
        this.challengePlatform.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getStorageId =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        CdmDocumentService_GetStorageId_ParamsSpec.$,
        CdmDocumentService_GetStorageId_ResponseParamsSpec.$,
        this.getStorageId.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.isVerifiedAccessEnabled =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        CdmDocumentService_IsVerifiedAccessEnabled_ParamsSpec.$,
        CdmDocumentService_IsVerifiedAccessEnabled_ResponseParamsSpec.$,
        this.isVerifiedAccessEnabled.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CdmDocumentService_ChallengePlatform_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CdmDocumentService_ChallengePlatform_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CdmDocumentService_GetStorageId_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CdmDocumentService_GetStorageId_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CdmDocumentService_IsVerifiedAccessEnabled_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CdmDocumentService_IsVerifiedAccessEnabled_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    CdmDocumentService_ChallengePlatform_ParamsSpec.$,
    'CdmDocumentService_ChallengePlatform_Params',
    [
      mojo.internal.StructField(
        'serviceId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'challenge', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class CdmDocumentService_ChallengePlatform_Params {
  constructor() {
    /** @type { !string } */
    this.serviceId;
    /** @type { !string } */
    this.challenge;
  }
}



mojo.internal.Struct(
    CdmDocumentService_ChallengePlatform_ResponseParamsSpec.$,
    'CdmDocumentService_ChallengePlatform_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'signedData', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'signedDataSignature', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'platformKeyCertificate', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class CdmDocumentService_ChallengePlatform_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.success;
    /** @type { !string } */
    this.signedData;
    /** @type { !string } */
    this.signedDataSignature;
    /** @type { !string } */
    this.platformKeyCertificate;
  }
}



mojo.internal.Struct(
    CdmDocumentService_GetStorageId_ParamsSpec.$,
    'CdmDocumentService_GetStorageId_Params',
    [
      mojo.internal.StructField(
        'version', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class CdmDocumentService_GetStorageId_Params {
  constructor() {
    /** @type { !number } */
    this.version;
  }
}



mojo.internal.Struct(
    CdmDocumentService_GetStorageId_ResponseParamsSpec.$,
    'CdmDocumentService_GetStorageId_ResponseParams',
    [
      mojo.internal.StructField(
        'version', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'storageId', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class CdmDocumentService_GetStorageId_ResponseParams {
  constructor() {
    /** @type { !number } */
    this.version;
    /** @type { !Array<!number> } */
    this.storageId;
  }
}



mojo.internal.Struct(
    CdmDocumentService_IsVerifiedAccessEnabled_ParamsSpec.$,
    'CdmDocumentService_IsVerifiedAccessEnabled_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class CdmDocumentService_IsVerifiedAccessEnabled_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    CdmDocumentService_IsVerifiedAccessEnabled_ResponseParamsSpec.$,
    'CdmDocumentService_IsVerifiedAccessEnabled_ResponseParams',
    [
      mojo.internal.StructField(
        'enabled', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class CdmDocumentService_IsVerifiedAccessEnabled_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.enabled;
  }
}

