// media/mojo/mojom/cdm_storage.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');







goog.provide('media.mojom.CdmStorage');
goog.provide('media.mojom.CdmStorageReceiver');
goog.provide('media.mojom.CdmStorageCallbackRouter');
goog.provide('media.mojom.CdmStorageInterface');
goog.provide('media.mojom.CdmStorageRemote');
goog.provide('media.mojom.CdmStoragePendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
media.mojom.CdmStoragePendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        media.mojom.CdmStorage.$interfaceName,
        scope);
  }
};

/** @interface */
media.mojom.CdmStorageInterface = class {
  
  /**
   * @param { !string } fileName
   * @return {!Promise<{
        status: !media.mojom.CdmStorage_Status,
        cdmFile: ?Object,
   *  }>}
   */

  open(fileName) {}
};

/**
 * @export
 * @implements { media.mojom.CdmStorageInterface }
 */
media.mojom.CdmStorageRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!media.mojom.CdmStoragePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          media.mojom.CdmStoragePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!media.mojom.CdmStoragePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !string } fileName
   * @return {!Promise<{
        status: !media.mojom.CdmStorage_Status,
        cdmFile: ?Object,
   *  }>}
   */

  open(
      fileName) {
    return this.proxy.sendMessage(
        0,
        media.mojom.CdmStorage_Open_ParamsSpec.$,
        media.mojom.CdmStorage_Open_ResponseParamsSpec.$,
        [
          fileName
        ],
        false);
  }
};

/**
 * An object which receives request messages for the CdmStorage
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
media.mojom.CdmStorageReceiver = class {
  /**
   * @param {!media.mojom.CdmStorageInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!media.mojom.CdmStorageRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        media.mojom.CdmStorageRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.CdmStorageRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        media.mojom.CdmStorage_Open_ParamsSpec.$,
        media.mojom.CdmStorage_Open_ResponseParamsSpec.$,
        impl.open.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
media.mojom.CdmStorage = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.CdmStorage";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!media.mojom.CdmStorageRemote}
   * @export
   */
  static getRemote() {
    let remote = new media.mojom.CdmStorageRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};

goog.provide('media.mojom.CdmStorage_Status');
goog.provide('media.mojom.CdmStorage.StatusSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
media.mojom.CdmStorage.StatusSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
media.mojom.CdmStorage_Status = {
  
  kSuccess: 0,
  kInUse: 1,
  kFailure: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * An object which receives request messages for the CdmStorage
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
media.mojom.CdmStorageCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      media.mojom.CdmStorageRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.CdmStorageRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.open =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        media.mojom.CdmStorage_Open_ParamsSpec.$,
        media.mojom.CdmStorage_Open_ResponseParamsSpec.$,
        this.open.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('media.mojom.CdmFile');
goog.provide('media.mojom.CdmFileReceiver');
goog.provide('media.mojom.CdmFileCallbackRouter');
goog.provide('media.mojom.CdmFileInterface');
goog.provide('media.mojom.CdmFileRemote');
goog.provide('media.mojom.CdmFilePendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
media.mojom.CdmFilePendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        media.mojom.CdmFile.$interfaceName,
        scope);
  }
};

/** @interface */
media.mojom.CdmFileInterface = class {
  
  /**
   * @return {!Promise<{
        status: !media.mojom.CdmFile_Status,
        data: !Array<!number>,
   *  }>}
   */

  read() {}
  
  /**
   * @param { !Array<!number> } data
   * @return {!Promise<{
        status: !media.mojom.CdmFile_Status,
   *  }>}
   */

  write(data) {}
};

/**
 * @export
 * @implements { media.mojom.CdmFileInterface }
 */
media.mojom.CdmFileRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!media.mojom.CdmFilePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          media.mojom.CdmFilePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!media.mojom.CdmFilePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        status: !media.mojom.CdmFile_Status,
        data: !Array<!number>,
   *  }>}
   */

  read() {
    return this.proxy.sendMessage(
        0,
        media.mojom.CdmFile_Read_ParamsSpec.$,
        media.mojom.CdmFile_Read_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !Array<!number> } data
   * @return {!Promise<{
        status: !media.mojom.CdmFile_Status,
   *  }>}
   */

  write(
      data) {
    return this.proxy.sendMessage(
        1,
        media.mojom.CdmFile_Write_ParamsSpec.$,
        media.mojom.CdmFile_Write_ResponseParamsSpec.$,
        [
          data
        ],
        false);
  }
};

/**
 * An object which receives request messages for the CdmFile
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
media.mojom.CdmFileReceiver = class {
  /**
   * @param {!media.mojom.CdmFileInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!media.mojom.CdmFileRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        media.mojom.CdmFileRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.CdmFileRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        media.mojom.CdmFile_Read_ParamsSpec.$,
        media.mojom.CdmFile_Read_ResponseParamsSpec.$,
        impl.read.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        media.mojom.CdmFile_Write_ParamsSpec.$,
        media.mojom.CdmFile_Write_ResponseParamsSpec.$,
        impl.write.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
media.mojom.CdmFile = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.CdmFile";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!media.mojom.CdmFileRemote}
   * @export
   */
  static getRemote() {
    let remote = new media.mojom.CdmFileRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};

goog.provide('media.mojom.CdmFile_Status');
goog.provide('media.mojom.CdmFile.StatusSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
media.mojom.CdmFile.StatusSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
media.mojom.CdmFile_Status = {
  
  kSuccess: 0,
  kFailure: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

/**
 * An object which receives request messages for the CdmFile
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
media.mojom.CdmFileCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      media.mojom.CdmFileRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.CdmFileRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.read =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        media.mojom.CdmFile_Read_ParamsSpec.$,
        media.mojom.CdmFile_Read_ResponseParamsSpec.$,
        this.read.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.write =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        media.mojom.CdmFile_Write_ParamsSpec.$,
        media.mojom.CdmFile_Write_ResponseParamsSpec.$,
        this.write.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('media.mojom.CdmStorage_Open_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.CdmStorage_Open_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.CdmStorage_Open_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.CdmStorage_Open_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.CdmFile_Read_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.CdmFile_Read_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.CdmFile_Read_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.CdmFile_Read_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.CdmFile_Write_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.CdmFile_Write_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.CdmFile_Write_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.CdmFile_Write_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    media.mojom.CdmStorage_Open_ParamsSpec.$,
    'CdmStorage_Open_Params',
    [
      mojo.internal.StructField(
        'fileName', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.CdmStorage_Open_Params');

/** @record */
media.mojom.CdmStorage_Open_Params = class {
  constructor() {
    /** @export { !string } */
    this.fileName;
  }
};



mojo.internal.Struct(
    media.mojom.CdmStorage_Open_ResponseParamsSpec.$,
    'CdmStorage_Open_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        media.mojom.CdmStorage.StatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'cdmFile', 4,
        0,
        mojo.internal.AssociatedInterfaceProxy(media.mojom.CdmFileRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('media.mojom.CdmStorage_Open_ResponseParams');

/** @record */
media.mojom.CdmStorage_Open_ResponseParams = class {
  constructor() {
    /** @export { !media.mojom.CdmStorage_Status } */
    this.status;
    /** @export { (Object|undefined) } */
    this.cdmFile;
  }
};



mojo.internal.Struct(
    media.mojom.CdmFile_Read_ParamsSpec.$,
    'CdmFile_Read_Params',
    [
    ],
    [[0, 8],]);



goog.provide('media.mojom.CdmFile_Read_Params');

/** @record */
media.mojom.CdmFile_Read_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    media.mojom.CdmFile_Read_ResponseParamsSpec.$,
    'CdmFile_Read_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        media.mojom.CdmFile.StatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'data', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('media.mojom.CdmFile_Read_ResponseParams');

/** @record */
media.mojom.CdmFile_Read_ResponseParams = class {
  constructor() {
    /** @export { !media.mojom.CdmFile_Status } */
    this.status;
    /** @export { !Array<!number> } */
    this.data;
  }
};



mojo.internal.Struct(
    media.mojom.CdmFile_Write_ParamsSpec.$,
    'CdmFile_Write_Params',
    [
      mojo.internal.StructField(
        'data', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.CdmFile_Write_Params');

/** @record */
media.mojom.CdmFile_Write_Params = class {
  constructor() {
    /** @export { !Array<!number> } */
    this.data;
  }
};



mojo.internal.Struct(
    media.mojom.CdmFile_Write_ResponseParamsSpec.$,
    'CdmFile_Write_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        media.mojom.CdmFile.StatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.CdmFile_Write_ResponseParams');

/** @record */
media.mojom.CdmFile_Write_ResponseParams = class {
  constructor() {
    /** @export { !media.mojom.CdmFile_Status } */
    this.status;
  }
};

