// media/mojo/mojom/content_decryption_module.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../mojo/public/js/bindings.js';

import {
  UnguessableToken as mojoBase_mojom_UnguessableToken,
  UnguessableTokenSpec as mojoBase_mojom_UnguessableTokenSpec
} from '../../../mojo/public/mojom/base/unguessable_token.mojom.m.js';

import {
  DecryptorRemote as media_mojom_DecryptorRemote,
  DecryptorPendingReceiver as media_mojom_DecryptorPendingReceiver
} from './decryptor.mojom.m.js';

import {
  CdmSessionClosedReason as media_mojom_CdmSessionClosedReason,
  CdmSessionClosedReasonSpec as media_mojom_CdmSessionClosedReasonSpec,
  CreateCdmStatus as media_mojom_CreateCdmStatus,
  CreateCdmStatusSpec as media_mojom_CreateCdmStatusSpec
} from './media_types.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const EmeInitDataTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const EmeInitDataType = {
  
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const CdmSessionTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const CdmSessionType = {
  
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const CdmMessageTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const CdmMessageType = {
  
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const CdmKeyStatusSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const CdmKeyStatus = {
  
  USABLE: 0,
  INTERNAL_ERROR: 1,
  EXPIRED: 2,
  OUTPUT_RESTRICTED: 3,
  OUTPUT_DOWNSCALED: 4,
  KEY_STATUS_PENDING: 5,
  RELEASED: 6,
  USABLE_IN_FUTURE: 7,
  MIN_VALUE: 0,
  MAX_VALUE: 7,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const HdcpVersionSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const HdcpVersion = {
  
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class ContentDecryptionModulePendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media.mojom.ContentDecryptionModule', scope);
  }
}

/** @interface */
export class ContentDecryptionModuleInterface {
  
  /**
   * @param { !Object } client
   */

  setClient(client) {}
  
  /**
   * @param { !Array<!number> } certificateData
   * @return {!Promise<{
        result: !CdmPromiseResult,
   *  }>}
   */

  setServerCertificate(certificateData) {}
  
  /**
   * @param { !HdcpVersion } minHdcpVersion
   * @return {!Promise<{
        result: !CdmPromiseResult,
        keyStatus: !CdmKeyStatus,
   *  }>}
   */

  getStatusForPolicy(minHdcpVersion) {}
  
  /**
   * @param { !CdmSessionType } sessionType
   * @param { !EmeInitDataType } initDataType
   * @param { !Array<!number> } initData
   * @return {!Promise<{
        result: !CdmPromiseResult,
        sessionId: !string,
   *  }>}
   */

  createSessionAndGenerateRequest(sessionType, initDataType, initData) {}
  
  /**
   * @param { !CdmSessionType } sessionType
   * @param { !string } sessionId
   * @return {!Promise<{
        result: !CdmPromiseResult,
        sessionId: !string,
   *  }>}
   */

  loadSession(sessionType, sessionId) {}
  
  /**
   * @param { !string } sessionId
   * @param { !Array<!number> } response
   * @return {!Promise<{
        result: !CdmPromiseResult,
   *  }>}
   */

  updateSession(sessionId, response) {}
  
  /**
   * @param { !string } sessionId
   * @return {!Promise<{
        result: !CdmPromiseResult,
   *  }>}
   */

  closeSession(sessionId) {}
  
  /**
   * @param { !string } sessionId
   * @return {!Promise<{
        result: !CdmPromiseResult,
   *  }>}
   */

  removeSession(sessionId) {}
}

/**
 * @implements { ContentDecryptionModuleInterface }
 */
export class ContentDecryptionModuleRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ContentDecryptionModulePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ContentDecryptionModulePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ContentDecryptionModulePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Object } client
   */

  setClient(
      client) {
    this.proxy.sendMessage(
        0,
        ContentDecryptionModule_SetClient_ParamsSpec.$,
        null,
        [
          client
        ],
        false);
  }

  
  /**
   * @param { !Array<!number> } certificateData
   * @return {!Promise<{
        result: !CdmPromiseResult,
   *  }>}
   */

  setServerCertificate(
      certificateData) {
    return this.proxy.sendMessage(
        1,
        ContentDecryptionModule_SetServerCertificate_ParamsSpec.$,
        ContentDecryptionModule_SetServerCertificate_ResponseParamsSpec.$,
        [
          certificateData
        ],
        false);
  }

  
  /**
   * @param { !HdcpVersion } minHdcpVersion
   * @return {!Promise<{
        result: !CdmPromiseResult,
        keyStatus: !CdmKeyStatus,
   *  }>}
   */

  getStatusForPolicy(
      minHdcpVersion) {
    return this.proxy.sendMessage(
        2,
        ContentDecryptionModule_GetStatusForPolicy_ParamsSpec.$,
        ContentDecryptionModule_GetStatusForPolicy_ResponseParamsSpec.$,
        [
          minHdcpVersion
        ],
        false);
  }

  
  /**
   * @param { !CdmSessionType } sessionType
   * @param { !EmeInitDataType } initDataType
   * @param { !Array<!number> } initData
   * @return {!Promise<{
        result: !CdmPromiseResult,
        sessionId: !string,
   *  }>}
   */

  createSessionAndGenerateRequest(
      sessionType,
      initDataType,
      initData) {
    return this.proxy.sendMessage(
        3,
        ContentDecryptionModule_CreateSessionAndGenerateRequest_ParamsSpec.$,
        ContentDecryptionModule_CreateSessionAndGenerateRequest_ResponseParamsSpec.$,
        [
          sessionType,
          initDataType,
          initData
        ],
        false);
  }

  
  /**
   * @param { !CdmSessionType } sessionType
   * @param { !string } sessionId
   * @return {!Promise<{
        result: !CdmPromiseResult,
        sessionId: !string,
   *  }>}
   */

  loadSession(
      sessionType,
      sessionId) {
    return this.proxy.sendMessage(
        4,
        ContentDecryptionModule_LoadSession_ParamsSpec.$,
        ContentDecryptionModule_LoadSession_ResponseParamsSpec.$,
        [
          sessionType,
          sessionId
        ],
        false);
  }

  
  /**
   * @param { !string } sessionId
   * @param { !Array<!number> } response
   * @return {!Promise<{
        result: !CdmPromiseResult,
   *  }>}
   */

  updateSession(
      sessionId,
      response) {
    return this.proxy.sendMessage(
        5,
        ContentDecryptionModule_UpdateSession_ParamsSpec.$,
        ContentDecryptionModule_UpdateSession_ResponseParamsSpec.$,
        [
          sessionId,
          response
        ],
        false);
  }

  
  /**
   * @param { !string } sessionId
   * @return {!Promise<{
        result: !CdmPromiseResult,
   *  }>}
   */

  closeSession(
      sessionId) {
    return this.proxy.sendMessage(
        6,
        ContentDecryptionModule_CloseSession_ParamsSpec.$,
        ContentDecryptionModule_CloseSession_ResponseParamsSpec.$,
        [
          sessionId
        ],
        false);
  }

  
  /**
   * @param { !string } sessionId
   * @return {!Promise<{
        result: !CdmPromiseResult,
   *  }>}
   */

  removeSession(
      sessionId) {
    return this.proxy.sendMessage(
        7,
        ContentDecryptionModule_RemoveSession_ParamsSpec.$,
        ContentDecryptionModule_RemoveSession_ResponseParamsSpec.$,
        [
          sessionId
        ],
        false);
  }
}

/**
 * An object which receives request messages for the ContentDecryptionModule
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ContentDecryptionModuleReceiver {
  /**
   * @param {!ContentDecryptionModuleInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ContentDecryptionModuleRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ContentDecryptionModuleRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ContentDecryptionModuleRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ContentDecryptionModule_SetClient_ParamsSpec.$,
        null,
        impl.setClient.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        ContentDecryptionModule_SetServerCertificate_ParamsSpec.$,
        ContentDecryptionModule_SetServerCertificate_ResponseParamsSpec.$,
        impl.setServerCertificate.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        ContentDecryptionModule_GetStatusForPolicy_ParamsSpec.$,
        ContentDecryptionModule_GetStatusForPolicy_ResponseParamsSpec.$,
        impl.getStatusForPolicy.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        ContentDecryptionModule_CreateSessionAndGenerateRequest_ParamsSpec.$,
        ContentDecryptionModule_CreateSessionAndGenerateRequest_ResponseParamsSpec.$,
        impl.createSessionAndGenerateRequest.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        ContentDecryptionModule_LoadSession_ParamsSpec.$,
        ContentDecryptionModule_LoadSession_ResponseParamsSpec.$,
        impl.loadSession.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        ContentDecryptionModule_UpdateSession_ParamsSpec.$,
        ContentDecryptionModule_UpdateSession_ResponseParamsSpec.$,
        impl.updateSession.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        ContentDecryptionModule_CloseSession_ParamsSpec.$,
        ContentDecryptionModule_CloseSession_ResponseParamsSpec.$,
        impl.closeSession.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        ContentDecryptionModule_RemoveSession_ParamsSpec.$,
        ContentDecryptionModule_RemoveSession_ResponseParamsSpec.$,
        impl.removeSession.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class ContentDecryptionModule {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.ContentDecryptionModule";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ContentDecryptionModuleRemote}
   */
  static getRemote() {
    let remote = new ContentDecryptionModuleRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the ContentDecryptionModule
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ContentDecryptionModuleCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ContentDecryptionModuleRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ContentDecryptionModuleRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setClient =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ContentDecryptionModule_SetClient_ParamsSpec.$,
        null,
        this.setClient.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setServerCertificate =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        ContentDecryptionModule_SetServerCertificate_ParamsSpec.$,
        ContentDecryptionModule_SetServerCertificate_ResponseParamsSpec.$,
        this.setServerCertificate.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getStatusForPolicy =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        ContentDecryptionModule_GetStatusForPolicy_ParamsSpec.$,
        ContentDecryptionModule_GetStatusForPolicy_ResponseParamsSpec.$,
        this.getStatusForPolicy.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createSessionAndGenerateRequest =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        ContentDecryptionModule_CreateSessionAndGenerateRequest_ParamsSpec.$,
        ContentDecryptionModule_CreateSessionAndGenerateRequest_ResponseParamsSpec.$,
        this.createSessionAndGenerateRequest.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.loadSession =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        ContentDecryptionModule_LoadSession_ParamsSpec.$,
        ContentDecryptionModule_LoadSession_ResponseParamsSpec.$,
        this.loadSession.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateSession =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        ContentDecryptionModule_UpdateSession_ParamsSpec.$,
        ContentDecryptionModule_UpdateSession_ResponseParamsSpec.$,
        this.updateSession.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.closeSession =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        ContentDecryptionModule_CloseSession_ParamsSpec.$,
        ContentDecryptionModule_CloseSession_ResponseParamsSpec.$,
        this.closeSession.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.removeSession =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        ContentDecryptionModule_RemoveSession_ParamsSpec.$,
        ContentDecryptionModule_RemoveSession_ResponseParamsSpec.$,
        this.removeSession.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class ContentDecryptionModuleClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media.mojom.ContentDecryptionModuleClient', scope);
  }
}

/** @interface */
export class ContentDecryptionModuleClientInterface {
  
  /**
   * @param { !string } sessionId
   * @param { !CdmMessageType } messageType
   * @param { !Array<!number> } message
   */

  onSessionMessage(sessionId, messageType, message) {}
  
  /**
   * @param { !string } sessionId
   * @param { !media_mojom_CdmSessionClosedReason } reason
   */

  onSessionClosed(sessionId, reason) {}
  
  /**
   * @param { !string } sessionId
   * @param { !boolean } hasAdditionalUsableKey
   * @param { !Array<!CdmKeyInformation> } keysInfo
   */

  onSessionKeysChange(sessionId, hasAdditionalUsableKey, keysInfo) {}
  
  /**
   * @param { !string } sessionId
   * @param { !number } newExpiryTimeSec
   */

  onSessionExpirationUpdate(sessionId, newExpiryTimeSec) {}
}

/**
 * @implements { ContentDecryptionModuleClientInterface }
 */
export class ContentDecryptionModuleClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ContentDecryptionModuleClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ContentDecryptionModuleClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ContentDecryptionModuleClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !string } sessionId
   * @param { !CdmMessageType } messageType
   * @param { !Array<!number> } message
   */

  onSessionMessage(
      sessionId,
      messageType,
      message) {
    this.proxy.sendMessage(
        0,
        ContentDecryptionModuleClient_OnSessionMessage_ParamsSpec.$,
        null,
        [
          sessionId,
          messageType,
          message
        ],
        false);
  }

  
  /**
   * @param { !string } sessionId
   * @param { !media_mojom_CdmSessionClosedReason } reason
   */

  onSessionClosed(
      sessionId,
      reason) {
    this.proxy.sendMessage(
        1,
        ContentDecryptionModuleClient_OnSessionClosed_ParamsSpec.$,
        null,
        [
          sessionId,
          reason
        ],
        false);
  }

  
  /**
   * @param { !string } sessionId
   * @param { !boolean } hasAdditionalUsableKey
   * @param { !Array<!CdmKeyInformation> } keysInfo
   */

  onSessionKeysChange(
      sessionId,
      hasAdditionalUsableKey,
      keysInfo) {
    this.proxy.sendMessage(
        2,
        ContentDecryptionModuleClient_OnSessionKeysChange_ParamsSpec.$,
        null,
        [
          sessionId,
          hasAdditionalUsableKey,
          keysInfo
        ],
        false);
  }

  
  /**
   * @param { !string } sessionId
   * @param { !number } newExpiryTimeSec
   */

  onSessionExpirationUpdate(
      sessionId,
      newExpiryTimeSec) {
    this.proxy.sendMessage(
        3,
        ContentDecryptionModuleClient_OnSessionExpirationUpdate_ParamsSpec.$,
        null,
        [
          sessionId,
          newExpiryTimeSec
        ],
        false);
  }
}

/**
 * An object which receives request messages for the ContentDecryptionModuleClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ContentDecryptionModuleClientReceiver {
  /**
   * @param {!ContentDecryptionModuleClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ContentDecryptionModuleClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ContentDecryptionModuleClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ContentDecryptionModuleClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ContentDecryptionModuleClient_OnSessionMessage_ParamsSpec.$,
        null,
        impl.onSessionMessage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        ContentDecryptionModuleClient_OnSessionClosed_ParamsSpec.$,
        null,
        impl.onSessionClosed.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        ContentDecryptionModuleClient_OnSessionKeysChange_ParamsSpec.$,
        null,
        impl.onSessionKeysChange.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        ContentDecryptionModuleClient_OnSessionExpirationUpdate_ParamsSpec.$,
        null,
        impl.onSessionExpirationUpdate.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class ContentDecryptionModuleClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.ContentDecryptionModuleClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ContentDecryptionModuleClientRemote}
   */
  static getRemote() {
    let remote = new ContentDecryptionModuleClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the ContentDecryptionModuleClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ContentDecryptionModuleClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ContentDecryptionModuleClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ContentDecryptionModuleClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onSessionMessage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ContentDecryptionModuleClient_OnSessionMessage_ParamsSpec.$,
        null,
        this.onSessionMessage.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onSessionClosed =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        ContentDecryptionModuleClient_OnSessionClosed_ParamsSpec.$,
        null,
        this.onSessionClosed.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onSessionKeysChange =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        ContentDecryptionModuleClient_OnSessionKeysChange_ParamsSpec.$,
        null,
        this.onSessionKeysChange.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onSessionExpirationUpdate =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        ContentDecryptionModuleClient_OnSessionExpirationUpdate_ParamsSpec.$,
        null,
        this.onSessionExpirationUpdate.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class CdmFactoryPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media.mojom.CdmFactory', scope);
  }
}

/** @interface */
export class CdmFactoryInterface {
  
  /**
   * @param { !CdmConfig } cdmConfig
   * @return {!Promise<{
        cdm: ?ContentDecryptionModuleRemote,
        cdmContext: ?CdmContext,
        status: !media_mojom_CreateCdmStatus,
   *  }>}
   */

  createCdm(cdmConfig) {}
}

/**
 * @implements { CdmFactoryInterface }
 */
export class CdmFactoryRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!CdmFactoryPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          CdmFactoryPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!CdmFactoryPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !CdmConfig } cdmConfig
   * @return {!Promise<{
        cdm: ?ContentDecryptionModuleRemote,
        cdmContext: ?CdmContext,
        status: !media_mojom_CreateCdmStatus,
   *  }>}
   */

  createCdm(
      cdmConfig) {
    return this.proxy.sendMessage(
        0,
        CdmFactory_CreateCdm_ParamsSpec.$,
        CdmFactory_CreateCdm_ResponseParamsSpec.$,
        [
          cdmConfig
        ],
        false);
  }
}

/**
 * An object which receives request messages for the CdmFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class CdmFactoryReceiver {
  /**
   * @param {!CdmFactoryInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!CdmFactoryRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        CdmFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!CdmFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        CdmFactory_CreateCdm_ParamsSpec.$,
        CdmFactory_CreateCdm_ResponseParamsSpec.$,
        impl.createCdm.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class CdmFactory {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.CdmFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!CdmFactoryRemote}
   */
  static getRemote() {
    let remote = new CdmFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the CdmFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class CdmFactoryCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      CdmFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!CdmFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createCdm =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        CdmFactory_CreateCdm_ParamsSpec.$,
        CdmFactory_CreateCdm_ResponseParamsSpec.$,
        this.createCdm.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CdmConfigSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CdmPromiseResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CdmKeyInformationSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CdmContextSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ContentDecryptionModule_SetClient_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ContentDecryptionModule_SetServerCertificate_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ContentDecryptionModule_SetServerCertificate_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ContentDecryptionModule_GetStatusForPolicy_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ContentDecryptionModule_GetStatusForPolicy_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ContentDecryptionModule_CreateSessionAndGenerateRequest_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ContentDecryptionModule_CreateSessionAndGenerateRequest_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ContentDecryptionModule_LoadSession_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ContentDecryptionModule_LoadSession_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ContentDecryptionModule_UpdateSession_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ContentDecryptionModule_UpdateSession_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ContentDecryptionModule_CloseSession_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ContentDecryptionModule_CloseSession_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ContentDecryptionModule_RemoveSession_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ContentDecryptionModule_RemoveSession_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ContentDecryptionModuleClient_OnSessionMessage_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ContentDecryptionModuleClient_OnSessionClosed_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ContentDecryptionModuleClient_OnSessionKeysChange_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ContentDecryptionModuleClient_OnSessionExpirationUpdate_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CdmFactory_CreateCdm_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CdmFactory_CreateCdm_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    CdmConfigSpec.$,
    'CdmConfig',
    [
      mojo.internal.StructField(
        'keySystem', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'allowDistinctiveIdentifier', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'allowPersistentState', 8,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'useHwSecureCodecs', 8,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class CdmConfig {
  constructor() {
    /** @type { !string } */
    this.keySystem;
    /** @type { !boolean } */
    this.allowDistinctiveIdentifier;
    /** @type { !boolean } */
    this.allowPersistentState;
    /** @type { !boolean } */
    this.useHwSecureCodecs;
  }
}


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const CdmPromiseResult_ExceptionSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const CdmPromiseResult_Exception = {
  
};


mojo.internal.Struct(
    CdmPromiseResultSpec.$,
    'CdmPromiseResult',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'exception', 4,
        0,
        CdmPromiseResult_ExceptionSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'systemCode', 8,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'errorMessage', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class CdmPromiseResult {
  constructor() {
    /** @type { !boolean } */
    this.success;
    /** @type { !CdmPromiseResult_Exception } */
    this.exception;
    /** @type { !number } */
    this.systemCode;
    /** @type { !string } */
    this.errorMessage;
  }
}



mojo.internal.Struct(
    CdmKeyInformationSpec.$,
    'CdmKeyInformation',
    [
      mojo.internal.StructField(
        'keyId', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'status', 8,
        0,
        CdmKeyStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'systemCode', 12,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class CdmKeyInformation {
  constructor() {
    /** @type { !Array<!number> } */
    this.keyId;
    /** @type { !CdmKeyStatus } */
    this.status;
    /** @type { !number } */
    this.systemCode;
  }
}



mojo.internal.Struct(
    CdmContextSpec.$,
    'CdmContext',
    [
      mojo.internal.StructField(
        'cdmId', 0,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'decryptor', 8,
        0,
        mojo.internal.InterfaceProxy(media_mojom_DecryptorRemote),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class CdmContext {
  constructor() {
    /** @type { !mojoBase_mojom_UnguessableToken } */
    this.cdmId;
    /** @type { (media_mojom_DecryptorRemote|undefined) } */
    this.decryptor;
  }
}



mojo.internal.Struct(
    ContentDecryptionModule_SetClient_ParamsSpec.$,
    'ContentDecryptionModule_SetClient_Params',
    [
      mojo.internal.StructField(
        'client', 0,
        0,
        mojo.internal.AssociatedInterfaceProxy(ContentDecryptionModuleClientRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ContentDecryptionModule_SetClient_Params {
  constructor() {
    /** @type { !Object } */
    this.client;
  }
}



mojo.internal.Struct(
    ContentDecryptionModule_SetServerCertificate_ParamsSpec.$,
    'ContentDecryptionModule_SetServerCertificate_Params',
    [
      mojo.internal.StructField(
        'certificateData', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ContentDecryptionModule_SetServerCertificate_Params {
  constructor() {
    /** @type { !Array<!number> } */
    this.certificateData;
  }
}



mojo.internal.Struct(
    ContentDecryptionModule_SetServerCertificate_ResponseParamsSpec.$,
    'ContentDecryptionModule_SetServerCertificate_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        CdmPromiseResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ContentDecryptionModule_SetServerCertificate_ResponseParams {
  constructor() {
    /** @type { !CdmPromiseResult } */
    this.result;
  }
}



mojo.internal.Struct(
    ContentDecryptionModule_GetStatusForPolicy_ParamsSpec.$,
    'ContentDecryptionModule_GetStatusForPolicy_Params',
    [
      mojo.internal.StructField(
        'minHdcpVersion', 0,
        0,
        HdcpVersionSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ContentDecryptionModule_GetStatusForPolicy_Params {
  constructor() {
    /** @type { !HdcpVersion } */
    this.minHdcpVersion;
  }
}



mojo.internal.Struct(
    ContentDecryptionModule_GetStatusForPolicy_ResponseParamsSpec.$,
    'ContentDecryptionModule_GetStatusForPolicy_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        CdmPromiseResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'keyStatus', 8,
        0,
        CdmKeyStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class ContentDecryptionModule_GetStatusForPolicy_ResponseParams {
  constructor() {
    /** @type { !CdmPromiseResult } */
    this.result;
    /** @type { !CdmKeyStatus } */
    this.keyStatus;
  }
}



mojo.internal.Struct(
    ContentDecryptionModule_CreateSessionAndGenerateRequest_ParamsSpec.$,
    'ContentDecryptionModule_CreateSessionAndGenerateRequest_Params',
    [
      mojo.internal.StructField(
        'sessionType', 0,
        0,
        CdmSessionTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'initDataType', 4,
        0,
        EmeInitDataTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'initData', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class ContentDecryptionModule_CreateSessionAndGenerateRequest_Params {
  constructor() {
    /** @type { !CdmSessionType } */
    this.sessionType;
    /** @type { !EmeInitDataType } */
    this.initDataType;
    /** @type { !Array<!number> } */
    this.initData;
  }
}



mojo.internal.Struct(
    ContentDecryptionModule_CreateSessionAndGenerateRequest_ResponseParamsSpec.$,
    'ContentDecryptionModule_CreateSessionAndGenerateRequest_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        CdmPromiseResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sessionId', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class ContentDecryptionModule_CreateSessionAndGenerateRequest_ResponseParams {
  constructor() {
    /** @type { !CdmPromiseResult } */
    this.result;
    /** @type { !string } */
    this.sessionId;
  }
}



mojo.internal.Struct(
    ContentDecryptionModule_LoadSession_ParamsSpec.$,
    'ContentDecryptionModule_LoadSession_Params',
    [
      mojo.internal.StructField(
        'sessionType', 0,
        0,
        CdmSessionTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sessionId', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class ContentDecryptionModule_LoadSession_Params {
  constructor() {
    /** @type { !CdmSessionType } */
    this.sessionType;
    /** @type { !string } */
    this.sessionId;
  }
}



mojo.internal.Struct(
    ContentDecryptionModule_LoadSession_ResponseParamsSpec.$,
    'ContentDecryptionModule_LoadSession_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        CdmPromiseResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sessionId', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class ContentDecryptionModule_LoadSession_ResponseParams {
  constructor() {
    /** @type { !CdmPromiseResult } */
    this.result;
    /** @type { !string } */
    this.sessionId;
  }
}



mojo.internal.Struct(
    ContentDecryptionModule_UpdateSession_ParamsSpec.$,
    'ContentDecryptionModule_UpdateSession_Params',
    [
      mojo.internal.StructField(
        'sessionId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'response', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class ContentDecryptionModule_UpdateSession_Params {
  constructor() {
    /** @type { !string } */
    this.sessionId;
    /** @type { !Array<!number> } */
    this.response;
  }
}



mojo.internal.Struct(
    ContentDecryptionModule_UpdateSession_ResponseParamsSpec.$,
    'ContentDecryptionModule_UpdateSession_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        CdmPromiseResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ContentDecryptionModule_UpdateSession_ResponseParams {
  constructor() {
    /** @type { !CdmPromiseResult } */
    this.result;
  }
}



mojo.internal.Struct(
    ContentDecryptionModule_CloseSession_ParamsSpec.$,
    'ContentDecryptionModule_CloseSession_Params',
    [
      mojo.internal.StructField(
        'sessionId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ContentDecryptionModule_CloseSession_Params {
  constructor() {
    /** @type { !string } */
    this.sessionId;
  }
}



mojo.internal.Struct(
    ContentDecryptionModule_CloseSession_ResponseParamsSpec.$,
    'ContentDecryptionModule_CloseSession_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        CdmPromiseResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ContentDecryptionModule_CloseSession_ResponseParams {
  constructor() {
    /** @type { !CdmPromiseResult } */
    this.result;
  }
}



mojo.internal.Struct(
    ContentDecryptionModule_RemoveSession_ParamsSpec.$,
    'ContentDecryptionModule_RemoveSession_Params',
    [
      mojo.internal.StructField(
        'sessionId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ContentDecryptionModule_RemoveSession_Params {
  constructor() {
    /** @type { !string } */
    this.sessionId;
  }
}



mojo.internal.Struct(
    ContentDecryptionModule_RemoveSession_ResponseParamsSpec.$,
    'ContentDecryptionModule_RemoveSession_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        CdmPromiseResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ContentDecryptionModule_RemoveSession_ResponseParams {
  constructor() {
    /** @type { !CdmPromiseResult } */
    this.result;
  }
}



mojo.internal.Struct(
    ContentDecryptionModuleClient_OnSessionMessage_ParamsSpec.$,
    'ContentDecryptionModuleClient_OnSessionMessage_Params',
    [
      mojo.internal.StructField(
        'sessionId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'messageType', 8,
        0,
        CdmMessageTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'message', 16,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class ContentDecryptionModuleClient_OnSessionMessage_Params {
  constructor() {
    /** @type { !string } */
    this.sessionId;
    /** @type { !CdmMessageType } */
    this.messageType;
    /** @type { !Array<!number> } */
    this.message;
  }
}



mojo.internal.Struct(
    ContentDecryptionModuleClient_OnSessionClosed_ParamsSpec.$,
    'ContentDecryptionModuleClient_OnSessionClosed_Params',
    [
      mojo.internal.StructField(
        'sessionId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'reason', 8,
        0,
        media_mojom_CdmSessionClosedReasonSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class ContentDecryptionModuleClient_OnSessionClosed_Params {
  constructor() {
    /** @type { !string } */
    this.sessionId;
    /** @type { !media_mojom_CdmSessionClosedReason } */
    this.reason;
  }
}



mojo.internal.Struct(
    ContentDecryptionModuleClient_OnSessionKeysChange_ParamsSpec.$,
    'ContentDecryptionModuleClient_OnSessionKeysChange_Params',
    [
      mojo.internal.StructField(
        'sessionId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hasAdditionalUsableKey', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'keysInfo', 16,
        0,
        mojo.internal.Array(CdmKeyInformationSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class ContentDecryptionModuleClient_OnSessionKeysChange_Params {
  constructor() {
    /** @type { !string } */
    this.sessionId;
    /** @type { !boolean } */
    this.hasAdditionalUsableKey;
    /** @type { !Array<!CdmKeyInformation> } */
    this.keysInfo;
  }
}



mojo.internal.Struct(
    ContentDecryptionModuleClient_OnSessionExpirationUpdate_ParamsSpec.$,
    'ContentDecryptionModuleClient_OnSessionExpirationUpdate_Params',
    [
      mojo.internal.StructField(
        'sessionId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'newExpiryTimeSec', 8,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class ContentDecryptionModuleClient_OnSessionExpirationUpdate_Params {
  constructor() {
    /** @type { !string } */
    this.sessionId;
    /** @type { !number } */
    this.newExpiryTimeSec;
  }
}



mojo.internal.Struct(
    CdmFactory_CreateCdm_ParamsSpec.$,
    'CdmFactory_CreateCdm_Params',
    [
      mojo.internal.StructField(
        'cdmConfig', 0,
        0,
        CdmConfigSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class CdmFactory_CreateCdm_Params {
  constructor() {
    /** @type { !CdmConfig } */
    this.cdmConfig;
  }
}



mojo.internal.Struct(
    CdmFactory_CreateCdm_ResponseParamsSpec.$,
    'CdmFactory_CreateCdm_ResponseParams',
    [
      mojo.internal.StructField(
        'cdm', 0,
        0,
        mojo.internal.InterfaceProxy(ContentDecryptionModuleRemote),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'cdmContext', 8,
        0,
        CdmContextSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'status', 16,
        0,
        media_mojom_CreateCdmStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class CdmFactory_CreateCdm_ResponseParams {
  constructor() {
    /** @type { (ContentDecryptionModuleRemote|undefined) } */
    this.cdm;
    /** @type { (CdmContext|undefined) } */
    this.cdmContext;
    /** @type { !media_mojom_CreateCdmStatus } */
    this.status;
  }
}

