// media/mojo/mojom/frame_interface_factory.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../mojo/public/js/bindings.js';

import {
  GenericPendingReceiver as mojoBase_mojom_GenericPendingReceiver,
  GenericPendingReceiverSpec as mojoBase_mojom_GenericPendingReceiverSpec
} from '../../../mojo/public/mojom/base/generic_pending_receiver.mojom.m.js';

import {
  Origin as url_mojom_Origin,
  OriginSpec as url_mojom_OriginSpec
} from '../../../url/mojom/origin.mojom.m.js';

import {
  CdmStorageRemote as media_mojom_CdmStorageRemote,
  CdmStoragePendingReceiver as media_mojom_CdmStoragePendingReceiver
} from './cdm_storage.mojom.m.js';

import {
  ProvisionFetcherRemote as media_mojom_ProvisionFetcherRemote,
  ProvisionFetcherPendingReceiver as media_mojom_ProvisionFetcherPendingReceiver
} from './provision_fetcher.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class FrameInterfaceFactoryPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media.mojom.FrameInterfaceFactory', scope);
  }
}

/** @interface */
export class FrameInterfaceFactoryInterface {
  
  /**
   * @param { !media_mojom_ProvisionFetcherPendingReceiver } provisionFetcher
   */

  createProvisionFetcher(provisionFetcher) {}
  
  /**
   * @param { !media_mojom_CdmStoragePendingReceiver } cdmStorage
   */

  createCdmStorage(cdmStorage) {}
  
  /**
   * @return {!Promise<{
        cdmOrigin: !url_mojom_Origin,
   *  }>}
   */

  getCdmOrigin() {}
  
  /**
   * @param { !mojoBase_mojom_GenericPendingReceiver } receiver
   */

  bindEmbedderReceiver(receiver) {}
}

/**
 * @implements { FrameInterfaceFactoryInterface }
 */
export class FrameInterfaceFactoryRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!FrameInterfaceFactoryPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          FrameInterfaceFactoryPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!FrameInterfaceFactoryPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !media_mojom_ProvisionFetcherPendingReceiver } provisionFetcher
   */

  createProvisionFetcher(
      provisionFetcher) {
    this.proxy.sendMessage(
        0,
        FrameInterfaceFactory_CreateProvisionFetcher_ParamsSpec.$,
        null,
        [
          provisionFetcher
        ],
        false);
  }

  
  /**
   * @param { !media_mojom_CdmStoragePendingReceiver } cdmStorage
   */

  createCdmStorage(
      cdmStorage) {
    this.proxy.sendMessage(
        1,
        FrameInterfaceFactory_CreateCdmStorage_ParamsSpec.$,
        null,
        [
          cdmStorage
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        cdmOrigin: !url_mojom_Origin,
   *  }>}
   */

  getCdmOrigin() {
    return this.proxy.sendMessage(
        2,
        FrameInterfaceFactory_GetCdmOrigin_ParamsSpec.$,
        FrameInterfaceFactory_GetCdmOrigin_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_GenericPendingReceiver } receiver
   */

  bindEmbedderReceiver(
      receiver) {
    this.proxy.sendMessage(
        3,
        FrameInterfaceFactory_BindEmbedderReceiver_ParamsSpec.$,
        null,
        [
          receiver
        ],
        false);
  }
}

/**
 * An object which receives request messages for the FrameInterfaceFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class FrameInterfaceFactoryReceiver {
  /**
   * @param {!FrameInterfaceFactoryInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!FrameInterfaceFactoryRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        FrameInterfaceFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!FrameInterfaceFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        FrameInterfaceFactory_CreateProvisionFetcher_ParamsSpec.$,
        null,
        impl.createProvisionFetcher.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        FrameInterfaceFactory_CreateCdmStorage_ParamsSpec.$,
        null,
        impl.createCdmStorage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        FrameInterfaceFactory_GetCdmOrigin_ParamsSpec.$,
        FrameInterfaceFactory_GetCdmOrigin_ResponseParamsSpec.$,
        impl.getCdmOrigin.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        FrameInterfaceFactory_BindEmbedderReceiver_ParamsSpec.$,
        null,
        impl.bindEmbedderReceiver.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class FrameInterfaceFactory {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.FrameInterfaceFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!FrameInterfaceFactoryRemote}
   */
  static getRemote() {
    let remote = new FrameInterfaceFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the FrameInterfaceFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class FrameInterfaceFactoryCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      FrameInterfaceFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!FrameInterfaceFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createProvisionFetcher =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        FrameInterfaceFactory_CreateProvisionFetcher_ParamsSpec.$,
        null,
        this.createProvisionFetcher.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createCdmStorage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        FrameInterfaceFactory_CreateCdmStorage_ParamsSpec.$,
        null,
        this.createCdmStorage.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getCdmOrigin =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        FrameInterfaceFactory_GetCdmOrigin_ParamsSpec.$,
        FrameInterfaceFactory_GetCdmOrigin_ResponseParamsSpec.$,
        this.getCdmOrigin.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.bindEmbedderReceiver =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        FrameInterfaceFactory_BindEmbedderReceiver_ParamsSpec.$,
        null,
        this.bindEmbedderReceiver.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FrameInterfaceFactory_CreateProvisionFetcher_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FrameInterfaceFactory_CreateCdmStorage_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FrameInterfaceFactory_GetCdmOrigin_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FrameInterfaceFactory_GetCdmOrigin_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FrameInterfaceFactory_BindEmbedderReceiver_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    FrameInterfaceFactory_CreateProvisionFetcher_ParamsSpec.$,
    'FrameInterfaceFactory_CreateProvisionFetcher_Params',
    [
      mojo.internal.StructField(
        'provisionFetcher', 0,
        0,
        mojo.internal.InterfaceRequest(media_mojom_ProvisionFetcherPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FrameInterfaceFactory_CreateProvisionFetcher_Params {
  constructor() {
    /** @type { !media_mojom_ProvisionFetcherPendingReceiver } */
    this.provisionFetcher;
  }
}



mojo.internal.Struct(
    FrameInterfaceFactory_CreateCdmStorage_ParamsSpec.$,
    'FrameInterfaceFactory_CreateCdmStorage_Params',
    [
      mojo.internal.StructField(
        'cdmStorage', 0,
        0,
        mojo.internal.InterfaceRequest(media_mojom_CdmStoragePendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FrameInterfaceFactory_CreateCdmStorage_Params {
  constructor() {
    /** @type { !media_mojom_CdmStoragePendingReceiver } */
    this.cdmStorage;
  }
}



mojo.internal.Struct(
    FrameInterfaceFactory_GetCdmOrigin_ParamsSpec.$,
    'FrameInterfaceFactory_GetCdmOrigin_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class FrameInterfaceFactory_GetCdmOrigin_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    FrameInterfaceFactory_GetCdmOrigin_ResponseParamsSpec.$,
    'FrameInterfaceFactory_GetCdmOrigin_ResponseParams',
    [
      mojo.internal.StructField(
        'cdmOrigin', 0,
        0,
        url_mojom_OriginSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FrameInterfaceFactory_GetCdmOrigin_ResponseParams {
  constructor() {
    /** @type { !url_mojom_Origin } */
    this.cdmOrigin;
  }
}



mojo.internal.Struct(
    FrameInterfaceFactory_BindEmbedderReceiver_ParamsSpec.$,
    'FrameInterfaceFactory_BindEmbedderReceiver_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojoBase_mojom_GenericPendingReceiverSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FrameInterfaceFactory_BindEmbedderReceiver_Params {
  constructor() {
    /** @type { !mojoBase_mojom_GenericPendingReceiver } */
    this.receiver;
  }
}

