// media/mojo/mojom/renderer_extensions.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../mojo/public/js/bindings.js';

import {
  MediaStatusState as media_mojom_MediaStatusState,
  MediaStatusStateSpec as media_mojom_MediaStatusStateSpec
} from './media_types.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class FlingingRendererClientExtensionPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media.mojom.FlingingRendererClientExtension', scope);
  }
}

/** @interface */
export class FlingingRendererClientExtensionInterface {
  
  /**
   * @param { !media_mojom_MediaStatusState } state
   */

  onRemotePlayStateChange(state) {}
}

/**
 * @implements { FlingingRendererClientExtensionInterface }
 */
export class FlingingRendererClientExtensionRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!FlingingRendererClientExtensionPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          FlingingRendererClientExtensionPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!FlingingRendererClientExtensionPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !media_mojom_MediaStatusState } state
   */

  onRemotePlayStateChange(
      state) {
    this.proxy.sendMessage(
        0,
        FlingingRendererClientExtension_OnRemotePlayStateChange_ParamsSpec.$,
        null,
        [
          state
        ],
        false);
  }
}

/**
 * An object which receives request messages for the FlingingRendererClientExtension
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class FlingingRendererClientExtensionReceiver {
  /**
   * @param {!FlingingRendererClientExtensionInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!FlingingRendererClientExtensionRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        FlingingRendererClientExtensionRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!FlingingRendererClientExtensionRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        FlingingRendererClientExtension_OnRemotePlayStateChange_ParamsSpec.$,
        null,
        impl.onRemotePlayStateChange.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class FlingingRendererClientExtension {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.FlingingRendererClientExtension";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!FlingingRendererClientExtensionRemote}
   */
  static getRemote() {
    let remote = new FlingingRendererClientExtensionRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the FlingingRendererClientExtension
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class FlingingRendererClientExtensionCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      FlingingRendererClientExtensionRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!FlingingRendererClientExtensionRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onRemotePlayStateChange =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        FlingingRendererClientExtension_OnRemotePlayStateChange_ParamsSpec.$,
        null,
        this.onRemotePlayStateChange.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class MediaFoundationRendererObserverPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media.mojom.MediaFoundationRendererObserver', scope);
  }
}

/** @interface */
export class MediaFoundationRendererObserverInterface {
}

/**
 * @implements { MediaFoundationRendererObserverInterface }
 */
export class MediaFoundationRendererObserverRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!MediaFoundationRendererObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          MediaFoundationRendererObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!MediaFoundationRendererObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }
}

/**
 * An object which receives request messages for the MediaFoundationRendererObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class MediaFoundationRendererObserverReceiver {
  /**
   * @param {!MediaFoundationRendererObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!MediaFoundationRendererObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        MediaFoundationRendererObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!MediaFoundationRendererObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class MediaFoundationRendererObserver {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.MediaFoundationRendererObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!MediaFoundationRendererObserverRemote}
   */
  static getRemote() {
    let remote = new MediaFoundationRendererObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the MediaFoundationRendererObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class MediaFoundationRendererObserverCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      MediaFoundationRendererObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!MediaFoundationRendererObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class MediaFoundationRendererNotifierPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media.mojom.MediaFoundationRendererNotifier', scope);
  }
}

/** @interface */
export class MediaFoundationRendererNotifierInterface {
  
  /**
   * @param { !MediaFoundationRendererObserverPendingReceiver } observer
   */

  mediaFoundationRendererCreated(observer) {}
}

/**
 * @implements { MediaFoundationRendererNotifierInterface }
 */
export class MediaFoundationRendererNotifierRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!MediaFoundationRendererNotifierPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          MediaFoundationRendererNotifierPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!MediaFoundationRendererNotifierPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !MediaFoundationRendererObserverPendingReceiver } observer
   */

  mediaFoundationRendererCreated(
      observer) {
    this.proxy.sendMessage(
        0,
        MediaFoundationRendererNotifier_MediaFoundationRendererCreated_ParamsSpec.$,
        null,
        [
          observer
        ],
        false);
  }
}

/**
 * An object which receives request messages for the MediaFoundationRendererNotifier
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class MediaFoundationRendererNotifierReceiver {
  /**
   * @param {!MediaFoundationRendererNotifierInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!MediaFoundationRendererNotifierRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        MediaFoundationRendererNotifierRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!MediaFoundationRendererNotifierRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        MediaFoundationRendererNotifier_MediaFoundationRendererCreated_ParamsSpec.$,
        null,
        impl.mediaFoundationRendererCreated.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class MediaFoundationRendererNotifier {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.MediaFoundationRendererNotifier";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!MediaFoundationRendererNotifierRemote}
   */
  static getRemote() {
    let remote = new MediaFoundationRendererNotifierRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the MediaFoundationRendererNotifier
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class MediaFoundationRendererNotifierCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      MediaFoundationRendererNotifierRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!MediaFoundationRendererNotifierRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.mediaFoundationRendererCreated =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        MediaFoundationRendererNotifier_MediaFoundationRendererCreated_ParamsSpec.$,
        null,
        this.mediaFoundationRendererCreated.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FlingingRendererClientExtension_OnRemotePlayStateChange_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaFoundationRendererNotifier_MediaFoundationRendererCreated_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    FlingingRendererClientExtension_OnRemotePlayStateChange_ParamsSpec.$,
    'FlingingRendererClientExtension_OnRemotePlayStateChange_Params',
    [
      mojo.internal.StructField(
        'state', 0,
        0,
        media_mojom_MediaStatusStateSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FlingingRendererClientExtension_OnRemotePlayStateChange_Params {
  constructor() {
    /** @type { !media_mojom_MediaStatusState } */
    this.state;
  }
}



mojo.internal.Struct(
    MediaFoundationRendererNotifier_MediaFoundationRendererCreated_ParamsSpec.$,
    'MediaFoundationRendererNotifier_MediaFoundationRendererCreated_Params',
    [
      mojo.internal.StructField(
        'observer', 0,
        0,
        mojo.internal.InterfaceRequest(MediaFoundationRendererObserverPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaFoundationRendererNotifier_MediaFoundationRendererCreated_Params {
  constructor() {
    /** @type { !MediaFoundationRendererObserverPendingReceiver } */
    this.observer;
  }
}

