// media/mojo/mojom/speech_recognition_service.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('media.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
media.mojom.AudioSourceSpeechRecognitionContextPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        media.mojom.AudioSourceSpeechRecognitionContext.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { media.mojom.AudioSourceSpeechRecognitionContextInterface }
 */
media.mojom.AudioSourceSpeechRecognitionContextRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!media.mojom.AudioSourceSpeechRecognitionContextPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          media.mojom.AudioSourceSpeechRecognitionContextPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!media.mojom.AudioSourceSpeechRecognitionContextPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !media.mojom.AudioSourceFetcherPendingReceiver } fetcherReceiver
   * @param { !media.mojom.SpeechRecognitionRecognizerClientRemote } client
   * @param { !media.mojom.SpeechRecognitionOptions } options
   * @return {!Promise<{
        isMultichannelSupported: !boolean,
   *  }>}
   */

  bindAudioSourceFetcher(
      fetcherReceiver,
      client,
      options) {
    return this.proxy.sendMessage(
        0,
        media.mojom.AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_ParamsSpec.$,
        media.mojom.AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_ResponseParamsSpec.$,
        [
          fetcherReceiver,
          client,
          options
        ],
        false);
  }
};

/**
 * An object which receives request messages for the AudioSourceSpeechRecognitionContext
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
media.mojom.AudioSourceSpeechRecognitionContextReceiver = class {
  /**
   * @param {!media.mojom.AudioSourceSpeechRecognitionContextInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!media.mojom.AudioSourceSpeechRecognitionContextRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        media.mojom.AudioSourceSpeechRecognitionContextRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.AudioSourceSpeechRecognitionContextRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        media.mojom.AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_ParamsSpec.$,
        media.mojom.AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_ResponseParamsSpec.$,
        impl.bindAudioSourceFetcher.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
media.mojom.AudioSourceSpeechRecognitionContext = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.AudioSourceSpeechRecognitionContext";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!media.mojom.AudioSourceSpeechRecognitionContextRemote}
   * @export
   */
  static getRemote() {
    let remote = new media.mojom.AudioSourceSpeechRecognitionContextRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the AudioSourceSpeechRecognitionContext
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
media.mojom.AudioSourceSpeechRecognitionContextCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      media.mojom.AudioSourceSpeechRecognitionContextRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.AudioSourceSpeechRecognitionContextRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.bindAudioSourceFetcher =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        media.mojom.AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_ParamsSpec.$,
        media.mojom.AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_ResponseParamsSpec.$,
        this.bindAudioSourceFetcher.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
media.mojom.SpeechRecognitionServicePendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        media.mojom.SpeechRecognitionService.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { media.mojom.SpeechRecognitionServiceInterface }
 */
media.mojom.SpeechRecognitionServiceRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!media.mojom.SpeechRecognitionServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          media.mojom.SpeechRecognitionServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!media.mojom.SpeechRecognitionServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !media.mojom.SpeechRecognitionContextPendingReceiver } context
   */

  bindSpeechRecognitionContext(
      context) {
    this.proxy.sendMessage(
        0,
        media.mojom.SpeechRecognitionService_BindSpeechRecognitionContext_ParamsSpec.$,
        null,
        [
          context
        ],
        false);
  }

  
  /**
   * @param { !media.mojom.AudioSourceSpeechRecognitionContextPendingReceiver } context
   */

  bindAudioSourceSpeechRecognitionContext(
      context) {
    this.proxy.sendMessage(
        1,
        media.mojom.SpeechRecognitionService_BindAudioSourceSpeechRecognitionContext_ParamsSpec.$,
        null,
        [
          context
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.FilePath } binaryPath
   * @param { !Object<!string, !mojoBase.mojom.FilePath> } configPaths
   * @param { !string } primaryLanguageName
   */

  setSodaPaths(
      binaryPath,
      configPaths,
      primaryLanguageName) {
    this.proxy.sendMessage(
        2,
        media.mojom.SpeechRecognitionService_SetSodaPaths_ParamsSpec.$,
        null,
        [
          binaryPath,
          configPaths,
          primaryLanguageName
        ],
        false);
  }

  
  /**
   * @param { !boolean } maskOffensiveWords
   */

  setSodaParams(
      maskOffensiveWords) {
    this.proxy.sendMessage(
        3,
        media.mojom.SpeechRecognitionService_SetSodaParams_ParamsSpec.$,
        null,
        [
          maskOffensiveWords
        ],
        false);
  }

  
  /**
   * @param { !Object<!string, !mojoBase.mojom.FilePath> } configPaths
   */

  setSodaConfigPaths(
      configPaths) {
    this.proxy.sendMessage(
        4,
        media.mojom.SpeechRecognitionService_SetSodaConfigPaths_ParamsSpec.$,
        null,
        [
          configPaths
        ],
        false);
  }
};

/**
 * An object which receives request messages for the SpeechRecognitionService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
media.mojom.SpeechRecognitionServiceReceiver = class {
  /**
   * @param {!media.mojom.SpeechRecognitionServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!media.mojom.SpeechRecognitionServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        media.mojom.SpeechRecognitionServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.SpeechRecognitionServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        media.mojom.SpeechRecognitionService_BindSpeechRecognitionContext_ParamsSpec.$,
        null,
        impl.bindSpeechRecognitionContext.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        media.mojom.SpeechRecognitionService_BindAudioSourceSpeechRecognitionContext_ParamsSpec.$,
        null,
        impl.bindAudioSourceSpeechRecognitionContext.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        media.mojom.SpeechRecognitionService_SetSodaPaths_ParamsSpec.$,
        null,
        impl.setSodaPaths.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        media.mojom.SpeechRecognitionService_SetSodaParams_ParamsSpec.$,
        null,
        impl.setSodaParams.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        media.mojom.SpeechRecognitionService_SetSodaConfigPaths_ParamsSpec.$,
        null,
        impl.setSodaConfigPaths.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
media.mojom.SpeechRecognitionService = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.SpeechRecognitionService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!media.mojom.SpeechRecognitionServiceRemote}
   * @export
   */
  static getRemote() {
    let remote = new media.mojom.SpeechRecognitionServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the SpeechRecognitionService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
media.mojom.SpeechRecognitionServiceCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      media.mojom.SpeechRecognitionServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.SpeechRecognitionServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.bindSpeechRecognitionContext =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        media.mojom.SpeechRecognitionService_BindSpeechRecognitionContext_ParamsSpec.$,
        null,
        this.bindSpeechRecognitionContext.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.bindAudioSourceSpeechRecognitionContext =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        media.mojom.SpeechRecognitionService_BindAudioSourceSpeechRecognitionContext_ParamsSpec.$,
        null,
        this.bindAudioSourceSpeechRecognitionContext.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setSodaPaths =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        media.mojom.SpeechRecognitionService_SetSodaPaths_ParamsSpec.$,
        null,
        this.setSodaPaths.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setSodaParams =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        media.mojom.SpeechRecognitionService_SetSodaParams_ParamsSpec.$,
        null,
        this.setSodaParams.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setSodaConfigPaths =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        media.mojom.SpeechRecognitionService_SetSodaConfigPaths_ParamsSpec.$,
        null,
        this.setSodaConfigPaths.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
media.mojom.AudioSourceFetcherPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        media.mojom.AudioSourceFetcher.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { media.mojom.AudioSourceFetcherInterface }
 */
media.mojom.AudioSourceFetcherRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!media.mojom.AudioSourceFetcherPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          media.mojom.AudioSourceFetcherPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!media.mojom.AudioSourceFetcherPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !media.mojom.AudioStreamFactoryRemote } factory
   * @param { !string } deviceId
   * @param { !media.mojom.AudioParameters } audioParameters
   */

  start(
      factory,
      deviceId,
      audioParameters) {
    this.proxy.sendMessage(
        0,
        media.mojom.AudioSourceFetcher_Start_ParamsSpec.$,
        null,
        [
          factory,
          deviceId,
          audioParameters
        ],
        false);
  }

  
  /**
   */

  stop() {
    this.proxy.sendMessage(
        1,
        media.mojom.AudioSourceFetcher_Stop_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the AudioSourceFetcher
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
media.mojom.AudioSourceFetcherReceiver = class {
  /**
   * @param {!media.mojom.AudioSourceFetcherInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!media.mojom.AudioSourceFetcherRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        media.mojom.AudioSourceFetcherRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.AudioSourceFetcherRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        media.mojom.AudioSourceFetcher_Start_ParamsSpec.$,
        null,
        impl.start.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        media.mojom.AudioSourceFetcher_Stop_ParamsSpec.$,
        null,
        impl.stop.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
media.mojom.AudioSourceFetcher = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.AudioSourceFetcher";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!media.mojom.AudioSourceFetcherRemote}
   * @export
   */
  static getRemote() {
    let remote = new media.mojom.AudioSourceFetcherRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the AudioSourceFetcher
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
media.mojom.AudioSourceFetcherCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      media.mojom.AudioSourceFetcherRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.AudioSourceFetcherRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.start =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        media.mojom.AudioSourceFetcher_Start_ParamsSpec.$,
        null,
        this.start.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.stop =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        media.mojom.AudioSourceFetcher_Stop_ParamsSpec.$,
        null,
        this.stop.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.SpeechRecognitionService_BindSpeechRecognitionContext_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.SpeechRecognitionService_BindAudioSourceSpeechRecognitionContext_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.SpeechRecognitionService_SetSodaPaths_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.SpeechRecognitionService_SetSodaParams_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.SpeechRecognitionService_SetSodaConfigPaths_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.AudioSourceFetcher_Start_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.AudioSourceFetcher_Stop_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    media.mojom.AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_ParamsSpec.$,
    'AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_Params',
    [
      mojo.internal.StructField(
        'fetcherReceiver', 0,
        0,
        mojo.internal.InterfaceRequest(media.mojom.AudioSourceFetcherPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'client', 4,
        0,
        mojo.internal.InterfaceProxy(media.mojom.SpeechRecognitionRecognizerClientRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'options', 16,
        0,
        media.mojom.SpeechRecognitionOptionsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
media.mojom.AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_Params = class {
  constructor() {
    /** @export { !media.mojom.AudioSourceFetcherPendingReceiver } */
    this.fetcherReceiver;
    /** @export { !media.mojom.SpeechRecognitionRecognizerClientRemote } */
    this.client;
    /** @export { !media.mojom.SpeechRecognitionOptions } */
    this.options;
  }
};



mojo.internal.Struct(
    media.mojom.AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_ResponseParamsSpec.$,
    'AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_ResponseParams',
    [
      mojo.internal.StructField(
        'isMultichannelSupported', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
media.mojom.AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.isMultichannelSupported;
  }
};



mojo.internal.Struct(
    media.mojom.SpeechRecognitionService_BindSpeechRecognitionContext_ParamsSpec.$,
    'SpeechRecognitionService_BindSpeechRecognitionContext_Params',
    [
      mojo.internal.StructField(
        'context', 0,
        0,
        mojo.internal.InterfaceRequest(media.mojom.SpeechRecognitionContextPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
media.mojom.SpeechRecognitionService_BindSpeechRecognitionContext_Params = class {
  constructor() {
    /** @export { !media.mojom.SpeechRecognitionContextPendingReceiver } */
    this.context;
  }
};



mojo.internal.Struct(
    media.mojom.SpeechRecognitionService_BindAudioSourceSpeechRecognitionContext_ParamsSpec.$,
    'SpeechRecognitionService_BindAudioSourceSpeechRecognitionContext_Params',
    [
      mojo.internal.StructField(
        'context', 0,
        0,
        mojo.internal.InterfaceRequest(media.mojom.AudioSourceSpeechRecognitionContextPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
media.mojom.SpeechRecognitionService_BindAudioSourceSpeechRecognitionContext_Params = class {
  constructor() {
    /** @export { !media.mojom.AudioSourceSpeechRecognitionContextPendingReceiver } */
    this.context;
  }
};



mojo.internal.Struct(
    media.mojom.SpeechRecognitionService_SetSodaPaths_ParamsSpec.$,
    'SpeechRecognitionService_SetSodaPaths_Params',
    [
      mojo.internal.StructField(
        'binaryPath', 0,
        0,
        mojoBase.mojom.FilePathSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'configPaths', 8,
        0,
        mojo.internal.Map(mojo.internal.String, mojoBase.mojom.FilePathSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'primaryLanguageName', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
media.mojom.SpeechRecognitionService_SetSodaPaths_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.FilePath } */
    this.binaryPath;
    /** @export { !Object<!string, !mojoBase.mojom.FilePath> } */
    this.configPaths;
    /** @export { !string } */
    this.primaryLanguageName;
  }
};



mojo.internal.Struct(
    media.mojom.SpeechRecognitionService_SetSodaParams_ParamsSpec.$,
    'SpeechRecognitionService_SetSodaParams_Params',
    [
      mojo.internal.StructField(
        'maskOffensiveWords', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
media.mojom.SpeechRecognitionService_SetSodaParams_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.maskOffensiveWords;
  }
};



mojo.internal.Struct(
    media.mojom.SpeechRecognitionService_SetSodaConfigPaths_ParamsSpec.$,
    'SpeechRecognitionService_SetSodaConfigPaths_Params',
    [
      mojo.internal.StructField(
        'configPaths', 0,
        0,
        mojo.internal.Map(mojo.internal.String, mojoBase.mojom.FilePathSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
media.mojom.SpeechRecognitionService_SetSodaConfigPaths_Params = class {
  constructor() {
    /** @export { !Object<!string, !mojoBase.mojom.FilePath> } */
    this.configPaths;
  }
};



mojo.internal.Struct(
    media.mojom.AudioSourceFetcher_Start_ParamsSpec.$,
    'AudioSourceFetcher_Start_Params',
    [
      mojo.internal.StructField(
        'factory', 0,
        0,
        mojo.internal.InterfaceProxy(media.mojom.AudioStreamFactoryRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'deviceId', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'audioParameters', 16,
        0,
        media.mojom.AudioParametersSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
media.mojom.AudioSourceFetcher_Start_Params = class {
  constructor() {
    /** @export { !media.mojom.AudioStreamFactoryRemote } */
    this.factory;
    /** @export { !string } */
    this.deviceId;
    /** @export { !media.mojom.AudioParameters } */
    this.audioParameters;
  }
};



mojo.internal.Struct(
    media.mojom.AudioSourceFetcher_Stop_ParamsSpec.$,
    'AudioSourceFetcher_Stop_Params',
    [
    ],
    [[0, 8],]);





/** @record */
media.mojom.AudioSourceFetcher_Stop_Params = class {
  constructor() {
  }
};

