// media/mojo/mojom/video_decode_perf_history.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../mojo/public/js/bindings.js';

import {
  PredictionFeatures as media_mojom_PredictionFeatures,
  PredictionFeaturesSpec as media_mojom_PredictionFeaturesSpec
} from './media_types.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class VideoDecodePerfHistoryPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media.mojom.VideoDecodePerfHistory', scope);
  }
}

/** @interface */
export class VideoDecodePerfHistoryInterface {
  
  /**
   * @param { !media_mojom_PredictionFeatures } features
   * @return {!Promise<{
        isSmooth: !boolean,
        isPowerEfficient: !boolean,
   *  }>}
   */

  getPerfInfo(features) {}
}

/**
 * @implements { VideoDecodePerfHistoryInterface }
 */
export class VideoDecodePerfHistoryRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!VideoDecodePerfHistoryPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          VideoDecodePerfHistoryPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!VideoDecodePerfHistoryPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !media_mojom_PredictionFeatures } features
   * @return {!Promise<{
        isSmooth: !boolean,
        isPowerEfficient: !boolean,
   *  }>}
   */

  getPerfInfo(
      features) {
    return this.proxy.sendMessage(
        0,
        VideoDecodePerfHistory_GetPerfInfo_ParamsSpec.$,
        VideoDecodePerfHistory_GetPerfInfo_ResponseParamsSpec.$,
        [
          features
        ],
        false);
  }
}

/**
 * An object which receives request messages for the VideoDecodePerfHistory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class VideoDecodePerfHistoryReceiver {
  /**
   * @param {!VideoDecodePerfHistoryInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!VideoDecodePerfHistoryRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        VideoDecodePerfHistoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!VideoDecodePerfHistoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        VideoDecodePerfHistory_GetPerfInfo_ParamsSpec.$,
        VideoDecodePerfHistory_GetPerfInfo_ResponseParamsSpec.$,
        impl.getPerfInfo.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class VideoDecodePerfHistory {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.VideoDecodePerfHistory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!VideoDecodePerfHistoryRemote}
   */
  static getRemote() {
    let remote = new VideoDecodePerfHistoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the VideoDecodePerfHistory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class VideoDecodePerfHistoryCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      VideoDecodePerfHistoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!VideoDecodePerfHistoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getPerfInfo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        VideoDecodePerfHistory_GetPerfInfo_ParamsSpec.$,
        VideoDecodePerfHistory_GetPerfInfo_ResponseParamsSpec.$,
        this.getPerfInfo.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VideoDecodePerfHistory_GetPerfInfo_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VideoDecodePerfHistory_GetPerfInfo_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    VideoDecodePerfHistory_GetPerfInfo_ParamsSpec.$,
    'VideoDecodePerfHistory_GetPerfInfo_Params',
    [
      mojo.internal.StructField(
        'features', 0,
        0,
        media_mojom_PredictionFeaturesSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class VideoDecodePerfHistory_GetPerfInfo_Params {
  constructor() {
    /** @type { !media_mojom_PredictionFeatures } */
    this.features;
  }
}



mojo.internal.Struct(
    VideoDecodePerfHistory_GetPerfInfo_ResponseParamsSpec.$,
    'VideoDecodePerfHistory_GetPerfInfo_ResponseParams',
    [
      mojo.internal.StructField(
        'isSmooth', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isPowerEfficient', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class VideoDecodePerfHistory_GetPerfInfo_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.isSmooth;
    /** @type { !boolean } */
    this.isPowerEfficient;
  }
}

