// media/mojo/mojom/video_encoder_info.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'media/mojo/mojom/video_encoder_info.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('media.mojom');
  var media_types$ =
      mojo.internal.exposeNamespace('media.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'media/mojo/mojom/media_types.mojom', 'media_types.mojom.js');
  }
  var geometry$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/geometry/mojom/geometry.mojom', '../../../ui/gfx/geometry/mojom/geometry.mojom.js');
  }



  function ResolutionRateLimit(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResolutionRateLimit.prototype.initDefaults_ = function() {
    this.frameSize = null;
    this.minStartBitrateBps = 0;
    this.minBitrateBps = 0;
    this.maxBitrateBps = 0;
    this.maxFramerateNumerator = 0;
    this.maxFramerateDenominator = 0;
  };
  ResolutionRateLimit.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResolutionRateLimit.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ResolutionRateLimit.frameSize
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, geometry$.Size, false);
    if (err !== validator.validationError.NONE)
        return err;






    return validator.validationError.NONE;
  };

  ResolutionRateLimit.encodedSize = codec.kStructHeaderSize + 32;

  ResolutionRateLimit.decode = function(decoder) {
    var packed;
    var val = new ResolutionRateLimit();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.frameSize =
        decoder.decodeStructPointer(geometry$.Size);
    val.minStartBitrateBps =
        decoder.decodeStruct(codec.Int32);
    val.minBitrateBps =
        decoder.decodeStruct(codec.Int32);
    val.maxBitrateBps =
        decoder.decodeStruct(codec.Int32);
    val.maxFramerateNumerator =
        decoder.decodeStruct(codec.Uint32);
    val.maxFramerateDenominator =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ResolutionRateLimit.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResolutionRateLimit.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(geometry$.Size, val.frameSize);
    encoder.encodeStruct(codec.Int32, val.minStartBitrateBps);
    encoder.encodeStruct(codec.Int32, val.minBitrateBps);
    encoder.encodeStruct(codec.Int32, val.maxBitrateBps);
    encoder.encodeStruct(codec.Uint32, val.maxFramerateNumerator);
    encoder.encodeStruct(codec.Uint32, val.maxFramerateDenominator);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function VideoEncoderInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  VideoEncoderInfo.prototype.initDefaults_ = function() {
    this.implementationName = null;
    this.hasFrameDelay = false;
    this.hasInputCapacity = false;
    this.supportsNativeHandle = false;
    this.hasTrustedRateController = false;
    this.isHardwareAccelerated = false;
    this.supportsSimulcast = false;
    this.reportsAverageQp = false;
    this.applyAlignmentToAllSimulcastLayers = false;
    this.supportsFrameSizeChange = false;
    this.supportsGpuSharedImages = false;
    this.frameDelay = 0;
    this.inputCapacity = 0;
    this.requestedResolutionAlignment = 0;
    this.fpsAllocation = null;
    this.resolutionRateLimits = null;
    this.gpuSupportedPixelFormats = null;
  };
  VideoEncoderInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  VideoEncoderInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 56}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoEncoderInfo.implementationName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;














    // validate VideoEncoderInfo.fpsAllocation
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 24, 8, new codec.ArrayOf(codec.Uint8), false, [5, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoEncoderInfo.resolutionRateLimits
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 32, 8, new codec.PointerTo(ResolutionRateLimit), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoEncoderInfo.gpuSupportedPixelFormats
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 40, 4, new codec.Enum(media_types$.VideoPixelFormat), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  VideoEncoderInfo.encodedSize = codec.kStructHeaderSize + 48;

  VideoEncoderInfo.decode = function(decoder) {
    var packed;
    var val = new VideoEncoderInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.implementationName =
        decoder.decodeStruct(codec.String);
    packed = decoder.readUint8();
    val.hasFrameDelay = (packed >> 0) & 1 ? true : false;
    val.hasInputCapacity = (packed >> 1) & 1 ? true : false;
    val.supportsNativeHandle = (packed >> 2) & 1 ? true : false;
    val.hasTrustedRateController = (packed >> 3) & 1 ? true : false;
    val.isHardwareAccelerated = (packed >> 4) & 1 ? true : false;
    val.supportsSimulcast = (packed >> 5) & 1 ? true : false;
    val.reportsAverageQp = (packed >> 6) & 1 ? true : false;
    val.applyAlignmentToAllSimulcastLayers = (packed >> 7) & 1 ? true : false;
    packed = decoder.readUint8();
    val.supportsFrameSizeChange = (packed >> 0) & 1 ? true : false;
    val.supportsGpuSharedImages = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    val.frameDelay =
        decoder.decodeStruct(codec.Int32);
    val.inputCapacity =
        decoder.decodeStruct(codec.Int32);
    val.requestedResolutionAlignment =
        decoder.decodeStruct(codec.Uint32);
    val.fpsAllocation =
        decoder.decodeArrayPointer(new codec.ArrayOf(codec.Uint8));
    val.resolutionRateLimits =
        decoder.decodeArrayPointer(new codec.PointerTo(ResolutionRateLimit));
    val.gpuSupportedPixelFormats =
        decoder.decodeArrayPointer(new codec.Enum(media_types$.VideoPixelFormat));
    return val;
  };

  VideoEncoderInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(VideoEncoderInfo.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.implementationName);
    packed = 0;
    packed |= (val.hasFrameDelay & 1) << 0
    packed |= (val.hasInputCapacity & 1) << 1
    packed |= (val.supportsNativeHandle & 1) << 2
    packed |= (val.hasTrustedRateController & 1) << 3
    packed |= (val.isHardwareAccelerated & 1) << 4
    packed |= (val.supportsSimulcast & 1) << 5
    packed |= (val.reportsAverageQp & 1) << 6
    packed |= (val.applyAlignmentToAllSimulcastLayers & 1) << 7
    encoder.writeUint8(packed);
    packed = 0;
    packed |= (val.supportsFrameSizeChange & 1) << 0
    packed |= (val.supportsGpuSharedImages & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.frameDelay);
    encoder.encodeStruct(codec.Int32, val.inputCapacity);
    encoder.encodeStruct(codec.Uint32, val.requestedResolutionAlignment);
    encoder.encodeArrayPointer(new codec.ArrayOf(codec.Uint8), val.fpsAllocation);
    encoder.encodeArrayPointer(new codec.PointerTo(ResolutionRateLimit), val.resolutionRateLimits);
    encoder.encodeArrayPointer(new codec.Enum(media_types$.VideoPixelFormat), val.gpuSupportedPixelFormats);
  };
  exports.ResolutionRateLimit = ResolutionRateLimit;
  exports.VideoEncoderInfo = VideoEncoderInfo;
})();