// services/accessibility/public/mojom/automation.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('ax.mojom.AXActionData');
goog.require('ax.mojom.AXEvent');
goog.require('ax.mojom.AXRelativeBounds');
goog.require('ax.mojom.AXTreeUpdate');
goog.require('gfx.mojom.Point');
goog.require('gfx.mojom.Rect');
goog.require('ax.mojom.AXTreeID');






goog.provide('ax.mojom.Automation');
goog.provide('ax.mojom.AutomationReceiver');
goog.provide('ax.mojom.AutomationCallbackRouter');
goog.provide('ax.mojom.AutomationInterface');
goog.provide('ax.mojom.AutomationRemote');
goog.provide('ax.mojom.AutomationPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
ax.mojom.AutomationPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        ax.mojom.Automation.$interfaceName,
        scope);
  }
};

/** @interface */
ax.mojom.AutomationInterface = class {
  
  /**
   * @param { !ax.mojom.AXTreeID } treeId
   */

  dispatchTreeDestroyedEvent(treeId) {}
  
  /**
   * @param { !ax.mojom.AXActionData } data
   * @param { !boolean } result
   */

  dispatchActionResult(data, result) {}
  
  /**
   * @param { !ax.mojom.AXTreeID } treeId
   * @param { !Array<!ax.mojom.AXTreeUpdate> } updates
   * @param { !gfx.mojom.Point } mouseLocation
   * @param { !Array<!ax.mojom.AXEvent> } events
   */

  dispatchAccessibilityEvents(treeId, updates, mouseLocation, events) {}
  
  /**
   * @param { !ax.mojom.AXTreeID } treeId
   * @param { !number } nodeId
   * @param { !ax.mojom.AXRelativeBounds } bounds
   */

  dispatchAccessibilityLocationChange(treeId, nodeId, bounds) {}
  
  /**
   * @param { !ax.mojom.AXTreeID } treeId
   * @param { !number } nodeId
   * @param { !number } scrollX
   * @param { !number } scrollY
   */

  dispatchAccessibilityScrollChange(treeId, nodeId, scrollX, scrollY) {}
  
  /**
   * @param { !ax.mojom.AXActionData } data
   * @param { ?gfx.mojom.Rect } rect
   */

  dispatchGetTextLocationResult(data, rect) {}
};

/**
 * @export
 * @implements { ax.mojom.AutomationInterface }
 */
ax.mojom.AutomationRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ax.mojom.AutomationPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ax.mojom.AutomationPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ax.mojom.AutomationPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !ax.mojom.AXTreeID } treeId
   */

  dispatchTreeDestroyedEvent(
      treeId) {
    this.proxy.sendMessage(
        0,
        ax.mojom.Automation_DispatchTreeDestroyedEvent_ParamsSpec.$,
        null,
        [
          treeId
        ],
        false);
  }

  
  /**
   * @param { !ax.mojom.AXActionData } data
   * @param { !boolean } result
   */

  dispatchActionResult(
      data,
      result) {
    this.proxy.sendMessage(
        1,
        ax.mojom.Automation_DispatchActionResult_ParamsSpec.$,
        null,
        [
          data,
          result
        ],
        false);
  }

  
  /**
   * @param { !ax.mojom.AXTreeID } treeId
   * @param { !Array<!ax.mojom.AXTreeUpdate> } updates
   * @param { !gfx.mojom.Point } mouseLocation
   * @param { !Array<!ax.mojom.AXEvent> } events
   */

  dispatchAccessibilityEvents(
      treeId,
      updates,
      mouseLocation,
      events) {
    this.proxy.sendMessage(
        2,
        ax.mojom.Automation_DispatchAccessibilityEvents_ParamsSpec.$,
        null,
        [
          treeId,
          updates,
          mouseLocation,
          events
        ],
        false);
  }

  
  /**
   * @param { !ax.mojom.AXTreeID } treeId
   * @param { !number } nodeId
   * @param { !ax.mojom.AXRelativeBounds } bounds
   */

  dispatchAccessibilityLocationChange(
      treeId,
      nodeId,
      bounds) {
    this.proxy.sendMessage(
        3,
        ax.mojom.Automation_DispatchAccessibilityLocationChange_ParamsSpec.$,
        null,
        [
          treeId,
          nodeId,
          bounds
        ],
        false);
  }

  
  /**
   * @param { !ax.mojom.AXTreeID } treeId
   * @param { !number } nodeId
   * @param { !number } scrollX
   * @param { !number } scrollY
   */

  dispatchAccessibilityScrollChange(
      treeId,
      nodeId,
      scrollX,
      scrollY) {
    this.proxy.sendMessage(
        4,
        ax.mojom.Automation_DispatchAccessibilityScrollChange_ParamsSpec.$,
        null,
        [
          treeId,
          nodeId,
          scrollX,
          scrollY
        ],
        false);
  }

  
  /**
   * @param { !ax.mojom.AXActionData } data
   * @param { ?gfx.mojom.Rect } rect
   */

  dispatchGetTextLocationResult(
      data,
      rect) {
    this.proxy.sendMessage(
        5,
        ax.mojom.Automation_DispatchGetTextLocationResult_ParamsSpec.$,
        null,
        [
          data,
          rect
        ],
        false);
  }
};

/**
 * An object which receives request messages for the Automation
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
ax.mojom.AutomationReceiver = class {
  /**
   * @param {!ax.mojom.AutomationInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ax.mojom.AutomationRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ax.mojom.AutomationRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ax.mojom.AutomationRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ax.mojom.Automation_DispatchTreeDestroyedEvent_ParamsSpec.$,
        null,
        impl.dispatchTreeDestroyedEvent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        ax.mojom.Automation_DispatchActionResult_ParamsSpec.$,
        null,
        impl.dispatchActionResult.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        ax.mojom.Automation_DispatchAccessibilityEvents_ParamsSpec.$,
        null,
        impl.dispatchAccessibilityEvents.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        ax.mojom.Automation_DispatchAccessibilityLocationChange_ParamsSpec.$,
        null,
        impl.dispatchAccessibilityLocationChange.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        ax.mojom.Automation_DispatchAccessibilityScrollChange_ParamsSpec.$,
        null,
        impl.dispatchAccessibilityScrollChange.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        ax.mojom.Automation_DispatchGetTextLocationResult_ParamsSpec.$,
        null,
        impl.dispatchGetTextLocationResult.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
ax.mojom.Automation = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ax.mojom.Automation";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ax.mojom.AutomationRemote}
   * @export
   */
  static getRemote() {
    let remote = new ax.mojom.AutomationRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the Automation
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
ax.mojom.AutomationCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ax.mojom.AutomationRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ax.mojom.AutomationRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dispatchTreeDestroyedEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ax.mojom.Automation_DispatchTreeDestroyedEvent_ParamsSpec.$,
        null,
        this.dispatchTreeDestroyedEvent.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dispatchActionResult =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        ax.mojom.Automation_DispatchActionResult_ParamsSpec.$,
        null,
        this.dispatchActionResult.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dispatchAccessibilityEvents =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        ax.mojom.Automation_DispatchAccessibilityEvents_ParamsSpec.$,
        null,
        this.dispatchAccessibilityEvents.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dispatchAccessibilityLocationChange =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        ax.mojom.Automation_DispatchAccessibilityLocationChange_ParamsSpec.$,
        null,
        this.dispatchAccessibilityLocationChange.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dispatchAccessibilityScrollChange =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        ax.mojom.Automation_DispatchAccessibilityScrollChange_ParamsSpec.$,
        null,
        this.dispatchAccessibilityScrollChange.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dispatchGetTextLocationResult =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        ax.mojom.Automation_DispatchGetTextLocationResult_ParamsSpec.$,
        null,
        this.dispatchGetTextLocationResult.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('ax.mojom.Automation_DispatchTreeDestroyedEvent_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ax.mojom.Automation_DispatchTreeDestroyedEvent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ax.mojom.Automation_DispatchActionResult_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ax.mojom.Automation_DispatchActionResult_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ax.mojom.Automation_DispatchAccessibilityEvents_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ax.mojom.Automation_DispatchAccessibilityEvents_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ax.mojom.Automation_DispatchAccessibilityLocationChange_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ax.mojom.Automation_DispatchAccessibilityLocationChange_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ax.mojom.Automation_DispatchAccessibilityScrollChange_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ax.mojom.Automation_DispatchAccessibilityScrollChange_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ax.mojom.Automation_DispatchGetTextLocationResult_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ax.mojom.Automation_DispatchGetTextLocationResult_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    ax.mojom.Automation_DispatchTreeDestroyedEvent_ParamsSpec.$,
    'Automation_DispatchTreeDestroyedEvent_Params',
    [
      mojo.internal.StructField(
        'treeId', 0,
        0,
        ax.mojom.AXTreeIDSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('ax.mojom.Automation_DispatchTreeDestroyedEvent_Params');

/** @record */
ax.mojom.Automation_DispatchTreeDestroyedEvent_Params = class {
  constructor() {
    /** @export { !ax.mojom.AXTreeID } */
    this.treeId;
  }
};



mojo.internal.Struct(
    ax.mojom.Automation_DispatchActionResult_ParamsSpec.$,
    'Automation_DispatchActionResult_Params',
    [
      mojo.internal.StructField(
        'data', 0,
        0,
        ax.mojom.AXActionDataSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'result', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('ax.mojom.Automation_DispatchActionResult_Params');

/** @record */
ax.mojom.Automation_DispatchActionResult_Params = class {
  constructor() {
    /** @export { !ax.mojom.AXActionData } */
    this.data;
    /** @export { !boolean } */
    this.result;
  }
};



mojo.internal.Struct(
    ax.mojom.Automation_DispatchAccessibilityEvents_ParamsSpec.$,
    'Automation_DispatchAccessibilityEvents_Params',
    [
      mojo.internal.StructField(
        'treeId', 0,
        0,
        ax.mojom.AXTreeIDSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'updates', 16,
        0,
        mojo.internal.Array(ax.mojom.AXTreeUpdateSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'mouseLocation', 24,
        0,
        gfx.mojom.PointSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'events', 32,
        0,
        mojo.internal.Array(ax.mojom.AXEventSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 48],]);



goog.provide('ax.mojom.Automation_DispatchAccessibilityEvents_Params');

/** @record */
ax.mojom.Automation_DispatchAccessibilityEvents_Params = class {
  constructor() {
    /** @export { !ax.mojom.AXTreeID } */
    this.treeId;
    /** @export { !Array<!ax.mojom.AXTreeUpdate> } */
    this.updates;
    /** @export { !gfx.mojom.Point } */
    this.mouseLocation;
    /** @export { !Array<!ax.mojom.AXEvent> } */
    this.events;
  }
};



mojo.internal.Struct(
    ax.mojom.Automation_DispatchAccessibilityLocationChange_ParamsSpec.$,
    'Automation_DispatchAccessibilityLocationChange_Params',
    [
      mojo.internal.StructField(
        'treeId', 0,
        0,
        ax.mojom.AXTreeIDSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'nodeId', 16,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'bounds', 24,
        0,
        ax.mojom.AXRelativeBoundsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('ax.mojom.Automation_DispatchAccessibilityLocationChange_Params');

/** @record */
ax.mojom.Automation_DispatchAccessibilityLocationChange_Params = class {
  constructor() {
    /** @export { !ax.mojom.AXTreeID } */
    this.treeId;
    /** @export { !number } */
    this.nodeId;
    /** @export { !ax.mojom.AXRelativeBounds } */
    this.bounds;
  }
};



mojo.internal.Struct(
    ax.mojom.Automation_DispatchAccessibilityScrollChange_ParamsSpec.$,
    'Automation_DispatchAccessibilityScrollChange_Params',
    [
      mojo.internal.StructField(
        'treeId', 0,
        0,
        ax.mojom.AXTreeIDSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'nodeId', 16,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'scrollX', 20,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'scrollY', 24,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('ax.mojom.Automation_DispatchAccessibilityScrollChange_Params');

/** @record */
ax.mojom.Automation_DispatchAccessibilityScrollChange_Params = class {
  constructor() {
    /** @export { !ax.mojom.AXTreeID } */
    this.treeId;
    /** @export { !number } */
    this.nodeId;
    /** @export { !number } */
    this.scrollX;
    /** @export { !number } */
    this.scrollY;
  }
};



mojo.internal.Struct(
    ax.mojom.Automation_DispatchGetTextLocationResult_ParamsSpec.$,
    'Automation_DispatchGetTextLocationResult_Params',
    [
      mojo.internal.StructField(
        'data', 0,
        0,
        ax.mojom.AXActionDataSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'rect', 8,
        0,
        gfx.mojom.RectSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('ax.mojom.Automation_DispatchGetTextLocationResult_Params');

/** @record */
ax.mojom.Automation_DispatchGetTextLocationResult_Params = class {
  constructor() {
    /** @export { !ax.mojom.AXActionData } */
    this.data;
    /** @export { (gfx.mojom.Rect|undefined) } */
    this.rect;
  }
};

