// services/device/public/mojom/battery_monitor.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('device.mojom.BatteryStatus');






goog.provide('device.mojom.BatteryMonitor');
goog.provide('device.mojom.BatteryMonitorReceiver');
goog.provide('device.mojom.BatteryMonitorCallbackRouter');
goog.provide('device.mojom.BatteryMonitorInterface');
goog.provide('device.mojom.BatteryMonitorRemote');
goog.provide('device.mojom.BatteryMonitorPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
device.mojom.BatteryMonitorPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        device.mojom.BatteryMonitor.$interfaceName,
        scope);
  }
};

/** @interface */
device.mojom.BatteryMonitorInterface = class {
  
  /**
   * @return {!Promise<{
        status: !device.mojom.BatteryStatus,
   *  }>}
   */

  queryNextStatus() {}
};

/**
 * @export
 * @implements { device.mojom.BatteryMonitorInterface }
 */
device.mojom.BatteryMonitorRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!device.mojom.BatteryMonitorPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          device.mojom.BatteryMonitorPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!device.mojom.BatteryMonitorPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        status: !device.mojom.BatteryStatus,
   *  }>}
   */

  queryNextStatus() {
    return this.proxy.sendMessage(
        0,
        device.mojom.BatteryMonitor_QueryNextStatus_ParamsSpec.$,
        device.mojom.BatteryMonitor_QueryNextStatus_ResponseParamsSpec.$,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the BatteryMonitor
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
device.mojom.BatteryMonitorReceiver = class {
  /**
   * @param {!device.mojom.BatteryMonitorInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!device.mojom.BatteryMonitorRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        device.mojom.BatteryMonitorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.BatteryMonitorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        device.mojom.BatteryMonitor_QueryNextStatus_ParamsSpec.$,
        device.mojom.BatteryMonitor_QueryNextStatus_ResponseParamsSpec.$,
        impl.queryNextStatus.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
device.mojom.BatteryMonitor = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.BatteryMonitor";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!device.mojom.BatteryMonitorRemote}
   * @export
   */
  static getRemote() {
    let remote = new device.mojom.BatteryMonitorRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the BatteryMonitor
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
device.mojom.BatteryMonitorCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      device.mojom.BatteryMonitorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.BatteryMonitorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.queryNextStatus =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        device.mojom.BatteryMonitor_QueryNextStatus_ParamsSpec.$,
        device.mojom.BatteryMonitor_QueryNextStatus_ResponseParamsSpec.$,
        this.queryNextStatus.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('device.mojom.BatteryMonitor_QueryNextStatus_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.BatteryMonitor_QueryNextStatus_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.BatteryMonitor_QueryNextStatus_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.BatteryMonitor_QueryNextStatus_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    device.mojom.BatteryMonitor_QueryNextStatus_ParamsSpec.$,
    'BatteryMonitor_QueryNextStatus_Params',
    [
    ],
    [[0, 8],]);



goog.provide('device.mojom.BatteryMonitor_QueryNextStatus_Params');

/** @record */
device.mojom.BatteryMonitor_QueryNextStatus_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    device.mojom.BatteryMonitor_QueryNextStatus_ResponseParamsSpec.$,
    'BatteryMonitor_QueryNextStatus_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        device.mojom.BatteryStatusSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.BatteryMonitor_QueryNextStatus_ResponseParams');

/** @record */
device.mojom.BatteryMonitor_QueryNextStatus_ResponseParams = class {
  constructor() {
    /** @export { !device.mojom.BatteryStatus } */
    this.status;
  }
};

