// services/device/public/mojom/mtp_file_entry.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/device/public/mojom/mtp_file_entry.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('device.mojom');



  function MtpFileEntry(values) {
    this.initDefaults_();
    this.initFields_(values);
  }

  MtpFileEntry.FileType = {};
  MtpFileEntry.FileType.FILE_TYPE_FOLDER = 0;
  MtpFileEntry.FileType.FILE_TYPE_JPEG = 14;
  MtpFileEntry.FileType.FILE_TYPE_JFIF = 15;
  MtpFileEntry.FileType.FILE_TYPE_TIFF = 16;
  MtpFileEntry.FileType.FILE_TYPE_BMP = 17;
  MtpFileEntry.FileType.FILE_TYPE_GIF = 18;
  MtpFileEntry.FileType.FILE_TYPE_PICT = 19;
  MtpFileEntry.FileType.FILE_TYPE_PNG = 20;
  MtpFileEntry.FileType.FILE_TYPE_WINDOWSIMAGEFORMAT = 25;
  MtpFileEntry.FileType.FILE_TYPE_JP2 = 40;
  MtpFileEntry.FileType.FILE_TYPE_JPX = 41;
  MtpFileEntry.FileType.FILE_TYPE_UNKNOWN = 44;
  MtpFileEntry.FileType.FILE_TYPE_OTHER = 9999;
  MtpFileEntry.FileType.MIN_VALUE = 0;
  MtpFileEntry.FileType.MAX_VALUE = 9999;

  MtpFileEntry.FileType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 14:
    case 15:
    case 16:
    case 17:
    case 18:
    case 19:
    case 20:
    case 25:
    case 40:
    case 41:
    case 44:
    case 9999:
      return true;
    }
    return false;
  };

  MtpFileEntry.FileType.toKnownEnumValue = function(value) {
    return value;
  };

  MtpFileEntry.FileType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  MtpFileEntry.prototype.initDefaults_ = function() {
    this.itemId = 0xFFFFFFFF;
    this.parentId = 0XFFFFFFFF;
    this.fileName = null;
    this.fileSize = 0;
    this.modificationTime = 0;
    this.fileType = MtpFileEntry.FileType.FILE_TYPE_UNKNOWN;
  };
  MtpFileEntry.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MtpFileEntry.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;




    // validate MtpFileEntry.fileName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;




    // validate MtpFileEntry.fileType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 32, MtpFileEntry.FileType);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MtpFileEntry.encodedSize = codec.kStructHeaderSize + 40;

  MtpFileEntry.decode = function(decoder) {
    var packed;
    var val = new MtpFileEntry();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.itemId =
        decoder.decodeStruct(codec.Uint32);
    val.parentId =
        decoder.decodeStruct(codec.Uint32);
    val.fileName =
        decoder.decodeStruct(codec.String);
    val.fileSize =
        decoder.decodeStruct(codec.Uint64);
    val.modificationTime =
        decoder.decodeStruct(codec.Int64);
    val.fileType =
        decoder.decodeStruct(new codec.Enum(MtpFileEntry.FileType));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MtpFileEntry.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MtpFileEntry.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.itemId);
    encoder.encodeStruct(codec.Uint32, val.parentId);
    encoder.encodeStruct(codec.String, val.fileName);
    encoder.encodeStruct(codec.Uint64, val.fileSize);
    encoder.encodeStruct(codec.Int64, val.modificationTime);
    encoder.encodeStruct(codec.Int32, val.fileType);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  exports.MtpFileEntry = MtpFileEntry;
})();