// services/device/public/mojom/mtp_manager.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('device.mojom.MtpFileEntry');
goog.require('device.mojom.MtpStorageInfo');






goog.provide('device.mojom.MtpManagerClient');
goog.provide('device.mojom.MtpManagerClientReceiver');
goog.provide('device.mojom.MtpManagerClientCallbackRouter');
goog.provide('device.mojom.MtpManagerClientInterface');
goog.provide('device.mojom.MtpManagerClientRemote');
goog.provide('device.mojom.MtpManagerClientPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
device.mojom.MtpManagerClientPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        device.mojom.MtpManagerClient.$interfaceName,
        scope);
  }
};

/** @interface */
device.mojom.MtpManagerClientInterface = class {
  
  /**
   * @param { !device.mojom.MtpStorageInfo } storageInfo
   */

  storageAttached(storageInfo) {}
  
  /**
   * @param { !string } storageName
   */

  storageDetached(storageName) {}
};

/**
 * @export
 * @implements { device.mojom.MtpManagerClientInterface }
 */
device.mojom.MtpManagerClientRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!device.mojom.MtpManagerClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          device.mojom.MtpManagerClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!device.mojom.MtpManagerClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !device.mojom.MtpStorageInfo } storageInfo
   */

  storageAttached(
      storageInfo) {
    this.proxy.sendMessage(
        0,
        device.mojom.MtpManagerClient_StorageAttached_ParamsSpec.$,
        null,
        [
          storageInfo
        ],
        false);
  }

  
  /**
   * @param { !string } storageName
   */

  storageDetached(
      storageName) {
    this.proxy.sendMessage(
        1,
        device.mojom.MtpManagerClient_StorageDetached_ParamsSpec.$,
        null,
        [
          storageName
        ],
        false);
  }
};

/**
 * An object which receives request messages for the MtpManagerClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
device.mojom.MtpManagerClientReceiver = class {
  /**
   * @param {!device.mojom.MtpManagerClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!device.mojom.MtpManagerClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        device.mojom.MtpManagerClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.MtpManagerClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        device.mojom.MtpManagerClient_StorageAttached_ParamsSpec.$,
        null,
        impl.storageAttached.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        device.mojom.MtpManagerClient_StorageDetached_ParamsSpec.$,
        null,
        impl.storageDetached.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
device.mojom.MtpManagerClient = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.MtpManagerClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!device.mojom.MtpManagerClientRemote}
   * @export
   */
  static getRemote() {
    let remote = new device.mojom.MtpManagerClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the MtpManagerClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
device.mojom.MtpManagerClientCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      device.mojom.MtpManagerClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.MtpManagerClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.storageAttached =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        device.mojom.MtpManagerClient_StorageAttached_ParamsSpec.$,
        null,
        this.storageAttached.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.storageDetached =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        device.mojom.MtpManagerClient_StorageDetached_ParamsSpec.$,
        null,
        this.storageDetached.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('device.mojom.MtpManager');
goog.provide('device.mojom.MtpManagerReceiver');
goog.provide('device.mojom.MtpManagerCallbackRouter');
goog.provide('device.mojom.MtpManagerInterface');
goog.provide('device.mojom.MtpManagerRemote');
goog.provide('device.mojom.MtpManagerPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
device.mojom.MtpManagerPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        device.mojom.MtpManager.$interfaceName,
        scope);
  }
};

/** @interface */
device.mojom.MtpManagerInterface = class {
  
  /**
   * @param { !Object } client
   * @return {!Promise<{
        storages: !Array<!device.mojom.MtpStorageInfo>,
   *  }>}
   */

  enumerateStoragesAndSetClient(client) {}
  
  /**
   * @param { !string } storageName
   * @return {!Promise<{
        storageInfo: !device.mojom.MtpStorageInfo,
   *  }>}
   */

  getStorageInfo(storageName) {}
  
  /**
   * @param { !string } storageName
   * @return {!Promise<{
        storageInfo: !device.mojom.MtpStorageInfo,
        error: !boolean,
   *  }>}
   */

  getStorageInfoFromDevice(storageName) {}
  
  /**
   * @param { !string } storageName
   * @param { !string } mode
   * @return {!Promise<{
        storageHandle: !string,
        error: !boolean,
   *  }>}
   */

  openStorage(storageName, mode) {}
  
  /**
   * @param { !string } storageHandle
   * @return {!Promise<{
        error: !boolean,
   *  }>}
   */

  closeStorage(storageHandle) {}
  
  /**
   * @param { !string } storageHandle
   * @param { !number } parentId
   * @param { !string } directoryName
   * @return {!Promise<{
        error: !boolean,
   *  }>}
   */

  createDirectory(storageHandle, parentId, directoryName) {}
  
  /**
   * @param { !string } storageHandle
   * @param { !number } fileId
   * @return {!Promise<{
        fileIds: !Array<!number>,
        error: !boolean,
   *  }>}
   */

  readDirectoryEntryIds(storageHandle, fileId) {}
  
  /**
   * @param { !string } storageHandle
   * @param { !number } fileId
   * @param { !number } offset
   * @param { !number } count
   * @return {!Promise<{
        data: !string,
        error: !boolean,
   *  }>}
   */

  readFileChunk(storageHandle, fileId, offset, count) {}
  
  /**
   * @param { !string } storageHandle
   * @param { !Array<!number> } fileIds
   * @return {!Promise<{
        fileEntries: !Array<!device.mojom.MtpFileEntry>,
        error: !boolean,
   *  }>}
   */

  getFileInfo(storageHandle, fileIds) {}
  
  /**
   * @param { !string } storageHandle
   * @param { !number } objectId
   * @param { !string } newName
   * @return {!Promise<{
        error: !boolean,
   *  }>}
   */

  renameObject(storageHandle, objectId, newName) {}
  
  /**
   * @param { !string } storageHandle
   * @param { !bigint } sourceFileDescriptor
   * @param { !number } parentId
   * @param { !string } fileName
   * @return {!Promise<{
        error: !boolean,
   *  }>}
   */

  copyFileFromLocal(storageHandle, sourceFileDescriptor, parentId, fileName) {}
  
  /**
   * @param { !string } storageHandle
   * @param { !number } objectId
   * @return {!Promise<{
        error: !boolean,
   *  }>}
   */

  deleteObject(storageHandle, objectId) {}
};

/**
 * @export
 * @implements { device.mojom.MtpManagerInterface }
 */
device.mojom.MtpManagerRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!device.mojom.MtpManagerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          device.mojom.MtpManagerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!device.mojom.MtpManagerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Object } client
   * @return {!Promise<{
        storages: !Array<!device.mojom.MtpStorageInfo>,
   *  }>}
   */

  enumerateStoragesAndSetClient(
      client) {
    return this.proxy.sendMessage(
        0,
        device.mojom.MtpManager_EnumerateStoragesAndSetClient_ParamsSpec.$,
        device.mojom.MtpManager_EnumerateStoragesAndSetClient_ResponseParamsSpec.$,
        [
          client
        ],
        false);
  }

  
  /**
   * @param { !string } storageName
   * @return {!Promise<{
        storageInfo: !device.mojom.MtpStorageInfo,
   *  }>}
   */

  getStorageInfo(
      storageName) {
    return this.proxy.sendMessage(
        1,
        device.mojom.MtpManager_GetStorageInfo_ParamsSpec.$,
        device.mojom.MtpManager_GetStorageInfo_ResponseParamsSpec.$,
        [
          storageName
        ],
        false);
  }

  
  /**
   * @param { !string } storageName
   * @return {!Promise<{
        storageInfo: !device.mojom.MtpStorageInfo,
        error: !boolean,
   *  }>}
   */

  getStorageInfoFromDevice(
      storageName) {
    return this.proxy.sendMessage(
        2,
        device.mojom.MtpManager_GetStorageInfoFromDevice_ParamsSpec.$,
        device.mojom.MtpManager_GetStorageInfoFromDevice_ResponseParamsSpec.$,
        [
          storageName
        ],
        false);
  }

  
  /**
   * @param { !string } storageName
   * @param { !string } mode
   * @return {!Promise<{
        storageHandle: !string,
        error: !boolean,
   *  }>}
   */

  openStorage(
      storageName,
      mode) {
    return this.proxy.sendMessage(
        3,
        device.mojom.MtpManager_OpenStorage_ParamsSpec.$,
        device.mojom.MtpManager_OpenStorage_ResponseParamsSpec.$,
        [
          storageName,
          mode
        ],
        false);
  }

  
  /**
   * @param { !string } storageHandle
   * @return {!Promise<{
        error: !boolean,
   *  }>}
   */

  closeStorage(
      storageHandle) {
    return this.proxy.sendMessage(
        4,
        device.mojom.MtpManager_CloseStorage_ParamsSpec.$,
        device.mojom.MtpManager_CloseStorage_ResponseParamsSpec.$,
        [
          storageHandle
        ],
        false);
  }

  
  /**
   * @param { !string } storageHandle
   * @param { !number } parentId
   * @param { !string } directoryName
   * @return {!Promise<{
        error: !boolean,
   *  }>}
   */

  createDirectory(
      storageHandle,
      parentId,
      directoryName) {
    return this.proxy.sendMessage(
        5,
        device.mojom.MtpManager_CreateDirectory_ParamsSpec.$,
        device.mojom.MtpManager_CreateDirectory_ResponseParamsSpec.$,
        [
          storageHandle,
          parentId,
          directoryName
        ],
        false);
  }

  
  /**
   * @param { !string } storageHandle
   * @param { !number } fileId
   * @return {!Promise<{
        fileIds: !Array<!number>,
        error: !boolean,
   *  }>}
   */

  readDirectoryEntryIds(
      storageHandle,
      fileId) {
    return this.proxy.sendMessage(
        6,
        device.mojom.MtpManager_ReadDirectoryEntryIds_ParamsSpec.$,
        device.mojom.MtpManager_ReadDirectoryEntryIds_ResponseParamsSpec.$,
        [
          storageHandle,
          fileId
        ],
        false);
  }

  
  /**
   * @param { !string } storageHandle
   * @param { !number } fileId
   * @param { !number } offset
   * @param { !number } count
   * @return {!Promise<{
        data: !string,
        error: !boolean,
   *  }>}
   */

  readFileChunk(
      storageHandle,
      fileId,
      offset,
      count) {
    return this.proxy.sendMessage(
        7,
        device.mojom.MtpManager_ReadFileChunk_ParamsSpec.$,
        device.mojom.MtpManager_ReadFileChunk_ResponseParamsSpec.$,
        [
          storageHandle,
          fileId,
          offset,
          count
        ],
        false);
  }

  
  /**
   * @param { !string } storageHandle
   * @param { !Array<!number> } fileIds
   * @return {!Promise<{
        fileEntries: !Array<!device.mojom.MtpFileEntry>,
        error: !boolean,
   *  }>}
   */

  getFileInfo(
      storageHandle,
      fileIds) {
    return this.proxy.sendMessage(
        8,
        device.mojom.MtpManager_GetFileInfo_ParamsSpec.$,
        device.mojom.MtpManager_GetFileInfo_ResponseParamsSpec.$,
        [
          storageHandle,
          fileIds
        ],
        false);
  }

  
  /**
   * @param { !string } storageHandle
   * @param { !number } objectId
   * @param { !string } newName
   * @return {!Promise<{
        error: !boolean,
   *  }>}
   */

  renameObject(
      storageHandle,
      objectId,
      newName) {
    return this.proxy.sendMessage(
        9,
        device.mojom.MtpManager_RenameObject_ParamsSpec.$,
        device.mojom.MtpManager_RenameObject_ResponseParamsSpec.$,
        [
          storageHandle,
          objectId,
          newName
        ],
        false);
  }

  
  /**
   * @param { !string } storageHandle
   * @param { !bigint } sourceFileDescriptor
   * @param { !number } parentId
   * @param { !string } fileName
   * @return {!Promise<{
        error: !boolean,
   *  }>}
   */

  copyFileFromLocal(
      storageHandle,
      sourceFileDescriptor,
      parentId,
      fileName) {
    return this.proxy.sendMessage(
        10,
        device.mojom.MtpManager_CopyFileFromLocal_ParamsSpec.$,
        device.mojom.MtpManager_CopyFileFromLocal_ResponseParamsSpec.$,
        [
          storageHandle,
          sourceFileDescriptor,
          parentId,
          fileName
        ],
        false);
  }

  
  /**
   * @param { !string } storageHandle
   * @param { !number } objectId
   * @return {!Promise<{
        error: !boolean,
   *  }>}
   */

  deleteObject(
      storageHandle,
      objectId) {
    return this.proxy.sendMessage(
        11,
        device.mojom.MtpManager_DeleteObject_ParamsSpec.$,
        device.mojom.MtpManager_DeleteObject_ResponseParamsSpec.$,
        [
          storageHandle,
          objectId
        ],
        false);
  }
};

/**
 * An object which receives request messages for the MtpManager
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
device.mojom.MtpManagerReceiver = class {
  /**
   * @param {!device.mojom.MtpManagerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!device.mojom.MtpManagerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        device.mojom.MtpManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.MtpManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        device.mojom.MtpManager_EnumerateStoragesAndSetClient_ParamsSpec.$,
        device.mojom.MtpManager_EnumerateStoragesAndSetClient_ResponseParamsSpec.$,
        impl.enumerateStoragesAndSetClient.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        device.mojom.MtpManager_GetStorageInfo_ParamsSpec.$,
        device.mojom.MtpManager_GetStorageInfo_ResponseParamsSpec.$,
        impl.getStorageInfo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        device.mojom.MtpManager_GetStorageInfoFromDevice_ParamsSpec.$,
        device.mojom.MtpManager_GetStorageInfoFromDevice_ResponseParamsSpec.$,
        impl.getStorageInfoFromDevice.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        device.mojom.MtpManager_OpenStorage_ParamsSpec.$,
        device.mojom.MtpManager_OpenStorage_ResponseParamsSpec.$,
        impl.openStorage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        device.mojom.MtpManager_CloseStorage_ParamsSpec.$,
        device.mojom.MtpManager_CloseStorage_ResponseParamsSpec.$,
        impl.closeStorage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        device.mojom.MtpManager_CreateDirectory_ParamsSpec.$,
        device.mojom.MtpManager_CreateDirectory_ResponseParamsSpec.$,
        impl.createDirectory.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        device.mojom.MtpManager_ReadDirectoryEntryIds_ParamsSpec.$,
        device.mojom.MtpManager_ReadDirectoryEntryIds_ResponseParamsSpec.$,
        impl.readDirectoryEntryIds.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        device.mojom.MtpManager_ReadFileChunk_ParamsSpec.$,
        device.mojom.MtpManager_ReadFileChunk_ResponseParamsSpec.$,
        impl.readFileChunk.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        device.mojom.MtpManager_GetFileInfo_ParamsSpec.$,
        device.mojom.MtpManager_GetFileInfo_ResponseParamsSpec.$,
        impl.getFileInfo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        device.mojom.MtpManager_RenameObject_ParamsSpec.$,
        device.mojom.MtpManager_RenameObject_ResponseParamsSpec.$,
        impl.renameObject.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        device.mojom.MtpManager_CopyFileFromLocal_ParamsSpec.$,
        device.mojom.MtpManager_CopyFileFromLocal_ResponseParamsSpec.$,
        impl.copyFileFromLocal.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        device.mojom.MtpManager_DeleteObject_ParamsSpec.$,
        device.mojom.MtpManager_DeleteObject_ResponseParamsSpec.$,
        impl.deleteObject.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
device.mojom.MtpManager = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.MtpManager";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!device.mojom.MtpManagerRemote}
   * @export
   */
  static getRemote() {
    let remote = new device.mojom.MtpManagerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the MtpManager
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
device.mojom.MtpManagerCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      device.mojom.MtpManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.MtpManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.enumerateStoragesAndSetClient =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        device.mojom.MtpManager_EnumerateStoragesAndSetClient_ParamsSpec.$,
        device.mojom.MtpManager_EnumerateStoragesAndSetClient_ResponseParamsSpec.$,
        this.enumerateStoragesAndSetClient.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getStorageInfo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        device.mojom.MtpManager_GetStorageInfo_ParamsSpec.$,
        device.mojom.MtpManager_GetStorageInfo_ResponseParamsSpec.$,
        this.getStorageInfo.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getStorageInfoFromDevice =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        device.mojom.MtpManager_GetStorageInfoFromDevice_ParamsSpec.$,
        device.mojom.MtpManager_GetStorageInfoFromDevice_ResponseParamsSpec.$,
        this.getStorageInfoFromDevice.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.openStorage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        device.mojom.MtpManager_OpenStorage_ParamsSpec.$,
        device.mojom.MtpManager_OpenStorage_ResponseParamsSpec.$,
        this.openStorage.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.closeStorage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        device.mojom.MtpManager_CloseStorage_ParamsSpec.$,
        device.mojom.MtpManager_CloseStorage_ResponseParamsSpec.$,
        this.closeStorage.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createDirectory =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        device.mojom.MtpManager_CreateDirectory_ParamsSpec.$,
        device.mojom.MtpManager_CreateDirectory_ResponseParamsSpec.$,
        this.createDirectory.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.readDirectoryEntryIds =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        device.mojom.MtpManager_ReadDirectoryEntryIds_ParamsSpec.$,
        device.mojom.MtpManager_ReadDirectoryEntryIds_ResponseParamsSpec.$,
        this.readDirectoryEntryIds.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.readFileChunk =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        device.mojom.MtpManager_ReadFileChunk_ParamsSpec.$,
        device.mojom.MtpManager_ReadFileChunk_ResponseParamsSpec.$,
        this.readFileChunk.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getFileInfo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        device.mojom.MtpManager_GetFileInfo_ParamsSpec.$,
        device.mojom.MtpManager_GetFileInfo_ResponseParamsSpec.$,
        this.getFileInfo.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.renameObject =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        device.mojom.MtpManager_RenameObject_ParamsSpec.$,
        device.mojom.MtpManager_RenameObject_ResponseParamsSpec.$,
        this.renameObject.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.copyFileFromLocal =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        device.mojom.MtpManager_CopyFileFromLocal_ParamsSpec.$,
        device.mojom.MtpManager_CopyFileFromLocal_ResponseParamsSpec.$,
        this.copyFileFromLocal.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.deleteObject =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        device.mojom.MtpManager_DeleteObject_ParamsSpec.$,
        device.mojom.MtpManager_DeleteObject_ResponseParamsSpec.$,
        this.deleteObject.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('device.mojom.MtpManagerClient_StorageAttached_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.MtpManagerClient_StorageAttached_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.MtpManagerClient_StorageDetached_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.MtpManagerClient_StorageDetached_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.MtpManager_EnumerateStoragesAndSetClient_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.MtpManager_EnumerateStoragesAndSetClient_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.MtpManager_EnumerateStoragesAndSetClient_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.MtpManager_EnumerateStoragesAndSetClient_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.MtpManager_GetStorageInfo_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.MtpManager_GetStorageInfo_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.MtpManager_GetStorageInfo_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.MtpManager_GetStorageInfo_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.MtpManager_GetStorageInfoFromDevice_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.MtpManager_GetStorageInfoFromDevice_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.MtpManager_GetStorageInfoFromDevice_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.MtpManager_GetStorageInfoFromDevice_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.MtpManager_OpenStorage_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.MtpManager_OpenStorage_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.MtpManager_OpenStorage_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.MtpManager_OpenStorage_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.MtpManager_CloseStorage_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.MtpManager_CloseStorage_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.MtpManager_CloseStorage_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.MtpManager_CloseStorage_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.MtpManager_CreateDirectory_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.MtpManager_CreateDirectory_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.MtpManager_CreateDirectory_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.MtpManager_CreateDirectory_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.MtpManager_ReadDirectoryEntryIds_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.MtpManager_ReadDirectoryEntryIds_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.MtpManager_ReadDirectoryEntryIds_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.MtpManager_ReadDirectoryEntryIds_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.MtpManager_ReadFileChunk_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.MtpManager_ReadFileChunk_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.MtpManager_ReadFileChunk_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.MtpManager_ReadFileChunk_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.MtpManager_GetFileInfo_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.MtpManager_GetFileInfo_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.MtpManager_GetFileInfo_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.MtpManager_GetFileInfo_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.MtpManager_RenameObject_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.MtpManager_RenameObject_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.MtpManager_RenameObject_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.MtpManager_RenameObject_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.MtpManager_CopyFileFromLocal_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.MtpManager_CopyFileFromLocal_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.MtpManager_CopyFileFromLocal_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.MtpManager_CopyFileFromLocal_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.MtpManager_DeleteObject_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.MtpManager_DeleteObject_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.MtpManager_DeleteObject_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.MtpManager_DeleteObject_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    device.mojom.MtpManagerClient_StorageAttached_ParamsSpec.$,
    'MtpManagerClient_StorageAttached_Params',
    [
      mojo.internal.StructField(
        'storageInfo', 0,
        0,
        device.mojom.MtpStorageInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.MtpManagerClient_StorageAttached_Params');

/** @record */
device.mojom.MtpManagerClient_StorageAttached_Params = class {
  constructor() {
    /** @export { !device.mojom.MtpStorageInfo } */
    this.storageInfo;
  }
};



mojo.internal.Struct(
    device.mojom.MtpManagerClient_StorageDetached_ParamsSpec.$,
    'MtpManagerClient_StorageDetached_Params',
    [
      mojo.internal.StructField(
        'storageName', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.MtpManagerClient_StorageDetached_Params');

/** @record */
device.mojom.MtpManagerClient_StorageDetached_Params = class {
  constructor() {
    /** @export { !string } */
    this.storageName;
  }
};



mojo.internal.Struct(
    device.mojom.MtpManager_EnumerateStoragesAndSetClient_ParamsSpec.$,
    'MtpManager_EnumerateStoragesAndSetClient_Params',
    [
      mojo.internal.StructField(
        'client', 0,
        0,
        mojo.internal.AssociatedInterfaceProxy(device.mojom.MtpManagerClientRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.MtpManager_EnumerateStoragesAndSetClient_Params');

/** @record */
device.mojom.MtpManager_EnumerateStoragesAndSetClient_Params = class {
  constructor() {
    /** @export { !Object } */
    this.client;
  }
};



mojo.internal.Struct(
    device.mojom.MtpManager_EnumerateStoragesAndSetClient_ResponseParamsSpec.$,
    'MtpManager_EnumerateStoragesAndSetClient_ResponseParams',
    [
      mojo.internal.StructField(
        'storages', 0,
        0,
        mojo.internal.Array(device.mojom.MtpStorageInfoSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.MtpManager_EnumerateStoragesAndSetClient_ResponseParams');

/** @record */
device.mojom.MtpManager_EnumerateStoragesAndSetClient_ResponseParams = class {
  constructor() {
    /** @export { !Array<!device.mojom.MtpStorageInfo> } */
    this.storages;
  }
};



mojo.internal.Struct(
    device.mojom.MtpManager_GetStorageInfo_ParamsSpec.$,
    'MtpManager_GetStorageInfo_Params',
    [
      mojo.internal.StructField(
        'storageName', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.MtpManager_GetStorageInfo_Params');

/** @record */
device.mojom.MtpManager_GetStorageInfo_Params = class {
  constructor() {
    /** @export { !string } */
    this.storageName;
  }
};



mojo.internal.Struct(
    device.mojom.MtpManager_GetStorageInfo_ResponseParamsSpec.$,
    'MtpManager_GetStorageInfo_ResponseParams',
    [
      mojo.internal.StructField(
        'storageInfo', 0,
        0,
        device.mojom.MtpStorageInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.MtpManager_GetStorageInfo_ResponseParams');

/** @record */
device.mojom.MtpManager_GetStorageInfo_ResponseParams = class {
  constructor() {
    /** @export { !device.mojom.MtpStorageInfo } */
    this.storageInfo;
  }
};



mojo.internal.Struct(
    device.mojom.MtpManager_GetStorageInfoFromDevice_ParamsSpec.$,
    'MtpManager_GetStorageInfoFromDevice_Params',
    [
      mojo.internal.StructField(
        'storageName', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.MtpManager_GetStorageInfoFromDevice_Params');

/** @record */
device.mojom.MtpManager_GetStorageInfoFromDevice_Params = class {
  constructor() {
    /** @export { !string } */
    this.storageName;
  }
};



mojo.internal.Struct(
    device.mojom.MtpManager_GetStorageInfoFromDevice_ResponseParamsSpec.$,
    'MtpManager_GetStorageInfoFromDevice_ResponseParams',
    [
      mojo.internal.StructField(
        'storageInfo', 0,
        0,
        device.mojom.MtpStorageInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'error', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('device.mojom.MtpManager_GetStorageInfoFromDevice_ResponseParams');

/** @record */
device.mojom.MtpManager_GetStorageInfoFromDevice_ResponseParams = class {
  constructor() {
    /** @export { !device.mojom.MtpStorageInfo } */
    this.storageInfo;
    /** @export { !boolean } */
    this.error;
  }
};



mojo.internal.Struct(
    device.mojom.MtpManager_OpenStorage_ParamsSpec.$,
    'MtpManager_OpenStorage_Params',
    [
      mojo.internal.StructField(
        'storageName', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'mode', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('device.mojom.MtpManager_OpenStorage_Params');

/** @record */
device.mojom.MtpManager_OpenStorage_Params = class {
  constructor() {
    /** @export { !string } */
    this.storageName;
    /** @export { !string } */
    this.mode;
  }
};



mojo.internal.Struct(
    device.mojom.MtpManager_OpenStorage_ResponseParamsSpec.$,
    'MtpManager_OpenStorage_ResponseParams',
    [
      mojo.internal.StructField(
        'storageHandle', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'error', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('device.mojom.MtpManager_OpenStorage_ResponseParams');

/** @record */
device.mojom.MtpManager_OpenStorage_ResponseParams = class {
  constructor() {
    /** @export { !string } */
    this.storageHandle;
    /** @export { !boolean } */
    this.error;
  }
};



mojo.internal.Struct(
    device.mojom.MtpManager_CloseStorage_ParamsSpec.$,
    'MtpManager_CloseStorage_Params',
    [
      mojo.internal.StructField(
        'storageHandle', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.MtpManager_CloseStorage_Params');

/** @record */
device.mojom.MtpManager_CloseStorage_Params = class {
  constructor() {
    /** @export { !string } */
    this.storageHandle;
  }
};



mojo.internal.Struct(
    device.mojom.MtpManager_CloseStorage_ResponseParamsSpec.$,
    'MtpManager_CloseStorage_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.MtpManager_CloseStorage_ResponseParams');

/** @record */
device.mojom.MtpManager_CloseStorage_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.error;
  }
};



mojo.internal.Struct(
    device.mojom.MtpManager_CreateDirectory_ParamsSpec.$,
    'MtpManager_CreateDirectory_Params',
    [
      mojo.internal.StructField(
        'storageHandle', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'parentId', 8,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'directoryName', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('device.mojom.MtpManager_CreateDirectory_Params');

/** @record */
device.mojom.MtpManager_CreateDirectory_Params = class {
  constructor() {
    /** @export { !string } */
    this.storageHandle;
    /** @export { !number } */
    this.parentId;
    /** @export { !string } */
    this.directoryName;
  }
};



mojo.internal.Struct(
    device.mojom.MtpManager_CreateDirectory_ResponseParamsSpec.$,
    'MtpManager_CreateDirectory_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.MtpManager_CreateDirectory_ResponseParams');

/** @record */
device.mojom.MtpManager_CreateDirectory_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.error;
  }
};



mojo.internal.Struct(
    device.mojom.MtpManager_ReadDirectoryEntryIds_ParamsSpec.$,
    'MtpManager_ReadDirectoryEntryIds_Params',
    [
      mojo.internal.StructField(
        'storageHandle', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'fileId', 8,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('device.mojom.MtpManager_ReadDirectoryEntryIds_Params');

/** @record */
device.mojom.MtpManager_ReadDirectoryEntryIds_Params = class {
  constructor() {
    /** @export { !string } */
    this.storageHandle;
    /** @export { !number } */
    this.fileId;
  }
};



mojo.internal.Struct(
    device.mojom.MtpManager_ReadDirectoryEntryIds_ResponseParamsSpec.$,
    'MtpManager_ReadDirectoryEntryIds_ResponseParams',
    [
      mojo.internal.StructField(
        'fileIds', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint32, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'error', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('device.mojom.MtpManager_ReadDirectoryEntryIds_ResponseParams');

/** @record */
device.mojom.MtpManager_ReadDirectoryEntryIds_ResponseParams = class {
  constructor() {
    /** @export { !Array<!number> } */
    this.fileIds;
    /** @export { !boolean } */
    this.error;
  }
};



mojo.internal.Struct(
    device.mojom.MtpManager_ReadFileChunk_ParamsSpec.$,
    'MtpManager_ReadFileChunk_Params',
    [
      mojo.internal.StructField(
        'storageHandle', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'fileId', 8,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'offset', 12,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'count', 16,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('device.mojom.MtpManager_ReadFileChunk_Params');

/** @record */
device.mojom.MtpManager_ReadFileChunk_Params = class {
  constructor() {
    /** @export { !string } */
    this.storageHandle;
    /** @export { !number } */
    this.fileId;
    /** @export { !number } */
    this.offset;
    /** @export { !number } */
    this.count;
  }
};



mojo.internal.Struct(
    device.mojom.MtpManager_ReadFileChunk_ResponseParamsSpec.$,
    'MtpManager_ReadFileChunk_ResponseParams',
    [
      mojo.internal.StructField(
        'data', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'error', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('device.mojom.MtpManager_ReadFileChunk_ResponseParams');

/** @record */
device.mojom.MtpManager_ReadFileChunk_ResponseParams = class {
  constructor() {
    /** @export { !string } */
    this.data;
    /** @export { !boolean } */
    this.error;
  }
};



mojo.internal.Struct(
    device.mojom.MtpManager_GetFileInfo_ParamsSpec.$,
    'MtpManager_GetFileInfo_Params',
    [
      mojo.internal.StructField(
        'storageHandle', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'fileIds', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint32, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('device.mojom.MtpManager_GetFileInfo_Params');

/** @record */
device.mojom.MtpManager_GetFileInfo_Params = class {
  constructor() {
    /** @export { !string } */
    this.storageHandle;
    /** @export { !Array<!number> } */
    this.fileIds;
  }
};



mojo.internal.Struct(
    device.mojom.MtpManager_GetFileInfo_ResponseParamsSpec.$,
    'MtpManager_GetFileInfo_ResponseParams',
    [
      mojo.internal.StructField(
        'fileEntries', 0,
        0,
        mojo.internal.Array(device.mojom.MtpFileEntrySpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'error', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('device.mojom.MtpManager_GetFileInfo_ResponseParams');

/** @record */
device.mojom.MtpManager_GetFileInfo_ResponseParams = class {
  constructor() {
    /** @export { !Array<!device.mojom.MtpFileEntry> } */
    this.fileEntries;
    /** @export { !boolean } */
    this.error;
  }
};



mojo.internal.Struct(
    device.mojom.MtpManager_RenameObject_ParamsSpec.$,
    'MtpManager_RenameObject_Params',
    [
      mojo.internal.StructField(
        'storageHandle', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'objectId', 8,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'newName', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('device.mojom.MtpManager_RenameObject_Params');

/** @record */
device.mojom.MtpManager_RenameObject_Params = class {
  constructor() {
    /** @export { !string } */
    this.storageHandle;
    /** @export { !number } */
    this.objectId;
    /** @export { !string } */
    this.newName;
  }
};



mojo.internal.Struct(
    device.mojom.MtpManager_RenameObject_ResponseParamsSpec.$,
    'MtpManager_RenameObject_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.MtpManager_RenameObject_ResponseParams');

/** @record */
device.mojom.MtpManager_RenameObject_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.error;
  }
};



mojo.internal.Struct(
    device.mojom.MtpManager_CopyFileFromLocal_ParamsSpec.$,
    'MtpManager_CopyFileFromLocal_Params',
    [
      mojo.internal.StructField(
        'storageHandle', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sourceFileDescriptor', 8,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'parentId', 16,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'fileName', 24,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('device.mojom.MtpManager_CopyFileFromLocal_Params');

/** @record */
device.mojom.MtpManager_CopyFileFromLocal_Params = class {
  constructor() {
    /** @export { !string } */
    this.storageHandle;
    /** @export { !bigint } */
    this.sourceFileDescriptor;
    /** @export { !number } */
    this.parentId;
    /** @export { !string } */
    this.fileName;
  }
};



mojo.internal.Struct(
    device.mojom.MtpManager_CopyFileFromLocal_ResponseParamsSpec.$,
    'MtpManager_CopyFileFromLocal_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.MtpManager_CopyFileFromLocal_ResponseParams');

/** @record */
device.mojom.MtpManager_CopyFileFromLocal_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.error;
  }
};



mojo.internal.Struct(
    device.mojom.MtpManager_DeleteObject_ParamsSpec.$,
    'MtpManager_DeleteObject_Params',
    [
      mojo.internal.StructField(
        'storageHandle', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'objectId', 8,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('device.mojom.MtpManager_DeleteObject_Params');

/** @record */
device.mojom.MtpManager_DeleteObject_Params = class {
  constructor() {
    /** @export { !string } */
    this.storageHandle;
    /** @export { !number } */
    this.objectId;
  }
};



mojo.internal.Struct(
    device.mojom.MtpManager_DeleteObject_ResponseParamsSpec.$,
    'MtpManager_DeleteObject_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.MtpManager_DeleteObject_ResponseParams');

/** @record */
device.mojom.MtpManager_DeleteObject_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.error;
  }
};

