// services/device/public/mojom/mtp_manager.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/device/public/mojom/mtp_manager.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('device.mojom');
  var mtp_file_entry$ =
      mojo.internal.exposeNamespace('device.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/device/public/mojom/mtp_file_entry.mojom', 'mtp_file_entry.mojom.js');
  }
  var mtp_storage_info$ =
      mojo.internal.exposeNamespace('device.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/device/public/mojom/mtp_storage_info.mojom', 'mtp_storage_info.mojom.js');
  }



  function MtpManagerClient_StorageAttached_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MtpManagerClient_StorageAttached_Params.prototype.initDefaults_ = function() {
    this.storageInfo = null;
  };
  MtpManagerClient_StorageAttached_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MtpManagerClient_StorageAttached_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MtpManagerClient_StorageAttached_Params.storageInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, mtp_storage_info$.MtpStorageInfo, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MtpManagerClient_StorageAttached_Params.encodedSize = codec.kStructHeaderSize + 8;

  MtpManagerClient_StorageAttached_Params.decode = function(decoder) {
    var packed;
    var val = new MtpManagerClient_StorageAttached_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.storageInfo =
        decoder.decodeStructPointer(mtp_storage_info$.MtpStorageInfo);
    return val;
  };

  MtpManagerClient_StorageAttached_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MtpManagerClient_StorageAttached_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(mtp_storage_info$.MtpStorageInfo, val.storageInfo);
  };
  function MtpManagerClient_StorageDetached_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MtpManagerClient_StorageDetached_Params.prototype.initDefaults_ = function() {
    this.storageName = null;
  };
  MtpManagerClient_StorageDetached_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MtpManagerClient_StorageDetached_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MtpManagerClient_StorageDetached_Params.storageName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MtpManagerClient_StorageDetached_Params.encodedSize = codec.kStructHeaderSize + 8;

  MtpManagerClient_StorageDetached_Params.decode = function(decoder) {
    var packed;
    var val = new MtpManagerClient_StorageDetached_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.storageName =
        decoder.decodeStruct(codec.String);
    return val;
  };

  MtpManagerClient_StorageDetached_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MtpManagerClient_StorageDetached_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.storageName);
  };
  function MtpManager_EnumerateStoragesAndSetClient_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MtpManager_EnumerateStoragesAndSetClient_Params.prototype.initDefaults_ = function() {
    this.client = new associatedBindings.AssociatedInterfacePtrInfo();
  };
  MtpManager_EnumerateStoragesAndSetClient_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MtpManager_EnumerateStoragesAndSetClient_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MtpManager_EnumerateStoragesAndSetClient_Params.client
    err = messageValidator.validateAssociatedInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MtpManager_EnumerateStoragesAndSetClient_Params.encodedSize = codec.kStructHeaderSize + 8;

  MtpManager_EnumerateStoragesAndSetClient_Params.decode = function(decoder) {
    var packed;
    var val = new MtpManager_EnumerateStoragesAndSetClient_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.client =
        decoder.decodeStruct(codec.AssociatedInterfacePtrInfo);
    return val;
  };

  MtpManager_EnumerateStoragesAndSetClient_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MtpManager_EnumerateStoragesAndSetClient_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.AssociatedInterfacePtrInfo, val.client);
  };
  function MtpManager_EnumerateStoragesAndSetClient_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MtpManager_EnumerateStoragesAndSetClient_ResponseParams.prototype.initDefaults_ = function() {
    this.storages = null;
  };
  MtpManager_EnumerateStoragesAndSetClient_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MtpManager_EnumerateStoragesAndSetClient_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MtpManager_EnumerateStoragesAndSetClient_ResponseParams.storages
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(mtp_storage_info$.MtpStorageInfo), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MtpManager_EnumerateStoragesAndSetClient_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  MtpManager_EnumerateStoragesAndSetClient_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new MtpManager_EnumerateStoragesAndSetClient_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.storages =
        decoder.decodeArrayPointer(new codec.PointerTo(mtp_storage_info$.MtpStorageInfo));
    return val;
  };

  MtpManager_EnumerateStoragesAndSetClient_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MtpManager_EnumerateStoragesAndSetClient_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(mtp_storage_info$.MtpStorageInfo), val.storages);
  };
  function MtpManager_GetStorageInfo_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MtpManager_GetStorageInfo_Params.prototype.initDefaults_ = function() {
    this.storageName = null;
  };
  MtpManager_GetStorageInfo_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MtpManager_GetStorageInfo_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MtpManager_GetStorageInfo_Params.storageName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MtpManager_GetStorageInfo_Params.encodedSize = codec.kStructHeaderSize + 8;

  MtpManager_GetStorageInfo_Params.decode = function(decoder) {
    var packed;
    var val = new MtpManager_GetStorageInfo_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.storageName =
        decoder.decodeStruct(codec.String);
    return val;
  };

  MtpManager_GetStorageInfo_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MtpManager_GetStorageInfo_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.storageName);
  };
  function MtpManager_GetStorageInfo_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MtpManager_GetStorageInfo_ResponseParams.prototype.initDefaults_ = function() {
    this.storageInfo = null;
  };
  MtpManager_GetStorageInfo_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MtpManager_GetStorageInfo_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MtpManager_GetStorageInfo_ResponseParams.storageInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, mtp_storage_info$.MtpStorageInfo, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MtpManager_GetStorageInfo_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  MtpManager_GetStorageInfo_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new MtpManager_GetStorageInfo_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.storageInfo =
        decoder.decodeStructPointer(mtp_storage_info$.MtpStorageInfo);
    return val;
  };

  MtpManager_GetStorageInfo_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MtpManager_GetStorageInfo_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(mtp_storage_info$.MtpStorageInfo, val.storageInfo);
  };
  function MtpManager_GetStorageInfoFromDevice_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MtpManager_GetStorageInfoFromDevice_Params.prototype.initDefaults_ = function() {
    this.storageName = null;
  };
  MtpManager_GetStorageInfoFromDevice_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MtpManager_GetStorageInfoFromDevice_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MtpManager_GetStorageInfoFromDevice_Params.storageName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MtpManager_GetStorageInfoFromDevice_Params.encodedSize = codec.kStructHeaderSize + 8;

  MtpManager_GetStorageInfoFromDevice_Params.decode = function(decoder) {
    var packed;
    var val = new MtpManager_GetStorageInfoFromDevice_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.storageName =
        decoder.decodeStruct(codec.String);
    return val;
  };

  MtpManager_GetStorageInfoFromDevice_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MtpManager_GetStorageInfoFromDevice_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.storageName);
  };
  function MtpManager_GetStorageInfoFromDevice_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MtpManager_GetStorageInfoFromDevice_ResponseParams.prototype.initDefaults_ = function() {
    this.storageInfo = null;
    this.error = false;
  };
  MtpManager_GetStorageInfoFromDevice_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MtpManager_GetStorageInfoFromDevice_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MtpManager_GetStorageInfoFromDevice_ResponseParams.storageInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, mtp_storage_info$.MtpStorageInfo, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  MtpManager_GetStorageInfoFromDevice_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  MtpManager_GetStorageInfoFromDevice_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new MtpManager_GetStorageInfoFromDevice_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.storageInfo =
        decoder.decodeStructPointer(mtp_storage_info$.MtpStorageInfo);
    packed = decoder.readUint8();
    val.error = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MtpManager_GetStorageInfoFromDevice_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MtpManager_GetStorageInfoFromDevice_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(mtp_storage_info$.MtpStorageInfo, val.storageInfo);
    packed = 0;
    packed |= (val.error & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MtpManager_OpenStorage_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MtpManager_OpenStorage_Params.prototype.initDefaults_ = function() {
    this.storageName = null;
    this.mode = null;
  };
  MtpManager_OpenStorage_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MtpManager_OpenStorage_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MtpManager_OpenStorage_Params.storageName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate MtpManager_OpenStorage_Params.mode
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MtpManager_OpenStorage_Params.encodedSize = codec.kStructHeaderSize + 16;

  MtpManager_OpenStorage_Params.decode = function(decoder) {
    var packed;
    var val = new MtpManager_OpenStorage_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.storageName =
        decoder.decodeStruct(codec.String);
    val.mode =
        decoder.decodeStruct(codec.String);
    return val;
  };

  MtpManager_OpenStorage_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MtpManager_OpenStorage_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.storageName);
    encoder.encodeStruct(codec.String, val.mode);
  };
  function MtpManager_OpenStorage_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MtpManager_OpenStorage_ResponseParams.prototype.initDefaults_ = function() {
    this.storageHandle = null;
    this.error = false;
  };
  MtpManager_OpenStorage_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MtpManager_OpenStorage_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MtpManager_OpenStorage_ResponseParams.storageHandle
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  MtpManager_OpenStorage_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  MtpManager_OpenStorage_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new MtpManager_OpenStorage_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.storageHandle =
        decoder.decodeStruct(codec.String);
    packed = decoder.readUint8();
    val.error = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MtpManager_OpenStorage_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MtpManager_OpenStorage_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.storageHandle);
    packed = 0;
    packed |= (val.error & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MtpManager_CloseStorage_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MtpManager_CloseStorage_Params.prototype.initDefaults_ = function() {
    this.storageHandle = null;
  };
  MtpManager_CloseStorage_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MtpManager_CloseStorage_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MtpManager_CloseStorage_Params.storageHandle
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MtpManager_CloseStorage_Params.encodedSize = codec.kStructHeaderSize + 8;

  MtpManager_CloseStorage_Params.decode = function(decoder) {
    var packed;
    var val = new MtpManager_CloseStorage_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.storageHandle =
        decoder.decodeStruct(codec.String);
    return val;
  };

  MtpManager_CloseStorage_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MtpManager_CloseStorage_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.storageHandle);
  };
  function MtpManager_CloseStorage_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MtpManager_CloseStorage_ResponseParams.prototype.initDefaults_ = function() {
    this.error = false;
  };
  MtpManager_CloseStorage_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MtpManager_CloseStorage_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  MtpManager_CloseStorage_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  MtpManager_CloseStorage_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new MtpManager_CloseStorage_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.error = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MtpManager_CloseStorage_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MtpManager_CloseStorage_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.error & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MtpManager_CreateDirectory_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MtpManager_CreateDirectory_Params.prototype.initDefaults_ = function() {
    this.storageHandle = null;
    this.parentId = 0;
    this.directoryName = null;
  };
  MtpManager_CreateDirectory_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MtpManager_CreateDirectory_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MtpManager_CreateDirectory_Params.storageHandle
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;



    // validate MtpManager_CreateDirectory_Params.directoryName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MtpManager_CreateDirectory_Params.encodedSize = codec.kStructHeaderSize + 24;

  MtpManager_CreateDirectory_Params.decode = function(decoder) {
    var packed;
    var val = new MtpManager_CreateDirectory_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.storageHandle =
        decoder.decodeStruct(codec.String);
    val.parentId =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.directoryName =
        decoder.decodeStruct(codec.String);
    return val;
  };

  MtpManager_CreateDirectory_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MtpManager_CreateDirectory_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.storageHandle);
    encoder.encodeStruct(codec.Uint32, val.parentId);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.directoryName);
  };
  function MtpManager_CreateDirectory_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MtpManager_CreateDirectory_ResponseParams.prototype.initDefaults_ = function() {
    this.error = false;
  };
  MtpManager_CreateDirectory_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MtpManager_CreateDirectory_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  MtpManager_CreateDirectory_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  MtpManager_CreateDirectory_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new MtpManager_CreateDirectory_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.error = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MtpManager_CreateDirectory_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MtpManager_CreateDirectory_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.error & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MtpManager_ReadDirectoryEntryIds_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MtpManager_ReadDirectoryEntryIds_Params.prototype.initDefaults_ = function() {
    this.storageHandle = null;
    this.fileId = 0;
  };
  MtpManager_ReadDirectoryEntryIds_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MtpManager_ReadDirectoryEntryIds_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MtpManager_ReadDirectoryEntryIds_Params.storageHandle
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  MtpManager_ReadDirectoryEntryIds_Params.encodedSize = codec.kStructHeaderSize + 16;

  MtpManager_ReadDirectoryEntryIds_Params.decode = function(decoder) {
    var packed;
    var val = new MtpManager_ReadDirectoryEntryIds_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.storageHandle =
        decoder.decodeStruct(codec.String);
    val.fileId =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MtpManager_ReadDirectoryEntryIds_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MtpManager_ReadDirectoryEntryIds_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.storageHandle);
    encoder.encodeStruct(codec.Uint32, val.fileId);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MtpManager_ReadDirectoryEntryIds_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MtpManager_ReadDirectoryEntryIds_ResponseParams.prototype.initDefaults_ = function() {
    this.fileIds = null;
    this.error = false;
  };
  MtpManager_ReadDirectoryEntryIds_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MtpManager_ReadDirectoryEntryIds_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MtpManager_ReadDirectoryEntryIds_ResponseParams.fileIds
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 4, codec.Uint32, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  MtpManager_ReadDirectoryEntryIds_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  MtpManager_ReadDirectoryEntryIds_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new MtpManager_ReadDirectoryEntryIds_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.fileIds =
        decoder.decodeArrayPointer(codec.Uint32);
    packed = decoder.readUint8();
    val.error = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MtpManager_ReadDirectoryEntryIds_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MtpManager_ReadDirectoryEntryIds_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.Uint32, val.fileIds);
    packed = 0;
    packed |= (val.error & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MtpManager_ReadFileChunk_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MtpManager_ReadFileChunk_Params.prototype.initDefaults_ = function() {
    this.storageHandle = null;
    this.fileId = 0;
    this.offset = 0;
    this.count = 0;
  };
  MtpManager_ReadFileChunk_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MtpManager_ReadFileChunk_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MtpManager_ReadFileChunk_Params.storageHandle
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;




    return validator.validationError.NONE;
  };

  MtpManager_ReadFileChunk_Params.encodedSize = codec.kStructHeaderSize + 24;

  MtpManager_ReadFileChunk_Params.decode = function(decoder) {
    var packed;
    var val = new MtpManager_ReadFileChunk_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.storageHandle =
        decoder.decodeStruct(codec.String);
    val.fileId =
        decoder.decodeStruct(codec.Uint32);
    val.offset =
        decoder.decodeStruct(codec.Uint32);
    val.count =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MtpManager_ReadFileChunk_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MtpManager_ReadFileChunk_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.storageHandle);
    encoder.encodeStruct(codec.Uint32, val.fileId);
    encoder.encodeStruct(codec.Uint32, val.offset);
    encoder.encodeStruct(codec.Uint32, val.count);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MtpManager_ReadFileChunk_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MtpManager_ReadFileChunk_ResponseParams.prototype.initDefaults_ = function() {
    this.data = null;
    this.error = false;
  };
  MtpManager_ReadFileChunk_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MtpManager_ReadFileChunk_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MtpManager_ReadFileChunk_ResponseParams.data
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  MtpManager_ReadFileChunk_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  MtpManager_ReadFileChunk_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new MtpManager_ReadFileChunk_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.data =
        decoder.decodeStruct(codec.String);
    packed = decoder.readUint8();
    val.error = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MtpManager_ReadFileChunk_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MtpManager_ReadFileChunk_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.data);
    packed = 0;
    packed |= (val.error & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MtpManager_GetFileInfo_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MtpManager_GetFileInfo_Params.prototype.initDefaults_ = function() {
    this.storageHandle = null;
    this.fileIds = null;
  };
  MtpManager_GetFileInfo_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MtpManager_GetFileInfo_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MtpManager_GetFileInfo_Params.storageHandle
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate MtpManager_GetFileInfo_Params.fileIds
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 4, codec.Uint32, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MtpManager_GetFileInfo_Params.encodedSize = codec.kStructHeaderSize + 16;

  MtpManager_GetFileInfo_Params.decode = function(decoder) {
    var packed;
    var val = new MtpManager_GetFileInfo_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.storageHandle =
        decoder.decodeStruct(codec.String);
    val.fileIds =
        decoder.decodeArrayPointer(codec.Uint32);
    return val;
  };

  MtpManager_GetFileInfo_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MtpManager_GetFileInfo_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.storageHandle);
    encoder.encodeArrayPointer(codec.Uint32, val.fileIds);
  };
  function MtpManager_GetFileInfo_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MtpManager_GetFileInfo_ResponseParams.prototype.initDefaults_ = function() {
    this.fileEntries = null;
    this.error = false;
  };
  MtpManager_GetFileInfo_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MtpManager_GetFileInfo_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MtpManager_GetFileInfo_ResponseParams.fileEntries
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(mtp_file_entry$.MtpFileEntry), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  MtpManager_GetFileInfo_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  MtpManager_GetFileInfo_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new MtpManager_GetFileInfo_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.fileEntries =
        decoder.decodeArrayPointer(new codec.PointerTo(mtp_file_entry$.MtpFileEntry));
    packed = decoder.readUint8();
    val.error = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MtpManager_GetFileInfo_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MtpManager_GetFileInfo_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(mtp_file_entry$.MtpFileEntry), val.fileEntries);
    packed = 0;
    packed |= (val.error & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MtpManager_RenameObject_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MtpManager_RenameObject_Params.prototype.initDefaults_ = function() {
    this.storageHandle = null;
    this.objectId = 0;
    this.newName = null;
  };
  MtpManager_RenameObject_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MtpManager_RenameObject_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MtpManager_RenameObject_Params.storageHandle
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;



    // validate MtpManager_RenameObject_Params.newName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MtpManager_RenameObject_Params.encodedSize = codec.kStructHeaderSize + 24;

  MtpManager_RenameObject_Params.decode = function(decoder) {
    var packed;
    var val = new MtpManager_RenameObject_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.storageHandle =
        decoder.decodeStruct(codec.String);
    val.objectId =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.newName =
        decoder.decodeStruct(codec.String);
    return val;
  };

  MtpManager_RenameObject_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MtpManager_RenameObject_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.storageHandle);
    encoder.encodeStruct(codec.Uint32, val.objectId);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.newName);
  };
  function MtpManager_RenameObject_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MtpManager_RenameObject_ResponseParams.prototype.initDefaults_ = function() {
    this.error = false;
  };
  MtpManager_RenameObject_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MtpManager_RenameObject_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  MtpManager_RenameObject_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  MtpManager_RenameObject_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new MtpManager_RenameObject_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.error = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MtpManager_RenameObject_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MtpManager_RenameObject_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.error & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MtpManager_CopyFileFromLocal_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MtpManager_CopyFileFromLocal_Params.prototype.initDefaults_ = function() {
    this.storageHandle = null;
    this.sourceFileDescriptor = 0;
    this.parentId = 0;
    this.fileName = null;
  };
  MtpManager_CopyFileFromLocal_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MtpManager_CopyFileFromLocal_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MtpManager_CopyFileFromLocal_Params.storageHandle
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;




    // validate MtpManager_CopyFileFromLocal_Params.fileName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 24, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MtpManager_CopyFileFromLocal_Params.encodedSize = codec.kStructHeaderSize + 32;

  MtpManager_CopyFileFromLocal_Params.decode = function(decoder) {
    var packed;
    var val = new MtpManager_CopyFileFromLocal_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.storageHandle =
        decoder.decodeStruct(codec.String);
    val.sourceFileDescriptor =
        decoder.decodeStruct(codec.Int64);
    val.parentId =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.fileName =
        decoder.decodeStruct(codec.String);
    return val;
  };

  MtpManager_CopyFileFromLocal_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MtpManager_CopyFileFromLocal_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.storageHandle);
    encoder.encodeStruct(codec.Int64, val.sourceFileDescriptor);
    encoder.encodeStruct(codec.Uint32, val.parentId);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.fileName);
  };
  function MtpManager_CopyFileFromLocal_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MtpManager_CopyFileFromLocal_ResponseParams.prototype.initDefaults_ = function() {
    this.error = false;
  };
  MtpManager_CopyFileFromLocal_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MtpManager_CopyFileFromLocal_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  MtpManager_CopyFileFromLocal_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  MtpManager_CopyFileFromLocal_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new MtpManager_CopyFileFromLocal_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.error = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MtpManager_CopyFileFromLocal_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MtpManager_CopyFileFromLocal_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.error & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MtpManager_DeleteObject_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MtpManager_DeleteObject_Params.prototype.initDefaults_ = function() {
    this.storageHandle = null;
    this.objectId = 0;
  };
  MtpManager_DeleteObject_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MtpManager_DeleteObject_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MtpManager_DeleteObject_Params.storageHandle
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  MtpManager_DeleteObject_Params.encodedSize = codec.kStructHeaderSize + 16;

  MtpManager_DeleteObject_Params.decode = function(decoder) {
    var packed;
    var val = new MtpManager_DeleteObject_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.storageHandle =
        decoder.decodeStruct(codec.String);
    val.objectId =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MtpManager_DeleteObject_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MtpManager_DeleteObject_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.storageHandle);
    encoder.encodeStruct(codec.Uint32, val.objectId);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MtpManager_DeleteObject_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MtpManager_DeleteObject_ResponseParams.prototype.initDefaults_ = function() {
    this.error = false;
  };
  MtpManager_DeleteObject_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MtpManager_DeleteObject_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  MtpManager_DeleteObject_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  MtpManager_DeleteObject_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new MtpManager_DeleteObject_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.error = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MtpManager_DeleteObject_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MtpManager_DeleteObject_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.error & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  var kMtpManagerClient_StorageAttached_Name = 0;
  var kMtpManagerClient_StorageDetached_Name = 1;

  function MtpManagerClientPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(MtpManagerClient,
                                                   handleOrPtrInfo);
  }

  function MtpManagerClientAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        MtpManagerClient, associatedInterfacePtrInfo);
  }

  MtpManagerClientAssociatedPtr.prototype =
      Object.create(MtpManagerClientPtr.prototype);
  MtpManagerClientAssociatedPtr.prototype.constructor =
      MtpManagerClientAssociatedPtr;

  function MtpManagerClientProxy(receiver) {
    this.receiver_ = receiver;
  }
  MtpManagerClientPtr.prototype.storageAttached = function() {
    return MtpManagerClientProxy.prototype.storageAttached
        .apply(this.ptr.getProxy(), arguments);
  };

  MtpManagerClientProxy.prototype.storageAttached = function(storageInfo) {
    var params_ = new MtpManagerClient_StorageAttached_Params();
    params_.storageInfo = storageInfo;
    var builder = new codec.MessageV0Builder(
        kMtpManagerClient_StorageAttached_Name,
        codec.align(MtpManagerClient_StorageAttached_Params.encodedSize));
    builder.encodeStruct(MtpManagerClient_StorageAttached_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MtpManagerClientPtr.prototype.storageDetached = function() {
    return MtpManagerClientProxy.prototype.storageDetached
        .apply(this.ptr.getProxy(), arguments);
  };

  MtpManagerClientProxy.prototype.storageDetached = function(storageName) {
    var params_ = new MtpManagerClient_StorageDetached_Params();
    params_.storageName = storageName;
    var builder = new codec.MessageV0Builder(
        kMtpManagerClient_StorageDetached_Name,
        codec.align(MtpManagerClient_StorageDetached_Params.encodedSize));
    builder.encodeStruct(MtpManagerClient_StorageDetached_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function MtpManagerClientStub(delegate) {
    this.delegate_ = delegate;
  }
  MtpManagerClientStub.prototype.storageAttached = function(storageInfo) {
    return this.delegate_ && this.delegate_.storageAttached && this.delegate_.storageAttached(storageInfo);
  }
  MtpManagerClientStub.prototype.storageDetached = function(storageName) {
    return this.delegate_ && this.delegate_.storageDetached && this.delegate_.storageDetached(storageName);
  }

  MtpManagerClientStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kMtpManagerClient_StorageAttached_Name:
      var params = reader.decodeStruct(MtpManagerClient_StorageAttached_Params);
      this.storageAttached(params.storageInfo);
      return true;
    case kMtpManagerClient_StorageDetached_Name:
      var params = reader.decodeStruct(MtpManagerClient_StorageDetached_Params);
      this.storageDetached(params.storageName);
      return true;
    default:
      return false;
    }
  };

  MtpManagerClientStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateMtpManagerClientRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kMtpManagerClient_StorageAttached_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MtpManagerClient_StorageAttached_Params;
      break;
      case kMtpManagerClient_StorageDetached_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MtpManagerClient_StorageDetached_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateMtpManagerClientResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var MtpManagerClient = {
    name: 'device.mojom.MtpManagerClient',
    kVersion: 0,
    ptrClass: MtpManagerClientPtr,
    proxyClass: MtpManagerClientProxy,
    stubClass: MtpManagerClientStub,
    validateRequest: validateMtpManagerClientRequest,
    validateResponse: null,
  };
  MtpManagerClientStub.prototype.validator = validateMtpManagerClientRequest;
  MtpManagerClientProxy.prototype.validator = null;
  var kMtpManager_EnumerateStoragesAndSetClient_Name = 0;
  var kMtpManager_GetStorageInfo_Name = 1;
  var kMtpManager_GetStorageInfoFromDevice_Name = 2;
  var kMtpManager_OpenStorage_Name = 3;
  var kMtpManager_CloseStorage_Name = 4;
  var kMtpManager_CreateDirectory_Name = 5;
  var kMtpManager_ReadDirectoryEntryIds_Name = 6;
  var kMtpManager_ReadFileChunk_Name = 7;
  var kMtpManager_GetFileInfo_Name = 8;
  var kMtpManager_RenameObject_Name = 9;
  var kMtpManager_CopyFileFromLocal_Name = 10;
  var kMtpManager_DeleteObject_Name = 11;

  function MtpManagerPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(MtpManager,
                                                   handleOrPtrInfo);
  }

  function MtpManagerAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        MtpManager, associatedInterfacePtrInfo);
  }

  MtpManagerAssociatedPtr.prototype =
      Object.create(MtpManagerPtr.prototype);
  MtpManagerAssociatedPtr.prototype.constructor =
      MtpManagerAssociatedPtr;

  function MtpManagerProxy(receiver) {
    this.receiver_ = receiver;
  }
  MtpManagerPtr.prototype.enumerateStoragesAndSetClient = function() {
    return MtpManagerProxy.prototype.enumerateStoragesAndSetClient
        .apply(this.ptr.getProxy(), arguments);
  };

  MtpManagerProxy.prototype.enumerateStoragesAndSetClient = function(client) {
    var params_ = new MtpManager_EnumerateStoragesAndSetClient_Params();
    params_.client = client;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV2Builder(
          kMtpManager_EnumerateStoragesAndSetClient_Name,
          codec.align(MtpManager_EnumerateStoragesAndSetClient_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.setPayload(MtpManager_EnumerateStoragesAndSetClient_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(MtpManager_EnumerateStoragesAndSetClient_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  MtpManagerPtr.prototype.getStorageInfo = function() {
    return MtpManagerProxy.prototype.getStorageInfo
        .apply(this.ptr.getProxy(), arguments);
  };

  MtpManagerProxy.prototype.getStorageInfo = function(storageName) {
    var params_ = new MtpManager_GetStorageInfo_Params();
    params_.storageName = storageName;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kMtpManager_GetStorageInfo_Name,
          codec.align(MtpManager_GetStorageInfo_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(MtpManager_GetStorageInfo_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(MtpManager_GetStorageInfo_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  MtpManagerPtr.prototype.getStorageInfoFromDevice = function() {
    return MtpManagerProxy.prototype.getStorageInfoFromDevice
        .apply(this.ptr.getProxy(), arguments);
  };

  MtpManagerProxy.prototype.getStorageInfoFromDevice = function(storageName) {
    var params_ = new MtpManager_GetStorageInfoFromDevice_Params();
    params_.storageName = storageName;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kMtpManager_GetStorageInfoFromDevice_Name,
          codec.align(MtpManager_GetStorageInfoFromDevice_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(MtpManager_GetStorageInfoFromDevice_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(MtpManager_GetStorageInfoFromDevice_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  MtpManagerPtr.prototype.openStorage = function() {
    return MtpManagerProxy.prototype.openStorage
        .apply(this.ptr.getProxy(), arguments);
  };

  MtpManagerProxy.prototype.openStorage = function(storageName, mode) {
    var params_ = new MtpManager_OpenStorage_Params();
    params_.storageName = storageName;
    params_.mode = mode;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kMtpManager_OpenStorage_Name,
          codec.align(MtpManager_OpenStorage_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(MtpManager_OpenStorage_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(MtpManager_OpenStorage_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  MtpManagerPtr.prototype.closeStorage = function() {
    return MtpManagerProxy.prototype.closeStorage
        .apply(this.ptr.getProxy(), arguments);
  };

  MtpManagerProxy.prototype.closeStorage = function(storageHandle) {
    var params_ = new MtpManager_CloseStorage_Params();
    params_.storageHandle = storageHandle;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kMtpManager_CloseStorage_Name,
          codec.align(MtpManager_CloseStorage_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(MtpManager_CloseStorage_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(MtpManager_CloseStorage_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  MtpManagerPtr.prototype.createDirectory = function() {
    return MtpManagerProxy.prototype.createDirectory
        .apply(this.ptr.getProxy(), arguments);
  };

  MtpManagerProxy.prototype.createDirectory = function(storageHandle, parentId, directoryName) {
    var params_ = new MtpManager_CreateDirectory_Params();
    params_.storageHandle = storageHandle;
    params_.parentId = parentId;
    params_.directoryName = directoryName;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kMtpManager_CreateDirectory_Name,
          codec.align(MtpManager_CreateDirectory_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(MtpManager_CreateDirectory_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(MtpManager_CreateDirectory_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  MtpManagerPtr.prototype.readDirectoryEntryIds = function() {
    return MtpManagerProxy.prototype.readDirectoryEntryIds
        .apply(this.ptr.getProxy(), arguments);
  };

  MtpManagerProxy.prototype.readDirectoryEntryIds = function(storageHandle, fileId) {
    var params_ = new MtpManager_ReadDirectoryEntryIds_Params();
    params_.storageHandle = storageHandle;
    params_.fileId = fileId;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kMtpManager_ReadDirectoryEntryIds_Name,
          codec.align(MtpManager_ReadDirectoryEntryIds_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(MtpManager_ReadDirectoryEntryIds_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(MtpManager_ReadDirectoryEntryIds_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  MtpManagerPtr.prototype.readFileChunk = function() {
    return MtpManagerProxy.prototype.readFileChunk
        .apply(this.ptr.getProxy(), arguments);
  };

  MtpManagerProxy.prototype.readFileChunk = function(storageHandle, fileId, offset, count) {
    var params_ = new MtpManager_ReadFileChunk_Params();
    params_.storageHandle = storageHandle;
    params_.fileId = fileId;
    params_.offset = offset;
    params_.count = count;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kMtpManager_ReadFileChunk_Name,
          codec.align(MtpManager_ReadFileChunk_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(MtpManager_ReadFileChunk_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(MtpManager_ReadFileChunk_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  MtpManagerPtr.prototype.getFileInfo = function() {
    return MtpManagerProxy.prototype.getFileInfo
        .apply(this.ptr.getProxy(), arguments);
  };

  MtpManagerProxy.prototype.getFileInfo = function(storageHandle, fileIds) {
    var params_ = new MtpManager_GetFileInfo_Params();
    params_.storageHandle = storageHandle;
    params_.fileIds = fileIds;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kMtpManager_GetFileInfo_Name,
          codec.align(MtpManager_GetFileInfo_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(MtpManager_GetFileInfo_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(MtpManager_GetFileInfo_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  MtpManagerPtr.prototype.renameObject = function() {
    return MtpManagerProxy.prototype.renameObject
        .apply(this.ptr.getProxy(), arguments);
  };

  MtpManagerProxy.prototype.renameObject = function(storageHandle, objectId, newName) {
    var params_ = new MtpManager_RenameObject_Params();
    params_.storageHandle = storageHandle;
    params_.objectId = objectId;
    params_.newName = newName;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kMtpManager_RenameObject_Name,
          codec.align(MtpManager_RenameObject_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(MtpManager_RenameObject_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(MtpManager_RenameObject_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  MtpManagerPtr.prototype.copyFileFromLocal = function() {
    return MtpManagerProxy.prototype.copyFileFromLocal
        .apply(this.ptr.getProxy(), arguments);
  };

  MtpManagerProxy.prototype.copyFileFromLocal = function(storageHandle, sourceFileDescriptor, parentId, fileName) {
    var params_ = new MtpManager_CopyFileFromLocal_Params();
    params_.storageHandle = storageHandle;
    params_.sourceFileDescriptor = sourceFileDescriptor;
    params_.parentId = parentId;
    params_.fileName = fileName;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kMtpManager_CopyFileFromLocal_Name,
          codec.align(MtpManager_CopyFileFromLocal_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(MtpManager_CopyFileFromLocal_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(MtpManager_CopyFileFromLocal_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  MtpManagerPtr.prototype.deleteObject = function() {
    return MtpManagerProxy.prototype.deleteObject
        .apply(this.ptr.getProxy(), arguments);
  };

  MtpManagerProxy.prototype.deleteObject = function(storageHandle, objectId) {
    var params_ = new MtpManager_DeleteObject_Params();
    params_.storageHandle = storageHandle;
    params_.objectId = objectId;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kMtpManager_DeleteObject_Name,
          codec.align(MtpManager_DeleteObject_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(MtpManager_DeleteObject_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(MtpManager_DeleteObject_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function MtpManagerStub(delegate) {
    this.delegate_ = delegate;
  }
  MtpManagerStub.prototype.enumerateStoragesAndSetClient = function(client) {
    return this.delegate_ && this.delegate_.enumerateStoragesAndSetClient && this.delegate_.enumerateStoragesAndSetClient(client);
  }
  MtpManagerStub.prototype.getStorageInfo = function(storageName) {
    return this.delegate_ && this.delegate_.getStorageInfo && this.delegate_.getStorageInfo(storageName);
  }
  MtpManagerStub.prototype.getStorageInfoFromDevice = function(storageName) {
    return this.delegate_ && this.delegate_.getStorageInfoFromDevice && this.delegate_.getStorageInfoFromDevice(storageName);
  }
  MtpManagerStub.prototype.openStorage = function(storageName, mode) {
    return this.delegate_ && this.delegate_.openStorage && this.delegate_.openStorage(storageName, mode);
  }
  MtpManagerStub.prototype.closeStorage = function(storageHandle) {
    return this.delegate_ && this.delegate_.closeStorage && this.delegate_.closeStorage(storageHandle);
  }
  MtpManagerStub.prototype.createDirectory = function(storageHandle, parentId, directoryName) {
    return this.delegate_ && this.delegate_.createDirectory && this.delegate_.createDirectory(storageHandle, parentId, directoryName);
  }
  MtpManagerStub.prototype.readDirectoryEntryIds = function(storageHandle, fileId) {
    return this.delegate_ && this.delegate_.readDirectoryEntryIds && this.delegate_.readDirectoryEntryIds(storageHandle, fileId);
  }
  MtpManagerStub.prototype.readFileChunk = function(storageHandle, fileId, offset, count) {
    return this.delegate_ && this.delegate_.readFileChunk && this.delegate_.readFileChunk(storageHandle, fileId, offset, count);
  }
  MtpManagerStub.prototype.getFileInfo = function(storageHandle, fileIds) {
    return this.delegate_ && this.delegate_.getFileInfo && this.delegate_.getFileInfo(storageHandle, fileIds);
  }
  MtpManagerStub.prototype.renameObject = function(storageHandle, objectId, newName) {
    return this.delegate_ && this.delegate_.renameObject && this.delegate_.renameObject(storageHandle, objectId, newName);
  }
  MtpManagerStub.prototype.copyFileFromLocal = function(storageHandle, sourceFileDescriptor, parentId, fileName) {
    return this.delegate_ && this.delegate_.copyFileFromLocal && this.delegate_.copyFileFromLocal(storageHandle, sourceFileDescriptor, parentId, fileName);
  }
  MtpManagerStub.prototype.deleteObject = function(storageHandle, objectId) {
    return this.delegate_ && this.delegate_.deleteObject && this.delegate_.deleteObject(storageHandle, objectId);
  }

  MtpManagerStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  MtpManagerStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kMtpManager_EnumerateStoragesAndSetClient_Name:
      var params = reader.decodeStruct(MtpManager_EnumerateStoragesAndSetClient_Params);
      this.enumerateStoragesAndSetClient(params.client).then(function(response) {
        var responseParams =
            new MtpManager_EnumerateStoragesAndSetClient_ResponseParams();
        responseParams.storages = response.storages;
        var builder = new codec.MessageV2Builder(
            kMtpManager_EnumerateStoragesAndSetClient_Name,
            codec.align(MtpManager_EnumerateStoragesAndSetClient_ResponseParams
                .encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.setPayload(MtpManager_EnumerateStoragesAndSetClient_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kMtpManager_GetStorageInfo_Name:
      var params = reader.decodeStruct(MtpManager_GetStorageInfo_Params);
      this.getStorageInfo(params.storageName).then(function(response) {
        var responseParams =
            new MtpManager_GetStorageInfo_ResponseParams();
        responseParams.storageInfo = response.storageInfo;
        var builder = new codec.MessageV1Builder(
            kMtpManager_GetStorageInfo_Name,
            codec.align(MtpManager_GetStorageInfo_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(MtpManager_GetStorageInfo_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kMtpManager_GetStorageInfoFromDevice_Name:
      var params = reader.decodeStruct(MtpManager_GetStorageInfoFromDevice_Params);
      this.getStorageInfoFromDevice(params.storageName).then(function(response) {
        var responseParams =
            new MtpManager_GetStorageInfoFromDevice_ResponseParams();
        responseParams.storageInfo = response.storageInfo;
        responseParams.error = response.error;
        var builder = new codec.MessageV1Builder(
            kMtpManager_GetStorageInfoFromDevice_Name,
            codec.align(MtpManager_GetStorageInfoFromDevice_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(MtpManager_GetStorageInfoFromDevice_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kMtpManager_OpenStorage_Name:
      var params = reader.decodeStruct(MtpManager_OpenStorage_Params);
      this.openStorage(params.storageName, params.mode).then(function(response) {
        var responseParams =
            new MtpManager_OpenStorage_ResponseParams();
        responseParams.storageHandle = response.storageHandle;
        responseParams.error = response.error;
        var builder = new codec.MessageV1Builder(
            kMtpManager_OpenStorage_Name,
            codec.align(MtpManager_OpenStorage_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(MtpManager_OpenStorage_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kMtpManager_CloseStorage_Name:
      var params = reader.decodeStruct(MtpManager_CloseStorage_Params);
      this.closeStorage(params.storageHandle).then(function(response) {
        var responseParams =
            new MtpManager_CloseStorage_ResponseParams();
        responseParams.error = response.error;
        var builder = new codec.MessageV1Builder(
            kMtpManager_CloseStorage_Name,
            codec.align(MtpManager_CloseStorage_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(MtpManager_CloseStorage_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kMtpManager_CreateDirectory_Name:
      var params = reader.decodeStruct(MtpManager_CreateDirectory_Params);
      this.createDirectory(params.storageHandle, params.parentId, params.directoryName).then(function(response) {
        var responseParams =
            new MtpManager_CreateDirectory_ResponseParams();
        responseParams.error = response.error;
        var builder = new codec.MessageV1Builder(
            kMtpManager_CreateDirectory_Name,
            codec.align(MtpManager_CreateDirectory_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(MtpManager_CreateDirectory_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kMtpManager_ReadDirectoryEntryIds_Name:
      var params = reader.decodeStruct(MtpManager_ReadDirectoryEntryIds_Params);
      this.readDirectoryEntryIds(params.storageHandle, params.fileId).then(function(response) {
        var responseParams =
            new MtpManager_ReadDirectoryEntryIds_ResponseParams();
        responseParams.fileIds = response.fileIds;
        responseParams.error = response.error;
        var builder = new codec.MessageV1Builder(
            kMtpManager_ReadDirectoryEntryIds_Name,
            codec.align(MtpManager_ReadDirectoryEntryIds_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(MtpManager_ReadDirectoryEntryIds_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kMtpManager_ReadFileChunk_Name:
      var params = reader.decodeStruct(MtpManager_ReadFileChunk_Params);
      this.readFileChunk(params.storageHandle, params.fileId, params.offset, params.count).then(function(response) {
        var responseParams =
            new MtpManager_ReadFileChunk_ResponseParams();
        responseParams.data = response.data;
        responseParams.error = response.error;
        var builder = new codec.MessageV1Builder(
            kMtpManager_ReadFileChunk_Name,
            codec.align(MtpManager_ReadFileChunk_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(MtpManager_ReadFileChunk_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kMtpManager_GetFileInfo_Name:
      var params = reader.decodeStruct(MtpManager_GetFileInfo_Params);
      this.getFileInfo(params.storageHandle, params.fileIds).then(function(response) {
        var responseParams =
            new MtpManager_GetFileInfo_ResponseParams();
        responseParams.fileEntries = response.fileEntries;
        responseParams.error = response.error;
        var builder = new codec.MessageV1Builder(
            kMtpManager_GetFileInfo_Name,
            codec.align(MtpManager_GetFileInfo_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(MtpManager_GetFileInfo_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kMtpManager_RenameObject_Name:
      var params = reader.decodeStruct(MtpManager_RenameObject_Params);
      this.renameObject(params.storageHandle, params.objectId, params.newName).then(function(response) {
        var responseParams =
            new MtpManager_RenameObject_ResponseParams();
        responseParams.error = response.error;
        var builder = new codec.MessageV1Builder(
            kMtpManager_RenameObject_Name,
            codec.align(MtpManager_RenameObject_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(MtpManager_RenameObject_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kMtpManager_CopyFileFromLocal_Name:
      var params = reader.decodeStruct(MtpManager_CopyFileFromLocal_Params);
      this.copyFileFromLocal(params.storageHandle, params.sourceFileDescriptor, params.parentId, params.fileName).then(function(response) {
        var responseParams =
            new MtpManager_CopyFileFromLocal_ResponseParams();
        responseParams.error = response.error;
        var builder = new codec.MessageV1Builder(
            kMtpManager_CopyFileFromLocal_Name,
            codec.align(MtpManager_CopyFileFromLocal_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(MtpManager_CopyFileFromLocal_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kMtpManager_DeleteObject_Name:
      var params = reader.decodeStruct(MtpManager_DeleteObject_Params);
      this.deleteObject(params.storageHandle, params.objectId).then(function(response) {
        var responseParams =
            new MtpManager_DeleteObject_ResponseParams();
        responseParams.error = response.error;
        var builder = new codec.MessageV1Builder(
            kMtpManager_DeleteObject_Name,
            codec.align(MtpManager_DeleteObject_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(MtpManager_DeleteObject_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateMtpManagerRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kMtpManager_EnumerateStoragesAndSetClient_Name:
        if (message.expectsResponse())
          paramsClass = MtpManager_EnumerateStoragesAndSetClient_Params;
      break;
      case kMtpManager_GetStorageInfo_Name:
        if (message.expectsResponse())
          paramsClass = MtpManager_GetStorageInfo_Params;
      break;
      case kMtpManager_GetStorageInfoFromDevice_Name:
        if (message.expectsResponse())
          paramsClass = MtpManager_GetStorageInfoFromDevice_Params;
      break;
      case kMtpManager_OpenStorage_Name:
        if (message.expectsResponse())
          paramsClass = MtpManager_OpenStorage_Params;
      break;
      case kMtpManager_CloseStorage_Name:
        if (message.expectsResponse())
          paramsClass = MtpManager_CloseStorage_Params;
      break;
      case kMtpManager_CreateDirectory_Name:
        if (message.expectsResponse())
          paramsClass = MtpManager_CreateDirectory_Params;
      break;
      case kMtpManager_ReadDirectoryEntryIds_Name:
        if (message.expectsResponse())
          paramsClass = MtpManager_ReadDirectoryEntryIds_Params;
      break;
      case kMtpManager_ReadFileChunk_Name:
        if (message.expectsResponse())
          paramsClass = MtpManager_ReadFileChunk_Params;
      break;
      case kMtpManager_GetFileInfo_Name:
        if (message.expectsResponse())
          paramsClass = MtpManager_GetFileInfo_Params;
      break;
      case kMtpManager_RenameObject_Name:
        if (message.expectsResponse())
          paramsClass = MtpManager_RenameObject_Params;
      break;
      case kMtpManager_CopyFileFromLocal_Name:
        if (message.expectsResponse())
          paramsClass = MtpManager_CopyFileFromLocal_Params;
      break;
      case kMtpManager_DeleteObject_Name:
        if (message.expectsResponse())
          paramsClass = MtpManager_DeleteObject_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateMtpManagerResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kMtpManager_EnumerateStoragesAndSetClient_Name:
        if (message.isResponse())
          paramsClass = MtpManager_EnumerateStoragesAndSetClient_ResponseParams;
        break;
      case kMtpManager_GetStorageInfo_Name:
        if (message.isResponse())
          paramsClass = MtpManager_GetStorageInfo_ResponseParams;
        break;
      case kMtpManager_GetStorageInfoFromDevice_Name:
        if (message.isResponse())
          paramsClass = MtpManager_GetStorageInfoFromDevice_ResponseParams;
        break;
      case kMtpManager_OpenStorage_Name:
        if (message.isResponse())
          paramsClass = MtpManager_OpenStorage_ResponseParams;
        break;
      case kMtpManager_CloseStorage_Name:
        if (message.isResponse())
          paramsClass = MtpManager_CloseStorage_ResponseParams;
        break;
      case kMtpManager_CreateDirectory_Name:
        if (message.isResponse())
          paramsClass = MtpManager_CreateDirectory_ResponseParams;
        break;
      case kMtpManager_ReadDirectoryEntryIds_Name:
        if (message.isResponse())
          paramsClass = MtpManager_ReadDirectoryEntryIds_ResponseParams;
        break;
      case kMtpManager_ReadFileChunk_Name:
        if (message.isResponse())
          paramsClass = MtpManager_ReadFileChunk_ResponseParams;
        break;
      case kMtpManager_GetFileInfo_Name:
        if (message.isResponse())
          paramsClass = MtpManager_GetFileInfo_ResponseParams;
        break;
      case kMtpManager_RenameObject_Name:
        if (message.isResponse())
          paramsClass = MtpManager_RenameObject_ResponseParams;
        break;
      case kMtpManager_CopyFileFromLocal_Name:
        if (message.isResponse())
          paramsClass = MtpManager_CopyFileFromLocal_ResponseParams;
        break;
      case kMtpManager_DeleteObject_Name:
        if (message.isResponse())
          paramsClass = MtpManager_DeleteObject_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var MtpManager = {
    name: 'device.mojom.MtpManager',
    kVersion: 0,
    ptrClass: MtpManagerPtr,
    proxyClass: MtpManagerProxy,
    stubClass: MtpManagerStub,
    validateRequest: validateMtpManagerRequest,
    validateResponse: validateMtpManagerResponse,
  };
  MtpManagerStub.prototype.validator = validateMtpManagerRequest;
  MtpManagerProxy.prototype.validator = validateMtpManagerResponse;
  exports.MtpManagerClient = MtpManagerClient;
  exports.MtpManagerClientPtr = MtpManagerClientPtr;
  exports.MtpManagerClientAssociatedPtr = MtpManagerClientAssociatedPtr;
  exports.MtpManager = MtpManager;
  exports.MtpManagerPtr = MtpManagerPtr;
  exports.MtpManagerAssociatedPtr = MtpManagerAssociatedPtr;
})();