// services/device/public/mojom/mtp_manager.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';

import {
  MtpFileEntry as device_mojom_MtpFileEntry,
  MtpFileEntrySpec as device_mojom_MtpFileEntrySpec
} from './mtp_file_entry.mojom.m.js';

import {
  MtpStorageInfo as device_mojom_MtpStorageInfo,
  MtpStorageInfoSpec as device_mojom_MtpStorageInfoSpec
} from './mtp_storage_info.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class MtpManagerClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'device.mojom.MtpManagerClient', scope);
  }
}

/** @interface */
export class MtpManagerClientInterface {
  
  /**
   * @param { !device_mojom_MtpStorageInfo } storageInfo
   */

  storageAttached(storageInfo) {}
  
  /**
   * @param { !string } storageName
   */

  storageDetached(storageName) {}
}

/**
 * @implements { MtpManagerClientInterface }
 */
export class MtpManagerClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!MtpManagerClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          MtpManagerClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!MtpManagerClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !device_mojom_MtpStorageInfo } storageInfo
   */

  storageAttached(
      storageInfo) {
    this.proxy.sendMessage(
        0,
        MtpManagerClient_StorageAttached_ParamsSpec.$,
        null,
        [
          storageInfo
        ],
        false);
  }

  
  /**
   * @param { !string } storageName
   */

  storageDetached(
      storageName) {
    this.proxy.sendMessage(
        1,
        MtpManagerClient_StorageDetached_ParamsSpec.$,
        null,
        [
          storageName
        ],
        false);
  }
}

/**
 * An object which receives request messages for the MtpManagerClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class MtpManagerClientReceiver {
  /**
   * @param {!MtpManagerClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!MtpManagerClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        MtpManagerClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!MtpManagerClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        MtpManagerClient_StorageAttached_ParamsSpec.$,
        null,
        impl.storageAttached.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        MtpManagerClient_StorageDetached_ParamsSpec.$,
        null,
        impl.storageDetached.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class MtpManagerClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.MtpManagerClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!MtpManagerClientRemote}
   */
  static getRemote() {
    let remote = new MtpManagerClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the MtpManagerClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class MtpManagerClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      MtpManagerClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!MtpManagerClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.storageAttached =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        MtpManagerClient_StorageAttached_ParamsSpec.$,
        null,
        this.storageAttached.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.storageDetached =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        MtpManagerClient_StorageDetached_ParamsSpec.$,
        null,
        this.storageDetached.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class MtpManagerPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'device.mojom.MtpManager', scope);
  }
}

/** @interface */
export class MtpManagerInterface {
  
  /**
   * @param { !Object } client
   * @return {!Promise<{
        storages: !Array<!device_mojom_MtpStorageInfo>,
   *  }>}
   */

  enumerateStoragesAndSetClient(client) {}
  
  /**
   * @param { !string } storageName
   * @return {!Promise<{
        storageInfo: !device_mojom_MtpStorageInfo,
   *  }>}
   */

  getStorageInfo(storageName) {}
  
  /**
   * @param { !string } storageName
   * @return {!Promise<{
        storageInfo: !device_mojom_MtpStorageInfo,
        error: !boolean,
   *  }>}
   */

  getStorageInfoFromDevice(storageName) {}
  
  /**
   * @param { !string } storageName
   * @param { !string } mode
   * @return {!Promise<{
        storageHandle: !string,
        error: !boolean,
   *  }>}
   */

  openStorage(storageName, mode) {}
  
  /**
   * @param { !string } storageHandle
   * @return {!Promise<{
        error: !boolean,
   *  }>}
   */

  closeStorage(storageHandle) {}
  
  /**
   * @param { !string } storageHandle
   * @param { !number } parentId
   * @param { !string } directoryName
   * @return {!Promise<{
        error: !boolean,
   *  }>}
   */

  createDirectory(storageHandle, parentId, directoryName) {}
  
  /**
   * @param { !string } storageHandle
   * @param { !number } fileId
   * @return {!Promise<{
        fileIds: !Array<!number>,
        error: !boolean,
   *  }>}
   */

  readDirectoryEntryIds(storageHandle, fileId) {}
  
  /**
   * @param { !string } storageHandle
   * @param { !number } fileId
   * @param { !number } offset
   * @param { !number } count
   * @return {!Promise<{
        data: !string,
        error: !boolean,
   *  }>}
   */

  readFileChunk(storageHandle, fileId, offset, count) {}
  
  /**
   * @param { !string } storageHandle
   * @param { !Array<!number> } fileIds
   * @return {!Promise<{
        fileEntries: !Array<!device_mojom_MtpFileEntry>,
        error: !boolean,
   *  }>}
   */

  getFileInfo(storageHandle, fileIds) {}
  
  /**
   * @param { !string } storageHandle
   * @param { !number } objectId
   * @param { !string } newName
   * @return {!Promise<{
        error: !boolean,
   *  }>}
   */

  renameObject(storageHandle, objectId, newName) {}
  
  /**
   * @param { !string } storageHandle
   * @param { !bigint } sourceFileDescriptor
   * @param { !number } parentId
   * @param { !string } fileName
   * @return {!Promise<{
        error: !boolean,
   *  }>}
   */

  copyFileFromLocal(storageHandle, sourceFileDescriptor, parentId, fileName) {}
  
  /**
   * @param { !string } storageHandle
   * @param { !number } objectId
   * @return {!Promise<{
        error: !boolean,
   *  }>}
   */

  deleteObject(storageHandle, objectId) {}
}

/**
 * @implements { MtpManagerInterface }
 */
export class MtpManagerRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!MtpManagerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          MtpManagerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!MtpManagerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Object } client
   * @return {!Promise<{
        storages: !Array<!device_mojom_MtpStorageInfo>,
   *  }>}
   */

  enumerateStoragesAndSetClient(
      client) {
    return this.proxy.sendMessage(
        0,
        MtpManager_EnumerateStoragesAndSetClient_ParamsSpec.$,
        MtpManager_EnumerateStoragesAndSetClient_ResponseParamsSpec.$,
        [
          client
        ],
        false);
  }

  
  /**
   * @param { !string } storageName
   * @return {!Promise<{
        storageInfo: !device_mojom_MtpStorageInfo,
   *  }>}
   */

  getStorageInfo(
      storageName) {
    return this.proxy.sendMessage(
        1,
        MtpManager_GetStorageInfo_ParamsSpec.$,
        MtpManager_GetStorageInfo_ResponseParamsSpec.$,
        [
          storageName
        ],
        false);
  }

  
  /**
   * @param { !string } storageName
   * @return {!Promise<{
        storageInfo: !device_mojom_MtpStorageInfo,
        error: !boolean,
   *  }>}
   */

  getStorageInfoFromDevice(
      storageName) {
    return this.proxy.sendMessage(
        2,
        MtpManager_GetStorageInfoFromDevice_ParamsSpec.$,
        MtpManager_GetStorageInfoFromDevice_ResponseParamsSpec.$,
        [
          storageName
        ],
        false);
  }

  
  /**
   * @param { !string } storageName
   * @param { !string } mode
   * @return {!Promise<{
        storageHandle: !string,
        error: !boolean,
   *  }>}
   */

  openStorage(
      storageName,
      mode) {
    return this.proxy.sendMessage(
        3,
        MtpManager_OpenStorage_ParamsSpec.$,
        MtpManager_OpenStorage_ResponseParamsSpec.$,
        [
          storageName,
          mode
        ],
        false);
  }

  
  /**
   * @param { !string } storageHandle
   * @return {!Promise<{
        error: !boolean,
   *  }>}
   */

  closeStorage(
      storageHandle) {
    return this.proxy.sendMessage(
        4,
        MtpManager_CloseStorage_ParamsSpec.$,
        MtpManager_CloseStorage_ResponseParamsSpec.$,
        [
          storageHandle
        ],
        false);
  }

  
  /**
   * @param { !string } storageHandle
   * @param { !number } parentId
   * @param { !string } directoryName
   * @return {!Promise<{
        error: !boolean,
   *  }>}
   */

  createDirectory(
      storageHandle,
      parentId,
      directoryName) {
    return this.proxy.sendMessage(
        5,
        MtpManager_CreateDirectory_ParamsSpec.$,
        MtpManager_CreateDirectory_ResponseParamsSpec.$,
        [
          storageHandle,
          parentId,
          directoryName
        ],
        false);
  }

  
  /**
   * @param { !string } storageHandle
   * @param { !number } fileId
   * @return {!Promise<{
        fileIds: !Array<!number>,
        error: !boolean,
   *  }>}
   */

  readDirectoryEntryIds(
      storageHandle,
      fileId) {
    return this.proxy.sendMessage(
        6,
        MtpManager_ReadDirectoryEntryIds_ParamsSpec.$,
        MtpManager_ReadDirectoryEntryIds_ResponseParamsSpec.$,
        [
          storageHandle,
          fileId
        ],
        false);
  }

  
  /**
   * @param { !string } storageHandle
   * @param { !number } fileId
   * @param { !number } offset
   * @param { !number } count
   * @return {!Promise<{
        data: !string,
        error: !boolean,
   *  }>}
   */

  readFileChunk(
      storageHandle,
      fileId,
      offset,
      count) {
    return this.proxy.sendMessage(
        7,
        MtpManager_ReadFileChunk_ParamsSpec.$,
        MtpManager_ReadFileChunk_ResponseParamsSpec.$,
        [
          storageHandle,
          fileId,
          offset,
          count
        ],
        false);
  }

  
  /**
   * @param { !string } storageHandle
   * @param { !Array<!number> } fileIds
   * @return {!Promise<{
        fileEntries: !Array<!device_mojom_MtpFileEntry>,
        error: !boolean,
   *  }>}
   */

  getFileInfo(
      storageHandle,
      fileIds) {
    return this.proxy.sendMessage(
        8,
        MtpManager_GetFileInfo_ParamsSpec.$,
        MtpManager_GetFileInfo_ResponseParamsSpec.$,
        [
          storageHandle,
          fileIds
        ],
        false);
  }

  
  /**
   * @param { !string } storageHandle
   * @param { !number } objectId
   * @param { !string } newName
   * @return {!Promise<{
        error: !boolean,
   *  }>}
   */

  renameObject(
      storageHandle,
      objectId,
      newName) {
    return this.proxy.sendMessage(
        9,
        MtpManager_RenameObject_ParamsSpec.$,
        MtpManager_RenameObject_ResponseParamsSpec.$,
        [
          storageHandle,
          objectId,
          newName
        ],
        false);
  }

  
  /**
   * @param { !string } storageHandle
   * @param { !bigint } sourceFileDescriptor
   * @param { !number } parentId
   * @param { !string } fileName
   * @return {!Promise<{
        error: !boolean,
   *  }>}
   */

  copyFileFromLocal(
      storageHandle,
      sourceFileDescriptor,
      parentId,
      fileName) {
    return this.proxy.sendMessage(
        10,
        MtpManager_CopyFileFromLocal_ParamsSpec.$,
        MtpManager_CopyFileFromLocal_ResponseParamsSpec.$,
        [
          storageHandle,
          sourceFileDescriptor,
          parentId,
          fileName
        ],
        false);
  }

  
  /**
   * @param { !string } storageHandle
   * @param { !number } objectId
   * @return {!Promise<{
        error: !boolean,
   *  }>}
   */

  deleteObject(
      storageHandle,
      objectId) {
    return this.proxy.sendMessage(
        11,
        MtpManager_DeleteObject_ParamsSpec.$,
        MtpManager_DeleteObject_ResponseParamsSpec.$,
        [
          storageHandle,
          objectId
        ],
        false);
  }
}

/**
 * An object which receives request messages for the MtpManager
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class MtpManagerReceiver {
  /**
   * @param {!MtpManagerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!MtpManagerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        MtpManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!MtpManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        MtpManager_EnumerateStoragesAndSetClient_ParamsSpec.$,
        MtpManager_EnumerateStoragesAndSetClient_ResponseParamsSpec.$,
        impl.enumerateStoragesAndSetClient.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        MtpManager_GetStorageInfo_ParamsSpec.$,
        MtpManager_GetStorageInfo_ResponseParamsSpec.$,
        impl.getStorageInfo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        MtpManager_GetStorageInfoFromDevice_ParamsSpec.$,
        MtpManager_GetStorageInfoFromDevice_ResponseParamsSpec.$,
        impl.getStorageInfoFromDevice.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        MtpManager_OpenStorage_ParamsSpec.$,
        MtpManager_OpenStorage_ResponseParamsSpec.$,
        impl.openStorage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        MtpManager_CloseStorage_ParamsSpec.$,
        MtpManager_CloseStorage_ResponseParamsSpec.$,
        impl.closeStorage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        MtpManager_CreateDirectory_ParamsSpec.$,
        MtpManager_CreateDirectory_ResponseParamsSpec.$,
        impl.createDirectory.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        MtpManager_ReadDirectoryEntryIds_ParamsSpec.$,
        MtpManager_ReadDirectoryEntryIds_ResponseParamsSpec.$,
        impl.readDirectoryEntryIds.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        MtpManager_ReadFileChunk_ParamsSpec.$,
        MtpManager_ReadFileChunk_ResponseParamsSpec.$,
        impl.readFileChunk.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        MtpManager_GetFileInfo_ParamsSpec.$,
        MtpManager_GetFileInfo_ResponseParamsSpec.$,
        impl.getFileInfo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        MtpManager_RenameObject_ParamsSpec.$,
        MtpManager_RenameObject_ResponseParamsSpec.$,
        impl.renameObject.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        MtpManager_CopyFileFromLocal_ParamsSpec.$,
        MtpManager_CopyFileFromLocal_ResponseParamsSpec.$,
        impl.copyFileFromLocal.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        MtpManager_DeleteObject_ParamsSpec.$,
        MtpManager_DeleteObject_ResponseParamsSpec.$,
        impl.deleteObject.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class MtpManager {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.MtpManager";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!MtpManagerRemote}
   */
  static getRemote() {
    let remote = new MtpManagerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the MtpManager
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class MtpManagerCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      MtpManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!MtpManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.enumerateStoragesAndSetClient =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        MtpManager_EnumerateStoragesAndSetClient_ParamsSpec.$,
        MtpManager_EnumerateStoragesAndSetClient_ResponseParamsSpec.$,
        this.enumerateStoragesAndSetClient.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getStorageInfo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        MtpManager_GetStorageInfo_ParamsSpec.$,
        MtpManager_GetStorageInfo_ResponseParamsSpec.$,
        this.getStorageInfo.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getStorageInfoFromDevice =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        MtpManager_GetStorageInfoFromDevice_ParamsSpec.$,
        MtpManager_GetStorageInfoFromDevice_ResponseParamsSpec.$,
        this.getStorageInfoFromDevice.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.openStorage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        MtpManager_OpenStorage_ParamsSpec.$,
        MtpManager_OpenStorage_ResponseParamsSpec.$,
        this.openStorage.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.closeStorage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        MtpManager_CloseStorage_ParamsSpec.$,
        MtpManager_CloseStorage_ResponseParamsSpec.$,
        this.closeStorage.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createDirectory =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        MtpManager_CreateDirectory_ParamsSpec.$,
        MtpManager_CreateDirectory_ResponseParamsSpec.$,
        this.createDirectory.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.readDirectoryEntryIds =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        MtpManager_ReadDirectoryEntryIds_ParamsSpec.$,
        MtpManager_ReadDirectoryEntryIds_ResponseParamsSpec.$,
        this.readDirectoryEntryIds.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.readFileChunk =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        MtpManager_ReadFileChunk_ParamsSpec.$,
        MtpManager_ReadFileChunk_ResponseParamsSpec.$,
        this.readFileChunk.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getFileInfo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        MtpManager_GetFileInfo_ParamsSpec.$,
        MtpManager_GetFileInfo_ResponseParamsSpec.$,
        this.getFileInfo.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.renameObject =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        MtpManager_RenameObject_ParamsSpec.$,
        MtpManager_RenameObject_ResponseParamsSpec.$,
        this.renameObject.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.copyFileFromLocal =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        MtpManager_CopyFileFromLocal_ParamsSpec.$,
        MtpManager_CopyFileFromLocal_ResponseParamsSpec.$,
        this.copyFileFromLocal.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.deleteObject =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        MtpManager_DeleteObject_ParamsSpec.$,
        MtpManager_DeleteObject_ResponseParamsSpec.$,
        this.deleteObject.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MtpManagerClient_StorageAttached_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MtpManagerClient_StorageDetached_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MtpManager_EnumerateStoragesAndSetClient_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MtpManager_EnumerateStoragesAndSetClient_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MtpManager_GetStorageInfo_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MtpManager_GetStorageInfo_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MtpManager_GetStorageInfoFromDevice_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MtpManager_GetStorageInfoFromDevice_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MtpManager_OpenStorage_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MtpManager_OpenStorage_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MtpManager_CloseStorage_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MtpManager_CloseStorage_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MtpManager_CreateDirectory_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MtpManager_CreateDirectory_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MtpManager_ReadDirectoryEntryIds_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MtpManager_ReadDirectoryEntryIds_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MtpManager_ReadFileChunk_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MtpManager_ReadFileChunk_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MtpManager_GetFileInfo_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MtpManager_GetFileInfo_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MtpManager_RenameObject_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MtpManager_RenameObject_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MtpManager_CopyFileFromLocal_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MtpManager_CopyFileFromLocal_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MtpManager_DeleteObject_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MtpManager_DeleteObject_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    MtpManagerClient_StorageAttached_ParamsSpec.$,
    'MtpManagerClient_StorageAttached_Params',
    [
      mojo.internal.StructField(
        'storageInfo', 0,
        0,
        device_mojom_MtpStorageInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MtpManagerClient_StorageAttached_Params {
  constructor() {
    /** @type { !device_mojom_MtpStorageInfo } */
    this.storageInfo;
  }
}



mojo.internal.Struct(
    MtpManagerClient_StorageDetached_ParamsSpec.$,
    'MtpManagerClient_StorageDetached_Params',
    [
      mojo.internal.StructField(
        'storageName', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MtpManagerClient_StorageDetached_Params {
  constructor() {
    /** @type { !string } */
    this.storageName;
  }
}



mojo.internal.Struct(
    MtpManager_EnumerateStoragesAndSetClient_ParamsSpec.$,
    'MtpManager_EnumerateStoragesAndSetClient_Params',
    [
      mojo.internal.StructField(
        'client', 0,
        0,
        mojo.internal.AssociatedInterfaceProxy(MtpManagerClientRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MtpManager_EnumerateStoragesAndSetClient_Params {
  constructor() {
    /** @type { !Object } */
    this.client;
  }
}



mojo.internal.Struct(
    MtpManager_EnumerateStoragesAndSetClient_ResponseParamsSpec.$,
    'MtpManager_EnumerateStoragesAndSetClient_ResponseParams',
    [
      mojo.internal.StructField(
        'storages', 0,
        0,
        mojo.internal.Array(device_mojom_MtpStorageInfoSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MtpManager_EnumerateStoragesAndSetClient_ResponseParams {
  constructor() {
    /** @type { !Array<!device_mojom_MtpStorageInfo> } */
    this.storages;
  }
}



mojo.internal.Struct(
    MtpManager_GetStorageInfo_ParamsSpec.$,
    'MtpManager_GetStorageInfo_Params',
    [
      mojo.internal.StructField(
        'storageName', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MtpManager_GetStorageInfo_Params {
  constructor() {
    /** @type { !string } */
    this.storageName;
  }
}



mojo.internal.Struct(
    MtpManager_GetStorageInfo_ResponseParamsSpec.$,
    'MtpManager_GetStorageInfo_ResponseParams',
    [
      mojo.internal.StructField(
        'storageInfo', 0,
        0,
        device_mojom_MtpStorageInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MtpManager_GetStorageInfo_ResponseParams {
  constructor() {
    /** @type { !device_mojom_MtpStorageInfo } */
    this.storageInfo;
  }
}



mojo.internal.Struct(
    MtpManager_GetStorageInfoFromDevice_ParamsSpec.$,
    'MtpManager_GetStorageInfoFromDevice_Params',
    [
      mojo.internal.StructField(
        'storageName', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MtpManager_GetStorageInfoFromDevice_Params {
  constructor() {
    /** @type { !string } */
    this.storageName;
  }
}



mojo.internal.Struct(
    MtpManager_GetStorageInfoFromDevice_ResponseParamsSpec.$,
    'MtpManager_GetStorageInfoFromDevice_ResponseParams',
    [
      mojo.internal.StructField(
        'storageInfo', 0,
        0,
        device_mojom_MtpStorageInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'error', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MtpManager_GetStorageInfoFromDevice_ResponseParams {
  constructor() {
    /** @type { !device_mojom_MtpStorageInfo } */
    this.storageInfo;
    /** @type { !boolean } */
    this.error;
  }
}



mojo.internal.Struct(
    MtpManager_OpenStorage_ParamsSpec.$,
    'MtpManager_OpenStorage_Params',
    [
      mojo.internal.StructField(
        'storageName', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'mode', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MtpManager_OpenStorage_Params {
  constructor() {
    /** @type { !string } */
    this.storageName;
    /** @type { !string } */
    this.mode;
  }
}



mojo.internal.Struct(
    MtpManager_OpenStorage_ResponseParamsSpec.$,
    'MtpManager_OpenStorage_ResponseParams',
    [
      mojo.internal.StructField(
        'storageHandle', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'error', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MtpManager_OpenStorage_ResponseParams {
  constructor() {
    /** @type { !string } */
    this.storageHandle;
    /** @type { !boolean } */
    this.error;
  }
}



mojo.internal.Struct(
    MtpManager_CloseStorage_ParamsSpec.$,
    'MtpManager_CloseStorage_Params',
    [
      mojo.internal.StructField(
        'storageHandle', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MtpManager_CloseStorage_Params {
  constructor() {
    /** @type { !string } */
    this.storageHandle;
  }
}



mojo.internal.Struct(
    MtpManager_CloseStorage_ResponseParamsSpec.$,
    'MtpManager_CloseStorage_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MtpManager_CloseStorage_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.error;
  }
}



mojo.internal.Struct(
    MtpManager_CreateDirectory_ParamsSpec.$,
    'MtpManager_CreateDirectory_Params',
    [
      mojo.internal.StructField(
        'storageHandle', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'parentId', 8,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'directoryName', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class MtpManager_CreateDirectory_Params {
  constructor() {
    /** @type { !string } */
    this.storageHandle;
    /** @type { !number } */
    this.parentId;
    /** @type { !string } */
    this.directoryName;
  }
}



mojo.internal.Struct(
    MtpManager_CreateDirectory_ResponseParamsSpec.$,
    'MtpManager_CreateDirectory_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MtpManager_CreateDirectory_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.error;
  }
}



mojo.internal.Struct(
    MtpManager_ReadDirectoryEntryIds_ParamsSpec.$,
    'MtpManager_ReadDirectoryEntryIds_Params',
    [
      mojo.internal.StructField(
        'storageHandle', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'fileId', 8,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MtpManager_ReadDirectoryEntryIds_Params {
  constructor() {
    /** @type { !string } */
    this.storageHandle;
    /** @type { !number } */
    this.fileId;
  }
}



mojo.internal.Struct(
    MtpManager_ReadDirectoryEntryIds_ResponseParamsSpec.$,
    'MtpManager_ReadDirectoryEntryIds_ResponseParams',
    [
      mojo.internal.StructField(
        'fileIds', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint32, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'error', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MtpManager_ReadDirectoryEntryIds_ResponseParams {
  constructor() {
    /** @type { !Array<!number> } */
    this.fileIds;
    /** @type { !boolean } */
    this.error;
  }
}



mojo.internal.Struct(
    MtpManager_ReadFileChunk_ParamsSpec.$,
    'MtpManager_ReadFileChunk_Params',
    [
      mojo.internal.StructField(
        'storageHandle', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'fileId', 8,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'offset', 12,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'count', 16,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class MtpManager_ReadFileChunk_Params {
  constructor() {
    /** @type { !string } */
    this.storageHandle;
    /** @type { !number } */
    this.fileId;
    /** @type { !number } */
    this.offset;
    /** @type { !number } */
    this.count;
  }
}



mojo.internal.Struct(
    MtpManager_ReadFileChunk_ResponseParamsSpec.$,
    'MtpManager_ReadFileChunk_ResponseParams',
    [
      mojo.internal.StructField(
        'data', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'error', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MtpManager_ReadFileChunk_ResponseParams {
  constructor() {
    /** @type { !string } */
    this.data;
    /** @type { !boolean } */
    this.error;
  }
}



mojo.internal.Struct(
    MtpManager_GetFileInfo_ParamsSpec.$,
    'MtpManager_GetFileInfo_Params',
    [
      mojo.internal.StructField(
        'storageHandle', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'fileIds', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint32, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MtpManager_GetFileInfo_Params {
  constructor() {
    /** @type { !string } */
    this.storageHandle;
    /** @type { !Array<!number> } */
    this.fileIds;
  }
}



mojo.internal.Struct(
    MtpManager_GetFileInfo_ResponseParamsSpec.$,
    'MtpManager_GetFileInfo_ResponseParams',
    [
      mojo.internal.StructField(
        'fileEntries', 0,
        0,
        mojo.internal.Array(device_mojom_MtpFileEntrySpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'error', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MtpManager_GetFileInfo_ResponseParams {
  constructor() {
    /** @type { !Array<!device_mojom_MtpFileEntry> } */
    this.fileEntries;
    /** @type { !boolean } */
    this.error;
  }
}



mojo.internal.Struct(
    MtpManager_RenameObject_ParamsSpec.$,
    'MtpManager_RenameObject_Params',
    [
      mojo.internal.StructField(
        'storageHandle', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'objectId', 8,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'newName', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class MtpManager_RenameObject_Params {
  constructor() {
    /** @type { !string } */
    this.storageHandle;
    /** @type { !number } */
    this.objectId;
    /** @type { !string } */
    this.newName;
  }
}



mojo.internal.Struct(
    MtpManager_RenameObject_ResponseParamsSpec.$,
    'MtpManager_RenameObject_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MtpManager_RenameObject_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.error;
  }
}



mojo.internal.Struct(
    MtpManager_CopyFileFromLocal_ParamsSpec.$,
    'MtpManager_CopyFileFromLocal_Params',
    [
      mojo.internal.StructField(
        'storageHandle', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sourceFileDescriptor', 8,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'parentId', 16,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'fileName', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class MtpManager_CopyFileFromLocal_Params {
  constructor() {
    /** @type { !string } */
    this.storageHandle;
    /** @type { !bigint } */
    this.sourceFileDescriptor;
    /** @type { !number } */
    this.parentId;
    /** @type { !string } */
    this.fileName;
  }
}



mojo.internal.Struct(
    MtpManager_CopyFileFromLocal_ResponseParamsSpec.$,
    'MtpManager_CopyFileFromLocal_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MtpManager_CopyFileFromLocal_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.error;
  }
}



mojo.internal.Struct(
    MtpManager_DeleteObject_ParamsSpec.$,
    'MtpManager_DeleteObject_Params',
    [
      mojo.internal.StructField(
        'storageHandle', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'objectId', 8,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MtpManager_DeleteObject_Params {
  constructor() {
    /** @type { !string } */
    this.storageHandle;
    /** @type { !number } */
    this.objectId;
  }
}



mojo.internal.Struct(
    MtpManager_DeleteObject_ResponseParamsSpec.$,
    'MtpManager_DeleteObject_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MtpManager_DeleteObject_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.error;
  }
}

