// services/device/public/mojom/mtp_storage_info.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/device/public/mojom/mtp_storage_info.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('device.mojom');



  function MtpStorageInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MtpStorageInfo.prototype.initDefaults_ = function() {
    this.storageName = null;
    this.vendor = null;
    this.vendorId = 0;
    this.productId = 0;
    this.product = null;
    this.deviceFlags = 0;
    this.storageType = 0;
    this.filesystemType = 0;
    this.accessCapability = 0;
    this.maxCapacity = 0;
    this.freeSpaceInBytes = 0;
    this.freeSpaceInObjects = 0;
    this.storageDescription = null;
    this.volumeIdentifier = null;
    this.serialNumber = null;
  };
  MtpStorageInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MtpStorageInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 104}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MtpStorageInfo.storageName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate MtpStorageInfo.vendor
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;



    // validate MtpStorageInfo.product
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 24, false)
    if (err !== validator.validationError.NONE)
        return err;










    // validate MtpStorageInfo.storageDescription
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 72, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate MtpStorageInfo.volumeIdentifier
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 80, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate MtpStorageInfo.serialNumber
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 88, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MtpStorageInfo.encodedSize = codec.kStructHeaderSize + 96;

  MtpStorageInfo.decode = function(decoder) {
    var packed;
    var val = new MtpStorageInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.storageName =
        decoder.decodeStruct(codec.String);
    val.vendor =
        decoder.decodeStruct(codec.String);
    val.vendorId =
        decoder.decodeStruct(codec.Uint32);
    val.productId =
        decoder.decodeStruct(codec.Uint32);
    val.product =
        decoder.decodeStruct(codec.String);
    val.deviceFlags =
        decoder.decodeStruct(codec.Uint32);
    val.storageType =
        decoder.decodeStruct(codec.Uint32);
    val.filesystemType =
        decoder.decodeStruct(codec.Uint32);
    val.accessCapability =
        decoder.decodeStruct(codec.Uint32);
    val.maxCapacity =
        decoder.decodeStruct(codec.Uint64);
    val.freeSpaceInBytes =
        decoder.decodeStruct(codec.Uint64);
    val.freeSpaceInObjects =
        decoder.decodeStruct(codec.Uint64);
    val.storageDescription =
        decoder.decodeStruct(codec.String);
    val.volumeIdentifier =
        decoder.decodeStruct(codec.String);
    val.serialNumber =
        decoder.decodeStruct(codec.String);
    return val;
  };

  MtpStorageInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MtpStorageInfo.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.storageName);
    encoder.encodeStruct(codec.String, val.vendor);
    encoder.encodeStruct(codec.Uint32, val.vendorId);
    encoder.encodeStruct(codec.Uint32, val.productId);
    encoder.encodeStruct(codec.String, val.product);
    encoder.encodeStruct(codec.Uint32, val.deviceFlags);
    encoder.encodeStruct(codec.Uint32, val.storageType);
    encoder.encodeStruct(codec.Uint32, val.filesystemType);
    encoder.encodeStruct(codec.Uint32, val.accessCapability);
    encoder.encodeStruct(codec.Uint64, val.maxCapacity);
    encoder.encodeStruct(codec.Uint64, val.freeSpaceInBytes);
    encoder.encodeStruct(codec.Uint64, val.freeSpaceInObjects);
    encoder.encodeStruct(codec.String, val.storageDescription);
    encoder.encodeStruct(codec.String, val.volumeIdentifier);
    encoder.encodeStruct(codec.String, val.serialNumber);
  };
  exports.MtpStorageInfo = MtpStorageInfo;
})();