// services/device/public/mojom/sensor_provider.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('device.mojom.ReportingMode');
goog.require('device.mojom.SensorType');
goog.require('device.mojom.Sensor');
goog.require('device.mojom.SensorClient');
goog.require('mojoBase.mojom.ReadOnlySharedMemoryRegion');
goog.require('device.mojom.SensorConfiguration');
goog.require('device.mojom.SensorReadingRaw');




goog.provide('device.mojom.SensorCreationResult');
goog.provide('device.mojom.SensorCreationResultSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
device.mojom.SensorCreationResultSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
device.mojom.SensorCreationResult = {
  
  SUCCESS: 0,
  ERROR_NOT_AVAILABLE: 1,
  ERROR_NOT_ALLOWED: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

goog.provide('device.mojom.CreateVirtualSensorResult');
goog.provide('device.mojom.CreateVirtualSensorResultSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
device.mojom.CreateVirtualSensorResultSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
device.mojom.CreateVirtualSensorResult = {
  
  kSuccess: 0,
  kSensorTypeAlreadyOverridden: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

goog.provide('device.mojom.UpdateVirtualSensorResult');
goog.provide('device.mojom.UpdateVirtualSensorResultSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
device.mojom.UpdateVirtualSensorResultSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
device.mojom.UpdateVirtualSensorResult = {
  
  kSuccess: 0,
  kSensorTypeNotOverridden: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

goog.provide('device.mojom.GetVirtualSensorInformationError');
goog.provide('device.mojom.GetVirtualSensorInformationErrorSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
device.mojom.GetVirtualSensorInformationErrorSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
device.mojom.GetVirtualSensorInformationError = {
  
  kSensorTypeNotOverridden: 0,
  MIN_VALUE: 0,
  MAX_VALUE: 0,
};



goog.provide('device.mojom.SensorProvider');
goog.provide('device.mojom.SensorProviderReceiver');
goog.provide('device.mojom.SensorProviderCallbackRouter');
goog.provide('device.mojom.SensorProviderInterface');
goog.provide('device.mojom.SensorProviderRemote');
goog.provide('device.mojom.SensorProviderPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
device.mojom.SensorProviderPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        device.mojom.SensorProvider.$interfaceName,
        scope);
  }
};

/** @interface */
device.mojom.SensorProviderInterface = class {
  
  /**
   * @param { !device.mojom.SensorType } type
   * @return {!Promise<{
        result: !device.mojom.SensorCreationResult,
        initParams: ?device.mojom.SensorInitParams,
   *  }>}
   */

  getSensor(type) {}
  
  /**
   * @param { !device.mojom.SensorType } type
   * @param { !device.mojom.VirtualSensorMetadata } metadata
   * @return {!Promise<{
        result: !device.mojom.CreateVirtualSensorResult,
   *  }>}
   */

  createVirtualSensor(type, metadata) {}
  
  /**
   * @param { !device.mojom.SensorType } type
   * @param { !device.mojom.SensorReadingRaw } reading
   * @return {!Promise<{
        result: !device.mojom.UpdateVirtualSensorResult,
   *  }>}
   */

  updateVirtualSensor(type, reading) {}
  
  /**
   * @param { !device.mojom.SensorType } type
   * @return {!Promise}
   */

  removeVirtualSensor(type) {}
  
  /**
   * @param { !device.mojom.SensorType } type
   * @return {!Promise<{
        result: !device.mojom.GetVirtualSensorInformationResult,
   *  }>}
   */

  getVirtualSensorInformation(type) {}
};

/**
 * @export
 * @implements { device.mojom.SensorProviderInterface }
 */
device.mojom.SensorProviderRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!device.mojom.SensorProviderPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          device.mojom.SensorProviderPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!device.mojom.SensorProviderPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !device.mojom.SensorType } type
   * @return {!Promise<{
        result: !device.mojom.SensorCreationResult,
        initParams: ?device.mojom.SensorInitParams,
   *  }>}
   */

  getSensor(
      type) {
    return this.proxy.sendMessage(
        0,
        device.mojom.SensorProvider_GetSensor_ParamsSpec.$,
        device.mojom.SensorProvider_GetSensor_ResponseParamsSpec.$,
        [
          type
        ],
        false);
  }

  
  /**
   * @param { !device.mojom.SensorType } type
   * @param { !device.mojom.VirtualSensorMetadata } metadata
   * @return {!Promise<{
        result: !device.mojom.CreateVirtualSensorResult,
   *  }>}
   */

  createVirtualSensor(
      type,
      metadata) {
    return this.proxy.sendMessage(
        1,
        device.mojom.SensorProvider_CreateVirtualSensor_ParamsSpec.$,
        device.mojom.SensorProvider_CreateVirtualSensor_ResponseParamsSpec.$,
        [
          type,
          metadata
        ],
        false);
  }

  
  /**
   * @param { !device.mojom.SensorType } type
   * @param { !device.mojom.SensorReadingRaw } reading
   * @return {!Promise<{
        result: !device.mojom.UpdateVirtualSensorResult,
   *  }>}
   */

  updateVirtualSensor(
      type,
      reading) {
    return this.proxy.sendMessage(
        2,
        device.mojom.SensorProvider_UpdateVirtualSensor_ParamsSpec.$,
        device.mojom.SensorProvider_UpdateVirtualSensor_ResponseParamsSpec.$,
        [
          type,
          reading
        ],
        false);
  }

  
  /**
   * @param { !device.mojom.SensorType } type
   * @return {!Promise}
   */

  removeVirtualSensor(
      type) {
    return this.proxy.sendMessage(
        3,
        device.mojom.SensorProvider_RemoveVirtualSensor_ParamsSpec.$,
        device.mojom.SensorProvider_RemoveVirtualSensor_ResponseParamsSpec.$,
        [
          type
        ],
        false);
  }

  
  /**
   * @param { !device.mojom.SensorType } type
   * @return {!Promise<{
        result: !device.mojom.GetVirtualSensorInformationResult,
   *  }>}
   */

  getVirtualSensorInformation(
      type) {
    return this.proxy.sendMessage(
        4,
        device.mojom.SensorProvider_GetVirtualSensorInformation_ParamsSpec.$,
        device.mojom.SensorProvider_GetVirtualSensorInformation_ResponseParamsSpec.$,
        [
          type
        ],
        false);
  }
};

/**
 * An object which receives request messages for the SensorProvider
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
device.mojom.SensorProviderReceiver = class {
  /**
   * @param {!device.mojom.SensorProviderInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!device.mojom.SensorProviderRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        device.mojom.SensorProviderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.SensorProviderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        device.mojom.SensorProvider_GetSensor_ParamsSpec.$,
        device.mojom.SensorProvider_GetSensor_ResponseParamsSpec.$,
        impl.getSensor.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        device.mojom.SensorProvider_CreateVirtualSensor_ParamsSpec.$,
        device.mojom.SensorProvider_CreateVirtualSensor_ResponseParamsSpec.$,
        impl.createVirtualSensor.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        device.mojom.SensorProvider_UpdateVirtualSensor_ParamsSpec.$,
        device.mojom.SensorProvider_UpdateVirtualSensor_ResponseParamsSpec.$,
        impl.updateVirtualSensor.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        device.mojom.SensorProvider_RemoveVirtualSensor_ParamsSpec.$,
        device.mojom.SensorProvider_RemoveVirtualSensor_ResponseParamsSpec.$,
        impl.removeVirtualSensor.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        device.mojom.SensorProvider_GetVirtualSensorInformation_ParamsSpec.$,
        device.mojom.SensorProvider_GetVirtualSensorInformation_ResponseParamsSpec.$,
        impl.getVirtualSensorInformation.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
device.mojom.SensorProvider = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.SensorProvider";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!device.mojom.SensorProviderRemote}
   * @export
   */
  static getRemote() {
    let remote = new device.mojom.SensorProviderRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the SensorProvider
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
device.mojom.SensorProviderCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      device.mojom.SensorProviderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.SensorProviderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getSensor =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        device.mojom.SensorProvider_GetSensor_ParamsSpec.$,
        device.mojom.SensorProvider_GetSensor_ResponseParamsSpec.$,
        this.getSensor.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createVirtualSensor =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        device.mojom.SensorProvider_CreateVirtualSensor_ParamsSpec.$,
        device.mojom.SensorProvider_CreateVirtualSensor_ResponseParamsSpec.$,
        this.createVirtualSensor.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateVirtualSensor =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        device.mojom.SensorProvider_UpdateVirtualSensor_ParamsSpec.$,
        device.mojom.SensorProvider_UpdateVirtualSensor_ResponseParamsSpec.$,
        this.updateVirtualSensor.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.removeVirtualSensor =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        device.mojom.SensorProvider_RemoveVirtualSensor_ParamsSpec.$,
        device.mojom.SensorProvider_RemoveVirtualSensor_ResponseParamsSpec.$,
        this.removeVirtualSensor.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getVirtualSensorInformation =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        device.mojom.SensorProvider_GetVirtualSensorInformation_ParamsSpec.$,
        device.mojom.SensorProvider_GetVirtualSensorInformation_ResponseParamsSpec.$,
        this.getVirtualSensorInformation.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('device.mojom.SensorInitParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.SensorInitParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.VirtualSensorMetadataSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.VirtualSensorMetadataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.VirtualSensorInformationSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.VirtualSensorInformationSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.SensorProvider_GetSensor_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.SensorProvider_GetSensor_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.SensorProvider_GetSensor_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.SensorProvider_GetSensor_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.SensorProvider_CreateVirtualSensor_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.SensorProvider_CreateVirtualSensor_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.SensorProvider_CreateVirtualSensor_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.SensorProvider_CreateVirtualSensor_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.SensorProvider_UpdateVirtualSensor_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.SensorProvider_UpdateVirtualSensor_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.SensorProvider_UpdateVirtualSensor_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.SensorProvider_UpdateVirtualSensor_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.SensorProvider_RemoveVirtualSensor_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.SensorProvider_RemoveVirtualSensor_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.SensorProvider_RemoveVirtualSensor_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.SensorProvider_RemoveVirtualSensor_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.SensorProvider_GetVirtualSensorInformation_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.SensorProvider_GetVirtualSensorInformation_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.SensorProvider_GetVirtualSensorInformation_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.SensorProvider_GetVirtualSensorInformation_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.GetVirtualSensorInformationResultSpec');
/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
device.mojom.GetVirtualSensorInformationResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { !bigint }
 * @export
 */
device.mojom.SensorInitParams_READ_BUFFER_SIZE_FOR_TESTS =
    BigInt('48');



mojo.internal.Struct(
    device.mojom.SensorInitParamsSpec.$,
    'SensorInitParams',
    [
      mojo.internal.StructField(
        'sensor', 0,
        0,
        mojo.internal.InterfaceProxy(device.mojom.SensorRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'clientReceiver', 8,
        0,
        mojo.internal.InterfaceRequest(device.mojom.SensorClientPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'memory', 16,
        0,
        mojoBase.mojom.ReadOnlySharedMemoryRegionSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'bufferOffset', 24,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'mode', 12,
        0,
        device.mojom.ReportingModeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'defaultConfiguration', 32,
        0,
        device.mojom.SensorConfigurationSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'maximumFrequency', 40,
        0,
        mojo.internal.Double,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'minimumFrequency', 48,
        0,
        mojo.internal.Double,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 64],]);



goog.provide('device.mojom.SensorInitParams');

/** @record */
device.mojom.SensorInitParams = class {
  constructor() {
    /** @export { !device.mojom.SensorRemote } */
    this.sensor;
    /** @export { !device.mojom.SensorClientPendingReceiver } */
    this.clientReceiver;
    /** @export { !mojoBase.mojom.ReadOnlySharedMemoryRegion } */
    this.memory;
    /** @export { !bigint } */
    this.bufferOffset;
    /** @export { !device.mojom.ReportingMode } */
    this.mode;
    /** @export { !device.mojom.SensorConfiguration } */
    this.defaultConfiguration;
    /** @export { !number } */
    this.maximumFrequency;
    /** @export { !number } */
    this.minimumFrequency;
  }
};



mojo.internal.Struct(
    device.mojom.VirtualSensorMetadataSpec.$,
    'VirtualSensorMetadata',
    [
      mojo.internal.StructField(
        'available', 0,
        0,
        mojo.internal.Bool,
        true,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'maximum_frequency_$flag', 0,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: true,
          linkedValueFieldName: "maximum_frequency_$value",
          originalFieldName: "maximumFrequency",
        }
      ),
      mojo.internal.StructField(
        'maximum_frequency_$value', 8,
        0,
        mojo.internal.Double,
        0,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: false,
          originalFieldName: "maximumFrequency",
        }
      ),
      mojo.internal.StructField(
        'minimum_frequency_$flag', 0,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: true,
          linkedValueFieldName: "minimum_frequency_$value",
          originalFieldName: "minimumFrequency",
        }
      ),
      mojo.internal.StructField(
        'minimum_frequency_$value', 16,
        0,
        mojo.internal.Double,
        0,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: false,
          originalFieldName: "minimumFrequency",
        }
      ),
      mojo.internal.StructField(
        'reporting_mode_$flag', 0,
        3,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: true,
          linkedValueFieldName: "reporting_mode_$value",
          originalFieldName: "reportingMode",
        }
      ),
      mojo.internal.StructField(
        'reporting_mode_$value', 4,
        0,
        device.mojom.ReportingModeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: false,
          originalFieldName: "reportingMode",
        }
      ),
    ],
    [[0, 32],]);



goog.provide('device.mojom.VirtualSensorMetadata');

/** @record */
device.mojom.VirtualSensorMetadata = class {
  constructor() {
    /** @export { !boolean } */
    this.available;
    /** @export { (number|undefined) } */
    this.maximumFrequency;
    /** @export { (number|undefined) } */
    this.minimumFrequency;
    /** @export { (device.mojom.ReportingMode|undefined) } */
    this.reportingMode;
  }
};



mojo.internal.Struct(
    device.mojom.VirtualSensorInformationSpec.$,
    'VirtualSensorInformation',
    [
      mojo.internal.StructField(
        'samplingFrequency', 0,
        0,
        mojo.internal.Double,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.VirtualSensorInformation');

/** @record */
device.mojom.VirtualSensorInformation = class {
  constructor() {
    /** @export { !number } */
    this.samplingFrequency;
  }
};



mojo.internal.Struct(
    device.mojom.SensorProvider_GetSensor_ParamsSpec.$,
    'SensorProvider_GetSensor_Params',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        device.mojom.SensorTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.SensorProvider_GetSensor_Params');

/** @record */
device.mojom.SensorProvider_GetSensor_Params = class {
  constructor() {
    /** @export { !device.mojom.SensorType } */
    this.type;
  }
};



mojo.internal.Struct(
    device.mojom.SensorProvider_GetSensor_ResponseParamsSpec.$,
    'SensorProvider_GetSensor_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        device.mojom.SensorCreationResultSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'initParams', 8,
        0,
        device.mojom.SensorInitParamsSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('device.mojom.SensorProvider_GetSensor_ResponseParams');

/** @record */
device.mojom.SensorProvider_GetSensor_ResponseParams = class {
  constructor() {
    /** @export { !device.mojom.SensorCreationResult } */
    this.result;
    /** @export { (device.mojom.SensorInitParams|undefined) } */
    this.initParams;
  }
};



mojo.internal.Struct(
    device.mojom.SensorProvider_CreateVirtualSensor_ParamsSpec.$,
    'SensorProvider_CreateVirtualSensor_Params',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        device.mojom.SensorTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'metadata', 8,
        0,
        device.mojom.VirtualSensorMetadataSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('device.mojom.SensorProvider_CreateVirtualSensor_Params');

/** @record */
device.mojom.SensorProvider_CreateVirtualSensor_Params = class {
  constructor() {
    /** @export { !device.mojom.SensorType } */
    this.type;
    /** @export { !device.mojom.VirtualSensorMetadata } */
    this.metadata;
  }
};



mojo.internal.Struct(
    device.mojom.SensorProvider_CreateVirtualSensor_ResponseParamsSpec.$,
    'SensorProvider_CreateVirtualSensor_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        device.mojom.CreateVirtualSensorResultSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.SensorProvider_CreateVirtualSensor_ResponseParams');

/** @record */
device.mojom.SensorProvider_CreateVirtualSensor_ResponseParams = class {
  constructor() {
    /** @export { !device.mojom.CreateVirtualSensorResult } */
    this.result;
  }
};



mojo.internal.Struct(
    device.mojom.SensorProvider_UpdateVirtualSensor_ParamsSpec.$,
    'SensorProvider_UpdateVirtualSensor_Params',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        device.mojom.SensorTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'reading', 8,
        0,
        device.mojom.SensorReadingRawSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('device.mojom.SensorProvider_UpdateVirtualSensor_Params');

/** @record */
device.mojom.SensorProvider_UpdateVirtualSensor_Params = class {
  constructor() {
    /** @export { !device.mojom.SensorType } */
    this.type;
    /** @export { !device.mojom.SensorReadingRaw } */
    this.reading;
  }
};



mojo.internal.Struct(
    device.mojom.SensorProvider_UpdateVirtualSensor_ResponseParamsSpec.$,
    'SensorProvider_UpdateVirtualSensor_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        device.mojom.UpdateVirtualSensorResultSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.SensorProvider_UpdateVirtualSensor_ResponseParams');

/** @record */
device.mojom.SensorProvider_UpdateVirtualSensor_ResponseParams = class {
  constructor() {
    /** @export { !device.mojom.UpdateVirtualSensorResult } */
    this.result;
  }
};



mojo.internal.Struct(
    device.mojom.SensorProvider_RemoveVirtualSensor_ParamsSpec.$,
    'SensorProvider_RemoveVirtualSensor_Params',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        device.mojom.SensorTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.SensorProvider_RemoveVirtualSensor_Params');

/** @record */
device.mojom.SensorProvider_RemoveVirtualSensor_Params = class {
  constructor() {
    /** @export { !device.mojom.SensorType } */
    this.type;
  }
};



mojo.internal.Struct(
    device.mojom.SensorProvider_RemoveVirtualSensor_ResponseParamsSpec.$,
    'SensorProvider_RemoveVirtualSensor_ResponseParams',
    [
    ],
    [[0, 8],]);



goog.provide('device.mojom.SensorProvider_RemoveVirtualSensor_ResponseParams');

/** @record */
device.mojom.SensorProvider_RemoveVirtualSensor_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    device.mojom.SensorProvider_GetVirtualSensorInformation_ParamsSpec.$,
    'SensorProvider_GetVirtualSensorInformation_Params',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        device.mojom.SensorTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.SensorProvider_GetVirtualSensorInformation_Params');

/** @record */
device.mojom.SensorProvider_GetVirtualSensorInformation_Params = class {
  constructor() {
    /** @export { !device.mojom.SensorType } */
    this.type;
  }
};



mojo.internal.Struct(
    device.mojom.SensorProvider_GetVirtualSensorInformation_ResponseParamsSpec.$,
    'SensorProvider_GetVirtualSensorInformation_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        device.mojom.GetVirtualSensorInformationResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('device.mojom.SensorProvider_GetVirtualSensorInformation_ResponseParams');

/** @record */
device.mojom.SensorProvider_GetVirtualSensorInformation_ResponseParams = class {
  constructor() {
    /** @export { !device.mojom.GetVirtualSensorInformationResult } */
    this.result;
  }
};

goog.provide('device.mojom.GetVirtualSensorInformationResult');


mojo.internal.Union(
    device.mojom.GetVirtualSensorInformationResultSpec.$, 'GetVirtualSensorInformationResult',
    {
      'info': {
        'ordinal': 0,
        'type': device.mojom.VirtualSensorInformationSpec.$,
      },
      'error': {
        'ordinal': 1,
        'type': device.mojom.GetVirtualSensorInformationErrorSpec.$,
      },
    });

/**
 * @typedef { {
 *   info: (!device.mojom.VirtualSensorInformation|undefined),
 *   error: (!device.mojom.GetVirtualSensorInformationError|undefined),
 * } }
 */
device.mojom.GetVirtualSensorInformationResult;
