// services/device/public/mojom/sensor_provider.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/device/public/mojom/sensor_provider.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('device.mojom');
  var shared_memory$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/shared_memory.mojom', '../../../../mojo/public/mojom/base/shared_memory.mojom.js');
  }
  var sensor$ =
      mojo.internal.exposeNamespace('device.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/device/public/mojom/sensor.mojom', 'sensor.mojom.js');
  }


  var SensorCreationResult = {};
  SensorCreationResult.SUCCESS = 0;
  SensorCreationResult.ERROR_NOT_AVAILABLE = 1;
  SensorCreationResult.ERROR_NOT_ALLOWED = 2;
  SensorCreationResult.MIN_VALUE = 0;
  SensorCreationResult.MAX_VALUE = 2;

  SensorCreationResult.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  SensorCreationResult.toKnownEnumValue = function(value) {
    return value;
  };

  SensorCreationResult.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var CreateVirtualSensorResult = {};
  CreateVirtualSensorResult.kSuccess = 0;
  CreateVirtualSensorResult.kSensorTypeAlreadyOverridden = 1;
  CreateVirtualSensorResult.MIN_VALUE = 0;
  CreateVirtualSensorResult.MAX_VALUE = 1;

  CreateVirtualSensorResult.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  CreateVirtualSensorResult.toKnownEnumValue = function(value) {
    return value;
  };

  CreateVirtualSensorResult.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var UpdateVirtualSensorResult = {};
  UpdateVirtualSensorResult.kSuccess = 0;
  UpdateVirtualSensorResult.kSensorTypeNotOverridden = 1;
  UpdateVirtualSensorResult.MIN_VALUE = 0;
  UpdateVirtualSensorResult.MAX_VALUE = 1;

  UpdateVirtualSensorResult.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  UpdateVirtualSensorResult.toKnownEnumValue = function(value) {
    return value;
  };

  UpdateVirtualSensorResult.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var GetVirtualSensorInformationError = {};
  GetVirtualSensorInformationError.kSensorTypeNotOverridden = 0;
  GetVirtualSensorInformationError.MIN_VALUE = 0;
  GetVirtualSensorInformationError.MAX_VALUE = 0;

  GetVirtualSensorInformationError.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
      return true;
    }
    return false;
  };

  GetVirtualSensorInformationError.toKnownEnumValue = function(value) {
    return value;
  };

  GetVirtualSensorInformationError.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function SensorInitParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SensorInitParams.READ_BUFFER_SIZE_FOR_TESTS = 48;
  SensorInitParams.prototype.initDefaults_ = function() {
    this.sensor = new sensor$.SensorPtr();
    this.clientReceiver = new bindings.InterfaceRequest();
    this.mode = 0;
    this.memory = null;
    this.bufferOffset = 0;
    this.defaultConfiguration = null;
    this.maximumFrequency = 0;
    this.minimumFrequency = 0;
  };
  SensorInitParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SensorInitParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 64}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SensorInitParams.sensor
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SensorInitParams.clientReceiver
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate SensorInitParams.memory
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, shared_memory$.ReadOnlySharedMemoryRegion, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate SensorInitParams.mode
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 12, sensor$.ReportingMode);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SensorInitParams.defaultConfiguration
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, sensor$.SensorConfiguration, false);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  SensorInitParams.encodedSize = codec.kStructHeaderSize + 56;

  SensorInitParams.decode = function(decoder) {
    var packed;
    var val = new SensorInitParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.sensor =
        decoder.decodeStruct(new codec.Interface(sensor$.SensorPtr));
    val.clientReceiver =
        decoder.decodeStruct(codec.InterfaceRequest);
    val.mode =
        decoder.decodeStruct(new codec.Enum(sensor$.ReportingMode));
    val.memory =
        decoder.decodeStructPointer(shared_memory$.ReadOnlySharedMemoryRegion);
    val.bufferOffset =
        decoder.decodeStruct(codec.Uint64);
    val.defaultConfiguration =
        decoder.decodeStructPointer(sensor$.SensorConfiguration);
    val.maximumFrequency =
        decoder.decodeStruct(codec.Double);
    val.minimumFrequency =
        decoder.decodeStruct(codec.Double);
    return val;
  };

  SensorInitParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SensorInitParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(new codec.Interface(sensor$.SensorPtr), val.sensor);
    encoder.encodeStruct(codec.InterfaceRequest, val.clientReceiver);
    encoder.encodeStruct(codec.Int32, val.mode);
    encoder.encodeStructPointer(shared_memory$.ReadOnlySharedMemoryRegion, val.memory);
    encoder.encodeStruct(codec.Uint64, val.bufferOffset);
    encoder.encodeStructPointer(sensor$.SensorConfiguration, val.defaultConfiguration);
    encoder.encodeStruct(codec.Double, val.maximumFrequency);
    encoder.encodeStruct(codec.Double, val.minimumFrequency);
  };
  function VirtualSensorMetadata(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  VirtualSensorMetadata.prototype.initDefaults_ = function() {
    this.available = true;
    this.maximum_frequency_$flag = false;
    this.minimum_frequency_$flag = false;
    this.reporting_mode_$flag = false;
    this.reporting_mode_$value = 0;
    this.maximum_frequency_$value = 0;
    this.minimum_frequency_$value = 0;
  };
  VirtualSensorMetadata.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  VirtualSensorMetadata.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;








    // validate VirtualSensorMetadata.reporting_mode_$value
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, sensor$.ReportingMode);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  VirtualSensorMetadata.encodedSize = codec.kStructHeaderSize + 24;

  VirtualSensorMetadata.decode = function(decoder) {
    var packed;
    var val = new VirtualSensorMetadata();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.available = (packed >> 0) & 1 ? true : false;
    val.maximum_frequency_$flag = (packed >> 1) & 1 ? true : false;
    val.minimum_frequency_$flag = (packed >> 2) & 1 ? true : false;
    val.reporting_mode_$flag = (packed >> 3) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.reporting_mode_$value =
        decoder.decodeStruct(new codec.Enum(sensor$.ReportingMode));
    val.maximum_frequency_$value =
        decoder.decodeStruct(codec.Double);
    val.minimum_frequency_$value =
        decoder.decodeStruct(codec.Double);
    return val;
  };

  VirtualSensorMetadata.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(VirtualSensorMetadata.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.available & 1) << 0
    packed |= (val.maximum_frequency_$flag & 1) << 1
    packed |= (val.minimum_frequency_$flag & 1) << 2
    packed |= (val.reporting_mode_$flag & 1) << 3
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.reporting_mode_$value);
    encoder.encodeStruct(codec.Double, val.maximum_frequency_$value);
    encoder.encodeStruct(codec.Double, val.minimum_frequency_$value);
  };
  function VirtualSensorInformation(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  VirtualSensorInformation.prototype.initDefaults_ = function() {
    this.samplingFrequency = 0;
  };
  VirtualSensorInformation.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  VirtualSensorInformation.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  VirtualSensorInformation.encodedSize = codec.kStructHeaderSize + 8;

  VirtualSensorInformation.decode = function(decoder) {
    var packed;
    var val = new VirtualSensorInformation();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.samplingFrequency =
        decoder.decodeStruct(codec.Double);
    return val;
  };

  VirtualSensorInformation.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(VirtualSensorInformation.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Double, val.samplingFrequency);
  };
  function SensorProvider_GetSensor_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SensorProvider_GetSensor_Params.prototype.initDefaults_ = function() {
    this.type = 0;
  };
  SensorProvider_GetSensor_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SensorProvider_GetSensor_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SensorProvider_GetSensor_Params.type
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, sensor$.SensorType);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SensorProvider_GetSensor_Params.encodedSize = codec.kStructHeaderSize + 8;

  SensorProvider_GetSensor_Params.decode = function(decoder) {
    var packed;
    var val = new SensorProvider_GetSensor_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.type =
        decoder.decodeStruct(new codec.Enum(sensor$.SensorType));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  SensorProvider_GetSensor_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SensorProvider_GetSensor_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.type);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function SensorProvider_GetSensor_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SensorProvider_GetSensor_ResponseParams.prototype.initDefaults_ = function() {
    this.result = 0;
    this.initParams = null;
  };
  SensorProvider_GetSensor_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SensorProvider_GetSensor_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SensorProvider_GetSensor_ResponseParams.result
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, SensorCreationResult);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SensorProvider_GetSensor_ResponseParams.initParams
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, SensorInitParams, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SensorProvider_GetSensor_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  SensorProvider_GetSensor_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new SensorProvider_GetSensor_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(new codec.Enum(SensorCreationResult));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.initParams =
        decoder.decodeStructPointer(SensorInitParams);
    return val;
  };

  SensorProvider_GetSensor_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SensorProvider_GetSensor_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.result);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(SensorInitParams, val.initParams);
  };
  function SensorProvider_CreateVirtualSensor_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SensorProvider_CreateVirtualSensor_Params.prototype.initDefaults_ = function() {
    this.type = 0;
    this.metadata = null;
  };
  SensorProvider_CreateVirtualSensor_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SensorProvider_CreateVirtualSensor_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SensorProvider_CreateVirtualSensor_Params.type
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, sensor$.SensorType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SensorProvider_CreateVirtualSensor_Params.metadata
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, VirtualSensorMetadata, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SensorProvider_CreateVirtualSensor_Params.encodedSize = codec.kStructHeaderSize + 16;

  SensorProvider_CreateVirtualSensor_Params.decode = function(decoder) {
    var packed;
    var val = new SensorProvider_CreateVirtualSensor_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.type =
        decoder.decodeStruct(new codec.Enum(sensor$.SensorType));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.metadata =
        decoder.decodeStructPointer(VirtualSensorMetadata);
    return val;
  };

  SensorProvider_CreateVirtualSensor_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SensorProvider_CreateVirtualSensor_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.type);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(VirtualSensorMetadata, val.metadata);
  };
  function SensorProvider_CreateVirtualSensor_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SensorProvider_CreateVirtualSensor_ResponseParams.prototype.initDefaults_ = function() {
    this.result = 0;
  };
  SensorProvider_CreateVirtualSensor_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SensorProvider_CreateVirtualSensor_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SensorProvider_CreateVirtualSensor_ResponseParams.result
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, CreateVirtualSensorResult);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SensorProvider_CreateVirtualSensor_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  SensorProvider_CreateVirtualSensor_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new SensorProvider_CreateVirtualSensor_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(new codec.Enum(CreateVirtualSensorResult));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  SensorProvider_CreateVirtualSensor_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SensorProvider_CreateVirtualSensor_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.result);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function SensorProvider_UpdateVirtualSensor_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SensorProvider_UpdateVirtualSensor_Params.prototype.initDefaults_ = function() {
    this.type = 0;
    this.reading = null;
  };
  SensorProvider_UpdateVirtualSensor_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SensorProvider_UpdateVirtualSensor_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SensorProvider_UpdateVirtualSensor_Params.type
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, sensor$.SensorType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SensorProvider_UpdateVirtualSensor_Params.reading
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, sensor$.SensorReadingRaw, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SensorProvider_UpdateVirtualSensor_Params.encodedSize = codec.kStructHeaderSize + 16;

  SensorProvider_UpdateVirtualSensor_Params.decode = function(decoder) {
    var packed;
    var val = new SensorProvider_UpdateVirtualSensor_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.type =
        decoder.decodeStruct(new codec.Enum(sensor$.SensorType));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.reading =
        decoder.decodeStructPointer(sensor$.SensorReadingRaw);
    return val;
  };

  SensorProvider_UpdateVirtualSensor_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SensorProvider_UpdateVirtualSensor_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.type);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(sensor$.SensorReadingRaw, val.reading);
  };
  function SensorProvider_UpdateVirtualSensor_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SensorProvider_UpdateVirtualSensor_ResponseParams.prototype.initDefaults_ = function() {
    this.result = 0;
  };
  SensorProvider_UpdateVirtualSensor_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SensorProvider_UpdateVirtualSensor_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SensorProvider_UpdateVirtualSensor_ResponseParams.result
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, UpdateVirtualSensorResult);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SensorProvider_UpdateVirtualSensor_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  SensorProvider_UpdateVirtualSensor_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new SensorProvider_UpdateVirtualSensor_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(new codec.Enum(UpdateVirtualSensorResult));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  SensorProvider_UpdateVirtualSensor_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SensorProvider_UpdateVirtualSensor_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.result);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function SensorProvider_RemoveVirtualSensor_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SensorProvider_RemoveVirtualSensor_Params.prototype.initDefaults_ = function() {
    this.type = 0;
  };
  SensorProvider_RemoveVirtualSensor_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SensorProvider_RemoveVirtualSensor_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SensorProvider_RemoveVirtualSensor_Params.type
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, sensor$.SensorType);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SensorProvider_RemoveVirtualSensor_Params.encodedSize = codec.kStructHeaderSize + 8;

  SensorProvider_RemoveVirtualSensor_Params.decode = function(decoder) {
    var packed;
    var val = new SensorProvider_RemoveVirtualSensor_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.type =
        decoder.decodeStruct(new codec.Enum(sensor$.SensorType));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  SensorProvider_RemoveVirtualSensor_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SensorProvider_RemoveVirtualSensor_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.type);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function SensorProvider_RemoveVirtualSensor_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SensorProvider_RemoveVirtualSensor_ResponseParams.prototype.initDefaults_ = function() {
  };
  SensorProvider_RemoveVirtualSensor_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SensorProvider_RemoveVirtualSensor_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SensorProvider_RemoveVirtualSensor_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  SensorProvider_RemoveVirtualSensor_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new SensorProvider_RemoveVirtualSensor_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  SensorProvider_RemoveVirtualSensor_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SensorProvider_RemoveVirtualSensor_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function SensorProvider_GetVirtualSensorInformation_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SensorProvider_GetVirtualSensorInformation_Params.prototype.initDefaults_ = function() {
    this.type = 0;
  };
  SensorProvider_GetVirtualSensorInformation_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SensorProvider_GetVirtualSensorInformation_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SensorProvider_GetVirtualSensorInformation_Params.type
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, sensor$.SensorType);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SensorProvider_GetVirtualSensorInformation_Params.encodedSize = codec.kStructHeaderSize + 8;

  SensorProvider_GetVirtualSensorInformation_Params.decode = function(decoder) {
    var packed;
    var val = new SensorProvider_GetVirtualSensorInformation_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.type =
        decoder.decodeStruct(new codec.Enum(sensor$.SensorType));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  SensorProvider_GetVirtualSensorInformation_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SensorProvider_GetVirtualSensorInformation_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.type);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function SensorProvider_GetVirtualSensorInformation_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SensorProvider_GetVirtualSensorInformation_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  SensorProvider_GetVirtualSensorInformation_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SensorProvider_GetVirtualSensorInformation_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SensorProvider_GetVirtualSensorInformation_ResponseParams.result
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, GetVirtualSensorInformationResult, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SensorProvider_GetVirtualSensorInformation_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  SensorProvider_GetVirtualSensorInformation_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new SensorProvider_GetVirtualSensorInformation_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(GetVirtualSensorInformationResult);
    return val;
  };

  SensorProvider_GetVirtualSensorInformation_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SensorProvider_GetVirtualSensorInformation_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(GetVirtualSensorInformationResult, val.result);
  };

  function GetVirtualSensorInformationResult(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  GetVirtualSensorInformationResult.Tags = {
    info: 0,
    error: 1,
  };

  GetVirtualSensorInformationResult.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  GetVirtualSensorInformationResult.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "info",
        "error",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a GetVirtualSensorInformationResult member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(GetVirtualSensorInformationResult.prototype, "info", {
    get: function() {
      if (this.$tag != GetVirtualSensorInformationResult.Tags.info) {
        throw new ReferenceError(
            "GetVirtualSensorInformationResult.info is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = GetVirtualSensorInformationResult.Tags.info;
      this.$data = value;
    }
  });
  Object.defineProperty(GetVirtualSensorInformationResult.prototype, "error", {
    get: function() {
      if (this.$tag != GetVirtualSensorInformationResult.Tags.error) {
        throw new ReferenceError(
            "GetVirtualSensorInformationResult.error is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = GetVirtualSensorInformationResult.Tags.error;
      this.$data = value;
    }
  });


    GetVirtualSensorInformationResult.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case GetVirtualSensorInformationResult.Tags.info:
          encoder.encodeStructPointer(VirtualSensorInformation, val.info);
          break;
        case GetVirtualSensorInformationResult.Tags.error:
          encoder.encodeStruct(codec.Int32, val.error);
          break;
      }
      encoder.align();
    };


    GetVirtualSensorInformationResult.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new GetVirtualSensorInformationResult();
      var tag = decoder.readUint32();
      switch (tag) {
        case GetVirtualSensorInformationResult.Tags.info:
          result.info = decoder.decodeStructPointer(VirtualSensorInformation);
          break;
        case GetVirtualSensorInformationResult.Tags.error:
          result.error = decoder.decodeStruct(new codec.Enum(GetVirtualSensorInformationError));
          break;
      }
      decoder.align();

      return result;
    };


    GetVirtualSensorInformationResult.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case GetVirtualSensorInformationResult.Tags.info:
          

    // validate GetVirtualSensorInformationResult.info
    err = messageValidator.validateStructPointer(data_offset, VirtualSensorInformation, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case GetVirtualSensorInformationResult.Tags.error:
          

    // validate GetVirtualSensorInformationResult.error
    err = messageValidator.validateEnum(data_offset, GetVirtualSensorInformationError);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  GetVirtualSensorInformationResult.encodedSize = 16;
  var kSensorProvider_GetSensor_Name = 0;
  var kSensorProvider_CreateVirtualSensor_Name = 1;
  var kSensorProvider_UpdateVirtualSensor_Name = 2;
  var kSensorProvider_RemoveVirtualSensor_Name = 3;
  var kSensorProvider_GetVirtualSensorInformation_Name = 4;

  function SensorProviderPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(SensorProvider,
                                                   handleOrPtrInfo);
  }

  function SensorProviderAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        SensorProvider, associatedInterfacePtrInfo);
  }

  SensorProviderAssociatedPtr.prototype =
      Object.create(SensorProviderPtr.prototype);
  SensorProviderAssociatedPtr.prototype.constructor =
      SensorProviderAssociatedPtr;

  function SensorProviderProxy(receiver) {
    this.receiver_ = receiver;
  }
  SensorProviderPtr.prototype.getSensor = function() {
    return SensorProviderProxy.prototype.getSensor
        .apply(this.ptr.getProxy(), arguments);
  };

  SensorProviderProxy.prototype.getSensor = function(type) {
    var params_ = new SensorProvider_GetSensor_Params();
    params_.type = type;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kSensorProvider_GetSensor_Name,
          codec.align(SensorProvider_GetSensor_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(SensorProvider_GetSensor_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(SensorProvider_GetSensor_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  SensorProviderPtr.prototype.createVirtualSensor = function() {
    return SensorProviderProxy.prototype.createVirtualSensor
        .apply(this.ptr.getProxy(), arguments);
  };

  SensorProviderProxy.prototype.createVirtualSensor = function(type, metadata) {
    var params_ = new SensorProvider_CreateVirtualSensor_Params();
    params_.type = type;
    params_.metadata = metadata;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kSensorProvider_CreateVirtualSensor_Name,
          codec.align(SensorProvider_CreateVirtualSensor_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(SensorProvider_CreateVirtualSensor_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(SensorProvider_CreateVirtualSensor_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  SensorProviderPtr.prototype.updateVirtualSensor = function() {
    return SensorProviderProxy.prototype.updateVirtualSensor
        .apply(this.ptr.getProxy(), arguments);
  };

  SensorProviderProxy.prototype.updateVirtualSensor = function(type, reading) {
    var params_ = new SensorProvider_UpdateVirtualSensor_Params();
    params_.type = type;
    params_.reading = reading;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kSensorProvider_UpdateVirtualSensor_Name,
          codec.align(SensorProvider_UpdateVirtualSensor_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(SensorProvider_UpdateVirtualSensor_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(SensorProvider_UpdateVirtualSensor_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  SensorProviderPtr.prototype.removeVirtualSensor = function() {
    return SensorProviderProxy.prototype.removeVirtualSensor
        .apply(this.ptr.getProxy(), arguments);
  };

  SensorProviderProxy.prototype.removeVirtualSensor = function(type) {
    var params_ = new SensorProvider_RemoveVirtualSensor_Params();
    params_.type = type;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kSensorProvider_RemoveVirtualSensor_Name,
          codec.align(SensorProvider_RemoveVirtualSensor_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(SensorProvider_RemoveVirtualSensor_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(SensorProvider_RemoveVirtualSensor_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  SensorProviderPtr.prototype.getVirtualSensorInformation = function() {
    return SensorProviderProxy.prototype.getVirtualSensorInformation
        .apply(this.ptr.getProxy(), arguments);
  };

  SensorProviderProxy.prototype.getVirtualSensorInformation = function(type) {
    var params_ = new SensorProvider_GetVirtualSensorInformation_Params();
    params_.type = type;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kSensorProvider_GetVirtualSensorInformation_Name,
          codec.align(SensorProvider_GetVirtualSensorInformation_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(SensorProvider_GetVirtualSensorInformation_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(SensorProvider_GetVirtualSensorInformation_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function SensorProviderStub(delegate) {
    this.delegate_ = delegate;
  }
  SensorProviderStub.prototype.getSensor = function(type) {
    return this.delegate_ && this.delegate_.getSensor && this.delegate_.getSensor(type);
  }
  SensorProviderStub.prototype.createVirtualSensor = function(type, metadata) {
    return this.delegate_ && this.delegate_.createVirtualSensor && this.delegate_.createVirtualSensor(type, metadata);
  }
  SensorProviderStub.prototype.updateVirtualSensor = function(type, reading) {
    return this.delegate_ && this.delegate_.updateVirtualSensor && this.delegate_.updateVirtualSensor(type, reading);
  }
  SensorProviderStub.prototype.removeVirtualSensor = function(type) {
    return this.delegate_ && this.delegate_.removeVirtualSensor && this.delegate_.removeVirtualSensor(type);
  }
  SensorProviderStub.prototype.getVirtualSensorInformation = function(type) {
    return this.delegate_ && this.delegate_.getVirtualSensorInformation && this.delegate_.getVirtualSensorInformation(type);
  }

  SensorProviderStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  SensorProviderStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kSensorProvider_GetSensor_Name:
      var params = reader.decodeStruct(SensorProvider_GetSensor_Params);
      this.getSensor(params.type).then(function(response) {
        var responseParams =
            new SensorProvider_GetSensor_ResponseParams();
        responseParams.result = response.result;
        responseParams.initParams = response.initParams;
        var builder = new codec.MessageV1Builder(
            kSensorProvider_GetSensor_Name,
            codec.align(SensorProvider_GetSensor_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(SensorProvider_GetSensor_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kSensorProvider_CreateVirtualSensor_Name:
      var params = reader.decodeStruct(SensorProvider_CreateVirtualSensor_Params);
      this.createVirtualSensor(params.type, params.metadata).then(function(response) {
        var responseParams =
            new SensorProvider_CreateVirtualSensor_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kSensorProvider_CreateVirtualSensor_Name,
            codec.align(SensorProvider_CreateVirtualSensor_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(SensorProvider_CreateVirtualSensor_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kSensorProvider_UpdateVirtualSensor_Name:
      var params = reader.decodeStruct(SensorProvider_UpdateVirtualSensor_Params);
      this.updateVirtualSensor(params.type, params.reading).then(function(response) {
        var responseParams =
            new SensorProvider_UpdateVirtualSensor_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kSensorProvider_UpdateVirtualSensor_Name,
            codec.align(SensorProvider_UpdateVirtualSensor_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(SensorProvider_UpdateVirtualSensor_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kSensorProvider_RemoveVirtualSensor_Name:
      var params = reader.decodeStruct(SensorProvider_RemoveVirtualSensor_Params);
      this.removeVirtualSensor(params.type).then(function(response) {
        var responseParams =
            new SensorProvider_RemoveVirtualSensor_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kSensorProvider_RemoveVirtualSensor_Name,
            codec.align(SensorProvider_RemoveVirtualSensor_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(SensorProvider_RemoveVirtualSensor_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kSensorProvider_GetVirtualSensorInformation_Name:
      var params = reader.decodeStruct(SensorProvider_GetVirtualSensorInformation_Params);
      this.getVirtualSensorInformation(params.type).then(function(response) {
        var responseParams =
            new SensorProvider_GetVirtualSensorInformation_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kSensorProvider_GetVirtualSensorInformation_Name,
            codec.align(SensorProvider_GetVirtualSensorInformation_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(SensorProvider_GetVirtualSensorInformation_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateSensorProviderRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kSensorProvider_GetSensor_Name:
        if (message.expectsResponse())
          paramsClass = SensorProvider_GetSensor_Params;
      break;
      case kSensorProvider_CreateVirtualSensor_Name:
        if (message.expectsResponse())
          paramsClass = SensorProvider_CreateVirtualSensor_Params;
      break;
      case kSensorProvider_UpdateVirtualSensor_Name:
        if (message.expectsResponse())
          paramsClass = SensorProvider_UpdateVirtualSensor_Params;
      break;
      case kSensorProvider_RemoveVirtualSensor_Name:
        if (message.expectsResponse())
          paramsClass = SensorProvider_RemoveVirtualSensor_Params;
      break;
      case kSensorProvider_GetVirtualSensorInformation_Name:
        if (message.expectsResponse())
          paramsClass = SensorProvider_GetVirtualSensorInformation_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateSensorProviderResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kSensorProvider_GetSensor_Name:
        if (message.isResponse())
          paramsClass = SensorProvider_GetSensor_ResponseParams;
        break;
      case kSensorProvider_CreateVirtualSensor_Name:
        if (message.isResponse())
          paramsClass = SensorProvider_CreateVirtualSensor_ResponseParams;
        break;
      case kSensorProvider_UpdateVirtualSensor_Name:
        if (message.isResponse())
          paramsClass = SensorProvider_UpdateVirtualSensor_ResponseParams;
        break;
      case kSensorProvider_RemoveVirtualSensor_Name:
        if (message.isResponse())
          paramsClass = SensorProvider_RemoveVirtualSensor_ResponseParams;
        break;
      case kSensorProvider_GetVirtualSensorInformation_Name:
        if (message.isResponse())
          paramsClass = SensorProvider_GetVirtualSensorInformation_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var SensorProvider = {
    name: 'device.mojom.SensorProvider',
    kVersion: 0,
    ptrClass: SensorProviderPtr,
    proxyClass: SensorProviderProxy,
    stubClass: SensorProviderStub,
    validateRequest: validateSensorProviderRequest,
    validateResponse: validateSensorProviderResponse,
  };
  SensorProviderStub.prototype.validator = validateSensorProviderRequest;
  SensorProviderProxy.prototype.validator = validateSensorProviderResponse;
  exports.SensorCreationResult = SensorCreationResult;
  exports.CreateVirtualSensorResult = CreateVirtualSensorResult;
  exports.UpdateVirtualSensorResult = UpdateVirtualSensorResult;
  exports.GetVirtualSensorInformationError = GetVirtualSensorInformationError;
  exports.SensorInitParams = SensorInitParams;
  exports.VirtualSensorMetadata = VirtualSensorMetadata;
  exports.VirtualSensorInformation = VirtualSensorInformation;
  exports.GetVirtualSensorInformationResult = GetVirtualSensorInformationResult;
  exports.SensorProvider = SensorProvider;
  exports.SensorProviderPtr = SensorProviderPtr;
  exports.SensorProviderAssociatedPtr = SensorProviderAssociatedPtr;
})();