// services/device/public/mojom/sensor_provider.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';

import {
  ReadOnlySharedMemoryRegion as mojoBase_mojom_ReadOnlySharedMemoryRegion,
  ReadOnlySharedMemoryRegionSpec as mojoBase_mojom_ReadOnlySharedMemoryRegionSpec
} from '../../../../mojo/public/mojom/base/shared_memory.mojom.m.js';

import {
  ReportingMode as device_mojom_ReportingMode,
  ReportingModeSpec as device_mojom_ReportingModeSpec,
  SensorType as device_mojom_SensorType,
  SensorTypeSpec as device_mojom_SensorTypeSpec,
  SensorRemote as device_mojom_SensorRemote,
  SensorPendingReceiver as device_mojom_SensorPendingReceiver,
  SensorClientRemote as device_mojom_SensorClientRemote,
  SensorClientPendingReceiver as device_mojom_SensorClientPendingReceiver,
  SensorConfiguration as device_mojom_SensorConfiguration,
  SensorConfigurationSpec as device_mojom_SensorConfigurationSpec,
  SensorReadingRaw as device_mojom_SensorReadingRaw,
  SensorReadingRawSpec as device_mojom_SensorReadingRawSpec
} from './sensor.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const SensorCreationResultSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const SensorCreationResult = {
  
  SUCCESS: 0,
  ERROR_NOT_AVAILABLE: 1,
  ERROR_NOT_ALLOWED: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const CreateVirtualSensorResultSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const CreateVirtualSensorResult = {
  
  kSuccess: 0,
  kSensorTypeAlreadyOverridden: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const UpdateVirtualSensorResultSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const UpdateVirtualSensorResult = {
  
  kSuccess: 0,
  kSensorTypeNotOverridden: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const GetVirtualSensorInformationErrorSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const GetVirtualSensorInformationError = {
  
  kSensorTypeNotOverridden: 0,
  MIN_VALUE: 0,
  MAX_VALUE: 0,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class SensorProviderPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'device.mojom.SensorProvider', scope);
  }
}

/** @interface */
export class SensorProviderInterface {
  
  /**
   * @param { !device_mojom_SensorType } type
   * @return {!Promise<{
        result: !SensorCreationResult,
        initParams: ?SensorInitParams,
   *  }>}
   */

  getSensor(type) {}
  
  /**
   * @param { !device_mojom_SensorType } type
   * @param { !VirtualSensorMetadata } metadata
   * @return {!Promise<{
        result: !CreateVirtualSensorResult,
   *  }>}
   */

  createVirtualSensor(type, metadata) {}
  
  /**
   * @param { !device_mojom_SensorType } type
   * @param { !device_mojom_SensorReadingRaw } reading
   * @return {!Promise<{
        result: !UpdateVirtualSensorResult,
   *  }>}
   */

  updateVirtualSensor(type, reading) {}
  
  /**
   * @param { !device_mojom_SensorType } type
   * @return {!Promise}
   */

  removeVirtualSensor(type) {}
  
  /**
   * @param { !device_mojom_SensorType } type
   * @return {!Promise<{
        result: !GetVirtualSensorInformationResult,
   *  }>}
   */

  getVirtualSensorInformation(type) {}
}

/**
 * @implements { SensorProviderInterface }
 */
export class SensorProviderRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!SensorProviderPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          SensorProviderPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!SensorProviderPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !device_mojom_SensorType } type
   * @return {!Promise<{
        result: !SensorCreationResult,
        initParams: ?SensorInitParams,
   *  }>}
   */

  getSensor(
      type) {
    return this.proxy.sendMessage(
        0,
        SensorProvider_GetSensor_ParamsSpec.$,
        SensorProvider_GetSensor_ResponseParamsSpec.$,
        [
          type
        ],
        false);
  }

  
  /**
   * @param { !device_mojom_SensorType } type
   * @param { !VirtualSensorMetadata } metadata
   * @return {!Promise<{
        result: !CreateVirtualSensorResult,
   *  }>}
   */

  createVirtualSensor(
      type,
      metadata) {
    return this.proxy.sendMessage(
        1,
        SensorProvider_CreateVirtualSensor_ParamsSpec.$,
        SensorProvider_CreateVirtualSensor_ResponseParamsSpec.$,
        [
          type,
          metadata
        ],
        false);
  }

  
  /**
   * @param { !device_mojom_SensorType } type
   * @param { !device_mojom_SensorReadingRaw } reading
   * @return {!Promise<{
        result: !UpdateVirtualSensorResult,
   *  }>}
   */

  updateVirtualSensor(
      type,
      reading) {
    return this.proxy.sendMessage(
        2,
        SensorProvider_UpdateVirtualSensor_ParamsSpec.$,
        SensorProvider_UpdateVirtualSensor_ResponseParamsSpec.$,
        [
          type,
          reading
        ],
        false);
  }

  
  /**
   * @param { !device_mojom_SensorType } type
   * @return {!Promise}
   */

  removeVirtualSensor(
      type) {
    return this.proxy.sendMessage(
        3,
        SensorProvider_RemoveVirtualSensor_ParamsSpec.$,
        SensorProvider_RemoveVirtualSensor_ResponseParamsSpec.$,
        [
          type
        ],
        false);
  }

  
  /**
   * @param { !device_mojom_SensorType } type
   * @return {!Promise<{
        result: !GetVirtualSensorInformationResult,
   *  }>}
   */

  getVirtualSensorInformation(
      type) {
    return this.proxy.sendMessage(
        4,
        SensorProvider_GetVirtualSensorInformation_ParamsSpec.$,
        SensorProvider_GetVirtualSensorInformation_ResponseParamsSpec.$,
        [
          type
        ],
        false);
  }
}

/**
 * An object which receives request messages for the SensorProvider
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class SensorProviderReceiver {
  /**
   * @param {!SensorProviderInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!SensorProviderRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        SensorProviderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SensorProviderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        SensorProvider_GetSensor_ParamsSpec.$,
        SensorProvider_GetSensor_ResponseParamsSpec.$,
        impl.getSensor.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        SensorProvider_CreateVirtualSensor_ParamsSpec.$,
        SensorProvider_CreateVirtualSensor_ResponseParamsSpec.$,
        impl.createVirtualSensor.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        SensorProvider_UpdateVirtualSensor_ParamsSpec.$,
        SensorProvider_UpdateVirtualSensor_ResponseParamsSpec.$,
        impl.updateVirtualSensor.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        SensorProvider_RemoveVirtualSensor_ParamsSpec.$,
        SensorProvider_RemoveVirtualSensor_ResponseParamsSpec.$,
        impl.removeVirtualSensor.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        SensorProvider_GetVirtualSensorInformation_ParamsSpec.$,
        SensorProvider_GetVirtualSensorInformation_ResponseParamsSpec.$,
        impl.getVirtualSensorInformation.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class SensorProvider {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.SensorProvider";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!SensorProviderRemote}
   */
  static getRemote() {
    let remote = new SensorProviderRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the SensorProvider
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class SensorProviderCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      SensorProviderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SensorProviderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getSensor =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        SensorProvider_GetSensor_ParamsSpec.$,
        SensorProvider_GetSensor_ResponseParamsSpec.$,
        this.getSensor.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createVirtualSensor =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        SensorProvider_CreateVirtualSensor_ParamsSpec.$,
        SensorProvider_CreateVirtualSensor_ResponseParamsSpec.$,
        this.createVirtualSensor.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateVirtualSensor =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        SensorProvider_UpdateVirtualSensor_ParamsSpec.$,
        SensorProvider_UpdateVirtualSensor_ResponseParamsSpec.$,
        this.updateVirtualSensor.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.removeVirtualSensor =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        SensorProvider_RemoveVirtualSensor_ParamsSpec.$,
        SensorProvider_RemoveVirtualSensor_ResponseParamsSpec.$,
        this.removeVirtualSensor.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getVirtualSensorInformation =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        SensorProvider_GetVirtualSensorInformation_ParamsSpec.$,
        SensorProvider_GetVirtualSensorInformation_ResponseParamsSpec.$,
        this.getVirtualSensorInformation.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SensorInitParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VirtualSensorMetadataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VirtualSensorInformationSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SensorProvider_GetSensor_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SensorProvider_GetSensor_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SensorProvider_CreateVirtualSensor_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SensorProvider_CreateVirtualSensor_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SensorProvider_UpdateVirtualSensor_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SensorProvider_UpdateVirtualSensor_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SensorProvider_RemoveVirtualSensor_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SensorProvider_RemoveVirtualSensor_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SensorProvider_GetVirtualSensorInformation_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SensorProvider_GetVirtualSensorInformation_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const GetVirtualSensorInformationResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { !bigint }
 */
export const SensorInitParams_READ_BUFFER_SIZE_FOR_TESTS =
    BigInt('48');



mojo.internal.Struct(
    SensorInitParamsSpec.$,
    'SensorInitParams',
    [
      mojo.internal.StructField(
        'sensor', 0,
        0,
        mojo.internal.InterfaceProxy(device_mojom_SensorRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'clientReceiver', 8,
        0,
        mojo.internal.InterfaceRequest(device_mojom_SensorClientPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'memory', 16,
        0,
        mojoBase_mojom_ReadOnlySharedMemoryRegionSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'bufferOffset', 24,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'mode', 12,
        0,
        device_mojom_ReportingModeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'defaultConfiguration', 32,
        0,
        device_mojom_SensorConfigurationSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maximumFrequency', 40,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'minimumFrequency', 48,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 64],]);



/**
 * @record
 */
export class SensorInitParams {
  constructor() {
    /** @type { !device_mojom_SensorRemote } */
    this.sensor;
    /** @type { !device_mojom_SensorClientPendingReceiver } */
    this.clientReceiver;
    /** @type { !mojoBase_mojom_ReadOnlySharedMemoryRegion } */
    this.memory;
    /** @type { !bigint } */
    this.bufferOffset;
    /** @type { !device_mojom_ReportingMode } */
    this.mode;
    /** @type { !device_mojom_SensorConfiguration } */
    this.defaultConfiguration;
    /** @type { !number } */
    this.maximumFrequency;
    /** @type { !number } */
    this.minimumFrequency;
  }
}



mojo.internal.Struct(
    VirtualSensorMetadataSpec.$,
    'VirtualSensorMetadata',
    [
      mojo.internal.StructField(
        'available', 0,
        0,
        mojo.internal.Bool,
        true,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maximum_frequency_$flag', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "maximum_frequency_$value",
          originalFieldName: "maximumFrequency",
        }
      ),
      mojo.internal.StructField(
        'maximum_frequency_$value', 8,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "maximumFrequency",
        }
      ),
      mojo.internal.StructField(
        'minimum_frequency_$flag', 0,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "minimum_frequency_$value",
          originalFieldName: "minimumFrequency",
        }
      ),
      mojo.internal.StructField(
        'minimum_frequency_$value', 16,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "minimumFrequency",
        }
      ),
      mojo.internal.StructField(
        'reporting_mode_$flag', 0,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "reporting_mode_$value",
          originalFieldName: "reportingMode",
        }
      ),
      mojo.internal.StructField(
        'reporting_mode_$value', 4,
        0,
        device_mojom_ReportingModeSpec.$,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "reportingMode",
        }
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class VirtualSensorMetadata {
  constructor() {
    /** @type { !boolean } */
    this.available;
    /** @type { (number|undefined) } */
    this.maximumFrequency;
    /** @type { (number|undefined) } */
    this.minimumFrequency;
    /** @type { (device_mojom_ReportingMode|undefined) } */
    this.reportingMode;
  }
}



mojo.internal.Struct(
    VirtualSensorInformationSpec.$,
    'VirtualSensorInformation',
    [
      mojo.internal.StructField(
        'samplingFrequency', 0,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class VirtualSensorInformation {
  constructor() {
    /** @type { !number } */
    this.samplingFrequency;
  }
}



mojo.internal.Struct(
    SensorProvider_GetSensor_ParamsSpec.$,
    'SensorProvider_GetSensor_Params',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        device_mojom_SensorTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SensorProvider_GetSensor_Params {
  constructor() {
    /** @type { !device_mojom_SensorType } */
    this.type;
  }
}



mojo.internal.Struct(
    SensorProvider_GetSensor_ResponseParamsSpec.$,
    'SensorProvider_GetSensor_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        SensorCreationResultSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'initParams', 8,
        0,
        SensorInitParamsSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class SensorProvider_GetSensor_ResponseParams {
  constructor() {
    /** @type { !SensorCreationResult } */
    this.result;
    /** @type { (SensorInitParams|undefined) } */
    this.initParams;
  }
}



mojo.internal.Struct(
    SensorProvider_CreateVirtualSensor_ParamsSpec.$,
    'SensorProvider_CreateVirtualSensor_Params',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        device_mojom_SensorTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'metadata', 8,
        0,
        VirtualSensorMetadataSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class SensorProvider_CreateVirtualSensor_Params {
  constructor() {
    /** @type { !device_mojom_SensorType } */
    this.type;
    /** @type { !VirtualSensorMetadata } */
    this.metadata;
  }
}



mojo.internal.Struct(
    SensorProvider_CreateVirtualSensor_ResponseParamsSpec.$,
    'SensorProvider_CreateVirtualSensor_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        CreateVirtualSensorResultSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SensorProvider_CreateVirtualSensor_ResponseParams {
  constructor() {
    /** @type { !CreateVirtualSensorResult } */
    this.result;
  }
}



mojo.internal.Struct(
    SensorProvider_UpdateVirtualSensor_ParamsSpec.$,
    'SensorProvider_UpdateVirtualSensor_Params',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        device_mojom_SensorTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'reading', 8,
        0,
        device_mojom_SensorReadingRawSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class SensorProvider_UpdateVirtualSensor_Params {
  constructor() {
    /** @type { !device_mojom_SensorType } */
    this.type;
    /** @type { !device_mojom_SensorReadingRaw } */
    this.reading;
  }
}



mojo.internal.Struct(
    SensorProvider_UpdateVirtualSensor_ResponseParamsSpec.$,
    'SensorProvider_UpdateVirtualSensor_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        UpdateVirtualSensorResultSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SensorProvider_UpdateVirtualSensor_ResponseParams {
  constructor() {
    /** @type { !UpdateVirtualSensorResult } */
    this.result;
  }
}



mojo.internal.Struct(
    SensorProvider_RemoveVirtualSensor_ParamsSpec.$,
    'SensorProvider_RemoveVirtualSensor_Params',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        device_mojom_SensorTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SensorProvider_RemoveVirtualSensor_Params {
  constructor() {
    /** @type { !device_mojom_SensorType } */
    this.type;
  }
}



mojo.internal.Struct(
    SensorProvider_RemoveVirtualSensor_ResponseParamsSpec.$,
    'SensorProvider_RemoveVirtualSensor_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class SensorProvider_RemoveVirtualSensor_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    SensorProvider_GetVirtualSensorInformation_ParamsSpec.$,
    'SensorProvider_GetVirtualSensorInformation_Params',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        device_mojom_SensorTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SensorProvider_GetVirtualSensorInformation_Params {
  constructor() {
    /** @type { !device_mojom_SensorType } */
    this.type;
  }
}



mojo.internal.Struct(
    SensorProvider_GetVirtualSensorInformation_ResponseParamsSpec.$,
    'SensorProvider_GetVirtualSensorInformation_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        GetVirtualSensorInformationResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class SensorProvider_GetVirtualSensorInformation_ResponseParams {
  constructor() {
    /** @type { !GetVirtualSensorInformationResult } */
    this.result;
  }
}

mojo.internal.Union(
    GetVirtualSensorInformationResultSpec.$, 'GetVirtualSensorInformationResult',
    {
      'info': {
        'ordinal': 0,
        'type': VirtualSensorInformationSpec.$,
      },
      'error': {
        'ordinal': 1,
        'type': GetVirtualSensorInformationErrorSpec.$,
      },
    });

/**
 * @typedef { {
 *   info: (!VirtualSensorInformation|undefined),
 *   error: (!GetVirtualSensorInformationError|undefined),
 * } }
 */
export const GetVirtualSensorInformationResult = {};
