// services/device/public/mojom/serial.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('device.mojom');





/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
device.mojom.SerialSendErrorSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
device.mojom.SerialSendError = {
  
  NONE: 0,
  DISCONNECTED: 1,
  SYSTEM_ERROR: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
device.mojom.SerialReceiveErrorSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
device.mojom.SerialReceiveError = {
  
  NONE: 0,
  DISCONNECTED: 1,
  DEVICE_LOST: 2,
  BREAK: 3,
  FRAME_ERROR: 4,
  OVERRUN: 5,
  BUFFER_OVERFLOW: 6,
  PARITY_ERROR: 7,
  SYSTEM_ERROR: 8,
  MIN_VALUE: 0,
  MAX_VALUE: 8,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
device.mojom.SerialDataBitsSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
device.mojom.SerialDataBits = {
  
  NONE: 0,
  SEVEN: 1,
  EIGHT: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
device.mojom.SerialParityBitSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
device.mojom.SerialParityBit = {
  
  NONE: 0,
  NO_PARITY: 1,
  ODD: 2,
  EVEN: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
device.mojom.SerialStopBitsSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
device.mojom.SerialStopBits = {
  
  NONE: 0,
  ONE: 1,
  TWO: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
device.mojom.SerialPortFlushModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
device.mojom.SerialPortFlushMode = {
  
  kReceiveAndTransmit: 0,
  kReceive: 1,
  kTransmit: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
device.mojom.SerialPortTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
device.mojom.SerialPortType = {
  
  PLATFORM_SERIAL: 0,
  BLUETOOTH_CLASSIC_RFCOMM: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};





/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
device.mojom.SerialPortManagerPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        device.mojom.SerialPortManager.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { device.mojom.SerialPortManagerInterface }
 */
device.mojom.SerialPortManagerRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!device.mojom.SerialPortManagerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          device.mojom.SerialPortManagerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!device.mojom.SerialPortManagerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !device.mojom.SerialPortManagerClientRemote } client
   */

  setClient(
      client) {
    this.proxy.sendMessage(
        0,
        device.mojom.SerialPortManager_SetClient_ParamsSpec.$,
        null,
        [
          client
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        devices: !Array<!device.mojom.SerialPortInfo>,
   *  }>}
   */

  getDevices() {
    return this.proxy.sendMessage(
        1,
        device.mojom.SerialPortManager_GetDevices_ParamsSpec.$,
        device.mojom.SerialPortManager_GetDevices_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.UnguessableToken } token
   * @param { !boolean } useAlternatePath
   * @param { !device.mojom.SerialConnectionOptions } options
   * @param { !device.mojom.SerialPortClientRemote } client
   * @param { ?device.mojom.SerialPortConnectionWatcherRemote } watcher
   * @return {!Promise<{
        port: ?device.mojom.SerialPortRemote,
   *  }>}
   */

  openPort(
      token,
      useAlternatePath,
      options,
      client,
      watcher) {
    return this.proxy.sendMessage(
        2,
        device.mojom.SerialPortManager_OpenPort_ParamsSpec.$,
        device.mojom.SerialPortManager_OpenPort_ResponseParamsSpec.$,
        [
          token,
          useAlternatePath,
          options,
          client,
          watcher
        ],
        false);
  }
};

/**
 * An object which receives request messages for the SerialPortManager
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
device.mojom.SerialPortManagerReceiver = class {
  /**
   * @param {!device.mojom.SerialPortManagerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!device.mojom.SerialPortManagerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        device.mojom.SerialPortManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.SerialPortManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        device.mojom.SerialPortManager_SetClient_ParamsSpec.$,
        null,
        impl.setClient.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        device.mojom.SerialPortManager_GetDevices_ParamsSpec.$,
        device.mojom.SerialPortManager_GetDevices_ResponseParamsSpec.$,
        impl.getDevices.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        device.mojom.SerialPortManager_OpenPort_ParamsSpec.$,
        device.mojom.SerialPortManager_OpenPort_ResponseParamsSpec.$,
        impl.openPort.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
device.mojom.SerialPortManager = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.SerialPortManager";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!device.mojom.SerialPortManagerRemote}
   * @export
   */
  static getRemote() {
    let remote = new device.mojom.SerialPortManagerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the SerialPortManager
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
device.mojom.SerialPortManagerCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      device.mojom.SerialPortManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.SerialPortManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setClient =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        device.mojom.SerialPortManager_SetClient_ParamsSpec.$,
        null,
        this.setClient.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getDevices =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        device.mojom.SerialPortManager_GetDevices_ParamsSpec.$,
        device.mojom.SerialPortManager_GetDevices_ResponseParamsSpec.$,
        this.getDevices.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.openPort =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        device.mojom.SerialPortManager_OpenPort_ParamsSpec.$,
        device.mojom.SerialPortManager_OpenPort_ResponseParamsSpec.$,
        this.openPort.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
device.mojom.SerialPortManagerClientPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        device.mojom.SerialPortManagerClient.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { device.mojom.SerialPortManagerClientInterface }
 */
device.mojom.SerialPortManagerClientRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!device.mojom.SerialPortManagerClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          device.mojom.SerialPortManagerClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!device.mojom.SerialPortManagerClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !device.mojom.SerialPortInfo } portInfo
   */

  onPortAdded(
      portInfo) {
    this.proxy.sendMessage(
        0,
        device.mojom.SerialPortManagerClient_OnPortAdded_ParamsSpec.$,
        null,
        [
          portInfo
        ],
        false);
  }

  
  /**
   * @param { !device.mojom.SerialPortInfo } portInfo
   */

  onPortRemoved(
      portInfo) {
    this.proxy.sendMessage(
        1,
        device.mojom.SerialPortManagerClient_OnPortRemoved_ParamsSpec.$,
        null,
        [
          portInfo
        ],
        false);
  }

  
  /**
   * @param { !device.mojom.SerialPortInfo } portInfo
   */

  onPortConnectedStateChanged(
      portInfo) {
    this.proxy.sendMessage(
        2,
        device.mojom.SerialPortManagerClient_OnPortConnectedStateChanged_ParamsSpec.$,
        null,
        [
          portInfo
        ],
        false);
  }
};

/**
 * An object which receives request messages for the SerialPortManagerClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
device.mojom.SerialPortManagerClientReceiver = class {
  /**
   * @param {!device.mojom.SerialPortManagerClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!device.mojom.SerialPortManagerClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        device.mojom.SerialPortManagerClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.SerialPortManagerClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        device.mojom.SerialPortManagerClient_OnPortAdded_ParamsSpec.$,
        null,
        impl.onPortAdded.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        device.mojom.SerialPortManagerClient_OnPortRemoved_ParamsSpec.$,
        null,
        impl.onPortRemoved.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        device.mojom.SerialPortManagerClient_OnPortConnectedStateChanged_ParamsSpec.$,
        null,
        impl.onPortConnectedStateChanged.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
device.mojom.SerialPortManagerClient = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.SerialPortManagerClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!device.mojom.SerialPortManagerClientRemote}
   * @export
   */
  static getRemote() {
    let remote = new device.mojom.SerialPortManagerClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the SerialPortManagerClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
device.mojom.SerialPortManagerClientCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      device.mojom.SerialPortManagerClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.SerialPortManagerClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onPortAdded =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        device.mojom.SerialPortManagerClient_OnPortAdded_ParamsSpec.$,
        null,
        this.onPortAdded.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onPortRemoved =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        device.mojom.SerialPortManagerClient_OnPortRemoved_ParamsSpec.$,
        null,
        this.onPortRemoved.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onPortConnectedStateChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        device.mojom.SerialPortManagerClient_OnPortConnectedStateChanged_ParamsSpec.$,
        null,
        this.onPortConnectedStateChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
device.mojom.SerialPortPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        device.mojom.SerialPort.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { device.mojom.SerialPortInterface }
 */
device.mojom.SerialPortRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!device.mojom.SerialPortPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          device.mojom.SerialPortPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!device.mojom.SerialPortPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !MojoHandle } consumer
   */

  startWriting(
      consumer) {
    this.proxy.sendMessage(
        0,
        device.mojom.SerialPort_StartWriting_ParamsSpec.$,
        null,
        [
          consumer
        ],
        false);
  }

  
  /**
   * @param { !MojoHandle } producer
   */

  startReading(
      producer) {
    this.proxy.sendMessage(
        1,
        device.mojom.SerialPort_StartReading_ParamsSpec.$,
        null,
        [
          producer
        ],
        false);
  }

  
  /**
   * @param { !device.mojom.SerialPortFlushMode } mode
   * @return {!Promise}
   */

  flush(
      mode) {
    return this.proxy.sendMessage(
        2,
        device.mojom.SerialPort_Flush_ParamsSpec.$,
        device.mojom.SerialPort_Flush_ResponseParamsSpec.$,
        [
          mode
        ],
        false);
  }

  
  /**
   * @return {!Promise}
   */

  drain() {
    return this.proxy.sendMessage(
        3,
        device.mojom.SerialPort_Drain_ParamsSpec.$,
        device.mojom.SerialPort_Drain_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        signals: ?device.mojom.SerialPortControlSignals,
   *  }>}
   */

  getControlSignals() {
    return this.proxy.sendMessage(
        4,
        device.mojom.SerialPort_GetControlSignals_ParamsSpec.$,
        device.mojom.SerialPort_GetControlSignals_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !device.mojom.SerialHostControlSignals } signals
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  setControlSignals(
      signals) {
    return this.proxy.sendMessage(
        5,
        device.mojom.SerialPort_SetControlSignals_ParamsSpec.$,
        device.mojom.SerialPort_SetControlSignals_ResponseParamsSpec.$,
        [
          signals
        ],
        false);
  }

  
  /**
   * @param { !device.mojom.SerialConnectionOptions } options
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  configurePort(
      options) {
    return this.proxy.sendMessage(
        6,
        device.mojom.SerialPort_ConfigurePort_ParamsSpec.$,
        device.mojom.SerialPort_ConfigurePort_ResponseParamsSpec.$,
        [
          options
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        info: !device.mojom.SerialConnectionInfo,
   *  }>}
   */

  getPortInfo() {
    return this.proxy.sendMessage(
        7,
        device.mojom.SerialPort_GetPortInfo_ParamsSpec.$,
        device.mojom.SerialPort_GetPortInfo_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !boolean } flush
   * @return {!Promise}
   */

  close(
      flush) {
    return this.proxy.sendMessage(
        8,
        device.mojom.SerialPort_Close_ParamsSpec.$,
        device.mojom.SerialPort_Close_ResponseParamsSpec.$,
        [
          flush
        ],
        false);
  }
};

/**
 * An object which receives request messages for the SerialPort
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
device.mojom.SerialPortReceiver = class {
  /**
   * @param {!device.mojom.SerialPortInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!device.mojom.SerialPortRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        device.mojom.SerialPortRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.SerialPortRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        device.mojom.SerialPort_StartWriting_ParamsSpec.$,
        null,
        impl.startWriting.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        device.mojom.SerialPort_StartReading_ParamsSpec.$,
        null,
        impl.startReading.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        device.mojom.SerialPort_Flush_ParamsSpec.$,
        device.mojom.SerialPort_Flush_ResponseParamsSpec.$,
        impl.flush.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        device.mojom.SerialPort_Drain_ParamsSpec.$,
        device.mojom.SerialPort_Drain_ResponseParamsSpec.$,
        impl.drain.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        device.mojom.SerialPort_GetControlSignals_ParamsSpec.$,
        device.mojom.SerialPort_GetControlSignals_ResponseParamsSpec.$,
        impl.getControlSignals.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        device.mojom.SerialPort_SetControlSignals_ParamsSpec.$,
        device.mojom.SerialPort_SetControlSignals_ResponseParamsSpec.$,
        impl.setControlSignals.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        device.mojom.SerialPort_ConfigurePort_ParamsSpec.$,
        device.mojom.SerialPort_ConfigurePort_ResponseParamsSpec.$,
        impl.configurePort.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        device.mojom.SerialPort_GetPortInfo_ParamsSpec.$,
        device.mojom.SerialPort_GetPortInfo_ResponseParamsSpec.$,
        impl.getPortInfo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        device.mojom.SerialPort_Close_ParamsSpec.$,
        device.mojom.SerialPort_Close_ResponseParamsSpec.$,
        impl.close.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
device.mojom.SerialPort = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.SerialPort";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!device.mojom.SerialPortRemote}
   * @export
   */
  static getRemote() {
    let remote = new device.mojom.SerialPortRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the SerialPort
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
device.mojom.SerialPortCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      device.mojom.SerialPortRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.SerialPortRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.startWriting =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        device.mojom.SerialPort_StartWriting_ParamsSpec.$,
        null,
        this.startWriting.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.startReading =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        device.mojom.SerialPort_StartReading_ParamsSpec.$,
        null,
        this.startReading.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.flush =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        device.mojom.SerialPort_Flush_ParamsSpec.$,
        device.mojom.SerialPort_Flush_ResponseParamsSpec.$,
        this.flush.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.drain =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        device.mojom.SerialPort_Drain_ParamsSpec.$,
        device.mojom.SerialPort_Drain_ResponseParamsSpec.$,
        this.drain.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getControlSignals =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        device.mojom.SerialPort_GetControlSignals_ParamsSpec.$,
        device.mojom.SerialPort_GetControlSignals_ResponseParamsSpec.$,
        this.getControlSignals.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setControlSignals =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        device.mojom.SerialPort_SetControlSignals_ParamsSpec.$,
        device.mojom.SerialPort_SetControlSignals_ResponseParamsSpec.$,
        this.setControlSignals.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.configurePort =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        device.mojom.SerialPort_ConfigurePort_ParamsSpec.$,
        device.mojom.SerialPort_ConfigurePort_ResponseParamsSpec.$,
        this.configurePort.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getPortInfo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        device.mojom.SerialPort_GetPortInfo_ParamsSpec.$,
        device.mojom.SerialPort_GetPortInfo_ResponseParamsSpec.$,
        this.getPortInfo.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.close =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        device.mojom.SerialPort_Close_ParamsSpec.$,
        device.mojom.SerialPort_Close_ResponseParamsSpec.$,
        this.close.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
device.mojom.SerialPortClientPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        device.mojom.SerialPortClient.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { device.mojom.SerialPortClientInterface }
 */
device.mojom.SerialPortClientRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!device.mojom.SerialPortClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          device.mojom.SerialPortClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!device.mojom.SerialPortClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !device.mojom.SerialReceiveError } error
   */

  onReadError(
      error) {
    this.proxy.sendMessage(
        0,
        device.mojom.SerialPortClient_OnReadError_ParamsSpec.$,
        null,
        [
          error
        ],
        false);
  }

  
  /**
   * @param { !device.mojom.SerialSendError } error
   */

  onSendError(
      error) {
    this.proxy.sendMessage(
        1,
        device.mojom.SerialPortClient_OnSendError_ParamsSpec.$,
        null,
        [
          error
        ],
        false);
  }
};

/**
 * An object which receives request messages for the SerialPortClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
device.mojom.SerialPortClientReceiver = class {
  /**
   * @param {!device.mojom.SerialPortClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!device.mojom.SerialPortClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        device.mojom.SerialPortClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.SerialPortClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        device.mojom.SerialPortClient_OnReadError_ParamsSpec.$,
        null,
        impl.onReadError.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        device.mojom.SerialPortClient_OnSendError_ParamsSpec.$,
        null,
        impl.onSendError.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
device.mojom.SerialPortClient = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.SerialPortClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!device.mojom.SerialPortClientRemote}
   * @export
   */
  static getRemote() {
    let remote = new device.mojom.SerialPortClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the SerialPortClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
device.mojom.SerialPortClientCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      device.mojom.SerialPortClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.SerialPortClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onReadError =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        device.mojom.SerialPortClient_OnReadError_ParamsSpec.$,
        null,
        this.onReadError.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onSendError =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        device.mojom.SerialPortClient_OnSendError_ParamsSpec.$,
        null,
        this.onSendError.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
device.mojom.SerialPortConnectionWatcherPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        device.mojom.SerialPortConnectionWatcher.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { device.mojom.SerialPortConnectionWatcherInterface }
 */
device.mojom.SerialPortConnectionWatcherRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!device.mojom.SerialPortConnectionWatcherPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          device.mojom.SerialPortConnectionWatcherPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!device.mojom.SerialPortConnectionWatcherPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }
};

/**
 * An object which receives request messages for the SerialPortConnectionWatcher
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
device.mojom.SerialPortConnectionWatcherReceiver = class {
  /**
   * @param {!device.mojom.SerialPortConnectionWatcherInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!device.mojom.SerialPortConnectionWatcherRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        device.mojom.SerialPortConnectionWatcherRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.SerialPortConnectionWatcherRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
device.mojom.SerialPortConnectionWatcher = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.SerialPortConnectionWatcher";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!device.mojom.SerialPortConnectionWatcherRemote}
   * @export
   */
  static getRemote() {
    let remote = new device.mojom.SerialPortConnectionWatcherRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the SerialPortConnectionWatcher
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
device.mojom.SerialPortConnectionWatcherCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      device.mojom.SerialPortConnectionWatcherRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.SerialPortConnectionWatcherRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.SerialPortInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.SerialConnectionOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.SerialConnectionInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.SerialHostControlSignalsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.SerialPortControlSignalsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.SerialPortManager_SetClient_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.SerialPortManager_GetDevices_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.SerialPortManager_GetDevices_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.SerialPortManager_OpenPort_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.SerialPortManager_OpenPort_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.SerialPortManagerClient_OnPortAdded_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.SerialPortManagerClient_OnPortRemoved_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.SerialPortManagerClient_OnPortConnectedStateChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.SerialPort_StartWriting_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.SerialPort_StartReading_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.SerialPort_Flush_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.SerialPort_Flush_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.SerialPort_Drain_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.SerialPort_Drain_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.SerialPort_GetControlSignals_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.SerialPort_GetControlSignals_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.SerialPort_SetControlSignals_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.SerialPort_SetControlSignals_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.SerialPort_ConfigurePort_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.SerialPort_ConfigurePort_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.SerialPort_GetPortInfo_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.SerialPort_GetPortInfo_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.SerialPort_Close_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.SerialPort_Close_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.SerialPortClient_OnReadError_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.SerialPortClient_OnSendError_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    device.mojom.SerialPortInfoSpec.$,
    'SerialPortInfo',
    [
      mojo.internal.StructField(
        'token', 0,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'path', 8,
        0,
        mojoBase.mojom.FilePathSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'type', 16,
        0,
        device.mojom.SerialPortTypeSpec.$,
        device.mojom.SerialPortType.PLATFORM_SERIAL,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'vendorId', 20,
        0,
        mojo.internal.Uint16,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hasVendorId', 22,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'productId', 24,
        0,
        mojo.internal.Uint16,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hasProductId', 22,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'bluetoothServiceClassId', 32,
        0,
        bluetooth.mojom.UUIDSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'displayName', 40,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'serialNumber', 48,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'connected', 22,
        2,
        mojo.internal.Bool,
        true,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 64],]);





/** @record */
device.mojom.SerialPortInfo = class {
  constructor() {
    /** @export { !mojoBase.mojom.UnguessableToken } */
    this.token;
    /** @export { !mojoBase.mojom.FilePath } */
    this.path;
    /** @export { !device.mojom.SerialPortType } */
    this.type;
    /** @export { !number } */
    this.vendorId;
    /** @export { !boolean } */
    this.hasVendorId;
    /** @export { !number } */
    this.productId;
    /** @export { !boolean } */
    this.hasProductId;
    /** @export { (bluetooth.mojom.UUID|undefined) } */
    this.bluetoothServiceClassId;
    /** @export { (string|undefined) } */
    this.displayName;
    /** @export { (string|undefined) } */
    this.serialNumber;
    /** @export { !boolean } */
    this.connected;
  }
};



mojo.internal.Struct(
    device.mojom.SerialConnectionOptionsSpec.$,
    'SerialConnectionOptions',
    [
      mojo.internal.StructField(
        'bitrate', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'dataBits', 4,
        0,
        device.mojom.SerialDataBitsSpec.$,
        device.mojom.SerialDataBits.NONE,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'parityBit', 8,
        0,
        device.mojom.SerialParityBitSpec.$,
        device.mojom.SerialParityBit.NONE,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'stopBits', 12,
        0,
        device.mojom.SerialStopBitsSpec.$,
        device.mojom.SerialStopBits.NONE,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'ctsFlowControl', 16,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hasCtsFlowControl', 16,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
device.mojom.SerialConnectionOptions = class {
  constructor() {
    /** @export { !number } */
    this.bitrate;
    /** @export { !device.mojom.SerialDataBits } */
    this.dataBits;
    /** @export { !device.mojom.SerialParityBit } */
    this.parityBit;
    /** @export { !device.mojom.SerialStopBits } */
    this.stopBits;
    /** @export { !boolean } */
    this.ctsFlowControl;
    /** @export { !boolean } */
    this.hasCtsFlowControl;
  }
};



mojo.internal.Struct(
    device.mojom.SerialConnectionInfoSpec.$,
    'SerialConnectionInfo',
    [
      mojo.internal.StructField(
        'bitrate', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'dataBits', 4,
        0,
        device.mojom.SerialDataBitsSpec.$,
        device.mojom.SerialDataBits.NONE,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'parityBit', 8,
        0,
        device.mojom.SerialParityBitSpec.$,
        device.mojom.SerialParityBit.NONE,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'stopBits', 12,
        0,
        device.mojom.SerialStopBitsSpec.$,
        device.mojom.SerialStopBits.NONE,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'ctsFlowControl', 16,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
device.mojom.SerialConnectionInfo = class {
  constructor() {
    /** @export { !number } */
    this.bitrate;
    /** @export { !device.mojom.SerialDataBits } */
    this.dataBits;
    /** @export { !device.mojom.SerialParityBit } */
    this.parityBit;
    /** @export { !device.mojom.SerialStopBits } */
    this.stopBits;
    /** @export { !boolean } */
    this.ctsFlowControl;
  }
};



mojo.internal.Struct(
    device.mojom.SerialHostControlSignalsSpec.$,
    'SerialHostControlSignals',
    [
      mojo.internal.StructField(
        'dtr', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hasDtr', 0,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'rts', 0,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hasRts', 0,
        3,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'brk', 0,
        4,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hasBrk', 0,
        5,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
device.mojom.SerialHostControlSignals = class {
  constructor() {
    /** @export { !boolean } */
    this.dtr;
    /** @export { !boolean } */
    this.hasDtr;
    /** @export { !boolean } */
    this.rts;
    /** @export { !boolean } */
    this.hasRts;
    /** @export { !boolean } */
    this.brk;
    /** @export { !boolean } */
    this.hasBrk;
  }
};



mojo.internal.Struct(
    device.mojom.SerialPortControlSignalsSpec.$,
    'SerialPortControlSignals',
    [
      mojo.internal.StructField(
        'dcd', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'cts', 0,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'ri', 0,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'dsr', 0,
        3,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
device.mojom.SerialPortControlSignals = class {
  constructor() {
    /** @export { !boolean } */
    this.dcd;
    /** @export { !boolean } */
    this.cts;
    /** @export { !boolean } */
    this.ri;
    /** @export { !boolean } */
    this.dsr;
  }
};



mojo.internal.Struct(
    device.mojom.SerialPortManager_SetClient_ParamsSpec.$,
    'SerialPortManager_SetClient_Params',
    [
      mojo.internal.StructField(
        'client', 0,
        0,
        mojo.internal.InterfaceProxy(device.mojom.SerialPortManagerClientRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
device.mojom.SerialPortManager_SetClient_Params = class {
  constructor() {
    /** @export { !device.mojom.SerialPortManagerClientRemote } */
    this.client;
  }
};



mojo.internal.Struct(
    device.mojom.SerialPortManager_GetDevices_ParamsSpec.$,
    'SerialPortManager_GetDevices_Params',
    [
    ],
    [[0, 8],]);





/** @record */
device.mojom.SerialPortManager_GetDevices_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    device.mojom.SerialPortManager_GetDevices_ResponseParamsSpec.$,
    'SerialPortManager_GetDevices_ResponseParams',
    [
      mojo.internal.StructField(
        'devices', 0,
        0,
        mojo.internal.Array(device.mojom.SerialPortInfoSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
device.mojom.SerialPortManager_GetDevices_ResponseParams = class {
  constructor() {
    /** @export { !Array<!device.mojom.SerialPortInfo> } */
    this.devices;
  }
};



mojo.internal.Struct(
    device.mojom.SerialPortManager_OpenPort_ParamsSpec.$,
    'SerialPortManager_OpenPort_Params',
    [
      mojo.internal.StructField(
        'token', 0,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'useAlternatePath', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'options', 16,
        0,
        device.mojom.SerialConnectionOptionsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'client', 24,
        0,
        mojo.internal.InterfaceProxy(device.mojom.SerialPortClientRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'watcher', 32,
        0,
        mojo.internal.InterfaceProxy(device.mojom.SerialPortConnectionWatcherRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 48],]);





/** @record */
device.mojom.SerialPortManager_OpenPort_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.UnguessableToken } */
    this.token;
    /** @export { !boolean } */
    this.useAlternatePath;
    /** @export { !device.mojom.SerialConnectionOptions } */
    this.options;
    /** @export { !device.mojom.SerialPortClientRemote } */
    this.client;
    /** @export { (device.mojom.SerialPortConnectionWatcherRemote|undefined) } */
    this.watcher;
  }
};



mojo.internal.Struct(
    device.mojom.SerialPortManager_OpenPort_ResponseParamsSpec.$,
    'SerialPortManager_OpenPort_ResponseParams',
    [
      mojo.internal.StructField(
        'port', 0,
        0,
        mojo.internal.InterfaceProxy(device.mojom.SerialPortRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
device.mojom.SerialPortManager_OpenPort_ResponseParams = class {
  constructor() {
    /** @export { (device.mojom.SerialPortRemote|undefined) } */
    this.port;
  }
};



mojo.internal.Struct(
    device.mojom.SerialPortManagerClient_OnPortAdded_ParamsSpec.$,
    'SerialPortManagerClient_OnPortAdded_Params',
    [
      mojo.internal.StructField(
        'portInfo', 0,
        0,
        device.mojom.SerialPortInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
device.mojom.SerialPortManagerClient_OnPortAdded_Params = class {
  constructor() {
    /** @export { !device.mojom.SerialPortInfo } */
    this.portInfo;
  }
};



mojo.internal.Struct(
    device.mojom.SerialPortManagerClient_OnPortRemoved_ParamsSpec.$,
    'SerialPortManagerClient_OnPortRemoved_Params',
    [
      mojo.internal.StructField(
        'portInfo', 0,
        0,
        device.mojom.SerialPortInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
device.mojom.SerialPortManagerClient_OnPortRemoved_Params = class {
  constructor() {
    /** @export { !device.mojom.SerialPortInfo } */
    this.portInfo;
  }
};



mojo.internal.Struct(
    device.mojom.SerialPortManagerClient_OnPortConnectedStateChanged_ParamsSpec.$,
    'SerialPortManagerClient_OnPortConnectedStateChanged_Params',
    [
      mojo.internal.StructField(
        'portInfo', 0,
        0,
        device.mojom.SerialPortInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
device.mojom.SerialPortManagerClient_OnPortConnectedStateChanged_Params = class {
  constructor() {
    /** @export { !device.mojom.SerialPortInfo } */
    this.portInfo;
  }
};



mojo.internal.Struct(
    device.mojom.SerialPort_StartWriting_ParamsSpec.$,
    'SerialPort_StartWriting_Params',
    [
      mojo.internal.StructField(
        'consumer', 0,
        0,
        mojo.internal.Handle,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
device.mojom.SerialPort_StartWriting_Params = class {
  constructor() {
    /** @export { !MojoHandle } */
    this.consumer;
  }
};



mojo.internal.Struct(
    device.mojom.SerialPort_StartReading_ParamsSpec.$,
    'SerialPort_StartReading_Params',
    [
      mojo.internal.StructField(
        'producer', 0,
        0,
        mojo.internal.Handle,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
device.mojom.SerialPort_StartReading_Params = class {
  constructor() {
    /** @export { !MojoHandle } */
    this.producer;
  }
};



mojo.internal.Struct(
    device.mojom.SerialPort_Flush_ParamsSpec.$,
    'SerialPort_Flush_Params',
    [
      mojo.internal.StructField(
        'mode', 0,
        0,
        device.mojom.SerialPortFlushModeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
device.mojom.SerialPort_Flush_Params = class {
  constructor() {
    /** @export { !device.mojom.SerialPortFlushMode } */
    this.mode;
  }
};



mojo.internal.Struct(
    device.mojom.SerialPort_Flush_ResponseParamsSpec.$,
    'SerialPort_Flush_ResponseParams',
    [
    ],
    [[0, 8],]);





/** @record */
device.mojom.SerialPort_Flush_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    device.mojom.SerialPort_Drain_ParamsSpec.$,
    'SerialPort_Drain_Params',
    [
    ],
    [[0, 8],]);





/** @record */
device.mojom.SerialPort_Drain_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    device.mojom.SerialPort_Drain_ResponseParamsSpec.$,
    'SerialPort_Drain_ResponseParams',
    [
    ],
    [[0, 8],]);





/** @record */
device.mojom.SerialPort_Drain_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    device.mojom.SerialPort_GetControlSignals_ParamsSpec.$,
    'SerialPort_GetControlSignals_Params',
    [
    ],
    [[0, 8],]);





/** @record */
device.mojom.SerialPort_GetControlSignals_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    device.mojom.SerialPort_GetControlSignals_ResponseParamsSpec.$,
    'SerialPort_GetControlSignals_ResponseParams',
    [
      mojo.internal.StructField(
        'signals', 0,
        0,
        device.mojom.SerialPortControlSignalsSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
device.mojom.SerialPort_GetControlSignals_ResponseParams = class {
  constructor() {
    /** @export { (device.mojom.SerialPortControlSignals|undefined) } */
    this.signals;
  }
};



mojo.internal.Struct(
    device.mojom.SerialPort_SetControlSignals_ParamsSpec.$,
    'SerialPort_SetControlSignals_Params',
    [
      mojo.internal.StructField(
        'signals', 0,
        0,
        device.mojom.SerialHostControlSignalsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
device.mojom.SerialPort_SetControlSignals_Params = class {
  constructor() {
    /** @export { !device.mojom.SerialHostControlSignals } */
    this.signals;
  }
};



mojo.internal.Struct(
    device.mojom.SerialPort_SetControlSignals_ResponseParamsSpec.$,
    'SerialPort_SetControlSignals_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
device.mojom.SerialPort_SetControlSignals_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.success;
  }
};



mojo.internal.Struct(
    device.mojom.SerialPort_ConfigurePort_ParamsSpec.$,
    'SerialPort_ConfigurePort_Params',
    [
      mojo.internal.StructField(
        'options', 0,
        0,
        device.mojom.SerialConnectionOptionsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
device.mojom.SerialPort_ConfigurePort_Params = class {
  constructor() {
    /** @export { !device.mojom.SerialConnectionOptions } */
    this.options;
  }
};



mojo.internal.Struct(
    device.mojom.SerialPort_ConfigurePort_ResponseParamsSpec.$,
    'SerialPort_ConfigurePort_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
device.mojom.SerialPort_ConfigurePort_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.success;
  }
};



mojo.internal.Struct(
    device.mojom.SerialPort_GetPortInfo_ParamsSpec.$,
    'SerialPort_GetPortInfo_Params',
    [
    ],
    [[0, 8],]);





/** @record */
device.mojom.SerialPort_GetPortInfo_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    device.mojom.SerialPort_GetPortInfo_ResponseParamsSpec.$,
    'SerialPort_GetPortInfo_ResponseParams',
    [
      mojo.internal.StructField(
        'info', 0,
        0,
        device.mojom.SerialConnectionInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
device.mojom.SerialPort_GetPortInfo_ResponseParams = class {
  constructor() {
    /** @export { !device.mojom.SerialConnectionInfo } */
    this.info;
  }
};



mojo.internal.Struct(
    device.mojom.SerialPort_Close_ParamsSpec.$,
    'SerialPort_Close_Params',
    [
      mojo.internal.StructField(
        'flush', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
device.mojom.SerialPort_Close_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.flush;
  }
};



mojo.internal.Struct(
    device.mojom.SerialPort_Close_ResponseParamsSpec.$,
    'SerialPort_Close_ResponseParams',
    [
    ],
    [[0, 8],]);





/** @record */
device.mojom.SerialPort_Close_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    device.mojom.SerialPortClient_OnReadError_ParamsSpec.$,
    'SerialPortClient_OnReadError_Params',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        device.mojom.SerialReceiveErrorSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
device.mojom.SerialPortClient_OnReadError_Params = class {
  constructor() {
    /** @export { !device.mojom.SerialReceiveError } */
    this.error;
  }
};



mojo.internal.Struct(
    device.mojom.SerialPortClient_OnSendError_ParamsSpec.$,
    'SerialPortClient_OnSendError_Params',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        device.mojom.SerialSendErrorSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
device.mojom.SerialPortClient_OnSendError_Params = class {
  constructor() {
    /** @export { !device.mojom.SerialSendError } */
    this.error;
  }
};

