// services/network/public/mojom/cert_verifier_service_updater.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('certVerifier.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
certVerifier.mojom.CertVerifierServiceUpdaterPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        certVerifier.mojom.CertVerifierServiceUpdater.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { certVerifier.mojom.CertVerifierServiceUpdaterInterface }
 */
certVerifier.mojom.CertVerifierServiceUpdaterRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!certVerifier.mojom.CertVerifierServiceUpdaterPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          certVerifier.mojom.CertVerifierServiceUpdaterPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!certVerifier.mojom.CertVerifierServiceUpdaterPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !certVerifier.mojom.AdditionalCertificates } certificates
   */

  updateAdditionalCertificates(
      certificates) {
    this.proxy.sendMessage(
        0,
        certVerifier.mojom.CertVerifierServiceUpdater_UpdateAdditionalCertificates_ParamsSpec.$,
        null,
        [
          certificates
        ],
        false);
  }

  
  /**
   * @return {!Promise}
   */

  waitUntilNextUpdateForTesting() {
    return this.proxy.sendMessage(
        1,
        certVerifier.mojom.CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_ParamsSpec.$,
        certVerifier.mojom.CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.CTPolicy } ctPolicy
   */

  setCTPolicy(
      ctPolicy) {
    this.proxy.sendMessage(
        2,
        certVerifier.mojom.CertVerifierServiceUpdater_SetCTPolicy_ParamsSpec.$,
        null,
        [
          ctPolicy
        ],
        false);
  }
};

/**
 * An object which receives request messages for the CertVerifierServiceUpdater
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
certVerifier.mojom.CertVerifierServiceUpdaterReceiver = class {
  /**
   * @param {!certVerifier.mojom.CertVerifierServiceUpdaterInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!certVerifier.mojom.CertVerifierServiceUpdaterRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        certVerifier.mojom.CertVerifierServiceUpdaterRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!certVerifier.mojom.CertVerifierServiceUpdaterRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        certVerifier.mojom.CertVerifierServiceUpdater_UpdateAdditionalCertificates_ParamsSpec.$,
        null,
        impl.updateAdditionalCertificates.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        certVerifier.mojom.CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_ParamsSpec.$,
        certVerifier.mojom.CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_ResponseParamsSpec.$,
        impl.waitUntilNextUpdateForTesting.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        certVerifier.mojom.CertVerifierServiceUpdater_SetCTPolicy_ParamsSpec.$,
        null,
        impl.setCTPolicy.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
certVerifier.mojom.CertVerifierServiceUpdater = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "cert_verifier.mojom.CertVerifierServiceUpdater";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!certVerifier.mojom.CertVerifierServiceUpdaterRemote}
   * @export
   */
  static getRemote() {
    let remote = new certVerifier.mojom.CertVerifierServiceUpdaterRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the CertVerifierServiceUpdater
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
certVerifier.mojom.CertVerifierServiceUpdaterCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      certVerifier.mojom.CertVerifierServiceUpdaterRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!certVerifier.mojom.CertVerifierServiceUpdaterRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateAdditionalCertificates =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        certVerifier.mojom.CertVerifierServiceUpdater_UpdateAdditionalCertificates_ParamsSpec.$,
        null,
        this.updateAdditionalCertificates.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.waitUntilNextUpdateForTesting =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        certVerifier.mojom.CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_ParamsSpec.$,
        certVerifier.mojom.CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_ResponseParamsSpec.$,
        this.waitUntilNextUpdateForTesting.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setCTPolicy =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        certVerifier.mojom.CertVerifierServiceUpdater_SetCTPolicy_ParamsSpec.$,
        null,
        this.setCTPolicy.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
certVerifier.mojom.CIDRSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
certVerifier.mojom.CertWithConstraintsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
certVerifier.mojom.AdditionalCertificatesSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
certVerifier.mojom.CertVerifierServiceUpdater_UpdateAdditionalCertificates_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
certVerifier.mojom.CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
certVerifier.mojom.CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
certVerifier.mojom.CertVerifierServiceUpdater_SetCTPolicy_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    certVerifier.mojom.CIDRSpec.$,
    'CIDR',
    [
      mojo.internal.StructField(
        'ip', 0,
        0,
        network.mojom.IPAddressSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'mask', 8,
        0,
        network.mojom.IPAddressSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
certVerifier.mojom.CIDR = class {
  constructor() {
    /** @export { !network.mojom.IPAddress } */
    this.ip;
    /** @export { !network.mojom.IPAddress } */
    this.mask;
  }
};



mojo.internal.Struct(
    certVerifier.mojom.CertWithConstraintsSpec.$,
    'CertWithConstraints',
    [
      mojo.internal.StructField(
        'certificate', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'permittedDnsNames', 8,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'permittedCidrs', 16,
        0,
        mojo.internal.Array(certVerifier.mojom.CIDRSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
certVerifier.mojom.CertWithConstraints = class {
  constructor() {
    /** @export { !Array<!number> } */
    this.certificate;
    /** @export { !Array<!string> } */
    this.permittedDnsNames;
    /** @export { !Array<!certVerifier.mojom.CIDR> } */
    this.permittedCidrs;
  }
};



mojo.internal.Struct(
    certVerifier.mojom.AdditionalCertificatesSpec.$,
    'AdditionalCertificates',
    [
      mojo.internal.StructField(
        'allCertificates', 0,
        0,
        mojo.internal.Array(mojo.internal.Array(mojo.internal.Uint8, false), false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'trustAnchors', 8,
        0,
        mojo.internal.Array(mojo.internal.Array(mojo.internal.Uint8, false), false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'trustAnchorsWithEnforcedConstraints', 16,
        0,
        mojo.internal.Array(mojo.internal.Array(mojo.internal.Uint8, false), false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'trustAnchorsWithAdditionalConstraints', 24,
        0,
        mojo.internal.Array(certVerifier.mojom.CertWithConstraintsSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'trustAnchorsAndLeafs', 32,
        0,
        mojo.internal.Array(certVerifier.mojom.CertWithConstraintsSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'trustLeafs', 40,
        0,
        mojo.internal.Array(certVerifier.mojom.CertWithConstraintsSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'distrustedSpkis', 48,
        0,
        mojo.internal.Array(mojo.internal.Array(mojo.internal.Uint8, false), false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 64],]);





/** @record */
certVerifier.mojom.AdditionalCertificates = class {
  constructor() {
    /** @export { !Array<!Array<!number>> } */
    this.allCertificates;
    /** @export { !Array<!Array<!number>> } */
    this.trustAnchors;
    /** @export { !Array<!Array<!number>> } */
    this.trustAnchorsWithEnforcedConstraints;
    /** @export { !Array<!certVerifier.mojom.CertWithConstraints> } */
    this.trustAnchorsWithAdditionalConstraints;
    /** @export { !Array<!certVerifier.mojom.CertWithConstraints> } */
    this.trustAnchorsAndLeafs;
    /** @export { !Array<!certVerifier.mojom.CertWithConstraints> } */
    this.trustLeafs;
    /** @export { !Array<!Array<!number>> } */
    this.distrustedSpkis;
  }
};



mojo.internal.Struct(
    certVerifier.mojom.CertVerifierServiceUpdater_UpdateAdditionalCertificates_ParamsSpec.$,
    'CertVerifierServiceUpdater_UpdateAdditionalCertificates_Params',
    [
      mojo.internal.StructField(
        'certificates', 0,
        0,
        certVerifier.mojom.AdditionalCertificatesSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
certVerifier.mojom.CertVerifierServiceUpdater_UpdateAdditionalCertificates_Params = class {
  constructor() {
    /** @export { !certVerifier.mojom.AdditionalCertificates } */
    this.certificates;
  }
};



mojo.internal.Struct(
    certVerifier.mojom.CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_ParamsSpec.$,
    'CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_Params',
    [
    ],
    [[0, 8],]);





/** @record */
certVerifier.mojom.CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    certVerifier.mojom.CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_ResponseParamsSpec.$,
    'CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_ResponseParams',
    [
    ],
    [[0, 8],]);





/** @record */
certVerifier.mojom.CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    certVerifier.mojom.CertVerifierServiceUpdater_SetCTPolicy_ParamsSpec.$,
    'CertVerifierServiceUpdater_SetCTPolicy_Params',
    [
      mojo.internal.StructField(
        'ctPolicy', 0,
        0,
        network.mojom.CTPolicySpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
certVerifier.mojom.CertVerifierServiceUpdater_SetCTPolicy_Params = class {
  constructor() {
    /** @export { !network.mojom.CTPolicy } */
    this.ctPolicy;
  }
};

