// services/network/public/mojom/cert_verifier_service_updater.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/network/public/mojom/cert_verifier_service_updater.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('certVerifier.mojom');
  var ip_address$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/ip_address.mojom', 'ip_address.mojom.js');
  }
  var network_context$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/network_context.mojom', 'network_context.mojom.js');
  }



  function CIDR(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CIDR.prototype.initDefaults_ = function() {
    this.ip = null;
    this.mask = null;
  };
  CIDR.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CIDR.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CIDR.ip
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, ip_address$.IPAddress, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CIDR.mask
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, ip_address$.IPAddress, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CIDR.encodedSize = codec.kStructHeaderSize + 16;

  CIDR.decode = function(decoder) {
    var packed;
    var val = new CIDR();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.ip =
        decoder.decodeStructPointer(ip_address$.IPAddress);
    val.mask =
        decoder.decodeStructPointer(ip_address$.IPAddress);
    return val;
  };

  CIDR.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CIDR.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(ip_address$.IPAddress, val.ip);
    encoder.encodeStructPointer(ip_address$.IPAddress, val.mask);
  };
  function CertWithConstraints(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CertWithConstraints.prototype.initDefaults_ = function() {
    this.certificate = null;
    this.permittedDnsNames = null;
    this.permittedCidrs = null;
  };
  CertWithConstraints.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CertWithConstraints.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CertWithConstraints.certificate
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CertWithConstraints.permittedDnsNames
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, codec.String, false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CertWithConstraints.permittedCidrs
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 8, new codec.PointerTo(CIDR), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CertWithConstraints.encodedSize = codec.kStructHeaderSize + 24;

  CertWithConstraints.decode = function(decoder) {
    var packed;
    var val = new CertWithConstraints();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.certificate =
        decoder.decodeArrayPointer(codec.Uint8);
    val.permittedDnsNames =
        decoder.decodeArrayPointer(codec.String);
    val.permittedCidrs =
        decoder.decodeArrayPointer(new codec.PointerTo(CIDR));
    return val;
  };

  CertWithConstraints.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CertWithConstraints.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.Uint8, val.certificate);
    encoder.encodeArrayPointer(codec.String, val.permittedDnsNames);
    encoder.encodeArrayPointer(new codec.PointerTo(CIDR), val.permittedCidrs);
  };
  function AdditionalCertificates(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AdditionalCertificates.prototype.initDefaults_ = function() {
    this.allCertificates = null;
    this.trustAnchors = null;
    this.trustAnchorsWithEnforcedConstraints = null;
    this.trustAnchorsWithAdditionalConstraints = null;
    this.trustAnchorsAndLeafs = null;
    this.trustLeafs = null;
    this.distrustedSpkis = null;
  };
  AdditionalCertificates.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AdditionalCertificates.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 64}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AdditionalCertificates.allCertificates
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.ArrayOf(codec.Uint8), false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AdditionalCertificates.trustAnchors
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.ArrayOf(codec.Uint8), false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AdditionalCertificates.trustAnchorsWithEnforcedConstraints
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 8, new codec.ArrayOf(codec.Uint8), false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AdditionalCertificates.trustAnchorsWithAdditionalConstraints
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 24, 8, new codec.PointerTo(CertWithConstraints), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AdditionalCertificates.trustAnchorsAndLeafs
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 32, 8, new codec.PointerTo(CertWithConstraints), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AdditionalCertificates.trustLeafs
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 40, 8, new codec.PointerTo(CertWithConstraints), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AdditionalCertificates.distrustedSpkis
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 48, 8, new codec.ArrayOf(codec.Uint8), false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AdditionalCertificates.encodedSize = codec.kStructHeaderSize + 56;

  AdditionalCertificates.decode = function(decoder) {
    var packed;
    var val = new AdditionalCertificates();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.allCertificates =
        decoder.decodeArrayPointer(new codec.ArrayOf(codec.Uint8));
    val.trustAnchors =
        decoder.decodeArrayPointer(new codec.ArrayOf(codec.Uint8));
    val.trustAnchorsWithEnforcedConstraints =
        decoder.decodeArrayPointer(new codec.ArrayOf(codec.Uint8));
    val.trustAnchorsWithAdditionalConstraints =
        decoder.decodeArrayPointer(new codec.PointerTo(CertWithConstraints));
    val.trustAnchorsAndLeafs =
        decoder.decodeArrayPointer(new codec.PointerTo(CertWithConstraints));
    val.trustLeafs =
        decoder.decodeArrayPointer(new codec.PointerTo(CertWithConstraints));
    val.distrustedSpkis =
        decoder.decodeArrayPointer(new codec.ArrayOf(codec.Uint8));
    return val;
  };

  AdditionalCertificates.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AdditionalCertificates.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.ArrayOf(codec.Uint8), val.allCertificates);
    encoder.encodeArrayPointer(new codec.ArrayOf(codec.Uint8), val.trustAnchors);
    encoder.encodeArrayPointer(new codec.ArrayOf(codec.Uint8), val.trustAnchorsWithEnforcedConstraints);
    encoder.encodeArrayPointer(new codec.PointerTo(CertWithConstraints), val.trustAnchorsWithAdditionalConstraints);
    encoder.encodeArrayPointer(new codec.PointerTo(CertWithConstraints), val.trustAnchorsAndLeafs);
    encoder.encodeArrayPointer(new codec.PointerTo(CertWithConstraints), val.trustLeafs);
    encoder.encodeArrayPointer(new codec.ArrayOf(codec.Uint8), val.distrustedSpkis);
  };
  function CertVerifierServiceUpdater_UpdateAdditionalCertificates_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CertVerifierServiceUpdater_UpdateAdditionalCertificates_Params.prototype.initDefaults_ = function() {
    this.certificates = null;
  };
  CertVerifierServiceUpdater_UpdateAdditionalCertificates_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CertVerifierServiceUpdater_UpdateAdditionalCertificates_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CertVerifierServiceUpdater_UpdateAdditionalCertificates_Params.certificates
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, AdditionalCertificates, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CertVerifierServiceUpdater_UpdateAdditionalCertificates_Params.encodedSize = codec.kStructHeaderSize + 8;

  CertVerifierServiceUpdater_UpdateAdditionalCertificates_Params.decode = function(decoder) {
    var packed;
    var val = new CertVerifierServiceUpdater_UpdateAdditionalCertificates_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.certificates =
        decoder.decodeStructPointer(AdditionalCertificates);
    return val;
  };

  CertVerifierServiceUpdater_UpdateAdditionalCertificates_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CertVerifierServiceUpdater_UpdateAdditionalCertificates_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(AdditionalCertificates, val.certificates);
  };
  function CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_Params.prototype.initDefaults_ = function() {
  };
  CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_Params.encodedSize = codec.kStructHeaderSize + 0;

  CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_Params.decode = function(decoder) {
    var packed;
    var val = new CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_ResponseParams.prototype.initDefaults_ = function() {
  };
  CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function CertVerifierServiceUpdater_SetCTPolicy_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CertVerifierServiceUpdater_SetCTPolicy_Params.prototype.initDefaults_ = function() {
    this.ctPolicy = null;
  };
  CertVerifierServiceUpdater_SetCTPolicy_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CertVerifierServiceUpdater_SetCTPolicy_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CertVerifierServiceUpdater_SetCTPolicy_Params.ctPolicy
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, network_context$.CTPolicy, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CertVerifierServiceUpdater_SetCTPolicy_Params.encodedSize = codec.kStructHeaderSize + 8;

  CertVerifierServiceUpdater_SetCTPolicy_Params.decode = function(decoder) {
    var packed;
    var val = new CertVerifierServiceUpdater_SetCTPolicy_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.ctPolicy =
        decoder.decodeStructPointer(network_context$.CTPolicy);
    return val;
  };

  CertVerifierServiceUpdater_SetCTPolicy_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CertVerifierServiceUpdater_SetCTPolicy_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(network_context$.CTPolicy, val.ctPolicy);
  };
  var kCertVerifierServiceUpdater_UpdateAdditionalCertificates_Name = 0;
  var kCertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_Name = 1;
  var kCertVerifierServiceUpdater_SetCTPolicy_Name = 2;

  function CertVerifierServiceUpdaterPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(CertVerifierServiceUpdater,
                                                   handleOrPtrInfo);
  }

  function CertVerifierServiceUpdaterAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        CertVerifierServiceUpdater, associatedInterfacePtrInfo);
  }

  CertVerifierServiceUpdaterAssociatedPtr.prototype =
      Object.create(CertVerifierServiceUpdaterPtr.prototype);
  CertVerifierServiceUpdaterAssociatedPtr.prototype.constructor =
      CertVerifierServiceUpdaterAssociatedPtr;

  function CertVerifierServiceUpdaterProxy(receiver) {
    this.receiver_ = receiver;
  }
  CertVerifierServiceUpdaterPtr.prototype.updateAdditionalCertificates = function() {
    return CertVerifierServiceUpdaterProxy.prototype.updateAdditionalCertificates
        .apply(this.ptr.getProxy(), arguments);
  };

  CertVerifierServiceUpdaterProxy.prototype.updateAdditionalCertificates = function(certificates) {
    var params_ = new CertVerifierServiceUpdater_UpdateAdditionalCertificates_Params();
    params_.certificates = certificates;
    var builder = new codec.MessageV0Builder(
        kCertVerifierServiceUpdater_UpdateAdditionalCertificates_Name,
        codec.align(CertVerifierServiceUpdater_UpdateAdditionalCertificates_Params.encodedSize));
    builder.encodeStruct(CertVerifierServiceUpdater_UpdateAdditionalCertificates_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  CertVerifierServiceUpdaterPtr.prototype.waitUntilNextUpdateForTesting = function() {
    return CertVerifierServiceUpdaterProxy.prototype.waitUntilNextUpdateForTesting
        .apply(this.ptr.getProxy(), arguments);
  };

  CertVerifierServiceUpdaterProxy.prototype.waitUntilNextUpdateForTesting = function() {
    var params_ = new CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kCertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_Name,
          codec.align(CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  CertVerifierServiceUpdaterPtr.prototype.setCTPolicy = function() {
    return CertVerifierServiceUpdaterProxy.prototype.setCTPolicy
        .apply(this.ptr.getProxy(), arguments);
  };

  CertVerifierServiceUpdaterProxy.prototype.setCTPolicy = function(ctPolicy) {
    var params_ = new CertVerifierServiceUpdater_SetCTPolicy_Params();
    params_.ctPolicy = ctPolicy;
    var builder = new codec.MessageV0Builder(
        kCertVerifierServiceUpdater_SetCTPolicy_Name,
        codec.align(CertVerifierServiceUpdater_SetCTPolicy_Params.encodedSize));
    builder.encodeStruct(CertVerifierServiceUpdater_SetCTPolicy_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function CertVerifierServiceUpdaterStub(delegate) {
    this.delegate_ = delegate;
  }
  CertVerifierServiceUpdaterStub.prototype.updateAdditionalCertificates = function(certificates) {
    return this.delegate_ && this.delegate_.updateAdditionalCertificates && this.delegate_.updateAdditionalCertificates(certificates);
  }
  CertVerifierServiceUpdaterStub.prototype.waitUntilNextUpdateForTesting = function() {
    return this.delegate_ && this.delegate_.waitUntilNextUpdateForTesting && this.delegate_.waitUntilNextUpdateForTesting();
  }
  CertVerifierServiceUpdaterStub.prototype.setCTPolicy = function(ctPolicy) {
    return this.delegate_ && this.delegate_.setCTPolicy && this.delegate_.setCTPolicy(ctPolicy);
  }

  CertVerifierServiceUpdaterStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kCertVerifierServiceUpdater_UpdateAdditionalCertificates_Name:
      var params = reader.decodeStruct(CertVerifierServiceUpdater_UpdateAdditionalCertificates_Params);
      this.updateAdditionalCertificates(params.certificates);
      return true;
    case kCertVerifierServiceUpdater_SetCTPolicy_Name:
      var params = reader.decodeStruct(CertVerifierServiceUpdater_SetCTPolicy_Params);
      this.setCTPolicy(params.ctPolicy);
      return true;
    default:
      return false;
    }
  };

  CertVerifierServiceUpdaterStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kCertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_Name:
      var params = reader.decodeStruct(CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_Params);
      this.waitUntilNextUpdateForTesting().then(function(response) {
        var responseParams =
            new CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kCertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_Name,
            codec.align(CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateCertVerifierServiceUpdaterRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kCertVerifierServiceUpdater_UpdateAdditionalCertificates_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = CertVerifierServiceUpdater_UpdateAdditionalCertificates_Params;
      break;
      case kCertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_Name:
        if (message.expectsResponse())
          paramsClass = CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_Params;
      break;
      case kCertVerifierServiceUpdater_SetCTPolicy_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = CertVerifierServiceUpdater_SetCTPolicy_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateCertVerifierServiceUpdaterResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kCertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_Name:
        if (message.isResponse())
          paramsClass = CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var CertVerifierServiceUpdater = {
    name: 'cert_verifier.mojom.CertVerifierServiceUpdater',
    kVersion: 0,
    ptrClass: CertVerifierServiceUpdaterPtr,
    proxyClass: CertVerifierServiceUpdaterProxy,
    stubClass: CertVerifierServiceUpdaterStub,
    validateRequest: validateCertVerifierServiceUpdaterRequest,
    validateResponse: validateCertVerifierServiceUpdaterResponse,
  };
  CertVerifierServiceUpdaterStub.prototype.validator = validateCertVerifierServiceUpdaterRequest;
  CertVerifierServiceUpdaterProxy.prototype.validator = validateCertVerifierServiceUpdaterResponse;
  exports.CIDR = CIDR;
  exports.CertWithConstraints = CertWithConstraints;
  exports.AdditionalCertificates = AdditionalCertificates;
  exports.CertVerifierServiceUpdater = CertVerifierServiceUpdater;
  exports.CertVerifierServiceUpdaterPtr = CertVerifierServiceUpdaterPtr;
  exports.CertVerifierServiceUpdaterAssociatedPtr = CertVerifierServiceUpdaterAssociatedPtr;
})();