// services/network/public/mojom/connection_change_observer_client.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('network.mojom');





/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
network.mojom.NetworkChangeEventSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
network.mojom.NetworkChangeEvent = {
  
  kSoonToDisconnect: 0,
  kDisconnected: 1,
  kConnected: 2,
  kDefaultNetworkChanged: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};





/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
network.mojom.ConnectionChangeObserverClientPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        network.mojom.ConnectionChangeObserverClient.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { network.mojom.ConnectionChangeObserverClientInterface }
 */
network.mojom.ConnectionChangeObserverClientRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!network.mojom.ConnectionChangeObserverClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          network.mojom.ConnectionChangeObserverClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!network.mojom.ConnectionChangeObserverClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  onSessionClosed() {
    this.proxy.sendMessage(
        0,
        network.mojom.ConnectionChangeObserverClient_OnSessionClosed_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.NetworkChangeEvent } event
   */

  onNetworkEvent(
      event) {
    this.proxy.sendMessage(
        1,
        network.mojom.ConnectionChangeObserverClient_OnNetworkEvent_ParamsSpec.$,
        null,
        [
          event
        ],
        false);
  }

  
  /**
   */

  onConnectionFailed() {
    this.proxy.sendMessage(
        2,
        network.mojom.ConnectionChangeObserverClient_OnConnectionFailed_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the ConnectionChangeObserverClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
network.mojom.ConnectionChangeObserverClientReceiver = class {
  /**
   * @param {!network.mojom.ConnectionChangeObserverClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!network.mojom.ConnectionChangeObserverClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        network.mojom.ConnectionChangeObserverClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.ConnectionChangeObserverClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        network.mojom.ConnectionChangeObserverClient_OnSessionClosed_ParamsSpec.$,
        null,
        impl.onSessionClosed.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        network.mojom.ConnectionChangeObserverClient_OnNetworkEvent_ParamsSpec.$,
        null,
        impl.onNetworkEvent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        network.mojom.ConnectionChangeObserverClient_OnConnectionFailed_ParamsSpec.$,
        null,
        impl.onConnectionFailed.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
network.mojom.ConnectionChangeObserverClient = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.ConnectionChangeObserverClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!network.mojom.ConnectionChangeObserverClientRemote}
   * @export
   */
  static getRemote() {
    let remote = new network.mojom.ConnectionChangeObserverClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the ConnectionChangeObserverClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
network.mojom.ConnectionChangeObserverClientCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      network.mojom.ConnectionChangeObserverClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.ConnectionChangeObserverClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onSessionClosed =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        network.mojom.ConnectionChangeObserverClient_OnSessionClosed_ParamsSpec.$,
        null,
        this.onSessionClosed.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onNetworkEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        network.mojom.ConnectionChangeObserverClient_OnNetworkEvent_ParamsSpec.$,
        null,
        this.onNetworkEvent.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onConnectionFailed =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        network.mojom.ConnectionChangeObserverClient_OnConnectionFailed_ParamsSpec.$,
        null,
        this.onConnectionFailed.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.ConnectionKeepAliveConfigSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.ConnectionChangeObserverClient_OnSessionClosed_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.ConnectionChangeObserverClient_OnNetworkEvent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.ConnectionChangeObserverClient_OnConnectionFailed_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    network.mojom.ConnectionKeepAliveConfigSpec.$,
    'ConnectionKeepAliveConfig',
    [
      mojo.internal.StructField(
        'idleTimeoutInSeconds', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'pingIntervalInSeconds', 4,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'enableConnectionKeepAlive', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'quicConnectionOptions', 16,
        0,
        mojo.internal.String,
        "",
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
network.mojom.ConnectionKeepAliveConfig = class {
  constructor() {
    /** @export { !number } */
    this.idleTimeoutInSeconds;
    /** @export { !number } */
    this.pingIntervalInSeconds;
    /** @export { !boolean } */
    this.enableConnectionKeepAlive;
    /** @export { !string } */
    this.quicConnectionOptions;
  }
};



mojo.internal.Struct(
    network.mojom.ConnectionChangeObserverClient_OnSessionClosed_ParamsSpec.$,
    'ConnectionChangeObserverClient_OnSessionClosed_Params',
    [
    ],
    [[0, 8],]);





/** @record */
network.mojom.ConnectionChangeObserverClient_OnSessionClosed_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.ConnectionChangeObserverClient_OnNetworkEvent_ParamsSpec.$,
    'ConnectionChangeObserverClient_OnNetworkEvent_Params',
    [
      mojo.internal.StructField(
        'event', 0,
        0,
        network.mojom.NetworkChangeEventSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.ConnectionChangeObserverClient_OnNetworkEvent_Params = class {
  constructor() {
    /** @export { !network.mojom.NetworkChangeEvent } */
    this.event;
  }
};



mojo.internal.Struct(
    network.mojom.ConnectionChangeObserverClient_OnConnectionFailed_ParamsSpec.$,
    'ConnectionChangeObserverClient_OnConnectionFailed_Params',
    [
    ],
    [[0, 8],]);





/** @record */
network.mojom.ConnectionChangeObserverClient_OnConnectionFailed_Params = class {
  constructor() {
  }
};

