// services/network/public/mojom/cross_origin_opener_policy.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('network.mojom.SourceLocation');




goog.provide('network.mojom.CoopAccessReportType');
goog.provide('network.mojom.CoopAccessReportTypeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
network.mojom.CoopAccessReportTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
network.mojom.CoopAccessReportType = {
  
  kAccessFromCoopPageToOpener: 0,
  kAccessFromCoopPageToOpenee: 1,
  kAccessFromCoopPageToOther: 2,
  kAccessToCoopPageFromOpener: 3,
  kAccessToCoopPageFromOpenee: 4,
  kAccessToCoopPageFromOther: 5,
  MIN_VALUE: 0,
  MAX_VALUE: 5,
};

goog.provide('network.mojom.CrossOriginOpenerPolicyValue');
goog.provide('network.mojom.CrossOriginOpenerPolicyValueSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
network.mojom.CrossOriginOpenerPolicyValueSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
network.mojom.CrossOriginOpenerPolicyValue = {
  
  kUnsafeNone: 0,
  kSameOriginAllowPopups: 1,
  kSameOrigin: 2,
  kSameOriginPlusCoep: 3,
  kNoopenerAllowPopups: 4,
  MIN_VALUE: 0,
  MAX_VALUE: 4,
};



goog.provide('network.mojom.CrossOriginOpenerPolicyReporter');
goog.provide('network.mojom.CrossOriginOpenerPolicyReporterReceiver');
goog.provide('network.mojom.CrossOriginOpenerPolicyReporterCallbackRouter');
goog.provide('network.mojom.CrossOriginOpenerPolicyReporterInterface');
goog.provide('network.mojom.CrossOriginOpenerPolicyReporterRemote');
goog.provide('network.mojom.CrossOriginOpenerPolicyReporterPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
network.mojom.CrossOriginOpenerPolicyReporterPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        network.mojom.CrossOriginOpenerPolicyReporter.$interfaceName,
        scope);
  }
};

/** @interface */
network.mojom.CrossOriginOpenerPolicyReporterInterface = class {
  
  /**
   * @param { !network.mojom.CoopAccessReportType } reportType
   * @param { !string } property
   * @param { !network.mojom.SourceLocation } sourceLocation
   * @param { !string } reportedWindowUrl
   */

  queueAccessReport(reportType, property, sourceLocation, reportedWindowUrl) {}
};

/**
 * @export
 * @implements { network.mojom.CrossOriginOpenerPolicyReporterInterface }
 */
network.mojom.CrossOriginOpenerPolicyReporterRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!network.mojom.CrossOriginOpenerPolicyReporterPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          network.mojom.CrossOriginOpenerPolicyReporterPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!network.mojom.CrossOriginOpenerPolicyReporterPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !network.mojom.CoopAccessReportType } reportType
   * @param { !string } property
   * @param { !network.mojom.SourceLocation } sourceLocation
   * @param { !string } reportedWindowUrl
   */

  queueAccessReport(
      reportType,
      property,
      sourceLocation,
      reportedWindowUrl) {
    this.proxy.sendMessage(
        0,
        network.mojom.CrossOriginOpenerPolicyReporter_QueueAccessReport_ParamsSpec.$,
        null,
        [
          reportType,
          property,
          sourceLocation,
          reportedWindowUrl
        ],
        false);
  }
};

/**
 * An object which receives request messages for the CrossOriginOpenerPolicyReporter
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
network.mojom.CrossOriginOpenerPolicyReporterReceiver = class {
  /**
   * @param {!network.mojom.CrossOriginOpenerPolicyReporterInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!network.mojom.CrossOriginOpenerPolicyReporterRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        network.mojom.CrossOriginOpenerPolicyReporterRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.CrossOriginOpenerPolicyReporterRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        network.mojom.CrossOriginOpenerPolicyReporter_QueueAccessReport_ParamsSpec.$,
        null,
        impl.queueAccessReport.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
network.mojom.CrossOriginOpenerPolicyReporter = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.CrossOriginOpenerPolicyReporter";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!network.mojom.CrossOriginOpenerPolicyReporterRemote}
   * @export
   */
  static getRemote() {
    let remote = new network.mojom.CrossOriginOpenerPolicyReporterRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the CrossOriginOpenerPolicyReporter
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
network.mojom.CrossOriginOpenerPolicyReporterCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      network.mojom.CrossOriginOpenerPolicyReporterRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.CrossOriginOpenerPolicyReporterRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.queueAccessReport =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        network.mojom.CrossOriginOpenerPolicyReporter_QueueAccessReport_ParamsSpec.$,
        null,
        this.queueAccessReport.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('network.mojom.CrossOriginOpenerPolicyReporterParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.CrossOriginOpenerPolicyReporterParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.CrossOriginOpenerPolicySpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.CrossOriginOpenerPolicySpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.CrossOriginOpenerPolicyReporter_QueueAccessReport_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.CrossOriginOpenerPolicyReporter_QueueAccessReport_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    network.mojom.CrossOriginOpenerPolicyReporterParamsSpec.$,
    'CrossOriginOpenerPolicyReporterParams',
    [
      mojo.internal.StructField(
        'reportType', 0,
        0,
        network.mojom.CoopAccessReportTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'reporter', 4,
        0,
        mojo.internal.InterfaceProxy(network.mojom.CrossOriginOpenerPolicyReporterRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'endpointDefined', 12,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'reportedWindowUrl', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('network.mojom.CrossOriginOpenerPolicyReporterParams');

/** @record */
network.mojom.CrossOriginOpenerPolicyReporterParams = class {
  constructor() {
    /** @export { !network.mojom.CoopAccessReportType } */
    this.reportType;
    /** @export { !network.mojom.CrossOriginOpenerPolicyReporterRemote } */
    this.reporter;
    /** @export { !boolean } */
    this.endpointDefined;
    /** @export { !string } */
    this.reportedWindowUrl;
  }
};



mojo.internal.Struct(
    network.mojom.CrossOriginOpenerPolicySpec.$,
    'CrossOriginOpenerPolicy',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        network.mojom.CrossOriginOpenerPolicyValueSpec.$,
        network.mojom.CrossOriginOpenerPolicyValue.kUnsafeNone,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'reportingEndpoint', 8,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'reportOnlyValue', 4,
        0,
        network.mojom.CrossOriginOpenerPolicyValueSpec.$,
        network.mojom.CrossOriginOpenerPolicyValue.kUnsafeNone,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'reportOnlyReportingEndpoint', 16,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'soapByDefaultValue', 24,
        0,
        network.mojom.CrossOriginOpenerPolicyValueSpec.$,
        network.mojom.CrossOriginOpenerPolicyValue.kUnsafeNone,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('network.mojom.CrossOriginOpenerPolicy');

/** @record */
network.mojom.CrossOriginOpenerPolicy = class {
  constructor() {
    /** @export { !network.mojom.CrossOriginOpenerPolicyValue } */
    this.value;
    /** @export { (string|undefined) } */
    this.reportingEndpoint;
    /** @export { !network.mojom.CrossOriginOpenerPolicyValue } */
    this.reportOnlyValue;
    /** @export { (string|undefined) } */
    this.reportOnlyReportingEndpoint;
    /** @export { !network.mojom.CrossOriginOpenerPolicyValue } */
    this.soapByDefaultValue;
  }
};



mojo.internal.Struct(
    network.mojom.CrossOriginOpenerPolicyReporter_QueueAccessReport_ParamsSpec.$,
    'CrossOriginOpenerPolicyReporter_QueueAccessReport_Params',
    [
      mojo.internal.StructField(
        'reportType', 0,
        0,
        network.mojom.CoopAccessReportTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'property', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sourceLocation', 16,
        0,
        network.mojom.SourceLocationSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'reportedWindowUrl', 24,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('network.mojom.CrossOriginOpenerPolicyReporter_QueueAccessReport_Params');

/** @record */
network.mojom.CrossOriginOpenerPolicyReporter_QueueAccessReport_Params = class {
  constructor() {
    /** @export { !network.mojom.CoopAccessReportType } */
    this.reportType;
    /** @export { !string } */
    this.property;
    /** @export { !network.mojom.SourceLocation } */
    this.sourceLocation;
    /** @export { !string } */
    this.reportedWindowUrl;
  }
};

