// services/network/public/mojom/ct_log_info.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/network/public/mojom/ct_log_info.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('network.mojom');
  var byte_string$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/byte_string.mojom', '../../../../mojo/public/mojom/base/byte_string.mojom.js');
  }
  var time$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/time.mojom', '../../../../mojo/public/mojom/base/time.mojom.js');
  }



  function PreviousOperatorEntry(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PreviousOperatorEntry.prototype.initDefaults_ = function() {
    this.name = null;
    this.endTime = null;
  };
  PreviousOperatorEntry.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PreviousOperatorEntry.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PreviousOperatorEntry.name
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate PreviousOperatorEntry.endTime
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, time$.Time, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PreviousOperatorEntry.encodedSize = codec.kStructHeaderSize + 16;

  PreviousOperatorEntry.decode = function(decoder) {
    var packed;
    var val = new PreviousOperatorEntry();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.name =
        decoder.decodeStruct(codec.String);
    val.endTime =
        decoder.decodeStructPointer(time$.Time);
    return val;
  };

  PreviousOperatorEntry.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PreviousOperatorEntry.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.name);
    encoder.encodeStructPointer(time$.Time, val.endTime);
  };
  function CTLogInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }

  CTLogInfo.LogType = {};
  CTLogInfo.LogType.kUnspecified = 0;
  CTLogInfo.LogType.kRFC6962 = 1;
  CTLogInfo.LogType.kStaticCTAPI = 2;
  CTLogInfo.LogType.MIN_VALUE = 0;
  CTLogInfo.LogType.MAX_VALUE = 2;

  CTLogInfo.LogType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  CTLogInfo.LogType.toKnownEnumValue = function(value) {
    return value;
  };

  CTLogInfo.LogType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  CTLogInfo.prototype.initDefaults_ = function() {
    this.id = null;
    this.publicKey = null;
    this.name = null;
    this.disqualifiedAt = null;
    this.mmd = null;
    this.currentOperator = null;
    this.previousOperators = null;
    this.logType = 0;
  };
  CTLogInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CTLogInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 72}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CTLogInfo.id
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, byte_string$.ByteString, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CTLogInfo.publicKey
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, byte_string$.ByteString, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CTLogInfo.name
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate CTLogInfo.disqualifiedAt
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, time$.Time, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CTLogInfo.mmd
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, time$.TimeDelta, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CTLogInfo.currentOperator
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 40, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate CTLogInfo.previousOperators
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 48, 8, new codec.PointerTo(PreviousOperatorEntry), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CTLogInfo.logType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 56, CTLogInfo.LogType);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CTLogInfo.encodedSize = codec.kStructHeaderSize + 64;

  CTLogInfo.decode = function(decoder) {
    var packed;
    var val = new CTLogInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.id =
        decoder.decodeStructPointer(byte_string$.ByteString);
    val.publicKey =
        decoder.decodeStructPointer(byte_string$.ByteString);
    val.name =
        decoder.decodeStruct(codec.String);
    val.disqualifiedAt =
        decoder.decodeStructPointer(time$.Time);
    val.mmd =
        decoder.decodeStructPointer(time$.TimeDelta);
    val.currentOperator =
        decoder.decodeStruct(codec.String);
    val.previousOperators =
        decoder.decodeArrayPointer(new codec.PointerTo(PreviousOperatorEntry));
    val.logType =
        decoder.decodeStruct(new codec.Enum(CTLogInfo.LogType));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  CTLogInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CTLogInfo.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(byte_string$.ByteString, val.id);
    encoder.encodeStructPointer(byte_string$.ByteString, val.publicKey);
    encoder.encodeStruct(codec.String, val.name);
    encoder.encodeStructPointer(time$.Time, val.disqualifiedAt);
    encoder.encodeStructPointer(time$.TimeDelta, val.mmd);
    encoder.encodeStruct(codec.String, val.currentOperator);
    encoder.encodeArrayPointer(new codec.PointerTo(PreviousOperatorEntry), val.previousOperators);
    encoder.encodeStruct(codec.Int32, val.logType);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  exports.PreviousOperatorEntry = PreviousOperatorEntry;
  exports.CTLogInfo = CTLogInfo;
})();