// services/network/public/mojom/dhcp_wpad_url_client.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('network.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
network.mojom.DhcpWpadUrlClientPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        network.mojom.DhcpWpadUrlClient.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { network.mojom.DhcpWpadUrlClientInterface }
 */
network.mojom.DhcpWpadUrlClientRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!network.mojom.DhcpWpadUrlClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          network.mojom.DhcpWpadUrlClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!network.mojom.DhcpWpadUrlClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        url: !mojoBase.mojom.BigString,
   *  }>}
   */

  getPacUrl() {
    return this.proxy.sendMessage(
        0,
        network.mojom.DhcpWpadUrlClient_GetPacUrl_ParamsSpec.$,
        network.mojom.DhcpWpadUrlClient_GetPacUrl_ResponseParamsSpec.$,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the DhcpWpadUrlClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
network.mojom.DhcpWpadUrlClientReceiver = class {
  /**
   * @param {!network.mojom.DhcpWpadUrlClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!network.mojom.DhcpWpadUrlClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        network.mojom.DhcpWpadUrlClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.DhcpWpadUrlClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        network.mojom.DhcpWpadUrlClient_GetPacUrl_ParamsSpec.$,
        network.mojom.DhcpWpadUrlClient_GetPacUrl_ResponseParamsSpec.$,
        impl.getPacUrl.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
network.mojom.DhcpWpadUrlClient = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.DhcpWpadUrlClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!network.mojom.DhcpWpadUrlClientRemote}
   * @export
   */
  static getRemote() {
    let remote = new network.mojom.DhcpWpadUrlClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the DhcpWpadUrlClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
network.mojom.DhcpWpadUrlClientCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      network.mojom.DhcpWpadUrlClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.DhcpWpadUrlClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getPacUrl =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        network.mojom.DhcpWpadUrlClient_GetPacUrl_ParamsSpec.$,
        network.mojom.DhcpWpadUrlClient_GetPacUrl_ResponseParamsSpec.$,
        this.getPacUrl.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.DhcpWpadUrlClient_GetPacUrl_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.DhcpWpadUrlClient_GetPacUrl_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    network.mojom.DhcpWpadUrlClient_GetPacUrl_ParamsSpec.$,
    'DhcpWpadUrlClient_GetPacUrl_Params',
    [
    ],
    [[0, 8],]);





/** @record */
network.mojom.DhcpWpadUrlClient_GetPacUrl_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.DhcpWpadUrlClient_GetPacUrl_ResponseParamsSpec.$,
    'DhcpWpadUrlClient_GetPacUrl_ResponseParams',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        mojoBase.mojom.BigStringSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.DhcpWpadUrlClient_GetPacUrl_ResponseParams = class {
  constructor() {
    /** @export { !mojoBase.mojom.BigString } */
    this.url;
  }
};

