// services/network/public/mojom/dhcp_wpad_url_client.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/network/public/mojom/dhcp_wpad_url_client.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('network.mojom');
  var big_string$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/big_string.mojom', '../../../../mojo/public/mojom/base/big_string.mojom.js');
  }



  function DhcpWpadUrlClient_GetPacUrl_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DhcpWpadUrlClient_GetPacUrl_Params.prototype.initDefaults_ = function() {
  };
  DhcpWpadUrlClient_GetPacUrl_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DhcpWpadUrlClient_GetPacUrl_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DhcpWpadUrlClient_GetPacUrl_Params.encodedSize = codec.kStructHeaderSize + 0;

  DhcpWpadUrlClient_GetPacUrl_Params.decode = function(decoder) {
    var packed;
    var val = new DhcpWpadUrlClient_GetPacUrl_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  DhcpWpadUrlClient_GetPacUrl_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DhcpWpadUrlClient_GetPacUrl_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function DhcpWpadUrlClient_GetPacUrl_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DhcpWpadUrlClient_GetPacUrl_ResponseParams.prototype.initDefaults_ = function() {
    this.url = null;
  };
  DhcpWpadUrlClient_GetPacUrl_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DhcpWpadUrlClient_GetPacUrl_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DhcpWpadUrlClient_GetPacUrl_ResponseParams.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, big_string$.BigString, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DhcpWpadUrlClient_GetPacUrl_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  DhcpWpadUrlClient_GetPacUrl_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new DhcpWpadUrlClient_GetPacUrl_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.url =
        decoder.decodeStructPointer(big_string$.BigString);
    return val;
  };

  DhcpWpadUrlClient_GetPacUrl_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DhcpWpadUrlClient_GetPacUrl_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(big_string$.BigString, val.url);
  };
  var kDhcpWpadUrlClient_GetPacUrl_Name = 0;

  function DhcpWpadUrlClientPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(DhcpWpadUrlClient,
                                                   handleOrPtrInfo);
  }

  function DhcpWpadUrlClientAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        DhcpWpadUrlClient, associatedInterfacePtrInfo);
  }

  DhcpWpadUrlClientAssociatedPtr.prototype =
      Object.create(DhcpWpadUrlClientPtr.prototype);
  DhcpWpadUrlClientAssociatedPtr.prototype.constructor =
      DhcpWpadUrlClientAssociatedPtr;

  function DhcpWpadUrlClientProxy(receiver) {
    this.receiver_ = receiver;
  }
  DhcpWpadUrlClientPtr.prototype.getPacUrl = function() {
    return DhcpWpadUrlClientProxy.prototype.getPacUrl
        .apply(this.ptr.getProxy(), arguments);
  };

  DhcpWpadUrlClientProxy.prototype.getPacUrl = function() {
    var params_ = new DhcpWpadUrlClient_GetPacUrl_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kDhcpWpadUrlClient_GetPacUrl_Name,
          codec.align(DhcpWpadUrlClient_GetPacUrl_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(DhcpWpadUrlClient_GetPacUrl_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(DhcpWpadUrlClient_GetPacUrl_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function DhcpWpadUrlClientStub(delegate) {
    this.delegate_ = delegate;
  }
  DhcpWpadUrlClientStub.prototype.getPacUrl = function() {
    return this.delegate_ && this.delegate_.getPacUrl && this.delegate_.getPacUrl();
  }

  DhcpWpadUrlClientStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  DhcpWpadUrlClientStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kDhcpWpadUrlClient_GetPacUrl_Name:
      var params = reader.decodeStruct(DhcpWpadUrlClient_GetPacUrl_Params);
      this.getPacUrl().then(function(response) {
        var responseParams =
            new DhcpWpadUrlClient_GetPacUrl_ResponseParams();
        responseParams.url = response.url;
        var builder = new codec.MessageV1Builder(
            kDhcpWpadUrlClient_GetPacUrl_Name,
            codec.align(DhcpWpadUrlClient_GetPacUrl_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(DhcpWpadUrlClient_GetPacUrl_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateDhcpWpadUrlClientRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kDhcpWpadUrlClient_GetPacUrl_Name:
        if (message.expectsResponse())
          paramsClass = DhcpWpadUrlClient_GetPacUrl_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateDhcpWpadUrlClientResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kDhcpWpadUrlClient_GetPacUrl_Name:
        if (message.isResponse())
          paramsClass = DhcpWpadUrlClient_GetPacUrl_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var DhcpWpadUrlClient = {
    name: 'network.mojom.DhcpWpadUrlClient',
    kVersion: 0,
    ptrClass: DhcpWpadUrlClientPtr,
    proxyClass: DhcpWpadUrlClientProxy,
    stubClass: DhcpWpadUrlClientStub,
    validateRequest: validateDhcpWpadUrlClientRequest,
    validateResponse: validateDhcpWpadUrlClientResponse,
  };
  DhcpWpadUrlClientStub.prototype.validator = validateDhcpWpadUrlClientRequest;
  DhcpWpadUrlClientProxy.prototype.validator = validateDhcpWpadUrlClientResponse;
  exports.DhcpWpadUrlClient = DhcpWpadUrlClient;
  exports.DhcpWpadUrlClientPtr = DhcpWpadUrlClientPtr;
  exports.DhcpWpadUrlClientAssociatedPtr = DhcpWpadUrlClientAssociatedPtr;
})();