// services/network/public/mojom/dhcp_wpad_url_client.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';

import {
  BigString as mojoBase_mojom_BigString,
  BigStringSpec as mojoBase_mojom_BigStringSpec
} from '../../../../mojo/public/mojom/base/big_string.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class DhcpWpadUrlClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.DhcpWpadUrlClient', scope);
  }
}

/** @interface */
export class DhcpWpadUrlClientInterface {
  
  /**
   * @return {!Promise<{
        url: !mojoBase_mojom_BigString,
   *  }>}
   */

  getPacUrl() {}
}

/**
 * @implements { DhcpWpadUrlClientInterface }
 */
export class DhcpWpadUrlClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!DhcpWpadUrlClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          DhcpWpadUrlClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!DhcpWpadUrlClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        url: !mojoBase_mojom_BigString,
   *  }>}
   */

  getPacUrl() {
    return this.proxy.sendMessage(
        0,
        DhcpWpadUrlClient_GetPacUrl_ParamsSpec.$,
        DhcpWpadUrlClient_GetPacUrl_ResponseParamsSpec.$,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the DhcpWpadUrlClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class DhcpWpadUrlClientReceiver {
  /**
   * @param {!DhcpWpadUrlClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!DhcpWpadUrlClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        DhcpWpadUrlClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!DhcpWpadUrlClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        DhcpWpadUrlClient_GetPacUrl_ParamsSpec.$,
        DhcpWpadUrlClient_GetPacUrl_ResponseParamsSpec.$,
        impl.getPacUrl.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class DhcpWpadUrlClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.DhcpWpadUrlClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!DhcpWpadUrlClientRemote}
   */
  static getRemote() {
    let remote = new DhcpWpadUrlClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the DhcpWpadUrlClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class DhcpWpadUrlClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      DhcpWpadUrlClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!DhcpWpadUrlClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getPacUrl =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        DhcpWpadUrlClient_GetPacUrl_ParamsSpec.$,
        DhcpWpadUrlClient_GetPacUrl_ResponseParamsSpec.$,
        this.getPacUrl.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DhcpWpadUrlClient_GetPacUrl_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DhcpWpadUrlClient_GetPacUrl_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    DhcpWpadUrlClient_GetPacUrl_ParamsSpec.$,
    'DhcpWpadUrlClient_GetPacUrl_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class DhcpWpadUrlClient_GetPacUrl_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    DhcpWpadUrlClient_GetPacUrl_ResponseParamsSpec.$,
    'DhcpWpadUrlClient_GetPacUrl_ResponseParams',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        mojoBase_mojom_BigStringSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class DhcpWpadUrlClient_GetPacUrl_ResponseParams {
  constructor() {
    /** @type { !mojoBase_mojom_BigString } */
    this.url;
  }
}

