// services/network/public/mojom/document_isolation_policy.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/network/public/mojom/document_isolation_policy.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('network.mojom');
  var url$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/url.mojom', '../../../../url/mojom/url.mojom.js');
  }
  var fetch_api$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/fetch_api.mojom', 'fetch_api.mojom.js');
  }


  var DocumentIsolationPolicyValue = {};
  DocumentIsolationPolicyValue.kNone = 0;
  DocumentIsolationPolicyValue.kIsolateAndRequireCorp = 1;
  DocumentIsolationPolicyValue.kIsolateAndCredentialless = 2;
  DocumentIsolationPolicyValue.MIN_VALUE = 0;
  DocumentIsolationPolicyValue.MAX_VALUE = 2;

  DocumentIsolationPolicyValue.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  DocumentIsolationPolicyValue.toKnownEnumValue = function(value) {
    return value;
  };

  DocumentIsolationPolicyValue.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function DocumentIsolationPolicy(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DocumentIsolationPolicy.prototype.initDefaults_ = function() {
    this.value = DocumentIsolationPolicyValue.kNone;
    this.reportOnlyValue = DocumentIsolationPolicyValue.kNone;
    this.reportingEndpoint = null;
    this.reportOnlyReportingEndpoint = null;
  };
  DocumentIsolationPolicy.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DocumentIsolationPolicy.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DocumentIsolationPolicy.value
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, DocumentIsolationPolicyValue);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DocumentIsolationPolicy.reportingEndpoint
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate DocumentIsolationPolicy.reportOnlyValue
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, DocumentIsolationPolicyValue);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DocumentIsolationPolicy.reportOnlyReportingEndpoint
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, true)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DocumentIsolationPolicy.encodedSize = codec.kStructHeaderSize + 24;

  DocumentIsolationPolicy.decode = function(decoder) {
    var packed;
    var val = new DocumentIsolationPolicy();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.value =
        decoder.decodeStruct(new codec.Enum(DocumentIsolationPolicyValue));
    val.reportOnlyValue =
        decoder.decodeStruct(new codec.Enum(DocumentIsolationPolicyValue));
    val.reportingEndpoint =
        decoder.decodeStruct(codec.String);
    val.reportOnlyReportingEndpoint =
        decoder.decodeStruct(codec.String);
    return val;
  };

  DocumentIsolationPolicy.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DocumentIsolationPolicy.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.value);
    encoder.encodeStruct(codec.Int32, val.reportOnlyValue);
    encoder.encodeStruct(codec.String, val.reportingEndpoint);
    encoder.encodeStruct(codec.String, val.reportOnlyReportingEndpoint);
  };
  function DocumentIsolationPolicyReporter_QueueCorpViolationReport_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DocumentIsolationPolicyReporter_QueueCorpViolationReport_Params.prototype.initDefaults_ = function() {
    this.blockedUrl = null;
    this.destination = 0;
    this.reportOnly = false;
  };
  DocumentIsolationPolicyReporter_QueueCorpViolationReport_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DocumentIsolationPolicyReporter_QueueCorpViolationReport_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DocumentIsolationPolicyReporter_QueueCorpViolationReport_Params.blockedUrl
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DocumentIsolationPolicyReporter_QueueCorpViolationReport_Params.destination
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, fetch_api$.RequestDestination);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  DocumentIsolationPolicyReporter_QueueCorpViolationReport_Params.encodedSize = codec.kStructHeaderSize + 16;

  DocumentIsolationPolicyReporter_QueueCorpViolationReport_Params.decode = function(decoder) {
    var packed;
    var val = new DocumentIsolationPolicyReporter_QueueCorpViolationReport_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.blockedUrl =
        decoder.decodeStructPointer(url$.Url);
    val.destination =
        decoder.decodeStruct(new codec.Enum(fetch_api$.RequestDestination));
    packed = decoder.readUint8();
    val.reportOnly = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  DocumentIsolationPolicyReporter_QueueCorpViolationReport_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DocumentIsolationPolicyReporter_QueueCorpViolationReport_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.blockedUrl);
    encoder.encodeStruct(codec.Int32, val.destination);
    packed = 0;
    packed |= (val.reportOnly & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function DocumentIsolationPolicyReporter_Clone_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DocumentIsolationPolicyReporter_Clone_Params.prototype.initDefaults_ = function() {
    this.receiver = new bindings.InterfaceRequest();
  };
  DocumentIsolationPolicyReporter_Clone_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DocumentIsolationPolicyReporter_Clone_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DocumentIsolationPolicyReporter_Clone_Params.receiver
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DocumentIsolationPolicyReporter_Clone_Params.encodedSize = codec.kStructHeaderSize + 8;

  DocumentIsolationPolicyReporter_Clone_Params.decode = function(decoder) {
    var packed;
    var val = new DocumentIsolationPolicyReporter_Clone_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.receiver =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  DocumentIsolationPolicyReporter_Clone_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DocumentIsolationPolicyReporter_Clone_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.receiver);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  var kDocumentIsolationPolicyReporter_QueueCorpViolationReport_Name = 0;
  var kDocumentIsolationPolicyReporter_Clone_Name = 1;

  function DocumentIsolationPolicyReporterPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(DocumentIsolationPolicyReporter,
                                                   handleOrPtrInfo);
  }

  function DocumentIsolationPolicyReporterAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        DocumentIsolationPolicyReporter, associatedInterfacePtrInfo);
  }

  DocumentIsolationPolicyReporterAssociatedPtr.prototype =
      Object.create(DocumentIsolationPolicyReporterPtr.prototype);
  DocumentIsolationPolicyReporterAssociatedPtr.prototype.constructor =
      DocumentIsolationPolicyReporterAssociatedPtr;

  function DocumentIsolationPolicyReporterProxy(receiver) {
    this.receiver_ = receiver;
  }
  DocumentIsolationPolicyReporterPtr.prototype.queueCorpViolationReport = function() {
    return DocumentIsolationPolicyReporterProxy.prototype.queueCorpViolationReport
        .apply(this.ptr.getProxy(), arguments);
  };

  DocumentIsolationPolicyReporterProxy.prototype.queueCorpViolationReport = function(blockedUrl, destination, reportOnly) {
    var params_ = new DocumentIsolationPolicyReporter_QueueCorpViolationReport_Params();
    params_.blockedUrl = blockedUrl;
    params_.destination = destination;
    params_.reportOnly = reportOnly;
    var builder = new codec.MessageV0Builder(
        kDocumentIsolationPolicyReporter_QueueCorpViolationReport_Name,
        codec.align(DocumentIsolationPolicyReporter_QueueCorpViolationReport_Params.encodedSize));
    builder.encodeStruct(DocumentIsolationPolicyReporter_QueueCorpViolationReport_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  DocumentIsolationPolicyReporterPtr.prototype.clone = function() {
    return DocumentIsolationPolicyReporterProxy.prototype.clone
        .apply(this.ptr.getProxy(), arguments);
  };

  DocumentIsolationPolicyReporterProxy.prototype.clone = function(receiver) {
    var params_ = new DocumentIsolationPolicyReporter_Clone_Params();
    params_.receiver = receiver;
    var builder = new codec.MessageV0Builder(
        kDocumentIsolationPolicyReporter_Clone_Name,
        codec.align(DocumentIsolationPolicyReporter_Clone_Params.encodedSize));
    builder.encodeStruct(DocumentIsolationPolicyReporter_Clone_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function DocumentIsolationPolicyReporterStub(delegate) {
    this.delegate_ = delegate;
  }
  DocumentIsolationPolicyReporterStub.prototype.queueCorpViolationReport = function(blockedUrl, destination, reportOnly) {
    return this.delegate_ && this.delegate_.queueCorpViolationReport && this.delegate_.queueCorpViolationReport(blockedUrl, destination, reportOnly);
  }
  DocumentIsolationPolicyReporterStub.prototype.clone = function(receiver) {
    return this.delegate_ && this.delegate_.clone && this.delegate_.clone(receiver);
  }

  DocumentIsolationPolicyReporterStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kDocumentIsolationPolicyReporter_QueueCorpViolationReport_Name:
      var params = reader.decodeStruct(DocumentIsolationPolicyReporter_QueueCorpViolationReport_Params);
      this.queueCorpViolationReport(params.blockedUrl, params.destination, params.reportOnly);
      return true;
    case kDocumentIsolationPolicyReporter_Clone_Name:
      var params = reader.decodeStruct(DocumentIsolationPolicyReporter_Clone_Params);
      this.clone(params.receiver);
      return true;
    default:
      return false;
    }
  };

  DocumentIsolationPolicyReporterStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateDocumentIsolationPolicyReporterRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kDocumentIsolationPolicyReporter_QueueCorpViolationReport_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = DocumentIsolationPolicyReporter_QueueCorpViolationReport_Params;
      break;
      case kDocumentIsolationPolicyReporter_Clone_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = DocumentIsolationPolicyReporter_Clone_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateDocumentIsolationPolicyReporterResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var DocumentIsolationPolicyReporter = {
    name: 'network.mojom.DocumentIsolationPolicyReporter',
    kVersion: 0,
    ptrClass: DocumentIsolationPolicyReporterPtr,
    proxyClass: DocumentIsolationPolicyReporterProxy,
    stubClass: DocumentIsolationPolicyReporterStub,
    validateRequest: validateDocumentIsolationPolicyReporterRequest,
    validateResponse: null,
  };
  DocumentIsolationPolicyReporterStub.prototype.validator = validateDocumentIsolationPolicyReporterRequest;
  DocumentIsolationPolicyReporterProxy.prototype.validator = null;
  exports.DocumentIsolationPolicyValue = DocumentIsolationPolicyValue;
  exports.DocumentIsolationPolicy = DocumentIsolationPolicy;
  exports.DocumentIsolationPolicyReporter = DocumentIsolationPolicyReporter;
  exports.DocumentIsolationPolicyReporterPtr = DocumentIsolationPolicyReporterPtr;
  exports.DocumentIsolationPolicyReporterAssociatedPtr = DocumentIsolationPolicyReporterAssociatedPtr;
})();