// services/network/public/mojom/host_resolver_endpoint_result.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/network/public/mojom/host_resolver_endpoint_result.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('network.mojom');
  var ip_endpoint$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/ip_endpoint.mojom', 'ip_endpoint.mojom.js');
  }
  var connection_endpoint_metadata$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/connection_endpoint_metadata.mojom', 'connection_endpoint_metadata.mojom.js');
  }



  function HostResolverEndpointResult(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  HostResolverEndpointResult.prototype.initDefaults_ = function() {
    this.ipEndpoints = null;
    this.metadata = null;
  };
  HostResolverEndpointResult.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  HostResolverEndpointResult.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HostResolverEndpointResult.ipEndpoints
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(ip_endpoint$.IPEndPoint), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HostResolverEndpointResult.metadata
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, connection_endpoint_metadata$.ConnectionEndpointMetadata, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  HostResolverEndpointResult.encodedSize = codec.kStructHeaderSize + 16;

  HostResolverEndpointResult.decode = function(decoder) {
    var packed;
    var val = new HostResolverEndpointResult();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.ipEndpoints =
        decoder.decodeArrayPointer(new codec.PointerTo(ip_endpoint$.IPEndPoint));
    val.metadata =
        decoder.decodeStructPointer(connection_endpoint_metadata$.ConnectionEndpointMetadata);
    return val;
  };

  HostResolverEndpointResult.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(HostResolverEndpointResult.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(ip_endpoint$.IPEndPoint), val.ipEndpoints);
    encoder.encodeStructPointer(connection_endpoint_metadata$.ConnectionEndpointMetadata, val.metadata);
  };
  exports.HostResolverEndpointResult = HostResolverEndpointResult;
})();