// services/network/public/mojom/http_cache_backend_file_operations.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('mojoBase.mojom.FileError');
goog.require('mojoBase.mojom.File');
goog.require('mojoBase.mojom.FileInfo');
goog.require('mojoBase.mojom.FilePath');
goog.require('mojoBase.mojom.Time');




goog.provide('network.mojom.HttpCacheBackendOpenFileFlags');
goog.provide('network.mojom.HttpCacheBackendOpenFileFlagsSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
network.mojom.HttpCacheBackendOpenFileFlagsSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
network.mojom.HttpCacheBackendOpenFileFlags = {
  
  kOpenAndRead: 33,
  kCreateAndWrite: 66,
  kOpenReadWriteWinShareDelete: 32865,
  kCreateReadWriteWinShareDelete: 32866,
  kCreateAlwaysWriteWinShareDelete: 32840,
  kOpenReadWinShareDeleteWinSequentialScan: 557089,
  MIN_VALUE: 33,
  MAX_VALUE: 557089,
};

goog.provide('network.mojom.HttpCacheBackendDeleteFileMode');
goog.provide('network.mojom.HttpCacheBackendDeleteFileModeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
network.mojom.HttpCacheBackendDeleteFileModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
network.mojom.HttpCacheBackendDeleteFileMode = {
  
  kDefault: 0,
  kEnsureImmediateAvailability: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};



goog.provide('network.mojom.FileEnumerator');
goog.provide('network.mojom.FileEnumeratorReceiver');
goog.provide('network.mojom.FileEnumeratorCallbackRouter');
goog.provide('network.mojom.FileEnumeratorInterface');
goog.provide('network.mojom.FileEnumeratorRemote');
goog.provide('network.mojom.FileEnumeratorPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
network.mojom.FileEnumeratorPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        network.mojom.FileEnumerator.$interfaceName,
        scope);
  }
};

/** @interface */
network.mojom.FileEnumeratorInterface = class {
  
  /**
   * @param { !number } numEntries
   * @return {!Promise<{
        entries: !Array<!network.mojom.FileEnumerationEntry>,
        end: !boolean,
        error: !boolean,
   *  }>}
   */

  getNext(numEntries) {}
};

/**
 * @export
 * @implements { network.mojom.FileEnumeratorInterface }
 */
network.mojom.FileEnumeratorRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!network.mojom.FileEnumeratorPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          network.mojom.FileEnumeratorPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!network.mojom.FileEnumeratorPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !number } numEntries
   * @return {!Promise<{
        entries: !Array<!network.mojom.FileEnumerationEntry>,
        end: !boolean,
        error: !boolean,
   *  }>}
   */

  getNext(
      numEntries) {
    return this.proxy.sendMessage(
        0,
        network.mojom.FileEnumerator_GetNext_ParamsSpec.$,
        network.mojom.FileEnumerator_GetNext_ResponseParamsSpec.$,
        [
          numEntries
        ],
        false);
  }
};

/**
 * An object which receives request messages for the FileEnumerator
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
network.mojom.FileEnumeratorReceiver = class {
  /**
   * @param {!network.mojom.FileEnumeratorInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!network.mojom.FileEnumeratorRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        network.mojom.FileEnumeratorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.FileEnumeratorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        network.mojom.FileEnumerator_GetNext_ParamsSpec.$,
        network.mojom.FileEnumerator_GetNext_ResponseParamsSpec.$,
        impl.getNext.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
network.mojom.FileEnumerator = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.FileEnumerator";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!network.mojom.FileEnumeratorRemote}
   * @export
   */
  static getRemote() {
    let remote = new network.mojom.FileEnumeratorRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the FileEnumerator
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
network.mojom.FileEnumeratorCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      network.mojom.FileEnumeratorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.FileEnumeratorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getNext =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        network.mojom.FileEnumerator_GetNext_ParamsSpec.$,
        network.mojom.FileEnumerator_GetNext_ResponseParamsSpec.$,
        this.getNext.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('network.mojom.HttpCacheBackendFileOperations');
goog.provide('network.mojom.HttpCacheBackendFileOperationsReceiver');
goog.provide('network.mojom.HttpCacheBackendFileOperationsCallbackRouter');
goog.provide('network.mojom.HttpCacheBackendFileOperationsInterface');
goog.provide('network.mojom.HttpCacheBackendFileOperationsRemote');
goog.provide('network.mojom.HttpCacheBackendFileOperationsPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
network.mojom.HttpCacheBackendFileOperationsPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        network.mojom.HttpCacheBackendFileOperations.$interfaceName,
        scope);
  }
};

/** @interface */
network.mojom.HttpCacheBackendFileOperationsInterface = class {
  
  /**
   * @param { !mojoBase.mojom.FilePath } path
   * @return {!Promise<{
        result: !boolean,
   *  }>}
   */

  createDirectory(path) {}
  
  /**
   * @param { !mojoBase.mojom.FilePath } path
   * @return {!Promise<{
        result: !boolean,
   *  }>}
   */

  pathExists(path) {}
  
  /**
   * @param { !mojoBase.mojom.FilePath } path
   * @return {!Promise<{
        result: !boolean,
   *  }>}
   */

  directoryExists(path) {}
  
  /**
   * @param { !mojoBase.mojom.FilePath } path
   * @param { !network.mojom.HttpCacheBackendOpenFileFlags } flags
   * @return {!Promise<{
        file: ?mojoBase.mojom.File,
        error: !mojoBase.mojom.FileError,
   *  }>}
   */

  openFile(path, flags) {}
  
  /**
   * @param { !mojoBase.mojom.FilePath } path
   * @param { !network.mojom.HttpCacheBackendDeleteFileMode } mode
   * @return {!Promise<{
        result: !boolean,
   *  }>}
   */

  deleteFile(path, mode) {}
  
  /**
   * @param { !mojoBase.mojom.FilePath } fromPath
   * @param { !mojoBase.mojom.FilePath } toPath
   * @return {!Promise<{
        error: !mojoBase.mojom.FileError,
   *  }>}
   */

  renameFile(fromPath, toPath) {}
  
  /**
   * @param { !mojoBase.mojom.FilePath } path
   * @return {!Promise<{
        info: ?mojoBase.mojom.FileInfo,
   *  }>}
   */

  getFileInfo(path) {}
  
  /**
   * @param { !mojoBase.mojom.FilePath } path
   * @param { !network.mojom.FileEnumeratorPendingReceiver } receiver
   */

  enumerateFiles(path, receiver) {}
  
  /**
   * @param { !mojoBase.mojom.FilePath } path
   * @return {!Promise<{
        result: !boolean,
   *  }>}
   */

  cleanupDirectory(path) {}
};

/**
 * @export
 * @implements { network.mojom.HttpCacheBackendFileOperationsInterface }
 */
network.mojom.HttpCacheBackendFileOperationsRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!network.mojom.HttpCacheBackendFileOperationsPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          network.mojom.HttpCacheBackendFileOperationsPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!network.mojom.HttpCacheBackendFileOperationsPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !mojoBase.mojom.FilePath } path
   * @return {!Promise<{
        result: !boolean,
   *  }>}
   */

  createDirectory(
      path) {
    return this.proxy.sendMessage(
        0,
        network.mojom.HttpCacheBackendFileOperations_CreateDirectory_ParamsSpec.$,
        network.mojom.HttpCacheBackendFileOperations_CreateDirectory_ResponseParamsSpec.$,
        [
          path
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.FilePath } path
   * @return {!Promise<{
        result: !boolean,
   *  }>}
   */

  pathExists(
      path) {
    return this.proxy.sendMessage(
        1,
        network.mojom.HttpCacheBackendFileOperations_PathExists_ParamsSpec.$,
        network.mojom.HttpCacheBackendFileOperations_PathExists_ResponseParamsSpec.$,
        [
          path
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.FilePath } path
   * @return {!Promise<{
        result: !boolean,
   *  }>}
   */

  directoryExists(
      path) {
    return this.proxy.sendMessage(
        2,
        network.mojom.HttpCacheBackendFileOperations_DirectoryExists_ParamsSpec.$,
        network.mojom.HttpCacheBackendFileOperations_DirectoryExists_ResponseParamsSpec.$,
        [
          path
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.FilePath } path
   * @param { !network.mojom.HttpCacheBackendOpenFileFlags } flags
   * @return {!Promise<{
        file: ?mojoBase.mojom.File,
        error: !mojoBase.mojom.FileError,
   *  }>}
   */

  openFile(
      path,
      flags) {
    return this.proxy.sendMessage(
        3,
        network.mojom.HttpCacheBackendFileOperations_OpenFile_ParamsSpec.$,
        network.mojom.HttpCacheBackendFileOperations_OpenFile_ResponseParamsSpec.$,
        [
          path,
          flags
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.FilePath } path
   * @param { !network.mojom.HttpCacheBackendDeleteFileMode } mode
   * @return {!Promise<{
        result: !boolean,
   *  }>}
   */

  deleteFile(
      path,
      mode) {
    return this.proxy.sendMessage(
        4,
        network.mojom.HttpCacheBackendFileOperations_DeleteFile_ParamsSpec.$,
        network.mojom.HttpCacheBackendFileOperations_DeleteFile_ResponseParamsSpec.$,
        [
          path,
          mode
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.FilePath } fromPath
   * @param { !mojoBase.mojom.FilePath } toPath
   * @return {!Promise<{
        error: !mojoBase.mojom.FileError,
   *  }>}
   */

  renameFile(
      fromPath,
      toPath) {
    return this.proxy.sendMessage(
        5,
        network.mojom.HttpCacheBackendFileOperations_RenameFile_ParamsSpec.$,
        network.mojom.HttpCacheBackendFileOperations_RenameFile_ResponseParamsSpec.$,
        [
          fromPath,
          toPath
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.FilePath } path
   * @return {!Promise<{
        info: ?mojoBase.mojom.FileInfo,
   *  }>}
   */

  getFileInfo(
      path) {
    return this.proxy.sendMessage(
        6,
        network.mojom.HttpCacheBackendFileOperations_GetFileInfo_ParamsSpec.$,
        network.mojom.HttpCacheBackendFileOperations_GetFileInfo_ResponseParamsSpec.$,
        [
          path
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.FilePath } path
   * @param { !network.mojom.FileEnumeratorPendingReceiver } receiver
   */

  enumerateFiles(
      path,
      receiver) {
    this.proxy.sendMessage(
        7,
        network.mojom.HttpCacheBackendFileOperations_EnumerateFiles_ParamsSpec.$,
        null,
        [
          path,
          receiver
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.FilePath } path
   * @return {!Promise<{
        result: !boolean,
   *  }>}
   */

  cleanupDirectory(
      path) {
    return this.proxy.sendMessage(
        8,
        network.mojom.HttpCacheBackendFileOperations_CleanupDirectory_ParamsSpec.$,
        network.mojom.HttpCacheBackendFileOperations_CleanupDirectory_ResponseParamsSpec.$,
        [
          path
        ],
        false);
  }
};

/**
 * An object which receives request messages for the HttpCacheBackendFileOperations
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
network.mojom.HttpCacheBackendFileOperationsReceiver = class {
  /**
   * @param {!network.mojom.HttpCacheBackendFileOperationsInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!network.mojom.HttpCacheBackendFileOperationsRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        network.mojom.HttpCacheBackendFileOperationsRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.HttpCacheBackendFileOperationsRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        network.mojom.HttpCacheBackendFileOperations_CreateDirectory_ParamsSpec.$,
        network.mojom.HttpCacheBackendFileOperations_CreateDirectory_ResponseParamsSpec.$,
        impl.createDirectory.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        network.mojom.HttpCacheBackendFileOperations_PathExists_ParamsSpec.$,
        network.mojom.HttpCacheBackendFileOperations_PathExists_ResponseParamsSpec.$,
        impl.pathExists.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        network.mojom.HttpCacheBackendFileOperations_DirectoryExists_ParamsSpec.$,
        network.mojom.HttpCacheBackendFileOperations_DirectoryExists_ResponseParamsSpec.$,
        impl.directoryExists.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        network.mojom.HttpCacheBackendFileOperations_OpenFile_ParamsSpec.$,
        network.mojom.HttpCacheBackendFileOperations_OpenFile_ResponseParamsSpec.$,
        impl.openFile.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        network.mojom.HttpCacheBackendFileOperations_DeleteFile_ParamsSpec.$,
        network.mojom.HttpCacheBackendFileOperations_DeleteFile_ResponseParamsSpec.$,
        impl.deleteFile.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        network.mojom.HttpCacheBackendFileOperations_RenameFile_ParamsSpec.$,
        network.mojom.HttpCacheBackendFileOperations_RenameFile_ResponseParamsSpec.$,
        impl.renameFile.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        network.mojom.HttpCacheBackendFileOperations_GetFileInfo_ParamsSpec.$,
        network.mojom.HttpCacheBackendFileOperations_GetFileInfo_ResponseParamsSpec.$,
        impl.getFileInfo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        network.mojom.HttpCacheBackendFileOperations_EnumerateFiles_ParamsSpec.$,
        null,
        impl.enumerateFiles.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        network.mojom.HttpCacheBackendFileOperations_CleanupDirectory_ParamsSpec.$,
        network.mojom.HttpCacheBackendFileOperations_CleanupDirectory_ResponseParamsSpec.$,
        impl.cleanupDirectory.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
network.mojom.HttpCacheBackendFileOperations = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.HttpCacheBackendFileOperations";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!network.mojom.HttpCacheBackendFileOperationsRemote}
   * @export
   */
  static getRemote() {
    let remote = new network.mojom.HttpCacheBackendFileOperationsRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the HttpCacheBackendFileOperations
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
network.mojom.HttpCacheBackendFileOperationsCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      network.mojom.HttpCacheBackendFileOperationsRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.HttpCacheBackendFileOperationsRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createDirectory =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        network.mojom.HttpCacheBackendFileOperations_CreateDirectory_ParamsSpec.$,
        network.mojom.HttpCacheBackendFileOperations_CreateDirectory_ResponseParamsSpec.$,
        this.createDirectory.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.pathExists =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        network.mojom.HttpCacheBackendFileOperations_PathExists_ParamsSpec.$,
        network.mojom.HttpCacheBackendFileOperations_PathExists_ResponseParamsSpec.$,
        this.pathExists.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.directoryExists =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        network.mojom.HttpCacheBackendFileOperations_DirectoryExists_ParamsSpec.$,
        network.mojom.HttpCacheBackendFileOperations_DirectoryExists_ResponseParamsSpec.$,
        this.directoryExists.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.openFile =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        network.mojom.HttpCacheBackendFileOperations_OpenFile_ParamsSpec.$,
        network.mojom.HttpCacheBackendFileOperations_OpenFile_ResponseParamsSpec.$,
        this.openFile.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.deleteFile =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        network.mojom.HttpCacheBackendFileOperations_DeleteFile_ParamsSpec.$,
        network.mojom.HttpCacheBackendFileOperations_DeleteFile_ResponseParamsSpec.$,
        this.deleteFile.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.renameFile =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        network.mojom.HttpCacheBackendFileOperations_RenameFile_ParamsSpec.$,
        network.mojom.HttpCacheBackendFileOperations_RenameFile_ResponseParamsSpec.$,
        this.renameFile.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getFileInfo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        network.mojom.HttpCacheBackendFileOperations_GetFileInfo_ParamsSpec.$,
        network.mojom.HttpCacheBackendFileOperations_GetFileInfo_ResponseParamsSpec.$,
        this.getFileInfo.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.enumerateFiles =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        network.mojom.HttpCacheBackendFileOperations_EnumerateFiles_ParamsSpec.$,
        null,
        this.enumerateFiles.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.cleanupDirectory =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        network.mojom.HttpCacheBackendFileOperations_CleanupDirectory_ParamsSpec.$,
        network.mojom.HttpCacheBackendFileOperations_CleanupDirectory_ResponseParamsSpec.$,
        this.cleanupDirectory.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('network.mojom.HttpCacheBackendFileOperationsFactory');
goog.provide('network.mojom.HttpCacheBackendFileOperationsFactoryReceiver');
goog.provide('network.mojom.HttpCacheBackendFileOperationsFactoryCallbackRouter');
goog.provide('network.mojom.HttpCacheBackendFileOperationsFactoryInterface');
goog.provide('network.mojom.HttpCacheBackendFileOperationsFactoryRemote');
goog.provide('network.mojom.HttpCacheBackendFileOperationsFactoryPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
network.mojom.HttpCacheBackendFileOperationsFactoryPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        network.mojom.HttpCacheBackendFileOperationsFactory.$interfaceName,
        scope);
  }
};

/** @interface */
network.mojom.HttpCacheBackendFileOperationsFactoryInterface = class {
  
  /**
   * @param { !network.mojom.HttpCacheBackendFileOperationsPendingReceiver } receiver
   */

  create(receiver) {}
};

/**
 * @export
 * @implements { network.mojom.HttpCacheBackendFileOperationsFactoryInterface }
 */
network.mojom.HttpCacheBackendFileOperationsFactoryRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!network.mojom.HttpCacheBackendFileOperationsFactoryPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          network.mojom.HttpCacheBackendFileOperationsFactoryPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!network.mojom.HttpCacheBackendFileOperationsFactoryPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !network.mojom.HttpCacheBackendFileOperationsPendingReceiver } receiver
   */

  create(
      receiver) {
    this.proxy.sendMessage(
        0,
        network.mojom.HttpCacheBackendFileOperationsFactory_Create_ParamsSpec.$,
        null,
        [
          receiver
        ],
        false);
  }
};

/**
 * An object which receives request messages for the HttpCacheBackendFileOperationsFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
network.mojom.HttpCacheBackendFileOperationsFactoryReceiver = class {
  /**
   * @param {!network.mojom.HttpCacheBackendFileOperationsFactoryInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!network.mojom.HttpCacheBackendFileOperationsFactoryRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        network.mojom.HttpCacheBackendFileOperationsFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.HttpCacheBackendFileOperationsFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        network.mojom.HttpCacheBackendFileOperationsFactory_Create_ParamsSpec.$,
        null,
        impl.create.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
network.mojom.HttpCacheBackendFileOperationsFactory = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.HttpCacheBackendFileOperationsFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!network.mojom.HttpCacheBackendFileOperationsFactoryRemote}
   * @export
   */
  static getRemote() {
    let remote = new network.mojom.HttpCacheBackendFileOperationsFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the HttpCacheBackendFileOperationsFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
network.mojom.HttpCacheBackendFileOperationsFactoryCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      network.mojom.HttpCacheBackendFileOperationsFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.HttpCacheBackendFileOperationsFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.create =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        network.mojom.HttpCacheBackendFileOperationsFactory_Create_ParamsSpec.$,
        null,
        this.create.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('network.mojom.FileEnumerationEntrySpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.FileEnumerationEntrySpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.FileEnumerator_GetNext_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.FileEnumerator_GetNext_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.FileEnumerator_GetNext_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.FileEnumerator_GetNext_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.HttpCacheBackendFileOperations_CreateDirectory_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.HttpCacheBackendFileOperations_CreateDirectory_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.HttpCacheBackendFileOperations_CreateDirectory_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.HttpCacheBackendFileOperations_CreateDirectory_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.HttpCacheBackendFileOperations_PathExists_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.HttpCacheBackendFileOperations_PathExists_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.HttpCacheBackendFileOperations_PathExists_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.HttpCacheBackendFileOperations_PathExists_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.HttpCacheBackendFileOperations_DirectoryExists_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.HttpCacheBackendFileOperations_DirectoryExists_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.HttpCacheBackendFileOperations_DirectoryExists_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.HttpCacheBackendFileOperations_DirectoryExists_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.HttpCacheBackendFileOperations_OpenFile_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.HttpCacheBackendFileOperations_OpenFile_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.HttpCacheBackendFileOperations_OpenFile_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.HttpCacheBackendFileOperations_OpenFile_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.HttpCacheBackendFileOperations_DeleteFile_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.HttpCacheBackendFileOperations_DeleteFile_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.HttpCacheBackendFileOperations_DeleteFile_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.HttpCacheBackendFileOperations_DeleteFile_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.HttpCacheBackendFileOperations_RenameFile_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.HttpCacheBackendFileOperations_RenameFile_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.HttpCacheBackendFileOperations_RenameFile_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.HttpCacheBackendFileOperations_RenameFile_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.HttpCacheBackendFileOperations_GetFileInfo_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.HttpCacheBackendFileOperations_GetFileInfo_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.HttpCacheBackendFileOperations_GetFileInfo_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.HttpCacheBackendFileOperations_GetFileInfo_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.HttpCacheBackendFileOperations_EnumerateFiles_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.HttpCacheBackendFileOperations_EnumerateFiles_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.HttpCacheBackendFileOperations_CleanupDirectory_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.HttpCacheBackendFileOperations_CleanupDirectory_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.HttpCacheBackendFileOperations_CleanupDirectory_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.HttpCacheBackendFileOperations_CleanupDirectory_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.HttpCacheBackendFileOperationsFactory_Create_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.HttpCacheBackendFileOperationsFactory_Create_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    network.mojom.FileEnumerationEntrySpec.$,
    'FileEnumerationEntry',
    [
      mojo.internal.StructField(
        'path', 0,
        0,
        mojoBase.mojom.FilePathSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'size', 8,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'lastAccessed', 16,
        0,
        mojoBase.mojom.TimeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'lastModified', 24,
        0,
        mojoBase.mojom.TimeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('network.mojom.FileEnumerationEntry');

/** @record */
network.mojom.FileEnumerationEntry = class {
  constructor() {
    /** @export { !mojoBase.mojom.FilePath } */
    this.path;
    /** @export { !bigint } */
    this.size;
    /** @export { !mojoBase.mojom.Time } */
    this.lastAccessed;
    /** @export { !mojoBase.mojom.Time } */
    this.lastModified;
  }
};



mojo.internal.Struct(
    network.mojom.FileEnumerator_GetNext_ParamsSpec.$,
    'FileEnumerator_GetNext_Params',
    [
      mojo.internal.StructField(
        'numEntries', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.FileEnumerator_GetNext_Params');

/** @record */
network.mojom.FileEnumerator_GetNext_Params = class {
  constructor() {
    /** @export { !number } */
    this.numEntries;
  }
};



mojo.internal.Struct(
    network.mojom.FileEnumerator_GetNext_ResponseParamsSpec.$,
    'FileEnumerator_GetNext_ResponseParams',
    [
      mojo.internal.StructField(
        'entries', 0,
        0,
        mojo.internal.Array(network.mojom.FileEnumerationEntrySpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'end', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'error', 8,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('network.mojom.FileEnumerator_GetNext_ResponseParams');

/** @record */
network.mojom.FileEnumerator_GetNext_ResponseParams = class {
  constructor() {
    /** @export { !Array<!network.mojom.FileEnumerationEntry> } */
    this.entries;
    /** @export { !boolean } */
    this.end;
    /** @export { !boolean } */
    this.error;
  }
};



mojo.internal.Struct(
    network.mojom.HttpCacheBackendFileOperations_CreateDirectory_ParamsSpec.$,
    'HttpCacheBackendFileOperations_CreateDirectory_Params',
    [
      mojo.internal.StructField(
        'path', 0,
        0,
        mojoBase.mojom.FilePathSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.HttpCacheBackendFileOperations_CreateDirectory_Params');

/** @record */
network.mojom.HttpCacheBackendFileOperations_CreateDirectory_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.FilePath } */
    this.path;
  }
};



mojo.internal.Struct(
    network.mojom.HttpCacheBackendFileOperations_CreateDirectory_ResponseParamsSpec.$,
    'HttpCacheBackendFileOperations_CreateDirectory_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.HttpCacheBackendFileOperations_CreateDirectory_ResponseParams');

/** @record */
network.mojom.HttpCacheBackendFileOperations_CreateDirectory_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.result;
  }
};



mojo.internal.Struct(
    network.mojom.HttpCacheBackendFileOperations_PathExists_ParamsSpec.$,
    'HttpCacheBackendFileOperations_PathExists_Params',
    [
      mojo.internal.StructField(
        'path', 0,
        0,
        mojoBase.mojom.FilePathSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.HttpCacheBackendFileOperations_PathExists_Params');

/** @record */
network.mojom.HttpCacheBackendFileOperations_PathExists_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.FilePath } */
    this.path;
  }
};



mojo.internal.Struct(
    network.mojom.HttpCacheBackendFileOperations_PathExists_ResponseParamsSpec.$,
    'HttpCacheBackendFileOperations_PathExists_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.HttpCacheBackendFileOperations_PathExists_ResponseParams');

/** @record */
network.mojom.HttpCacheBackendFileOperations_PathExists_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.result;
  }
};



mojo.internal.Struct(
    network.mojom.HttpCacheBackendFileOperations_DirectoryExists_ParamsSpec.$,
    'HttpCacheBackendFileOperations_DirectoryExists_Params',
    [
      mojo.internal.StructField(
        'path', 0,
        0,
        mojoBase.mojom.FilePathSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.HttpCacheBackendFileOperations_DirectoryExists_Params');

/** @record */
network.mojom.HttpCacheBackendFileOperations_DirectoryExists_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.FilePath } */
    this.path;
  }
};



mojo.internal.Struct(
    network.mojom.HttpCacheBackendFileOperations_DirectoryExists_ResponseParamsSpec.$,
    'HttpCacheBackendFileOperations_DirectoryExists_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.HttpCacheBackendFileOperations_DirectoryExists_ResponseParams');

/** @record */
network.mojom.HttpCacheBackendFileOperations_DirectoryExists_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.result;
  }
};



mojo.internal.Struct(
    network.mojom.HttpCacheBackendFileOperations_OpenFile_ParamsSpec.$,
    'HttpCacheBackendFileOperations_OpenFile_Params',
    [
      mojo.internal.StructField(
        'path', 0,
        0,
        mojoBase.mojom.FilePathSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'flags', 8,
        0,
        network.mojom.HttpCacheBackendOpenFileFlagsSpec.$,
        33,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('network.mojom.HttpCacheBackendFileOperations_OpenFile_Params');

/** @record */
network.mojom.HttpCacheBackendFileOperations_OpenFile_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.FilePath } */
    this.path;
    /** @export { !network.mojom.HttpCacheBackendOpenFileFlags } */
    this.flags;
  }
};



mojo.internal.Struct(
    network.mojom.HttpCacheBackendFileOperations_OpenFile_ResponseParamsSpec.$,
    'HttpCacheBackendFileOperations_OpenFile_ResponseParams',
    [
      mojo.internal.StructField(
        'file', 0,
        0,
        mojoBase.mojom.FileSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'error', 8,
        0,
        mojoBase.mojom.FileErrorSpec.$,
        -16,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('network.mojom.HttpCacheBackendFileOperations_OpenFile_ResponseParams');

/** @record */
network.mojom.HttpCacheBackendFileOperations_OpenFile_ResponseParams = class {
  constructor() {
    /** @export { (mojoBase.mojom.File|undefined) } */
    this.file;
    /** @export { !mojoBase.mojom.FileError } */
    this.error;
  }
};



mojo.internal.Struct(
    network.mojom.HttpCacheBackendFileOperations_DeleteFile_ParamsSpec.$,
    'HttpCacheBackendFileOperations_DeleteFile_Params',
    [
      mojo.internal.StructField(
        'path', 0,
        0,
        mojoBase.mojom.FilePathSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'mode', 8,
        0,
        network.mojom.HttpCacheBackendDeleteFileModeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('network.mojom.HttpCacheBackendFileOperations_DeleteFile_Params');

/** @record */
network.mojom.HttpCacheBackendFileOperations_DeleteFile_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.FilePath } */
    this.path;
    /** @export { !network.mojom.HttpCacheBackendDeleteFileMode } */
    this.mode;
  }
};



mojo.internal.Struct(
    network.mojom.HttpCacheBackendFileOperations_DeleteFile_ResponseParamsSpec.$,
    'HttpCacheBackendFileOperations_DeleteFile_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.HttpCacheBackendFileOperations_DeleteFile_ResponseParams');

/** @record */
network.mojom.HttpCacheBackendFileOperations_DeleteFile_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.result;
  }
};



mojo.internal.Struct(
    network.mojom.HttpCacheBackendFileOperations_RenameFile_ParamsSpec.$,
    'HttpCacheBackendFileOperations_RenameFile_Params',
    [
      mojo.internal.StructField(
        'fromPath', 0,
        0,
        mojoBase.mojom.FilePathSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'toPath', 8,
        0,
        mojoBase.mojom.FilePathSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('network.mojom.HttpCacheBackendFileOperations_RenameFile_Params');

/** @record */
network.mojom.HttpCacheBackendFileOperations_RenameFile_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.FilePath } */
    this.fromPath;
    /** @export { !mojoBase.mojom.FilePath } */
    this.toPath;
  }
};



mojo.internal.Struct(
    network.mojom.HttpCacheBackendFileOperations_RenameFile_ResponseParamsSpec.$,
    'HttpCacheBackendFileOperations_RenameFile_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        mojoBase.mojom.FileErrorSpec.$,
        -16,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.HttpCacheBackendFileOperations_RenameFile_ResponseParams');

/** @record */
network.mojom.HttpCacheBackendFileOperations_RenameFile_ResponseParams = class {
  constructor() {
    /** @export { !mojoBase.mojom.FileError } */
    this.error;
  }
};



mojo.internal.Struct(
    network.mojom.HttpCacheBackendFileOperations_GetFileInfo_ParamsSpec.$,
    'HttpCacheBackendFileOperations_GetFileInfo_Params',
    [
      mojo.internal.StructField(
        'path', 0,
        0,
        mojoBase.mojom.FilePathSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.HttpCacheBackendFileOperations_GetFileInfo_Params');

/** @record */
network.mojom.HttpCacheBackendFileOperations_GetFileInfo_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.FilePath } */
    this.path;
  }
};



mojo.internal.Struct(
    network.mojom.HttpCacheBackendFileOperations_GetFileInfo_ResponseParamsSpec.$,
    'HttpCacheBackendFileOperations_GetFileInfo_ResponseParams',
    [
      mojo.internal.StructField(
        'info', 0,
        0,
        mojoBase.mojom.FileInfoSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.HttpCacheBackendFileOperations_GetFileInfo_ResponseParams');

/** @record */
network.mojom.HttpCacheBackendFileOperations_GetFileInfo_ResponseParams = class {
  constructor() {
    /** @export { (mojoBase.mojom.FileInfo|undefined) } */
    this.info;
  }
};



mojo.internal.Struct(
    network.mojom.HttpCacheBackendFileOperations_EnumerateFiles_ParamsSpec.$,
    'HttpCacheBackendFileOperations_EnumerateFiles_Params',
    [
      mojo.internal.StructField(
        'path', 0,
        0,
        mojoBase.mojom.FilePathSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'receiver', 8,
        0,
        mojo.internal.InterfaceRequest(network.mojom.FileEnumeratorPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('network.mojom.HttpCacheBackendFileOperations_EnumerateFiles_Params');

/** @record */
network.mojom.HttpCacheBackendFileOperations_EnumerateFiles_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.FilePath } */
    this.path;
    /** @export { !network.mojom.FileEnumeratorPendingReceiver } */
    this.receiver;
  }
};



mojo.internal.Struct(
    network.mojom.HttpCacheBackendFileOperations_CleanupDirectory_ParamsSpec.$,
    'HttpCacheBackendFileOperations_CleanupDirectory_Params',
    [
      mojo.internal.StructField(
        'path', 0,
        0,
        mojoBase.mojom.FilePathSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.HttpCacheBackendFileOperations_CleanupDirectory_Params');

/** @record */
network.mojom.HttpCacheBackendFileOperations_CleanupDirectory_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.FilePath } */
    this.path;
  }
};



mojo.internal.Struct(
    network.mojom.HttpCacheBackendFileOperations_CleanupDirectory_ResponseParamsSpec.$,
    'HttpCacheBackendFileOperations_CleanupDirectory_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.HttpCacheBackendFileOperations_CleanupDirectory_ResponseParams');

/** @record */
network.mojom.HttpCacheBackendFileOperations_CleanupDirectory_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.result;
  }
};



mojo.internal.Struct(
    network.mojom.HttpCacheBackendFileOperationsFactory_Create_ParamsSpec.$,
    'HttpCacheBackendFileOperationsFactory_Create_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(network.mojom.HttpCacheBackendFileOperationsPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.HttpCacheBackendFileOperationsFactory_Create_Params');

/** @record */
network.mojom.HttpCacheBackendFileOperationsFactory_Create_Params = class {
  constructor() {
    /** @export { !network.mojom.HttpCacheBackendFileOperationsPendingReceiver } */
    this.receiver;
  }
};

