// services/network/public/mojom/integrity_policy.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/network/public/mojom/integrity_policy.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('network.mojom');



  function IntegrityPolicy(values) {
    this.initDefaults_();
    this.initFields_(values);
  }

  IntegrityPolicy.Destination = {};
  IntegrityPolicy.Destination.kScript = 0;
  IntegrityPolicy.Destination.MIN_VALUE = 0;
  IntegrityPolicy.Destination.MAX_VALUE = 0;

  IntegrityPolicy.Destination.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
      return true;
    }
    return false;
  };

  IntegrityPolicy.Destination.toKnownEnumValue = function(value) {
    return value;
  };

  IntegrityPolicy.Destination.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  IntegrityPolicy.Source = {};
  IntegrityPolicy.Source.kInline = 0;
  IntegrityPolicy.Source.MIN_VALUE = 0;
  IntegrityPolicy.Source.MAX_VALUE = 0;

  IntegrityPolicy.Source.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
      return true;
    }
    return false;
  };

  IntegrityPolicy.Source.toKnownEnumValue = function(value) {
    return value;
  };

  IntegrityPolicy.Source.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  IntegrityPolicy.prototype.initDefaults_ = function() {
    this.blockedDestinations = null;
    this.sources = null;
    this.endpoints = null;
    this.parsingErrors = null;
  };
  IntegrityPolicy.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  IntegrityPolicy.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate IntegrityPolicy.blockedDestinations
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 4, new codec.Enum(IntegrityPolicy.Destination), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate IntegrityPolicy.sources
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 4, new codec.Enum(IntegrityPolicy.Source), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate IntegrityPolicy.endpoints
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 8, codec.String, false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate IntegrityPolicy.parsingErrors
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 24, 8, codec.String, false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  IntegrityPolicy.encodedSize = codec.kStructHeaderSize + 32;

  IntegrityPolicy.decode = function(decoder) {
    var packed;
    var val = new IntegrityPolicy();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.blockedDestinations =
        decoder.decodeArrayPointer(new codec.Enum(IntegrityPolicy.Destination));
    val.sources =
        decoder.decodeArrayPointer(new codec.Enum(IntegrityPolicy.Source));
    val.endpoints =
        decoder.decodeArrayPointer(codec.String);
    val.parsingErrors =
        decoder.decodeArrayPointer(codec.String);
    return val;
  };

  IntegrityPolicy.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(IntegrityPolicy.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.Enum(IntegrityPolicy.Destination), val.blockedDestinations);
    encoder.encodeArrayPointer(new codec.Enum(IntegrityPolicy.Source), val.sources);
    encoder.encodeArrayPointer(codec.String, val.endpoints);
    encoder.encodeArrayPointer(codec.String, val.parsingErrors);
  };
  exports.IntegrityPolicy = IntegrityPolicy;
})();