// services/network/public/mojom/network_change_manager.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const ConnectionTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const ConnectionType = {
  
  CONNECTION_UNKNOWN: 0,
  CONNECTION_ETHERNET: 1,
  CONNECTION_WIFI: 2,
  CONNECTION_2G: 3,
  CONNECTION_3G: 4,
  CONNECTION_4G: 5,
  CONNECTION_NONE: 6,
  CONNECTION_BLUETOOTH: 7,
  CONNECTION_5G: 8,
  CONNECTION_LAST: 8,
  MIN_VALUE: 0,
  MAX_VALUE: 8,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const ConnectionSubtypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const ConnectionSubtype = {
  
  SUBTYPE_UNKNOWN: 0,
  SUBTYPE_NONE: 1,
  SUBTYPE_OTHER: 2,
  SUBTYPE_GSM: 3,
  SUBTYPE_IDEN: 4,
  SUBTYPE_CDMA: 5,
  SUBTYPE_1XRTT: 6,
  SUBTYPE_GPRS: 7,
  SUBTYPE_EDGE: 8,
  SUBTYPE_UMTS: 9,
  SUBTYPE_EVDO_REV_0: 10,
  SUBTYPE_EVDO_REV_A: 11,
  SUBTYPE_HSPA: 12,
  SUBTYPE_EVDO_REV_B: 13,
  SUBTYPE_HSDPA: 14,
  SUBTYPE_HSUPA: 15,
  SUBTYPE_EHRPD: 16,
  SUBTYPE_HSPAP: 17,
  SUBTYPE_LTE: 18,
  SUBTYPE_LTE_ADVANCED: 19,
  SUBTYPE_BLUETOOTH_1_2: 20,
  SUBTYPE_BLUETOOTH_2_1: 21,
  SUBTYPE_BLUETOOTH_3_0: 22,
  SUBTYPE_BLUETOOTH_4_0: 23,
  SUBTYPE_ETHERNET: 24,
  SUBTYPE_FAST_ETHERNET: 25,
  SUBTYPE_GIGABIT_ETHERNET: 26,
  SUBTYPE_10_GIGABIT_ETHERNET: 27,
  SUBTYPE_WIFI_B: 28,
  SUBTYPE_WIFI_G: 29,
  SUBTYPE_WIFI_N: 30,
  SUBTYPE_WIFI_AC: 31,
  SUBTYPE_WIFI_AD: 32,
  SUBTYPE_LAST: 32,
  MIN_VALUE: 0,
  MAX_VALUE: 32,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const IPAddressChangeTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const IPAddressChangeType = {
  
  IP_ADDRESS_CHANGE_NONE: 0,
  IP_ADDRESS_CHANGE_NORMAL: 1,
  IP_ADDRESS_CHANGE_IPV6_TEMPADDR: 2,
  IP_ADDRESS_CHANGE_LAST: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class NetworkChangeManagerClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.NetworkChangeManagerClient', scope);
  }
}

/** @interface */
export class NetworkChangeManagerClientInterface {
  
  /**
   * @param { !ConnectionType } type
   */

  onInitialConnectionType(type) {}
  
  /**
   * @param { !ConnectionType } type
   */

  onNetworkChanged(type) {}
}

/**
 * @implements { NetworkChangeManagerClientInterface }
 */
export class NetworkChangeManagerClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!NetworkChangeManagerClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          NetworkChangeManagerClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!NetworkChangeManagerClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !ConnectionType } type
   */

  onInitialConnectionType(
      type) {
    this.proxy.sendMessage(
        0,
        NetworkChangeManagerClient_OnInitialConnectionType_ParamsSpec.$,
        null,
        [
          type
        ],
        false);
  }

  
  /**
   * @param { !ConnectionType } type
   */

  onNetworkChanged(
      type) {
    this.proxy.sendMessage(
        1,
        NetworkChangeManagerClient_OnNetworkChanged_ParamsSpec.$,
        null,
        [
          type
        ],
        false);
  }
}

/**
 * An object which receives request messages for the NetworkChangeManagerClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class NetworkChangeManagerClientReceiver {
  /**
   * @param {!NetworkChangeManagerClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!NetworkChangeManagerClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        NetworkChangeManagerClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!NetworkChangeManagerClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        NetworkChangeManagerClient_OnInitialConnectionType_ParamsSpec.$,
        null,
        impl.onInitialConnectionType.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        NetworkChangeManagerClient_OnNetworkChanged_ParamsSpec.$,
        null,
        impl.onNetworkChanged.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class NetworkChangeManagerClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.NetworkChangeManagerClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!NetworkChangeManagerClientRemote}
   */
  static getRemote() {
    let remote = new NetworkChangeManagerClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the NetworkChangeManagerClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class NetworkChangeManagerClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      NetworkChangeManagerClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!NetworkChangeManagerClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onInitialConnectionType =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        NetworkChangeManagerClient_OnInitialConnectionType_ParamsSpec.$,
        null,
        this.onInitialConnectionType.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onNetworkChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        NetworkChangeManagerClient_OnNetworkChanged_ParamsSpec.$,
        null,
        this.onNetworkChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class NetworkChangeManagerPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.NetworkChangeManager', scope);
  }
}

/** @interface */
export class NetworkChangeManagerInterface {
  
  /**
   * @param { !NetworkChangeManagerClientRemote } clientRemote
   */

  requestNotifications(clientRemote) {}
  
  /**
   * @param { !boolean } dnsChanged
   * @param { !IPAddressChangeType } ipAddressChangeType
   * @param { !boolean } connectionTypeChanged
   * @param { !ConnectionType } newConnectionType
   * @param { !boolean } connectionSubtypeChanged
   * @param { !ConnectionSubtype } newConnectionSubtype
   */

  onNetworkChanged(dnsChanged, ipAddressChangeType, connectionTypeChanged, newConnectionType, connectionSubtypeChanged, newConnectionSubtype) {}
}

/**
 * @implements { NetworkChangeManagerInterface }
 */
export class NetworkChangeManagerRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!NetworkChangeManagerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          NetworkChangeManagerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!NetworkChangeManagerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !NetworkChangeManagerClientRemote } clientRemote
   */

  requestNotifications(
      clientRemote) {
    this.proxy.sendMessage(
        0,
        NetworkChangeManager_RequestNotifications_ParamsSpec.$,
        null,
        [
          clientRemote
        ],
        false);
  }

  
  /**
   * @param { !boolean } dnsChanged
   * @param { !IPAddressChangeType } ipAddressChangeType
   * @param { !boolean } connectionTypeChanged
   * @param { !ConnectionType } newConnectionType
   * @param { !boolean } connectionSubtypeChanged
   * @param { !ConnectionSubtype } newConnectionSubtype
   */

  onNetworkChanged(
      dnsChanged,
      ipAddressChangeType,
      connectionTypeChanged,
      newConnectionType,
      connectionSubtypeChanged,
      newConnectionSubtype) {
    this.proxy.sendMessage(
        1,
        NetworkChangeManager_OnNetworkChanged_ParamsSpec.$,
        null,
        [
          dnsChanged,
          ipAddressChangeType,
          connectionTypeChanged,
          newConnectionType,
          connectionSubtypeChanged,
          newConnectionSubtype
        ],
        false);
  }
}

/**
 * An object which receives request messages for the NetworkChangeManager
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class NetworkChangeManagerReceiver {
  /**
   * @param {!NetworkChangeManagerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!NetworkChangeManagerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        NetworkChangeManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!NetworkChangeManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        NetworkChangeManager_RequestNotifications_ParamsSpec.$,
        null,
        impl.requestNotifications.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        NetworkChangeManager_OnNetworkChanged_ParamsSpec.$,
        null,
        impl.onNetworkChanged.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class NetworkChangeManager {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.NetworkChangeManager";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!NetworkChangeManagerRemote}
   */
  static getRemote() {
    let remote = new NetworkChangeManagerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the NetworkChangeManager
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class NetworkChangeManagerCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      NetworkChangeManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!NetworkChangeManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestNotifications =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        NetworkChangeManager_RequestNotifications_ParamsSpec.$,
        null,
        this.requestNotifications.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onNetworkChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        NetworkChangeManager_OnNetworkChanged_ParamsSpec.$,
        null,
        this.onNetworkChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkChangeManagerClient_OnInitialConnectionType_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkChangeManagerClient_OnNetworkChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkChangeManager_RequestNotifications_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkChangeManager_OnNetworkChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    NetworkChangeManagerClient_OnInitialConnectionType_ParamsSpec.$,
    'NetworkChangeManagerClient_OnInitialConnectionType_Params',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        ConnectionTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkChangeManagerClient_OnInitialConnectionType_Params {
  constructor() {
    /** @type { !ConnectionType } */
    this.type;
  }
}



mojo.internal.Struct(
    NetworkChangeManagerClient_OnNetworkChanged_ParamsSpec.$,
    'NetworkChangeManagerClient_OnNetworkChanged_Params',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        ConnectionTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkChangeManagerClient_OnNetworkChanged_Params {
  constructor() {
    /** @type { !ConnectionType } */
    this.type;
  }
}



mojo.internal.Struct(
    NetworkChangeManager_RequestNotifications_ParamsSpec.$,
    'NetworkChangeManager_RequestNotifications_Params',
    [
      mojo.internal.StructField(
        'clientRemote', 0,
        0,
        mojo.internal.InterfaceProxy(NetworkChangeManagerClientRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkChangeManager_RequestNotifications_Params {
  constructor() {
    /** @type { !NetworkChangeManagerClientRemote } */
    this.clientRemote;
  }
}



mojo.internal.Struct(
    NetworkChangeManager_OnNetworkChanged_ParamsSpec.$,
    'NetworkChangeManager_OnNetworkChanged_Params',
    [
      mojo.internal.StructField(
        'dnsChanged', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'ipAddressChangeType', 4,
        0,
        IPAddressChangeTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'connectionTypeChanged', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'newConnectionType', 8,
        0,
        ConnectionTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'connectionSubtypeChanged', 0,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'newConnectionSubtype', 12,
        0,
        ConnectionSubtypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class NetworkChangeManager_OnNetworkChanged_Params {
  constructor() {
    /** @type { !boolean } */
    this.dnsChanged;
    /** @type { !IPAddressChangeType } */
    this.ipAddressChangeType;
    /** @type { !boolean } */
    this.connectionTypeChanged;
    /** @type { !ConnectionType } */
    this.newConnectionType;
    /** @type { !boolean } */
    this.connectionSubtypeChanged;
    /** @type { !ConnectionSubtype } */
    this.newConnectionSubtype;
  }
}

