// services/network/public/mojom/network_context.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';

import {
  ContentSettingPatternSource as contentSettings_mojom_ContentSettingPatternSource,
  ContentSettingPatternSourceSpec as contentSettings_mojom_ContentSettingPatternSourceSpec
} from '../../../../components/content_settings/core/common/content_settings.mojom.m.js';

import {
  CoreControlRemote as ipProtection_mojom_CoreControlRemote,
  CoreControlPendingReceiver as ipProtection_mojom_CoreControlPendingReceiver,
  CoreHostRemote as ipProtection_mojom_CoreHostRemote,
  CoreHostPendingReceiver as ipProtection_mojom_CoreHostPendingReceiver
} from '../../../../components/ip_protection/mojom/core.mojom.m.js';

import {
  IpProxyStatus as ipProtection_mojom_IpProxyStatus,
  IpProxyStatusSpec as ipProtection_mojom_IpProxyStatusSpec,
  ProxyLayer as ipProtection_mojom_ProxyLayer,
  ProxyLayerSpec as ipProtection_mojom_ProxyLayerSpec,
  BlindSignedAuthToken as ipProtection_mojom_BlindSignedAuthToken,
  BlindSignedAuthTokenSpec as ipProtection_mojom_BlindSignedAuthTokenSpec
} from '../../../../components/ip_protection/mojom/data_types.mojom.m.js';

import {
  BigBuffer as mojoBase_mojom_BigBuffer,
  BigBufferSpec as mojoBase_mojom_BigBufferSpec
} from '../../../../mojo/public/mojom/base/big_buffer.mojom.m.js';

import {
  FilePath as mojoBase_mojom_FilePath,
  FilePathSpec as mojoBase_mojom_FilePathSpec
} from '../../../../mojo/public/mojom/base/file_path.mojom.m.js';

import {
  Time as mojoBase_mojom_Time,
  TimeSpec as mojoBase_mojom_TimeSpec,
  TimeDelta as mojoBase_mojom_TimeDelta,
  TimeDeltaSpec as mojoBase_mojom_TimeDeltaSpec
} from '../../../../mojo/public/mojom/base/time.mojom.m.js';

import {
  UnguessableToken as mojoBase_mojom_UnguessableToken,
  UnguessableTokenSpec as mojoBase_mojom_UnguessableTokenSpec
} from '../../../../mojo/public/mojom/base/unguessable_token.mojom.m.js';

import {
  DictionaryValue as mojoBase_mojom_DictionaryValue,
  DictionaryValueSpec as mojoBase_mojom_DictionaryValueSpec
} from '../../../../mojo/public/mojom/base/values.mojom.m.js';

import {
  Origin as url_mojom_Origin,
  OriginSpec as url_mojom_OriginSpec
} from '../../../../url/mojom/origin.mojom.m.js';

import {
  SchemeHostPort as url_mojom_SchemeHostPort,
  SchemeHostPortSpec as url_mojom_SchemeHostPortSpec
} from '../../../../url/mojom/scheme_host_port.mojom.m.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../../url/mojom/url.mojom.m.js';

import {
  ProxyResolverFactoryRemote as proxyResolver_mojom_ProxyResolverFactoryRemote,
  ProxyResolverFactoryPendingReceiver as proxyResolver_mojom_ProxyResolverFactoryPendingReceiver
} from '../../../proxy_resolver/public/mojom/proxy_resolver.mojom.m.js';

import {
  AddressList as network_mojom_AddressList,
  AddressListSpec as network_mojom_AddressListSpec
} from './address_list.mojom.m.js';

import {
  CertVerifierServiceRemote as certVerifier_mojom_CertVerifierServiceRemote,
  CertVerifierServicePendingReceiver as certVerifier_mojom_CertVerifierServicePendingReceiver,
  CertVerifierServiceClientRemote as certVerifier_mojom_CertVerifierServiceClientRemote,
  CertVerifierServiceClientPendingReceiver as certVerifier_mojom_CertVerifierServiceClientPendingReceiver
} from './cert_verifier_service.mojom.m.js';

import {
  ClearDataFilter as network_mojom_ClearDataFilter,
  ClearDataFilterSpec as network_mojom_ClearDataFilterSpec
} from './clear_data_filter.mojom.m.js';

import {
  ClientSecurityState as network_mojom_ClientSecurityState,
  ClientSecurityStateSpec as network_mojom_ClientSecurityStateSpec
} from './client_security_state.mojom.m.js';

import {
  ConnectionChangeObserverClientRemote as network_mojom_ConnectionChangeObserverClientRemote,
  ConnectionChangeObserverClientPendingReceiver as network_mojom_ConnectionChangeObserverClientPendingReceiver,
  ConnectionKeepAliveConfig as network_mojom_ConnectionKeepAliveConfig,
  ConnectionKeepAliveConfigSpec as network_mojom_ConnectionKeepAliveConfigSpec
} from './connection_change_observer_client.mojom.m.js';

import {
  CookieAccessObserverRemote as network_mojom_CookieAccessObserverRemote,
  CookieAccessObserverPendingReceiver as network_mojom_CookieAccessObserverPendingReceiver
} from './cookie_access_observer.mojom.m.js';

import {
  CookieEncryptionProviderRemote as network_mojom_CookieEncryptionProviderRemote,
  CookieEncryptionProviderPendingReceiver as network_mojom_CookieEncryptionProviderPendingReceiver
} from './cookie_encryption_provider.mojom.m.js';

import {
  CookieManagerRemote as network_mojom_CookieManagerRemote,
  CookieManagerPendingReceiver as network_mojom_CookieManagerPendingReceiver,
  CookieManagerParams as network_mojom_CookieManagerParams,
  CookieManagerParamsSpec as network_mojom_CookieManagerParamsSpec
} from './cookie_manager.mojom.m.js';

import {
  CookieSettingOverrides as network_mojom_CookieSettingOverrides,
  CookieSettingOverridesSpec as network_mojom_CookieSettingOverridesSpec
} from './cookie_setting_overrides.mojom.m.js';

import {
  CorsOriginAccessPatterns as network_mojom_CorsOriginAccessPatterns,
  CorsOriginAccessPatternsSpec as network_mojom_CorsOriginAccessPatternsSpec,
  CorsOriginPattern as network_mojom_CorsOriginPattern,
  CorsOriginPatternSpec as network_mojom_CorsOriginPatternSpec
} from './cors_origin_pattern.mojom.m.js';

import {
  CrossOriginEmbedderPolicyReporterRemote as network_mojom_CrossOriginEmbedderPolicyReporterRemote,
  CrossOriginEmbedderPolicyReporterPendingReceiver as network_mojom_CrossOriginEmbedderPolicyReporterPendingReceiver
} from './cross_origin_embedder_policy.mojom.m.js';

import {
  DefaultCredentials as network_mojom_DefaultCredentials,
  DefaultCredentialsSpec as network_mojom_DefaultCredentialsSpec
} from './default_credentials.mojom.m.js';

import {
  DeviceBoundSessionAccessObserverRemote as network_mojom_DeviceBoundSessionAccessObserverRemote,
  DeviceBoundSessionAccessObserverPendingReceiver as network_mojom_DeviceBoundSessionAccessObserverPendingReceiver,
  DeviceBoundSessionManagerRemote as network_mojom_DeviceBoundSessionManagerRemote,
  DeviceBoundSessionManagerPendingReceiver as network_mojom_DeviceBoundSessionManagerPendingReceiver
} from './device_bound_sessions.mojom.m.js';

import {
  DevToolsObserverRemote as network_mojom_DevToolsObserverRemote,
  DevToolsObserverPendingReceiver as network_mojom_DevToolsObserverPendingReceiver
} from './devtools_observer.mojom.m.js';

import {
  DhcpWpadUrlClientRemote as network_mojom_DhcpWpadUrlClientRemote,
  DhcpWpadUrlClientPendingReceiver as network_mojom_DhcpWpadUrlClientPendingReceiver
} from './dhcp_wpad_url_client.mojom.m.js';

import {
  DocumentIsolationPolicyReporterRemote as network_mojom_DocumentIsolationPolicyReporterRemote,
  DocumentIsolationPolicyReporterPendingReceiver as network_mojom_DocumentIsolationPolicyReporterPendingReceiver
} from './document_isolation_policy.mojom.m.js';

import {
  CredentialsMode as network_mojom_CredentialsMode,
  CredentialsModeSpec as network_mojom_CredentialsModeSpec,
  RequestDestination as network_mojom_RequestDestination,
  RequestDestinationSpec as network_mojom_RequestDestinationSpec
} from './fetch_api.mojom.m.js';

import {
  FirstPartySetsAccessDelegateRemote as network_mojom_FirstPartySetsAccessDelegateRemote,
  FirstPartySetsAccessDelegatePendingReceiver as network_mojom_FirstPartySetsAccessDelegatePendingReceiver,
  FirstPartySetsAccessDelegateParams as network_mojom_FirstPartySetsAccessDelegateParams,
  FirstPartySetsAccessDelegateParamsSpec as network_mojom_FirstPartySetsAccessDelegateParamsSpec
} from './first_party_sets_access_delegate.mojom.m.js';

import {
  SHA256HashValue as network_mojom_SHA256HashValue,
  SHA256HashValueSpec as network_mojom_SHA256HashValueSpec
} from './hash_value.mojom.m.js';

import {
  HostResolverRemote as network_mojom_HostResolverRemote,
  HostResolverPendingReceiver as network_mojom_HostResolverPendingReceiver,
  ResolveHostClientRemote as network_mojom_ResolveHostClientRemote,
  ResolveHostClientPendingReceiver as network_mojom_ResolveHostClientPendingReceiver,
  DnsConfigOverrides as network_mojom_DnsConfigOverrides,
  DnsConfigOverridesSpec as network_mojom_DnsConfigOverridesSpec,
  ResolveHostParameters as network_mojom_ResolveHostParameters,
  ResolveHostParametersSpec as network_mojom_ResolveHostParametersSpec,
  HostResolverHost as network_mojom_HostResolverHost,
  HostResolverHostSpec as network_mojom_HostResolverHostSpec
} from './host_resolver.mojom.m.js';

import {
  HttpCacheBackendFileOperationsFactoryRemote as network_mojom_HttpCacheBackendFileOperationsFactoryRemote,
  HttpCacheBackendFileOperationsFactoryPendingReceiver as network_mojom_HttpCacheBackendFileOperationsFactoryPendingReceiver
} from './http_cache_backend_file_operations.mojom.m.js';

import {
  HttpRequestHeaders as network_mojom_HttpRequestHeaders,
  HttpRequestHeadersSpec as network_mojom_HttpRequestHeadersSpec
} from './http_request_headers.mojom.m.js';

import {
  IPAddress as network_mojom_IPAddress,
  IPAddressSpec as network_mojom_IPAddressSpec
} from './ip_address.mojom.m.js';

import {
  IPEndPoint as network_mojom_IPEndPoint,
  IPEndPointSpec as network_mojom_IPEndPointSpec
} from './ip_endpoint.mojom.m.js';

import {
  IsolationInfo as network_mojom_IsolationInfo,
  IsolationInfoSpec as network_mojom_IsolationInfoSpec
} from './isolation_info.mojom.m.js';

import {
  MdnsResponderRemote as network_mojom_MdnsResponderRemote,
  MdnsResponderPendingReceiver as network_mojom_MdnsResponderPendingReceiver
} from './mdns_responder.mojom.m.js';

import {
  MutableNetworkTrafficAnnotationTag as network_mojom_MutableNetworkTrafficAnnotationTag,
  MutableNetworkTrafficAnnotationTagSpec as network_mojom_MutableNetworkTrafficAnnotationTagSpec
} from './mutable_network_traffic_annotation_tag.mojom.m.js';

import {
  NetLogExporterRemote as network_mojom_NetLogExporterRemote,
  NetLogExporterPendingReceiver as network_mojom_NetLogExporterPendingReceiver
} from './net_log.mojom.m.js';

import {
  NetworkAnonymizationKey as network_mojom_NetworkAnonymizationKey,
  NetworkAnonymizationKeySpec as network_mojom_NetworkAnonymizationKeySpec
} from './network_anonymization_key.mojom.m.js';

import {
  NetworkContextClientRemote as network_mojom_NetworkContextClientRemote,
  NetworkContextClientPendingReceiver as network_mojom_NetworkContextClientPendingReceiver
} from './network_context_client.mojom.m.js';

import {
  NetworkIsolationKey as network_mojom_NetworkIsolationKey,
  NetworkIsolationKeySpec as network_mojom_NetworkIsolationKeySpec
} from './network_isolation_key.mojom.m.js';

import {
  AuthChallengeInfo as network_mojom_AuthChallengeInfo,
  AuthChallengeInfoSpec as network_mojom_AuthChallengeInfoSpec,
  AuthCredentials as network_mojom_AuthCredentials,
  AuthCredentialsSpec as network_mojom_AuthCredentialsSpec,
  CertVerifyResult as network_mojom_CertVerifyResult,
  CertVerifyResultSpec as network_mojom_CertVerifyResultSpec,
  HostPortPair as network_mojom_HostPortPair,
  HostPortPairSpec as network_mojom_HostPortPairSpec,
  HttpResponseHeaders as network_mojom_HttpResponseHeaders,
  HttpResponseHeadersSpec as network_mojom_HttpResponseHeadersSpec,
  ProxyChain as network_mojom_ProxyChain,
  ProxyChainSpec as network_mojom_ProxyChainSpec,
  ProxyServer as network_mojom_ProxyServer,
  ProxyServerSpec as network_mojom_ProxyServerSpec,
  X509Certificate as network_mojom_X509Certificate,
  X509CertificateSpec as network_mojom_X509CertificateSpec
} from './network_param.mojom.m.js';

import {
  ObliviousHttpClientRemote as network_mojom_ObliviousHttpClientRemote,
  ObliviousHttpClientPendingReceiver as network_mojom_ObliviousHttpClientPendingReceiver,
  ObliviousHttpRequest as network_mojom_ObliviousHttpRequest,
  ObliviousHttpRequestSpec as network_mojom_ObliviousHttpRequestSpec
} from './oblivious_http_request.mojom.m.js';

import {
  P2PSocketManagerRemote as network_mojom_P2PSocketManagerRemote,
  P2PSocketManagerPendingReceiver as network_mojom_P2PSocketManagerPendingReceiver
} from './p2p.mojom.m.js';

import {
  P2PTrustedSocketManagerRemote as network_mojom_P2PTrustedSocketManagerRemote,
  P2PTrustedSocketManagerPendingReceiver as network_mojom_P2PTrustedSocketManagerPendingReceiver,
  P2PTrustedSocketManagerClientRemote as network_mojom_P2PTrustedSocketManagerClientRemote,
  P2PTrustedSocketManagerClientPendingReceiver as network_mojom_P2PTrustedSocketManagerClientPendingReceiver
} from './p2p_trusted.mojom.m.js';

import {
  ProxyRules as network_mojom_ProxyRules,
  ProxyRulesSpec as network_mojom_ProxyRulesSpec
} from './proxy_config.mojom.m.js';

import {
  ProxyConfigClientRemote as network_mojom_ProxyConfigClientRemote,
  ProxyConfigClientPendingReceiver as network_mojom_ProxyConfigClientPendingReceiver,
  ProxyConfigPollerClientRemote as network_mojom_ProxyConfigPollerClientRemote,
  ProxyConfigPollerClientPendingReceiver as network_mojom_ProxyConfigPollerClientPendingReceiver,
  ProxyErrorClientRemote as network_mojom_ProxyErrorClientRemote,
  ProxyErrorClientPendingReceiver as network_mojom_ProxyErrorClientPendingReceiver,
  ProxyConfigWithAnnotation as network_mojom_ProxyConfigWithAnnotation,
  ProxyConfigWithAnnotationSpec as network_mojom_ProxyConfigWithAnnotationSpec
} from './proxy_config_with_annotation.mojom.m.js';

import {
  ProxyLookupClientRemote as network_mojom_ProxyLookupClientRemote,
  ProxyLookupClientPendingReceiver as network_mojom_ProxyLookupClientPendingReceiver
} from './proxy_lookup_client.mojom.m.js';

import {
  ProxyResolvingSocketFactoryRemote as network_mojom_ProxyResolvingSocketFactoryRemote,
  ProxyResolvingSocketFactoryPendingReceiver as network_mojom_ProxyResolvingSocketFactoryPendingReceiver
} from './proxy_resolving_socket.mojom.m.js';

import {
  ReportingApiObserverRemote as network_mojom_ReportingApiObserverRemote,
  ReportingApiObserverPendingReceiver as network_mojom_ReportingApiObserverPendingReceiver
} from './reporting_service.mojom.m.js';

import {
  RestrictedCookieManagerRole as network_mojom_RestrictedCookieManagerRole,
  RestrictedCookieManagerRoleSpec as network_mojom_RestrictedCookieManagerRoleSpec,
  RestrictedCookieManagerRemote as network_mojom_RestrictedCookieManagerRemote,
  RestrictedCookieManagerPendingReceiver as network_mojom_RestrictedCookieManagerPendingReceiver
} from './restricted_cookie_manager.mojom.m.js';

import {
  RestrictedUDPSocketMode as network_mojom_RestrictedUDPSocketMode,
  RestrictedUDPSocketModeSpec as network_mojom_RestrictedUDPSocketModeSpec,
  RestrictedUDPSocketRemote as network_mojom_RestrictedUDPSocketRemote,
  RestrictedUDPSocketPendingReceiver as network_mojom_RestrictedUDPSocketPendingReceiver,
  RestrictedUDPSocketParams as network_mojom_RestrictedUDPSocketParams,
  RestrictedUDPSocketParamsSpec as network_mojom_RestrictedUDPSocketParamsSpec
} from './restricted_udp_socket.mojom.m.js';

import {
  SharedDictionaryAccessObserverRemote as network_mojom_SharedDictionaryAccessObserverRemote,
  SharedDictionaryAccessObserverPendingReceiver as network_mojom_SharedDictionaryAccessObserverPendingReceiver
} from './shared_dictionary_access_observer.mojom.m.js';

import {
  SharedDictionaryIsolationKey as network_mojom_SharedDictionaryIsolationKey,
  SharedDictionaryIsolationKeySpec as network_mojom_SharedDictionaryIsolationKeySpec
} from './shared_dictionary_isolation_key.mojom.m.js';

import {
  SharedDictionaryUsageInfo as network_mojom_SharedDictionaryUsageInfo,
  SharedDictionaryUsageInfoSpec as network_mojom_SharedDictionaryUsageInfoSpec
} from './shared_dictionary_usage_info.mojom.m.js';

import {
  SiteForCookies as network_mojom_SiteForCookies,
  SiteForCookiesSpec as network_mojom_SiteForCookiesSpec
} from './site_for_cookies.mojom.m.js';

import {
  SSLConfigClientRemote as network_mojom_SSLConfigClientRemote,
  SSLConfigClientPendingReceiver as network_mojom_SSLConfigClientPendingReceiver,
  SSLConfig as network_mojom_SSLConfig,
  SSLConfigSpec as network_mojom_SSLConfigSpec
} from './ssl_config.mojom.m.js';

import {
  StorageAccessApiStatus as network_mojom_StorageAccessApiStatus,
  StorageAccessApiStatusSpec as network_mojom_StorageAccessApiStatusSpec
} from './storage_access_api.mojom.m.js';

import {
  SocketObserverRemote as network_mojom_SocketObserverRemote,
  SocketObserverPendingReceiver as network_mojom_SocketObserverPendingReceiver,
  TCPBoundSocketRemote as network_mojom_TCPBoundSocketRemote,
  TCPBoundSocketPendingReceiver as network_mojom_TCPBoundSocketPendingReceiver,
  TCPConnectedSocketRemote as network_mojom_TCPConnectedSocketRemote,
  TCPConnectedSocketPendingReceiver as network_mojom_TCPConnectedSocketPendingReceiver,
  TCPServerSocketRemote as network_mojom_TCPServerSocketRemote,
  TCPServerSocketPendingReceiver as network_mojom_TCPServerSocketPendingReceiver,
  TCPConnectedSocketOptions as network_mojom_TCPConnectedSocketOptions,
  TCPConnectedSocketOptionsSpec as network_mojom_TCPConnectedSocketOptionsSpec,
  TCPServerSocketOptions as network_mojom_TCPServerSocketOptions,
  TCPServerSocketOptionsSpec as network_mojom_TCPServerSocketOptionsSpec
} from './tcp_socket.mojom.m.js';

import {
  TransferableDirectory as network_mojom_TransferableDirectory,
  TransferableDirectorySpec as network_mojom_TransferableDirectorySpec
} from './transferable_directory.mojom.m.js';

import {
  TrustTokenAccessObserverRemote as network_mojom_TrustTokenAccessObserverRemote,
  TrustTokenAccessObserverPendingReceiver as network_mojom_TrustTokenAccessObserverPendingReceiver
} from './trust_token_access_observer.mojom.m.js';

import {
  DeleteStoredTrustTokensStatus as network_mojom_DeleteStoredTrustTokensStatus,
  DeleteStoredTrustTokensStatusSpec as network_mojom_DeleteStoredTrustTokensStatusSpec,
  TrustTokenQueryAnswererRemote as network_mojom_TrustTokenQueryAnswererRemote,
  TrustTokenQueryAnswererPendingReceiver as network_mojom_TrustTokenQueryAnswererPendingReceiver,
  StoredTrustTokensForIssuer as network_mojom_StoredTrustTokensForIssuer,
  StoredTrustTokensForIssuerSpec as network_mojom_StoredTrustTokensForIssuerSpec,
  ToplevelRedemptionRecord as network_mojom_ToplevelRedemptionRecord,
  ToplevelRedemptionRecordSpec as network_mojom_ToplevelRedemptionRecordSpec
} from './trust_tokens.mojom.m.js';

import {
  UDPSocketRemote as network_mojom_UDPSocketRemote,
  UDPSocketPendingReceiver as network_mojom_UDPSocketPendingReceiver,
  UDPSocketListenerRemote as network_mojom_UDPSocketListenerRemote,
  UDPSocketListenerPendingReceiver as network_mojom_UDPSocketListenerPendingReceiver
} from './udp_socket.mojom.m.js';

import {
  URLLoaderFactoryRemote as network_mojom_URLLoaderFactoryRemote,
  URLLoaderFactoryPendingReceiver as network_mojom_URLLoaderFactoryPendingReceiver
} from './url_loader_factory.mojom.m.js';

import {
  URLLoaderNetworkServiceObserverRemote as network_mojom_URLLoaderNetworkServiceObserverRemote,
  URLLoaderNetworkServiceObserverPendingReceiver as network_mojom_URLLoaderNetworkServiceObserverPendingReceiver
} from './url_loader_network_service_observer.mojom.m.js';

import {
  URLRequest as network_mojom_URLRequest,
  URLRequestSpec as network_mojom_URLRequestSpec
} from './url_request.mojom.m.js';

import {
  WebTransportHandshakeClientRemote as network_mojom_WebTransportHandshakeClientRemote,
  WebTransportHandshakeClientPendingReceiver as network_mojom_WebTransportHandshakeClientPendingReceiver,
  WebTransportCertificateFingerprint as network_mojom_WebTransportCertificateFingerprint,
  WebTransportCertificateFingerprintSpec as network_mojom_WebTransportCertificateFingerprintSpec
} from './web_transport.mojom.m.js';

import {
  WebSocketAuthenticationHandlerRemote as network_mojom_WebSocketAuthenticationHandlerRemote,
  WebSocketAuthenticationHandlerPendingReceiver as network_mojom_WebSocketAuthenticationHandlerPendingReceiver,
  WebSocketHandshakeClientRemote as network_mojom_WebSocketHandshakeClientRemote,
  WebSocketHandshakeClientPendingReceiver as network_mojom_WebSocketHandshakeClientPendingReceiver,
  HttpHeader as network_mojom_HttpHeader,
  HttpHeaderSpec as network_mojom_HttpHeaderSpec
} from './websocket.mojom.m.js';


/**
 * @const { !number }
 */
export const WEB_SOCKET_OPTION_NONE = 0;


/**
 * @const { !number }
 */
export const WEB_SOCKET_OPTION_BLOCK_ALL_COOKIES = 1;


/**
 * @const { !number }
 */
export const WEB_SOCKET_OPTION_BLOCK_THIRD_PARTY_COOKIES = 2;


/**
 * @const { !number }
 */
export const BROWSER_PROCESS_ID = 0;


/**
 * @const { !number }
 */
export const INVALID_PROCESS_ID = -1;


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const TrustTokenOperationPolicyVerdictSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const TrustTokenOperationPolicyVerdict = {
  
  kForbid: 0,
  kPotentiallyPermit: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const SCTAuditingModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const SCTAuditingMode = {
  
  kDisabled: 0,
  kEnhancedSafeBrowsingReporting: 1,
  kHashdance: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class CustomProxyConnectionObserverPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.CustomProxyConnectionObserver', scope);
  }
}

/** @interface */
export class CustomProxyConnectionObserverInterface {
  
  /**
   * @param { !network_mojom_ProxyChain } badChain
   * @param { !number } netError
   */

  onFallback(badChain, netError) {}
  
  /**
   * @param { !network_mojom_ProxyChain } proxyChain
   * @param { !bigint } chainIndex
   * @param { !network_mojom_HttpResponseHeaders } responseHeaders
   */

  onTunnelHeadersReceived(proxyChain, chainIndex, responseHeaders) {}
}

/**
 * @implements { CustomProxyConnectionObserverInterface }
 */
export class CustomProxyConnectionObserverRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!CustomProxyConnectionObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          CustomProxyConnectionObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!CustomProxyConnectionObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !network_mojom_ProxyChain } badChain
   * @param { !number } netError
   */

  onFallback(
      badChain,
      netError) {
    this.proxy.sendMessage(
        0,
        CustomProxyConnectionObserver_OnFallback_ParamsSpec.$,
        null,
        [
          badChain,
          netError
        ],
        false);
  }

  
  /**
   * @param { !network_mojom_ProxyChain } proxyChain
   * @param { !bigint } chainIndex
   * @param { !network_mojom_HttpResponseHeaders } responseHeaders
   */

  onTunnelHeadersReceived(
      proxyChain,
      chainIndex,
      responseHeaders) {
    this.proxy.sendMessage(
        1,
        CustomProxyConnectionObserver_OnTunnelHeadersReceived_ParamsSpec.$,
        null,
        [
          proxyChain,
          chainIndex,
          responseHeaders
        ],
        false);
  }
}

/**
 * An object which receives request messages for the CustomProxyConnectionObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class CustomProxyConnectionObserverReceiver {
  /**
   * @param {!CustomProxyConnectionObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!CustomProxyConnectionObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        CustomProxyConnectionObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!CustomProxyConnectionObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        CustomProxyConnectionObserver_OnFallback_ParamsSpec.$,
        null,
        impl.onFallback.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        CustomProxyConnectionObserver_OnTunnelHeadersReceived_ParamsSpec.$,
        null,
        impl.onTunnelHeadersReceived.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class CustomProxyConnectionObserver {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.CustomProxyConnectionObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!CustomProxyConnectionObserverRemote}
   */
  static getRemote() {
    let remote = new CustomProxyConnectionObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the CustomProxyConnectionObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class CustomProxyConnectionObserverCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      CustomProxyConnectionObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!CustomProxyConnectionObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onFallback =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        CustomProxyConnectionObserver_OnFallback_ParamsSpec.$,
        null,
        this.onFallback.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onTunnelHeadersReceived =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        CustomProxyConnectionObserver_OnTunnelHeadersReceived_ParamsSpec.$,
        null,
        this.onTunnelHeadersReceived.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class CustomProxyConfigClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.CustomProxyConfigClient', scope);
  }
}

/** @interface */
export class CustomProxyConfigClientInterface {
  
  /**
   * @param { !CustomProxyConfig } proxyConfig
   * @return {!Promise}
   */

  onCustomProxyConfigUpdated(proxyConfig) {}
}

/**
 * @implements { CustomProxyConfigClientInterface }
 */
export class CustomProxyConfigClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!CustomProxyConfigClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          CustomProxyConfigClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!CustomProxyConfigClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !CustomProxyConfig } proxyConfig
   * @return {!Promise}
   */

  onCustomProxyConfigUpdated(
      proxyConfig) {
    return this.proxy.sendMessage(
        0,
        CustomProxyConfigClient_OnCustomProxyConfigUpdated_ParamsSpec.$,
        CustomProxyConfigClient_OnCustomProxyConfigUpdated_ResponseParamsSpec.$,
        [
          proxyConfig
        ],
        false);
  }
}

/**
 * An object which receives request messages for the CustomProxyConfigClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class CustomProxyConfigClientReceiver {
  /**
   * @param {!CustomProxyConfigClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!CustomProxyConfigClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        CustomProxyConfigClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!CustomProxyConfigClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        CustomProxyConfigClient_OnCustomProxyConfigUpdated_ParamsSpec.$,
        CustomProxyConfigClient_OnCustomProxyConfigUpdated_ResponseParamsSpec.$,
        impl.onCustomProxyConfigUpdated.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class CustomProxyConfigClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.CustomProxyConfigClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!CustomProxyConfigClientRemote}
   */
  static getRemote() {
    let remote = new CustomProxyConfigClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the CustomProxyConfigClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class CustomProxyConfigClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      CustomProxyConfigClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!CustomProxyConfigClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onCustomProxyConfigUpdated =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        CustomProxyConfigClient_OnCustomProxyConfigUpdated_ParamsSpec.$,
        CustomProxyConfigClient_OnCustomProxyConfigUpdated_ResponseParamsSpec.$,
        this.onCustomProxyConfigUpdated.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class TrustedHeaderClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.TrustedHeaderClient', scope);
  }
}

/** @interface */
export class TrustedHeaderClientInterface {
  
  /**
   * @param { !network_mojom_HttpRequestHeaders } headers
   * @return {!Promise<{
        result: !number,
        headers: ?network_mojom_HttpRequestHeaders,
   *  }>}
   */

  onBeforeSendHeaders(headers) {}
  
  /**
   * @param { !string } headers
   * @param { !network_mojom_IPEndPoint } remoteEndpoint
   * @return {!Promise<{
        result: !number,
        headers: ?string,
        preserveFragmentOnRedirectUrl: ?url_mojom_Url,
   *  }>}
   */

  onHeadersReceived(headers, remoteEndpoint) {}
}

/**
 * @implements { TrustedHeaderClientInterface }
 */
export class TrustedHeaderClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!TrustedHeaderClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          TrustedHeaderClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!TrustedHeaderClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !network_mojom_HttpRequestHeaders } headers
   * @return {!Promise<{
        result: !number,
        headers: ?network_mojom_HttpRequestHeaders,
   *  }>}
   */

  onBeforeSendHeaders(
      headers) {
    return this.proxy.sendMessage(
        0,
        TrustedHeaderClient_OnBeforeSendHeaders_ParamsSpec.$,
        TrustedHeaderClient_OnBeforeSendHeaders_ResponseParamsSpec.$,
        [
          headers
        ],
        false);
  }

  
  /**
   * @param { !string } headers
   * @param { !network_mojom_IPEndPoint } remoteEndpoint
   * @return {!Promise<{
        result: !number,
        headers: ?string,
        preserveFragmentOnRedirectUrl: ?url_mojom_Url,
   *  }>}
   */

  onHeadersReceived(
      headers,
      remoteEndpoint) {
    return this.proxy.sendMessage(
        1,
        TrustedHeaderClient_OnHeadersReceived_ParamsSpec.$,
        TrustedHeaderClient_OnHeadersReceived_ResponseParamsSpec.$,
        [
          headers,
          remoteEndpoint
        ],
        false);
  }
}

/**
 * An object which receives request messages for the TrustedHeaderClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class TrustedHeaderClientReceiver {
  /**
   * @param {!TrustedHeaderClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!TrustedHeaderClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        TrustedHeaderClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!TrustedHeaderClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        TrustedHeaderClient_OnBeforeSendHeaders_ParamsSpec.$,
        TrustedHeaderClient_OnBeforeSendHeaders_ResponseParamsSpec.$,
        impl.onBeforeSendHeaders.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        TrustedHeaderClient_OnHeadersReceived_ParamsSpec.$,
        TrustedHeaderClient_OnHeadersReceived_ResponseParamsSpec.$,
        impl.onHeadersReceived.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class TrustedHeaderClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.TrustedHeaderClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!TrustedHeaderClientRemote}
   */
  static getRemote() {
    let remote = new TrustedHeaderClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the TrustedHeaderClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class TrustedHeaderClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      TrustedHeaderClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!TrustedHeaderClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onBeforeSendHeaders =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        TrustedHeaderClient_OnBeforeSendHeaders_ParamsSpec.$,
        TrustedHeaderClient_OnBeforeSendHeaders_ResponseParamsSpec.$,
        this.onBeforeSendHeaders.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onHeadersReceived =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        TrustedHeaderClient_OnHeadersReceived_ParamsSpec.$,
        TrustedHeaderClient_OnHeadersReceived_ResponseParamsSpec.$,
        this.onHeadersReceived.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class TrustedURLLoaderHeaderClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.TrustedURLLoaderHeaderClient', scope);
  }
}

/** @interface */
export class TrustedURLLoaderHeaderClientInterface {
  
  /**
   * @param { !number } requestId
   * @param { !TrustedHeaderClientPendingReceiver } headerClient
   */

  onLoaderCreated(requestId, headerClient) {}
  
  /**
   * @param { !network_mojom_URLRequest } request
   * @param { !TrustedHeaderClientPendingReceiver } headerClient
   */

  onLoaderForCorsPreflightCreated(request, headerClient) {}
}

/**
 * @implements { TrustedURLLoaderHeaderClientInterface }
 */
export class TrustedURLLoaderHeaderClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!TrustedURLLoaderHeaderClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          TrustedURLLoaderHeaderClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!TrustedURLLoaderHeaderClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !number } requestId
   * @param { !TrustedHeaderClientPendingReceiver } headerClient
   */

  onLoaderCreated(
      requestId,
      headerClient) {
    this.proxy.sendMessage(
        0,
        TrustedURLLoaderHeaderClient_OnLoaderCreated_ParamsSpec.$,
        null,
        [
          requestId,
          headerClient
        ],
        false);
  }

  
  /**
   * @param { !network_mojom_URLRequest } request
   * @param { !TrustedHeaderClientPendingReceiver } headerClient
   */

  onLoaderForCorsPreflightCreated(
      request,
      headerClient) {
    this.proxy.sendMessage(
        1,
        TrustedURLLoaderHeaderClient_OnLoaderForCorsPreflightCreated_ParamsSpec.$,
        null,
        [
          request,
          headerClient
        ],
        false);
  }
}

/**
 * An object which receives request messages for the TrustedURLLoaderHeaderClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class TrustedURLLoaderHeaderClientReceiver {
  /**
   * @param {!TrustedURLLoaderHeaderClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!TrustedURLLoaderHeaderClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        TrustedURLLoaderHeaderClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!TrustedURLLoaderHeaderClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        TrustedURLLoaderHeaderClient_OnLoaderCreated_ParamsSpec.$,
        null,
        impl.onLoaderCreated.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        TrustedURLLoaderHeaderClient_OnLoaderForCorsPreflightCreated_ParamsSpec.$,
        null,
        impl.onLoaderForCorsPreflightCreated.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class TrustedURLLoaderHeaderClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.TrustedURLLoaderHeaderClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!TrustedURLLoaderHeaderClientRemote}
   */
  static getRemote() {
    let remote = new TrustedURLLoaderHeaderClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the TrustedURLLoaderHeaderClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class TrustedURLLoaderHeaderClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      TrustedURLLoaderHeaderClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!TrustedURLLoaderHeaderClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onLoaderCreated =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        TrustedURLLoaderHeaderClient_OnLoaderCreated_ParamsSpec.$,
        null,
        this.onLoaderCreated.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onLoaderForCorsPreflightCreated =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        TrustedURLLoaderHeaderClient_OnLoaderForCorsPreflightCreated_ParamsSpec.$,
        null,
        this.onLoaderForCorsPreflightCreated.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class PreloadedSharedDictionaryInfoHandlePendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.PreloadedSharedDictionaryInfoHandle', scope);
  }
}

/** @interface */
export class PreloadedSharedDictionaryInfoHandleInterface {
}

/**
 * @implements { PreloadedSharedDictionaryInfoHandleInterface }
 */
export class PreloadedSharedDictionaryInfoHandleRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!PreloadedSharedDictionaryInfoHandlePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PreloadedSharedDictionaryInfoHandlePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!PreloadedSharedDictionaryInfoHandlePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }
}

/**
 * An object which receives request messages for the PreloadedSharedDictionaryInfoHandle
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PreloadedSharedDictionaryInfoHandleReceiver {
  /**
   * @param {!PreloadedSharedDictionaryInfoHandleInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!PreloadedSharedDictionaryInfoHandleRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PreloadedSharedDictionaryInfoHandleRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!PreloadedSharedDictionaryInfoHandleRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PreloadedSharedDictionaryInfoHandle {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.PreloadedSharedDictionaryInfoHandle";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!PreloadedSharedDictionaryInfoHandleRemote}
   */
  static getRemote() {
    let remote = new PreloadedSharedDictionaryInfoHandleRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the PreloadedSharedDictionaryInfoHandle
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PreloadedSharedDictionaryInfoHandleCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PreloadedSharedDictionaryInfoHandleRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!PreloadedSharedDictionaryInfoHandleRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class DurableMessageCollectorPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.DurableMessageCollector', scope);
  }
}

/** @interface */
export class DurableMessageCollectorInterface {
  
  /**
   * @param { !NetworkDurableMessageConfig } config
   */

  configure(config) {}
  
  /**
   * @param { !string } devtoolsRequestId
   * @return {!Promise<{
        message: ?mojoBase_mojom_BigBuffer,
   *  }>}
   */

  retrieve(devtoolsRequestId) {}
}

/**
 * @implements { DurableMessageCollectorInterface }
 */
export class DurableMessageCollectorRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!DurableMessageCollectorPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          DurableMessageCollectorPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!DurableMessageCollectorPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !NetworkDurableMessageConfig } config
   */

  configure(
      config) {
    this.proxy.sendMessage(
        0,
        DurableMessageCollector_Configure_ParamsSpec.$,
        null,
        [
          config
        ],
        false);
  }

  
  /**
   * @param { !string } devtoolsRequestId
   * @return {!Promise<{
        message: ?mojoBase_mojom_BigBuffer,
   *  }>}
   */

  retrieve(
      devtoolsRequestId) {
    return this.proxy.sendMessage(
        1,
        DurableMessageCollector_Retrieve_ParamsSpec.$,
        DurableMessageCollector_Retrieve_ResponseParamsSpec.$,
        [
          devtoolsRequestId
        ],
        false);
  }
}

/**
 * An object which receives request messages for the DurableMessageCollector
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class DurableMessageCollectorReceiver {
  /**
   * @param {!DurableMessageCollectorInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!DurableMessageCollectorRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        DurableMessageCollectorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!DurableMessageCollectorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        DurableMessageCollector_Configure_ParamsSpec.$,
        null,
        impl.configure.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        DurableMessageCollector_Retrieve_ParamsSpec.$,
        DurableMessageCollector_Retrieve_ResponseParamsSpec.$,
        impl.retrieve.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class DurableMessageCollector {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.DurableMessageCollector";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!DurableMessageCollectorRemote}
   */
  static getRemote() {
    let remote = new DurableMessageCollectorRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the DurableMessageCollector
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class DurableMessageCollectorCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      DurableMessageCollectorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!DurableMessageCollectorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.configure =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        DurableMessageCollector_Configure_ParamsSpec.$,
        null,
        this.configure.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.retrieve =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        DurableMessageCollector_Retrieve_ParamsSpec.$,
        DurableMessageCollector_Retrieve_ResponseParamsSpec.$,
        this.retrieve.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class NetworkContextPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.NetworkContext', scope);
  }
}

/** @interface */
export class NetworkContextInterface {
  
  /**
   * @param { !network_mojom_NetworkContextClientRemote } client
   */

  setClient(client) {}
  
  /**
   * @param { !network_mojom_URLLoaderFactoryPendingReceiver } urlLoaderFactory
   * @param { !URLLoaderFactoryParams } params
   */

  createURLLoaderFactory(urlLoaderFactory, params) {}
  
  /**
   */

  resetURLLoaderFactories() {}
  
  /**
   * @param { !network_mojom_ObliviousHttpRequest } request
   * @param { !network_mojom_ObliviousHttpClientRemote } client
   */

  getViaObliviousHttp(request, client) {}
  
  /**
   * @param { !network_mojom_CookieManagerPendingReceiver } cookieManager
   */

  getCookieManager(cookieManager) {}
  
  /**
   * @param { !network_mojom_RestrictedCookieManagerPendingReceiver } restrictedCookieManager
   * @param { !network_mojom_RestrictedCookieManagerRole } role
   * @param { !url_mojom_Origin } origin
   * @param { !network_mojom_IsolationInfo } isolationInfo
   * @param { !network_mojom_CookieSettingOverrides } cookieSettingOverrides
   * @param { !network_mojom_CookieSettingOverrides } devtoolsCookieSettingOverrides
   * @param { ?network_mojom_CookieAccessObserverRemote } cookieObserver
   */

  getRestrictedCookieManager(restrictedCookieManager, role, origin, isolationInfo, cookieSettingOverrides, devtoolsCookieSettingOverrides, cookieObserver) {}
  
  /**
   * @param { !network_mojom_TrustTokenQueryAnswererPendingReceiver } trustTokenQueryAnswerer
   * @param { !url_mojom_Origin } topFrameOrigin
   */

  getTrustTokenQueryAnswerer(trustTokenQueryAnswerer, topFrameOrigin) {}
  
  /**
   * @param { ?network_mojom_ClearDataFilter } filter
   * @return {!Promise}
   */

  clearTrustTokenData(filter) {}
  
  /**
   * @return {!Promise<{
        anyDataDeleted: !boolean,
   *  }>}
   */

  clearTrustTokenSessionOnlyData() {}
  
  /**
   * @return {!Promise<{
        tokens: !Array<!network_mojom_StoredTrustTokensForIssuer>,
   *  }>}
   */

  getStoredTrustTokenCounts() {}
  
  /**
   * @return {!Promise<{
        issuerRedemptionRecordMap: !Map<!url_mojom_Origin, !Array<!network_mojom_ToplevelRedemptionRecord>>,
   *  }>}
   */

  getPrivateStateTokenRedemptionRecords() {}
  
  /**
   * @return {!Promise<{
        status: !ipProtection_mojom_IpProxyStatus,
   *  }>}
   */

  getIpProxyStatus() {}
  
  /**
   * @param { !boolean } bypassProxy
   */

  setBypassIpProtectionProxy(bypassProxy) {}
  
  /**
   * @param { !url_mojom_Origin } issuer
   * @return {!Promise<{
        status: !network_mojom_DeleteStoredTrustTokensStatus,
   *  }>}
   */

  deleteStoredTrustTokens(issuer) {}
  
  /**
   * @param { !boolean } block
   */

  setBlockTrustTokens(block) {}
  
  /**
   * @param { !Array<!contentSettings_mojom_ContentSettingPatternSource> } settings
   */

  setTrackingProtectionContentSetting(settings) {}
  
  /**
   * @param { !mojoBase_mojom_Time } startTime
   * @param { !mojoBase_mojom_Time } endTime
   * @return {!Promise}
   */

  clearNetworkingHistoryBetween(startTime, endTime) {}
  
  /**
   * @param { !mojoBase_mojom_Time } startTime
   * @param { !mojoBase_mojom_Time } endTime
   * @param { ?network_mojom_ClearDataFilter } filter
   * @return {!Promise}
   */

  clearHttpCache(startTime, endTime, filter) {}
  
  /**
   * @param { !mojoBase_mojom_Time } startTime
   * @param { !mojoBase_mojom_Time } endTime
   * @return {!Promise<{
        isUpperBound: !boolean,
        sizeOrError: !bigint,
   *  }>}
   */

  computeHttpCacheSize(startTime, endTime) {}
  
  /**
   */

  notifyBrowserIdle() {}
  
  /**
   * @param { !url_mojom_Url } url
   * @param { !string } httpMethod
   * @param { !network_mojom_NetworkIsolationKey } key
   * @param { !boolean } includeCredentials
   */

  notifyExternalCacheHit(url, httpMethod, key, includeCredentials) {}
  
  /**
   * @param { ?network_mojom_ClearDataFilter } filter
   * @return {!Promise}
   */

  clearHostCache(filter) {}
  
  /**
   * @param { !mojoBase_mojom_Time } startTime
   * @param { !mojoBase_mojom_Time } endTime
   * @param { ?network_mojom_ClearDataFilter } filter
   * @return {!Promise}
   */

  clearHttpAuthCache(startTime, endTime, filter) {}
  
  /**
   * @param { ?network_mojom_ClearDataFilter } filter
   * @return {!Promise}
   */

  clearCorsPreflightCache(filter) {}
  
  /**
   * @param { ?network_mojom_ClearDataFilter } filter
   * @return {!Promise}
   */

  clearReportingCacheReports(filter) {}
  
  /**
   * @param { ?network_mojom_ClearDataFilter } filter
   * @return {!Promise}
   */

  clearReportingCacheClients(filter) {}
  
  /**
   * @param { ?network_mojom_ClearDataFilter } filter
   * @return {!Promise}
   */

  clearNetworkErrorLogging(filter) {}
  
  /**
   * @param { ?network_mojom_ClearDataFilter } filter
   * @param { !NetworkContext_DomainReliabilityClearMode } mode
   * @return {!Promise}
   */

  clearDomainReliability(filter, mode) {}
  
  /**
   * @param { !mojoBase_mojom_Time } startTime
   * @param { !mojoBase_mojom_Time } endTime
   * @param { ?network_mojom_ClearDataFilter } filter
   * @return {!Promise}
   */

  clearSharedDictionaryCache(startTime, endTime, filter) {}
  
  /**
   * @param { !network_mojom_SharedDictionaryIsolationKey } isolationKey
   * @return {!Promise}
   */

  clearSharedDictionaryCacheForIsolationKey(isolationKey) {}
  
  /**
   * @param { !mojoBase_mojom_UnguessableToken } reportingSource
   * @param { !url_mojom_Origin } origin
   * @param { !network_mojom_IsolationInfo } isolationInfo
   * @param { !Object<!string, !string> } endpoints
   */

  setDocumentReportingEndpoints(reportingSource, origin, isolationInfo, endpoints) {}
  
  /**
   * @param { !Object<!string, !url_mojom_Url> } endpoints
   */

  setEnterpriseReportingEndpoints(endpoints) {}
  
  /**
   * @param { !mojoBase_mojom_UnguessableToken } reportingSource
   */

  sendReportsAndRemoveSource(reportingSource) {}
  
  /**
   * @param { !string } type
   * @param { !string } group
   * @param { !url_mojom_Url } url
   * @param { ?mojoBase_mojom_UnguessableToken } reportingSource
   * @param { !network_mojom_NetworkAnonymizationKey } networkAnonymizationKey
   * @param { !mojoBase_mojom_DictionaryValue } body
   */

  queueReport(type, group, url, reportingSource, networkAnonymizationKey, body) {}
  
  /**
   * @param { !string } type
   * @param { !string } group
   * @param { !url_mojom_Url } url
   * @param { !mojoBase_mojom_DictionaryValue } body
   */

  queueEnterpriseReport(type, group, url, body) {}
  
  /**
   * @param { !SignedExchangeReport } report
   * @param { !network_mojom_NetworkAnonymizationKey } networkAnonymizationKey
   */

  queueSignedExchangeReport(report, networkAnonymizationKey) {}
  
  /**
   * @return {!Promise}
   */

  closeAllConnections() {}
  
  /**
   * @return {!Promise}
   */

  closeIdleConnections() {}
  
  /**
   * @param { !mojoBase_mojom_UnguessableToken } throttlingProfileId
   * @param { !Array<!MatchedNetworkConditions> } conditions
   */

  setNetworkConditions(throttlingProfileId, conditions) {}
  
  /**
   * @param { !mojoBase_mojom_UnguessableToken } throttlingProfileId
   * @param { !DurableMessageCollectorPendingReceiver } receiver
   */

  enableDurableMessageCollector(throttlingProfileId, receiver) {}
  
  /**
   * @param { !string } newAcceptLanguage
   */

  setAcceptLanguage(newAcceptLanguage) {}
  
  /**
   * @param { !boolean } enableReferrers
   */

  setEnableReferrers(enableReferrers) {}
  
  /**
   * @param { !CTPolicy } ctPolicy
   */

  setCTPolicy(ctPolicy) {}
  
  /**
   * @param { !network_mojom_UDPSocketPendingReceiver } receiver
   * @param { ?network_mojom_UDPSocketListenerRemote } listener
   */

  createUDPSocket(receiver, listener) {}
  
  /**
   * @param { !network_mojom_IPEndPoint } addr
   * @param { !network_mojom_RestrictedUDPSocketMode } mode
   * @param { !network_mojom_MutableNetworkTrafficAnnotationTag } trafficAnnotation
   * @param { ?network_mojom_RestrictedUDPSocketParams } params
   * @param { !network_mojom_RestrictedUDPSocketPendingReceiver } receiver
   * @param { ?network_mojom_UDPSocketListenerRemote } listener
   * @param { !boolean } allowMulticast
   * @return {!Promise<{
        result: !number,
        localAddrOut: ?network_mojom_IPEndPoint,
   *  }>}
   */

  createRestrictedUDPSocket(addr, mode, trafficAnnotation, params, receiver, listener, allowMulticast) {}
  
  /**
   * @param { !network_mojom_IPEndPoint } localAddr
   * @param { !network_mojom_TCPServerSocketOptions } options
   * @param { !network_mojom_MutableNetworkTrafficAnnotationTag } trafficAnnotation
   * @param { !network_mojom_TCPServerSocketPendingReceiver } socket
   * @return {!Promise<{
        result: !number,
        localAddrOut: ?network_mojom_IPEndPoint,
   *  }>}
   */

  createTCPServerSocket(localAddr, options, trafficAnnotation, socket) {}
  
  /**
   * @param { ?network_mojom_IPEndPoint } localAddr
   * @param { !network_mojom_AddressList } remoteAddrList
   * @param { ?network_mojom_TCPConnectedSocketOptions } tcpConnectedSocketOptions
   * @param { !network_mojom_MutableNetworkTrafficAnnotationTag } trafficAnnotation
   * @param { !network_mojom_TCPConnectedSocketPendingReceiver } socket
   * @param { ?network_mojom_SocketObserverRemote } observer
   * @return {!Promise<{
        result: !number,
        localAddr: ?network_mojom_IPEndPoint,
        peerAddr: ?network_mojom_IPEndPoint,
        receiveStream: ?MojoHandle,
        sendStream: ?MojoHandle,
   *  }>}
   */

  createTCPConnectedSocket(localAddr, remoteAddrList, tcpConnectedSocketOptions, trafficAnnotation, socket, observer) {}
  
  /**
   * @param { !network_mojom_IPEndPoint } localAddr
   * @param { !network_mojom_MutableNetworkTrafficAnnotationTag } trafficAnnotation
   * @param { !network_mojom_TCPBoundSocketPendingReceiver } socket
   * @return {!Promise<{
        result: !number,
        localAddr: ?network_mojom_IPEndPoint,
   *  }>}
   */

  createTCPBoundSocket(localAddr, trafficAnnotation, socket) {}
  
  /**
   * @param { !network_mojom_ProxyResolvingSocketFactoryPendingReceiver } factory
   */

  createProxyResolvingSocketFactory(factory) {}
  
  /**
   * @param { !url_mojom_Url } url
   * @param { !network_mojom_NetworkAnonymizationKey } networkAnonymizationKey
   * @param { !network_mojom_ProxyLookupClientRemote } proxyLookupClient
   */

  lookUpProxyForURL(url, networkAnonymizationKey, proxyLookupClient) {}
  
  /**
   * @return {!Promise}
   */

  forceReloadProxyConfig() {}
  
  /**
   * @return {!Promise}
   */

  clearBadProxiesCache() {}
  
  /**
   * @param { !url_mojom_Url } url
   * @param { !Array<!string> } requestedProtocols
   * @param { !network_mojom_SiteForCookies } siteForCookies
   * @param { !network_mojom_StorageAccessApiStatus } storageAccessApiStatus
   * @param { !network_mojom_IsolationInfo } isolationInfo
   * @param { !Array<!network_mojom_HttpHeader> } additionalHeaders
   * @param { !number } processId
   * @param { !url_mojom_Origin } origin
   * @param { !network_mojom_ClientSecurityState } clientSecurityState
   * @param { !number } options
   * @param { !network_mojom_MutableNetworkTrafficAnnotationTag } trafficAnnotation
   * @param { !network_mojom_WebSocketHandshakeClientRemote } handshakeClient
   * @param { ?network_mojom_URLLoaderNetworkServiceObserverRemote } urlLoaderNetworkObserver
   * @param { ?network_mojom_WebSocketAuthenticationHandlerRemote } authHandler
   * @param { ?TrustedHeaderClientRemote } headerClient
   * @param { ?mojoBase_mojom_UnguessableToken } throttlingProfileId
   */

  createWebSocket(url, requestedProtocols, siteForCookies, storageAccessApiStatus, isolationInfo, additionalHeaders, processId, origin, clientSecurityState, options, trafficAnnotation, handshakeClient, urlLoaderNetworkObserver, authHandler, headerClient, throttlingProfileId) {}
  
  /**
   * @param { !url_mojom_Url } url
   * @param { !url_mojom_Origin } origin
   * @param { !network_mojom_NetworkAnonymizationKey } networkAnonymizationKey
   * @param { !Array<!network_mojom_WebTransportCertificateFingerprint> } fingerprints
   * @param { !Array<!string> } applicationProtocols
   * @param { !network_mojom_WebTransportHandshakeClientRemote } handshakeClient
   * @param { ?network_mojom_URLLoaderNetworkServiceObserverRemote } urlLoaderNetworkObserver
   * @param { !network_mojom_ClientSecurityState } clientSecurityState
   */

  createWebTransport(url, origin, networkAnonymizationKey, fingerprints, applicationProtocols, handshakeClient, urlLoaderNetworkObserver, clientSecurityState) {}
  
  /**
   * @param { !network_mojom_NetLogExporterPendingReceiver } receiver
   */

  createNetLogExporter(receiver) {}
  
  /**
   * @param { !number } numStreams
   * @param { !url_mojom_Url } url
   * @param { !network_mojom_CredentialsMode } credentialsMode
   * @param { !network_mojom_NetworkAnonymizationKey } networkAnonymizationKey
   * @param { !network_mojom_MutableNetworkTrafficAnnotationTag } trafficAnnotation
   * @param { ?network_mojom_ConnectionKeepAliveConfig } keepaliveConfig
   * @param { ?network_mojom_ConnectionChangeObserverClientRemote } observerClient
   */

  preconnectSockets(numStreams, url, credentialsMode, networkAnonymizationKey, trafficAnnotation, keepaliveConfig, observerClient) {}
  
  /**
   * @param { !network_mojom_NetworkAnonymizationKey } networkAnonymizationKey
   * @param { !network_mojom_P2PTrustedSocketManagerClientRemote } client
   * @param { !network_mojom_P2PTrustedSocketManagerPendingReceiver } trustedSocketManager
   * @param { !network_mojom_P2PSocketManagerPendingReceiver } socketManager
   */

  createP2PSocketManager(networkAnonymizationKey, client, trustedSocketManager, socketManager) {}
  
  /**
   * @param { !network_mojom_MdnsResponderPendingReceiver } responderReceiver
   */

  createMdnsResponder(responderReceiver) {}
  
  /**
   * @param { !network_mojom_HostResolverHost } host
   * @param { !network_mojom_NetworkAnonymizationKey } networkAnonymizationKey
   * @param { ?network_mojom_ResolveHostParameters } optionalParameters
   * @param { !network_mojom_ResolveHostClientRemote } responseClient
   */

  resolveHost(host, networkAnonymizationKey, optionalParameters, responseClient) {}
  
  /**
   * @param { ?network_mojom_DnsConfigOverrides } configOverrides
   * @param { !network_mojom_HostResolverPendingReceiver } hostResolver
   */

  createHostResolver(configOverrides, hostResolver) {}
  
  /**
   * @param { !network_mojom_X509Certificate } certificate
   * @param { !network_mojom_HostPortPair } hostPort
   * @param { !string } ocspResponse
   * @param { !string } sctList
   * @return {!Promise<{
        errorCode: !number,
        cvResult: !network_mojom_CertVerifyResult,
        pkpBypassed: !boolean,
   *  }>}
   */

  verifyCert(certificate, hostPort, ocspResponse, sctList) {}
  
  /**
   * @param { !network_mojom_X509Certificate } certificate
   * @param { !network_mojom_HostPortPair } hostPort
   * @param { !string } ocspResponse
   * @param { !string } sctList
   * @return {!Promise<{
        errorCode: !number,
        cvResult: !network_mojom_CertVerifyResult,
        pkpBypassed: !boolean,
   *  }>}
   */

  verifyCertForSignedExchange(certificate, hostPort, ocspResponse, sctList) {}
  
  /**
   * @param { !string } binding
   * @param { !string } hostname
   * @param { !network_mojom_X509Certificate } tlsCertificate
   * @return {!Promise<{
        verifiedCert: !network_mojom_X509Certificate,
   *  }>}
   */

  verify2QwacCertBinding(binding, hostname, tlsCertificate) {}
  
  /**
   * @param { !string } host
   * @param { !mojoBase_mojom_Time } expiry
   * @param { !boolean } includeSubdomains
   * @return {!Promise}
   */

  addHSTS(host, expiry, includeSubdomains) {}
  
  /**
   * @param { !string } host
   * @param { !boolean } isTopLevelNav
   * @return {!Promise<{
        result: !boolean,
   *  }>}
   */

  isHSTSActiveForHost(host, isTopLevelNav) {}
  
  /**
   * @param { !string } domain
   * @return {!Promise<{
        state: !mojoBase_mojom_DictionaryValue,
   *  }>}
   */

  getHSTSState(domain) {}
  
  /**
   * @param { !url_mojom_Origin } sourceOrigin
   * @param { !Array<!network_mojom_CorsOriginPattern> } allowPatterns
   * @param { !Array<!network_mojom_CorsOriginPattern> } blockPatterns
   * @return {!Promise}
   */

  setCorsOriginAccessListsForOrigin(sourceOrigin, allowPatterns, blockPatterns) {}
  
  /**
   * @param { !string } host
   * @return {!Promise<{
        result: !boolean,
   *  }>}
   */

  deleteDynamicDataForHost(host) {}
  
  /**
   * @param { !boolean } splitAuthCacheByNetworkAnonymizationKey
   */

  setSplitAuthCacheByNetworkAnonymizationKey(splitAuthCacheByNetworkAnonymizationKey) {}
  
  /**
   * @return {!Promise<{
        cacheKey: !mojoBase_mojom_UnguessableToken,
   *  }>}
   */

  saveHttpAuthCacheProxyEntries() {}
  
  /**
   * @param { !mojoBase_mojom_UnguessableToken } cacheKey
   * @return {!Promise}
   */

  loadHttpAuthCacheProxyEntries(cacheKey) {}
  
  /**
   * @param { !network_mojom_AuthChallengeInfo } challenge
   * @param { !network_mojom_NetworkAnonymizationKey } networkAnonymizationKey
   * @param { !network_mojom_AuthCredentials } credentials
   * @return {!Promise}
   */

  addAuthCacheEntry(challenge, networkAnonymizationKey, credentials) {}
  
  /**
   * @param { !boolean } value
   */

  setCorsNonWildcardRequestHeadersSupport(value) {}
  
  /**
   * @param { !network_mojom_ProxyServer } proxyServer
   * @param { !string } authScheme
   * @param { !string } realm
   * @return {!Promise<{
        credentials: ?network_mojom_AuthCredentials,
   *  }>}
   */

  lookupProxyAuthCredentials(proxyServer, authScheme, realm) {}
  
  /**
   * @return {!Promise}
   */

  enableStaticKeyPinningForTesting() {}
  
  /**
   * @param { !network_mojom_X509Certificate } certificate
   * @param { !string } hostname
   * @param { !string } ocspResponse
   * @param { !string } sctList
   * @return {!Promise<{
        errorCode: !number,
   *  }>}
   */

  verifyCertificateForTesting(certificate, hostname, ocspResponse, sctList) {}
  
  /**
   * @return {!Promise<{
        trustAnchorIds: !Array<!Array<!number>>,
   *  }>}
   */

  getTrustAnchorIDsForTesting() {}
  
  /**
   * @param { !url_mojom_Origin } origin
   * @param { !url_mojom_Url } uploadUrl
   * @return {!Promise}
   */

  addDomainReliabilityContextForTesting(origin, uploadUrl) {}
  
  /**
   * @return {!Promise}
   */

  forceDomainReliabilityUploadsForTesting() {}
  
  /**
   * @param { !SCTAuditingMode } mode
   */

  setSCTAuditingMode(mode) {}
  
  /**
   * @param { !network_mojom_ReportingApiObserverRemote } observer
   */

  addReportingApiObserver(observer) {}
  
  /**
   * @return {!Promise<{
        usageInfo: !Array<!network_mojom_SharedDictionaryUsageInfo>,
   *  }>}
   */

  getSharedDictionaryUsageInfo() {}
  
  /**
   * @param { !network_mojom_SharedDictionaryIsolationKey } isolationKey
   * @return {!Promise<{
        dictionaries: !Array<!SharedDictionaryInfo>,
   *  }>}
   */

  getSharedDictionaryInfo(isolationKey) {}
  
  /**
   * @param { !mojoBase_mojom_Time } startTime
   * @param { !mojoBase_mojom_Time } endTime
   * @return {!Promise<{
        origins: !Array<!url_mojom_Origin>,
   *  }>}
   */

  getSharedDictionaryOriginsBetween(startTime, endTime) {}
  
  /**
   * @param { !bigint } cacheMaxSize
   */

  setSharedDictionaryCacheMaxSize(cacheMaxSize) {}
  
  /**
   * @param { !Array<!url_mojom_Url> } urls
   * @param { !PreloadedSharedDictionaryInfoHandlePendingReceiver } preloadHandle
   */

  preloadSharedDictionaryInfoForDocument(urls, preloadHandle) {}
  
  /**
   * @return {!Promise<{
        value: !boolean,
   *  }>}
   */

  hasPreloadedSharedDictionaryInfoForTesting() {}
  
  /**
   * @param { !network_mojom_HostPortPair } host
   * @param { !network_mojom_X509Certificate } certificate
   */

  flushCachedClientCertIfNeeded(host, certificate) {}
  
  /**
   * @param { !network_mojom_X509Certificate } certificate
   */

  flushMatchingCachedClientCert(certificate) {}
  
  /**
   * @param { ?string } label
   */

  setCookieDeprecationLabel(label) {}
  
  /**
   * @param { !Array<!mojoBase_mojom_UnguessableToken> } nonces
   * @return {!Promise}
   */

  revokeNetworkForNonces(nonces) {}
  
  /**
   * @param { !Array<!mojoBase_mojom_UnguessableToken> } nonces
   */

  clearNonces(nonces) {}
  
  /**
   * @param { !url_mojom_Url } exemptedUrl
   * @param { !mojoBase_mojom_UnguessableToken } nonce
   * @return {!Promise}
   */

  exemptUrlFromNetworkRevocationForNonce(exemptedUrl, nonce) {}
  
  /**
   * @param { !number } requestId
   * @param { !number } options
   * @param { !network_mojom_URLRequest } request
   * @param { !network_mojom_MutableNetworkTrafficAnnotationTag } trafficAnnotation
   */

  prefetch(requestId, options, request, trafficAnnotation) {}
  
  /**
   * @return {!Promise<{
        boundNetwork: !bigint,
   *  }>}
   */

  getBoundNetworkForTesting() {}
  
  /**
   * @param { !network_mojom_DeviceBoundSessionManagerPendingReceiver } deviceBoundSessionManager
   */

  getDeviceBoundSessionManager(deviceBoundSessionManager) {}
  
  /**
   * @param { !Array<!url_mojom_SchemeHostPort> } origins
   * @param { !network_mojom_NetworkAnonymizationKey } networkAnonymizationKey
   */

  addQuicHints(origins, networkAnonymizationKey) {}
}

/**
 * @implements { NetworkContextInterface }
 */
export class NetworkContextRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!NetworkContextPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          NetworkContextPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!NetworkContextPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !network_mojom_NetworkContextClientRemote } client
   */

  setClient(
      client) {
    this.proxy.sendMessage(
        0,
        NetworkContext_SetClient_ParamsSpec.$,
        null,
        [
          client
        ],
        false);
  }

  
  /**
   * @param { !network_mojom_URLLoaderFactoryPendingReceiver } urlLoaderFactory
   * @param { !URLLoaderFactoryParams } params
   */

  createURLLoaderFactory(
      urlLoaderFactory,
      params) {
    this.proxy.sendMessage(
        1,
        NetworkContext_CreateURLLoaderFactory_ParamsSpec.$,
        null,
        [
          urlLoaderFactory,
          params
        ],
        false);
  }

  
  /**
   */

  resetURLLoaderFactories() {
    this.proxy.sendMessage(
        2,
        NetworkContext_ResetURLLoaderFactories_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !network_mojom_ObliviousHttpRequest } request
   * @param { !network_mojom_ObliviousHttpClientRemote } client
   */

  getViaObliviousHttp(
      request,
      client) {
    this.proxy.sendMessage(
        3,
        NetworkContext_GetViaObliviousHttp_ParamsSpec.$,
        null,
        [
          request,
          client
        ],
        false);
  }

  
  /**
   * @param { !network_mojom_CookieManagerPendingReceiver } cookieManager
   */

  getCookieManager(
      cookieManager) {
    this.proxy.sendMessage(
        4,
        NetworkContext_GetCookieManager_ParamsSpec.$,
        null,
        [
          cookieManager
        ],
        false);
  }

  
  /**
   * @param { !network_mojom_RestrictedCookieManagerPendingReceiver } restrictedCookieManager
   * @param { !network_mojom_RestrictedCookieManagerRole } role
   * @param { !url_mojom_Origin } origin
   * @param { !network_mojom_IsolationInfo } isolationInfo
   * @param { !network_mojom_CookieSettingOverrides } cookieSettingOverrides
   * @param { !network_mojom_CookieSettingOverrides } devtoolsCookieSettingOverrides
   * @param { ?network_mojom_CookieAccessObserverRemote } cookieObserver
   */

  getRestrictedCookieManager(
      restrictedCookieManager,
      role,
      origin,
      isolationInfo,
      cookieSettingOverrides,
      devtoolsCookieSettingOverrides,
      cookieObserver) {
    this.proxy.sendMessage(
        5,
        NetworkContext_GetRestrictedCookieManager_ParamsSpec.$,
        null,
        [
          restrictedCookieManager,
          role,
          origin,
          isolationInfo,
          cookieSettingOverrides,
          devtoolsCookieSettingOverrides,
          cookieObserver
        ],
        false);
  }

  
  /**
   * @param { !network_mojom_TrustTokenQueryAnswererPendingReceiver } trustTokenQueryAnswerer
   * @param { !url_mojom_Origin } topFrameOrigin
   */

  getTrustTokenQueryAnswerer(
      trustTokenQueryAnswerer,
      topFrameOrigin) {
    this.proxy.sendMessage(
        6,
        NetworkContext_GetTrustTokenQueryAnswerer_ParamsSpec.$,
        null,
        [
          trustTokenQueryAnswerer,
          topFrameOrigin
        ],
        false);
  }

  
  /**
   * @param { ?network_mojom_ClearDataFilter } filter
   * @return {!Promise}
   */

  clearTrustTokenData(
      filter) {
    return this.proxy.sendMessage(
        7,
        NetworkContext_ClearTrustTokenData_ParamsSpec.$,
        NetworkContext_ClearTrustTokenData_ResponseParamsSpec.$,
        [
          filter
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        anyDataDeleted: !boolean,
   *  }>}
   */

  clearTrustTokenSessionOnlyData() {
    return this.proxy.sendMessage(
        8,
        NetworkContext_ClearTrustTokenSessionOnlyData_ParamsSpec.$,
        NetworkContext_ClearTrustTokenSessionOnlyData_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        tokens: !Array<!network_mojom_StoredTrustTokensForIssuer>,
   *  }>}
   */

  getStoredTrustTokenCounts() {
    return this.proxy.sendMessage(
        9,
        NetworkContext_GetStoredTrustTokenCounts_ParamsSpec.$,
        NetworkContext_GetStoredTrustTokenCounts_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        issuerRedemptionRecordMap: !Map<!url_mojom_Origin, !Array<!network_mojom_ToplevelRedemptionRecord>>,
   *  }>}
   */

  getPrivateStateTokenRedemptionRecords() {
    return this.proxy.sendMessage(
        10,
        NetworkContext_GetPrivateStateTokenRedemptionRecords_ParamsSpec.$,
        NetworkContext_GetPrivateStateTokenRedemptionRecords_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        status: !ipProtection_mojom_IpProxyStatus,
   *  }>}
   */

  getIpProxyStatus() {
    return this.proxy.sendMessage(
        11,
        NetworkContext_GetIpProxyStatus_ParamsSpec.$,
        NetworkContext_GetIpProxyStatus_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !boolean } bypassProxy
   */

  setBypassIpProtectionProxy(
      bypassProxy) {
    this.proxy.sendMessage(
        12,
        NetworkContext_SetBypassIpProtectionProxy_ParamsSpec.$,
        null,
        [
          bypassProxy
        ],
        false);
  }

  
  /**
   * @param { !url_mojom_Origin } issuer
   * @return {!Promise<{
        status: !network_mojom_DeleteStoredTrustTokensStatus,
   *  }>}
   */

  deleteStoredTrustTokens(
      issuer) {
    return this.proxy.sendMessage(
        13,
        NetworkContext_DeleteStoredTrustTokens_ParamsSpec.$,
        NetworkContext_DeleteStoredTrustTokens_ResponseParamsSpec.$,
        [
          issuer
        ],
        false);
  }

  
  /**
   * @param { !boolean } block
   */

  setBlockTrustTokens(
      block) {
    this.proxy.sendMessage(
        14,
        NetworkContext_SetBlockTrustTokens_ParamsSpec.$,
        null,
        [
          block
        ],
        false);
  }

  
  /**
   * @param { !Array<!contentSettings_mojom_ContentSettingPatternSource> } settings
   */

  setTrackingProtectionContentSetting(
      settings) {
    this.proxy.sendMessage(
        15,
        NetworkContext_SetTrackingProtectionContentSetting_ParamsSpec.$,
        null,
        [
          settings
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_Time } startTime
   * @param { !mojoBase_mojom_Time } endTime
   * @return {!Promise}
   */

  clearNetworkingHistoryBetween(
      startTime,
      endTime) {
    return this.proxy.sendMessage(
        16,
        NetworkContext_ClearNetworkingHistoryBetween_ParamsSpec.$,
        NetworkContext_ClearNetworkingHistoryBetween_ResponseParamsSpec.$,
        [
          startTime,
          endTime
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_Time } startTime
   * @param { !mojoBase_mojom_Time } endTime
   * @param { ?network_mojom_ClearDataFilter } filter
   * @return {!Promise}
   */

  clearHttpCache(
      startTime,
      endTime,
      filter) {
    return this.proxy.sendMessage(
        17,
        NetworkContext_ClearHttpCache_ParamsSpec.$,
        NetworkContext_ClearHttpCache_ResponseParamsSpec.$,
        [
          startTime,
          endTime,
          filter
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_Time } startTime
   * @param { !mojoBase_mojom_Time } endTime
   * @return {!Promise<{
        isUpperBound: !boolean,
        sizeOrError: !bigint,
   *  }>}
   */

  computeHttpCacheSize(
      startTime,
      endTime) {
    return this.proxy.sendMessage(
        18,
        NetworkContext_ComputeHttpCacheSize_ParamsSpec.$,
        NetworkContext_ComputeHttpCacheSize_ResponseParamsSpec.$,
        [
          startTime,
          endTime
        ],
        false);
  }

  
  /**
   */

  notifyBrowserIdle() {
    this.proxy.sendMessage(
        19,
        NetworkContext_NotifyBrowserIdle_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !url_mojom_Url } url
   * @param { !string } httpMethod
   * @param { !network_mojom_NetworkIsolationKey } key
   * @param { !boolean } includeCredentials
   */

  notifyExternalCacheHit(
      url,
      httpMethod,
      key,
      includeCredentials) {
    this.proxy.sendMessage(
        20,
        NetworkContext_NotifyExternalCacheHit_ParamsSpec.$,
        null,
        [
          url,
          httpMethod,
          key,
          includeCredentials
        ],
        false);
  }

  
  /**
   * @param { ?network_mojom_ClearDataFilter } filter
   * @return {!Promise}
   */

  clearHostCache(
      filter) {
    return this.proxy.sendMessage(
        21,
        NetworkContext_ClearHostCache_ParamsSpec.$,
        NetworkContext_ClearHostCache_ResponseParamsSpec.$,
        [
          filter
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_Time } startTime
   * @param { !mojoBase_mojom_Time } endTime
   * @param { ?network_mojom_ClearDataFilter } filter
   * @return {!Promise}
   */

  clearHttpAuthCache(
      startTime,
      endTime,
      filter) {
    return this.proxy.sendMessage(
        22,
        NetworkContext_ClearHttpAuthCache_ParamsSpec.$,
        NetworkContext_ClearHttpAuthCache_ResponseParamsSpec.$,
        [
          startTime,
          endTime,
          filter
        ],
        false);
  }

  
  /**
   * @param { ?network_mojom_ClearDataFilter } filter
   * @return {!Promise}
   */

  clearCorsPreflightCache(
      filter) {
    return this.proxy.sendMessage(
        23,
        NetworkContext_ClearCorsPreflightCache_ParamsSpec.$,
        NetworkContext_ClearCorsPreflightCache_ResponseParamsSpec.$,
        [
          filter
        ],
        false);
  }

  
  /**
   * @param { ?network_mojom_ClearDataFilter } filter
   * @return {!Promise}
   */

  clearReportingCacheReports(
      filter) {
    return this.proxy.sendMessage(
        24,
        NetworkContext_ClearReportingCacheReports_ParamsSpec.$,
        NetworkContext_ClearReportingCacheReports_ResponseParamsSpec.$,
        [
          filter
        ],
        false);
  }

  
  /**
   * @param { ?network_mojom_ClearDataFilter } filter
   * @return {!Promise}
   */

  clearReportingCacheClients(
      filter) {
    return this.proxy.sendMessage(
        25,
        NetworkContext_ClearReportingCacheClients_ParamsSpec.$,
        NetworkContext_ClearReportingCacheClients_ResponseParamsSpec.$,
        [
          filter
        ],
        false);
  }

  
  /**
   * @param { ?network_mojom_ClearDataFilter } filter
   * @return {!Promise}
   */

  clearNetworkErrorLogging(
      filter) {
    return this.proxy.sendMessage(
        26,
        NetworkContext_ClearNetworkErrorLogging_ParamsSpec.$,
        NetworkContext_ClearNetworkErrorLogging_ResponseParamsSpec.$,
        [
          filter
        ],
        false);
  }

  
  /**
   * @param { ?network_mojom_ClearDataFilter } filter
   * @param { !NetworkContext_DomainReliabilityClearMode } mode
   * @return {!Promise}
   */

  clearDomainReliability(
      filter,
      mode) {
    return this.proxy.sendMessage(
        27,
        NetworkContext_ClearDomainReliability_ParamsSpec.$,
        NetworkContext_ClearDomainReliability_ResponseParamsSpec.$,
        [
          filter,
          mode
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_Time } startTime
   * @param { !mojoBase_mojom_Time } endTime
   * @param { ?network_mojom_ClearDataFilter } filter
   * @return {!Promise}
   */

  clearSharedDictionaryCache(
      startTime,
      endTime,
      filter) {
    return this.proxy.sendMessage(
        28,
        NetworkContext_ClearSharedDictionaryCache_ParamsSpec.$,
        NetworkContext_ClearSharedDictionaryCache_ResponseParamsSpec.$,
        [
          startTime,
          endTime,
          filter
        ],
        false);
  }

  
  /**
   * @param { !network_mojom_SharedDictionaryIsolationKey } isolationKey
   * @return {!Promise}
   */

  clearSharedDictionaryCacheForIsolationKey(
      isolationKey) {
    return this.proxy.sendMessage(
        29,
        NetworkContext_ClearSharedDictionaryCacheForIsolationKey_ParamsSpec.$,
        NetworkContext_ClearSharedDictionaryCacheForIsolationKey_ResponseParamsSpec.$,
        [
          isolationKey
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_UnguessableToken } reportingSource
   * @param { !url_mojom_Origin } origin
   * @param { !network_mojom_IsolationInfo } isolationInfo
   * @param { !Object<!string, !string> } endpoints
   */

  setDocumentReportingEndpoints(
      reportingSource,
      origin,
      isolationInfo,
      endpoints) {
    this.proxy.sendMessage(
        30,
        NetworkContext_SetDocumentReportingEndpoints_ParamsSpec.$,
        null,
        [
          reportingSource,
          origin,
          isolationInfo,
          endpoints
        ],
        false);
  }

  
  /**
   * @param { !Object<!string, !url_mojom_Url> } endpoints
   */

  setEnterpriseReportingEndpoints(
      endpoints) {
    this.proxy.sendMessage(
        31,
        NetworkContext_SetEnterpriseReportingEndpoints_ParamsSpec.$,
        null,
        [
          endpoints
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_UnguessableToken } reportingSource
   */

  sendReportsAndRemoveSource(
      reportingSource) {
    this.proxy.sendMessage(
        32,
        NetworkContext_SendReportsAndRemoveSource_ParamsSpec.$,
        null,
        [
          reportingSource
        ],
        false);
  }

  
  /**
   * @param { !string } type
   * @param { !string } group
   * @param { !url_mojom_Url } url
   * @param { ?mojoBase_mojom_UnguessableToken } reportingSource
   * @param { !network_mojom_NetworkAnonymizationKey } networkAnonymizationKey
   * @param { !mojoBase_mojom_DictionaryValue } body
   */

  queueReport(
      type,
      group,
      url,
      reportingSource,
      networkAnonymizationKey,
      body) {
    this.proxy.sendMessage(
        33,
        NetworkContext_QueueReport_ParamsSpec.$,
        null,
        [
          type,
          group,
          url,
          reportingSource,
          networkAnonymizationKey,
          body
        ],
        false);
  }

  
  /**
   * @param { !string } type
   * @param { !string } group
   * @param { !url_mojom_Url } url
   * @param { !mojoBase_mojom_DictionaryValue } body
   */

  queueEnterpriseReport(
      type,
      group,
      url,
      body) {
    this.proxy.sendMessage(
        34,
        NetworkContext_QueueEnterpriseReport_ParamsSpec.$,
        null,
        [
          type,
          group,
          url,
          body
        ],
        false);
  }

  
  /**
   * @param { !SignedExchangeReport } report
   * @param { !network_mojom_NetworkAnonymizationKey } networkAnonymizationKey
   */

  queueSignedExchangeReport(
      report,
      networkAnonymizationKey) {
    this.proxy.sendMessage(
        35,
        NetworkContext_QueueSignedExchangeReport_ParamsSpec.$,
        null,
        [
          report,
          networkAnonymizationKey
        ],
        false);
  }

  
  /**
   * @return {!Promise}
   */

  closeAllConnections() {
    return this.proxy.sendMessage(
        36,
        NetworkContext_CloseAllConnections_ParamsSpec.$,
        NetworkContext_CloseAllConnections_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise}
   */

  closeIdleConnections() {
    return this.proxy.sendMessage(
        37,
        NetworkContext_CloseIdleConnections_ParamsSpec.$,
        NetworkContext_CloseIdleConnections_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_UnguessableToken } throttlingProfileId
   * @param { !Array<!MatchedNetworkConditions> } conditions
   */

  setNetworkConditions(
      throttlingProfileId,
      conditions) {
    this.proxy.sendMessage(
        38,
        NetworkContext_SetNetworkConditions_ParamsSpec.$,
        null,
        [
          throttlingProfileId,
          conditions
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_UnguessableToken } throttlingProfileId
   * @param { !DurableMessageCollectorPendingReceiver } receiver
   */

  enableDurableMessageCollector(
      throttlingProfileId,
      receiver) {
    this.proxy.sendMessage(
        39,
        NetworkContext_EnableDurableMessageCollector_ParamsSpec.$,
        null,
        [
          throttlingProfileId,
          receiver
        ],
        false);
  }

  
  /**
   * @param { !string } newAcceptLanguage
   */

  setAcceptLanguage(
      newAcceptLanguage) {
    this.proxy.sendMessage(
        40,
        NetworkContext_SetAcceptLanguage_ParamsSpec.$,
        null,
        [
          newAcceptLanguage
        ],
        false);
  }

  
  /**
   * @param { !boolean } enableReferrers
   */

  setEnableReferrers(
      enableReferrers) {
    this.proxy.sendMessage(
        41,
        NetworkContext_SetEnableReferrers_ParamsSpec.$,
        null,
        [
          enableReferrers
        ],
        false);
  }

  
  /**
   * @param { !CTPolicy } ctPolicy
   */

  setCTPolicy(
      ctPolicy) {
    this.proxy.sendMessage(
        42,
        NetworkContext_SetCTPolicy_ParamsSpec.$,
        null,
        [
          ctPolicy
        ],
        false);
  }

  
  /**
   * @param { !network_mojom_UDPSocketPendingReceiver } receiver
   * @param { ?network_mojom_UDPSocketListenerRemote } listener
   */

  createUDPSocket(
      receiver,
      listener) {
    this.proxy.sendMessage(
        43,
        NetworkContext_CreateUDPSocket_ParamsSpec.$,
        null,
        [
          receiver,
          listener
        ],
        false);
  }

  
  /**
   * @param { !network_mojom_IPEndPoint } addr
   * @param { !network_mojom_RestrictedUDPSocketMode } mode
   * @param { !network_mojom_MutableNetworkTrafficAnnotationTag } trafficAnnotation
   * @param { ?network_mojom_RestrictedUDPSocketParams } params
   * @param { !network_mojom_RestrictedUDPSocketPendingReceiver } receiver
   * @param { ?network_mojom_UDPSocketListenerRemote } listener
   * @param { !boolean } allowMulticast
   * @return {!Promise<{
        result: !number,
        localAddrOut: ?network_mojom_IPEndPoint,
   *  }>}
   */

  createRestrictedUDPSocket(
      addr,
      mode,
      trafficAnnotation,
      params,
      receiver,
      listener,
      allowMulticast) {
    return this.proxy.sendMessage(
        44,
        NetworkContext_CreateRestrictedUDPSocket_ParamsSpec.$,
        NetworkContext_CreateRestrictedUDPSocket_ResponseParamsSpec.$,
        [
          addr,
          mode,
          trafficAnnotation,
          params,
          receiver,
          listener,
          allowMulticast
        ],
        false);
  }

  
  /**
   * @param { !network_mojom_IPEndPoint } localAddr
   * @param { !network_mojom_TCPServerSocketOptions } options
   * @param { !network_mojom_MutableNetworkTrafficAnnotationTag } trafficAnnotation
   * @param { !network_mojom_TCPServerSocketPendingReceiver } socket
   * @return {!Promise<{
        result: !number,
        localAddrOut: ?network_mojom_IPEndPoint,
   *  }>}
   */

  createTCPServerSocket(
      localAddr,
      options,
      trafficAnnotation,
      socket) {
    return this.proxy.sendMessage(
        45,
        NetworkContext_CreateTCPServerSocket_ParamsSpec.$,
        NetworkContext_CreateTCPServerSocket_ResponseParamsSpec.$,
        [
          localAddr,
          options,
          trafficAnnotation,
          socket
        ],
        false);
  }

  
  /**
   * @param { ?network_mojom_IPEndPoint } localAddr
   * @param { !network_mojom_AddressList } remoteAddrList
   * @param { ?network_mojom_TCPConnectedSocketOptions } tcpConnectedSocketOptions
   * @param { !network_mojom_MutableNetworkTrafficAnnotationTag } trafficAnnotation
   * @param { !network_mojom_TCPConnectedSocketPendingReceiver } socket
   * @param { ?network_mojom_SocketObserverRemote } observer
   * @return {!Promise<{
        result: !number,
        localAddr: ?network_mojom_IPEndPoint,
        peerAddr: ?network_mojom_IPEndPoint,
        receiveStream: ?MojoHandle,
        sendStream: ?MojoHandle,
   *  }>}
   */

  createTCPConnectedSocket(
      localAddr,
      remoteAddrList,
      tcpConnectedSocketOptions,
      trafficAnnotation,
      socket,
      observer) {
    return this.proxy.sendMessage(
        46,
        NetworkContext_CreateTCPConnectedSocket_ParamsSpec.$,
        NetworkContext_CreateTCPConnectedSocket_ResponseParamsSpec.$,
        [
          localAddr,
          remoteAddrList,
          tcpConnectedSocketOptions,
          trafficAnnotation,
          socket,
          observer
        ],
        false);
  }

  
  /**
   * @param { !network_mojom_IPEndPoint } localAddr
   * @param { !network_mojom_MutableNetworkTrafficAnnotationTag } trafficAnnotation
   * @param { !network_mojom_TCPBoundSocketPendingReceiver } socket
   * @return {!Promise<{
        result: !number,
        localAddr: ?network_mojom_IPEndPoint,
   *  }>}
   */

  createTCPBoundSocket(
      localAddr,
      trafficAnnotation,
      socket) {
    return this.proxy.sendMessage(
        47,
        NetworkContext_CreateTCPBoundSocket_ParamsSpec.$,
        NetworkContext_CreateTCPBoundSocket_ResponseParamsSpec.$,
        [
          localAddr,
          trafficAnnotation,
          socket
        ],
        false);
  }

  
  /**
   * @param { !network_mojom_ProxyResolvingSocketFactoryPendingReceiver } factory
   */

  createProxyResolvingSocketFactory(
      factory) {
    this.proxy.sendMessage(
        48,
        NetworkContext_CreateProxyResolvingSocketFactory_ParamsSpec.$,
        null,
        [
          factory
        ],
        false);
  }

  
  /**
   * @param { !url_mojom_Url } url
   * @param { !network_mojom_NetworkAnonymizationKey } networkAnonymizationKey
   * @param { !network_mojom_ProxyLookupClientRemote } proxyLookupClient
   */

  lookUpProxyForURL(
      url,
      networkAnonymizationKey,
      proxyLookupClient) {
    this.proxy.sendMessage(
        49,
        NetworkContext_LookUpProxyForURL_ParamsSpec.$,
        null,
        [
          url,
          networkAnonymizationKey,
          proxyLookupClient
        ],
        false);
  }

  
  /**
   * @return {!Promise}
   */

  forceReloadProxyConfig() {
    return this.proxy.sendMessage(
        50,
        NetworkContext_ForceReloadProxyConfig_ParamsSpec.$,
        NetworkContext_ForceReloadProxyConfig_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise}
   */

  clearBadProxiesCache() {
    return this.proxy.sendMessage(
        51,
        NetworkContext_ClearBadProxiesCache_ParamsSpec.$,
        NetworkContext_ClearBadProxiesCache_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !url_mojom_Url } url
   * @param { !Array<!string> } requestedProtocols
   * @param { !network_mojom_SiteForCookies } siteForCookies
   * @param { !network_mojom_StorageAccessApiStatus } storageAccessApiStatus
   * @param { !network_mojom_IsolationInfo } isolationInfo
   * @param { !Array<!network_mojom_HttpHeader> } additionalHeaders
   * @param { !number } processId
   * @param { !url_mojom_Origin } origin
   * @param { !network_mojom_ClientSecurityState } clientSecurityState
   * @param { !number } options
   * @param { !network_mojom_MutableNetworkTrafficAnnotationTag } trafficAnnotation
   * @param { !network_mojom_WebSocketHandshakeClientRemote } handshakeClient
   * @param { ?network_mojom_URLLoaderNetworkServiceObserverRemote } urlLoaderNetworkObserver
   * @param { ?network_mojom_WebSocketAuthenticationHandlerRemote } authHandler
   * @param { ?TrustedHeaderClientRemote } headerClient
   * @param { ?mojoBase_mojom_UnguessableToken } throttlingProfileId
   */

  createWebSocket(
      url,
      requestedProtocols,
      siteForCookies,
      storageAccessApiStatus,
      isolationInfo,
      additionalHeaders,
      processId,
      origin,
      clientSecurityState,
      options,
      trafficAnnotation,
      handshakeClient,
      urlLoaderNetworkObserver,
      authHandler,
      headerClient,
      throttlingProfileId) {
    this.proxy.sendMessage(
        52,
        NetworkContext_CreateWebSocket_ParamsSpec.$,
        null,
        [
          url,
          requestedProtocols,
          siteForCookies,
          storageAccessApiStatus,
          isolationInfo,
          additionalHeaders,
          processId,
          origin,
          clientSecurityState,
          options,
          trafficAnnotation,
          handshakeClient,
          urlLoaderNetworkObserver,
          authHandler,
          headerClient,
          throttlingProfileId
        ],
        false);
  }

  
  /**
   * @param { !url_mojom_Url } url
   * @param { !url_mojom_Origin } origin
   * @param { !network_mojom_NetworkAnonymizationKey } networkAnonymizationKey
   * @param { !Array<!network_mojom_WebTransportCertificateFingerprint> } fingerprints
   * @param { !Array<!string> } applicationProtocols
   * @param { !network_mojom_WebTransportHandshakeClientRemote } handshakeClient
   * @param { ?network_mojom_URLLoaderNetworkServiceObserverRemote } urlLoaderNetworkObserver
   * @param { !network_mojom_ClientSecurityState } clientSecurityState
   */

  createWebTransport(
      url,
      origin,
      networkAnonymizationKey,
      fingerprints,
      applicationProtocols,
      handshakeClient,
      urlLoaderNetworkObserver,
      clientSecurityState) {
    this.proxy.sendMessage(
        53,
        NetworkContext_CreateWebTransport_ParamsSpec.$,
        null,
        [
          url,
          origin,
          networkAnonymizationKey,
          fingerprints,
          applicationProtocols,
          handshakeClient,
          urlLoaderNetworkObserver,
          clientSecurityState
        ],
        false);
  }

  
  /**
   * @param { !network_mojom_NetLogExporterPendingReceiver } receiver
   */

  createNetLogExporter(
      receiver) {
    this.proxy.sendMessage(
        54,
        NetworkContext_CreateNetLogExporter_ParamsSpec.$,
        null,
        [
          receiver
        ],
        false);
  }

  
  /**
   * @param { !number } numStreams
   * @param { !url_mojom_Url } url
   * @param { !network_mojom_CredentialsMode } credentialsMode
   * @param { !network_mojom_NetworkAnonymizationKey } networkAnonymizationKey
   * @param { !network_mojom_MutableNetworkTrafficAnnotationTag } trafficAnnotation
   * @param { ?network_mojom_ConnectionKeepAliveConfig } keepaliveConfig
   * @param { ?network_mojom_ConnectionChangeObserverClientRemote } observerClient
   */

  preconnectSockets(
      numStreams,
      url,
      credentialsMode,
      networkAnonymizationKey,
      trafficAnnotation,
      keepaliveConfig,
      observerClient) {
    this.proxy.sendMessage(
        55,
        NetworkContext_PreconnectSockets_ParamsSpec.$,
        null,
        [
          numStreams,
          url,
          credentialsMode,
          networkAnonymizationKey,
          trafficAnnotation,
          keepaliveConfig,
          observerClient
        ],
        false);
  }

  
  /**
   * @param { !network_mojom_NetworkAnonymizationKey } networkAnonymizationKey
   * @param { !network_mojom_P2PTrustedSocketManagerClientRemote } client
   * @param { !network_mojom_P2PTrustedSocketManagerPendingReceiver } trustedSocketManager
   * @param { !network_mojom_P2PSocketManagerPendingReceiver } socketManager
   */

  createP2PSocketManager(
      networkAnonymizationKey,
      client,
      trustedSocketManager,
      socketManager) {
    this.proxy.sendMessage(
        56,
        NetworkContext_CreateP2PSocketManager_ParamsSpec.$,
        null,
        [
          networkAnonymizationKey,
          client,
          trustedSocketManager,
          socketManager
        ],
        false);
  }

  
  /**
   * @param { !network_mojom_MdnsResponderPendingReceiver } responderReceiver
   */

  createMdnsResponder(
      responderReceiver) {
    this.proxy.sendMessage(
        57,
        NetworkContext_CreateMdnsResponder_ParamsSpec.$,
        null,
        [
          responderReceiver
        ],
        false);
  }

  
  /**
   * @param { !network_mojom_HostResolverHost } host
   * @param { !network_mojom_NetworkAnonymizationKey } networkAnonymizationKey
   * @param { ?network_mojom_ResolveHostParameters } optionalParameters
   * @param { !network_mojom_ResolveHostClientRemote } responseClient
   */

  resolveHost(
      host,
      networkAnonymizationKey,
      optionalParameters,
      responseClient) {
    this.proxy.sendMessage(
        58,
        NetworkContext_ResolveHost_ParamsSpec.$,
        null,
        [
          host,
          networkAnonymizationKey,
          optionalParameters,
          responseClient
        ],
        false);
  }

  
  /**
   * @param { ?network_mojom_DnsConfigOverrides } configOverrides
   * @param { !network_mojom_HostResolverPendingReceiver } hostResolver
   */

  createHostResolver(
      configOverrides,
      hostResolver) {
    this.proxy.sendMessage(
        59,
        NetworkContext_CreateHostResolver_ParamsSpec.$,
        null,
        [
          configOverrides,
          hostResolver
        ],
        false);
  }

  
  /**
   * @param { !network_mojom_X509Certificate } certificate
   * @param { !network_mojom_HostPortPair } hostPort
   * @param { !string } ocspResponse
   * @param { !string } sctList
   * @return {!Promise<{
        errorCode: !number,
        cvResult: !network_mojom_CertVerifyResult,
        pkpBypassed: !boolean,
   *  }>}
   */

  verifyCert(
      certificate,
      hostPort,
      ocspResponse,
      sctList) {
    return this.proxy.sendMessage(
        60,
        NetworkContext_VerifyCert_ParamsSpec.$,
        NetworkContext_VerifyCert_ResponseParamsSpec.$,
        [
          certificate,
          hostPort,
          ocspResponse,
          sctList
        ],
        false);
  }

  
  /**
   * @param { !network_mojom_X509Certificate } certificate
   * @param { !network_mojom_HostPortPair } hostPort
   * @param { !string } ocspResponse
   * @param { !string } sctList
   * @return {!Promise<{
        errorCode: !number,
        cvResult: !network_mojom_CertVerifyResult,
        pkpBypassed: !boolean,
   *  }>}
   */

  verifyCertForSignedExchange(
      certificate,
      hostPort,
      ocspResponse,
      sctList) {
    return this.proxy.sendMessage(
        61,
        NetworkContext_VerifyCertForSignedExchange_ParamsSpec.$,
        NetworkContext_VerifyCertForSignedExchange_ResponseParamsSpec.$,
        [
          certificate,
          hostPort,
          ocspResponse,
          sctList
        ],
        false);
  }

  
  /**
   * @param { !string } binding
   * @param { !string } hostname
   * @param { !network_mojom_X509Certificate } tlsCertificate
   * @return {!Promise<{
        verifiedCert: !network_mojom_X509Certificate,
   *  }>}
   */

  verify2QwacCertBinding(
      binding,
      hostname,
      tlsCertificate) {
    return this.proxy.sendMessage(
        62,
        NetworkContext_Verify2QwacCertBinding_ParamsSpec.$,
        NetworkContext_Verify2QwacCertBinding_ResponseParamsSpec.$,
        [
          binding,
          hostname,
          tlsCertificate
        ],
        false);
  }

  
  /**
   * @param { !string } host
   * @param { !mojoBase_mojom_Time } expiry
   * @param { !boolean } includeSubdomains
   * @return {!Promise}
   */

  addHSTS(
      host,
      expiry,
      includeSubdomains) {
    return this.proxy.sendMessage(
        63,
        NetworkContext_AddHSTS_ParamsSpec.$,
        NetworkContext_AddHSTS_ResponseParamsSpec.$,
        [
          host,
          expiry,
          includeSubdomains
        ],
        false);
  }

  
  /**
   * @param { !string } host
   * @param { !boolean } isTopLevelNav
   * @return {!Promise<{
        result: !boolean,
   *  }>}
   */

  isHSTSActiveForHost(
      host,
      isTopLevelNav) {
    return this.proxy.sendMessage(
        64,
        NetworkContext_IsHSTSActiveForHost_ParamsSpec.$,
        NetworkContext_IsHSTSActiveForHost_ResponseParamsSpec.$,
        [
          host,
          isTopLevelNav
        ],
        false);
  }

  
  /**
   * @param { !string } domain
   * @return {!Promise<{
        state: !mojoBase_mojom_DictionaryValue,
   *  }>}
   */

  getHSTSState(
      domain) {
    return this.proxy.sendMessage(
        65,
        NetworkContext_GetHSTSState_ParamsSpec.$,
        NetworkContext_GetHSTSState_ResponseParamsSpec.$,
        [
          domain
        ],
        false);
  }

  
  /**
   * @param { !url_mojom_Origin } sourceOrigin
   * @param { !Array<!network_mojom_CorsOriginPattern> } allowPatterns
   * @param { !Array<!network_mojom_CorsOriginPattern> } blockPatterns
   * @return {!Promise}
   */

  setCorsOriginAccessListsForOrigin(
      sourceOrigin,
      allowPatterns,
      blockPatterns) {
    return this.proxy.sendMessage(
        66,
        NetworkContext_SetCorsOriginAccessListsForOrigin_ParamsSpec.$,
        NetworkContext_SetCorsOriginAccessListsForOrigin_ResponseParamsSpec.$,
        [
          sourceOrigin,
          allowPatterns,
          blockPatterns
        ],
        false);
  }

  
  /**
   * @param { !string } host
   * @return {!Promise<{
        result: !boolean,
   *  }>}
   */

  deleteDynamicDataForHost(
      host) {
    return this.proxy.sendMessage(
        67,
        NetworkContext_DeleteDynamicDataForHost_ParamsSpec.$,
        NetworkContext_DeleteDynamicDataForHost_ResponseParamsSpec.$,
        [
          host
        ],
        false);
  }

  
  /**
   * @param { !boolean } splitAuthCacheByNetworkAnonymizationKey
   */

  setSplitAuthCacheByNetworkAnonymizationKey(
      splitAuthCacheByNetworkAnonymizationKey) {
    this.proxy.sendMessage(
        68,
        NetworkContext_SetSplitAuthCacheByNetworkAnonymizationKey_ParamsSpec.$,
        null,
        [
          splitAuthCacheByNetworkAnonymizationKey
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        cacheKey: !mojoBase_mojom_UnguessableToken,
   *  }>}
   */

  saveHttpAuthCacheProxyEntries() {
    return this.proxy.sendMessage(
        69,
        NetworkContext_SaveHttpAuthCacheProxyEntries_ParamsSpec.$,
        NetworkContext_SaveHttpAuthCacheProxyEntries_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_UnguessableToken } cacheKey
   * @return {!Promise}
   */

  loadHttpAuthCacheProxyEntries(
      cacheKey) {
    return this.proxy.sendMessage(
        70,
        NetworkContext_LoadHttpAuthCacheProxyEntries_ParamsSpec.$,
        NetworkContext_LoadHttpAuthCacheProxyEntries_ResponseParamsSpec.$,
        [
          cacheKey
        ],
        false);
  }

  
  /**
   * @param { !network_mojom_AuthChallengeInfo } challenge
   * @param { !network_mojom_NetworkAnonymizationKey } networkAnonymizationKey
   * @param { !network_mojom_AuthCredentials } credentials
   * @return {!Promise}
   */

  addAuthCacheEntry(
      challenge,
      networkAnonymizationKey,
      credentials) {
    return this.proxy.sendMessage(
        71,
        NetworkContext_AddAuthCacheEntry_ParamsSpec.$,
        NetworkContext_AddAuthCacheEntry_ResponseParamsSpec.$,
        [
          challenge,
          networkAnonymizationKey,
          credentials
        ],
        false);
  }

  
  /**
   * @param { !boolean } value
   */

  setCorsNonWildcardRequestHeadersSupport(
      value) {
    this.proxy.sendMessage(
        72,
        NetworkContext_SetCorsNonWildcardRequestHeadersSupport_ParamsSpec.$,
        null,
        [
          value
        ],
        false);
  }

  
  /**
   * @param { !network_mojom_ProxyServer } proxyServer
   * @param { !string } authScheme
   * @param { !string } realm
   * @return {!Promise<{
        credentials: ?network_mojom_AuthCredentials,
   *  }>}
   */

  lookupProxyAuthCredentials(
      proxyServer,
      authScheme,
      realm) {
    return this.proxy.sendMessage(
        73,
        NetworkContext_LookupProxyAuthCredentials_ParamsSpec.$,
        NetworkContext_LookupProxyAuthCredentials_ResponseParamsSpec.$,
        [
          proxyServer,
          authScheme,
          realm
        ],
        false);
  }

  
  /**
   * @return {!Promise}
   */

  enableStaticKeyPinningForTesting() {
    return this.proxy.sendMessage(
        74,
        NetworkContext_EnableStaticKeyPinningForTesting_ParamsSpec.$,
        NetworkContext_EnableStaticKeyPinningForTesting_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !network_mojom_X509Certificate } certificate
   * @param { !string } hostname
   * @param { !string } ocspResponse
   * @param { !string } sctList
   * @return {!Promise<{
        errorCode: !number,
   *  }>}
   */

  verifyCertificateForTesting(
      certificate,
      hostname,
      ocspResponse,
      sctList) {
    return this.proxy.sendMessage(
        75,
        NetworkContext_VerifyCertificateForTesting_ParamsSpec.$,
        NetworkContext_VerifyCertificateForTesting_ResponseParamsSpec.$,
        [
          certificate,
          hostname,
          ocspResponse,
          sctList
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        trustAnchorIds: !Array<!Array<!number>>,
   *  }>}
   */

  getTrustAnchorIDsForTesting() {
    return this.proxy.sendMessage(
        76,
        NetworkContext_GetTrustAnchorIDsForTesting_ParamsSpec.$,
        NetworkContext_GetTrustAnchorIDsForTesting_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !url_mojom_Origin } origin
   * @param { !url_mojom_Url } uploadUrl
   * @return {!Promise}
   */

  addDomainReliabilityContextForTesting(
      origin,
      uploadUrl) {
    return this.proxy.sendMessage(
        77,
        NetworkContext_AddDomainReliabilityContextForTesting_ParamsSpec.$,
        NetworkContext_AddDomainReliabilityContextForTesting_ResponseParamsSpec.$,
        [
          origin,
          uploadUrl
        ],
        false);
  }

  
  /**
   * @return {!Promise}
   */

  forceDomainReliabilityUploadsForTesting() {
    return this.proxy.sendMessage(
        78,
        NetworkContext_ForceDomainReliabilityUploadsForTesting_ParamsSpec.$,
        NetworkContext_ForceDomainReliabilityUploadsForTesting_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !SCTAuditingMode } mode
   */

  setSCTAuditingMode(
      mode) {
    this.proxy.sendMessage(
        79,
        NetworkContext_SetSCTAuditingMode_ParamsSpec.$,
        null,
        [
          mode
        ],
        false);
  }

  
  /**
   * @param { !network_mojom_ReportingApiObserverRemote } observer
   */

  addReportingApiObserver(
      observer) {
    this.proxy.sendMessage(
        80,
        NetworkContext_AddReportingApiObserver_ParamsSpec.$,
        null,
        [
          observer
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        usageInfo: !Array<!network_mojom_SharedDictionaryUsageInfo>,
   *  }>}
   */

  getSharedDictionaryUsageInfo() {
    return this.proxy.sendMessage(
        81,
        NetworkContext_GetSharedDictionaryUsageInfo_ParamsSpec.$,
        NetworkContext_GetSharedDictionaryUsageInfo_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !network_mojom_SharedDictionaryIsolationKey } isolationKey
   * @return {!Promise<{
        dictionaries: !Array<!SharedDictionaryInfo>,
   *  }>}
   */

  getSharedDictionaryInfo(
      isolationKey) {
    return this.proxy.sendMessage(
        82,
        NetworkContext_GetSharedDictionaryInfo_ParamsSpec.$,
        NetworkContext_GetSharedDictionaryInfo_ResponseParamsSpec.$,
        [
          isolationKey
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_Time } startTime
   * @param { !mojoBase_mojom_Time } endTime
   * @return {!Promise<{
        origins: !Array<!url_mojom_Origin>,
   *  }>}
   */

  getSharedDictionaryOriginsBetween(
      startTime,
      endTime) {
    return this.proxy.sendMessage(
        83,
        NetworkContext_GetSharedDictionaryOriginsBetween_ParamsSpec.$,
        NetworkContext_GetSharedDictionaryOriginsBetween_ResponseParamsSpec.$,
        [
          startTime,
          endTime
        ],
        false);
  }

  
  /**
   * @param { !bigint } cacheMaxSize
   */

  setSharedDictionaryCacheMaxSize(
      cacheMaxSize) {
    this.proxy.sendMessage(
        84,
        NetworkContext_SetSharedDictionaryCacheMaxSize_ParamsSpec.$,
        null,
        [
          cacheMaxSize
        ],
        false);
  }

  
  /**
   * @param { !Array<!url_mojom_Url> } urls
   * @param { !PreloadedSharedDictionaryInfoHandlePendingReceiver } preloadHandle
   */

  preloadSharedDictionaryInfoForDocument(
      urls,
      preloadHandle) {
    this.proxy.sendMessage(
        85,
        NetworkContext_PreloadSharedDictionaryInfoForDocument_ParamsSpec.$,
        null,
        [
          urls,
          preloadHandle
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        value: !boolean,
   *  }>}
   */

  hasPreloadedSharedDictionaryInfoForTesting() {
    return this.proxy.sendMessage(
        86,
        NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_ParamsSpec.$,
        NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !network_mojom_HostPortPair } host
   * @param { !network_mojom_X509Certificate } certificate
   */

  flushCachedClientCertIfNeeded(
      host,
      certificate) {
    this.proxy.sendMessage(
        87,
        NetworkContext_FlushCachedClientCertIfNeeded_ParamsSpec.$,
        null,
        [
          host,
          certificate
        ],
        false);
  }

  
  /**
   * @param { !network_mojom_X509Certificate } certificate
   */

  flushMatchingCachedClientCert(
      certificate) {
    this.proxy.sendMessage(
        88,
        NetworkContext_FlushMatchingCachedClientCert_ParamsSpec.$,
        null,
        [
          certificate
        ],
        false);
  }

  
  /**
   * @param { ?string } label
   */

  setCookieDeprecationLabel(
      label) {
    this.proxy.sendMessage(
        89,
        NetworkContext_SetCookieDeprecationLabel_ParamsSpec.$,
        null,
        [
          label
        ],
        false);
  }

  
  /**
   * @param { !Array<!mojoBase_mojom_UnguessableToken> } nonces
   * @return {!Promise}
   */

  revokeNetworkForNonces(
      nonces) {
    return this.proxy.sendMessage(
        90,
        NetworkContext_RevokeNetworkForNonces_ParamsSpec.$,
        NetworkContext_RevokeNetworkForNonces_ResponseParamsSpec.$,
        [
          nonces
        ],
        false);
  }

  
  /**
   * @param { !Array<!mojoBase_mojom_UnguessableToken> } nonces
   */

  clearNonces(
      nonces) {
    this.proxy.sendMessage(
        91,
        NetworkContext_ClearNonces_ParamsSpec.$,
        null,
        [
          nonces
        ],
        false);
  }

  
  /**
   * @param { !url_mojom_Url } exemptedUrl
   * @param { !mojoBase_mojom_UnguessableToken } nonce
   * @return {!Promise}
   */

  exemptUrlFromNetworkRevocationForNonce(
      exemptedUrl,
      nonce) {
    return this.proxy.sendMessage(
        92,
        NetworkContext_ExemptUrlFromNetworkRevocationForNonce_ParamsSpec.$,
        NetworkContext_ExemptUrlFromNetworkRevocationForNonce_ResponseParamsSpec.$,
        [
          exemptedUrl,
          nonce
        ],
        false);
  }

  
  /**
   * @param { !number } requestId
   * @param { !number } options
   * @param { !network_mojom_URLRequest } request
   * @param { !network_mojom_MutableNetworkTrafficAnnotationTag } trafficAnnotation
   */

  prefetch(
      requestId,
      options,
      request,
      trafficAnnotation) {
    this.proxy.sendMessage(
        93,
        NetworkContext_Prefetch_ParamsSpec.$,
        null,
        [
          requestId,
          options,
          request,
          trafficAnnotation
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        boundNetwork: !bigint,
   *  }>}
   */

  getBoundNetworkForTesting() {
    return this.proxy.sendMessage(
        94,
        NetworkContext_GetBoundNetworkForTesting_ParamsSpec.$,
        NetworkContext_GetBoundNetworkForTesting_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !network_mojom_DeviceBoundSessionManagerPendingReceiver } deviceBoundSessionManager
   */

  getDeviceBoundSessionManager(
      deviceBoundSessionManager) {
    this.proxy.sendMessage(
        95,
        NetworkContext_GetDeviceBoundSessionManager_ParamsSpec.$,
        null,
        [
          deviceBoundSessionManager
        ],
        false);
  }

  
  /**
   * @param { !Array<!url_mojom_SchemeHostPort> } origins
   * @param { !network_mojom_NetworkAnonymizationKey } networkAnonymizationKey
   */

  addQuicHints(
      origins,
      networkAnonymizationKey) {
    this.proxy.sendMessage(
        96,
        NetworkContext_AddQuicHints_ParamsSpec.$,
        null,
        [
          origins,
          networkAnonymizationKey
        ],
        false);
  }
}

/**
 * An object which receives request messages for the NetworkContext
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class NetworkContextReceiver {
  /**
   * @param {!NetworkContextInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!NetworkContextRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        NetworkContextRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!NetworkContextRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        NetworkContext_SetClient_ParamsSpec.$,
        null,
        impl.setClient.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        NetworkContext_CreateURLLoaderFactory_ParamsSpec.$,
        null,
        impl.createURLLoaderFactory.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        NetworkContext_ResetURLLoaderFactories_ParamsSpec.$,
        null,
        impl.resetURLLoaderFactories.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        NetworkContext_GetViaObliviousHttp_ParamsSpec.$,
        null,
        impl.getViaObliviousHttp.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        NetworkContext_GetCookieManager_ParamsSpec.$,
        null,
        impl.getCookieManager.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        NetworkContext_GetRestrictedCookieManager_ParamsSpec.$,
        null,
        impl.getRestrictedCookieManager.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        NetworkContext_GetTrustTokenQueryAnswerer_ParamsSpec.$,
        null,
        impl.getTrustTokenQueryAnswerer.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        NetworkContext_ClearTrustTokenData_ParamsSpec.$,
        NetworkContext_ClearTrustTokenData_ResponseParamsSpec.$,
        impl.clearTrustTokenData.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        NetworkContext_ClearTrustTokenSessionOnlyData_ParamsSpec.$,
        NetworkContext_ClearTrustTokenSessionOnlyData_ResponseParamsSpec.$,
        impl.clearTrustTokenSessionOnlyData.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        NetworkContext_GetStoredTrustTokenCounts_ParamsSpec.$,
        NetworkContext_GetStoredTrustTokenCounts_ResponseParamsSpec.$,
        impl.getStoredTrustTokenCounts.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        NetworkContext_GetPrivateStateTokenRedemptionRecords_ParamsSpec.$,
        NetworkContext_GetPrivateStateTokenRedemptionRecords_ResponseParamsSpec.$,
        impl.getPrivateStateTokenRedemptionRecords.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        NetworkContext_GetIpProxyStatus_ParamsSpec.$,
        NetworkContext_GetIpProxyStatus_ResponseParamsSpec.$,
        impl.getIpProxyStatus.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        NetworkContext_SetBypassIpProtectionProxy_ParamsSpec.$,
        null,
        impl.setBypassIpProtectionProxy.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        13,
        NetworkContext_DeleteStoredTrustTokens_ParamsSpec.$,
        NetworkContext_DeleteStoredTrustTokens_ResponseParamsSpec.$,
        impl.deleteStoredTrustTokens.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        14,
        NetworkContext_SetBlockTrustTokens_ParamsSpec.$,
        null,
        impl.setBlockTrustTokens.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        15,
        NetworkContext_SetTrackingProtectionContentSetting_ParamsSpec.$,
        null,
        impl.setTrackingProtectionContentSetting.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        16,
        NetworkContext_ClearNetworkingHistoryBetween_ParamsSpec.$,
        NetworkContext_ClearNetworkingHistoryBetween_ResponseParamsSpec.$,
        impl.clearNetworkingHistoryBetween.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        17,
        NetworkContext_ClearHttpCache_ParamsSpec.$,
        NetworkContext_ClearHttpCache_ResponseParamsSpec.$,
        impl.clearHttpCache.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        18,
        NetworkContext_ComputeHttpCacheSize_ParamsSpec.$,
        NetworkContext_ComputeHttpCacheSize_ResponseParamsSpec.$,
        impl.computeHttpCacheSize.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        19,
        NetworkContext_NotifyBrowserIdle_ParamsSpec.$,
        null,
        impl.notifyBrowserIdle.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        20,
        NetworkContext_NotifyExternalCacheHit_ParamsSpec.$,
        null,
        impl.notifyExternalCacheHit.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        21,
        NetworkContext_ClearHostCache_ParamsSpec.$,
        NetworkContext_ClearHostCache_ResponseParamsSpec.$,
        impl.clearHostCache.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        22,
        NetworkContext_ClearHttpAuthCache_ParamsSpec.$,
        NetworkContext_ClearHttpAuthCache_ResponseParamsSpec.$,
        impl.clearHttpAuthCache.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        23,
        NetworkContext_ClearCorsPreflightCache_ParamsSpec.$,
        NetworkContext_ClearCorsPreflightCache_ResponseParamsSpec.$,
        impl.clearCorsPreflightCache.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        24,
        NetworkContext_ClearReportingCacheReports_ParamsSpec.$,
        NetworkContext_ClearReportingCacheReports_ResponseParamsSpec.$,
        impl.clearReportingCacheReports.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        25,
        NetworkContext_ClearReportingCacheClients_ParamsSpec.$,
        NetworkContext_ClearReportingCacheClients_ResponseParamsSpec.$,
        impl.clearReportingCacheClients.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        26,
        NetworkContext_ClearNetworkErrorLogging_ParamsSpec.$,
        NetworkContext_ClearNetworkErrorLogging_ResponseParamsSpec.$,
        impl.clearNetworkErrorLogging.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        27,
        NetworkContext_ClearDomainReliability_ParamsSpec.$,
        NetworkContext_ClearDomainReliability_ResponseParamsSpec.$,
        impl.clearDomainReliability.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        28,
        NetworkContext_ClearSharedDictionaryCache_ParamsSpec.$,
        NetworkContext_ClearSharedDictionaryCache_ResponseParamsSpec.$,
        impl.clearSharedDictionaryCache.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        29,
        NetworkContext_ClearSharedDictionaryCacheForIsolationKey_ParamsSpec.$,
        NetworkContext_ClearSharedDictionaryCacheForIsolationKey_ResponseParamsSpec.$,
        impl.clearSharedDictionaryCacheForIsolationKey.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        30,
        NetworkContext_SetDocumentReportingEndpoints_ParamsSpec.$,
        null,
        impl.setDocumentReportingEndpoints.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        31,
        NetworkContext_SetEnterpriseReportingEndpoints_ParamsSpec.$,
        null,
        impl.setEnterpriseReportingEndpoints.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        32,
        NetworkContext_SendReportsAndRemoveSource_ParamsSpec.$,
        null,
        impl.sendReportsAndRemoveSource.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        33,
        NetworkContext_QueueReport_ParamsSpec.$,
        null,
        impl.queueReport.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        34,
        NetworkContext_QueueEnterpriseReport_ParamsSpec.$,
        null,
        impl.queueEnterpriseReport.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        35,
        NetworkContext_QueueSignedExchangeReport_ParamsSpec.$,
        null,
        impl.queueSignedExchangeReport.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        36,
        NetworkContext_CloseAllConnections_ParamsSpec.$,
        NetworkContext_CloseAllConnections_ResponseParamsSpec.$,
        impl.closeAllConnections.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        37,
        NetworkContext_CloseIdleConnections_ParamsSpec.$,
        NetworkContext_CloseIdleConnections_ResponseParamsSpec.$,
        impl.closeIdleConnections.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        38,
        NetworkContext_SetNetworkConditions_ParamsSpec.$,
        null,
        impl.setNetworkConditions.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        39,
        NetworkContext_EnableDurableMessageCollector_ParamsSpec.$,
        null,
        impl.enableDurableMessageCollector.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        40,
        NetworkContext_SetAcceptLanguage_ParamsSpec.$,
        null,
        impl.setAcceptLanguage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        41,
        NetworkContext_SetEnableReferrers_ParamsSpec.$,
        null,
        impl.setEnableReferrers.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        42,
        NetworkContext_SetCTPolicy_ParamsSpec.$,
        null,
        impl.setCTPolicy.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        43,
        NetworkContext_CreateUDPSocket_ParamsSpec.$,
        null,
        impl.createUDPSocket.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        44,
        NetworkContext_CreateRestrictedUDPSocket_ParamsSpec.$,
        NetworkContext_CreateRestrictedUDPSocket_ResponseParamsSpec.$,
        impl.createRestrictedUDPSocket.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        45,
        NetworkContext_CreateTCPServerSocket_ParamsSpec.$,
        NetworkContext_CreateTCPServerSocket_ResponseParamsSpec.$,
        impl.createTCPServerSocket.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        46,
        NetworkContext_CreateTCPConnectedSocket_ParamsSpec.$,
        NetworkContext_CreateTCPConnectedSocket_ResponseParamsSpec.$,
        impl.createTCPConnectedSocket.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        47,
        NetworkContext_CreateTCPBoundSocket_ParamsSpec.$,
        NetworkContext_CreateTCPBoundSocket_ResponseParamsSpec.$,
        impl.createTCPBoundSocket.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        48,
        NetworkContext_CreateProxyResolvingSocketFactory_ParamsSpec.$,
        null,
        impl.createProxyResolvingSocketFactory.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        49,
        NetworkContext_LookUpProxyForURL_ParamsSpec.$,
        null,
        impl.lookUpProxyForURL.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        50,
        NetworkContext_ForceReloadProxyConfig_ParamsSpec.$,
        NetworkContext_ForceReloadProxyConfig_ResponseParamsSpec.$,
        impl.forceReloadProxyConfig.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        51,
        NetworkContext_ClearBadProxiesCache_ParamsSpec.$,
        NetworkContext_ClearBadProxiesCache_ResponseParamsSpec.$,
        impl.clearBadProxiesCache.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        52,
        NetworkContext_CreateWebSocket_ParamsSpec.$,
        null,
        impl.createWebSocket.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        53,
        NetworkContext_CreateWebTransport_ParamsSpec.$,
        null,
        impl.createWebTransport.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        54,
        NetworkContext_CreateNetLogExporter_ParamsSpec.$,
        null,
        impl.createNetLogExporter.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        55,
        NetworkContext_PreconnectSockets_ParamsSpec.$,
        null,
        impl.preconnectSockets.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        56,
        NetworkContext_CreateP2PSocketManager_ParamsSpec.$,
        null,
        impl.createP2PSocketManager.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        57,
        NetworkContext_CreateMdnsResponder_ParamsSpec.$,
        null,
        impl.createMdnsResponder.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        58,
        NetworkContext_ResolveHost_ParamsSpec.$,
        null,
        impl.resolveHost.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        59,
        NetworkContext_CreateHostResolver_ParamsSpec.$,
        null,
        impl.createHostResolver.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        60,
        NetworkContext_VerifyCert_ParamsSpec.$,
        NetworkContext_VerifyCert_ResponseParamsSpec.$,
        impl.verifyCert.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        61,
        NetworkContext_VerifyCertForSignedExchange_ParamsSpec.$,
        NetworkContext_VerifyCertForSignedExchange_ResponseParamsSpec.$,
        impl.verifyCertForSignedExchange.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        62,
        NetworkContext_Verify2QwacCertBinding_ParamsSpec.$,
        NetworkContext_Verify2QwacCertBinding_ResponseParamsSpec.$,
        impl.verify2QwacCertBinding.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        63,
        NetworkContext_AddHSTS_ParamsSpec.$,
        NetworkContext_AddHSTS_ResponseParamsSpec.$,
        impl.addHSTS.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        64,
        NetworkContext_IsHSTSActiveForHost_ParamsSpec.$,
        NetworkContext_IsHSTSActiveForHost_ResponseParamsSpec.$,
        impl.isHSTSActiveForHost.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        65,
        NetworkContext_GetHSTSState_ParamsSpec.$,
        NetworkContext_GetHSTSState_ResponseParamsSpec.$,
        impl.getHSTSState.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        66,
        NetworkContext_SetCorsOriginAccessListsForOrigin_ParamsSpec.$,
        NetworkContext_SetCorsOriginAccessListsForOrigin_ResponseParamsSpec.$,
        impl.setCorsOriginAccessListsForOrigin.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        67,
        NetworkContext_DeleteDynamicDataForHost_ParamsSpec.$,
        NetworkContext_DeleteDynamicDataForHost_ResponseParamsSpec.$,
        impl.deleteDynamicDataForHost.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        68,
        NetworkContext_SetSplitAuthCacheByNetworkAnonymizationKey_ParamsSpec.$,
        null,
        impl.setSplitAuthCacheByNetworkAnonymizationKey.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        69,
        NetworkContext_SaveHttpAuthCacheProxyEntries_ParamsSpec.$,
        NetworkContext_SaveHttpAuthCacheProxyEntries_ResponseParamsSpec.$,
        impl.saveHttpAuthCacheProxyEntries.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        70,
        NetworkContext_LoadHttpAuthCacheProxyEntries_ParamsSpec.$,
        NetworkContext_LoadHttpAuthCacheProxyEntries_ResponseParamsSpec.$,
        impl.loadHttpAuthCacheProxyEntries.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        71,
        NetworkContext_AddAuthCacheEntry_ParamsSpec.$,
        NetworkContext_AddAuthCacheEntry_ResponseParamsSpec.$,
        impl.addAuthCacheEntry.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        72,
        NetworkContext_SetCorsNonWildcardRequestHeadersSupport_ParamsSpec.$,
        null,
        impl.setCorsNonWildcardRequestHeadersSupport.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        73,
        NetworkContext_LookupProxyAuthCredentials_ParamsSpec.$,
        NetworkContext_LookupProxyAuthCredentials_ResponseParamsSpec.$,
        impl.lookupProxyAuthCredentials.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        74,
        NetworkContext_EnableStaticKeyPinningForTesting_ParamsSpec.$,
        NetworkContext_EnableStaticKeyPinningForTesting_ResponseParamsSpec.$,
        impl.enableStaticKeyPinningForTesting.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        75,
        NetworkContext_VerifyCertificateForTesting_ParamsSpec.$,
        NetworkContext_VerifyCertificateForTesting_ResponseParamsSpec.$,
        impl.verifyCertificateForTesting.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        76,
        NetworkContext_GetTrustAnchorIDsForTesting_ParamsSpec.$,
        NetworkContext_GetTrustAnchorIDsForTesting_ResponseParamsSpec.$,
        impl.getTrustAnchorIDsForTesting.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        77,
        NetworkContext_AddDomainReliabilityContextForTesting_ParamsSpec.$,
        NetworkContext_AddDomainReliabilityContextForTesting_ResponseParamsSpec.$,
        impl.addDomainReliabilityContextForTesting.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        78,
        NetworkContext_ForceDomainReliabilityUploadsForTesting_ParamsSpec.$,
        NetworkContext_ForceDomainReliabilityUploadsForTesting_ResponseParamsSpec.$,
        impl.forceDomainReliabilityUploadsForTesting.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        79,
        NetworkContext_SetSCTAuditingMode_ParamsSpec.$,
        null,
        impl.setSCTAuditingMode.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        80,
        NetworkContext_AddReportingApiObserver_ParamsSpec.$,
        null,
        impl.addReportingApiObserver.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        81,
        NetworkContext_GetSharedDictionaryUsageInfo_ParamsSpec.$,
        NetworkContext_GetSharedDictionaryUsageInfo_ResponseParamsSpec.$,
        impl.getSharedDictionaryUsageInfo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        82,
        NetworkContext_GetSharedDictionaryInfo_ParamsSpec.$,
        NetworkContext_GetSharedDictionaryInfo_ResponseParamsSpec.$,
        impl.getSharedDictionaryInfo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        83,
        NetworkContext_GetSharedDictionaryOriginsBetween_ParamsSpec.$,
        NetworkContext_GetSharedDictionaryOriginsBetween_ResponseParamsSpec.$,
        impl.getSharedDictionaryOriginsBetween.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        84,
        NetworkContext_SetSharedDictionaryCacheMaxSize_ParamsSpec.$,
        null,
        impl.setSharedDictionaryCacheMaxSize.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        85,
        NetworkContext_PreloadSharedDictionaryInfoForDocument_ParamsSpec.$,
        null,
        impl.preloadSharedDictionaryInfoForDocument.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        86,
        NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_ParamsSpec.$,
        NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_ResponseParamsSpec.$,
        impl.hasPreloadedSharedDictionaryInfoForTesting.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        87,
        NetworkContext_FlushCachedClientCertIfNeeded_ParamsSpec.$,
        null,
        impl.flushCachedClientCertIfNeeded.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        88,
        NetworkContext_FlushMatchingCachedClientCert_ParamsSpec.$,
        null,
        impl.flushMatchingCachedClientCert.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        89,
        NetworkContext_SetCookieDeprecationLabel_ParamsSpec.$,
        null,
        impl.setCookieDeprecationLabel.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        90,
        NetworkContext_RevokeNetworkForNonces_ParamsSpec.$,
        NetworkContext_RevokeNetworkForNonces_ResponseParamsSpec.$,
        impl.revokeNetworkForNonces.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        91,
        NetworkContext_ClearNonces_ParamsSpec.$,
        null,
        impl.clearNonces.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        92,
        NetworkContext_ExemptUrlFromNetworkRevocationForNonce_ParamsSpec.$,
        NetworkContext_ExemptUrlFromNetworkRevocationForNonce_ResponseParamsSpec.$,
        impl.exemptUrlFromNetworkRevocationForNonce.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        93,
        NetworkContext_Prefetch_ParamsSpec.$,
        null,
        impl.prefetch.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        94,
        NetworkContext_GetBoundNetworkForTesting_ParamsSpec.$,
        NetworkContext_GetBoundNetworkForTesting_ResponseParamsSpec.$,
        impl.getBoundNetworkForTesting.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        95,
        NetworkContext_GetDeviceBoundSessionManager_ParamsSpec.$,
        null,
        impl.getDeviceBoundSessionManager.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        96,
        NetworkContext_AddQuicHints_ParamsSpec.$,
        null,
        impl.addQuicHints.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class NetworkContext {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.NetworkContext";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!NetworkContextRemote}
   */
  static getRemote() {
    let remote = new NetworkContextRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const NetworkContext_DomainReliabilityClearModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const NetworkContext_DomainReliabilityClearMode = {
  
  CLEAR_CONTEXTS: 0,
  CLEAR_BEACONS: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

/**
 * An object which receives request messages for the NetworkContext
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class NetworkContextCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      NetworkContextRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!NetworkContextRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setClient =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        NetworkContext_SetClient_ParamsSpec.$,
        null,
        this.setClient.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createURLLoaderFactory =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        NetworkContext_CreateURLLoaderFactory_ParamsSpec.$,
        null,
        this.createURLLoaderFactory.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.resetURLLoaderFactories =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        NetworkContext_ResetURLLoaderFactories_ParamsSpec.$,
        null,
        this.resetURLLoaderFactories.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getViaObliviousHttp =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        NetworkContext_GetViaObliviousHttp_ParamsSpec.$,
        null,
        this.getViaObliviousHttp.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getCookieManager =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        NetworkContext_GetCookieManager_ParamsSpec.$,
        null,
        this.getCookieManager.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getRestrictedCookieManager =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        NetworkContext_GetRestrictedCookieManager_ParamsSpec.$,
        null,
        this.getRestrictedCookieManager.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getTrustTokenQueryAnswerer =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        NetworkContext_GetTrustTokenQueryAnswerer_ParamsSpec.$,
        null,
        this.getTrustTokenQueryAnswerer.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clearTrustTokenData =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        NetworkContext_ClearTrustTokenData_ParamsSpec.$,
        NetworkContext_ClearTrustTokenData_ResponseParamsSpec.$,
        this.clearTrustTokenData.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clearTrustTokenSessionOnlyData =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        NetworkContext_ClearTrustTokenSessionOnlyData_ParamsSpec.$,
        NetworkContext_ClearTrustTokenSessionOnlyData_ResponseParamsSpec.$,
        this.clearTrustTokenSessionOnlyData.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getStoredTrustTokenCounts =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        NetworkContext_GetStoredTrustTokenCounts_ParamsSpec.$,
        NetworkContext_GetStoredTrustTokenCounts_ResponseParamsSpec.$,
        this.getStoredTrustTokenCounts.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getPrivateStateTokenRedemptionRecords =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        NetworkContext_GetPrivateStateTokenRedemptionRecords_ParamsSpec.$,
        NetworkContext_GetPrivateStateTokenRedemptionRecords_ResponseParamsSpec.$,
        this.getPrivateStateTokenRedemptionRecords.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getIpProxyStatus =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        NetworkContext_GetIpProxyStatus_ParamsSpec.$,
        NetworkContext_GetIpProxyStatus_ResponseParamsSpec.$,
        this.getIpProxyStatus.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setBypassIpProtectionProxy =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        NetworkContext_SetBypassIpProtectionProxy_ParamsSpec.$,
        null,
        this.setBypassIpProtectionProxy.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.deleteStoredTrustTokens =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        13,
        NetworkContext_DeleteStoredTrustTokens_ParamsSpec.$,
        NetworkContext_DeleteStoredTrustTokens_ResponseParamsSpec.$,
        this.deleteStoredTrustTokens.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setBlockTrustTokens =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        14,
        NetworkContext_SetBlockTrustTokens_ParamsSpec.$,
        null,
        this.setBlockTrustTokens.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setTrackingProtectionContentSetting =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        15,
        NetworkContext_SetTrackingProtectionContentSetting_ParamsSpec.$,
        null,
        this.setTrackingProtectionContentSetting.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clearNetworkingHistoryBetween =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        16,
        NetworkContext_ClearNetworkingHistoryBetween_ParamsSpec.$,
        NetworkContext_ClearNetworkingHistoryBetween_ResponseParamsSpec.$,
        this.clearNetworkingHistoryBetween.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clearHttpCache =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        17,
        NetworkContext_ClearHttpCache_ParamsSpec.$,
        NetworkContext_ClearHttpCache_ResponseParamsSpec.$,
        this.clearHttpCache.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.computeHttpCacheSize =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        18,
        NetworkContext_ComputeHttpCacheSize_ParamsSpec.$,
        NetworkContext_ComputeHttpCacheSize_ResponseParamsSpec.$,
        this.computeHttpCacheSize.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.notifyBrowserIdle =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        19,
        NetworkContext_NotifyBrowserIdle_ParamsSpec.$,
        null,
        this.notifyBrowserIdle.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.notifyExternalCacheHit =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        20,
        NetworkContext_NotifyExternalCacheHit_ParamsSpec.$,
        null,
        this.notifyExternalCacheHit.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clearHostCache =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        21,
        NetworkContext_ClearHostCache_ParamsSpec.$,
        NetworkContext_ClearHostCache_ResponseParamsSpec.$,
        this.clearHostCache.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clearHttpAuthCache =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        22,
        NetworkContext_ClearHttpAuthCache_ParamsSpec.$,
        NetworkContext_ClearHttpAuthCache_ResponseParamsSpec.$,
        this.clearHttpAuthCache.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clearCorsPreflightCache =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        23,
        NetworkContext_ClearCorsPreflightCache_ParamsSpec.$,
        NetworkContext_ClearCorsPreflightCache_ResponseParamsSpec.$,
        this.clearCorsPreflightCache.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clearReportingCacheReports =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        24,
        NetworkContext_ClearReportingCacheReports_ParamsSpec.$,
        NetworkContext_ClearReportingCacheReports_ResponseParamsSpec.$,
        this.clearReportingCacheReports.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clearReportingCacheClients =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        25,
        NetworkContext_ClearReportingCacheClients_ParamsSpec.$,
        NetworkContext_ClearReportingCacheClients_ResponseParamsSpec.$,
        this.clearReportingCacheClients.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clearNetworkErrorLogging =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        26,
        NetworkContext_ClearNetworkErrorLogging_ParamsSpec.$,
        NetworkContext_ClearNetworkErrorLogging_ResponseParamsSpec.$,
        this.clearNetworkErrorLogging.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clearDomainReliability =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        27,
        NetworkContext_ClearDomainReliability_ParamsSpec.$,
        NetworkContext_ClearDomainReliability_ResponseParamsSpec.$,
        this.clearDomainReliability.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clearSharedDictionaryCache =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        28,
        NetworkContext_ClearSharedDictionaryCache_ParamsSpec.$,
        NetworkContext_ClearSharedDictionaryCache_ResponseParamsSpec.$,
        this.clearSharedDictionaryCache.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clearSharedDictionaryCacheForIsolationKey =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        29,
        NetworkContext_ClearSharedDictionaryCacheForIsolationKey_ParamsSpec.$,
        NetworkContext_ClearSharedDictionaryCacheForIsolationKey_ResponseParamsSpec.$,
        this.clearSharedDictionaryCacheForIsolationKey.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setDocumentReportingEndpoints =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        30,
        NetworkContext_SetDocumentReportingEndpoints_ParamsSpec.$,
        null,
        this.setDocumentReportingEndpoints.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setEnterpriseReportingEndpoints =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        31,
        NetworkContext_SetEnterpriseReportingEndpoints_ParamsSpec.$,
        null,
        this.setEnterpriseReportingEndpoints.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.sendReportsAndRemoveSource =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        32,
        NetworkContext_SendReportsAndRemoveSource_ParamsSpec.$,
        null,
        this.sendReportsAndRemoveSource.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.queueReport =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        33,
        NetworkContext_QueueReport_ParamsSpec.$,
        null,
        this.queueReport.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.queueEnterpriseReport =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        34,
        NetworkContext_QueueEnterpriseReport_ParamsSpec.$,
        null,
        this.queueEnterpriseReport.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.queueSignedExchangeReport =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        35,
        NetworkContext_QueueSignedExchangeReport_ParamsSpec.$,
        null,
        this.queueSignedExchangeReport.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.closeAllConnections =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        36,
        NetworkContext_CloseAllConnections_ParamsSpec.$,
        NetworkContext_CloseAllConnections_ResponseParamsSpec.$,
        this.closeAllConnections.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.closeIdleConnections =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        37,
        NetworkContext_CloseIdleConnections_ParamsSpec.$,
        NetworkContext_CloseIdleConnections_ResponseParamsSpec.$,
        this.closeIdleConnections.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setNetworkConditions =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        38,
        NetworkContext_SetNetworkConditions_ParamsSpec.$,
        null,
        this.setNetworkConditions.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.enableDurableMessageCollector =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        39,
        NetworkContext_EnableDurableMessageCollector_ParamsSpec.$,
        null,
        this.enableDurableMessageCollector.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setAcceptLanguage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        40,
        NetworkContext_SetAcceptLanguage_ParamsSpec.$,
        null,
        this.setAcceptLanguage.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setEnableReferrers =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        41,
        NetworkContext_SetEnableReferrers_ParamsSpec.$,
        null,
        this.setEnableReferrers.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setCTPolicy =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        42,
        NetworkContext_SetCTPolicy_ParamsSpec.$,
        null,
        this.setCTPolicy.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createUDPSocket =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        43,
        NetworkContext_CreateUDPSocket_ParamsSpec.$,
        null,
        this.createUDPSocket.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createRestrictedUDPSocket =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        44,
        NetworkContext_CreateRestrictedUDPSocket_ParamsSpec.$,
        NetworkContext_CreateRestrictedUDPSocket_ResponseParamsSpec.$,
        this.createRestrictedUDPSocket.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createTCPServerSocket =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        45,
        NetworkContext_CreateTCPServerSocket_ParamsSpec.$,
        NetworkContext_CreateTCPServerSocket_ResponseParamsSpec.$,
        this.createTCPServerSocket.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createTCPConnectedSocket =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        46,
        NetworkContext_CreateTCPConnectedSocket_ParamsSpec.$,
        NetworkContext_CreateTCPConnectedSocket_ResponseParamsSpec.$,
        this.createTCPConnectedSocket.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createTCPBoundSocket =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        47,
        NetworkContext_CreateTCPBoundSocket_ParamsSpec.$,
        NetworkContext_CreateTCPBoundSocket_ResponseParamsSpec.$,
        this.createTCPBoundSocket.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createProxyResolvingSocketFactory =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        48,
        NetworkContext_CreateProxyResolvingSocketFactory_ParamsSpec.$,
        null,
        this.createProxyResolvingSocketFactory.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.lookUpProxyForURL =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        49,
        NetworkContext_LookUpProxyForURL_ParamsSpec.$,
        null,
        this.lookUpProxyForURL.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.forceReloadProxyConfig =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        50,
        NetworkContext_ForceReloadProxyConfig_ParamsSpec.$,
        NetworkContext_ForceReloadProxyConfig_ResponseParamsSpec.$,
        this.forceReloadProxyConfig.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clearBadProxiesCache =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        51,
        NetworkContext_ClearBadProxiesCache_ParamsSpec.$,
        NetworkContext_ClearBadProxiesCache_ResponseParamsSpec.$,
        this.clearBadProxiesCache.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createWebSocket =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        52,
        NetworkContext_CreateWebSocket_ParamsSpec.$,
        null,
        this.createWebSocket.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createWebTransport =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        53,
        NetworkContext_CreateWebTransport_ParamsSpec.$,
        null,
        this.createWebTransport.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createNetLogExporter =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        54,
        NetworkContext_CreateNetLogExporter_ParamsSpec.$,
        null,
        this.createNetLogExporter.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.preconnectSockets =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        55,
        NetworkContext_PreconnectSockets_ParamsSpec.$,
        null,
        this.preconnectSockets.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createP2PSocketManager =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        56,
        NetworkContext_CreateP2PSocketManager_ParamsSpec.$,
        null,
        this.createP2PSocketManager.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createMdnsResponder =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        57,
        NetworkContext_CreateMdnsResponder_ParamsSpec.$,
        null,
        this.createMdnsResponder.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.resolveHost =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        58,
        NetworkContext_ResolveHost_ParamsSpec.$,
        null,
        this.resolveHost.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createHostResolver =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        59,
        NetworkContext_CreateHostResolver_ParamsSpec.$,
        null,
        this.createHostResolver.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.verifyCert =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        60,
        NetworkContext_VerifyCert_ParamsSpec.$,
        NetworkContext_VerifyCert_ResponseParamsSpec.$,
        this.verifyCert.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.verifyCertForSignedExchange =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        61,
        NetworkContext_VerifyCertForSignedExchange_ParamsSpec.$,
        NetworkContext_VerifyCertForSignedExchange_ResponseParamsSpec.$,
        this.verifyCertForSignedExchange.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.verify2QwacCertBinding =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        62,
        NetworkContext_Verify2QwacCertBinding_ParamsSpec.$,
        NetworkContext_Verify2QwacCertBinding_ResponseParamsSpec.$,
        this.verify2QwacCertBinding.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addHSTS =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        63,
        NetworkContext_AddHSTS_ParamsSpec.$,
        NetworkContext_AddHSTS_ResponseParamsSpec.$,
        this.addHSTS.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.isHSTSActiveForHost =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        64,
        NetworkContext_IsHSTSActiveForHost_ParamsSpec.$,
        NetworkContext_IsHSTSActiveForHost_ResponseParamsSpec.$,
        this.isHSTSActiveForHost.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getHSTSState =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        65,
        NetworkContext_GetHSTSState_ParamsSpec.$,
        NetworkContext_GetHSTSState_ResponseParamsSpec.$,
        this.getHSTSState.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setCorsOriginAccessListsForOrigin =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        66,
        NetworkContext_SetCorsOriginAccessListsForOrigin_ParamsSpec.$,
        NetworkContext_SetCorsOriginAccessListsForOrigin_ResponseParamsSpec.$,
        this.setCorsOriginAccessListsForOrigin.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.deleteDynamicDataForHost =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        67,
        NetworkContext_DeleteDynamicDataForHost_ParamsSpec.$,
        NetworkContext_DeleteDynamicDataForHost_ResponseParamsSpec.$,
        this.deleteDynamicDataForHost.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setSplitAuthCacheByNetworkAnonymizationKey =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        68,
        NetworkContext_SetSplitAuthCacheByNetworkAnonymizationKey_ParamsSpec.$,
        null,
        this.setSplitAuthCacheByNetworkAnonymizationKey.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.saveHttpAuthCacheProxyEntries =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        69,
        NetworkContext_SaveHttpAuthCacheProxyEntries_ParamsSpec.$,
        NetworkContext_SaveHttpAuthCacheProxyEntries_ResponseParamsSpec.$,
        this.saveHttpAuthCacheProxyEntries.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.loadHttpAuthCacheProxyEntries =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        70,
        NetworkContext_LoadHttpAuthCacheProxyEntries_ParamsSpec.$,
        NetworkContext_LoadHttpAuthCacheProxyEntries_ResponseParamsSpec.$,
        this.loadHttpAuthCacheProxyEntries.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addAuthCacheEntry =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        71,
        NetworkContext_AddAuthCacheEntry_ParamsSpec.$,
        NetworkContext_AddAuthCacheEntry_ResponseParamsSpec.$,
        this.addAuthCacheEntry.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setCorsNonWildcardRequestHeadersSupport =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        72,
        NetworkContext_SetCorsNonWildcardRequestHeadersSupport_ParamsSpec.$,
        null,
        this.setCorsNonWildcardRequestHeadersSupport.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.lookupProxyAuthCredentials =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        73,
        NetworkContext_LookupProxyAuthCredentials_ParamsSpec.$,
        NetworkContext_LookupProxyAuthCredentials_ResponseParamsSpec.$,
        this.lookupProxyAuthCredentials.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.enableStaticKeyPinningForTesting =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        74,
        NetworkContext_EnableStaticKeyPinningForTesting_ParamsSpec.$,
        NetworkContext_EnableStaticKeyPinningForTesting_ResponseParamsSpec.$,
        this.enableStaticKeyPinningForTesting.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.verifyCertificateForTesting =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        75,
        NetworkContext_VerifyCertificateForTesting_ParamsSpec.$,
        NetworkContext_VerifyCertificateForTesting_ResponseParamsSpec.$,
        this.verifyCertificateForTesting.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getTrustAnchorIDsForTesting =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        76,
        NetworkContext_GetTrustAnchorIDsForTesting_ParamsSpec.$,
        NetworkContext_GetTrustAnchorIDsForTesting_ResponseParamsSpec.$,
        this.getTrustAnchorIDsForTesting.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addDomainReliabilityContextForTesting =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        77,
        NetworkContext_AddDomainReliabilityContextForTesting_ParamsSpec.$,
        NetworkContext_AddDomainReliabilityContextForTesting_ResponseParamsSpec.$,
        this.addDomainReliabilityContextForTesting.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.forceDomainReliabilityUploadsForTesting =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        78,
        NetworkContext_ForceDomainReliabilityUploadsForTesting_ParamsSpec.$,
        NetworkContext_ForceDomainReliabilityUploadsForTesting_ResponseParamsSpec.$,
        this.forceDomainReliabilityUploadsForTesting.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setSCTAuditingMode =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        79,
        NetworkContext_SetSCTAuditingMode_ParamsSpec.$,
        null,
        this.setSCTAuditingMode.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addReportingApiObserver =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        80,
        NetworkContext_AddReportingApiObserver_ParamsSpec.$,
        null,
        this.addReportingApiObserver.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getSharedDictionaryUsageInfo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        81,
        NetworkContext_GetSharedDictionaryUsageInfo_ParamsSpec.$,
        NetworkContext_GetSharedDictionaryUsageInfo_ResponseParamsSpec.$,
        this.getSharedDictionaryUsageInfo.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getSharedDictionaryInfo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        82,
        NetworkContext_GetSharedDictionaryInfo_ParamsSpec.$,
        NetworkContext_GetSharedDictionaryInfo_ResponseParamsSpec.$,
        this.getSharedDictionaryInfo.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getSharedDictionaryOriginsBetween =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        83,
        NetworkContext_GetSharedDictionaryOriginsBetween_ParamsSpec.$,
        NetworkContext_GetSharedDictionaryOriginsBetween_ResponseParamsSpec.$,
        this.getSharedDictionaryOriginsBetween.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setSharedDictionaryCacheMaxSize =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        84,
        NetworkContext_SetSharedDictionaryCacheMaxSize_ParamsSpec.$,
        null,
        this.setSharedDictionaryCacheMaxSize.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.preloadSharedDictionaryInfoForDocument =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        85,
        NetworkContext_PreloadSharedDictionaryInfoForDocument_ParamsSpec.$,
        null,
        this.preloadSharedDictionaryInfoForDocument.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.hasPreloadedSharedDictionaryInfoForTesting =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        86,
        NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_ParamsSpec.$,
        NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_ResponseParamsSpec.$,
        this.hasPreloadedSharedDictionaryInfoForTesting.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.flushCachedClientCertIfNeeded =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        87,
        NetworkContext_FlushCachedClientCertIfNeeded_ParamsSpec.$,
        null,
        this.flushCachedClientCertIfNeeded.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.flushMatchingCachedClientCert =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        88,
        NetworkContext_FlushMatchingCachedClientCert_ParamsSpec.$,
        null,
        this.flushMatchingCachedClientCert.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setCookieDeprecationLabel =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        89,
        NetworkContext_SetCookieDeprecationLabel_ParamsSpec.$,
        null,
        this.setCookieDeprecationLabel.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.revokeNetworkForNonces =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        90,
        NetworkContext_RevokeNetworkForNonces_ParamsSpec.$,
        NetworkContext_RevokeNetworkForNonces_ResponseParamsSpec.$,
        this.revokeNetworkForNonces.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clearNonces =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        91,
        NetworkContext_ClearNonces_ParamsSpec.$,
        null,
        this.clearNonces.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.exemptUrlFromNetworkRevocationForNonce =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        92,
        NetworkContext_ExemptUrlFromNetworkRevocationForNonce_ParamsSpec.$,
        NetworkContext_ExemptUrlFromNetworkRevocationForNonce_ResponseParamsSpec.$,
        this.exemptUrlFromNetworkRevocationForNonce.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.prefetch =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        93,
        NetworkContext_Prefetch_ParamsSpec.$,
        null,
        this.prefetch.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getBoundNetworkForTesting =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        94,
        NetworkContext_GetBoundNetworkForTesting_ParamsSpec.$,
        NetworkContext_GetBoundNetworkForTesting_ResponseParamsSpec.$,
        this.getBoundNetworkForTesting.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getDeviceBoundSessionManager =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        95,
        NetworkContext_GetDeviceBoundSessionManager_ParamsSpec.$,
        null,
        this.getDeviceBoundSessionManager.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addQuicHints =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        96,
        NetworkContext_AddQuicHints_ParamsSpec.$,
        null,
        this.addQuicHints.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CustomProxyConfigSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CertVerifierServiceRemoteParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HttpAuthStaticNetworkContextParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CTPolicySpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContextFilePathsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContextParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkConditionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MatchedNetworkConditionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkDurableMessageConfigSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SharedDictionaryInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SignedExchangeReportSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const URLLoaderFactoryOverrideSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const URLLoaderFactoryParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CustomProxyConnectionObserver_OnFallback_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CustomProxyConnectionObserver_OnTunnelHeadersReceived_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CustomProxyConfigClient_OnCustomProxyConfigUpdated_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CustomProxyConfigClient_OnCustomProxyConfigUpdated_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TrustedHeaderClient_OnBeforeSendHeaders_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TrustedHeaderClient_OnBeforeSendHeaders_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TrustedHeaderClient_OnHeadersReceived_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TrustedHeaderClient_OnHeadersReceived_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TrustedURLLoaderHeaderClient_OnLoaderCreated_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TrustedURLLoaderHeaderClient_OnLoaderForCorsPreflightCreated_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DurableMessageCollector_Configure_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DurableMessageCollector_Retrieve_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DurableMessageCollector_Retrieve_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_SetClient_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_CreateURLLoaderFactory_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_ResetURLLoaderFactories_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_GetViaObliviousHttp_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_GetCookieManager_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_GetRestrictedCookieManager_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_GetTrustTokenQueryAnswerer_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_ClearTrustTokenData_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_ClearTrustTokenData_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_ClearTrustTokenSessionOnlyData_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_ClearTrustTokenSessionOnlyData_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_GetStoredTrustTokenCounts_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_GetStoredTrustTokenCounts_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_GetPrivateStateTokenRedemptionRecords_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_GetPrivateStateTokenRedemptionRecords_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_GetIpProxyStatus_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_GetIpProxyStatus_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_SetBypassIpProtectionProxy_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_DeleteStoredTrustTokens_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_DeleteStoredTrustTokens_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_SetBlockTrustTokens_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_SetTrackingProtectionContentSetting_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_ClearNetworkingHistoryBetween_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_ClearNetworkingHistoryBetween_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_ClearHttpCache_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_ClearHttpCache_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_ComputeHttpCacheSize_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_ComputeHttpCacheSize_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_NotifyBrowserIdle_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_NotifyExternalCacheHit_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_ClearHostCache_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_ClearHostCache_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_ClearHttpAuthCache_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_ClearHttpAuthCache_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_ClearCorsPreflightCache_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_ClearCorsPreflightCache_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_ClearReportingCacheReports_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_ClearReportingCacheReports_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_ClearReportingCacheClients_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_ClearReportingCacheClients_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_ClearNetworkErrorLogging_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_ClearNetworkErrorLogging_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_ClearDomainReliability_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_ClearDomainReliability_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_ClearSharedDictionaryCache_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_ClearSharedDictionaryCache_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_ClearSharedDictionaryCacheForIsolationKey_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_ClearSharedDictionaryCacheForIsolationKey_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_SetDocumentReportingEndpoints_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_SetEnterpriseReportingEndpoints_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_SendReportsAndRemoveSource_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_QueueReport_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_QueueEnterpriseReport_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_QueueSignedExchangeReport_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_CloseAllConnections_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_CloseAllConnections_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_CloseIdleConnections_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_CloseIdleConnections_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_SetNetworkConditions_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_EnableDurableMessageCollector_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_SetAcceptLanguage_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_SetEnableReferrers_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_SetCTPolicy_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_CreateUDPSocket_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_CreateRestrictedUDPSocket_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_CreateRestrictedUDPSocket_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_CreateTCPServerSocket_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_CreateTCPServerSocket_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_CreateTCPConnectedSocket_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_CreateTCPConnectedSocket_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_CreateTCPBoundSocket_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_CreateTCPBoundSocket_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_CreateProxyResolvingSocketFactory_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_LookUpProxyForURL_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_ForceReloadProxyConfig_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_ForceReloadProxyConfig_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_ClearBadProxiesCache_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_ClearBadProxiesCache_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_CreateWebSocket_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_CreateWebTransport_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_CreateNetLogExporter_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_PreconnectSockets_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_CreateP2PSocketManager_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_CreateMdnsResponder_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_ResolveHost_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_CreateHostResolver_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_VerifyCert_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_VerifyCert_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_VerifyCertForSignedExchange_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_VerifyCertForSignedExchange_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_Verify2QwacCertBinding_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_Verify2QwacCertBinding_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_AddHSTS_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_AddHSTS_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_IsHSTSActiveForHost_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_IsHSTSActiveForHost_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_GetHSTSState_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_GetHSTSState_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_SetCorsOriginAccessListsForOrigin_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_SetCorsOriginAccessListsForOrigin_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_DeleteDynamicDataForHost_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_DeleteDynamicDataForHost_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_SetSplitAuthCacheByNetworkAnonymizationKey_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_SaveHttpAuthCacheProxyEntries_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_SaveHttpAuthCacheProxyEntries_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_LoadHttpAuthCacheProxyEntries_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_LoadHttpAuthCacheProxyEntries_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_AddAuthCacheEntry_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_AddAuthCacheEntry_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_SetCorsNonWildcardRequestHeadersSupport_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_LookupProxyAuthCredentials_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_LookupProxyAuthCredentials_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_EnableStaticKeyPinningForTesting_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_EnableStaticKeyPinningForTesting_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_VerifyCertificateForTesting_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_VerifyCertificateForTesting_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_GetTrustAnchorIDsForTesting_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_GetTrustAnchorIDsForTesting_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_AddDomainReliabilityContextForTesting_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_AddDomainReliabilityContextForTesting_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_ForceDomainReliabilityUploadsForTesting_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_ForceDomainReliabilityUploadsForTesting_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_SetSCTAuditingMode_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_AddReportingApiObserver_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_GetSharedDictionaryUsageInfo_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_GetSharedDictionaryUsageInfo_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_GetSharedDictionaryInfo_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_GetSharedDictionaryInfo_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_GetSharedDictionaryOriginsBetween_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_GetSharedDictionaryOriginsBetween_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_SetSharedDictionaryCacheMaxSize_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_PreloadSharedDictionaryInfoForDocument_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_FlushCachedClientCertIfNeeded_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_FlushMatchingCachedClientCert_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_SetCookieDeprecationLabel_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_RevokeNetworkForNonces_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_RevokeNetworkForNonces_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_ClearNonces_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_ExemptUrlFromNetworkRevocationForNonce_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_ExemptUrlFromNetworkRevocationForNonce_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_Prefetch_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_GetBoundNetworkForTesting_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_GetBoundNetworkForTesting_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_GetDeviceBoundSessionManager_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContext_AddQuicHints_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    CustomProxyConfigSpec.$,
    'CustomProxyConfig',
    [
      mojo.internal.StructField(
        'rules', 0,
        0,
        network_mojom_ProxyRulesSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'shouldOverrideExistingConfig', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'allowNonIdempotentMethods', 8,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'connectTunnelHeaders', 16,
        0,
        network_mojom_HttpRequestHeadersSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class CustomProxyConfig {
  constructor() {
    /** @type { !network_mojom_ProxyRules } */
    this.rules;
    /** @type { !boolean } */
    this.shouldOverrideExistingConfig;
    /** @type { !boolean } */
    this.allowNonIdempotentMethods;
    /** @type { !network_mojom_HttpRequestHeaders } */
    this.connectTunnelHeaders;
  }
}



mojo.internal.Struct(
    CertVerifierServiceRemoteParamsSpec.$,
    'CertVerifierServiceRemoteParams',
    [
      mojo.internal.StructField(
        'certVerifierService', 0,
        0,
        mojo.internal.InterfaceProxy(certVerifier_mojom_CertVerifierServiceRemote),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'certVerifierServiceClientReceiver', 8,
        0,
        mojo.internal.InterfaceRequest(certVerifier_mojom_CertVerifierServiceClientPendingReceiver),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class CertVerifierServiceRemoteParams {
  constructor() {
    /** @type { (certVerifier_mojom_CertVerifierServiceRemote|undefined) } */
    this.certVerifierService;
    /** @type { (certVerifier_mojom_CertVerifierServiceClientPendingReceiver|undefined) } */
    this.certVerifierServiceClientReceiver;
  }
}



mojo.internal.Struct(
    HttpAuthStaticNetworkContextParamsSpec.$,
    'HttpAuthStaticNetworkContextParams',
    [
      mojo.internal.StructField(
        'allowDefaultCredentials', 0,
        0,
        network_mojom_DefaultCredentialsSpec.$,
        network_mojom_DefaultCredentials.ALLOW_DEFAULT_CREDENTIALS,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class HttpAuthStaticNetworkContextParams {
  constructor() {
    /** @type { !network_mojom_DefaultCredentials } */
    this.allowDefaultCredentials;
  }
}



mojo.internal.Struct(
    CTPolicySpec.$,
    'CTPolicy',
    [
      mojo.internal.StructField(
        'excludedHosts', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'excludedSpkis', 8,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class CTPolicy {
  constructor() {
    /** @type { !Array<!string> } */
    this.excludedHosts;
    /** @type { !Array<!string> } */
    this.excludedSpkis;
  }
}



mojo.internal.Struct(
    NetworkContextFilePathsSpec.$,
    'NetworkContextFilePaths',
    [
      mojo.internal.StructField(
        'sharedDictionaryDirectory', 0,
        0,
        network_mojom_TransferableDirectorySpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'httpCacheDirectory', 16,
        0,
        network_mojom_TransferableDirectorySpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'noVarySearchDirectory', 32,
        0,
        network_mojom_TransferableDirectorySpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'dataDirectory', 48,
        0,
        network_mojom_TransferableDirectorySpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'unsandboxedDataPath', 64,
        0,
        mojoBase_mojom_FilePathSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'cookieDatabaseName', 72,
        0,
        mojoBase_mojom_FilePathSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'deviceBoundSessionsDatabaseName', 80,
        0,
        mojoBase_mojom_FilePathSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'trustTokenDatabaseName', 88,
        0,
        mojoBase_mojom_FilePathSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'httpServerPropertiesFileName', 96,
        0,
        mojoBase_mojom_FilePathSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'transportSecurityPersisterFileName', 104,
        0,
        mojoBase_mojom_FilePathSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'reportingAndNelStoreDatabaseName', 112,
        0,
        mojoBase_mojom_FilePathSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sctAuditingPendingReportsFileName', 120,
        0,
        mojoBase_mojom_FilePathSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'triggerMigration', 128,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 144],]);



/**
 * @record
 */
export class NetworkContextFilePaths {
  constructor() {
    /** @type { (network_mojom_TransferableDirectory|undefined) } */
    this.sharedDictionaryDirectory;
    /** @type { (network_mojom_TransferableDirectory|undefined) } */
    this.httpCacheDirectory;
    /** @type { (network_mojom_TransferableDirectory|undefined) } */
    this.noVarySearchDirectory;
    /** @type { !network_mojom_TransferableDirectory } */
    this.dataDirectory;
    /** @type { (mojoBase_mojom_FilePath|undefined) } */
    this.unsandboxedDataPath;
    /** @type { (mojoBase_mojom_FilePath|undefined) } */
    this.cookieDatabaseName;
    /** @type { (mojoBase_mojom_FilePath|undefined) } */
    this.deviceBoundSessionsDatabaseName;
    /** @type { (mojoBase_mojom_FilePath|undefined) } */
    this.trustTokenDatabaseName;
    /** @type { (mojoBase_mojom_FilePath|undefined) } */
    this.httpServerPropertiesFileName;
    /** @type { (mojoBase_mojom_FilePath|undefined) } */
    this.transportSecurityPersisterFileName;
    /** @type { (mojoBase_mojom_FilePath|undefined) } */
    this.reportingAndNelStoreDatabaseName;
    /** @type { (mojoBase_mojom_FilePath|undefined) } */
    this.sctAuditingPendingReportsFileName;
    /** @type { !boolean } */
    this.triggerMigration;
  }
}



mojo.internal.Struct(
    NetworkContextParamsSpec.$,
    'NetworkContextParams',
    [
      mojo.internal.StructField(
        'userAgent', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'acceptLanguage', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'enableBrotli', 16,
        0,
        mojo.internal.Bool,
        true,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'enableZstd', 16,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'enableReferrers', 16,
        2,
        mojo.internal.Bool,
        true,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'validateReferrerPolicyOnInitialRequest', 16,
        3,
        mojo.internal.Bool,
        true,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'proxyResolverFactory', 20,
        0,
        mojo.internal.InterfaceProxy(proxyResolver_mojom_ProxyResolverFactoryRemote),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'dhcpWpadUrlClient', 28,
        0,
        mojo.internal.InterfaceProxy(network_mojom_DhcpWpadUrlClientRemote),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'enableEncryptedCookies', 16,
        4,
        mojo.internal.Bool,
        true,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'restoreOldSessionCookies', 16,
        5,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'persistSessionCookies', 16,
        6,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'httpCacheEnabled', 16,
        7,
        mojo.internal.Bool,
        true,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'httpCacheMaxSize', 36,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'httpCacheFileOperationsFactory', 40,
        0,
        mojo.internal.InterfaceProxy(network_mojom_HttpCacheBackendFileOperationsFactoryRemote),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'disableIdleSocketsCloseOnMemoryPressure', 17,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'initialSslConfig', 48,
        0,
        network_mojom_SSLConfigSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sslConfigClientReceiver', 56,
        0,
        mojo.internal.InterfaceRequest(network_mojom_SSLConfigClientPendingReceiver),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'initialProxyConfig', 64,
        0,
        network_mojom_ProxyConfigWithAnnotationSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'proxyConfigClientReceiver', 60,
        0,
        mojo.internal.InterfaceRequest(network_mojom_ProxyConfigClientPendingReceiver),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'initialCustomProxyConfig', 72,
        0,
        CustomProxyConfigSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'customProxyConfigClientReceiver', 80,
        0,
        mojo.internal.InterfaceRequest(CustomProxyConfigClientPendingReceiver),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'customProxyConnectionObserverRemote', 84,
        0,
        mojo.internal.InterfaceProxy(CustomProxyConnectionObserverRemote),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'proxyConfigPollerClient', 92,
        0,
        mojo.internal.InterfaceProxy(network_mojom_ProxyConfigPollerClientRemote),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'proxyErrorClient', 100,
        0,
        mojo.internal.InterfaceProxy(network_mojom_ProxyErrorClientRemote),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'ipProtectionCoreHost', 108,
        0,
        mojo.internal.InterfaceProxy(ipProtection_mojom_CoreHostRemote),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'ipProtectionControl', 116,
        0,
        mojo.internal.InterfaceRequest(ipProtection_mojom_CoreControlPendingReceiver),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'enableIpProtection', 17,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'ipProtectionIncognito', 17,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'initialIpProtectionTokens', 120,
        0,
        mojo.internal.Map(ipProtection_mojom_ProxyLayerSpec.$, mojo.internal.Array(ipProtection_mojom_BlindSignedAuthTokenSpec.$, false), false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'ipProtectionDataDirectory', 128,
        0,
        mojoBase_mojom_FilePathSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'pacQuickCheckEnabled', 17,
        3,
        mojo.internal.Bool,
        true,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'enableCertificateReporting', 17,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'enforceChromeCtPolicy', 17,
        5,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sctAuditingMode', 136,
        0,
        SCTAuditingModeSpec.$,
        SCTAuditingMode.kDisabled,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'ctPolicy', 144,
        0,
        CTPolicySpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'certVerifierParams', 152,
        0,
        CertVerifierServiceRemoteParamsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'cookieManagerParams', 160,
        0,
        network_mojom_CookieManagerParamsSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'enableDomainReliability', 17,
        6,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'domainReliabilityUploadReporter', 168,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'discardDomainReliablityUploads', 17,
        7,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'reportingDeliveryInterval', 176,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'skipReportingSendPermissionCheck', 18,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'corsOriginAccessList', 184,
        0,
        mojo.internal.Array(network_mojom_CorsOriginAccessPatternsSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'corsExemptHeaderList', 192,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'allowAnyCorsExemptHeaderForBrowser', 18,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hstsPolicyBypassList', 200,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'httpAuthStaticNetworkContextParams', 208,
        0,
        HttpAuthStaticNetworkContextParamsSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'resetHttpCacheBackend', 18,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'splitAuthCacheByNetworkAnonymizationKey', 18,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'requireNetworkAnonymizationKey', 18,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'filePaths', 216,
        0,
        NetworkContextFilePathsSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'blockTrustTokens', 18,
        5,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sharedDictionaryEnabled', 18,
        6,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sharedDictionaryCacheMaxSize', 224,
        0,
        mojo.internal.Uint64,
        BigInt('0'),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'firstPartySetsAccessDelegateParams', 232,
        0,
        network_mojom_FirstPartySetsAccessDelegateParamsSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'firstPartySetsAccessDelegateReceiver', 140,
        0,
        mojo.internal.InterfaceRequest(network_mojom_FirstPartySetsAccessDelegatePendingReceiver),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'acamPreflightSpecConformant', 18,
        7,
        mojo.internal.Bool,
        true,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'cookieDeprecationLabel', 240,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'cookieEncryptionProvider', 248,
        0,
        mojo.internal.InterfaceProxy(network_mojom_CookieEncryptionProviderRemote),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'deviceBoundSessionsEnabled', 19,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'boundNetwork', 256,
        0,
        mojo.internal.Int64,
        BigInt('-1'),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'enterpriseReportingEndpoints', 264,
        0,
        mojo.internal.Map(mojo.internal.String, url_mojom_UrlSpec.$, false),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'quic_idle_connection_timeout_seconds_$flag', 19,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "quic_idle_connection_timeout_seconds_$value",
          originalFieldName: "quicIdleConnectionTimeoutSeconds",
        }
      ),
      mojo.internal.StructField(
        'quic_idle_connection_timeout_seconds_$value', 272,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "quicIdleConnectionTimeoutSeconds",
        }
      ),
      mojo.internal.StructField(
        'trackingProtectionContentSettings', 280,
        0,
        mojo.internal.Array(contentSettings_mojom_ContentSettingPatternSourceSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 296],]);



/**
 * @record
 */
export class NetworkContextParams {
  constructor() {
    /** @type { !string } */
    this.userAgent;
    /** @type { !string } */
    this.acceptLanguage;
    /** @type { !boolean } */
    this.enableBrotli;
    /** @type { !boolean } */
    this.enableZstd;
    /** @type { !boolean } */
    this.enableReferrers;
    /** @type { !boolean } */
    this.validateReferrerPolicyOnInitialRequest;
    /** @type { (proxyResolver_mojom_ProxyResolverFactoryRemote|undefined) } */
    this.proxyResolverFactory;
    /** @type { (network_mojom_DhcpWpadUrlClientRemote|undefined) } */
    this.dhcpWpadUrlClient;
    /** @type { !boolean } */
    this.enableEncryptedCookies;
    /** @type { !boolean } */
    this.restoreOldSessionCookies;
    /** @type { !boolean } */
    this.persistSessionCookies;
    /** @type { !boolean } */
    this.httpCacheEnabled;
    /** @type { !number } */
    this.httpCacheMaxSize;
    /** @type { (network_mojom_HttpCacheBackendFileOperationsFactoryRemote|undefined) } */
    this.httpCacheFileOperationsFactory;
    /** @type { !boolean } */
    this.disableIdleSocketsCloseOnMemoryPressure;
    /** @type { (network_mojom_SSLConfig|undefined) } */
    this.initialSslConfig;
    /** @type { (network_mojom_SSLConfigClientPendingReceiver|undefined) } */
    this.sslConfigClientReceiver;
    /** @type { (network_mojom_ProxyConfigWithAnnotation|undefined) } */
    this.initialProxyConfig;
    /** @type { (network_mojom_ProxyConfigClientPendingReceiver|undefined) } */
    this.proxyConfigClientReceiver;
    /** @type { (CustomProxyConfig|undefined) } */
    this.initialCustomProxyConfig;
    /** @type { (CustomProxyConfigClientPendingReceiver|undefined) } */
    this.customProxyConfigClientReceiver;
    /** @type { (CustomProxyConnectionObserverRemote|undefined) } */
    this.customProxyConnectionObserverRemote;
    /** @type { (network_mojom_ProxyConfigPollerClientRemote|undefined) } */
    this.proxyConfigPollerClient;
    /** @type { (network_mojom_ProxyErrorClientRemote|undefined) } */
    this.proxyErrorClient;
    /** @type { (ipProtection_mojom_CoreHostRemote|undefined) } */
    this.ipProtectionCoreHost;
    /** @type { (ipProtection_mojom_CoreControlPendingReceiver|undefined) } */
    this.ipProtectionControl;
    /** @type { !boolean } */
    this.enableIpProtection;
    /** @type { !boolean } */
    this.ipProtectionIncognito;
    /** @type { !Object<!ipProtection_mojom_ProxyLayer, !Array<!ipProtection_mojom_BlindSignedAuthToken>> } */
    this.initialIpProtectionTokens;
    /** @type { (mojoBase_mojom_FilePath|undefined) } */
    this.ipProtectionDataDirectory;
    /** @type { !boolean } */
    this.pacQuickCheckEnabled;
    /** @type { !boolean } */
    this.enableCertificateReporting;
    /** @type { !boolean } */
    this.enforceChromeCtPolicy;
    /** @type { !SCTAuditingMode } */
    this.sctAuditingMode;
    /** @type { (CTPolicy|undefined) } */
    this.ctPolicy;
    /** @type { !CertVerifierServiceRemoteParams } */
    this.certVerifierParams;
    /** @type { (network_mojom_CookieManagerParams|undefined) } */
    this.cookieManagerParams;
    /** @type { !boolean } */
    this.enableDomainReliability;
    /** @type { !string } */
    this.domainReliabilityUploadReporter;
    /** @type { !boolean } */
    this.discardDomainReliablityUploads;
    /** @type { (mojoBase_mojom_TimeDelta|undefined) } */
    this.reportingDeliveryInterval;
    /** @type { !boolean } */
    this.skipReportingSendPermissionCheck;
    /** @type { !Array<!network_mojom_CorsOriginAccessPatterns> } */
    this.corsOriginAccessList;
    /** @type { !Array<!string> } */
    this.corsExemptHeaderList;
    /** @type { !boolean } */
    this.allowAnyCorsExemptHeaderForBrowser;
    /** @type { !Array<!string> } */
    this.hstsPolicyBypassList;
    /** @type { (HttpAuthStaticNetworkContextParams|undefined) } */
    this.httpAuthStaticNetworkContextParams;
    /** @type { !boolean } */
    this.resetHttpCacheBackend;
    /** @type { !boolean } */
    this.splitAuthCacheByNetworkAnonymizationKey;
    /** @type { !boolean } */
    this.requireNetworkAnonymizationKey;
    /** @type { (NetworkContextFilePaths|undefined) } */
    this.filePaths;
    /** @type { !boolean } */
    this.blockTrustTokens;
    /** @type { !boolean } */
    this.sharedDictionaryEnabled;
    /** @type { !bigint } */
    this.sharedDictionaryCacheMaxSize;
    /** @type { (network_mojom_FirstPartySetsAccessDelegateParams|undefined) } */
    this.firstPartySetsAccessDelegateParams;
    /** @type { (network_mojom_FirstPartySetsAccessDelegatePendingReceiver|undefined) } */
    this.firstPartySetsAccessDelegateReceiver;
    /** @type { !boolean } */
    this.acamPreflightSpecConformant;
    /** @type { (string|undefined) } */
    this.cookieDeprecationLabel;
    /** @type { (network_mojom_CookieEncryptionProviderRemote|undefined) } */
    this.cookieEncryptionProvider;
    /** @type { !boolean } */
    this.deviceBoundSessionsEnabled;
    /** @type { !bigint } */
    this.boundNetwork;
    /** @type { (Object<!string, !url_mojom_Url>|undefined) } */
    this.enterpriseReportingEndpoints;
    /** @type { (bigint|undefined) } */
    this.quicIdleConnectionTimeoutSeconds;
    /** @type { !Array<!contentSettings_mojom_ContentSettingPatternSource> } */
    this.trackingProtectionContentSettings;
  }
}



mojo.internal.Struct(
    NetworkConditionsSpec.$,
    'NetworkConditions',
    [
      mojo.internal.StructField(
        'offline', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'latency', 8,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'downloadThroughput', 16,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'uploadThroughput', 24,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'packetLoss', 32,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'packetQueueLength', 4,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'packetReordering', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'ruleId', 40,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 56],]);



/**
 * @record
 */
export class NetworkConditions {
  constructor() {
    /** @type { !boolean } */
    this.offline;
    /** @type { !mojoBase_mojom_TimeDelta } */
    this.latency;
    /** @type { !number } */
    this.downloadThroughput;
    /** @type { !number } */
    this.uploadThroughput;
    /** @type { !number } */
    this.packetLoss;
    /** @type { !number } */
    this.packetQueueLength;
    /** @type { !boolean } */
    this.packetReordering;
    /** @type { (mojoBase_mojom_UnguessableToken|undefined) } */
    this.ruleId;
  }
}



mojo.internal.Struct(
    MatchedNetworkConditionsSpec.$,
    'MatchedNetworkConditions',
    [
      mojo.internal.StructField(
        'pattern', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'conditions', 8,
        0,
        NetworkConditionsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MatchedNetworkConditions {
  constructor() {
    /** @type { !string } */
    this.pattern;
    /** @type { !NetworkConditions } */
    this.conditions;
  }
}



mojo.internal.Struct(
    NetworkDurableMessageConfigSpec.$,
    'NetworkDurableMessageConfig',
    [
      mojo.internal.StructField(
        'httpStorageMaxSize', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkDurableMessageConfig {
  constructor() {
    /** @type { !bigint } */
    this.httpStorageMaxSize;
  }
}



mojo.internal.Struct(
    SharedDictionaryInfoSpec.$,
    'SharedDictionaryInfo',
    [
      mojo.internal.StructField(
        'match', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'matchDest', 8,
        0,
        mojo.internal.Array(network_mojom_RequestDestinationSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'id', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'dictionaryUrl', 24,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'lastFetchTime', 32,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'responseTime', 40,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'expiration', 48,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'lastUsedTime', 56,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'size', 64,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hash', 72,
        0,
        network_mojom_SHA256HashValueSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 88],]);



/**
 * @record
 */
export class SharedDictionaryInfo {
  constructor() {
    /** @type { !string } */
    this.match;
    /** @type { !Array<!network_mojom_RequestDestination> } */
    this.matchDest;
    /** @type { !string } */
    this.id;
    /** @type { !url_mojom_Url } */
    this.dictionaryUrl;
    /** @type { !mojoBase_mojom_Time } */
    this.lastFetchTime;
    /** @type { !mojoBase_mojom_Time } */
    this.responseTime;
    /** @type { !mojoBase_mojom_TimeDelta } */
    this.expiration;
    /** @type { !mojoBase_mojom_Time } */
    this.lastUsedTime;
    /** @type { !bigint } */
    this.size;
    /** @type { !network_mojom_SHA256HashValue } */
    this.hash;
  }
}



mojo.internal.Struct(
    SignedExchangeReportSpec.$,
    'SignedExchangeReport',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'type', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'outerUrl', 16,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'innerUrl', 24,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'certUrl', 32,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'referrer', 40,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'serverIpAddress', 48,
        0,
        network_mojom_IPAddressSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'protocol', 56,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'method', 64,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'statusCode', 4,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'elapsedTime', 72,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 88],]);



/**
 * @record
 */
export class SignedExchangeReport {
  constructor() {
    /** @type { !boolean } */
    this.success;
    /** @type { !string } */
    this.type;
    /** @type { !url_mojom_Url } */
    this.outerUrl;
    /** @type { !url_mojom_Url } */
    this.innerUrl;
    /** @type { !url_mojom_Url } */
    this.certUrl;
    /** @type { !string } */
    this.referrer;
    /** @type { !network_mojom_IPAddress } */
    this.serverIpAddress;
    /** @type { !string } */
    this.protocol;
    /** @type { !string } */
    this.method;
    /** @type { !number } */
    this.statusCode;
    /** @type { !mojoBase_mojom_TimeDelta } */
    this.elapsedTime;
  }
}



mojo.internal.Struct(
    URLLoaderFactoryOverrideSpec.$,
    'URLLoaderFactoryOverride',
    [
      mojo.internal.StructField(
        'overridingFactory', 0,
        0,
        mojo.internal.InterfaceProxy(network_mojom_URLLoaderFactoryRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'overriddenFactoryReceiver', 8,
        0,
        mojo.internal.InterfaceRequest(network_mojom_URLLoaderFactoryPendingReceiver),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'skipCorsEnabledSchemeCheck', 12,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class URLLoaderFactoryOverride {
  constructor() {
    /** @type { !network_mojom_URLLoaderFactoryRemote } */
    this.overridingFactory;
    /** @type { (network_mojom_URLLoaderFactoryPendingReceiver|undefined) } */
    this.overriddenFactoryReceiver;
    /** @type { !boolean } */
    this.skipCorsEnabledSchemeCheck;
  }
}



mojo.internal.Struct(
    URLLoaderFactoryParamsSpec.$,
    'URLLoaderFactoryParams',
    [
      mojo.internal.StructField(
        'processId', 0,
        0,
        mojo.internal.Int32,
        INVALID_PROCESS_ID,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'requestInitiatorOriginLock', 8,
        0,
        url_mojom_OriginSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isOrbEnabled', 4,
        0,
        mojo.internal.Bool,
        true,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'ignoreIsolatedWorldOrigin', 4,
        1,
        mojo.internal.Bool,
        true,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'unsafeNonWebbyInitiator', 4,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'disableWebSecurity', 4,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'headerClient', 16,
        0,
        mojo.internal.InterfaceProxy(TrustedURLLoaderHeaderClientRemote),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isolationInfo', 24,
        0,
        network_mojom_IsolationInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'disableSecureDns', 4,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isTrusted', 4,
        5,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'automaticallyAssignIsolationInfo', 4,
        6,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'topFrameId', 32,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'factoryOverride', 40,
        0,
        URLLoaderFactoryOverrideSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'clientSecurityState', 48,
        0,
        network_mojom_ClientSecurityStateSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'coepReporter', 56,
        0,
        mojo.internal.InterfaceProxy(network_mojom_CrossOriginEmbedderPolicyReporterRemote),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'dipReporter', 64,
        0,
        mojo.internal.InterfaceProxy(network_mojom_DocumentIsolationPolicyReporterRemote),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'cookieObserver', 72,
        0,
        mojo.internal.InterfaceProxy(network_mojom_CookieAccessObserverRemote),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'trustTokenObserver', 80,
        0,
        mojo.internal.InterfaceProxy(network_mojom_TrustTokenAccessObserverRemote),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sharedDictionaryObserver', 88,
        0,
        mojo.internal.InterfaceProxy(network_mojom_SharedDictionaryAccessObserverRemote),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'urlLoaderNetworkObserver', 96,
        0,
        mojo.internal.InterfaceProxy(network_mojom_URLLoaderNetworkServiceObserverRemote),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'devtoolsObserver', 104,
        0,
        mojo.internal.InterfaceProxy(network_mojom_DevToolsObserverRemote),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'deviceBoundSessionObserver', 112,
        0,
        mojo.internal.InterfaceProxy(network_mojom_DeviceBoundSessionAccessObserverRemote),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'trustTokenIssuancePolicy', 120,
        0,
        TrustTokenOperationPolicyVerdictSpec.$,
        TrustTokenOperationPolicyVerdict.kPotentiallyPermit,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'trustTokenRedemptionPolicy', 124,
        0,
        TrustTokenOperationPolicyVerdictSpec.$,
        TrustTokenOperationPolicyVerdict.kPotentiallyPermit,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'debugTag', 128,
        0,
        mojo.internal.String,
        "",
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'cookieSettingOverrides', 136,
        0,
        network_mojom_CookieSettingOverridesSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'devtoolsCookieSettingOverrides', 144,
        0,
        network_mojom_CookieSettingOverridesSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'requireCrossSiteRequestForCookies', 4,
        7,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'ignoreFactoryReset', 5,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isMainFrameOriginRecentlyAccessed', 5,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 160],]);



/**
 * @record
 */
export class URLLoaderFactoryParams {
  constructor() {
    /** @type { !number } */
    this.processId;
    /** @type { (url_mojom_Origin|undefined) } */
    this.requestInitiatorOriginLock;
    /** @type { !boolean } */
    this.isOrbEnabled;
    /** @type { !boolean } */
    this.ignoreIsolatedWorldOrigin;
    /** @type { !boolean } */
    this.unsafeNonWebbyInitiator;
    /** @type { !boolean } */
    this.disableWebSecurity;
    /** @type { (TrustedURLLoaderHeaderClientRemote|undefined) } */
    this.headerClient;
    /** @type { !network_mojom_IsolationInfo } */
    this.isolationInfo;
    /** @type { !boolean } */
    this.disableSecureDns;
    /** @type { !boolean } */
    this.isTrusted;
    /** @type { !boolean } */
    this.automaticallyAssignIsolationInfo;
    /** @type { (mojoBase_mojom_UnguessableToken|undefined) } */
    this.topFrameId;
    /** @type { (URLLoaderFactoryOverride|undefined) } */
    this.factoryOverride;
    /** @type { (network_mojom_ClientSecurityState|undefined) } */
    this.clientSecurityState;
    /** @type { (network_mojom_CrossOriginEmbedderPolicyReporterRemote|undefined) } */
    this.coepReporter;
    /** @type { (network_mojom_DocumentIsolationPolicyReporterRemote|undefined) } */
    this.dipReporter;
    /** @type { (network_mojom_CookieAccessObserverRemote|undefined) } */
    this.cookieObserver;
    /** @type { (network_mojom_TrustTokenAccessObserverRemote|undefined) } */
    this.trustTokenObserver;
    /** @type { (network_mojom_SharedDictionaryAccessObserverRemote|undefined) } */
    this.sharedDictionaryObserver;
    /** @type { (network_mojom_URLLoaderNetworkServiceObserverRemote|undefined) } */
    this.urlLoaderNetworkObserver;
    /** @type { (network_mojom_DevToolsObserverRemote|undefined) } */
    this.devtoolsObserver;
    /** @type { (network_mojom_DeviceBoundSessionAccessObserverRemote|undefined) } */
    this.deviceBoundSessionObserver;
    /** @type { !TrustTokenOperationPolicyVerdict } */
    this.trustTokenIssuancePolicy;
    /** @type { !TrustTokenOperationPolicyVerdict } */
    this.trustTokenRedemptionPolicy;
    /** @type { !string } */
    this.debugTag;
    /** @type { !network_mojom_CookieSettingOverrides } */
    this.cookieSettingOverrides;
    /** @type { !network_mojom_CookieSettingOverrides } */
    this.devtoolsCookieSettingOverrides;
    /** @type { !boolean } */
    this.requireCrossSiteRequestForCookies;
    /** @type { !boolean } */
    this.ignoreFactoryReset;
    /** @type { !boolean } */
    this.isMainFrameOriginRecentlyAccessed;
  }
}



mojo.internal.Struct(
    CustomProxyConnectionObserver_OnFallback_ParamsSpec.$,
    'CustomProxyConnectionObserver_OnFallback_Params',
    [
      mojo.internal.StructField(
        'badChain', 0,
        0,
        network_mojom_ProxyChainSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'netError', 8,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class CustomProxyConnectionObserver_OnFallback_Params {
  constructor() {
    /** @type { !network_mojom_ProxyChain } */
    this.badChain;
    /** @type { !number } */
    this.netError;
  }
}



mojo.internal.Struct(
    CustomProxyConnectionObserver_OnTunnelHeadersReceived_ParamsSpec.$,
    'CustomProxyConnectionObserver_OnTunnelHeadersReceived_Params',
    [
      mojo.internal.StructField(
        'proxyChain', 0,
        0,
        network_mojom_ProxyChainSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'chainIndex', 8,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'responseHeaders', 16,
        0,
        network_mojom_HttpResponseHeadersSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class CustomProxyConnectionObserver_OnTunnelHeadersReceived_Params {
  constructor() {
    /** @type { !network_mojom_ProxyChain } */
    this.proxyChain;
    /** @type { !bigint } */
    this.chainIndex;
    /** @type { !network_mojom_HttpResponseHeaders } */
    this.responseHeaders;
  }
}



mojo.internal.Struct(
    CustomProxyConfigClient_OnCustomProxyConfigUpdated_ParamsSpec.$,
    'CustomProxyConfigClient_OnCustomProxyConfigUpdated_Params',
    [
      mojo.internal.StructField(
        'proxyConfig', 0,
        0,
        CustomProxyConfigSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class CustomProxyConfigClient_OnCustomProxyConfigUpdated_Params {
  constructor() {
    /** @type { !CustomProxyConfig } */
    this.proxyConfig;
  }
}



mojo.internal.Struct(
    CustomProxyConfigClient_OnCustomProxyConfigUpdated_ResponseParamsSpec.$,
    'CustomProxyConfigClient_OnCustomProxyConfigUpdated_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class CustomProxyConfigClient_OnCustomProxyConfigUpdated_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    TrustedHeaderClient_OnBeforeSendHeaders_ParamsSpec.$,
    'TrustedHeaderClient_OnBeforeSendHeaders_Params',
    [
      mojo.internal.StructField(
        'headers', 0,
        0,
        network_mojom_HttpRequestHeadersSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class TrustedHeaderClient_OnBeforeSendHeaders_Params {
  constructor() {
    /** @type { !network_mojom_HttpRequestHeaders } */
    this.headers;
  }
}



mojo.internal.Struct(
    TrustedHeaderClient_OnBeforeSendHeaders_ResponseParamsSpec.$,
    'TrustedHeaderClient_OnBeforeSendHeaders_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'headers', 8,
        0,
        network_mojom_HttpRequestHeadersSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class TrustedHeaderClient_OnBeforeSendHeaders_ResponseParams {
  constructor() {
    /** @type { !number } */
    this.result;
    /** @type { (network_mojom_HttpRequestHeaders|undefined) } */
    this.headers;
  }
}



mojo.internal.Struct(
    TrustedHeaderClient_OnHeadersReceived_ParamsSpec.$,
    'TrustedHeaderClient_OnHeadersReceived_Params',
    [
      mojo.internal.StructField(
        'headers', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'remoteEndpoint', 8,
        0,
        network_mojom_IPEndPointSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class TrustedHeaderClient_OnHeadersReceived_Params {
  constructor() {
    /** @type { !string } */
    this.headers;
    /** @type { !network_mojom_IPEndPoint } */
    this.remoteEndpoint;
  }
}



mojo.internal.Struct(
    TrustedHeaderClient_OnHeadersReceived_ResponseParamsSpec.$,
    'TrustedHeaderClient_OnHeadersReceived_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'headers', 8,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'preserveFragmentOnRedirectUrl', 16,
        0,
        url_mojom_UrlSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class TrustedHeaderClient_OnHeadersReceived_ResponseParams {
  constructor() {
    /** @type { !number } */
    this.result;
    /** @type { (string|undefined) } */
    this.headers;
    /** @type { (url_mojom_Url|undefined) } */
    this.preserveFragmentOnRedirectUrl;
  }
}



mojo.internal.Struct(
    TrustedURLLoaderHeaderClient_OnLoaderCreated_ParamsSpec.$,
    'TrustedURLLoaderHeaderClient_OnLoaderCreated_Params',
    [
      mojo.internal.StructField(
        'requestId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'headerClient', 4,
        0,
        mojo.internal.InterfaceRequest(TrustedHeaderClientPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class TrustedURLLoaderHeaderClient_OnLoaderCreated_Params {
  constructor() {
    /** @type { !number } */
    this.requestId;
    /** @type { !TrustedHeaderClientPendingReceiver } */
    this.headerClient;
  }
}



mojo.internal.Struct(
    TrustedURLLoaderHeaderClient_OnLoaderForCorsPreflightCreated_ParamsSpec.$,
    'TrustedURLLoaderHeaderClient_OnLoaderForCorsPreflightCreated_Params',
    [
      mojo.internal.StructField(
        'request', 0,
        0,
        network_mojom_URLRequestSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'headerClient', 8,
        0,
        mojo.internal.InterfaceRequest(TrustedHeaderClientPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class TrustedURLLoaderHeaderClient_OnLoaderForCorsPreflightCreated_Params {
  constructor() {
    /** @type { !network_mojom_URLRequest } */
    this.request;
    /** @type { !TrustedHeaderClientPendingReceiver } */
    this.headerClient;
  }
}



mojo.internal.Struct(
    DurableMessageCollector_Configure_ParamsSpec.$,
    'DurableMessageCollector_Configure_Params',
    [
      mojo.internal.StructField(
        'config', 0,
        0,
        NetworkDurableMessageConfigSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class DurableMessageCollector_Configure_Params {
  constructor() {
    /** @type { !NetworkDurableMessageConfig } */
    this.config;
  }
}



mojo.internal.Struct(
    DurableMessageCollector_Retrieve_ParamsSpec.$,
    'DurableMessageCollector_Retrieve_Params',
    [
      mojo.internal.StructField(
        'devtoolsRequestId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class DurableMessageCollector_Retrieve_Params {
  constructor() {
    /** @type { !string } */
    this.devtoolsRequestId;
  }
}



mojo.internal.Struct(
    DurableMessageCollector_Retrieve_ResponseParamsSpec.$,
    'DurableMessageCollector_Retrieve_ResponseParams',
    [
      mojo.internal.StructField(
        'message', 0,
        0,
        mojoBase_mojom_BigBufferSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class DurableMessageCollector_Retrieve_ResponseParams {
  constructor() {
    /** @type { (mojoBase_mojom_BigBuffer|undefined) } */
    this.message;
  }
}



mojo.internal.Struct(
    NetworkContext_SetClient_ParamsSpec.$,
    'NetworkContext_SetClient_Params',
    [
      mojo.internal.StructField(
        'client', 0,
        0,
        mojo.internal.InterfaceProxy(network_mojom_NetworkContextClientRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkContext_SetClient_Params {
  constructor() {
    /** @type { !network_mojom_NetworkContextClientRemote } */
    this.client;
  }
}



mojo.internal.Struct(
    NetworkContext_CreateURLLoaderFactory_ParamsSpec.$,
    'NetworkContext_CreateURLLoaderFactory_Params',
    [
      mojo.internal.StructField(
        'urlLoaderFactory', 0,
        0,
        mojo.internal.InterfaceRequest(network_mojom_URLLoaderFactoryPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'params', 8,
        0,
        URLLoaderFactoryParamsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class NetworkContext_CreateURLLoaderFactory_Params {
  constructor() {
    /** @type { !network_mojom_URLLoaderFactoryPendingReceiver } */
    this.urlLoaderFactory;
    /** @type { !URLLoaderFactoryParams } */
    this.params;
  }
}



mojo.internal.Struct(
    NetworkContext_ResetURLLoaderFactories_ParamsSpec.$,
    'NetworkContext_ResetURLLoaderFactories_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NetworkContext_ResetURLLoaderFactories_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    NetworkContext_GetViaObliviousHttp_ParamsSpec.$,
    'NetworkContext_GetViaObliviousHttp_Params',
    [
      mojo.internal.StructField(
        'request', 0,
        0,
        network_mojom_ObliviousHttpRequestSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'client', 8,
        0,
        mojo.internal.InterfaceProxy(network_mojom_ObliviousHttpClientRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class NetworkContext_GetViaObliviousHttp_Params {
  constructor() {
    /** @type { !network_mojom_ObliviousHttpRequest } */
    this.request;
    /** @type { !network_mojom_ObliviousHttpClientRemote } */
    this.client;
  }
}



mojo.internal.Struct(
    NetworkContext_GetCookieManager_ParamsSpec.$,
    'NetworkContext_GetCookieManager_Params',
    [
      mojo.internal.StructField(
        'cookieManager', 0,
        0,
        mojo.internal.InterfaceRequest(network_mojom_CookieManagerPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkContext_GetCookieManager_Params {
  constructor() {
    /** @type { !network_mojom_CookieManagerPendingReceiver } */
    this.cookieManager;
  }
}



mojo.internal.Struct(
    NetworkContext_GetRestrictedCookieManager_ParamsSpec.$,
    'NetworkContext_GetRestrictedCookieManager_Params',
    [
      mojo.internal.StructField(
        'restrictedCookieManager', 0,
        0,
        mojo.internal.InterfaceRequest(network_mojom_RestrictedCookieManagerPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'role', 4,
        0,
        network_mojom_RestrictedCookieManagerRoleSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'origin', 8,
        0,
        url_mojom_OriginSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isolationInfo', 16,
        0,
        network_mojom_IsolationInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'cookieSettingOverrides', 24,
        0,
        network_mojom_CookieSettingOverridesSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'devtoolsCookieSettingOverrides', 32,
        0,
        network_mojom_CookieSettingOverridesSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'cookieObserver', 40,
        0,
        mojo.internal.InterfaceProxy(network_mojom_CookieAccessObserverRemote),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 56],]);



/**
 * @record
 */
export class NetworkContext_GetRestrictedCookieManager_Params {
  constructor() {
    /** @type { !network_mojom_RestrictedCookieManagerPendingReceiver } */
    this.restrictedCookieManager;
    /** @type { !network_mojom_RestrictedCookieManagerRole } */
    this.role;
    /** @type { !url_mojom_Origin } */
    this.origin;
    /** @type { !network_mojom_IsolationInfo } */
    this.isolationInfo;
    /** @type { !network_mojom_CookieSettingOverrides } */
    this.cookieSettingOverrides;
    /** @type { !network_mojom_CookieSettingOverrides } */
    this.devtoolsCookieSettingOverrides;
    /** @type { (network_mojom_CookieAccessObserverRemote|undefined) } */
    this.cookieObserver;
  }
}



mojo.internal.Struct(
    NetworkContext_GetTrustTokenQueryAnswerer_ParamsSpec.$,
    'NetworkContext_GetTrustTokenQueryAnswerer_Params',
    [
      mojo.internal.StructField(
        'trustTokenQueryAnswerer', 0,
        0,
        mojo.internal.InterfaceRequest(network_mojom_TrustTokenQueryAnswererPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'topFrameOrigin', 8,
        0,
        url_mojom_OriginSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class NetworkContext_GetTrustTokenQueryAnswerer_Params {
  constructor() {
    /** @type { !network_mojom_TrustTokenQueryAnswererPendingReceiver } */
    this.trustTokenQueryAnswerer;
    /** @type { !url_mojom_Origin } */
    this.topFrameOrigin;
  }
}



mojo.internal.Struct(
    NetworkContext_ClearTrustTokenData_ParamsSpec.$,
    'NetworkContext_ClearTrustTokenData_Params',
    [
      mojo.internal.StructField(
        'filter', 0,
        0,
        network_mojom_ClearDataFilterSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkContext_ClearTrustTokenData_Params {
  constructor() {
    /** @type { (network_mojom_ClearDataFilter|undefined) } */
    this.filter;
  }
}



mojo.internal.Struct(
    NetworkContext_ClearTrustTokenData_ResponseParamsSpec.$,
    'NetworkContext_ClearTrustTokenData_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NetworkContext_ClearTrustTokenData_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    NetworkContext_ClearTrustTokenSessionOnlyData_ParamsSpec.$,
    'NetworkContext_ClearTrustTokenSessionOnlyData_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NetworkContext_ClearTrustTokenSessionOnlyData_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    NetworkContext_ClearTrustTokenSessionOnlyData_ResponseParamsSpec.$,
    'NetworkContext_ClearTrustTokenSessionOnlyData_ResponseParams',
    [
      mojo.internal.StructField(
        'anyDataDeleted', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkContext_ClearTrustTokenSessionOnlyData_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.anyDataDeleted;
  }
}



mojo.internal.Struct(
    NetworkContext_GetStoredTrustTokenCounts_ParamsSpec.$,
    'NetworkContext_GetStoredTrustTokenCounts_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NetworkContext_GetStoredTrustTokenCounts_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    NetworkContext_GetStoredTrustTokenCounts_ResponseParamsSpec.$,
    'NetworkContext_GetStoredTrustTokenCounts_ResponseParams',
    [
      mojo.internal.StructField(
        'tokens', 0,
        0,
        mojo.internal.Array(network_mojom_StoredTrustTokensForIssuerSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkContext_GetStoredTrustTokenCounts_ResponseParams {
  constructor() {
    /** @type { !Array<!network_mojom_StoredTrustTokensForIssuer> } */
    this.tokens;
  }
}



mojo.internal.Struct(
    NetworkContext_GetPrivateStateTokenRedemptionRecords_ParamsSpec.$,
    'NetworkContext_GetPrivateStateTokenRedemptionRecords_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NetworkContext_GetPrivateStateTokenRedemptionRecords_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    NetworkContext_GetPrivateStateTokenRedemptionRecords_ResponseParamsSpec.$,
    'NetworkContext_GetPrivateStateTokenRedemptionRecords_ResponseParams',
    [
      mojo.internal.StructField(
        'issuerRedemptionRecordMap', 0,
        0,
        mojo.internal.Map(url_mojom_OriginSpec.$, mojo.internal.Array(network_mojom_ToplevelRedemptionRecordSpec.$, false), false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkContext_GetPrivateStateTokenRedemptionRecords_ResponseParams {
  constructor() {
    /** @type { !Map<!url_mojom_Origin, !Array<!network_mojom_ToplevelRedemptionRecord>> } */
    this.issuerRedemptionRecordMap;
  }
}



mojo.internal.Struct(
    NetworkContext_GetIpProxyStatus_ParamsSpec.$,
    'NetworkContext_GetIpProxyStatus_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NetworkContext_GetIpProxyStatus_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    NetworkContext_GetIpProxyStatus_ResponseParamsSpec.$,
    'NetworkContext_GetIpProxyStatus_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        ipProtection_mojom_IpProxyStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkContext_GetIpProxyStatus_ResponseParams {
  constructor() {
    /** @type { !ipProtection_mojom_IpProxyStatus } */
    this.status;
  }
}



mojo.internal.Struct(
    NetworkContext_SetBypassIpProtectionProxy_ParamsSpec.$,
    'NetworkContext_SetBypassIpProtectionProxy_Params',
    [
      mojo.internal.StructField(
        'bypassProxy', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkContext_SetBypassIpProtectionProxy_Params {
  constructor() {
    /** @type { !boolean } */
    this.bypassProxy;
  }
}



mojo.internal.Struct(
    NetworkContext_DeleteStoredTrustTokens_ParamsSpec.$,
    'NetworkContext_DeleteStoredTrustTokens_Params',
    [
      mojo.internal.StructField(
        'issuer', 0,
        0,
        url_mojom_OriginSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkContext_DeleteStoredTrustTokens_Params {
  constructor() {
    /** @type { !url_mojom_Origin } */
    this.issuer;
  }
}



mojo.internal.Struct(
    NetworkContext_DeleteStoredTrustTokens_ResponseParamsSpec.$,
    'NetworkContext_DeleteStoredTrustTokens_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        network_mojom_DeleteStoredTrustTokensStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkContext_DeleteStoredTrustTokens_ResponseParams {
  constructor() {
    /** @type { !network_mojom_DeleteStoredTrustTokensStatus } */
    this.status;
  }
}



mojo.internal.Struct(
    NetworkContext_SetBlockTrustTokens_ParamsSpec.$,
    'NetworkContext_SetBlockTrustTokens_Params',
    [
      mojo.internal.StructField(
        'block', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkContext_SetBlockTrustTokens_Params {
  constructor() {
    /** @type { !boolean } */
    this.block;
  }
}



mojo.internal.Struct(
    NetworkContext_SetTrackingProtectionContentSetting_ParamsSpec.$,
    'NetworkContext_SetTrackingProtectionContentSetting_Params',
    [
      mojo.internal.StructField(
        'settings', 0,
        0,
        mojo.internal.Array(contentSettings_mojom_ContentSettingPatternSourceSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkContext_SetTrackingProtectionContentSetting_Params {
  constructor() {
    /** @type { !Array<!contentSettings_mojom_ContentSettingPatternSource> } */
    this.settings;
  }
}



mojo.internal.Struct(
    NetworkContext_ClearNetworkingHistoryBetween_ParamsSpec.$,
    'NetworkContext_ClearNetworkingHistoryBetween_Params',
    [
      mojo.internal.StructField(
        'startTime', 0,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'endTime', 8,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class NetworkContext_ClearNetworkingHistoryBetween_Params {
  constructor() {
    /** @type { !mojoBase_mojom_Time } */
    this.startTime;
    /** @type { !mojoBase_mojom_Time } */
    this.endTime;
  }
}



mojo.internal.Struct(
    NetworkContext_ClearNetworkingHistoryBetween_ResponseParamsSpec.$,
    'NetworkContext_ClearNetworkingHistoryBetween_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NetworkContext_ClearNetworkingHistoryBetween_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    NetworkContext_ClearHttpCache_ParamsSpec.$,
    'NetworkContext_ClearHttpCache_Params',
    [
      mojo.internal.StructField(
        'startTime', 0,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'endTime', 8,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'filter', 16,
        0,
        network_mojom_ClearDataFilterSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class NetworkContext_ClearHttpCache_Params {
  constructor() {
    /** @type { !mojoBase_mojom_Time } */
    this.startTime;
    /** @type { !mojoBase_mojom_Time } */
    this.endTime;
    /** @type { (network_mojom_ClearDataFilter|undefined) } */
    this.filter;
  }
}



mojo.internal.Struct(
    NetworkContext_ClearHttpCache_ResponseParamsSpec.$,
    'NetworkContext_ClearHttpCache_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NetworkContext_ClearHttpCache_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    NetworkContext_ComputeHttpCacheSize_ParamsSpec.$,
    'NetworkContext_ComputeHttpCacheSize_Params',
    [
      mojo.internal.StructField(
        'startTime', 0,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'endTime', 8,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class NetworkContext_ComputeHttpCacheSize_Params {
  constructor() {
    /** @type { !mojoBase_mojom_Time } */
    this.startTime;
    /** @type { !mojoBase_mojom_Time } */
    this.endTime;
  }
}



mojo.internal.Struct(
    NetworkContext_ComputeHttpCacheSize_ResponseParamsSpec.$,
    'NetworkContext_ComputeHttpCacheSize_ResponseParams',
    [
      mojo.internal.StructField(
        'isUpperBound', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sizeOrError', 8,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class NetworkContext_ComputeHttpCacheSize_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.isUpperBound;
    /** @type { !bigint } */
    this.sizeOrError;
  }
}



mojo.internal.Struct(
    NetworkContext_NotifyBrowserIdle_ParamsSpec.$,
    'NetworkContext_NotifyBrowserIdle_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NetworkContext_NotifyBrowserIdle_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    NetworkContext_NotifyExternalCacheHit_ParamsSpec.$,
    'NetworkContext_NotifyExternalCacheHit_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'httpMethod', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'key', 16,
        0,
        network_mojom_NetworkIsolationKeySpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'includeCredentials', 32,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class NetworkContext_NotifyExternalCacheHit_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.url;
    /** @type { !string } */
    this.httpMethod;
    /** @type { !network_mojom_NetworkIsolationKey } */
    this.key;
    /** @type { !boolean } */
    this.includeCredentials;
  }
}



mojo.internal.Struct(
    NetworkContext_ClearHostCache_ParamsSpec.$,
    'NetworkContext_ClearHostCache_Params',
    [
      mojo.internal.StructField(
        'filter', 0,
        0,
        network_mojom_ClearDataFilterSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkContext_ClearHostCache_Params {
  constructor() {
    /** @type { (network_mojom_ClearDataFilter|undefined) } */
    this.filter;
  }
}



mojo.internal.Struct(
    NetworkContext_ClearHostCache_ResponseParamsSpec.$,
    'NetworkContext_ClearHostCache_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NetworkContext_ClearHostCache_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    NetworkContext_ClearHttpAuthCache_ParamsSpec.$,
    'NetworkContext_ClearHttpAuthCache_Params',
    [
      mojo.internal.StructField(
        'startTime', 0,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'endTime', 8,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'filter', 16,
        0,
        network_mojom_ClearDataFilterSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class NetworkContext_ClearHttpAuthCache_Params {
  constructor() {
    /** @type { !mojoBase_mojom_Time } */
    this.startTime;
    /** @type { !mojoBase_mojom_Time } */
    this.endTime;
    /** @type { (network_mojom_ClearDataFilter|undefined) } */
    this.filter;
  }
}



mojo.internal.Struct(
    NetworkContext_ClearHttpAuthCache_ResponseParamsSpec.$,
    'NetworkContext_ClearHttpAuthCache_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NetworkContext_ClearHttpAuthCache_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    NetworkContext_ClearCorsPreflightCache_ParamsSpec.$,
    'NetworkContext_ClearCorsPreflightCache_Params',
    [
      mojo.internal.StructField(
        'filter', 0,
        0,
        network_mojom_ClearDataFilterSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkContext_ClearCorsPreflightCache_Params {
  constructor() {
    /** @type { (network_mojom_ClearDataFilter|undefined) } */
    this.filter;
  }
}



mojo.internal.Struct(
    NetworkContext_ClearCorsPreflightCache_ResponseParamsSpec.$,
    'NetworkContext_ClearCorsPreflightCache_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NetworkContext_ClearCorsPreflightCache_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    NetworkContext_ClearReportingCacheReports_ParamsSpec.$,
    'NetworkContext_ClearReportingCacheReports_Params',
    [
      mojo.internal.StructField(
        'filter', 0,
        0,
        network_mojom_ClearDataFilterSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkContext_ClearReportingCacheReports_Params {
  constructor() {
    /** @type { (network_mojom_ClearDataFilter|undefined) } */
    this.filter;
  }
}



mojo.internal.Struct(
    NetworkContext_ClearReportingCacheReports_ResponseParamsSpec.$,
    'NetworkContext_ClearReportingCacheReports_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NetworkContext_ClearReportingCacheReports_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    NetworkContext_ClearReportingCacheClients_ParamsSpec.$,
    'NetworkContext_ClearReportingCacheClients_Params',
    [
      mojo.internal.StructField(
        'filter', 0,
        0,
        network_mojom_ClearDataFilterSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkContext_ClearReportingCacheClients_Params {
  constructor() {
    /** @type { (network_mojom_ClearDataFilter|undefined) } */
    this.filter;
  }
}



mojo.internal.Struct(
    NetworkContext_ClearReportingCacheClients_ResponseParamsSpec.$,
    'NetworkContext_ClearReportingCacheClients_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NetworkContext_ClearReportingCacheClients_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    NetworkContext_ClearNetworkErrorLogging_ParamsSpec.$,
    'NetworkContext_ClearNetworkErrorLogging_Params',
    [
      mojo.internal.StructField(
        'filter', 0,
        0,
        network_mojom_ClearDataFilterSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkContext_ClearNetworkErrorLogging_Params {
  constructor() {
    /** @type { (network_mojom_ClearDataFilter|undefined) } */
    this.filter;
  }
}



mojo.internal.Struct(
    NetworkContext_ClearNetworkErrorLogging_ResponseParamsSpec.$,
    'NetworkContext_ClearNetworkErrorLogging_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NetworkContext_ClearNetworkErrorLogging_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    NetworkContext_ClearDomainReliability_ParamsSpec.$,
    'NetworkContext_ClearDomainReliability_Params',
    [
      mojo.internal.StructField(
        'filter', 0,
        0,
        network_mojom_ClearDataFilterSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'mode', 8,
        0,
        NetworkContext_DomainReliabilityClearModeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class NetworkContext_ClearDomainReliability_Params {
  constructor() {
    /** @type { (network_mojom_ClearDataFilter|undefined) } */
    this.filter;
    /** @type { !NetworkContext_DomainReliabilityClearMode } */
    this.mode;
  }
}



mojo.internal.Struct(
    NetworkContext_ClearDomainReliability_ResponseParamsSpec.$,
    'NetworkContext_ClearDomainReliability_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NetworkContext_ClearDomainReliability_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    NetworkContext_ClearSharedDictionaryCache_ParamsSpec.$,
    'NetworkContext_ClearSharedDictionaryCache_Params',
    [
      mojo.internal.StructField(
        'startTime', 0,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'endTime', 8,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'filter', 16,
        0,
        network_mojom_ClearDataFilterSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class NetworkContext_ClearSharedDictionaryCache_Params {
  constructor() {
    /** @type { !mojoBase_mojom_Time } */
    this.startTime;
    /** @type { !mojoBase_mojom_Time } */
    this.endTime;
    /** @type { (network_mojom_ClearDataFilter|undefined) } */
    this.filter;
  }
}



mojo.internal.Struct(
    NetworkContext_ClearSharedDictionaryCache_ResponseParamsSpec.$,
    'NetworkContext_ClearSharedDictionaryCache_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NetworkContext_ClearSharedDictionaryCache_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    NetworkContext_ClearSharedDictionaryCacheForIsolationKey_ParamsSpec.$,
    'NetworkContext_ClearSharedDictionaryCacheForIsolationKey_Params',
    [
      mojo.internal.StructField(
        'isolationKey', 0,
        0,
        network_mojom_SharedDictionaryIsolationKeySpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkContext_ClearSharedDictionaryCacheForIsolationKey_Params {
  constructor() {
    /** @type { !network_mojom_SharedDictionaryIsolationKey } */
    this.isolationKey;
  }
}



mojo.internal.Struct(
    NetworkContext_ClearSharedDictionaryCacheForIsolationKey_ResponseParamsSpec.$,
    'NetworkContext_ClearSharedDictionaryCacheForIsolationKey_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NetworkContext_ClearSharedDictionaryCacheForIsolationKey_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    NetworkContext_SetDocumentReportingEndpoints_ParamsSpec.$,
    'NetworkContext_SetDocumentReportingEndpoints_Params',
    [
      mojo.internal.StructField(
        'reportingSource', 0,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'origin', 8,
        0,
        url_mojom_OriginSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isolationInfo', 16,
        0,
        network_mojom_IsolationInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'endpoints', 24,
        0,
        mojo.internal.Map(mojo.internal.String, mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class NetworkContext_SetDocumentReportingEndpoints_Params {
  constructor() {
    /** @type { !mojoBase_mojom_UnguessableToken } */
    this.reportingSource;
    /** @type { !url_mojom_Origin } */
    this.origin;
    /** @type { !network_mojom_IsolationInfo } */
    this.isolationInfo;
    /** @type { !Object<!string, !string> } */
    this.endpoints;
  }
}



mojo.internal.Struct(
    NetworkContext_SetEnterpriseReportingEndpoints_ParamsSpec.$,
    'NetworkContext_SetEnterpriseReportingEndpoints_Params',
    [
      mojo.internal.StructField(
        'endpoints', 0,
        0,
        mojo.internal.Map(mojo.internal.String, url_mojom_UrlSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkContext_SetEnterpriseReportingEndpoints_Params {
  constructor() {
    /** @type { !Object<!string, !url_mojom_Url> } */
    this.endpoints;
  }
}



mojo.internal.Struct(
    NetworkContext_SendReportsAndRemoveSource_ParamsSpec.$,
    'NetworkContext_SendReportsAndRemoveSource_Params',
    [
      mojo.internal.StructField(
        'reportingSource', 0,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkContext_SendReportsAndRemoveSource_Params {
  constructor() {
    /** @type { !mojoBase_mojom_UnguessableToken } */
    this.reportingSource;
  }
}



mojo.internal.Struct(
    NetworkContext_QueueReport_ParamsSpec.$,
    'NetworkContext_QueueReport_Params',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'group', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'url', 16,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'reportingSource', 24,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'networkAnonymizationKey', 32,
        0,
        network_mojom_NetworkAnonymizationKeySpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'body', 48,
        0,
        mojoBase_mojom_DictionaryValueSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 64],]);



/**
 * @record
 */
export class NetworkContext_QueueReport_Params {
  constructor() {
    /** @type { !string } */
    this.type;
    /** @type { !string } */
    this.group;
    /** @type { !url_mojom_Url } */
    this.url;
    /** @type { (mojoBase_mojom_UnguessableToken|undefined) } */
    this.reportingSource;
    /** @type { !network_mojom_NetworkAnonymizationKey } */
    this.networkAnonymizationKey;
    /** @type { !mojoBase_mojom_DictionaryValue } */
    this.body;
  }
}



mojo.internal.Struct(
    NetworkContext_QueueEnterpriseReport_ParamsSpec.$,
    'NetworkContext_QueueEnterpriseReport_Params',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'group', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'url', 16,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'body', 24,
        0,
        mojoBase_mojom_DictionaryValueSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class NetworkContext_QueueEnterpriseReport_Params {
  constructor() {
    /** @type { !string } */
    this.type;
    /** @type { !string } */
    this.group;
    /** @type { !url_mojom_Url } */
    this.url;
    /** @type { !mojoBase_mojom_DictionaryValue } */
    this.body;
  }
}



mojo.internal.Struct(
    NetworkContext_QueueSignedExchangeReport_ParamsSpec.$,
    'NetworkContext_QueueSignedExchangeReport_Params',
    [
      mojo.internal.StructField(
        'report', 0,
        0,
        SignedExchangeReportSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'networkAnonymizationKey', 8,
        0,
        network_mojom_NetworkAnonymizationKeySpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class NetworkContext_QueueSignedExchangeReport_Params {
  constructor() {
    /** @type { !SignedExchangeReport } */
    this.report;
    /** @type { !network_mojom_NetworkAnonymizationKey } */
    this.networkAnonymizationKey;
  }
}



mojo.internal.Struct(
    NetworkContext_CloseAllConnections_ParamsSpec.$,
    'NetworkContext_CloseAllConnections_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NetworkContext_CloseAllConnections_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    NetworkContext_CloseAllConnections_ResponseParamsSpec.$,
    'NetworkContext_CloseAllConnections_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NetworkContext_CloseAllConnections_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    NetworkContext_CloseIdleConnections_ParamsSpec.$,
    'NetworkContext_CloseIdleConnections_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NetworkContext_CloseIdleConnections_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    NetworkContext_CloseIdleConnections_ResponseParamsSpec.$,
    'NetworkContext_CloseIdleConnections_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NetworkContext_CloseIdleConnections_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    NetworkContext_SetNetworkConditions_ParamsSpec.$,
    'NetworkContext_SetNetworkConditions_Params',
    [
      mojo.internal.StructField(
        'throttlingProfileId', 0,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'conditions', 8,
        0,
        mojo.internal.Array(MatchedNetworkConditionsSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class NetworkContext_SetNetworkConditions_Params {
  constructor() {
    /** @type { !mojoBase_mojom_UnguessableToken } */
    this.throttlingProfileId;
    /** @type { !Array<!MatchedNetworkConditions> } */
    this.conditions;
  }
}



mojo.internal.Struct(
    NetworkContext_EnableDurableMessageCollector_ParamsSpec.$,
    'NetworkContext_EnableDurableMessageCollector_Params',
    [
      mojo.internal.StructField(
        'throttlingProfileId', 0,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'receiver', 8,
        0,
        mojo.internal.InterfaceRequest(DurableMessageCollectorPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class NetworkContext_EnableDurableMessageCollector_Params {
  constructor() {
    /** @type { !mojoBase_mojom_UnguessableToken } */
    this.throttlingProfileId;
    /** @type { !DurableMessageCollectorPendingReceiver } */
    this.receiver;
  }
}



mojo.internal.Struct(
    NetworkContext_SetAcceptLanguage_ParamsSpec.$,
    'NetworkContext_SetAcceptLanguage_Params',
    [
      mojo.internal.StructField(
        'newAcceptLanguage', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkContext_SetAcceptLanguage_Params {
  constructor() {
    /** @type { !string } */
    this.newAcceptLanguage;
  }
}



mojo.internal.Struct(
    NetworkContext_SetEnableReferrers_ParamsSpec.$,
    'NetworkContext_SetEnableReferrers_Params',
    [
      mojo.internal.StructField(
        'enableReferrers', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkContext_SetEnableReferrers_Params {
  constructor() {
    /** @type { !boolean } */
    this.enableReferrers;
  }
}



mojo.internal.Struct(
    NetworkContext_SetCTPolicy_ParamsSpec.$,
    'NetworkContext_SetCTPolicy_Params',
    [
      mojo.internal.StructField(
        'ctPolicy', 0,
        0,
        CTPolicySpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkContext_SetCTPolicy_Params {
  constructor() {
    /** @type { !CTPolicy } */
    this.ctPolicy;
  }
}



mojo.internal.Struct(
    NetworkContext_CreateUDPSocket_ParamsSpec.$,
    'NetworkContext_CreateUDPSocket_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(network_mojom_UDPSocketPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'listener', 4,
        0,
        mojo.internal.InterfaceProxy(network_mojom_UDPSocketListenerRemote),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class NetworkContext_CreateUDPSocket_Params {
  constructor() {
    /** @type { !network_mojom_UDPSocketPendingReceiver } */
    this.receiver;
    /** @type { (network_mojom_UDPSocketListenerRemote|undefined) } */
    this.listener;
  }
}



mojo.internal.Struct(
    NetworkContext_CreateRestrictedUDPSocket_ParamsSpec.$,
    'NetworkContext_CreateRestrictedUDPSocket_Params',
    [
      mojo.internal.StructField(
        'addr', 0,
        0,
        network_mojom_IPEndPointSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'mode', 8,
        0,
        network_mojom_RestrictedUDPSocketModeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'trafficAnnotation', 16,
        0,
        network_mojom_MutableNetworkTrafficAnnotationTagSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'params', 24,
        0,
        network_mojom_RestrictedUDPSocketParamsSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'receiver', 12,
        0,
        mojo.internal.InterfaceRequest(network_mojom_RestrictedUDPSocketPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'listener', 32,
        0,
        mojo.internal.InterfaceProxy(network_mojom_UDPSocketListenerRemote),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'allowMulticast', 40,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 56],]);



/**
 * @record
 */
export class NetworkContext_CreateRestrictedUDPSocket_Params {
  constructor() {
    /** @type { !network_mojom_IPEndPoint } */
    this.addr;
    /** @type { !network_mojom_RestrictedUDPSocketMode } */
    this.mode;
    /** @type { !network_mojom_MutableNetworkTrafficAnnotationTag } */
    this.trafficAnnotation;
    /** @type { (network_mojom_RestrictedUDPSocketParams|undefined) } */
    this.params;
    /** @type { !network_mojom_RestrictedUDPSocketPendingReceiver } */
    this.receiver;
    /** @type { (network_mojom_UDPSocketListenerRemote|undefined) } */
    this.listener;
    /** @type { !boolean } */
    this.allowMulticast;
  }
}



mojo.internal.Struct(
    NetworkContext_CreateRestrictedUDPSocket_ResponseParamsSpec.$,
    'NetworkContext_CreateRestrictedUDPSocket_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'localAddrOut', 8,
        0,
        network_mojom_IPEndPointSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class NetworkContext_CreateRestrictedUDPSocket_ResponseParams {
  constructor() {
    /** @type { !number } */
    this.result;
    /** @type { (network_mojom_IPEndPoint|undefined) } */
    this.localAddrOut;
  }
}



mojo.internal.Struct(
    NetworkContext_CreateTCPServerSocket_ParamsSpec.$,
    'NetworkContext_CreateTCPServerSocket_Params',
    [
      mojo.internal.StructField(
        'localAddr', 0,
        0,
        network_mojom_IPEndPointSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'options', 8,
        0,
        network_mojom_TCPServerSocketOptionsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'trafficAnnotation', 16,
        0,
        network_mojom_MutableNetworkTrafficAnnotationTagSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'socket', 24,
        0,
        mojo.internal.InterfaceRequest(network_mojom_TCPServerSocketPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class NetworkContext_CreateTCPServerSocket_Params {
  constructor() {
    /** @type { !network_mojom_IPEndPoint } */
    this.localAddr;
    /** @type { !network_mojom_TCPServerSocketOptions } */
    this.options;
    /** @type { !network_mojom_MutableNetworkTrafficAnnotationTag } */
    this.trafficAnnotation;
    /** @type { !network_mojom_TCPServerSocketPendingReceiver } */
    this.socket;
  }
}



mojo.internal.Struct(
    NetworkContext_CreateTCPServerSocket_ResponseParamsSpec.$,
    'NetworkContext_CreateTCPServerSocket_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'localAddrOut', 8,
        0,
        network_mojom_IPEndPointSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class NetworkContext_CreateTCPServerSocket_ResponseParams {
  constructor() {
    /** @type { !number } */
    this.result;
    /** @type { (network_mojom_IPEndPoint|undefined) } */
    this.localAddrOut;
  }
}



mojo.internal.Struct(
    NetworkContext_CreateTCPConnectedSocket_ParamsSpec.$,
    'NetworkContext_CreateTCPConnectedSocket_Params',
    [
      mojo.internal.StructField(
        'localAddr', 0,
        0,
        network_mojom_IPEndPointSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'remoteAddrList', 8,
        0,
        network_mojom_AddressListSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'tcpConnectedSocketOptions', 16,
        0,
        network_mojom_TCPConnectedSocketOptionsSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'trafficAnnotation', 24,
        0,
        network_mojom_MutableNetworkTrafficAnnotationTagSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'socket', 32,
        0,
        mojo.internal.InterfaceRequest(network_mojom_TCPConnectedSocketPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'observer', 36,
        0,
        mojo.internal.InterfaceProxy(network_mojom_SocketObserverRemote),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 56],]);



/**
 * @record
 */
export class NetworkContext_CreateTCPConnectedSocket_Params {
  constructor() {
    /** @type { (network_mojom_IPEndPoint|undefined) } */
    this.localAddr;
    /** @type { !network_mojom_AddressList } */
    this.remoteAddrList;
    /** @type { (network_mojom_TCPConnectedSocketOptions|undefined) } */
    this.tcpConnectedSocketOptions;
    /** @type { !network_mojom_MutableNetworkTrafficAnnotationTag } */
    this.trafficAnnotation;
    /** @type { !network_mojom_TCPConnectedSocketPendingReceiver } */
    this.socket;
    /** @type { (network_mojom_SocketObserverRemote|undefined) } */
    this.observer;
  }
}



mojo.internal.Struct(
    NetworkContext_CreateTCPConnectedSocket_ResponseParamsSpec.$,
    'NetworkContext_CreateTCPConnectedSocket_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'localAddr', 8,
        0,
        network_mojom_IPEndPointSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'peerAddr', 16,
        0,
        network_mojom_IPEndPointSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'receiveStream', 4,
        0,
        mojo.internal.Handle,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sendStream', 24,
        0,
        mojo.internal.Handle,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class NetworkContext_CreateTCPConnectedSocket_ResponseParams {
  constructor() {
    /** @type { !number } */
    this.result;
    /** @type { (network_mojom_IPEndPoint|undefined) } */
    this.localAddr;
    /** @type { (network_mojom_IPEndPoint|undefined) } */
    this.peerAddr;
    /** @type { (MojoHandle|undefined) } */
    this.receiveStream;
    /** @type { (MojoHandle|undefined) } */
    this.sendStream;
  }
}



mojo.internal.Struct(
    NetworkContext_CreateTCPBoundSocket_ParamsSpec.$,
    'NetworkContext_CreateTCPBoundSocket_Params',
    [
      mojo.internal.StructField(
        'localAddr', 0,
        0,
        network_mojom_IPEndPointSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'trafficAnnotation', 8,
        0,
        network_mojom_MutableNetworkTrafficAnnotationTagSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'socket', 16,
        0,
        mojo.internal.InterfaceRequest(network_mojom_TCPBoundSocketPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class NetworkContext_CreateTCPBoundSocket_Params {
  constructor() {
    /** @type { !network_mojom_IPEndPoint } */
    this.localAddr;
    /** @type { !network_mojom_MutableNetworkTrafficAnnotationTag } */
    this.trafficAnnotation;
    /** @type { !network_mojom_TCPBoundSocketPendingReceiver } */
    this.socket;
  }
}



mojo.internal.Struct(
    NetworkContext_CreateTCPBoundSocket_ResponseParamsSpec.$,
    'NetworkContext_CreateTCPBoundSocket_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'localAddr', 8,
        0,
        network_mojom_IPEndPointSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class NetworkContext_CreateTCPBoundSocket_ResponseParams {
  constructor() {
    /** @type { !number } */
    this.result;
    /** @type { (network_mojom_IPEndPoint|undefined) } */
    this.localAddr;
  }
}



mojo.internal.Struct(
    NetworkContext_CreateProxyResolvingSocketFactory_ParamsSpec.$,
    'NetworkContext_CreateProxyResolvingSocketFactory_Params',
    [
      mojo.internal.StructField(
        'factory', 0,
        0,
        mojo.internal.InterfaceRequest(network_mojom_ProxyResolvingSocketFactoryPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkContext_CreateProxyResolvingSocketFactory_Params {
  constructor() {
    /** @type { !network_mojom_ProxyResolvingSocketFactoryPendingReceiver } */
    this.factory;
  }
}



mojo.internal.Struct(
    NetworkContext_LookUpProxyForURL_ParamsSpec.$,
    'NetworkContext_LookUpProxyForURL_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'networkAnonymizationKey', 8,
        0,
        network_mojom_NetworkAnonymizationKeySpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'proxyLookupClient', 24,
        0,
        mojo.internal.InterfaceProxy(network_mojom_ProxyLookupClientRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class NetworkContext_LookUpProxyForURL_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.url;
    /** @type { !network_mojom_NetworkAnonymizationKey } */
    this.networkAnonymizationKey;
    /** @type { !network_mojom_ProxyLookupClientRemote } */
    this.proxyLookupClient;
  }
}



mojo.internal.Struct(
    NetworkContext_ForceReloadProxyConfig_ParamsSpec.$,
    'NetworkContext_ForceReloadProxyConfig_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NetworkContext_ForceReloadProxyConfig_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    NetworkContext_ForceReloadProxyConfig_ResponseParamsSpec.$,
    'NetworkContext_ForceReloadProxyConfig_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NetworkContext_ForceReloadProxyConfig_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    NetworkContext_ClearBadProxiesCache_ParamsSpec.$,
    'NetworkContext_ClearBadProxiesCache_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NetworkContext_ClearBadProxiesCache_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    NetworkContext_ClearBadProxiesCache_ResponseParamsSpec.$,
    'NetworkContext_ClearBadProxiesCache_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NetworkContext_ClearBadProxiesCache_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    NetworkContext_CreateWebSocket_ParamsSpec.$,
    'NetworkContext_CreateWebSocket_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'requestedProtocols', 8,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'siteForCookies', 16,
        0,
        network_mojom_SiteForCookiesSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'storageAccessApiStatus', 24,
        0,
        network_mojom_StorageAccessApiStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isolationInfo', 32,
        0,
        network_mojom_IsolationInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'additionalHeaders', 40,
        0,
        mojo.internal.Array(network_mojom_HttpHeaderSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'processId', 28,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'origin', 48,
        0,
        url_mojom_OriginSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'clientSecurityState', 56,
        0,
        network_mojom_ClientSecurityStateSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'options', 64,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'trafficAnnotation', 72,
        0,
        network_mojom_MutableNetworkTrafficAnnotationTagSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'handshakeClient', 80,
        0,
        mojo.internal.InterfaceProxy(network_mojom_WebSocketHandshakeClientRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'urlLoaderNetworkObserver', 88,
        0,
        mojo.internal.InterfaceProxy(network_mojom_URLLoaderNetworkServiceObserverRemote),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'authHandler', 96,
        0,
        mojo.internal.InterfaceProxy(network_mojom_WebSocketAuthenticationHandlerRemote),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'headerClient', 104,
        0,
        mojo.internal.InterfaceProxy(TrustedHeaderClientRemote),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'throttlingProfileId', 112,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 128],]);



/**
 * @record
 */
export class NetworkContext_CreateWebSocket_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.url;
    /** @type { !Array<!string> } */
    this.requestedProtocols;
    /** @type { !network_mojom_SiteForCookies } */
    this.siteForCookies;
    /** @type { !network_mojom_StorageAccessApiStatus } */
    this.storageAccessApiStatus;
    /** @type { !network_mojom_IsolationInfo } */
    this.isolationInfo;
    /** @type { !Array<!network_mojom_HttpHeader> } */
    this.additionalHeaders;
    /** @type { !number } */
    this.processId;
    /** @type { !url_mojom_Origin } */
    this.origin;
    /** @type { !network_mojom_ClientSecurityState } */
    this.clientSecurityState;
    /** @type { !number } */
    this.options;
    /** @type { !network_mojom_MutableNetworkTrafficAnnotationTag } */
    this.trafficAnnotation;
    /** @type { !network_mojom_WebSocketHandshakeClientRemote } */
    this.handshakeClient;
    /** @type { (network_mojom_URLLoaderNetworkServiceObserverRemote|undefined) } */
    this.urlLoaderNetworkObserver;
    /** @type { (network_mojom_WebSocketAuthenticationHandlerRemote|undefined) } */
    this.authHandler;
    /** @type { (TrustedHeaderClientRemote|undefined) } */
    this.headerClient;
    /** @type { (mojoBase_mojom_UnguessableToken|undefined) } */
    this.throttlingProfileId;
  }
}



mojo.internal.Struct(
    NetworkContext_CreateWebTransport_ParamsSpec.$,
    'NetworkContext_CreateWebTransport_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'origin', 8,
        0,
        url_mojom_OriginSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'networkAnonymizationKey', 16,
        0,
        network_mojom_NetworkAnonymizationKeySpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'fingerprints', 32,
        0,
        mojo.internal.Array(network_mojom_WebTransportCertificateFingerprintSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'applicationProtocols', 40,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'handshakeClient', 48,
        0,
        mojo.internal.InterfaceProxy(network_mojom_WebTransportHandshakeClientRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'urlLoaderNetworkObserver', 56,
        0,
        mojo.internal.InterfaceProxy(network_mojom_URLLoaderNetworkServiceObserverRemote),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'clientSecurityState', 64,
        0,
        network_mojom_ClientSecurityStateSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 80],]);



/**
 * @record
 */
export class NetworkContext_CreateWebTransport_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.url;
    /** @type { !url_mojom_Origin } */
    this.origin;
    /** @type { !network_mojom_NetworkAnonymizationKey } */
    this.networkAnonymizationKey;
    /** @type { !Array<!network_mojom_WebTransportCertificateFingerprint> } */
    this.fingerprints;
    /** @type { !Array<!string> } */
    this.applicationProtocols;
    /** @type { !network_mojom_WebTransportHandshakeClientRemote } */
    this.handshakeClient;
    /** @type { (network_mojom_URLLoaderNetworkServiceObserverRemote|undefined) } */
    this.urlLoaderNetworkObserver;
    /** @type { !network_mojom_ClientSecurityState } */
    this.clientSecurityState;
  }
}



mojo.internal.Struct(
    NetworkContext_CreateNetLogExporter_ParamsSpec.$,
    'NetworkContext_CreateNetLogExporter_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(network_mojom_NetLogExporterPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkContext_CreateNetLogExporter_Params {
  constructor() {
    /** @type { !network_mojom_NetLogExporterPendingReceiver } */
    this.receiver;
  }
}



mojo.internal.Struct(
    NetworkContext_PreconnectSockets_ParamsSpec.$,
    'NetworkContext_PreconnectSockets_Params',
    [
      mojo.internal.StructField(
        'numStreams', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'url', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'credentialsMode', 4,
        0,
        network_mojom_CredentialsModeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'networkAnonymizationKey', 16,
        0,
        network_mojom_NetworkAnonymizationKeySpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'trafficAnnotation', 32,
        0,
        network_mojom_MutableNetworkTrafficAnnotationTagSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'keepaliveConfig', 40,
        0,
        network_mojom_ConnectionKeepAliveConfigSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'observerClient', 48,
        0,
        mojo.internal.InterfaceProxy(network_mojom_ConnectionChangeObserverClientRemote),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 64],]);



/**
 * @record
 */
export class NetworkContext_PreconnectSockets_Params {
  constructor() {
    /** @type { !number } */
    this.numStreams;
    /** @type { !url_mojom_Url } */
    this.url;
    /** @type { !network_mojom_CredentialsMode } */
    this.credentialsMode;
    /** @type { !network_mojom_NetworkAnonymizationKey } */
    this.networkAnonymizationKey;
    /** @type { !network_mojom_MutableNetworkTrafficAnnotationTag } */
    this.trafficAnnotation;
    /** @type { (network_mojom_ConnectionKeepAliveConfig|undefined) } */
    this.keepaliveConfig;
    /** @type { (network_mojom_ConnectionChangeObserverClientRemote|undefined) } */
    this.observerClient;
  }
}



mojo.internal.Struct(
    NetworkContext_CreateP2PSocketManager_ParamsSpec.$,
    'NetworkContext_CreateP2PSocketManager_Params',
    [
      mojo.internal.StructField(
        'networkAnonymizationKey', 0,
        0,
        network_mojom_NetworkAnonymizationKeySpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'client', 16,
        0,
        mojo.internal.InterfaceProxy(network_mojom_P2PTrustedSocketManagerClientRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'trustedSocketManager', 24,
        0,
        mojo.internal.InterfaceRequest(network_mojom_P2PTrustedSocketManagerPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'socketManager', 28,
        0,
        mojo.internal.InterfaceRequest(network_mojom_P2PSocketManagerPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class NetworkContext_CreateP2PSocketManager_Params {
  constructor() {
    /** @type { !network_mojom_NetworkAnonymizationKey } */
    this.networkAnonymizationKey;
    /** @type { !network_mojom_P2PTrustedSocketManagerClientRemote } */
    this.client;
    /** @type { !network_mojom_P2PTrustedSocketManagerPendingReceiver } */
    this.trustedSocketManager;
    /** @type { !network_mojom_P2PSocketManagerPendingReceiver } */
    this.socketManager;
  }
}



mojo.internal.Struct(
    NetworkContext_CreateMdnsResponder_ParamsSpec.$,
    'NetworkContext_CreateMdnsResponder_Params',
    [
      mojo.internal.StructField(
        'responderReceiver', 0,
        0,
        mojo.internal.InterfaceRequest(network_mojom_MdnsResponderPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkContext_CreateMdnsResponder_Params {
  constructor() {
    /** @type { !network_mojom_MdnsResponderPendingReceiver } */
    this.responderReceiver;
  }
}



mojo.internal.Struct(
    NetworkContext_ResolveHost_ParamsSpec.$,
    'NetworkContext_ResolveHost_Params',
    [
      mojo.internal.StructField(
        'host', 0,
        0,
        network_mojom_HostResolverHostSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'networkAnonymizationKey', 16,
        0,
        network_mojom_NetworkAnonymizationKeySpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'optionalParameters', 32,
        0,
        network_mojom_ResolveHostParametersSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'responseClient', 40,
        0,
        mojo.internal.InterfaceProxy(network_mojom_ResolveHostClientRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 56],]);



/**
 * @record
 */
export class NetworkContext_ResolveHost_Params {
  constructor() {
    /** @type { !network_mojom_HostResolverHost } */
    this.host;
    /** @type { !network_mojom_NetworkAnonymizationKey } */
    this.networkAnonymizationKey;
    /** @type { (network_mojom_ResolveHostParameters|undefined) } */
    this.optionalParameters;
    /** @type { !network_mojom_ResolveHostClientRemote } */
    this.responseClient;
  }
}



mojo.internal.Struct(
    NetworkContext_CreateHostResolver_ParamsSpec.$,
    'NetworkContext_CreateHostResolver_Params',
    [
      mojo.internal.StructField(
        'configOverrides', 0,
        0,
        network_mojom_DnsConfigOverridesSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hostResolver', 8,
        0,
        mojo.internal.InterfaceRequest(network_mojom_HostResolverPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class NetworkContext_CreateHostResolver_Params {
  constructor() {
    /** @type { (network_mojom_DnsConfigOverrides|undefined) } */
    this.configOverrides;
    /** @type { !network_mojom_HostResolverPendingReceiver } */
    this.hostResolver;
  }
}



mojo.internal.Struct(
    NetworkContext_VerifyCert_ParamsSpec.$,
    'NetworkContext_VerifyCert_Params',
    [
      mojo.internal.StructField(
        'certificate', 0,
        0,
        network_mojom_X509CertificateSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hostPort', 8,
        0,
        network_mojom_HostPortPairSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'ocspResponse', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sctList', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class NetworkContext_VerifyCert_Params {
  constructor() {
    /** @type { !network_mojom_X509Certificate } */
    this.certificate;
    /** @type { !network_mojom_HostPortPair } */
    this.hostPort;
    /** @type { !string } */
    this.ocspResponse;
    /** @type { !string } */
    this.sctList;
  }
}



mojo.internal.Struct(
    NetworkContext_VerifyCert_ResponseParamsSpec.$,
    'NetworkContext_VerifyCert_ResponseParams',
    [
      mojo.internal.StructField(
        'errorCode', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'cvResult', 8,
        0,
        network_mojom_CertVerifyResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'pkpBypassed', 4,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class NetworkContext_VerifyCert_ResponseParams {
  constructor() {
    /** @type { !number } */
    this.errorCode;
    /** @type { !network_mojom_CertVerifyResult } */
    this.cvResult;
    /** @type { !boolean } */
    this.pkpBypassed;
  }
}



mojo.internal.Struct(
    NetworkContext_VerifyCertForSignedExchange_ParamsSpec.$,
    'NetworkContext_VerifyCertForSignedExchange_Params',
    [
      mojo.internal.StructField(
        'certificate', 0,
        0,
        network_mojom_X509CertificateSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hostPort', 8,
        0,
        network_mojom_HostPortPairSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'ocspResponse', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sctList', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class NetworkContext_VerifyCertForSignedExchange_Params {
  constructor() {
    /** @type { !network_mojom_X509Certificate } */
    this.certificate;
    /** @type { !network_mojom_HostPortPair } */
    this.hostPort;
    /** @type { !string } */
    this.ocspResponse;
    /** @type { !string } */
    this.sctList;
  }
}



mojo.internal.Struct(
    NetworkContext_VerifyCertForSignedExchange_ResponseParamsSpec.$,
    'NetworkContext_VerifyCertForSignedExchange_ResponseParams',
    [
      mojo.internal.StructField(
        'errorCode', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'cvResult', 8,
        0,
        network_mojom_CertVerifyResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'pkpBypassed', 4,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class NetworkContext_VerifyCertForSignedExchange_ResponseParams {
  constructor() {
    /** @type { !number } */
    this.errorCode;
    /** @type { !network_mojom_CertVerifyResult } */
    this.cvResult;
    /** @type { !boolean } */
    this.pkpBypassed;
  }
}



mojo.internal.Struct(
    NetworkContext_Verify2QwacCertBinding_ParamsSpec.$,
    'NetworkContext_Verify2QwacCertBinding_Params',
    [
      mojo.internal.StructField(
        'binding', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hostname', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'tlsCertificate', 16,
        0,
        network_mojom_X509CertificateSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class NetworkContext_Verify2QwacCertBinding_Params {
  constructor() {
    /** @type { !string } */
    this.binding;
    /** @type { !string } */
    this.hostname;
    /** @type { !network_mojom_X509Certificate } */
    this.tlsCertificate;
  }
}



mojo.internal.Struct(
    NetworkContext_Verify2QwacCertBinding_ResponseParamsSpec.$,
    'NetworkContext_Verify2QwacCertBinding_ResponseParams',
    [
      mojo.internal.StructField(
        'verifiedCert', 0,
        0,
        network_mojom_X509CertificateSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkContext_Verify2QwacCertBinding_ResponseParams {
  constructor() {
    /** @type { !network_mojom_X509Certificate } */
    this.verifiedCert;
  }
}



mojo.internal.Struct(
    NetworkContext_AddHSTS_ParamsSpec.$,
    'NetworkContext_AddHSTS_Params',
    [
      mojo.internal.StructField(
        'host', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'expiry', 8,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'includeSubdomains', 16,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class NetworkContext_AddHSTS_Params {
  constructor() {
    /** @type { !string } */
    this.host;
    /** @type { !mojoBase_mojom_Time } */
    this.expiry;
    /** @type { !boolean } */
    this.includeSubdomains;
  }
}



mojo.internal.Struct(
    NetworkContext_AddHSTS_ResponseParamsSpec.$,
    'NetworkContext_AddHSTS_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NetworkContext_AddHSTS_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    NetworkContext_IsHSTSActiveForHost_ParamsSpec.$,
    'NetworkContext_IsHSTSActiveForHost_Params',
    [
      mojo.internal.StructField(
        'host', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isTopLevelNav', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class NetworkContext_IsHSTSActiveForHost_Params {
  constructor() {
    /** @type { !string } */
    this.host;
    /** @type { !boolean } */
    this.isTopLevelNav;
  }
}



mojo.internal.Struct(
    NetworkContext_IsHSTSActiveForHost_ResponseParamsSpec.$,
    'NetworkContext_IsHSTSActiveForHost_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkContext_IsHSTSActiveForHost_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.result;
  }
}



mojo.internal.Struct(
    NetworkContext_GetHSTSState_ParamsSpec.$,
    'NetworkContext_GetHSTSState_Params',
    [
      mojo.internal.StructField(
        'domain', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkContext_GetHSTSState_Params {
  constructor() {
    /** @type { !string } */
    this.domain;
  }
}



mojo.internal.Struct(
    NetworkContext_GetHSTSState_ResponseParamsSpec.$,
    'NetworkContext_GetHSTSState_ResponseParams',
    [
      mojo.internal.StructField(
        'state', 0,
        0,
        mojoBase_mojom_DictionaryValueSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkContext_GetHSTSState_ResponseParams {
  constructor() {
    /** @type { !mojoBase_mojom_DictionaryValue } */
    this.state;
  }
}



mojo.internal.Struct(
    NetworkContext_SetCorsOriginAccessListsForOrigin_ParamsSpec.$,
    'NetworkContext_SetCorsOriginAccessListsForOrigin_Params',
    [
      mojo.internal.StructField(
        'sourceOrigin', 0,
        0,
        url_mojom_OriginSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'allowPatterns', 8,
        0,
        mojo.internal.Array(network_mojom_CorsOriginPatternSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'blockPatterns', 16,
        0,
        mojo.internal.Array(network_mojom_CorsOriginPatternSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class NetworkContext_SetCorsOriginAccessListsForOrigin_Params {
  constructor() {
    /** @type { !url_mojom_Origin } */
    this.sourceOrigin;
    /** @type { !Array<!network_mojom_CorsOriginPattern> } */
    this.allowPatterns;
    /** @type { !Array<!network_mojom_CorsOriginPattern> } */
    this.blockPatterns;
  }
}



mojo.internal.Struct(
    NetworkContext_SetCorsOriginAccessListsForOrigin_ResponseParamsSpec.$,
    'NetworkContext_SetCorsOriginAccessListsForOrigin_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NetworkContext_SetCorsOriginAccessListsForOrigin_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    NetworkContext_DeleteDynamicDataForHost_ParamsSpec.$,
    'NetworkContext_DeleteDynamicDataForHost_Params',
    [
      mojo.internal.StructField(
        'host', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkContext_DeleteDynamicDataForHost_Params {
  constructor() {
    /** @type { !string } */
    this.host;
  }
}



mojo.internal.Struct(
    NetworkContext_DeleteDynamicDataForHost_ResponseParamsSpec.$,
    'NetworkContext_DeleteDynamicDataForHost_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkContext_DeleteDynamicDataForHost_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.result;
  }
}



mojo.internal.Struct(
    NetworkContext_SetSplitAuthCacheByNetworkAnonymizationKey_ParamsSpec.$,
    'NetworkContext_SetSplitAuthCacheByNetworkAnonymizationKey_Params',
    [
      mojo.internal.StructField(
        'splitAuthCacheByNetworkAnonymizationKey', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkContext_SetSplitAuthCacheByNetworkAnonymizationKey_Params {
  constructor() {
    /** @type { !boolean } */
    this.splitAuthCacheByNetworkAnonymizationKey;
  }
}



mojo.internal.Struct(
    NetworkContext_SaveHttpAuthCacheProxyEntries_ParamsSpec.$,
    'NetworkContext_SaveHttpAuthCacheProxyEntries_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NetworkContext_SaveHttpAuthCacheProxyEntries_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    NetworkContext_SaveHttpAuthCacheProxyEntries_ResponseParamsSpec.$,
    'NetworkContext_SaveHttpAuthCacheProxyEntries_ResponseParams',
    [
      mojo.internal.StructField(
        'cacheKey', 0,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkContext_SaveHttpAuthCacheProxyEntries_ResponseParams {
  constructor() {
    /** @type { !mojoBase_mojom_UnguessableToken } */
    this.cacheKey;
  }
}



mojo.internal.Struct(
    NetworkContext_LoadHttpAuthCacheProxyEntries_ParamsSpec.$,
    'NetworkContext_LoadHttpAuthCacheProxyEntries_Params',
    [
      mojo.internal.StructField(
        'cacheKey', 0,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkContext_LoadHttpAuthCacheProxyEntries_Params {
  constructor() {
    /** @type { !mojoBase_mojom_UnguessableToken } */
    this.cacheKey;
  }
}



mojo.internal.Struct(
    NetworkContext_LoadHttpAuthCacheProxyEntries_ResponseParamsSpec.$,
    'NetworkContext_LoadHttpAuthCacheProxyEntries_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NetworkContext_LoadHttpAuthCacheProxyEntries_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    NetworkContext_AddAuthCacheEntry_ParamsSpec.$,
    'NetworkContext_AddAuthCacheEntry_Params',
    [
      mojo.internal.StructField(
        'challenge', 0,
        0,
        network_mojom_AuthChallengeInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'networkAnonymizationKey', 8,
        0,
        network_mojom_NetworkAnonymizationKeySpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'credentials', 24,
        0,
        network_mojom_AuthCredentialsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class NetworkContext_AddAuthCacheEntry_Params {
  constructor() {
    /** @type { !network_mojom_AuthChallengeInfo } */
    this.challenge;
    /** @type { !network_mojom_NetworkAnonymizationKey } */
    this.networkAnonymizationKey;
    /** @type { !network_mojom_AuthCredentials } */
    this.credentials;
  }
}



mojo.internal.Struct(
    NetworkContext_AddAuthCacheEntry_ResponseParamsSpec.$,
    'NetworkContext_AddAuthCacheEntry_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NetworkContext_AddAuthCacheEntry_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    NetworkContext_SetCorsNonWildcardRequestHeadersSupport_ParamsSpec.$,
    'NetworkContext_SetCorsNonWildcardRequestHeadersSupport_Params',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkContext_SetCorsNonWildcardRequestHeadersSupport_Params {
  constructor() {
    /** @type { !boolean } */
    this.value;
  }
}



mojo.internal.Struct(
    NetworkContext_LookupProxyAuthCredentials_ParamsSpec.$,
    'NetworkContext_LookupProxyAuthCredentials_Params',
    [
      mojo.internal.StructField(
        'proxyServer', 0,
        0,
        network_mojom_ProxyServerSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'authScheme', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'realm', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class NetworkContext_LookupProxyAuthCredentials_Params {
  constructor() {
    /** @type { !network_mojom_ProxyServer } */
    this.proxyServer;
    /** @type { !string } */
    this.authScheme;
    /** @type { !string } */
    this.realm;
  }
}



mojo.internal.Struct(
    NetworkContext_LookupProxyAuthCredentials_ResponseParamsSpec.$,
    'NetworkContext_LookupProxyAuthCredentials_ResponseParams',
    [
      mojo.internal.StructField(
        'credentials', 0,
        0,
        network_mojom_AuthCredentialsSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkContext_LookupProxyAuthCredentials_ResponseParams {
  constructor() {
    /** @type { (network_mojom_AuthCredentials|undefined) } */
    this.credentials;
  }
}



mojo.internal.Struct(
    NetworkContext_EnableStaticKeyPinningForTesting_ParamsSpec.$,
    'NetworkContext_EnableStaticKeyPinningForTesting_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NetworkContext_EnableStaticKeyPinningForTesting_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    NetworkContext_EnableStaticKeyPinningForTesting_ResponseParamsSpec.$,
    'NetworkContext_EnableStaticKeyPinningForTesting_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NetworkContext_EnableStaticKeyPinningForTesting_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    NetworkContext_VerifyCertificateForTesting_ParamsSpec.$,
    'NetworkContext_VerifyCertificateForTesting_Params',
    [
      mojo.internal.StructField(
        'certificate', 0,
        0,
        network_mojom_X509CertificateSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hostname', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'ocspResponse', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sctList', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class NetworkContext_VerifyCertificateForTesting_Params {
  constructor() {
    /** @type { !network_mojom_X509Certificate } */
    this.certificate;
    /** @type { !string } */
    this.hostname;
    /** @type { !string } */
    this.ocspResponse;
    /** @type { !string } */
    this.sctList;
  }
}



mojo.internal.Struct(
    NetworkContext_VerifyCertificateForTesting_ResponseParamsSpec.$,
    'NetworkContext_VerifyCertificateForTesting_ResponseParams',
    [
      mojo.internal.StructField(
        'errorCode', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkContext_VerifyCertificateForTesting_ResponseParams {
  constructor() {
    /** @type { !number } */
    this.errorCode;
  }
}



mojo.internal.Struct(
    NetworkContext_GetTrustAnchorIDsForTesting_ParamsSpec.$,
    'NetworkContext_GetTrustAnchorIDsForTesting_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NetworkContext_GetTrustAnchorIDsForTesting_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    NetworkContext_GetTrustAnchorIDsForTesting_ResponseParamsSpec.$,
    'NetworkContext_GetTrustAnchorIDsForTesting_ResponseParams',
    [
      mojo.internal.StructField(
        'trustAnchorIds', 0,
        0,
        mojo.internal.Array(mojo.internal.Array(mojo.internal.Uint8, false), false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkContext_GetTrustAnchorIDsForTesting_ResponseParams {
  constructor() {
    /** @type { !Array<!Array<!number>> } */
    this.trustAnchorIds;
  }
}



mojo.internal.Struct(
    NetworkContext_AddDomainReliabilityContextForTesting_ParamsSpec.$,
    'NetworkContext_AddDomainReliabilityContextForTesting_Params',
    [
      mojo.internal.StructField(
        'origin', 0,
        0,
        url_mojom_OriginSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'uploadUrl', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class NetworkContext_AddDomainReliabilityContextForTesting_Params {
  constructor() {
    /** @type { !url_mojom_Origin } */
    this.origin;
    /** @type { !url_mojom_Url } */
    this.uploadUrl;
  }
}



mojo.internal.Struct(
    NetworkContext_AddDomainReliabilityContextForTesting_ResponseParamsSpec.$,
    'NetworkContext_AddDomainReliabilityContextForTesting_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NetworkContext_AddDomainReliabilityContextForTesting_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    NetworkContext_ForceDomainReliabilityUploadsForTesting_ParamsSpec.$,
    'NetworkContext_ForceDomainReliabilityUploadsForTesting_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NetworkContext_ForceDomainReliabilityUploadsForTesting_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    NetworkContext_ForceDomainReliabilityUploadsForTesting_ResponseParamsSpec.$,
    'NetworkContext_ForceDomainReliabilityUploadsForTesting_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NetworkContext_ForceDomainReliabilityUploadsForTesting_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    NetworkContext_SetSCTAuditingMode_ParamsSpec.$,
    'NetworkContext_SetSCTAuditingMode_Params',
    [
      mojo.internal.StructField(
        'mode', 0,
        0,
        SCTAuditingModeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkContext_SetSCTAuditingMode_Params {
  constructor() {
    /** @type { !SCTAuditingMode } */
    this.mode;
  }
}



mojo.internal.Struct(
    NetworkContext_AddReportingApiObserver_ParamsSpec.$,
    'NetworkContext_AddReportingApiObserver_Params',
    [
      mojo.internal.StructField(
        'observer', 0,
        0,
        mojo.internal.InterfaceProxy(network_mojom_ReportingApiObserverRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkContext_AddReportingApiObserver_Params {
  constructor() {
    /** @type { !network_mojom_ReportingApiObserverRemote } */
    this.observer;
  }
}



mojo.internal.Struct(
    NetworkContext_GetSharedDictionaryUsageInfo_ParamsSpec.$,
    'NetworkContext_GetSharedDictionaryUsageInfo_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NetworkContext_GetSharedDictionaryUsageInfo_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    NetworkContext_GetSharedDictionaryUsageInfo_ResponseParamsSpec.$,
    'NetworkContext_GetSharedDictionaryUsageInfo_ResponseParams',
    [
      mojo.internal.StructField(
        'usageInfo', 0,
        0,
        mojo.internal.Array(network_mojom_SharedDictionaryUsageInfoSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkContext_GetSharedDictionaryUsageInfo_ResponseParams {
  constructor() {
    /** @type { !Array<!network_mojom_SharedDictionaryUsageInfo> } */
    this.usageInfo;
  }
}



mojo.internal.Struct(
    NetworkContext_GetSharedDictionaryInfo_ParamsSpec.$,
    'NetworkContext_GetSharedDictionaryInfo_Params',
    [
      mojo.internal.StructField(
        'isolationKey', 0,
        0,
        network_mojom_SharedDictionaryIsolationKeySpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkContext_GetSharedDictionaryInfo_Params {
  constructor() {
    /** @type { !network_mojom_SharedDictionaryIsolationKey } */
    this.isolationKey;
  }
}



mojo.internal.Struct(
    NetworkContext_GetSharedDictionaryInfo_ResponseParamsSpec.$,
    'NetworkContext_GetSharedDictionaryInfo_ResponseParams',
    [
      mojo.internal.StructField(
        'dictionaries', 0,
        0,
        mojo.internal.Array(SharedDictionaryInfoSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkContext_GetSharedDictionaryInfo_ResponseParams {
  constructor() {
    /** @type { !Array<!SharedDictionaryInfo> } */
    this.dictionaries;
  }
}



mojo.internal.Struct(
    NetworkContext_GetSharedDictionaryOriginsBetween_ParamsSpec.$,
    'NetworkContext_GetSharedDictionaryOriginsBetween_Params',
    [
      mojo.internal.StructField(
        'startTime', 0,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'endTime', 8,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class NetworkContext_GetSharedDictionaryOriginsBetween_Params {
  constructor() {
    /** @type { !mojoBase_mojom_Time } */
    this.startTime;
    /** @type { !mojoBase_mojom_Time } */
    this.endTime;
  }
}



mojo.internal.Struct(
    NetworkContext_GetSharedDictionaryOriginsBetween_ResponseParamsSpec.$,
    'NetworkContext_GetSharedDictionaryOriginsBetween_ResponseParams',
    [
      mojo.internal.StructField(
        'origins', 0,
        0,
        mojo.internal.Array(url_mojom_OriginSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkContext_GetSharedDictionaryOriginsBetween_ResponseParams {
  constructor() {
    /** @type { !Array<!url_mojom_Origin> } */
    this.origins;
  }
}



mojo.internal.Struct(
    NetworkContext_SetSharedDictionaryCacheMaxSize_ParamsSpec.$,
    'NetworkContext_SetSharedDictionaryCacheMaxSize_Params',
    [
      mojo.internal.StructField(
        'cacheMaxSize', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkContext_SetSharedDictionaryCacheMaxSize_Params {
  constructor() {
    /** @type { !bigint } */
    this.cacheMaxSize;
  }
}



mojo.internal.Struct(
    NetworkContext_PreloadSharedDictionaryInfoForDocument_ParamsSpec.$,
    'NetworkContext_PreloadSharedDictionaryInfoForDocument_Params',
    [
      mojo.internal.StructField(
        'urls', 0,
        0,
        mojo.internal.Array(url_mojom_UrlSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'preloadHandle', 8,
        0,
        mojo.internal.InterfaceRequest(PreloadedSharedDictionaryInfoHandlePendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class NetworkContext_PreloadSharedDictionaryInfoForDocument_Params {
  constructor() {
    /** @type { !Array<!url_mojom_Url> } */
    this.urls;
    /** @type { !PreloadedSharedDictionaryInfoHandlePendingReceiver } */
    this.preloadHandle;
  }
}



mojo.internal.Struct(
    NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_ParamsSpec.$,
    'NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_ResponseParamsSpec.$,
    'NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_ResponseParams',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.value;
  }
}



mojo.internal.Struct(
    NetworkContext_FlushCachedClientCertIfNeeded_ParamsSpec.$,
    'NetworkContext_FlushCachedClientCertIfNeeded_Params',
    [
      mojo.internal.StructField(
        'host', 0,
        0,
        network_mojom_HostPortPairSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'certificate', 8,
        0,
        network_mojom_X509CertificateSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class NetworkContext_FlushCachedClientCertIfNeeded_Params {
  constructor() {
    /** @type { !network_mojom_HostPortPair } */
    this.host;
    /** @type { !network_mojom_X509Certificate } */
    this.certificate;
  }
}



mojo.internal.Struct(
    NetworkContext_FlushMatchingCachedClientCert_ParamsSpec.$,
    'NetworkContext_FlushMatchingCachedClientCert_Params',
    [
      mojo.internal.StructField(
        'certificate', 0,
        0,
        network_mojom_X509CertificateSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkContext_FlushMatchingCachedClientCert_Params {
  constructor() {
    /** @type { !network_mojom_X509Certificate } */
    this.certificate;
  }
}



mojo.internal.Struct(
    NetworkContext_SetCookieDeprecationLabel_ParamsSpec.$,
    'NetworkContext_SetCookieDeprecationLabel_Params',
    [
      mojo.internal.StructField(
        'label', 0,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkContext_SetCookieDeprecationLabel_Params {
  constructor() {
    /** @type { (string|undefined) } */
    this.label;
  }
}



mojo.internal.Struct(
    NetworkContext_RevokeNetworkForNonces_ParamsSpec.$,
    'NetworkContext_RevokeNetworkForNonces_Params',
    [
      mojo.internal.StructField(
        'nonces', 0,
        0,
        mojo.internal.Array(mojoBase_mojom_UnguessableTokenSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkContext_RevokeNetworkForNonces_Params {
  constructor() {
    /** @type { !Array<!mojoBase_mojom_UnguessableToken> } */
    this.nonces;
  }
}



mojo.internal.Struct(
    NetworkContext_RevokeNetworkForNonces_ResponseParamsSpec.$,
    'NetworkContext_RevokeNetworkForNonces_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NetworkContext_RevokeNetworkForNonces_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    NetworkContext_ClearNonces_ParamsSpec.$,
    'NetworkContext_ClearNonces_Params',
    [
      mojo.internal.StructField(
        'nonces', 0,
        0,
        mojo.internal.Array(mojoBase_mojom_UnguessableTokenSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkContext_ClearNonces_Params {
  constructor() {
    /** @type { !Array<!mojoBase_mojom_UnguessableToken> } */
    this.nonces;
  }
}



mojo.internal.Struct(
    NetworkContext_ExemptUrlFromNetworkRevocationForNonce_ParamsSpec.$,
    'NetworkContext_ExemptUrlFromNetworkRevocationForNonce_Params',
    [
      mojo.internal.StructField(
        'exemptedUrl', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'nonce', 8,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class NetworkContext_ExemptUrlFromNetworkRevocationForNonce_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.exemptedUrl;
    /** @type { !mojoBase_mojom_UnguessableToken } */
    this.nonce;
  }
}



mojo.internal.Struct(
    NetworkContext_ExemptUrlFromNetworkRevocationForNonce_ResponseParamsSpec.$,
    'NetworkContext_ExemptUrlFromNetworkRevocationForNonce_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NetworkContext_ExemptUrlFromNetworkRevocationForNonce_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    NetworkContext_Prefetch_ParamsSpec.$,
    'NetworkContext_Prefetch_Params',
    [
      mojo.internal.StructField(
        'requestId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'options', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'request', 8,
        0,
        network_mojom_URLRequestSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'trafficAnnotation', 16,
        0,
        network_mojom_MutableNetworkTrafficAnnotationTagSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class NetworkContext_Prefetch_Params {
  constructor() {
    /** @type { !number } */
    this.requestId;
    /** @type { !number } */
    this.options;
    /** @type { !network_mojom_URLRequest } */
    this.request;
    /** @type { !network_mojom_MutableNetworkTrafficAnnotationTag } */
    this.trafficAnnotation;
  }
}



mojo.internal.Struct(
    NetworkContext_GetBoundNetworkForTesting_ParamsSpec.$,
    'NetworkContext_GetBoundNetworkForTesting_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NetworkContext_GetBoundNetworkForTesting_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    NetworkContext_GetBoundNetworkForTesting_ResponseParamsSpec.$,
    'NetworkContext_GetBoundNetworkForTesting_ResponseParams',
    [
      mojo.internal.StructField(
        'boundNetwork', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkContext_GetBoundNetworkForTesting_ResponseParams {
  constructor() {
    /** @type { !bigint } */
    this.boundNetwork;
  }
}



mojo.internal.Struct(
    NetworkContext_GetDeviceBoundSessionManager_ParamsSpec.$,
    'NetworkContext_GetDeviceBoundSessionManager_Params',
    [
      mojo.internal.StructField(
        'deviceBoundSessionManager', 0,
        0,
        mojo.internal.InterfaceRequest(network_mojom_DeviceBoundSessionManagerPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkContext_GetDeviceBoundSessionManager_Params {
  constructor() {
    /** @type { !network_mojom_DeviceBoundSessionManagerPendingReceiver } */
    this.deviceBoundSessionManager;
  }
}



mojo.internal.Struct(
    NetworkContext_AddQuicHints_ParamsSpec.$,
    'NetworkContext_AddQuicHints_Params',
    [
      mojo.internal.StructField(
        'origins', 0,
        0,
        mojo.internal.Array(url_mojom_SchemeHostPortSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'networkAnonymizationKey', 8,
        0,
        network_mojom_NetworkAnonymizationKeySpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class NetworkContext_AddQuicHints_Params {
  constructor() {
    /** @type { !Array<!url_mojom_SchemeHostPort> } */
    this.origins;
    /** @type { !network_mojom_NetworkAnonymizationKey } */
    this.networkAnonymizationKey;
  }
}

