// services/network/public/mojom/oblivious_http_request.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';

import {
  ByteString as mojoBase_mojom_ByteString,
  ByteStringSpec as mojoBase_mojom_ByteStringSpec
} from '../../../../mojo/public/mojom/base/byte_string.mojom.m.js';

import {
  TimeDelta as mojoBase_mojom_TimeDelta,
  TimeDeltaSpec as mojoBase_mojom_TimeDeltaSpec
} from '../../../../mojo/public/mojom/base/time.mojom.m.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../../url/mojom/url.mojom.m.js';

import {
  MutableNetworkTrafficAnnotationTag as network_mojom_MutableNetworkTrafficAnnotationTag,
  MutableNetworkTrafficAnnotationTagSpec as network_mojom_MutableNetworkTrafficAnnotationTagSpec
} from './mutable_network_traffic_annotation_tag.mojom.m.js';

import {
  HttpResponseHeaders as network_mojom_HttpResponseHeaders,
  HttpResponseHeadersSpec as network_mojom_HttpResponseHeadersSpec
} from './network_param.mojom.m.js';

import {
  TrustTokenParams as network_mojom_TrustTokenParams,
  TrustTokenParamsSpec as network_mojom_TrustTokenParamsSpec
} from './trust_tokens.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class ObliviousHttpClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.ObliviousHttpClient', scope);
  }
}

/** @interface */
export class ObliviousHttpClientInterface {
  
  /**
   * @param { !ObliviousHttpCompletionResult } response
   */

  onCompleted(response) {}
}

/**
 * @implements { ObliviousHttpClientInterface }
 */
export class ObliviousHttpClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ObliviousHttpClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ObliviousHttpClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ObliviousHttpClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !ObliviousHttpCompletionResult } response
   */

  onCompleted(
      response) {
    this.proxy.sendMessage(
        0,
        ObliviousHttpClient_OnCompleted_ParamsSpec.$,
        null,
        [
          response
        ],
        false);
  }
}

/**
 * An object which receives request messages for the ObliviousHttpClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ObliviousHttpClientReceiver {
  /**
   * @param {!ObliviousHttpClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ObliviousHttpClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ObliviousHttpClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ObliviousHttpClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ObliviousHttpClient_OnCompleted_ParamsSpec.$,
        null,
        impl.onCompleted.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class ObliviousHttpClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.ObliviousHttpClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ObliviousHttpClientRemote}
   */
  static getRemote() {
    let remote = new ObliviousHttpClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the ObliviousHttpClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ObliviousHttpClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ObliviousHttpClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ObliviousHttpClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onCompleted =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ObliviousHttpClient_OnCompleted_ParamsSpec.$,
        null,
        this.onCompleted.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ObliviousHttpRequestBodySpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ObliviousHttpResponseSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ObliviousHttpPaddingParametersSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ObliviousHttpRequestSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ObliviousHttpClient_OnCompleted_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const ObliviousHttpCompletionResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    ObliviousHttpRequestBodySpec.$,
    'ObliviousHttpRequestBody',
    [
      mojo.internal.StructField(
        'content', 0,
        0,
        mojoBase_mojom_ByteStringSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'contentType', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class ObliviousHttpRequestBody {
  constructor() {
    /** @type { !mojoBase_mojom_ByteString } */
    this.content;
    /** @type { !string } */
    this.contentType;
  }
}



mojo.internal.Struct(
    ObliviousHttpResponseSpec.$,
    'ObliviousHttpResponse',
    [
      mojo.internal.StructField(
        'responseCode', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'headers', 8,
        0,
        network_mojom_HttpResponseHeadersSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'responseBody', 16,
        0,
        mojoBase_mojom_ByteStringSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class ObliviousHttpResponse {
  constructor() {
    /** @type { !number } */
    this.responseCode;
    /** @type { !network_mojom_HttpResponseHeaders } */
    this.headers;
    /** @type { !mojoBase_mojom_ByteString } */
    this.responseBody;
  }
}



mojo.internal.Struct(
    ObliviousHttpPaddingParametersSpec.$,
    'ObliviousHttpPaddingParameters',
    [
      mojo.internal.StructField(
        'addExponentialPad', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'exponentialMean', 2,
        0,
        mojo.internal.Uint16,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'padToNextPowerOfTwo', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ObliviousHttpPaddingParameters {
  constructor() {
    /** @type { !boolean } */
    this.addExponentialPad;
    /** @type { !number } */
    this.exponentialMean;
    /** @type { !boolean } */
    this.padToNextPowerOfTwo;
  }
}



mojo.internal.Struct(
    ObliviousHttpRequestSpec.$,
    'ObliviousHttpRequest',
    [
      mojo.internal.StructField(
        'relayUrl', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'trafficAnnotation', 8,
        0,
        network_mojom_MutableNetworkTrafficAnnotationTagSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'timeoutDuration', 16,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'keyConfig', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'resourceUrl', 32,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'method', 40,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'requestBody', 48,
        0,
        ObliviousHttpRequestBodySpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'trustTokenParams', 56,
        0,
        network_mojom_TrustTokenParamsSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'paddingParams', 64,
        0,
        ObliviousHttpPaddingParametersSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 80],]);



/**
 * @record
 */
export class ObliviousHttpRequest {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.relayUrl;
    /** @type { !network_mojom_MutableNetworkTrafficAnnotationTag } */
    this.trafficAnnotation;
    /** @type { (mojoBase_mojom_TimeDelta|undefined) } */
    this.timeoutDuration;
    /** @type { !string } */
    this.keyConfig;
    /** @type { !url_mojom_Url } */
    this.resourceUrl;
    /** @type { !string } */
    this.method;
    /** @type { (ObliviousHttpRequestBody|undefined) } */
    this.requestBody;
    /** @type { (network_mojom_TrustTokenParams|undefined) } */
    this.trustTokenParams;
    /** @type { (ObliviousHttpPaddingParameters|undefined) } */
    this.paddingParams;
  }
}



mojo.internal.Struct(
    ObliviousHttpClient_OnCompleted_ParamsSpec.$,
    'ObliviousHttpClient_OnCompleted_Params',
    [
      mojo.internal.StructField(
        'response', 0,
        0,
        ObliviousHttpCompletionResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class ObliviousHttpClient_OnCompleted_Params {
  constructor() {
    /** @type { !ObliviousHttpCompletionResult } */
    this.response;
  }
}

mojo.internal.Union(
    ObliviousHttpCompletionResultSpec.$, 'ObliviousHttpCompletionResult',
    {
      'netError': {
        'ordinal': 0,
        'type': mojo.internal.Int32,
      },
      'outerResponseErrorCode': {
        'ordinal': 1,
        'type': mojo.internal.Int32,
      },
      'innerResponse': {
        'ordinal': 2,
        'type': ObliviousHttpResponseSpec.$,
      },
    });

/**
 * @typedef { {
 *   netError: (!number|undefined),
 *   outerResponseErrorCode: (!number|undefined),
 *   innerResponse: (!ObliviousHttpResponse|undefined),
 * } }
 */
export const ObliviousHttpCompletionResult = {};
