// services/network/public/mojom/proxy_resolving_socket.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../../url/mojom/url.mojom.m.js';

import {
  IPEndPoint as network_mojom_IPEndPoint,
  IPEndPointSpec as network_mojom_IPEndPointSpec
} from './ip_endpoint.mojom.m.js';

import {
  MutableNetworkTrafficAnnotationTag as network_mojom_MutableNetworkTrafficAnnotationTag,
  MutableNetworkTrafficAnnotationTagSpec as network_mojom_MutableNetworkTrafficAnnotationTagSpec
} from './mutable_network_traffic_annotation_tag.mojom.m.js';

import {
  NetworkAnonymizationKey as network_mojom_NetworkAnonymizationKey,
  NetworkAnonymizationKeySpec as network_mojom_NetworkAnonymizationKeySpec
} from './network_anonymization_key.mojom.m.js';

import {
  HostPortPair as network_mojom_HostPortPair,
  HostPortPairSpec as network_mojom_HostPortPairSpec
} from './network_param.mojom.m.js';

import {
  SocketObserverRemote as network_mojom_SocketObserverRemote,
  SocketObserverPendingReceiver as network_mojom_SocketObserverPendingReceiver
} from './tcp_socket.mojom.m.js';

import {
  TLSClientSocketRemote as network_mojom_TLSClientSocketRemote,
  TLSClientSocketPendingReceiver as network_mojom_TLSClientSocketPendingReceiver
} from './tls_socket.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class ProxyResolvingSocketPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.ProxyResolvingSocket', scope);
  }
}

/** @interface */
export class ProxyResolvingSocketInterface {
  
  /**
   * @param { !network_mojom_HostPortPair } hostPortPair
   * @param { !network_mojom_MutableNetworkTrafficAnnotationTag } trafficAnnotation
   * @param { !network_mojom_TLSClientSocketPendingReceiver } receiver
   * @param { ?network_mojom_SocketObserverRemote } observer
   * @return {!Promise<{
        netError: !number,
        receiveStream: ?MojoHandle,
        sendStream: ?MojoHandle,
   *  }>}
   */

  upgradeToTLS(hostPortPair, trafficAnnotation, receiver, observer) {}
}

/**
 * @implements { ProxyResolvingSocketInterface }
 */
export class ProxyResolvingSocketRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ProxyResolvingSocketPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ProxyResolvingSocketPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ProxyResolvingSocketPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !network_mojom_HostPortPair } hostPortPair
   * @param { !network_mojom_MutableNetworkTrafficAnnotationTag } trafficAnnotation
   * @param { !network_mojom_TLSClientSocketPendingReceiver } receiver
   * @param { ?network_mojom_SocketObserverRemote } observer
   * @return {!Promise<{
        netError: !number,
        receiveStream: ?MojoHandle,
        sendStream: ?MojoHandle,
   *  }>}
   */

  upgradeToTLS(
      hostPortPair,
      trafficAnnotation,
      receiver,
      observer) {
    return this.proxy.sendMessage(
        0,
        ProxyResolvingSocket_UpgradeToTLS_ParamsSpec.$,
        ProxyResolvingSocket_UpgradeToTLS_ResponseParamsSpec.$,
        [
          hostPortPair,
          trafficAnnotation,
          receiver,
          observer
        ],
        false);
  }
}

/**
 * An object which receives request messages for the ProxyResolvingSocket
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ProxyResolvingSocketReceiver {
  /**
   * @param {!ProxyResolvingSocketInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ProxyResolvingSocketRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ProxyResolvingSocketRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ProxyResolvingSocketRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ProxyResolvingSocket_UpgradeToTLS_ParamsSpec.$,
        ProxyResolvingSocket_UpgradeToTLS_ResponseParamsSpec.$,
        impl.upgradeToTLS.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class ProxyResolvingSocket {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.ProxyResolvingSocket";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ProxyResolvingSocketRemote}
   */
  static getRemote() {
    let remote = new ProxyResolvingSocketRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the ProxyResolvingSocket
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ProxyResolvingSocketCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ProxyResolvingSocketRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ProxyResolvingSocketRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.upgradeToTLS =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ProxyResolvingSocket_UpgradeToTLS_ParamsSpec.$,
        ProxyResolvingSocket_UpgradeToTLS_ResponseParamsSpec.$,
        this.upgradeToTLS.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class ProxyResolvingSocketFactoryPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.ProxyResolvingSocketFactory', scope);
  }
}

/** @interface */
export class ProxyResolvingSocketFactoryInterface {
  
  /**
   * @param { !url_mojom_Url } url
   * @param { !network_mojom_NetworkAnonymizationKey } networkAnonymizationKey
   * @param { ?ProxyResolvingSocketOptions } options
   * @param { !network_mojom_MutableNetworkTrafficAnnotationTag } trafficAnnotation
   * @param { !ProxyResolvingSocketPendingReceiver } socket
   * @param { ?network_mojom_SocketObserverRemote } observer
   * @return {!Promise<{
        result: !number,
        localAddr: ?network_mojom_IPEndPoint,
        peerAddr: ?network_mojom_IPEndPoint,
        receiveStream: ?MojoHandle,
        sendStream: ?MojoHandle,
   *  }>}
   */

  createProxyResolvingSocket(url, networkAnonymizationKey, options, trafficAnnotation, socket, observer) {}
}

/**
 * @implements { ProxyResolvingSocketFactoryInterface }
 */
export class ProxyResolvingSocketFactoryRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ProxyResolvingSocketFactoryPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ProxyResolvingSocketFactoryPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ProxyResolvingSocketFactoryPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !url_mojom_Url } url
   * @param { !network_mojom_NetworkAnonymizationKey } networkAnonymizationKey
   * @param { ?ProxyResolvingSocketOptions } options
   * @param { !network_mojom_MutableNetworkTrafficAnnotationTag } trafficAnnotation
   * @param { !ProxyResolvingSocketPendingReceiver } socket
   * @param { ?network_mojom_SocketObserverRemote } observer
   * @return {!Promise<{
        result: !number,
        localAddr: ?network_mojom_IPEndPoint,
        peerAddr: ?network_mojom_IPEndPoint,
        receiveStream: ?MojoHandle,
        sendStream: ?MojoHandle,
   *  }>}
   */

  createProxyResolvingSocket(
      url,
      networkAnonymizationKey,
      options,
      trafficAnnotation,
      socket,
      observer) {
    return this.proxy.sendMessage(
        0,
        ProxyResolvingSocketFactory_CreateProxyResolvingSocket_ParamsSpec.$,
        ProxyResolvingSocketFactory_CreateProxyResolvingSocket_ResponseParamsSpec.$,
        [
          url,
          networkAnonymizationKey,
          options,
          trafficAnnotation,
          socket,
          observer
        ],
        false);
  }
}

/**
 * An object which receives request messages for the ProxyResolvingSocketFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ProxyResolvingSocketFactoryReceiver {
  /**
   * @param {!ProxyResolvingSocketFactoryInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ProxyResolvingSocketFactoryRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ProxyResolvingSocketFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ProxyResolvingSocketFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ProxyResolvingSocketFactory_CreateProxyResolvingSocket_ParamsSpec.$,
        ProxyResolvingSocketFactory_CreateProxyResolvingSocket_ResponseParamsSpec.$,
        impl.createProxyResolvingSocket.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class ProxyResolvingSocketFactory {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.ProxyResolvingSocketFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ProxyResolvingSocketFactoryRemote}
   */
  static getRemote() {
    let remote = new ProxyResolvingSocketFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the ProxyResolvingSocketFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ProxyResolvingSocketFactoryCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ProxyResolvingSocketFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ProxyResolvingSocketFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createProxyResolvingSocket =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ProxyResolvingSocketFactory_CreateProxyResolvingSocket_ParamsSpec.$,
        ProxyResolvingSocketFactory_CreateProxyResolvingSocket_ResponseParamsSpec.$,
        this.createProxyResolvingSocket.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ProxyResolvingSocketOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ProxyResolvingSocket_UpgradeToTLS_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ProxyResolvingSocket_UpgradeToTLS_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ProxyResolvingSocketFactory_CreateProxyResolvingSocket_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ProxyResolvingSocketFactory_CreateProxyResolvingSocket_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    ProxyResolvingSocketOptionsSpec.$,
    'ProxyResolvingSocketOptions',
    [
      mojo.internal.StructField(
        'useTls', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ProxyResolvingSocketOptions {
  constructor() {
    /** @type { !boolean } */
    this.useTls;
  }
}



mojo.internal.Struct(
    ProxyResolvingSocket_UpgradeToTLS_ParamsSpec.$,
    'ProxyResolvingSocket_UpgradeToTLS_Params',
    [
      mojo.internal.StructField(
        'hostPortPair', 0,
        0,
        network_mojom_HostPortPairSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'trafficAnnotation', 8,
        0,
        network_mojom_MutableNetworkTrafficAnnotationTagSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'receiver', 16,
        0,
        mojo.internal.InterfaceRequest(network_mojom_TLSClientSocketPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'observer', 20,
        0,
        mojo.internal.InterfaceProxy(network_mojom_SocketObserverRemote),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class ProxyResolvingSocket_UpgradeToTLS_Params {
  constructor() {
    /** @type { !network_mojom_HostPortPair } */
    this.hostPortPair;
    /** @type { !network_mojom_MutableNetworkTrafficAnnotationTag } */
    this.trafficAnnotation;
    /** @type { !network_mojom_TLSClientSocketPendingReceiver } */
    this.receiver;
    /** @type { (network_mojom_SocketObserverRemote|undefined) } */
    this.observer;
  }
}



mojo.internal.Struct(
    ProxyResolvingSocket_UpgradeToTLS_ResponseParamsSpec.$,
    'ProxyResolvingSocket_UpgradeToTLS_ResponseParams',
    [
      mojo.internal.StructField(
        'netError', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'receiveStream', 4,
        0,
        mojo.internal.Handle,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sendStream', 8,
        0,
        mojo.internal.Handle,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class ProxyResolvingSocket_UpgradeToTLS_ResponseParams {
  constructor() {
    /** @type { !number } */
    this.netError;
    /** @type { (MojoHandle|undefined) } */
    this.receiveStream;
    /** @type { (MojoHandle|undefined) } */
    this.sendStream;
  }
}



mojo.internal.Struct(
    ProxyResolvingSocketFactory_CreateProxyResolvingSocket_ParamsSpec.$,
    'ProxyResolvingSocketFactory_CreateProxyResolvingSocket_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'networkAnonymizationKey', 8,
        0,
        network_mojom_NetworkAnonymizationKeySpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'options', 24,
        0,
        ProxyResolvingSocketOptionsSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'trafficAnnotation', 32,
        0,
        network_mojom_MutableNetworkTrafficAnnotationTagSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'socket', 40,
        0,
        mojo.internal.InterfaceRequest(ProxyResolvingSocketPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'observer', 44,
        0,
        mojo.internal.InterfaceProxy(network_mojom_SocketObserverRemote),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 64],]);



/**
 * @record
 */
export class ProxyResolvingSocketFactory_CreateProxyResolvingSocket_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.url;
    /** @type { !network_mojom_NetworkAnonymizationKey } */
    this.networkAnonymizationKey;
    /** @type { (ProxyResolvingSocketOptions|undefined) } */
    this.options;
    /** @type { !network_mojom_MutableNetworkTrafficAnnotationTag } */
    this.trafficAnnotation;
    /** @type { !ProxyResolvingSocketPendingReceiver } */
    this.socket;
    /** @type { (network_mojom_SocketObserverRemote|undefined) } */
    this.observer;
  }
}



mojo.internal.Struct(
    ProxyResolvingSocketFactory_CreateProxyResolvingSocket_ResponseParamsSpec.$,
    'ProxyResolvingSocketFactory_CreateProxyResolvingSocket_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'localAddr', 8,
        0,
        network_mojom_IPEndPointSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'peerAddr', 16,
        0,
        network_mojom_IPEndPointSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'receiveStream', 4,
        0,
        mojo.internal.Handle,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sendStream', 24,
        0,
        mojo.internal.Handle,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class ProxyResolvingSocketFactory_CreateProxyResolvingSocket_ResponseParams {
  constructor() {
    /** @type { !number } */
    this.result;
    /** @type { (network_mojom_IPEndPoint|undefined) } */
    this.localAddr;
    /** @type { (network_mojom_IPEndPoint|undefined) } */
    this.peerAddr;
    /** @type { (MojoHandle|undefined) } */
    this.receiveStream;
    /** @type { (MojoHandle|undefined) } */
    this.sendStream;
  }
}

