// services/network/public/mojom/restricted_udp_socket.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('network.mojom.DnsQueryType');
goog.require('network.mojom.SocketConnectionTracker');
goog.require('network.mojom.HostPortPair');
goog.require('network.mojom.IPAddress');
goog.require('mojoBase.mojom.ReadOnlyBuffer');
goog.require('network.mojom.UDPSocketOptions');




goog.provide('network.mojom.RestrictedUDPSocketMode');
goog.provide('network.mojom.RestrictedUDPSocketModeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
network.mojom.RestrictedUDPSocketModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
network.mojom.RestrictedUDPSocketMode = {
  
  CONNECTED: 0,
  BOUND: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};



goog.provide('network.mojom.RestrictedUDPSocket');
goog.provide('network.mojom.RestrictedUDPSocketReceiver');
goog.provide('network.mojom.RestrictedUDPSocketCallbackRouter');
goog.provide('network.mojom.RestrictedUDPSocketInterface');
goog.provide('network.mojom.RestrictedUDPSocketRemote');
goog.provide('network.mojom.RestrictedUDPSocketPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
network.mojom.RestrictedUDPSocketPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        network.mojom.RestrictedUDPSocket.$interfaceName,
        scope);
  }
};

/** @interface */
network.mojom.RestrictedUDPSocketInterface = class {
  
  /**
   * @param { !network.mojom.IPAddress } groupAddress
   * @return {!Promise<{
        result: !number,
   *  }>}
   */

  joinGroup(groupAddress) {}
  
  /**
   * @param { !network.mojom.IPAddress } groupAddress
   * @return {!Promise<{
        result: !number,
   *  }>}
   */

  leaveGroup(groupAddress) {}
  
  /**
   * @param { !number } numAdditionalDatagrams
   */

  receiveMore(numAdditionalDatagrams) {}
  
  /**
   * @param { !mojoBase.mojom.ReadOnlyBuffer } data
   * @return {!Promise<{
        result: !number,
   *  }>}
   */

  send(data) {}
  
  /**
   * @param { !mojoBase.mojom.ReadOnlyBuffer } data
   * @param { !network.mojom.HostPortPair } destAddr
   * @param { !network.mojom.DnsQueryType } dnsQueryType
   * @return {!Promise<{
        result: !number,
   *  }>}
   */

  sendTo(data, destAddr, dnsQueryType) {}
};

/**
 * @export
 * @implements { network.mojom.RestrictedUDPSocketInterface }
 */
network.mojom.RestrictedUDPSocketRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!network.mojom.RestrictedUDPSocketPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          network.mojom.RestrictedUDPSocketPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!network.mojom.RestrictedUDPSocketPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !network.mojom.IPAddress } groupAddress
   * @return {!Promise<{
        result: !number,
   *  }>}
   */

  joinGroup(
      groupAddress) {
    return this.proxy.sendMessage(
        0,
        network.mojom.RestrictedUDPSocket_JoinGroup_ParamsSpec.$,
        network.mojom.RestrictedUDPSocket_JoinGroup_ResponseParamsSpec.$,
        [
          groupAddress
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.IPAddress } groupAddress
   * @return {!Promise<{
        result: !number,
   *  }>}
   */

  leaveGroup(
      groupAddress) {
    return this.proxy.sendMessage(
        1,
        network.mojom.RestrictedUDPSocket_LeaveGroup_ParamsSpec.$,
        network.mojom.RestrictedUDPSocket_LeaveGroup_ResponseParamsSpec.$,
        [
          groupAddress
        ],
        false);
  }

  
  /**
   * @param { !number } numAdditionalDatagrams
   */

  receiveMore(
      numAdditionalDatagrams) {
    this.proxy.sendMessage(
        2,
        network.mojom.RestrictedUDPSocket_ReceiveMore_ParamsSpec.$,
        null,
        [
          numAdditionalDatagrams
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.ReadOnlyBuffer } data
   * @return {!Promise<{
        result: !number,
   *  }>}
   */

  send(
      data) {
    return this.proxy.sendMessage(
        3,
        network.mojom.RestrictedUDPSocket_Send_ParamsSpec.$,
        network.mojom.RestrictedUDPSocket_Send_ResponseParamsSpec.$,
        [
          data
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.ReadOnlyBuffer } data
   * @param { !network.mojom.HostPortPair } destAddr
   * @param { !network.mojom.DnsQueryType } dnsQueryType
   * @return {!Promise<{
        result: !number,
   *  }>}
   */

  sendTo(
      data,
      destAddr,
      dnsQueryType) {
    return this.proxy.sendMessage(
        4,
        network.mojom.RestrictedUDPSocket_SendTo_ParamsSpec.$,
        network.mojom.RestrictedUDPSocket_SendTo_ResponseParamsSpec.$,
        [
          data,
          destAddr,
          dnsQueryType
        ],
        false);
  }
};

/**
 * An object which receives request messages for the RestrictedUDPSocket
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
network.mojom.RestrictedUDPSocketReceiver = class {
  /**
   * @param {!network.mojom.RestrictedUDPSocketInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!network.mojom.RestrictedUDPSocketRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        network.mojom.RestrictedUDPSocketRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.RestrictedUDPSocketRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        network.mojom.RestrictedUDPSocket_JoinGroup_ParamsSpec.$,
        network.mojom.RestrictedUDPSocket_JoinGroup_ResponseParamsSpec.$,
        impl.joinGroup.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        network.mojom.RestrictedUDPSocket_LeaveGroup_ParamsSpec.$,
        network.mojom.RestrictedUDPSocket_LeaveGroup_ResponseParamsSpec.$,
        impl.leaveGroup.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        network.mojom.RestrictedUDPSocket_ReceiveMore_ParamsSpec.$,
        null,
        impl.receiveMore.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        network.mojom.RestrictedUDPSocket_Send_ParamsSpec.$,
        network.mojom.RestrictedUDPSocket_Send_ResponseParamsSpec.$,
        impl.send.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        network.mojom.RestrictedUDPSocket_SendTo_ParamsSpec.$,
        network.mojom.RestrictedUDPSocket_SendTo_ResponseParamsSpec.$,
        impl.sendTo.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
network.mojom.RestrictedUDPSocket = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.RestrictedUDPSocket";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!network.mojom.RestrictedUDPSocketRemote}
   * @export
   */
  static getRemote() {
    let remote = new network.mojom.RestrictedUDPSocketRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the RestrictedUDPSocket
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
network.mojom.RestrictedUDPSocketCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      network.mojom.RestrictedUDPSocketRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.RestrictedUDPSocketRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.joinGroup =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        network.mojom.RestrictedUDPSocket_JoinGroup_ParamsSpec.$,
        network.mojom.RestrictedUDPSocket_JoinGroup_ResponseParamsSpec.$,
        this.joinGroup.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.leaveGroup =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        network.mojom.RestrictedUDPSocket_LeaveGroup_ParamsSpec.$,
        network.mojom.RestrictedUDPSocket_LeaveGroup_ResponseParamsSpec.$,
        this.leaveGroup.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.receiveMore =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        network.mojom.RestrictedUDPSocket_ReceiveMore_ParamsSpec.$,
        null,
        this.receiveMore.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.send =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        network.mojom.RestrictedUDPSocket_Send_ParamsSpec.$,
        network.mojom.RestrictedUDPSocket_Send_ResponseParamsSpec.$,
        this.send.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.sendTo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        network.mojom.RestrictedUDPSocket_SendTo_ParamsSpec.$,
        network.mojom.RestrictedUDPSocket_SendTo_ResponseParamsSpec.$,
        this.sendTo.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('network.mojom.RestrictedUDPSocketParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.RestrictedUDPSocketParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.RestrictedUDPSocket_JoinGroup_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.RestrictedUDPSocket_JoinGroup_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.RestrictedUDPSocket_JoinGroup_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.RestrictedUDPSocket_JoinGroup_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.RestrictedUDPSocket_LeaveGroup_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.RestrictedUDPSocket_LeaveGroup_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.RestrictedUDPSocket_LeaveGroup_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.RestrictedUDPSocket_LeaveGroup_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.RestrictedUDPSocket_ReceiveMore_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.RestrictedUDPSocket_ReceiveMore_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.RestrictedUDPSocket_Send_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.RestrictedUDPSocket_Send_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.RestrictedUDPSocket_Send_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.RestrictedUDPSocket_Send_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.RestrictedUDPSocket_SendTo_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.RestrictedUDPSocket_SendTo_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.RestrictedUDPSocket_SendTo_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.RestrictedUDPSocket_SendTo_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    network.mojom.RestrictedUDPSocketParamsSpec.$,
    'RestrictedUDPSocketParams',
    [
      mojo.internal.StructField(
        'socketOptions', 0,
        0,
        network.mojom.UDPSocketOptionsSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'connectionTracker', 8,
        0,
        mojo.internal.InterfaceProxy(network.mojom.SocketConnectionTrackerRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('network.mojom.RestrictedUDPSocketParams');

/** @record */
network.mojom.RestrictedUDPSocketParams = class {
  constructor() {
    /** @export { (network.mojom.UDPSocketOptions|undefined) } */
    this.socketOptions;
    /** @export { (network.mojom.SocketConnectionTrackerRemote|undefined) } */
    this.connectionTracker;
  }
};



mojo.internal.Struct(
    network.mojom.RestrictedUDPSocket_JoinGroup_ParamsSpec.$,
    'RestrictedUDPSocket_JoinGroup_Params',
    [
      mojo.internal.StructField(
        'groupAddress', 0,
        0,
        network.mojom.IPAddressSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.RestrictedUDPSocket_JoinGroup_Params');

/** @record */
network.mojom.RestrictedUDPSocket_JoinGroup_Params = class {
  constructor() {
    /** @export { !network.mojom.IPAddress } */
    this.groupAddress;
  }
};



mojo.internal.Struct(
    network.mojom.RestrictedUDPSocket_JoinGroup_ResponseParamsSpec.$,
    'RestrictedUDPSocket_JoinGroup_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.RestrictedUDPSocket_JoinGroup_ResponseParams');

/** @record */
network.mojom.RestrictedUDPSocket_JoinGroup_ResponseParams = class {
  constructor() {
    /** @export { !number } */
    this.result;
  }
};



mojo.internal.Struct(
    network.mojom.RestrictedUDPSocket_LeaveGroup_ParamsSpec.$,
    'RestrictedUDPSocket_LeaveGroup_Params',
    [
      mojo.internal.StructField(
        'groupAddress', 0,
        0,
        network.mojom.IPAddressSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.RestrictedUDPSocket_LeaveGroup_Params');

/** @record */
network.mojom.RestrictedUDPSocket_LeaveGroup_Params = class {
  constructor() {
    /** @export { !network.mojom.IPAddress } */
    this.groupAddress;
  }
};



mojo.internal.Struct(
    network.mojom.RestrictedUDPSocket_LeaveGroup_ResponseParamsSpec.$,
    'RestrictedUDPSocket_LeaveGroup_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.RestrictedUDPSocket_LeaveGroup_ResponseParams');

/** @record */
network.mojom.RestrictedUDPSocket_LeaveGroup_ResponseParams = class {
  constructor() {
    /** @export { !number } */
    this.result;
  }
};



mojo.internal.Struct(
    network.mojom.RestrictedUDPSocket_ReceiveMore_ParamsSpec.$,
    'RestrictedUDPSocket_ReceiveMore_Params',
    [
      mojo.internal.StructField(
        'numAdditionalDatagrams', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.RestrictedUDPSocket_ReceiveMore_Params');

/** @record */
network.mojom.RestrictedUDPSocket_ReceiveMore_Params = class {
  constructor() {
    /** @export { !number } */
    this.numAdditionalDatagrams;
  }
};



mojo.internal.Struct(
    network.mojom.RestrictedUDPSocket_Send_ParamsSpec.$,
    'RestrictedUDPSocket_Send_Params',
    [
      mojo.internal.StructField(
        'data', 0,
        0,
        mojoBase.mojom.ReadOnlyBufferSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.RestrictedUDPSocket_Send_Params');

/** @record */
network.mojom.RestrictedUDPSocket_Send_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.ReadOnlyBuffer } */
    this.data;
  }
};



mojo.internal.Struct(
    network.mojom.RestrictedUDPSocket_Send_ResponseParamsSpec.$,
    'RestrictedUDPSocket_Send_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.RestrictedUDPSocket_Send_ResponseParams');

/** @record */
network.mojom.RestrictedUDPSocket_Send_ResponseParams = class {
  constructor() {
    /** @export { !number } */
    this.result;
  }
};



mojo.internal.Struct(
    network.mojom.RestrictedUDPSocket_SendTo_ParamsSpec.$,
    'RestrictedUDPSocket_SendTo_Params',
    [
      mojo.internal.StructField(
        'data', 0,
        0,
        mojoBase.mojom.ReadOnlyBufferSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'destAddr', 8,
        0,
        network.mojom.HostPortPairSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'dnsQueryType', 16,
        0,
        network.mojom.DnsQueryTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('network.mojom.RestrictedUDPSocket_SendTo_Params');

/** @record */
network.mojom.RestrictedUDPSocket_SendTo_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.ReadOnlyBuffer } */
    this.data;
    /** @export { !network.mojom.HostPortPair } */
    this.destAddr;
    /** @export { !network.mojom.DnsQueryType } */
    this.dnsQueryType;
  }
};



mojo.internal.Struct(
    network.mojom.RestrictedUDPSocket_SendTo_ResponseParamsSpec.$,
    'RestrictedUDPSocket_SendTo_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.RestrictedUDPSocket_SendTo_ResponseParams');

/** @record */
network.mojom.RestrictedUDPSocket_SendTo_ResponseParams = class {
  constructor() {
    /** @export { !number } */
    this.result;
  }
};

