// services/network/public/mojom/restricted_udp_socket.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/network/public/mojom/restricted_udp_socket.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('network.mojom');
  var read_only_buffer$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/read_only_buffer.mojom', '../../../../mojo/public/mojom/base/read_only_buffer.mojom.js');
  }
  var host_resolver$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/host_resolver.mojom', 'host_resolver.mojom.js');
  }
  var network_param$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/network_param.mojom', 'network_param.mojom.js');
  }
  var udp_socket$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/udp_socket.mojom', 'udp_socket.mojom.js');
  }
  var ip_address$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/ip_address.mojom', 'ip_address.mojom.js');
  }
  var socket_connection_tracker$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/socket_connection_tracker.mojom', 'socket_connection_tracker.mojom.js');
  }


  var RestrictedUDPSocketMode = {};
  RestrictedUDPSocketMode.CONNECTED = 0;
  RestrictedUDPSocketMode.BOUND = 1;
  RestrictedUDPSocketMode.MIN_VALUE = 0;
  RestrictedUDPSocketMode.MAX_VALUE = 1;

  RestrictedUDPSocketMode.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  RestrictedUDPSocketMode.toKnownEnumValue = function(value) {
    return value;
  };

  RestrictedUDPSocketMode.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function RestrictedUDPSocketParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RestrictedUDPSocketParams.prototype.initDefaults_ = function() {
    this.socketOptions = null;
    this.connectionTracker = new socket_connection_tracker$.SocketConnectionTrackerPtr();
  };
  RestrictedUDPSocketParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RestrictedUDPSocketParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RestrictedUDPSocketParams.socketOptions
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, udp_socket$.UDPSocketOptions, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RestrictedUDPSocketParams.connectionTracker
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 8, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RestrictedUDPSocketParams.encodedSize = codec.kStructHeaderSize + 16;

  RestrictedUDPSocketParams.decode = function(decoder) {
    var packed;
    var val = new RestrictedUDPSocketParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.socketOptions =
        decoder.decodeStructPointer(udp_socket$.UDPSocketOptions);
    val.connectionTracker =
        decoder.decodeStruct(new codec.NullableInterface(socket_connection_tracker$.SocketConnectionTrackerPtr));
    return val;
  };

  RestrictedUDPSocketParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RestrictedUDPSocketParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(udp_socket$.UDPSocketOptions, val.socketOptions);
    encoder.encodeStruct(new codec.NullableInterface(socket_connection_tracker$.SocketConnectionTrackerPtr), val.connectionTracker);
  };
  function RestrictedUDPSocket_JoinGroup_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RestrictedUDPSocket_JoinGroup_Params.prototype.initDefaults_ = function() {
    this.groupAddress = null;
  };
  RestrictedUDPSocket_JoinGroup_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RestrictedUDPSocket_JoinGroup_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RestrictedUDPSocket_JoinGroup_Params.groupAddress
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, ip_address$.IPAddress, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RestrictedUDPSocket_JoinGroup_Params.encodedSize = codec.kStructHeaderSize + 8;

  RestrictedUDPSocket_JoinGroup_Params.decode = function(decoder) {
    var packed;
    var val = new RestrictedUDPSocket_JoinGroup_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.groupAddress =
        decoder.decodeStructPointer(ip_address$.IPAddress);
    return val;
  };

  RestrictedUDPSocket_JoinGroup_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RestrictedUDPSocket_JoinGroup_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(ip_address$.IPAddress, val.groupAddress);
  };
  function RestrictedUDPSocket_JoinGroup_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RestrictedUDPSocket_JoinGroup_ResponseParams.prototype.initDefaults_ = function() {
    this.result = 0;
  };
  RestrictedUDPSocket_JoinGroup_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RestrictedUDPSocket_JoinGroup_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  RestrictedUDPSocket_JoinGroup_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  RestrictedUDPSocket_JoinGroup_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new RestrictedUDPSocket_JoinGroup_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  RestrictedUDPSocket_JoinGroup_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RestrictedUDPSocket_JoinGroup_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.result);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function RestrictedUDPSocket_LeaveGroup_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RestrictedUDPSocket_LeaveGroup_Params.prototype.initDefaults_ = function() {
    this.groupAddress = null;
  };
  RestrictedUDPSocket_LeaveGroup_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RestrictedUDPSocket_LeaveGroup_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RestrictedUDPSocket_LeaveGroup_Params.groupAddress
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, ip_address$.IPAddress, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RestrictedUDPSocket_LeaveGroup_Params.encodedSize = codec.kStructHeaderSize + 8;

  RestrictedUDPSocket_LeaveGroup_Params.decode = function(decoder) {
    var packed;
    var val = new RestrictedUDPSocket_LeaveGroup_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.groupAddress =
        decoder.decodeStructPointer(ip_address$.IPAddress);
    return val;
  };

  RestrictedUDPSocket_LeaveGroup_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RestrictedUDPSocket_LeaveGroup_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(ip_address$.IPAddress, val.groupAddress);
  };
  function RestrictedUDPSocket_LeaveGroup_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RestrictedUDPSocket_LeaveGroup_ResponseParams.prototype.initDefaults_ = function() {
    this.result = 0;
  };
  RestrictedUDPSocket_LeaveGroup_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RestrictedUDPSocket_LeaveGroup_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  RestrictedUDPSocket_LeaveGroup_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  RestrictedUDPSocket_LeaveGroup_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new RestrictedUDPSocket_LeaveGroup_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  RestrictedUDPSocket_LeaveGroup_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RestrictedUDPSocket_LeaveGroup_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.result);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function RestrictedUDPSocket_ReceiveMore_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RestrictedUDPSocket_ReceiveMore_Params.prototype.initDefaults_ = function() {
    this.numAdditionalDatagrams = 0;
  };
  RestrictedUDPSocket_ReceiveMore_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RestrictedUDPSocket_ReceiveMore_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  RestrictedUDPSocket_ReceiveMore_Params.encodedSize = codec.kStructHeaderSize + 8;

  RestrictedUDPSocket_ReceiveMore_Params.decode = function(decoder) {
    var packed;
    var val = new RestrictedUDPSocket_ReceiveMore_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.numAdditionalDatagrams =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  RestrictedUDPSocket_ReceiveMore_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RestrictedUDPSocket_ReceiveMore_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.numAdditionalDatagrams);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function RestrictedUDPSocket_Send_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RestrictedUDPSocket_Send_Params.prototype.initDefaults_ = function() {
    this.data = null;
  };
  RestrictedUDPSocket_Send_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RestrictedUDPSocket_Send_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RestrictedUDPSocket_Send_Params.data
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, read_only_buffer$.ReadOnlyBuffer, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RestrictedUDPSocket_Send_Params.encodedSize = codec.kStructHeaderSize + 8;

  RestrictedUDPSocket_Send_Params.decode = function(decoder) {
    var packed;
    var val = new RestrictedUDPSocket_Send_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.data =
        decoder.decodeStructPointer(read_only_buffer$.ReadOnlyBuffer);
    return val;
  };

  RestrictedUDPSocket_Send_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RestrictedUDPSocket_Send_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(read_only_buffer$.ReadOnlyBuffer, val.data);
  };
  function RestrictedUDPSocket_Send_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RestrictedUDPSocket_Send_ResponseParams.prototype.initDefaults_ = function() {
    this.result = 0;
  };
  RestrictedUDPSocket_Send_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RestrictedUDPSocket_Send_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  RestrictedUDPSocket_Send_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  RestrictedUDPSocket_Send_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new RestrictedUDPSocket_Send_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  RestrictedUDPSocket_Send_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RestrictedUDPSocket_Send_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.result);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function RestrictedUDPSocket_SendTo_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RestrictedUDPSocket_SendTo_Params.prototype.initDefaults_ = function() {
    this.data = null;
    this.destAddr = null;
    this.dnsQueryType = 0;
  };
  RestrictedUDPSocket_SendTo_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RestrictedUDPSocket_SendTo_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RestrictedUDPSocket_SendTo_Params.data
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, read_only_buffer$.ReadOnlyBuffer, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RestrictedUDPSocket_SendTo_Params.destAddr
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, network_param$.HostPortPair, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RestrictedUDPSocket_SendTo_Params.dnsQueryType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 16, host_resolver$.DnsQueryType);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RestrictedUDPSocket_SendTo_Params.encodedSize = codec.kStructHeaderSize + 24;

  RestrictedUDPSocket_SendTo_Params.decode = function(decoder) {
    var packed;
    var val = new RestrictedUDPSocket_SendTo_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.data =
        decoder.decodeStructPointer(read_only_buffer$.ReadOnlyBuffer);
    val.destAddr =
        decoder.decodeStructPointer(network_param$.HostPortPair);
    val.dnsQueryType =
        decoder.decodeStruct(new codec.Enum(host_resolver$.DnsQueryType));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  RestrictedUDPSocket_SendTo_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RestrictedUDPSocket_SendTo_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(read_only_buffer$.ReadOnlyBuffer, val.data);
    encoder.encodeStructPointer(network_param$.HostPortPair, val.destAddr);
    encoder.encodeStruct(codec.Int32, val.dnsQueryType);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function RestrictedUDPSocket_SendTo_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RestrictedUDPSocket_SendTo_ResponseParams.prototype.initDefaults_ = function() {
    this.result = 0;
  };
  RestrictedUDPSocket_SendTo_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RestrictedUDPSocket_SendTo_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  RestrictedUDPSocket_SendTo_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  RestrictedUDPSocket_SendTo_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new RestrictedUDPSocket_SendTo_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  RestrictedUDPSocket_SendTo_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RestrictedUDPSocket_SendTo_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.result);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  var kRestrictedUDPSocket_JoinGroup_Name = 0;
  var kRestrictedUDPSocket_LeaveGroup_Name = 1;
  var kRestrictedUDPSocket_ReceiveMore_Name = 2;
  var kRestrictedUDPSocket_Send_Name = 3;
  var kRestrictedUDPSocket_SendTo_Name = 4;

  function RestrictedUDPSocketPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(RestrictedUDPSocket,
                                                   handleOrPtrInfo);
  }

  function RestrictedUDPSocketAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        RestrictedUDPSocket, associatedInterfacePtrInfo);
  }

  RestrictedUDPSocketAssociatedPtr.prototype =
      Object.create(RestrictedUDPSocketPtr.prototype);
  RestrictedUDPSocketAssociatedPtr.prototype.constructor =
      RestrictedUDPSocketAssociatedPtr;

  function RestrictedUDPSocketProxy(receiver) {
    this.receiver_ = receiver;
  }
  RestrictedUDPSocketPtr.prototype.joinGroup = function() {
    return RestrictedUDPSocketProxy.prototype.joinGroup
        .apply(this.ptr.getProxy(), arguments);
  };

  RestrictedUDPSocketProxy.prototype.joinGroup = function(groupAddress) {
    var params_ = new RestrictedUDPSocket_JoinGroup_Params();
    params_.groupAddress = groupAddress;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kRestrictedUDPSocket_JoinGroup_Name,
          codec.align(RestrictedUDPSocket_JoinGroup_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(RestrictedUDPSocket_JoinGroup_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(RestrictedUDPSocket_JoinGroup_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  RestrictedUDPSocketPtr.prototype.leaveGroup = function() {
    return RestrictedUDPSocketProxy.prototype.leaveGroup
        .apply(this.ptr.getProxy(), arguments);
  };

  RestrictedUDPSocketProxy.prototype.leaveGroup = function(groupAddress) {
    var params_ = new RestrictedUDPSocket_LeaveGroup_Params();
    params_.groupAddress = groupAddress;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kRestrictedUDPSocket_LeaveGroup_Name,
          codec.align(RestrictedUDPSocket_LeaveGroup_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(RestrictedUDPSocket_LeaveGroup_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(RestrictedUDPSocket_LeaveGroup_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  RestrictedUDPSocketPtr.prototype.receiveMore = function() {
    return RestrictedUDPSocketProxy.prototype.receiveMore
        .apply(this.ptr.getProxy(), arguments);
  };

  RestrictedUDPSocketProxy.prototype.receiveMore = function(numAdditionalDatagrams) {
    var params_ = new RestrictedUDPSocket_ReceiveMore_Params();
    params_.numAdditionalDatagrams = numAdditionalDatagrams;
    var builder = new codec.MessageV0Builder(
        kRestrictedUDPSocket_ReceiveMore_Name,
        codec.align(RestrictedUDPSocket_ReceiveMore_Params.encodedSize));
    builder.encodeStruct(RestrictedUDPSocket_ReceiveMore_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  RestrictedUDPSocketPtr.prototype.send = function() {
    return RestrictedUDPSocketProxy.prototype.send
        .apply(this.ptr.getProxy(), arguments);
  };

  RestrictedUDPSocketProxy.prototype.send = function(data) {
    var params_ = new RestrictedUDPSocket_Send_Params();
    params_.data = data;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kRestrictedUDPSocket_Send_Name,
          codec.align(RestrictedUDPSocket_Send_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(RestrictedUDPSocket_Send_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(RestrictedUDPSocket_Send_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  RestrictedUDPSocketPtr.prototype.sendTo = function() {
    return RestrictedUDPSocketProxy.prototype.sendTo
        .apply(this.ptr.getProxy(), arguments);
  };

  RestrictedUDPSocketProxy.prototype.sendTo = function(data, destAddr, dnsQueryType) {
    var params_ = new RestrictedUDPSocket_SendTo_Params();
    params_.data = data;
    params_.destAddr = destAddr;
    params_.dnsQueryType = dnsQueryType;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kRestrictedUDPSocket_SendTo_Name,
          codec.align(RestrictedUDPSocket_SendTo_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(RestrictedUDPSocket_SendTo_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(RestrictedUDPSocket_SendTo_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function RestrictedUDPSocketStub(delegate) {
    this.delegate_ = delegate;
  }
  RestrictedUDPSocketStub.prototype.joinGroup = function(groupAddress) {
    return this.delegate_ && this.delegate_.joinGroup && this.delegate_.joinGroup(groupAddress);
  }
  RestrictedUDPSocketStub.prototype.leaveGroup = function(groupAddress) {
    return this.delegate_ && this.delegate_.leaveGroup && this.delegate_.leaveGroup(groupAddress);
  }
  RestrictedUDPSocketStub.prototype.receiveMore = function(numAdditionalDatagrams) {
    return this.delegate_ && this.delegate_.receiveMore && this.delegate_.receiveMore(numAdditionalDatagrams);
  }
  RestrictedUDPSocketStub.prototype.send = function(data) {
    return this.delegate_ && this.delegate_.send && this.delegate_.send(data);
  }
  RestrictedUDPSocketStub.prototype.sendTo = function(data, destAddr, dnsQueryType) {
    return this.delegate_ && this.delegate_.sendTo && this.delegate_.sendTo(data, destAddr, dnsQueryType);
  }

  RestrictedUDPSocketStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kRestrictedUDPSocket_ReceiveMore_Name:
      var params = reader.decodeStruct(RestrictedUDPSocket_ReceiveMore_Params);
      this.receiveMore(params.numAdditionalDatagrams);
      return true;
    default:
      return false;
    }
  };

  RestrictedUDPSocketStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kRestrictedUDPSocket_JoinGroup_Name:
      var params = reader.decodeStruct(RestrictedUDPSocket_JoinGroup_Params);
      this.joinGroup(params.groupAddress).then(function(response) {
        var responseParams =
            new RestrictedUDPSocket_JoinGroup_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kRestrictedUDPSocket_JoinGroup_Name,
            codec.align(RestrictedUDPSocket_JoinGroup_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(RestrictedUDPSocket_JoinGroup_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kRestrictedUDPSocket_LeaveGroup_Name:
      var params = reader.decodeStruct(RestrictedUDPSocket_LeaveGroup_Params);
      this.leaveGroup(params.groupAddress).then(function(response) {
        var responseParams =
            new RestrictedUDPSocket_LeaveGroup_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kRestrictedUDPSocket_LeaveGroup_Name,
            codec.align(RestrictedUDPSocket_LeaveGroup_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(RestrictedUDPSocket_LeaveGroup_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kRestrictedUDPSocket_Send_Name:
      var params = reader.decodeStruct(RestrictedUDPSocket_Send_Params);
      this.send(params.data).then(function(response) {
        var responseParams =
            new RestrictedUDPSocket_Send_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kRestrictedUDPSocket_Send_Name,
            codec.align(RestrictedUDPSocket_Send_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(RestrictedUDPSocket_Send_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kRestrictedUDPSocket_SendTo_Name:
      var params = reader.decodeStruct(RestrictedUDPSocket_SendTo_Params);
      this.sendTo(params.data, params.destAddr, params.dnsQueryType).then(function(response) {
        var responseParams =
            new RestrictedUDPSocket_SendTo_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kRestrictedUDPSocket_SendTo_Name,
            codec.align(RestrictedUDPSocket_SendTo_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(RestrictedUDPSocket_SendTo_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateRestrictedUDPSocketRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kRestrictedUDPSocket_JoinGroup_Name:
        if (message.expectsResponse())
          paramsClass = RestrictedUDPSocket_JoinGroup_Params;
      break;
      case kRestrictedUDPSocket_LeaveGroup_Name:
        if (message.expectsResponse())
          paramsClass = RestrictedUDPSocket_LeaveGroup_Params;
      break;
      case kRestrictedUDPSocket_ReceiveMore_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = RestrictedUDPSocket_ReceiveMore_Params;
      break;
      case kRestrictedUDPSocket_Send_Name:
        if (message.expectsResponse())
          paramsClass = RestrictedUDPSocket_Send_Params;
      break;
      case kRestrictedUDPSocket_SendTo_Name:
        if (message.expectsResponse())
          paramsClass = RestrictedUDPSocket_SendTo_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateRestrictedUDPSocketResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kRestrictedUDPSocket_JoinGroup_Name:
        if (message.isResponse())
          paramsClass = RestrictedUDPSocket_JoinGroup_ResponseParams;
        break;
      case kRestrictedUDPSocket_LeaveGroup_Name:
        if (message.isResponse())
          paramsClass = RestrictedUDPSocket_LeaveGroup_ResponseParams;
        break;
      case kRestrictedUDPSocket_Send_Name:
        if (message.isResponse())
          paramsClass = RestrictedUDPSocket_Send_ResponseParams;
        break;
      case kRestrictedUDPSocket_SendTo_Name:
        if (message.isResponse())
          paramsClass = RestrictedUDPSocket_SendTo_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var RestrictedUDPSocket = {
    name: 'network.mojom.RestrictedUDPSocket',
    kVersion: 0,
    ptrClass: RestrictedUDPSocketPtr,
    proxyClass: RestrictedUDPSocketProxy,
    stubClass: RestrictedUDPSocketStub,
    validateRequest: validateRestrictedUDPSocketRequest,
    validateResponse: validateRestrictedUDPSocketResponse,
  };
  RestrictedUDPSocketStub.prototype.validator = validateRestrictedUDPSocketRequest;
  RestrictedUDPSocketProxy.prototype.validator = validateRestrictedUDPSocketResponse;
  exports.RestrictedUDPSocketMode = RestrictedUDPSocketMode;
  exports.RestrictedUDPSocketParams = RestrictedUDPSocketParams;
  exports.RestrictedUDPSocket = RestrictedUDPSocket;
  exports.RestrictedUDPSocketPtr = RestrictedUDPSocketPtr;
  exports.RestrictedUDPSocketAssociatedPtr = RestrictedUDPSocketAssociatedPtr;
})();