// services/network/public/mojom/restricted_udp_socket.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';

import {
  ReadOnlyBuffer as mojoBase_mojom_ReadOnlyBuffer,
  ReadOnlyBufferSpec as mojoBase_mojom_ReadOnlyBufferSpec
} from '../../../../mojo/public/mojom/base/read_only_buffer.mojom.m.js';

import {
  DnsQueryType as network_mojom_DnsQueryType,
  DnsQueryTypeSpec as network_mojom_DnsQueryTypeSpec
} from './host_resolver.mojom.m.js';

import {
  IPAddress as network_mojom_IPAddress,
  IPAddressSpec as network_mojom_IPAddressSpec
} from './ip_address.mojom.m.js';

import {
  HostPortPair as network_mojom_HostPortPair,
  HostPortPairSpec as network_mojom_HostPortPairSpec
} from './network_param.mojom.m.js';

import {
  SocketConnectionTrackerRemote as network_mojom_SocketConnectionTrackerRemote,
  SocketConnectionTrackerPendingReceiver as network_mojom_SocketConnectionTrackerPendingReceiver
} from './socket_connection_tracker.mojom.m.js';

import {
  UDPSocketOptions as network_mojom_UDPSocketOptions,
  UDPSocketOptionsSpec as network_mojom_UDPSocketOptionsSpec
} from './udp_socket.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const RestrictedUDPSocketModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const RestrictedUDPSocketMode = {
  
  CONNECTED: 0,
  BOUND: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class RestrictedUDPSocketPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.RestrictedUDPSocket', scope);
  }
}

/** @interface */
export class RestrictedUDPSocketInterface {
  
  /**
   * @param { !network_mojom_IPAddress } groupAddress
   * @return {!Promise<{
        result: !number,
   *  }>}
   */

  joinGroup(groupAddress) {}
  
  /**
   * @param { !network_mojom_IPAddress } groupAddress
   * @return {!Promise<{
        result: !number,
   *  }>}
   */

  leaveGroup(groupAddress) {}
  
  /**
   * @param { !number } numAdditionalDatagrams
   */

  receiveMore(numAdditionalDatagrams) {}
  
  /**
   * @param { !mojoBase_mojom_ReadOnlyBuffer } data
   * @return {!Promise<{
        result: !number,
   *  }>}
   */

  send(data) {}
  
  /**
   * @param { !mojoBase_mojom_ReadOnlyBuffer } data
   * @param { !network_mojom_HostPortPair } destAddr
   * @param { !network_mojom_DnsQueryType } dnsQueryType
   * @return {!Promise<{
        result: !number,
   *  }>}
   */

  sendTo(data, destAddr, dnsQueryType) {}
}

/**
 * @implements { RestrictedUDPSocketInterface }
 */
export class RestrictedUDPSocketRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!RestrictedUDPSocketPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          RestrictedUDPSocketPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!RestrictedUDPSocketPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !network_mojom_IPAddress } groupAddress
   * @return {!Promise<{
        result: !number,
   *  }>}
   */

  joinGroup(
      groupAddress) {
    return this.proxy.sendMessage(
        0,
        RestrictedUDPSocket_JoinGroup_ParamsSpec.$,
        RestrictedUDPSocket_JoinGroup_ResponseParamsSpec.$,
        [
          groupAddress
        ],
        false);
  }

  
  /**
   * @param { !network_mojom_IPAddress } groupAddress
   * @return {!Promise<{
        result: !number,
   *  }>}
   */

  leaveGroup(
      groupAddress) {
    return this.proxy.sendMessage(
        1,
        RestrictedUDPSocket_LeaveGroup_ParamsSpec.$,
        RestrictedUDPSocket_LeaveGroup_ResponseParamsSpec.$,
        [
          groupAddress
        ],
        false);
  }

  
  /**
   * @param { !number } numAdditionalDatagrams
   */

  receiveMore(
      numAdditionalDatagrams) {
    this.proxy.sendMessage(
        2,
        RestrictedUDPSocket_ReceiveMore_ParamsSpec.$,
        null,
        [
          numAdditionalDatagrams
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_ReadOnlyBuffer } data
   * @return {!Promise<{
        result: !number,
   *  }>}
   */

  send(
      data) {
    return this.proxy.sendMessage(
        3,
        RestrictedUDPSocket_Send_ParamsSpec.$,
        RestrictedUDPSocket_Send_ResponseParamsSpec.$,
        [
          data
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_ReadOnlyBuffer } data
   * @param { !network_mojom_HostPortPair } destAddr
   * @param { !network_mojom_DnsQueryType } dnsQueryType
   * @return {!Promise<{
        result: !number,
   *  }>}
   */

  sendTo(
      data,
      destAddr,
      dnsQueryType) {
    return this.proxy.sendMessage(
        4,
        RestrictedUDPSocket_SendTo_ParamsSpec.$,
        RestrictedUDPSocket_SendTo_ResponseParamsSpec.$,
        [
          data,
          destAddr,
          dnsQueryType
        ],
        false);
  }
}

/**
 * An object which receives request messages for the RestrictedUDPSocket
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class RestrictedUDPSocketReceiver {
  /**
   * @param {!RestrictedUDPSocketInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!RestrictedUDPSocketRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        RestrictedUDPSocketRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!RestrictedUDPSocketRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        RestrictedUDPSocket_JoinGroup_ParamsSpec.$,
        RestrictedUDPSocket_JoinGroup_ResponseParamsSpec.$,
        impl.joinGroup.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        RestrictedUDPSocket_LeaveGroup_ParamsSpec.$,
        RestrictedUDPSocket_LeaveGroup_ResponseParamsSpec.$,
        impl.leaveGroup.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        RestrictedUDPSocket_ReceiveMore_ParamsSpec.$,
        null,
        impl.receiveMore.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        RestrictedUDPSocket_Send_ParamsSpec.$,
        RestrictedUDPSocket_Send_ResponseParamsSpec.$,
        impl.send.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        RestrictedUDPSocket_SendTo_ParamsSpec.$,
        RestrictedUDPSocket_SendTo_ResponseParamsSpec.$,
        impl.sendTo.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class RestrictedUDPSocket {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.RestrictedUDPSocket";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!RestrictedUDPSocketRemote}
   */
  static getRemote() {
    let remote = new RestrictedUDPSocketRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the RestrictedUDPSocket
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class RestrictedUDPSocketCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      RestrictedUDPSocketRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!RestrictedUDPSocketRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.joinGroup =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        RestrictedUDPSocket_JoinGroup_ParamsSpec.$,
        RestrictedUDPSocket_JoinGroup_ResponseParamsSpec.$,
        this.joinGroup.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.leaveGroup =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        RestrictedUDPSocket_LeaveGroup_ParamsSpec.$,
        RestrictedUDPSocket_LeaveGroup_ResponseParamsSpec.$,
        this.leaveGroup.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.receiveMore =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        RestrictedUDPSocket_ReceiveMore_ParamsSpec.$,
        null,
        this.receiveMore.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.send =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        RestrictedUDPSocket_Send_ParamsSpec.$,
        RestrictedUDPSocket_Send_ResponseParamsSpec.$,
        this.send.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.sendTo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        RestrictedUDPSocket_SendTo_ParamsSpec.$,
        RestrictedUDPSocket_SendTo_ResponseParamsSpec.$,
        this.sendTo.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RestrictedUDPSocketParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RestrictedUDPSocket_JoinGroup_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RestrictedUDPSocket_JoinGroup_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RestrictedUDPSocket_LeaveGroup_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RestrictedUDPSocket_LeaveGroup_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RestrictedUDPSocket_ReceiveMore_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RestrictedUDPSocket_Send_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RestrictedUDPSocket_Send_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RestrictedUDPSocket_SendTo_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RestrictedUDPSocket_SendTo_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    RestrictedUDPSocketParamsSpec.$,
    'RestrictedUDPSocketParams',
    [
      mojo.internal.StructField(
        'socketOptions', 0,
        0,
        network_mojom_UDPSocketOptionsSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'connectionTracker', 8,
        0,
        mojo.internal.InterfaceProxy(network_mojom_SocketConnectionTrackerRemote),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class RestrictedUDPSocketParams {
  constructor() {
    /** @type { (network_mojom_UDPSocketOptions|undefined) } */
    this.socketOptions;
    /** @type { (network_mojom_SocketConnectionTrackerRemote|undefined) } */
    this.connectionTracker;
  }
}



mojo.internal.Struct(
    RestrictedUDPSocket_JoinGroup_ParamsSpec.$,
    'RestrictedUDPSocket_JoinGroup_Params',
    [
      mojo.internal.StructField(
        'groupAddress', 0,
        0,
        network_mojom_IPAddressSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class RestrictedUDPSocket_JoinGroup_Params {
  constructor() {
    /** @type { !network_mojom_IPAddress } */
    this.groupAddress;
  }
}



mojo.internal.Struct(
    RestrictedUDPSocket_JoinGroup_ResponseParamsSpec.$,
    'RestrictedUDPSocket_JoinGroup_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class RestrictedUDPSocket_JoinGroup_ResponseParams {
  constructor() {
    /** @type { !number } */
    this.result;
  }
}



mojo.internal.Struct(
    RestrictedUDPSocket_LeaveGroup_ParamsSpec.$,
    'RestrictedUDPSocket_LeaveGroup_Params',
    [
      mojo.internal.StructField(
        'groupAddress', 0,
        0,
        network_mojom_IPAddressSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class RestrictedUDPSocket_LeaveGroup_Params {
  constructor() {
    /** @type { !network_mojom_IPAddress } */
    this.groupAddress;
  }
}



mojo.internal.Struct(
    RestrictedUDPSocket_LeaveGroup_ResponseParamsSpec.$,
    'RestrictedUDPSocket_LeaveGroup_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class RestrictedUDPSocket_LeaveGroup_ResponseParams {
  constructor() {
    /** @type { !number } */
    this.result;
  }
}



mojo.internal.Struct(
    RestrictedUDPSocket_ReceiveMore_ParamsSpec.$,
    'RestrictedUDPSocket_ReceiveMore_Params',
    [
      mojo.internal.StructField(
        'numAdditionalDatagrams', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class RestrictedUDPSocket_ReceiveMore_Params {
  constructor() {
    /** @type { !number } */
    this.numAdditionalDatagrams;
  }
}



mojo.internal.Struct(
    RestrictedUDPSocket_Send_ParamsSpec.$,
    'RestrictedUDPSocket_Send_Params',
    [
      mojo.internal.StructField(
        'data', 0,
        0,
        mojoBase_mojom_ReadOnlyBufferSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class RestrictedUDPSocket_Send_Params {
  constructor() {
    /** @type { !mojoBase_mojom_ReadOnlyBuffer } */
    this.data;
  }
}



mojo.internal.Struct(
    RestrictedUDPSocket_Send_ResponseParamsSpec.$,
    'RestrictedUDPSocket_Send_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class RestrictedUDPSocket_Send_ResponseParams {
  constructor() {
    /** @type { !number } */
    this.result;
  }
}



mojo.internal.Struct(
    RestrictedUDPSocket_SendTo_ParamsSpec.$,
    'RestrictedUDPSocket_SendTo_Params',
    [
      mojo.internal.StructField(
        'data', 0,
        0,
        mojoBase_mojom_ReadOnlyBufferSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'destAddr', 8,
        0,
        network_mojom_HostPortPairSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'dnsQueryType', 16,
        0,
        network_mojom_DnsQueryTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class RestrictedUDPSocket_SendTo_Params {
  constructor() {
    /** @type { !mojoBase_mojom_ReadOnlyBuffer } */
    this.data;
    /** @type { !network_mojom_HostPortPair } */
    this.destAddr;
    /** @type { !network_mojom_DnsQueryType } */
    this.dnsQueryType;
  }
}



mojo.internal.Struct(
    RestrictedUDPSocket_SendTo_ResponseParamsSpec.$,
    'RestrictedUDPSocket_SendTo_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class RestrictedUDPSocket_SendTo_ResponseParams {
  constructor() {
    /** @type { !number } */
    this.result;
  }
}

