// services/network/public/mojom/source_location.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/network/public/mojom/source_location.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('network.mojom');



  function SourceLocation(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SourceLocation.prototype.initDefaults_ = function() {
    this.url = null;
    this.line = 0;
    this.column = 0;
  };
  SourceLocation.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SourceLocation.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SourceLocation.url
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  SourceLocation.encodedSize = codec.kStructHeaderSize + 16;

  SourceLocation.decode = function(decoder) {
    var packed;
    var val = new SourceLocation();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.url =
        decoder.decodeStruct(codec.String);
    val.line =
        decoder.decodeStruct(codec.Uint32);
    val.column =
        decoder.decodeStruct(codec.Uint32);
    return val;
  };

  SourceLocation.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SourceLocation.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.url);
    encoder.encodeStruct(codec.Uint32, val.line);
    encoder.encodeStruct(codec.Uint32, val.column);
  };
  exports.SourceLocation = SourceLocation;
})();