// services/network/public/mojom/url_loader.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('network.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
network.mojom.URLLoaderPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        network.mojom.URLLoader.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { network.mojom.URLLoaderInterface }
 */
network.mojom.URLLoaderRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!network.mojom.URLLoaderPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          network.mojom.URLLoaderPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!network.mojom.URLLoaderPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Array<!string> } removedHeaders
   * @param { !network.mojom.HttpRequestHeaders } modifiedHeaders
   * @param { !network.mojom.HttpRequestHeaders } modifiedCorsExemptHeaders
   * @param { ?url.mojom.Url } newUrl
   */

  followRedirect(
      removedHeaders,
      modifiedHeaders,
      modifiedCorsExemptHeaders,
      newUrl) {
    this.proxy.sendMessage(
        0,
        network.mojom.URLLoader_FollowRedirect_ParamsSpec.$,
        null,
        [
          removedHeaders,
          modifiedHeaders,
          modifiedCorsExemptHeaders,
          newUrl
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.RequestPriority } priority
   * @param { !number } intraPriorityValue
   */

  setPriority(
      priority,
      intraPriorityValue) {
    this.proxy.sendMessage(
        1,
        network.mojom.URLLoader_SetPriority_ParamsSpec.$,
        null,
        [
          priority,
          intraPriorityValue
        ],
        false);
  }
};

/**
 * An object which receives request messages for the URLLoader
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
network.mojom.URLLoaderReceiver = class {
  /**
   * @param {!network.mojom.URLLoaderInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!network.mojom.URLLoaderRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        network.mojom.URLLoaderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.URLLoaderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        network.mojom.URLLoader_FollowRedirect_ParamsSpec.$,
        null,
        impl.followRedirect.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        network.mojom.URLLoader_SetPriority_ParamsSpec.$,
        null,
        impl.setPriority.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
network.mojom.URLLoader = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.URLLoader";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!network.mojom.URLLoaderRemote}
   * @export
   */
  static getRemote() {
    let remote = new network.mojom.URLLoaderRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the URLLoader
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
network.mojom.URLLoaderCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      network.mojom.URLLoaderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.URLLoaderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.followRedirect =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        network.mojom.URLLoader_FollowRedirect_ParamsSpec.$,
        null,
        this.followRedirect.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setPriority =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        network.mojom.URLLoader_SetPriority_ParamsSpec.$,
        null,
        this.setPriority.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
network.mojom.URLLoaderClientPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        network.mojom.URLLoaderClient.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { network.mojom.URLLoaderClientInterface }
 */
network.mojom.URLLoaderClientRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!network.mojom.URLLoaderClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          network.mojom.URLLoaderClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!network.mojom.URLLoaderClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !network.mojom.EarlyHints } earlyHints
   */

  onReceiveEarlyHints(
      earlyHints) {
    this.proxy.sendMessage(
        0,
        network.mojom.URLLoaderClient_OnReceiveEarlyHints_ParamsSpec.$,
        null,
        [
          earlyHints
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.URLResponseHead } head
   * @param { ?MojoHandle } body
   * @param { ?mojoBase.mojom.BigBuffer } cachedMetadata
   */

  onReceiveResponse(
      head,
      body,
      cachedMetadata) {
    this.proxy.sendMessage(
        1,
        network.mojom.URLLoaderClient_OnReceiveResponse_ParamsSpec.$,
        null,
        [
          head,
          body,
          cachedMetadata
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.URLRequestRedirectInfo } redirectInfo
   * @param { !network.mojom.URLResponseHead } head
   */

  onReceiveRedirect(
      redirectInfo,
      head) {
    this.proxy.sendMessage(
        2,
        network.mojom.URLLoaderClient_OnReceiveRedirect_ParamsSpec.$,
        null,
        [
          redirectInfo,
          head
        ],
        false);
  }

  
  /**
   * @param { !bigint } currentPosition
   * @param { !bigint } totalSize
   * @return {!Promise}
   */

  onUploadProgress(
      currentPosition,
      totalSize) {
    return this.proxy.sendMessage(
        3,
        network.mojom.URLLoaderClient_OnUploadProgress_ParamsSpec.$,
        network.mojom.URLLoaderClient_OnUploadProgress_ResponseParamsSpec.$,
        [
          currentPosition,
          totalSize
        ],
        false);
  }

  
  /**
   * @param { !number } transferSizeDiff
   */

  onTransferSizeUpdated(
      transferSizeDiff) {
    this.proxy.sendMessage(
        4,
        network.mojom.URLLoaderClient_OnTransferSizeUpdated_ParamsSpec.$,
        null,
        [
          transferSizeDiff
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.URLLoaderCompletionStatus } status
   */

  onComplete(
      status) {
    this.proxy.sendMessage(
        5,
        network.mojom.URLLoaderClient_OnComplete_ParamsSpec.$,
        null,
        [
          status
        ],
        false);
  }
};

/**
 * An object which receives request messages for the URLLoaderClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
network.mojom.URLLoaderClientReceiver = class {
  /**
   * @param {!network.mojom.URLLoaderClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!network.mojom.URLLoaderClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        network.mojom.URLLoaderClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.URLLoaderClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        network.mojom.URLLoaderClient_OnReceiveEarlyHints_ParamsSpec.$,
        null,
        impl.onReceiveEarlyHints.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        network.mojom.URLLoaderClient_OnReceiveResponse_ParamsSpec.$,
        null,
        impl.onReceiveResponse.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        network.mojom.URLLoaderClient_OnReceiveRedirect_ParamsSpec.$,
        null,
        impl.onReceiveRedirect.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        network.mojom.URLLoaderClient_OnUploadProgress_ParamsSpec.$,
        network.mojom.URLLoaderClient_OnUploadProgress_ResponseParamsSpec.$,
        impl.onUploadProgress.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        network.mojom.URLLoaderClient_OnTransferSizeUpdated_ParamsSpec.$,
        null,
        impl.onTransferSizeUpdated.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        network.mojom.URLLoaderClient_OnComplete_ParamsSpec.$,
        null,
        impl.onComplete.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
network.mojom.URLLoaderClient = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.URLLoaderClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!network.mojom.URLLoaderClientRemote}
   * @export
   */
  static getRemote() {
    let remote = new network.mojom.URLLoaderClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the URLLoaderClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
network.mojom.URLLoaderClientCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      network.mojom.URLLoaderClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.URLLoaderClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onReceiveEarlyHints =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        network.mojom.URLLoaderClient_OnReceiveEarlyHints_ParamsSpec.$,
        null,
        this.onReceiveEarlyHints.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onReceiveResponse =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        network.mojom.URLLoaderClient_OnReceiveResponse_ParamsSpec.$,
        null,
        this.onReceiveResponse.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onReceiveRedirect =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        network.mojom.URLLoaderClient_OnReceiveRedirect_ParamsSpec.$,
        null,
        this.onReceiveRedirect.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onUploadProgress =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        network.mojom.URLLoaderClient_OnUploadProgress_ParamsSpec.$,
        network.mojom.URLLoaderClient_OnUploadProgress_ResponseParamsSpec.$,
        this.onUploadProgress.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onTransferSizeUpdated =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        network.mojom.URLLoaderClient_OnTransferSizeUpdated_ParamsSpec.$,
        null,
        this.onTransferSizeUpdated.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onComplete =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        network.mojom.URLLoaderClient_OnComplete_ParamsSpec.$,
        null,
        this.onComplete.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.URLRequestRedirectInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.URLLoaderClientEndpointsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.URLLoader_FollowRedirect_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.URLLoader_SetPriority_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.URLLoaderClient_OnReceiveEarlyHints_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.URLLoaderClient_OnReceiveResponse_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.URLLoaderClient_OnReceiveRedirect_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.URLLoaderClient_OnUploadProgress_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.URLLoaderClient_OnUploadProgress_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.URLLoaderClient_OnTransferSizeUpdated_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.URLLoaderClient_OnComplete_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    network.mojom.URLRequestRedirectInfoSpec.$,
    'URLRequestRedirectInfo',
    [
    ],
    [[0, 8],]);





/** @record */
network.mojom.URLRequestRedirectInfo = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.URLLoaderClientEndpointsSpec.$,
    'URLLoaderClientEndpoints',
    [
      mojo.internal.StructField(
        'urlLoader', 0,
        0,
        mojo.internal.InterfaceProxy(network.mojom.URLLoaderRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'urlLoaderClient', 8,
        0,
        mojo.internal.InterfaceRequest(network.mojom.URLLoaderClientPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
network.mojom.URLLoaderClientEndpoints = class {
  constructor() {
    /** @export { !network.mojom.URLLoaderRemote } */
    this.urlLoader;
    /** @export { !network.mojom.URLLoaderClientPendingReceiver } */
    this.urlLoaderClient;
  }
};



mojo.internal.Struct(
    network.mojom.URLLoader_FollowRedirect_ParamsSpec.$,
    'URLLoader_FollowRedirect_Params',
    [
      mojo.internal.StructField(
        'removedHeaders', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'modifiedHeaders', 8,
        0,
        network.mojom.HttpRequestHeadersSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'modifiedCorsExemptHeaders', 16,
        0,
        network.mojom.HttpRequestHeadersSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'newUrl', 24,
        0,
        url.mojom.UrlSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
network.mojom.URLLoader_FollowRedirect_Params = class {
  constructor() {
    /** @export { !Array<!string> } */
    this.removedHeaders;
    /** @export { !network.mojom.HttpRequestHeaders } */
    this.modifiedHeaders;
    /** @export { !network.mojom.HttpRequestHeaders } */
    this.modifiedCorsExemptHeaders;
    /** @export { (url.mojom.Url|undefined) } */
    this.newUrl;
  }
};



mojo.internal.Struct(
    network.mojom.URLLoader_SetPriority_ParamsSpec.$,
    'URLLoader_SetPriority_Params',
    [
      mojo.internal.StructField(
        'priority', 0,
        0,
        network.mojom.RequestPrioritySpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'intraPriorityValue', 4,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.URLLoader_SetPriority_Params = class {
  constructor() {
    /** @export { !network.mojom.RequestPriority } */
    this.priority;
    /** @export { !number } */
    this.intraPriorityValue;
  }
};



mojo.internal.Struct(
    network.mojom.URLLoaderClient_OnReceiveEarlyHints_ParamsSpec.$,
    'URLLoaderClient_OnReceiveEarlyHints_Params',
    [
      mojo.internal.StructField(
        'earlyHints', 0,
        0,
        network.mojom.EarlyHintsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.URLLoaderClient_OnReceiveEarlyHints_Params = class {
  constructor() {
    /** @export { !network.mojom.EarlyHints } */
    this.earlyHints;
  }
};



mojo.internal.Struct(
    network.mojom.URLLoaderClient_OnReceiveResponse_ParamsSpec.$,
    'URLLoaderClient_OnReceiveResponse_Params',
    [
      mojo.internal.StructField(
        'head', 0,
        0,
        network.mojom.URLResponseHeadSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'body', 8,
        0,
        mojo.internal.Handle,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'cachedMetadata', 16,
        0,
        mojoBase.mojom.BigBufferSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
network.mojom.URLLoaderClient_OnReceiveResponse_Params = class {
  constructor() {
    /** @export { !network.mojom.URLResponseHead } */
    this.head;
    /** @export { (MojoHandle|undefined) } */
    this.body;
    /** @export { (mojoBase.mojom.BigBuffer|undefined) } */
    this.cachedMetadata;
  }
};



mojo.internal.Struct(
    network.mojom.URLLoaderClient_OnReceiveRedirect_ParamsSpec.$,
    'URLLoaderClient_OnReceiveRedirect_Params',
    [
      mojo.internal.StructField(
        'redirectInfo', 0,
        0,
        network.mojom.URLRequestRedirectInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'head', 8,
        0,
        network.mojom.URLResponseHeadSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
network.mojom.URLLoaderClient_OnReceiveRedirect_Params = class {
  constructor() {
    /** @export { !network.mojom.URLRequestRedirectInfo } */
    this.redirectInfo;
    /** @export { !network.mojom.URLResponseHead } */
    this.head;
  }
};



mojo.internal.Struct(
    network.mojom.URLLoaderClient_OnUploadProgress_ParamsSpec.$,
    'URLLoaderClient_OnUploadProgress_Params',
    [
      mojo.internal.StructField(
        'currentPosition', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'totalSize', 8,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
network.mojom.URLLoaderClient_OnUploadProgress_Params = class {
  constructor() {
    /** @export { !bigint } */
    this.currentPosition;
    /** @export { !bigint } */
    this.totalSize;
  }
};



mojo.internal.Struct(
    network.mojom.URLLoaderClient_OnUploadProgress_ResponseParamsSpec.$,
    'URLLoaderClient_OnUploadProgress_ResponseParams',
    [
    ],
    [[0, 8],]);





/** @record */
network.mojom.URLLoaderClient_OnUploadProgress_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.URLLoaderClient_OnTransferSizeUpdated_ParamsSpec.$,
    'URLLoaderClient_OnTransferSizeUpdated_Params',
    [
      mojo.internal.StructField(
        'transferSizeDiff', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.URLLoaderClient_OnTransferSizeUpdated_Params = class {
  constructor() {
    /** @export { !number } */
    this.transferSizeDiff;
  }
};



mojo.internal.Struct(
    network.mojom.URLLoaderClient_OnComplete_ParamsSpec.$,
    'URLLoaderClient_OnComplete_Params',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        network.mojom.URLLoaderCompletionStatusSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.URLLoaderClient_OnComplete_Params = class {
  constructor() {
    /** @export { !network.mojom.URLLoaderCompletionStatus } */
    this.status;
  }
};

