// services/network/public/mojom/url_loader.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/network/public/mojom/url_loader.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('network.mojom');
  var big_buffer$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/big_buffer.mojom', '../../../../mojo/public/mojom/base/big_buffer.mojom.js');
  }
  var early_hints$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/early_hints.mojom', 'early_hints.mojom.js');
  }
  var http_request_headers$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/http_request_headers.mojom', 'http_request_headers.mojom.js');
  }
  var request_priority$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/request_priority.mojom', 'request_priority.mojom.js');
  }
  var url_loader_completion_status$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/url_loader_completion_status.mojom', 'url_loader_completion_status.mojom.js');
  }
  var url_response_head$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/url_response_head.mojom', 'url_response_head.mojom.js');
  }
  var url$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/url.mojom', '../../../../url/mojom/url.mojom.js');
  }



  function URLRequestRedirectInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  URLRequestRedirectInfo.prototype.initDefaults_ = function() {
  };
  URLRequestRedirectInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  URLRequestRedirectInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  URLRequestRedirectInfo.encodedSize = codec.kStructHeaderSize + 0;

  URLRequestRedirectInfo.decode = function(decoder) {
    var packed;
    var val = new URLRequestRedirectInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  URLRequestRedirectInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(URLRequestRedirectInfo.encodedSize);
    encoder.writeUint32(0);
  };
  function URLLoaderClientEndpoints(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  URLLoaderClientEndpoints.prototype.initDefaults_ = function() {
    this.urlLoader = new URLLoaderPtr();
    this.urlLoaderClient = new bindings.InterfaceRequest();
  };
  URLLoaderClientEndpoints.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  URLLoaderClientEndpoints.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLLoaderClientEndpoints.urlLoader
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLLoaderClientEndpoints.urlLoaderClient
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  URLLoaderClientEndpoints.encodedSize = codec.kStructHeaderSize + 16;

  URLLoaderClientEndpoints.decode = function(decoder) {
    var packed;
    var val = new URLLoaderClientEndpoints();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.urlLoader =
        decoder.decodeStruct(new codec.Interface(URLLoaderPtr));
    val.urlLoaderClient =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  URLLoaderClientEndpoints.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(URLLoaderClientEndpoints.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(new codec.Interface(URLLoaderPtr), val.urlLoader);
    encoder.encodeStruct(codec.InterfaceRequest, val.urlLoaderClient);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function URLLoader_FollowRedirect_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  URLLoader_FollowRedirect_Params.prototype.initDefaults_ = function() {
    this.removedHeaders = null;
    this.modifiedHeaders = null;
    this.modifiedCorsExemptHeaders = null;
    this.newUrl = null;
  };
  URLLoader_FollowRedirect_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  URLLoader_FollowRedirect_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLLoader_FollowRedirect_Params.removedHeaders
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, codec.String, false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLLoader_FollowRedirect_Params.modifiedHeaders
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, http_request_headers$.HttpRequestHeaders, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLLoader_FollowRedirect_Params.modifiedCorsExemptHeaders
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, http_request_headers$.HttpRequestHeaders, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLLoader_FollowRedirect_Params.newUrl
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, url$.Url, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  URLLoader_FollowRedirect_Params.encodedSize = codec.kStructHeaderSize + 32;

  URLLoader_FollowRedirect_Params.decode = function(decoder) {
    var packed;
    var val = new URLLoader_FollowRedirect_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.removedHeaders =
        decoder.decodeArrayPointer(codec.String);
    val.modifiedHeaders =
        decoder.decodeStructPointer(http_request_headers$.HttpRequestHeaders);
    val.modifiedCorsExemptHeaders =
        decoder.decodeStructPointer(http_request_headers$.HttpRequestHeaders);
    val.newUrl =
        decoder.decodeStructPointer(url$.Url);
    return val;
  };

  URLLoader_FollowRedirect_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(URLLoader_FollowRedirect_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.String, val.removedHeaders);
    encoder.encodeStructPointer(http_request_headers$.HttpRequestHeaders, val.modifiedHeaders);
    encoder.encodeStructPointer(http_request_headers$.HttpRequestHeaders, val.modifiedCorsExemptHeaders);
    encoder.encodeStructPointer(url$.Url, val.newUrl);
  };
  function URLLoader_SetPriority_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  URLLoader_SetPriority_Params.prototype.initDefaults_ = function() {
    this.priority = 0;
    this.intraPriorityValue = 0;
  };
  URLLoader_SetPriority_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  URLLoader_SetPriority_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLLoader_SetPriority_Params.priority
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, request_priority$.RequestPriority);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  URLLoader_SetPriority_Params.encodedSize = codec.kStructHeaderSize + 8;

  URLLoader_SetPriority_Params.decode = function(decoder) {
    var packed;
    var val = new URLLoader_SetPriority_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.priority =
        decoder.decodeStruct(new codec.Enum(request_priority$.RequestPriority));
    val.intraPriorityValue =
        decoder.decodeStruct(codec.Int32);
    return val;
  };

  URLLoader_SetPriority_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(URLLoader_SetPriority_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.priority);
    encoder.encodeStruct(codec.Int32, val.intraPriorityValue);
  };
  function URLLoaderClient_OnReceiveEarlyHints_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  URLLoaderClient_OnReceiveEarlyHints_Params.prototype.initDefaults_ = function() {
    this.earlyHints = null;
  };
  URLLoaderClient_OnReceiveEarlyHints_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  URLLoaderClient_OnReceiveEarlyHints_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLLoaderClient_OnReceiveEarlyHints_Params.earlyHints
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, early_hints$.EarlyHints, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  URLLoaderClient_OnReceiveEarlyHints_Params.encodedSize = codec.kStructHeaderSize + 8;

  URLLoaderClient_OnReceiveEarlyHints_Params.decode = function(decoder) {
    var packed;
    var val = new URLLoaderClient_OnReceiveEarlyHints_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.earlyHints =
        decoder.decodeStructPointer(early_hints$.EarlyHints);
    return val;
  };

  URLLoaderClient_OnReceiveEarlyHints_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(URLLoaderClient_OnReceiveEarlyHints_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(early_hints$.EarlyHints, val.earlyHints);
  };
  function URLLoaderClient_OnReceiveResponse_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  URLLoaderClient_OnReceiveResponse_Params.prototype.initDefaults_ = function() {
    this.head = null;
    this.body = null;
    this.cachedMetadata = null;
  };
  URLLoaderClient_OnReceiveResponse_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  URLLoaderClient_OnReceiveResponse_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLLoaderClient_OnReceiveResponse_Params.head
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url_response_head$.URLResponseHead, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLLoaderClient_OnReceiveResponse_Params.body
    err = messageValidator.validateHandle(offset + codec.kStructHeaderSize + 8, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLLoaderClient_OnReceiveResponse_Params.cachedMetadata
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 16, big_buffer$.BigBuffer, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  URLLoaderClient_OnReceiveResponse_Params.encodedSize = codec.kStructHeaderSize + 32;

  URLLoaderClient_OnReceiveResponse_Params.decode = function(decoder) {
    var packed;
    var val = new URLLoaderClient_OnReceiveResponse_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.head =
        decoder.decodeStructPointer(url_response_head$.URLResponseHead);
    val.body =
        decoder.decodeStruct(codec.Handle);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.cachedMetadata =
        decoder.decodeStruct(big_buffer$.BigBuffer);
    return val;
  };

  URLLoaderClient_OnReceiveResponse_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(URLLoaderClient_OnReceiveResponse_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url_response_head$.URLResponseHead, val.head);
    encoder.encodeStruct(codec.Handle, val.body);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(big_buffer$.BigBuffer, val.cachedMetadata);
  };
  function URLLoaderClient_OnReceiveRedirect_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  URLLoaderClient_OnReceiveRedirect_Params.prototype.initDefaults_ = function() {
    this.redirectInfo = null;
    this.head = null;
  };
  URLLoaderClient_OnReceiveRedirect_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  URLLoaderClient_OnReceiveRedirect_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLLoaderClient_OnReceiveRedirect_Params.redirectInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, URLRequestRedirectInfo, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLLoaderClient_OnReceiveRedirect_Params.head
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, url_response_head$.URLResponseHead, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  URLLoaderClient_OnReceiveRedirect_Params.encodedSize = codec.kStructHeaderSize + 16;

  URLLoaderClient_OnReceiveRedirect_Params.decode = function(decoder) {
    var packed;
    var val = new URLLoaderClient_OnReceiveRedirect_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.redirectInfo =
        decoder.decodeStructPointer(URLRequestRedirectInfo);
    val.head =
        decoder.decodeStructPointer(url_response_head$.URLResponseHead);
    return val;
  };

  URLLoaderClient_OnReceiveRedirect_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(URLLoaderClient_OnReceiveRedirect_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(URLRequestRedirectInfo, val.redirectInfo);
    encoder.encodeStructPointer(url_response_head$.URLResponseHead, val.head);
  };
  function URLLoaderClient_OnUploadProgress_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  URLLoaderClient_OnUploadProgress_Params.prototype.initDefaults_ = function() {
    this.currentPosition = 0;
    this.totalSize = 0;
  };
  URLLoaderClient_OnUploadProgress_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  URLLoaderClient_OnUploadProgress_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  URLLoaderClient_OnUploadProgress_Params.encodedSize = codec.kStructHeaderSize + 16;

  URLLoaderClient_OnUploadProgress_Params.decode = function(decoder) {
    var packed;
    var val = new URLLoaderClient_OnUploadProgress_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.currentPosition =
        decoder.decodeStruct(codec.Int64);
    val.totalSize =
        decoder.decodeStruct(codec.Int64);
    return val;
  };

  URLLoaderClient_OnUploadProgress_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(URLLoaderClient_OnUploadProgress_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int64, val.currentPosition);
    encoder.encodeStruct(codec.Int64, val.totalSize);
  };
  function URLLoaderClient_OnUploadProgress_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  URLLoaderClient_OnUploadProgress_ResponseParams.prototype.initDefaults_ = function() {
  };
  URLLoaderClient_OnUploadProgress_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  URLLoaderClient_OnUploadProgress_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  URLLoaderClient_OnUploadProgress_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  URLLoaderClient_OnUploadProgress_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new URLLoaderClient_OnUploadProgress_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  URLLoaderClient_OnUploadProgress_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(URLLoaderClient_OnUploadProgress_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function URLLoaderClient_OnTransferSizeUpdated_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  URLLoaderClient_OnTransferSizeUpdated_Params.prototype.initDefaults_ = function() {
    this.transferSizeDiff = 0;
  };
  URLLoaderClient_OnTransferSizeUpdated_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  URLLoaderClient_OnTransferSizeUpdated_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  URLLoaderClient_OnTransferSizeUpdated_Params.encodedSize = codec.kStructHeaderSize + 8;

  URLLoaderClient_OnTransferSizeUpdated_Params.decode = function(decoder) {
    var packed;
    var val = new URLLoaderClient_OnTransferSizeUpdated_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.transferSizeDiff =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  URLLoaderClient_OnTransferSizeUpdated_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(URLLoaderClient_OnTransferSizeUpdated_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.transferSizeDiff);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function URLLoaderClient_OnComplete_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  URLLoaderClient_OnComplete_Params.prototype.initDefaults_ = function() {
    this.status = null;
  };
  URLLoaderClient_OnComplete_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  URLLoaderClient_OnComplete_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLLoaderClient_OnComplete_Params.status
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url_loader_completion_status$.URLLoaderCompletionStatus, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  URLLoaderClient_OnComplete_Params.encodedSize = codec.kStructHeaderSize + 8;

  URLLoaderClient_OnComplete_Params.decode = function(decoder) {
    var packed;
    var val = new URLLoaderClient_OnComplete_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.status =
        decoder.decodeStructPointer(url_loader_completion_status$.URLLoaderCompletionStatus);
    return val;
  };

  URLLoaderClient_OnComplete_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(URLLoaderClient_OnComplete_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url_loader_completion_status$.URLLoaderCompletionStatus, val.status);
  };
  var kURLLoader_FollowRedirect_Name = 0;
  var kURLLoader_SetPriority_Name = 1;

  function URLLoaderPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(URLLoader,
                                                   handleOrPtrInfo);
  }

  function URLLoaderAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        URLLoader, associatedInterfacePtrInfo);
  }

  URLLoaderAssociatedPtr.prototype =
      Object.create(URLLoaderPtr.prototype);
  URLLoaderAssociatedPtr.prototype.constructor =
      URLLoaderAssociatedPtr;

  function URLLoaderProxy(receiver) {
    this.receiver_ = receiver;
  }
  URLLoaderPtr.prototype.followRedirect = function() {
    return URLLoaderProxy.prototype.followRedirect
        .apply(this.ptr.getProxy(), arguments);
  };

  URLLoaderProxy.prototype.followRedirect = function(removedHeaders, modifiedHeaders, modifiedCorsExemptHeaders, newUrl) {
    var params_ = new URLLoader_FollowRedirect_Params();
    params_.removedHeaders = removedHeaders;
    params_.modifiedHeaders = modifiedHeaders;
    params_.modifiedCorsExemptHeaders = modifiedCorsExemptHeaders;
    params_.newUrl = newUrl;
    var builder = new codec.MessageV0Builder(
        kURLLoader_FollowRedirect_Name,
        codec.align(URLLoader_FollowRedirect_Params.encodedSize));
    builder.encodeStruct(URLLoader_FollowRedirect_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  URLLoaderPtr.prototype.setPriority = function() {
    return URLLoaderProxy.prototype.setPriority
        .apply(this.ptr.getProxy(), arguments);
  };

  URLLoaderProxy.prototype.setPriority = function(priority, intraPriorityValue) {
    var params_ = new URLLoader_SetPriority_Params();
    params_.priority = priority;
    params_.intraPriorityValue = intraPriorityValue;
    var builder = new codec.MessageV0Builder(
        kURLLoader_SetPriority_Name,
        codec.align(URLLoader_SetPriority_Params.encodedSize));
    builder.encodeStruct(URLLoader_SetPriority_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function URLLoaderStub(delegate) {
    this.delegate_ = delegate;
  }
  URLLoaderStub.prototype.followRedirect = function(removedHeaders, modifiedHeaders, modifiedCorsExemptHeaders, newUrl) {
    return this.delegate_ && this.delegate_.followRedirect && this.delegate_.followRedirect(removedHeaders, modifiedHeaders, modifiedCorsExemptHeaders, newUrl);
  }
  URLLoaderStub.prototype.setPriority = function(priority, intraPriorityValue) {
    return this.delegate_ && this.delegate_.setPriority && this.delegate_.setPriority(priority, intraPriorityValue);
  }

  URLLoaderStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kURLLoader_FollowRedirect_Name:
      var params = reader.decodeStruct(URLLoader_FollowRedirect_Params);
      this.followRedirect(params.removedHeaders, params.modifiedHeaders, params.modifiedCorsExemptHeaders, params.newUrl);
      return true;
    case kURLLoader_SetPriority_Name:
      var params = reader.decodeStruct(URLLoader_SetPriority_Params);
      this.setPriority(params.priority, params.intraPriorityValue);
      return true;
    default:
      return false;
    }
  };

  URLLoaderStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateURLLoaderRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kURLLoader_FollowRedirect_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = URLLoader_FollowRedirect_Params;
      break;
      case kURLLoader_SetPriority_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = URLLoader_SetPriority_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateURLLoaderResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var URLLoader = {
    name: 'network.mojom.URLLoader',
    kVersion: 0,
    ptrClass: URLLoaderPtr,
    proxyClass: URLLoaderProxy,
    stubClass: URLLoaderStub,
    validateRequest: validateURLLoaderRequest,
    validateResponse: null,
  };
  URLLoader.CLIENT_DISCONNECT_REASON = 1,
  URLLoaderStub.prototype.validator = validateURLLoaderRequest;
  URLLoaderProxy.prototype.validator = null;
  var kURLLoaderClient_OnReceiveEarlyHints_Name = 0;
  var kURLLoaderClient_OnReceiveResponse_Name = 1;
  var kURLLoaderClient_OnReceiveRedirect_Name = 2;
  var kURLLoaderClient_OnUploadProgress_Name = 3;
  var kURLLoaderClient_OnTransferSizeUpdated_Name = 4;
  var kURLLoaderClient_OnComplete_Name = 5;

  function URLLoaderClientPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(URLLoaderClient,
                                                   handleOrPtrInfo);
  }

  function URLLoaderClientAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        URLLoaderClient, associatedInterfacePtrInfo);
  }

  URLLoaderClientAssociatedPtr.prototype =
      Object.create(URLLoaderClientPtr.prototype);
  URLLoaderClientAssociatedPtr.prototype.constructor =
      URLLoaderClientAssociatedPtr;

  function URLLoaderClientProxy(receiver) {
    this.receiver_ = receiver;
  }
  URLLoaderClientPtr.prototype.onReceiveEarlyHints = function() {
    return URLLoaderClientProxy.prototype.onReceiveEarlyHints
        .apply(this.ptr.getProxy(), arguments);
  };

  URLLoaderClientProxy.prototype.onReceiveEarlyHints = function(earlyHints) {
    var params_ = new URLLoaderClient_OnReceiveEarlyHints_Params();
    params_.earlyHints = earlyHints;
    var builder = new codec.MessageV0Builder(
        kURLLoaderClient_OnReceiveEarlyHints_Name,
        codec.align(URLLoaderClient_OnReceiveEarlyHints_Params.encodedSize));
    builder.encodeStruct(URLLoaderClient_OnReceiveEarlyHints_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  URLLoaderClientPtr.prototype.onReceiveResponse = function() {
    return URLLoaderClientProxy.prototype.onReceiveResponse
        .apply(this.ptr.getProxy(), arguments);
  };

  URLLoaderClientProxy.prototype.onReceiveResponse = function(head, body, cachedMetadata) {
    var params_ = new URLLoaderClient_OnReceiveResponse_Params();
    params_.head = head;
    params_.body = body;
    params_.cachedMetadata = cachedMetadata;
    var builder = new codec.MessageV0Builder(
        kURLLoaderClient_OnReceiveResponse_Name,
        codec.align(URLLoaderClient_OnReceiveResponse_Params.encodedSize));
    builder.encodeStruct(URLLoaderClient_OnReceiveResponse_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  URLLoaderClientPtr.prototype.onReceiveRedirect = function() {
    return URLLoaderClientProxy.prototype.onReceiveRedirect
        .apply(this.ptr.getProxy(), arguments);
  };

  URLLoaderClientProxy.prototype.onReceiveRedirect = function(redirectInfo, head) {
    var params_ = new URLLoaderClient_OnReceiveRedirect_Params();
    params_.redirectInfo = redirectInfo;
    params_.head = head;
    var builder = new codec.MessageV0Builder(
        kURLLoaderClient_OnReceiveRedirect_Name,
        codec.align(URLLoaderClient_OnReceiveRedirect_Params.encodedSize));
    builder.encodeStruct(URLLoaderClient_OnReceiveRedirect_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  URLLoaderClientPtr.prototype.onUploadProgress = function() {
    return URLLoaderClientProxy.prototype.onUploadProgress
        .apply(this.ptr.getProxy(), arguments);
  };

  URLLoaderClientProxy.prototype.onUploadProgress = function(currentPosition, totalSize) {
    var params_ = new URLLoaderClient_OnUploadProgress_Params();
    params_.currentPosition = currentPosition;
    params_.totalSize = totalSize;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kURLLoaderClient_OnUploadProgress_Name,
          codec.align(URLLoaderClient_OnUploadProgress_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(URLLoaderClient_OnUploadProgress_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(URLLoaderClient_OnUploadProgress_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  URLLoaderClientPtr.prototype.onTransferSizeUpdated = function() {
    return URLLoaderClientProxy.prototype.onTransferSizeUpdated
        .apply(this.ptr.getProxy(), arguments);
  };

  URLLoaderClientProxy.prototype.onTransferSizeUpdated = function(transferSizeDiff) {
    var params_ = new URLLoaderClient_OnTransferSizeUpdated_Params();
    params_.transferSizeDiff = transferSizeDiff;
    var builder = new codec.MessageV0Builder(
        kURLLoaderClient_OnTransferSizeUpdated_Name,
        codec.align(URLLoaderClient_OnTransferSizeUpdated_Params.encodedSize));
    builder.encodeStruct(URLLoaderClient_OnTransferSizeUpdated_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  URLLoaderClientPtr.prototype.onComplete = function() {
    return URLLoaderClientProxy.prototype.onComplete
        .apply(this.ptr.getProxy(), arguments);
  };

  URLLoaderClientProxy.prototype.onComplete = function(status) {
    var params_ = new URLLoaderClient_OnComplete_Params();
    params_.status = status;
    var builder = new codec.MessageV0Builder(
        kURLLoaderClient_OnComplete_Name,
        codec.align(URLLoaderClient_OnComplete_Params.encodedSize));
    builder.encodeStruct(URLLoaderClient_OnComplete_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function URLLoaderClientStub(delegate) {
    this.delegate_ = delegate;
  }
  URLLoaderClientStub.prototype.onReceiveEarlyHints = function(earlyHints) {
    return this.delegate_ && this.delegate_.onReceiveEarlyHints && this.delegate_.onReceiveEarlyHints(earlyHints);
  }
  URLLoaderClientStub.prototype.onReceiveResponse = function(head, body, cachedMetadata) {
    return this.delegate_ && this.delegate_.onReceiveResponse && this.delegate_.onReceiveResponse(head, body, cachedMetadata);
  }
  URLLoaderClientStub.prototype.onReceiveRedirect = function(redirectInfo, head) {
    return this.delegate_ && this.delegate_.onReceiveRedirect && this.delegate_.onReceiveRedirect(redirectInfo, head);
  }
  URLLoaderClientStub.prototype.onUploadProgress = function(currentPosition, totalSize) {
    return this.delegate_ && this.delegate_.onUploadProgress && this.delegate_.onUploadProgress(currentPosition, totalSize);
  }
  URLLoaderClientStub.prototype.onTransferSizeUpdated = function(transferSizeDiff) {
    return this.delegate_ && this.delegate_.onTransferSizeUpdated && this.delegate_.onTransferSizeUpdated(transferSizeDiff);
  }
  URLLoaderClientStub.prototype.onComplete = function(status) {
    return this.delegate_ && this.delegate_.onComplete && this.delegate_.onComplete(status);
  }

  URLLoaderClientStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kURLLoaderClient_OnReceiveEarlyHints_Name:
      var params = reader.decodeStruct(URLLoaderClient_OnReceiveEarlyHints_Params);
      this.onReceiveEarlyHints(params.earlyHints);
      return true;
    case kURLLoaderClient_OnReceiveResponse_Name:
      var params = reader.decodeStruct(URLLoaderClient_OnReceiveResponse_Params);
      this.onReceiveResponse(params.head, params.body, params.cachedMetadata);
      return true;
    case kURLLoaderClient_OnReceiveRedirect_Name:
      var params = reader.decodeStruct(URLLoaderClient_OnReceiveRedirect_Params);
      this.onReceiveRedirect(params.redirectInfo, params.head);
      return true;
    case kURLLoaderClient_OnTransferSizeUpdated_Name:
      var params = reader.decodeStruct(URLLoaderClient_OnTransferSizeUpdated_Params);
      this.onTransferSizeUpdated(params.transferSizeDiff);
      return true;
    case kURLLoaderClient_OnComplete_Name:
      var params = reader.decodeStruct(URLLoaderClient_OnComplete_Params);
      this.onComplete(params.status);
      return true;
    default:
      return false;
    }
  };

  URLLoaderClientStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kURLLoaderClient_OnUploadProgress_Name:
      var params = reader.decodeStruct(URLLoaderClient_OnUploadProgress_Params);
      this.onUploadProgress(params.currentPosition, params.totalSize).then(function(response) {
        var responseParams =
            new URLLoaderClient_OnUploadProgress_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kURLLoaderClient_OnUploadProgress_Name,
            codec.align(URLLoaderClient_OnUploadProgress_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(URLLoaderClient_OnUploadProgress_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateURLLoaderClientRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kURLLoaderClient_OnReceiveEarlyHints_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = URLLoaderClient_OnReceiveEarlyHints_Params;
      break;
      case kURLLoaderClient_OnReceiveResponse_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = URLLoaderClient_OnReceiveResponse_Params;
      break;
      case kURLLoaderClient_OnReceiveRedirect_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = URLLoaderClient_OnReceiveRedirect_Params;
      break;
      case kURLLoaderClient_OnUploadProgress_Name:
        if (message.expectsResponse())
          paramsClass = URLLoaderClient_OnUploadProgress_Params;
      break;
      case kURLLoaderClient_OnTransferSizeUpdated_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = URLLoaderClient_OnTransferSizeUpdated_Params;
      break;
      case kURLLoaderClient_OnComplete_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = URLLoaderClient_OnComplete_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateURLLoaderClientResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kURLLoaderClient_OnUploadProgress_Name:
        if (message.isResponse())
          paramsClass = URLLoaderClient_OnUploadProgress_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var URLLoaderClient = {
    name: 'network.mojom.URLLoaderClient',
    kVersion: 0,
    ptrClass: URLLoaderClientPtr,
    proxyClass: URLLoaderClientProxy,
    stubClass: URLLoaderClientStub,
    validateRequest: validateURLLoaderClientRequest,
    validateResponse: validateURLLoaderClientResponse,
  };
  URLLoaderClientStub.prototype.validator = validateURLLoaderClientRequest;
  URLLoaderClientProxy.prototype.validator = validateURLLoaderClientResponse;
  exports.URLRequestRedirectInfo = URLRequestRedirectInfo;
  exports.URLLoaderClientEndpoints = URLLoaderClientEndpoints;
  exports.URLLoader = URLLoader;
  exports.URLLoaderPtr = URLLoaderPtr;
  exports.URLLoaderAssociatedPtr = URLLoaderAssociatedPtr;
  exports.URLLoaderClient = URLLoaderClient;
  exports.URLLoaderClientPtr = URLLoaderClientPtr;
  exports.URLLoaderClientAssociatedPtr = URLLoaderClientAssociatedPtr;
})();