// services/network/public/mojom/web_bundle_handle.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/network/public/mojom/web_bundle_handle.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('network.mojom');


  var WebBundleErrorType = {};
  WebBundleErrorType.kMetadataParseError = 0;
  WebBundleErrorType.kResponseParseError = 1;
  WebBundleErrorType.kResourceNotFound = 2;
  WebBundleErrorType.kMemoryQuotaExceeded = 3;
  WebBundleErrorType.kServingConstraintsNotMet = 4;
  WebBundleErrorType.kWebBundleFetchFailed = 5;
  WebBundleErrorType.kWebBundleRedirected = 6;
  WebBundleErrorType.kDeprecationWarning = 7;
  WebBundleErrorType.MIN_VALUE = 0;
  WebBundleErrorType.MAX_VALUE = 7;

  WebBundleErrorType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
      return true;
    }
    return false;
  };

  WebBundleErrorType.toKnownEnumValue = function(value) {
    return value;
  };

  WebBundleErrorType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function WebBundleHandle_Clone_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebBundleHandle_Clone_Params.prototype.initDefaults_ = function() {
    this.receiver = new bindings.InterfaceRequest();
  };
  WebBundleHandle_Clone_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebBundleHandle_Clone_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebBundleHandle_Clone_Params.receiver
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebBundleHandle_Clone_Params.encodedSize = codec.kStructHeaderSize + 8;

  WebBundleHandle_Clone_Params.decode = function(decoder) {
    var packed;
    var val = new WebBundleHandle_Clone_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.receiver =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  WebBundleHandle_Clone_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebBundleHandle_Clone_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.receiver);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function WebBundleHandle_OnWebBundleError_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebBundleHandle_OnWebBundleError_Params.prototype.initDefaults_ = function() {
    this.type = 0;
    this.message = null;
  };
  WebBundleHandle_OnWebBundleError_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebBundleHandle_OnWebBundleError_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebBundleHandle_OnWebBundleError_Params.type
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, WebBundleErrorType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebBundleHandle_OnWebBundleError_Params.message
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebBundleHandle_OnWebBundleError_Params.encodedSize = codec.kStructHeaderSize + 16;

  WebBundleHandle_OnWebBundleError_Params.decode = function(decoder) {
    var packed;
    var val = new WebBundleHandle_OnWebBundleError_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.type =
        decoder.decodeStruct(new codec.Enum(WebBundleErrorType));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.message =
        decoder.decodeStruct(codec.String);
    return val;
  };

  WebBundleHandle_OnWebBundleError_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebBundleHandle_OnWebBundleError_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.type);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.message);
  };
  function WebBundleHandle_OnWebBundleLoadFinished_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebBundleHandle_OnWebBundleLoadFinished_Params.prototype.initDefaults_ = function() {
    this.success = false;
  };
  WebBundleHandle_OnWebBundleLoadFinished_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebBundleHandle_OnWebBundleLoadFinished_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  WebBundleHandle_OnWebBundleLoadFinished_Params.encodedSize = codec.kStructHeaderSize + 8;

  WebBundleHandle_OnWebBundleLoadFinished_Params.decode = function(decoder) {
    var packed;
    var val = new WebBundleHandle_OnWebBundleLoadFinished_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.success = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  WebBundleHandle_OnWebBundleLoadFinished_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebBundleHandle_OnWebBundleLoadFinished_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.success & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  var kWebBundleHandle_Clone_Name = 0;
  var kWebBundleHandle_OnWebBundleError_Name = 1;
  var kWebBundleHandle_OnWebBundleLoadFinished_Name = 2;

  function WebBundleHandlePtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(WebBundleHandle,
                                                   handleOrPtrInfo);
  }

  function WebBundleHandleAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        WebBundleHandle, associatedInterfacePtrInfo);
  }

  WebBundleHandleAssociatedPtr.prototype =
      Object.create(WebBundleHandlePtr.prototype);
  WebBundleHandleAssociatedPtr.prototype.constructor =
      WebBundleHandleAssociatedPtr;

  function WebBundleHandleProxy(receiver) {
    this.receiver_ = receiver;
  }
  WebBundleHandlePtr.prototype.clone = function() {
    return WebBundleHandleProxy.prototype.clone
        .apply(this.ptr.getProxy(), arguments);
  };

  WebBundleHandleProxy.prototype.clone = function(receiver) {
    var params_ = new WebBundleHandle_Clone_Params();
    params_.receiver = receiver;
    var builder = new codec.MessageV0Builder(
        kWebBundleHandle_Clone_Name,
        codec.align(WebBundleHandle_Clone_Params.encodedSize));
    builder.encodeStruct(WebBundleHandle_Clone_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WebBundleHandlePtr.prototype.onWebBundleError = function() {
    return WebBundleHandleProxy.prototype.onWebBundleError
        .apply(this.ptr.getProxy(), arguments);
  };

  WebBundleHandleProxy.prototype.onWebBundleError = function(type, message) {
    var params_ = new WebBundleHandle_OnWebBundleError_Params();
    params_.type = type;
    params_.message = message;
    var builder = new codec.MessageV0Builder(
        kWebBundleHandle_OnWebBundleError_Name,
        codec.align(WebBundleHandle_OnWebBundleError_Params.encodedSize));
    builder.encodeStruct(WebBundleHandle_OnWebBundleError_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WebBundleHandlePtr.prototype.onWebBundleLoadFinished = function() {
    return WebBundleHandleProxy.prototype.onWebBundleLoadFinished
        .apply(this.ptr.getProxy(), arguments);
  };

  WebBundleHandleProxy.prototype.onWebBundleLoadFinished = function(success) {
    var params_ = new WebBundleHandle_OnWebBundleLoadFinished_Params();
    params_.success = success;
    var builder = new codec.MessageV0Builder(
        kWebBundleHandle_OnWebBundleLoadFinished_Name,
        codec.align(WebBundleHandle_OnWebBundleLoadFinished_Params.encodedSize));
    builder.encodeStruct(WebBundleHandle_OnWebBundleLoadFinished_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function WebBundleHandleStub(delegate) {
    this.delegate_ = delegate;
  }
  WebBundleHandleStub.prototype.clone = function(receiver) {
    return this.delegate_ && this.delegate_.clone && this.delegate_.clone(receiver);
  }
  WebBundleHandleStub.prototype.onWebBundleError = function(type, message) {
    return this.delegate_ && this.delegate_.onWebBundleError && this.delegate_.onWebBundleError(type, message);
  }
  WebBundleHandleStub.prototype.onWebBundleLoadFinished = function(success) {
    return this.delegate_ && this.delegate_.onWebBundleLoadFinished && this.delegate_.onWebBundleLoadFinished(success);
  }

  WebBundleHandleStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kWebBundleHandle_Clone_Name:
      var params = reader.decodeStruct(WebBundleHandle_Clone_Params);
      this.clone(params.receiver);
      return true;
    case kWebBundleHandle_OnWebBundleError_Name:
      var params = reader.decodeStruct(WebBundleHandle_OnWebBundleError_Params);
      this.onWebBundleError(params.type, params.message);
      return true;
    case kWebBundleHandle_OnWebBundleLoadFinished_Name:
      var params = reader.decodeStruct(WebBundleHandle_OnWebBundleLoadFinished_Params);
      this.onWebBundleLoadFinished(params.success);
      return true;
    default:
      return false;
    }
  };

  WebBundleHandleStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateWebBundleHandleRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kWebBundleHandle_Clone_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WebBundleHandle_Clone_Params;
      break;
      case kWebBundleHandle_OnWebBundleError_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WebBundleHandle_OnWebBundleError_Params;
      break;
      case kWebBundleHandle_OnWebBundleLoadFinished_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WebBundleHandle_OnWebBundleLoadFinished_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateWebBundleHandleResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var WebBundleHandle = {
    name: 'network.mojom.WebBundleHandle',
    kVersion: 0,
    ptrClass: WebBundleHandlePtr,
    proxyClass: WebBundleHandleProxy,
    stubClass: WebBundleHandleStub,
    validateRequest: validateWebBundleHandleRequest,
    validateResponse: null,
  };
  WebBundleHandleStub.prototype.validator = validateWebBundleHandleRequest;
  WebBundleHandleProxy.prototype.validator = null;
  exports.WebBundleErrorType = WebBundleErrorType;
  exports.WebBundleHandle = WebBundleHandle;
  exports.WebBundleHandlePtr = WebBundleHandlePtr;
  exports.WebBundleHandleAssociatedPtr = WebBundleHandleAssociatedPtr;
})();