// services/on_device_model/public/mojom/on_device_model.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';

import {
  File as mojoBase_mojom_File,
  FileSpec as mojoBase_mojom_FileSpec
} from '../../../../mojo/public/mojom/base/file.mojom.m.js';

import {
  FilePath as mojoBase_mojom_FilePath,
  FilePathSpec as mojoBase_mojom_FilePathSpec
} from '../../../../mojo/public/mojom/base/file_path.mojom.m.js';

import {
  BitmapWithArbitraryBpp as skia_mojom_BitmapWithArbitraryBpp,
  BitmapWithArbitraryBppSpec as skia_mojom_BitmapWithArbitraryBppSpec
} from '../../../../skia/public/mojom/bitmap.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const TokenSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const Token = {
  
  kSystem: 0,
  kModel: 1,
  kUser: 2,
  kEnd: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const PrioritySpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const Priority = {
  
  kForeground: 0,
  kBackground: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const PerformanceClassSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const PerformanceClass = {
  
  kError: 0,
  kGpuBlocked: 1,
  kFailedToLoadLibrary: 2,
  kVeryLow: 3,
  kLow: 4,
  kMedium: 5,
  kHigh: 6,
  kVeryHigh: 7,
  MIN_VALUE: 0,
  MAX_VALUE: 7,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const LoadModelResultSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const LoadModelResult = {
  
  kSuccess: 0,
  kGpuBlocked: 1,
  kFailedToLoadLibrary: 2,
  kCrosNeedReboot: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class StreamingResponderPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'on_device_model.mojom.StreamingResponder', scope);
  }
}

/** @interface */
export class StreamingResponderInterface {
  
  /**
   * @param { !ResponseChunk } chunk
   */

  onResponse(chunk) {}
  
  /**
   * @param { !ResponseSummary } summary
   */

  onComplete(summary) {}
}

/**
 * @implements { StreamingResponderInterface }
 */
export class StreamingResponderRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!StreamingResponderPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          StreamingResponderPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!StreamingResponderPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !ResponseChunk } chunk
   */

  onResponse(
      chunk) {
    this.proxy.sendMessage(
        0,
        StreamingResponder_OnResponse_ParamsSpec.$,
        null,
        [
          chunk
        ],
        false);
  }

  
  /**
   * @param { !ResponseSummary } summary
   */

  onComplete(
      summary) {
    this.proxy.sendMessage(
        1,
        StreamingResponder_OnComplete_ParamsSpec.$,
        null,
        [
          summary
        ],
        false);
  }
}

/**
 * An object which receives request messages for the StreamingResponder
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class StreamingResponderReceiver {
  /**
   * @param {!StreamingResponderInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!StreamingResponderRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        StreamingResponderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!StreamingResponderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        StreamingResponder_OnResponse_ParamsSpec.$,
        null,
        impl.onResponse.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        StreamingResponder_OnComplete_ParamsSpec.$,
        null,
        impl.onComplete.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class StreamingResponder {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "on_device_model.mojom.StreamingResponder";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!StreamingResponderRemote}
   */
  static getRemote() {
    let remote = new StreamingResponderRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the StreamingResponder
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class StreamingResponderCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      StreamingResponderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!StreamingResponderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onResponse =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        StreamingResponder_OnResponse_ParamsSpec.$,
        null,
        this.onResponse.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onComplete =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        StreamingResponder_OnComplete_ParamsSpec.$,
        null,
        this.onComplete.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class ContextClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'on_device_model.mojom.ContextClient', scope);
  }
}

/** @interface */
export class ContextClientInterface {
  
  /**
   * @param { !number } tokensProcessed
   */

  onComplete(tokensProcessed) {}
}

/**
 * @implements { ContextClientInterface }
 */
export class ContextClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ContextClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ContextClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ContextClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !number } tokensProcessed
   */

  onComplete(
      tokensProcessed) {
    this.proxy.sendMessage(
        0,
        ContextClient_OnComplete_ParamsSpec.$,
        null,
        [
          tokensProcessed
        ],
        false);
  }
}

/**
 * An object which receives request messages for the ContextClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ContextClientReceiver {
  /**
   * @param {!ContextClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ContextClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ContextClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ContextClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ContextClient_OnComplete_ParamsSpec.$,
        null,
        impl.onComplete.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class ContextClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "on_device_model.mojom.ContextClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ContextClientRemote}
   */
  static getRemote() {
    let remote = new ContextClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the ContextClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ContextClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ContextClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ContextClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onComplete =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ContextClient_OnComplete_ParamsSpec.$,
        null,
        this.onComplete.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class SessionPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'on_device_model.mojom.Session', scope);
  }
}

/** @interface */
export class SessionInterface {
  
  /**
   * @param { !AppendOptions } options
   * @param { ?ContextClientRemote } client
   */

  append(options, client) {}
  
  /**
   * @param { !GenerateOptions } options
   * @param { !StreamingResponderRemote } responder
   */

  generate(options, responder) {}
  
  /**
   * @param { !Input } input
   * @return {!Promise<{
        size: !number,
   *  }>}
   */

  getSizeInTokens(input) {}
  
  /**
   * @param { !string } text
   * @return {!Promise<{
        probability: !number,
   *  }>}
   */

  score(text) {}
  
  /**
   * @param { !SessionPendingReceiver } session
   */

  clone(session) {}
  
  /**
   * @param { !string } text
   * @return {!Promise<{
        probabilities: !Array<!number>,
   *  }>}
   */

  getProbabilitiesBlocking(text) {}
  
  /**
   * @param { !Priority } priority
   */

  setPriority(priority) {}
  
  /**
   * @param { !AsrStreamOptions } options
   * @param { !AsrStreamInputPendingReceiver } stream
   * @param { !AsrStreamResponderRemote } responder
   */

  asrStream(options, stream, responder) {}
}

/**
 * @implements { SessionInterface }
 */
export class SessionRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!SessionPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          SessionPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!SessionPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !AppendOptions } options
   * @param { ?ContextClientRemote } client
   */

  append(
      options,
      client) {
    this.proxy.sendMessage(
        6,
        Session_Append_ParamsSpec.$,
        null,
        [
          options,
          client
        ],
        false);
  }

  
  /**
   * @param { !GenerateOptions } options
   * @param { !StreamingResponderRemote } responder
   */

  generate(
      options,
      responder) {
    this.proxy.sendMessage(
        7,
        Session_Generate_ParamsSpec.$,
        null,
        [
          options,
          responder
        ],
        false);
  }

  
  /**
   * @param { !Input } input
   * @return {!Promise<{
        size: !number,
   *  }>}
   */

  getSizeInTokens(
      input) {
    return this.proxy.sendMessage(
        5,
        Session_GetSizeInTokens_ParamsSpec.$,
        Session_GetSizeInTokens_ResponseParamsSpec.$,
        [
          input
        ],
        false);
  }

  
  /**
   * @param { !string } text
   * @return {!Promise<{
        probability: !number,
   *  }>}
   */

  score(
      text) {
    return this.proxy.sendMessage(
        3,
        Session_Score_ParamsSpec.$,
        Session_Score_ResponseParamsSpec.$,
        [
          text
        ],
        false);
  }

  
  /**
   * @param { !SessionPendingReceiver } session
   */

  clone(
      session) {
    this.proxy.sendMessage(
        4,
        Session_Clone_ParamsSpec.$,
        null,
        [
          session
        ],
        false);
  }

  
  /**
   * @param { !string } text
   * @return {!Promise<{
        probabilities: !Array<!number>,
   *  }>}
   */

  getProbabilitiesBlocking(
      text) {
    return this.proxy.sendMessage(
        8,
        Session_GetProbabilitiesBlocking_ParamsSpec.$,
        Session_GetProbabilitiesBlocking_ResponseParamsSpec.$,
        [
          text
        ],
        false);
  }

  
  /**
   * @param { !Priority } priority
   */

  setPriority(
      priority) {
    this.proxy.sendMessage(
        9,
        Session_SetPriority_ParamsSpec.$,
        null,
        [
          priority
        ],
        false);
  }

  
  /**
   * @param { !AsrStreamOptions } options
   * @param { !AsrStreamInputPendingReceiver } stream
   * @param { !AsrStreamResponderRemote } responder
   */

  asrStream(
      options,
      stream,
      responder) {
    this.proxy.sendMessage(
        10,
        Session_AsrStream_ParamsSpec.$,
        null,
        [
          options,
          stream,
          responder
        ],
        false);
  }
}

/**
 * An object which receives request messages for the Session
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class SessionReceiver {
  /**
   * @param {!SessionInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!SessionRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        SessionRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SessionRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        6,
        Session_Append_ParamsSpec.$,
        null,
        impl.append.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        Session_Generate_ParamsSpec.$,
        null,
        impl.generate.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        Session_GetSizeInTokens_ParamsSpec.$,
        Session_GetSizeInTokens_ResponseParamsSpec.$,
        impl.getSizeInTokens.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        Session_Score_ParamsSpec.$,
        Session_Score_ResponseParamsSpec.$,
        impl.score.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        Session_Clone_ParamsSpec.$,
        null,
        impl.clone.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        Session_GetProbabilitiesBlocking_ParamsSpec.$,
        Session_GetProbabilitiesBlocking_ResponseParamsSpec.$,
        impl.getProbabilitiesBlocking.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        Session_SetPriority_ParamsSpec.$,
        null,
        impl.setPriority.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        Session_AsrStream_ParamsSpec.$,
        null,
        impl.asrStream.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class Session {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "on_device_model.mojom.Session";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!SessionRemote}
   */
  static getRemote() {
    let remote = new SessionRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the Session
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class SessionCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      SessionRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SessionRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.append =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        Session_Append_ParamsSpec.$,
        null,
        this.append.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.generate =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        Session_Generate_ParamsSpec.$,
        null,
        this.generate.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getSizeInTokens =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        Session_GetSizeInTokens_ParamsSpec.$,
        Session_GetSizeInTokens_ResponseParamsSpec.$,
        this.getSizeInTokens.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.score =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        Session_Score_ParamsSpec.$,
        Session_Score_ResponseParamsSpec.$,
        this.score.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clone =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        Session_Clone_ParamsSpec.$,
        null,
        this.clone.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getProbabilitiesBlocking =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        Session_GetProbabilitiesBlocking_ParamsSpec.$,
        Session_GetProbabilitiesBlocking_ResponseParamsSpec.$,
        this.getProbabilitiesBlocking.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setPriority =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        Session_SetPriority_ParamsSpec.$,
        null,
        this.setPriority.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.asrStream =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        Session_AsrStream_ParamsSpec.$,
        null,
        this.asrStream.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class OnDeviceModelPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'on_device_model.mojom.OnDeviceModel', scope);
  }
}

/** @interface */
export class OnDeviceModelInterface {
  
  /**
   * @param { !SessionPendingReceiver } session
   * @param { ?SessionParams } params
   */

  startSession(session, params) {}
  
  /**
   * @param { !string } text
   * @return {!Promise<{
        safetyInfo: ?SafetyInfo,
   *  }>}
   */

  classifyTextSafety(text) {}
  
  /**
   * @param { !string } text
   * @return {!Promise<{
        result: ?LanguageDetectionResult,
   *  }>}
   */

  detectLanguage(text) {}
  
  /**
   * @param { !LoadAdaptationParams } params
   * @param { !OnDeviceModelPendingReceiver } model
   * @return {!Promise<{
        result: !LoadModelResult,
   *  }>}
   */

  loadAdaptation(params, model) {}
}

/**
 * @implements { OnDeviceModelInterface }
 */
export class OnDeviceModelRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!OnDeviceModelPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          OnDeviceModelPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!OnDeviceModelPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !SessionPendingReceiver } session
   * @param { ?SessionParams } params
   */

  startSession(
      session,
      params) {
    this.proxy.sendMessage(
        0,
        OnDeviceModel_StartSession_ParamsSpec.$,
        null,
        [
          session,
          params
        ],
        false);
  }

  
  /**
   * @param { !string } text
   * @return {!Promise<{
        safetyInfo: ?SafetyInfo,
   *  }>}
   */

  classifyTextSafety(
      text) {
    return this.proxy.sendMessage(
        1,
        OnDeviceModel_ClassifyTextSafety_ParamsSpec.$,
        OnDeviceModel_ClassifyTextSafety_ResponseParamsSpec.$,
        [
          text
        ],
        false);
  }

  
  /**
   * @param { !string } text
   * @return {!Promise<{
        result: ?LanguageDetectionResult,
   *  }>}
   */

  detectLanguage(
      text) {
    return this.proxy.sendMessage(
        2,
        OnDeviceModel_DetectLanguage_ParamsSpec.$,
        OnDeviceModel_DetectLanguage_ResponseParamsSpec.$,
        [
          text
        ],
        false);
  }

  
  /**
   * @param { !LoadAdaptationParams } params
   * @param { !OnDeviceModelPendingReceiver } model
   * @return {!Promise<{
        result: !LoadModelResult,
   *  }>}
   */

  loadAdaptation(
      params,
      model) {
    return this.proxy.sendMessage(
        3,
        OnDeviceModel_LoadAdaptation_ParamsSpec.$,
        OnDeviceModel_LoadAdaptation_ResponseParamsSpec.$,
        [
          params,
          model
        ],
        false);
  }
}

/**
 * An object which receives request messages for the OnDeviceModel
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class OnDeviceModelReceiver {
  /**
   * @param {!OnDeviceModelInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!OnDeviceModelRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        OnDeviceModelRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!OnDeviceModelRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        OnDeviceModel_StartSession_ParamsSpec.$,
        null,
        impl.startSession.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        OnDeviceModel_ClassifyTextSafety_ParamsSpec.$,
        OnDeviceModel_ClassifyTextSafety_ResponseParamsSpec.$,
        impl.classifyTextSafety.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        OnDeviceModel_DetectLanguage_ParamsSpec.$,
        OnDeviceModel_DetectLanguage_ResponseParamsSpec.$,
        impl.detectLanguage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        OnDeviceModel_LoadAdaptation_ParamsSpec.$,
        OnDeviceModel_LoadAdaptation_ResponseParamsSpec.$,
        impl.loadAdaptation.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class OnDeviceModel {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "on_device_model.mojom.OnDeviceModel";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!OnDeviceModelRemote}
   */
  static getRemote() {
    let remote = new OnDeviceModelRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the OnDeviceModel
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class OnDeviceModelCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      OnDeviceModelRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!OnDeviceModelRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.startSession =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        OnDeviceModel_StartSession_ParamsSpec.$,
        null,
        this.startSession.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.classifyTextSafety =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        OnDeviceModel_ClassifyTextSafety_ParamsSpec.$,
        OnDeviceModel_ClassifyTextSafety_ResponseParamsSpec.$,
        this.classifyTextSafety.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.detectLanguage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        OnDeviceModel_DetectLanguage_ParamsSpec.$,
        OnDeviceModel_DetectLanguage_ResponseParamsSpec.$,
        this.detectLanguage.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.loadAdaptation =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        OnDeviceModel_LoadAdaptation_ParamsSpec.$,
        OnDeviceModel_LoadAdaptation_ResponseParamsSpec.$,
        this.loadAdaptation.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class TextSafetySessionPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'on_device_model.mojom.TextSafetySession', scope);
  }
}

/** @interface */
export class TextSafetySessionInterface {
  
  /**
   * @param { !string } text
   * @return {!Promise<{
        safetyInfo: ?SafetyInfo,
   *  }>}
   */

  classifyTextSafety(text) {}
  
  /**
   * @param { !string } text
   * @return {!Promise<{
        result: ?LanguageDetectionResult,
   *  }>}
   */

  detectLanguage(text) {}
  
  /**
   * @param { !TextSafetySessionPendingReceiver } session
   */

  clone(session) {}
}

/**
 * @implements { TextSafetySessionInterface }
 */
export class TextSafetySessionRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!TextSafetySessionPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          TextSafetySessionPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!TextSafetySessionPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !string } text
   * @return {!Promise<{
        safetyInfo: ?SafetyInfo,
   *  }>}
   */

  classifyTextSafety(
      text) {
    return this.proxy.sendMessage(
        1,
        TextSafetySession_ClassifyTextSafety_ParamsSpec.$,
        TextSafetySession_ClassifyTextSafety_ResponseParamsSpec.$,
        [
          text
        ],
        false);
  }

  
  /**
   * @param { !string } text
   * @return {!Promise<{
        result: ?LanguageDetectionResult,
   *  }>}
   */

  detectLanguage(
      text) {
    return this.proxy.sendMessage(
        2,
        TextSafetySession_DetectLanguage_ParamsSpec.$,
        TextSafetySession_DetectLanguage_ResponseParamsSpec.$,
        [
          text
        ],
        false);
  }

  
  /**
   * @param { !TextSafetySessionPendingReceiver } session
   */

  clone(
      session) {
    this.proxy.sendMessage(
        3,
        TextSafetySession_Clone_ParamsSpec.$,
        null,
        [
          session
        ],
        false);
  }
}

/**
 * An object which receives request messages for the TextSafetySession
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class TextSafetySessionReceiver {
  /**
   * @param {!TextSafetySessionInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!TextSafetySessionRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        TextSafetySessionRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!TextSafetySessionRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        1,
        TextSafetySession_ClassifyTextSafety_ParamsSpec.$,
        TextSafetySession_ClassifyTextSafety_ResponseParamsSpec.$,
        impl.classifyTextSafety.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        TextSafetySession_DetectLanguage_ParamsSpec.$,
        TextSafetySession_DetectLanguage_ResponseParamsSpec.$,
        impl.detectLanguage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        TextSafetySession_Clone_ParamsSpec.$,
        null,
        impl.clone.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class TextSafetySession {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "on_device_model.mojom.TextSafetySession";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!TextSafetySessionRemote}
   */
  static getRemote() {
    let remote = new TextSafetySessionRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the TextSafetySession
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class TextSafetySessionCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      TextSafetySessionRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!TextSafetySessionRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.classifyTextSafety =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        TextSafetySession_ClassifyTextSafety_ParamsSpec.$,
        TextSafetySession_ClassifyTextSafety_ResponseParamsSpec.$,
        this.classifyTextSafety.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.detectLanguage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        TextSafetySession_DetectLanguage_ParamsSpec.$,
        TextSafetySession_DetectLanguage_ResponseParamsSpec.$,
        this.detectLanguage.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clone =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        TextSafetySession_Clone_ParamsSpec.$,
        null,
        this.clone.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class TextSafetyModelPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'on_device_model.mojom.TextSafetyModel', scope);
  }
}

/** @interface */
export class TextSafetyModelInterface {
  
  /**
   * @param { !TextSafetySessionPendingReceiver } session
   */

  startSession(session) {}
}

/**
 * @implements { TextSafetyModelInterface }
 */
export class TextSafetyModelRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!TextSafetyModelPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          TextSafetyModelPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!TextSafetyModelPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !TextSafetySessionPendingReceiver } session
   */

  startSession(
      session) {
    this.proxy.sendMessage(
        0,
        TextSafetyModel_StartSession_ParamsSpec.$,
        null,
        [
          session
        ],
        false);
  }
}

/**
 * An object which receives request messages for the TextSafetyModel
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class TextSafetyModelReceiver {
  /**
   * @param {!TextSafetyModelInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!TextSafetyModelRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        TextSafetyModelRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!TextSafetyModelRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        TextSafetyModel_StartSession_ParamsSpec.$,
        null,
        impl.startSession.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class TextSafetyModel {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "on_device_model.mojom.TextSafetyModel";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!TextSafetyModelRemote}
   */
  static getRemote() {
    let remote = new TextSafetyModelRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the TextSafetyModel
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class TextSafetyModelCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      TextSafetyModelRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!TextSafetyModelRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.startSession =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        TextSafetyModel_StartSession_ParamsSpec.$,
        null,
        this.startSession.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class AsrStreamResponderPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'on_device_model.mojom.AsrStreamResponder', scope);
  }
}

/** @interface */
export class AsrStreamResponderInterface {
  
  /**
   * @param { !Array<!SpeechRecognitionResult> } result
   */

  onResponse(result) {}
}

/**
 * @implements { AsrStreamResponderInterface }
 */
export class AsrStreamResponderRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!AsrStreamResponderPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          AsrStreamResponderPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!AsrStreamResponderPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Array<!SpeechRecognitionResult> } result
   */

  onResponse(
      result) {
    this.proxy.sendMessage(
        0,
        AsrStreamResponder_OnResponse_ParamsSpec.$,
        null,
        [
          result
        ],
        false);
  }
}

/**
 * An object which receives request messages for the AsrStreamResponder
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AsrStreamResponderReceiver {
  /**
   * @param {!AsrStreamResponderInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!AsrStreamResponderRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        AsrStreamResponderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AsrStreamResponderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        AsrStreamResponder_OnResponse_ParamsSpec.$,
        null,
        impl.onResponse.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class AsrStreamResponder {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "on_device_model.mojom.AsrStreamResponder";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!AsrStreamResponderRemote}
   */
  static getRemote() {
    let remote = new AsrStreamResponderRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the AsrStreamResponder
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AsrStreamResponderCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      AsrStreamResponderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AsrStreamResponderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onResponse =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        AsrStreamResponder_OnResponse_ParamsSpec.$,
        null,
        this.onResponse.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class AsrStreamInputPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'on_device_model.mojom.AsrStreamInput', scope);
  }
}

/** @interface */
export class AsrStreamInputInterface {
  
  /**
   * @param { !AudioData } data
   */

  addAudioChunk(data) {}
}

/**
 * @implements { AsrStreamInputInterface }
 */
export class AsrStreamInputRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!AsrStreamInputPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          AsrStreamInputPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!AsrStreamInputPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !AudioData } data
   */

  addAudioChunk(
      data) {
    this.proxy.sendMessage(
        0,
        AsrStreamInput_AddAudioChunk_ParamsSpec.$,
        null,
        [
          data
        ],
        false);
  }
}

/**
 * An object which receives request messages for the AsrStreamInput
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AsrStreamInputReceiver {
  /**
   * @param {!AsrStreamInputInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!AsrStreamInputRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        AsrStreamInputRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AsrStreamInputRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        AsrStreamInput_AddAudioChunk_ParamsSpec.$,
        null,
        impl.addAudioChunk.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class AsrStreamInput {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "on_device_model.mojom.AsrStreamInput";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!AsrStreamInputRemote}
   */
  static getRemote() {
    let remote = new AsrStreamInputRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the AsrStreamInput
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AsrStreamInputCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      AsrStreamInputRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AsrStreamInputRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addAudioChunk =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        AsrStreamInput_AddAudioChunk_ParamsSpec.$,
        null,
        this.addAudioChunk.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AdaptationAssetsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const LanguageDetectionResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SafetyInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ResponseChunkSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ResponseSummarySpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const LoadAdaptationParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CapabilitiesSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SessionParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InputSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AppendOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const GenerateOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SpeechRecognitionResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AsrStreamOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DevicePerformanceInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DeviceInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const StreamingResponder_OnResponse_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const StreamingResponder_OnComplete_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ContextClient_OnComplete_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Session_Append_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Session_Generate_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Session_GetSizeInTokens_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Session_GetSizeInTokens_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Session_Score_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Session_Score_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Session_Clone_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Session_GetProbabilitiesBlocking_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Session_GetProbabilitiesBlocking_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Session_SetPriority_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Session_AsrStream_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const OnDeviceModel_StartSession_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const OnDeviceModel_ClassifyTextSafety_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const OnDeviceModel_ClassifyTextSafety_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const OnDeviceModel_DetectLanguage_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const OnDeviceModel_DetectLanguage_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const OnDeviceModel_LoadAdaptation_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const OnDeviceModel_LoadAdaptation_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TextSafetySession_ClassifyTextSafety_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TextSafetySession_ClassifyTextSafety_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TextSafetySession_DetectLanguage_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TextSafetySession_DetectLanguage_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TextSafetySession_Clone_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TextSafetyModel_StartSession_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AsrStreamResponder_OnResponse_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AsrStreamInput_AddAudioChunk_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const InputPieceSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const ResponseConstraintSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    AdaptationAssetsSpec.$,
    'AdaptationAssets',
    [
      mojo.internal.StructField(
        'weights', 0,
        0,
        mojoBase_mojom_FileSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'weightsPath', 8,
        0,
        mojoBase_mojom_FilePathSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AdaptationAssets {
  constructor() {
    /** @type { (mojoBase_mojom_File|undefined) } */
    this.weights;
    /** @type { (mojoBase_mojom_FilePath|undefined) } */
    this.weightsPath;
  }
}



mojo.internal.Struct(
    LanguageDetectionResultSpec.$,
    'LanguageDetectionResult',
    [
      mojo.internal.StructField(
        'code', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'reliability', 8,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class LanguageDetectionResult {
  constructor() {
    /** @type { !string } */
    this.code;
    /** @type { !number } */
    this.reliability;
  }
}



mojo.internal.Struct(
    SafetyInfoSpec.$,
    'SafetyInfo',
    [
      mojo.internal.StructField(
        'classScores', 0,
        0,
        mojo.internal.Array(mojo.internal.Float, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'language', 8,
        0,
        LanguageDetectionResultSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class SafetyInfo {
  constructor() {
    /** @type { !Array<!number> } */
    this.classScores;
    /** @type { (LanguageDetectionResult|undefined) } */
    this.language;
  }
}



mojo.internal.Struct(
    ResponseChunkSpec.$,
    'ResponseChunk',
    [
      mojo.internal.StructField(
        'text', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'safetyInfo', 8,
        0,
        SafetyInfoSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class ResponseChunk {
  constructor() {
    /** @type { !string } */
    this.text;
    /** @type { (SafetyInfo|undefined) } */
    this.safetyInfo;
  }
}



mojo.internal.Struct(
    ResponseSummarySpec.$,
    'ResponseSummary',
    [
      mojo.internal.StructField(
        'safetyInfo', 0,
        0,
        SafetyInfoSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'outputTokenCount', 8,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class ResponseSummary {
  constructor() {
    /** @type { (SafetyInfo|undefined) } */
    this.safetyInfo;
    /** @type { !number } */
    this.outputTokenCount;
  }
}



mojo.internal.Struct(
    LoadAdaptationParamsSpec.$,
    'LoadAdaptationParams',
    [
      mojo.internal.StructField(
        'assets', 0,
        0,
        AdaptationAssetsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class LoadAdaptationParams {
  constructor() {
    /** @type { !AdaptationAssets } */
    this.assets;
  }
}



mojo.internal.Struct(
    CapabilitiesSpec.$,
    'Capabilities',
    [
      mojo.internal.StructField(
        'imageInput', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'audioInput', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Capabilities {
  constructor() {
    /** @type { !boolean } */
    this.imageInput;
    /** @type { !boolean } */
    this.audioInput;
  }
}



mojo.internal.Struct(
    SessionParamsSpec.$,
    'SessionParams',
    [
      mojo.internal.StructField(
        'maxTokens', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'capabilities', 8,
        0,
        CapabilitiesSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'topK', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        1,
      ),
      mojo.internal.StructField(
        'temperature', 16,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        1,
      ),
    ],
    [[0, 24],[1, 32],]);



/**
 * @record
 */
export class SessionParams {
  constructor() {
    /** @type { !number } */
    this.maxTokens;
    /** @type { !Capabilities } */
    this.capabilities;
    /** @type { !number } */
    this.topK;
    /** @type { !number } */
    this.temperature;
  }
}



mojo.internal.Struct(
    InputSpec.$,
    'Input',
    [
      mojo.internal.StructField(
        'pieces', 0,
        0,
        mojo.internal.Array(InputPieceSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Input {
  constructor() {
    /** @type { !Array<!InputPiece> } */
    this.pieces;
  }
}



mojo.internal.Struct(
    AppendOptionsSpec.$,
    'AppendOptions',
    [
      mojo.internal.StructField(
        'input', 0,
        0,
        InputSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxTokens', 8,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AppendOptions {
  constructor() {
    /** @type { !Input } */
    this.input;
    /** @type { !number } */
    this.maxTokens;
  }
}



mojo.internal.Struct(
    GenerateOptionsSpec.$,
    'GenerateOptions',
    [
      mojo.internal.StructField(
        'maxOutputTokens', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'constraint', 8,
        0,
        ResponseConstraintSpec.$,
        null,
        true /* nullable */,
        2,
      ),
    ],
    [[0, 16],[2, 32],]);



/**
 * @record
 */
export class GenerateOptions {
  constructor() {
    /** @type { !number } */
    this.maxOutputTokens;
    /** @type { (ResponseConstraint|undefined) } */
    this.constraint;
  }
}



mojo.internal.Struct(
    AudioDataSpec.$,
    'AudioData',
    [
      mojo.internal.StructField(
        'channelCount', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sampleRate', 4,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'frameCount', 8,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'data', 16,
        0,
        mojo.internal.Array(mojo.internal.Float, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class AudioData {
  constructor() {
    /** @type { !number } */
    this.channelCount;
    /** @type { !number } */
    this.sampleRate;
    /** @type { !number } */
    this.frameCount;
    /** @type { !Array<!number> } */
    this.data;
  }
}



mojo.internal.Struct(
    SpeechRecognitionResultSpec.$,
    'SpeechRecognitionResult',
    [
      mojo.internal.StructField(
        'transcript', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isFinal', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class SpeechRecognitionResult {
  constructor() {
    /** @type { !string } */
    this.transcript;
    /** @type { !boolean } */
    this.isFinal;
  }
}



mojo.internal.Struct(
    AsrStreamOptionsSpec.$,
    'AsrStreamOptions',
    [
      mojo.internal.StructField(
        'sampleRateHz', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AsrStreamOptions {
  constructor() {
    /** @type { !number } */
    this.sampleRateHz;
  }
}



mojo.internal.Struct(
    DevicePerformanceInfoSpec.$,
    'DevicePerformanceInfo',
    [
      mojo.internal.StructField(
        'performanceClass', 0,
        0,
        PerformanceClassSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'vramMb', 8,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class DevicePerformanceInfo {
  constructor() {
    /** @type { !PerformanceClass } */
    this.performanceClass;
    /** @type { !bigint } */
    this.vramMb;
  }
}



mojo.internal.Struct(
    DeviceInfoSpec.$,
    'DeviceInfo',
    [
      mojo.internal.StructField(
        'vendorId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'deviceId', 4,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'driverVersion', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'supportsFp16', 16,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class DeviceInfo {
  constructor() {
    /** @type { !number } */
    this.vendorId;
    /** @type { !number } */
    this.deviceId;
    /** @type { !string } */
    this.driverVersion;
    /** @type { !boolean } */
    this.supportsFp16;
  }
}



mojo.internal.Struct(
    StreamingResponder_OnResponse_ParamsSpec.$,
    'StreamingResponder_OnResponse_Params',
    [
      mojo.internal.StructField(
        'chunk', 0,
        0,
        ResponseChunkSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class StreamingResponder_OnResponse_Params {
  constructor() {
    /** @type { !ResponseChunk } */
    this.chunk;
  }
}



mojo.internal.Struct(
    StreamingResponder_OnComplete_ParamsSpec.$,
    'StreamingResponder_OnComplete_Params',
    [
      mojo.internal.StructField(
        'summary', 0,
        0,
        ResponseSummarySpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class StreamingResponder_OnComplete_Params {
  constructor() {
    /** @type { !ResponseSummary } */
    this.summary;
  }
}



mojo.internal.Struct(
    ContextClient_OnComplete_ParamsSpec.$,
    'ContextClient_OnComplete_Params',
    [
      mojo.internal.StructField(
        'tokensProcessed', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ContextClient_OnComplete_Params {
  constructor() {
    /** @type { !number } */
    this.tokensProcessed;
  }
}



mojo.internal.Struct(
    Session_Append_ParamsSpec.$,
    'Session_Append_Params',
    [
      mojo.internal.StructField(
        'options', 0,
        0,
        AppendOptionsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'client', 8,
        0,
        mojo.internal.InterfaceProxy(ContextClientRemote),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class Session_Append_Params {
  constructor() {
    /** @type { !AppendOptions } */
    this.options;
    /** @type { (ContextClientRemote|undefined) } */
    this.client;
  }
}



mojo.internal.Struct(
    Session_Generate_ParamsSpec.$,
    'Session_Generate_Params',
    [
      mojo.internal.StructField(
        'options', 0,
        0,
        GenerateOptionsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'responder', 8,
        0,
        mojo.internal.InterfaceProxy(StreamingResponderRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class Session_Generate_Params {
  constructor() {
    /** @type { !GenerateOptions } */
    this.options;
    /** @type { !StreamingResponderRemote } */
    this.responder;
  }
}



mojo.internal.Struct(
    Session_GetSizeInTokens_ParamsSpec.$,
    'Session_GetSizeInTokens_Params',
    [
      mojo.internal.StructField(
        'input', 0,
        0,
        InputSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Session_GetSizeInTokens_Params {
  constructor() {
    /** @type { !Input } */
    this.input;
  }
}



mojo.internal.Struct(
    Session_GetSizeInTokens_ResponseParamsSpec.$,
    'Session_GetSizeInTokens_ResponseParams',
    [
      mojo.internal.StructField(
        'size', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Session_GetSizeInTokens_ResponseParams {
  constructor() {
    /** @type { !number } */
    this.size;
  }
}



mojo.internal.Struct(
    Session_Score_ParamsSpec.$,
    'Session_Score_Params',
    [
      mojo.internal.StructField(
        'text', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Session_Score_Params {
  constructor() {
    /** @type { !string } */
    this.text;
  }
}



mojo.internal.Struct(
    Session_Score_ResponseParamsSpec.$,
    'Session_Score_ResponseParams',
    [
      mojo.internal.StructField(
        'probability', 0,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Session_Score_ResponseParams {
  constructor() {
    /** @type { !number } */
    this.probability;
  }
}



mojo.internal.Struct(
    Session_Clone_ParamsSpec.$,
    'Session_Clone_Params',
    [
      mojo.internal.StructField(
        'session', 0,
        0,
        mojo.internal.InterfaceRequest(SessionPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Session_Clone_Params {
  constructor() {
    /** @type { !SessionPendingReceiver } */
    this.session;
  }
}



mojo.internal.Struct(
    Session_GetProbabilitiesBlocking_ParamsSpec.$,
    'Session_GetProbabilitiesBlocking_Params',
    [
      mojo.internal.StructField(
        'text', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Session_GetProbabilitiesBlocking_Params {
  constructor() {
    /** @type { !string } */
    this.text;
  }
}



mojo.internal.Struct(
    Session_GetProbabilitiesBlocking_ResponseParamsSpec.$,
    'Session_GetProbabilitiesBlocking_ResponseParams',
    [
      mojo.internal.StructField(
        'probabilities', 0,
        0,
        mojo.internal.Array(mojo.internal.Float, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Session_GetProbabilitiesBlocking_ResponseParams {
  constructor() {
    /** @type { !Array<!number> } */
    this.probabilities;
  }
}



mojo.internal.Struct(
    Session_SetPriority_ParamsSpec.$,
    'Session_SetPriority_Params',
    [
      mojo.internal.StructField(
        'priority', 0,
        0,
        PrioritySpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Session_SetPriority_Params {
  constructor() {
    /** @type { !Priority } */
    this.priority;
  }
}



mojo.internal.Struct(
    Session_AsrStream_ParamsSpec.$,
    'Session_AsrStream_Params',
    [
      mojo.internal.StructField(
        'options', 0,
        0,
        AsrStreamOptionsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'stream', 8,
        0,
        mojo.internal.InterfaceRequest(AsrStreamInputPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'responder', 12,
        0,
        mojo.internal.InterfaceProxy(AsrStreamResponderRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class Session_AsrStream_Params {
  constructor() {
    /** @type { !AsrStreamOptions } */
    this.options;
    /** @type { !AsrStreamInputPendingReceiver } */
    this.stream;
    /** @type { !AsrStreamResponderRemote } */
    this.responder;
  }
}



mojo.internal.Struct(
    OnDeviceModel_StartSession_ParamsSpec.$,
    'OnDeviceModel_StartSession_Params',
    [
      mojo.internal.StructField(
        'session', 0,
        0,
        mojo.internal.InterfaceRequest(SessionPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'params', 8,
        0,
        SessionParamsSpec.$,
        null,
        true /* nullable */,
        1,
      ),
    ],
    [[0, 16],[1, 24],]);



/**
 * @record
 */
export class OnDeviceModel_StartSession_Params {
  constructor() {
    /** @type { !SessionPendingReceiver } */
    this.session;
    /** @type { (SessionParams|undefined) } */
    this.params;
  }
}



mojo.internal.Struct(
    OnDeviceModel_ClassifyTextSafety_ParamsSpec.$,
    'OnDeviceModel_ClassifyTextSafety_Params',
    [
      mojo.internal.StructField(
        'text', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class OnDeviceModel_ClassifyTextSafety_Params {
  constructor() {
    /** @type { !string } */
    this.text;
  }
}



mojo.internal.Struct(
    OnDeviceModel_ClassifyTextSafety_ResponseParamsSpec.$,
    'OnDeviceModel_ClassifyTextSafety_ResponseParams',
    [
      mojo.internal.StructField(
        'safetyInfo', 0,
        0,
        SafetyInfoSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class OnDeviceModel_ClassifyTextSafety_ResponseParams {
  constructor() {
    /** @type { (SafetyInfo|undefined) } */
    this.safetyInfo;
  }
}



mojo.internal.Struct(
    OnDeviceModel_DetectLanguage_ParamsSpec.$,
    'OnDeviceModel_DetectLanguage_Params',
    [
      mojo.internal.StructField(
        'text', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class OnDeviceModel_DetectLanguage_Params {
  constructor() {
    /** @type { !string } */
    this.text;
  }
}



mojo.internal.Struct(
    OnDeviceModel_DetectLanguage_ResponseParamsSpec.$,
    'OnDeviceModel_DetectLanguage_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        LanguageDetectionResultSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class OnDeviceModel_DetectLanguage_ResponseParams {
  constructor() {
    /** @type { (LanguageDetectionResult|undefined) } */
    this.result;
  }
}



mojo.internal.Struct(
    OnDeviceModel_LoadAdaptation_ParamsSpec.$,
    'OnDeviceModel_LoadAdaptation_Params',
    [
      mojo.internal.StructField(
        'params', 0,
        0,
        LoadAdaptationParamsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'model', 8,
        0,
        mojo.internal.InterfaceRequest(OnDeviceModelPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class OnDeviceModel_LoadAdaptation_Params {
  constructor() {
    /** @type { !LoadAdaptationParams } */
    this.params;
    /** @type { !OnDeviceModelPendingReceiver } */
    this.model;
  }
}



mojo.internal.Struct(
    OnDeviceModel_LoadAdaptation_ResponseParamsSpec.$,
    'OnDeviceModel_LoadAdaptation_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        LoadModelResultSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class OnDeviceModel_LoadAdaptation_ResponseParams {
  constructor() {
    /** @type { !LoadModelResult } */
    this.result;
  }
}



mojo.internal.Struct(
    TextSafetySession_ClassifyTextSafety_ParamsSpec.$,
    'TextSafetySession_ClassifyTextSafety_Params',
    [
      mojo.internal.StructField(
        'text', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class TextSafetySession_ClassifyTextSafety_Params {
  constructor() {
    /** @type { !string } */
    this.text;
  }
}



mojo.internal.Struct(
    TextSafetySession_ClassifyTextSafety_ResponseParamsSpec.$,
    'TextSafetySession_ClassifyTextSafety_ResponseParams',
    [
      mojo.internal.StructField(
        'safetyInfo', 0,
        0,
        SafetyInfoSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class TextSafetySession_ClassifyTextSafety_ResponseParams {
  constructor() {
    /** @type { (SafetyInfo|undefined) } */
    this.safetyInfo;
  }
}



mojo.internal.Struct(
    TextSafetySession_DetectLanguage_ParamsSpec.$,
    'TextSafetySession_DetectLanguage_Params',
    [
      mojo.internal.StructField(
        'text', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class TextSafetySession_DetectLanguage_Params {
  constructor() {
    /** @type { !string } */
    this.text;
  }
}



mojo.internal.Struct(
    TextSafetySession_DetectLanguage_ResponseParamsSpec.$,
    'TextSafetySession_DetectLanguage_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        LanguageDetectionResultSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class TextSafetySession_DetectLanguage_ResponseParams {
  constructor() {
    /** @type { (LanguageDetectionResult|undefined) } */
    this.result;
  }
}



mojo.internal.Struct(
    TextSafetySession_Clone_ParamsSpec.$,
    'TextSafetySession_Clone_Params',
    [
      mojo.internal.StructField(
        'session', 0,
        0,
        mojo.internal.InterfaceRequest(TextSafetySessionPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class TextSafetySession_Clone_Params {
  constructor() {
    /** @type { !TextSafetySessionPendingReceiver } */
    this.session;
  }
}



mojo.internal.Struct(
    TextSafetyModel_StartSession_ParamsSpec.$,
    'TextSafetyModel_StartSession_Params',
    [
      mojo.internal.StructField(
        'session', 0,
        0,
        mojo.internal.InterfaceRequest(TextSafetySessionPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class TextSafetyModel_StartSession_Params {
  constructor() {
    /** @type { !TextSafetySessionPendingReceiver } */
    this.session;
  }
}



mojo.internal.Struct(
    AsrStreamResponder_OnResponse_ParamsSpec.$,
    'AsrStreamResponder_OnResponse_Params',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Array(SpeechRecognitionResultSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AsrStreamResponder_OnResponse_Params {
  constructor() {
    /** @type { !Array<!SpeechRecognitionResult> } */
    this.result;
  }
}



mojo.internal.Struct(
    AsrStreamInput_AddAudioChunk_ParamsSpec.$,
    'AsrStreamInput_AddAudioChunk_Params',
    [
      mojo.internal.StructField(
        'data', 0,
        0,
        AudioDataSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AsrStreamInput_AddAudioChunk_Params {
  constructor() {
    /** @type { !AudioData } */
    this.data;
  }
}

mojo.internal.Union(
    InputPieceSpec.$, 'InputPiece',
    {
      'token': {
        'ordinal': 0,
        'type': TokenSpec.$,
      },
      'text': {
        'ordinal': 1,
        'type': mojo.internal.String,
      },
      'bitmap': {
        'ordinal': 2,
        'type': skia_mojom_BitmapWithArbitraryBppSpec.$,
      },
      'unknownType': {
        'ordinal': 3,
        'type': mojo.internal.Bool,
      },
      'audio': {
        'ordinal': 4,
        'type': AudioDataSpec.$,
      },
    });

/**
 * @typedef { {
 *   token: (!Token|undefined),
 *   text: (!string|undefined),
 *   bitmap: (!skia_mojom_BitmapWithArbitraryBpp|undefined),
 *   unknownType: (!boolean|undefined),
 *   audio: (!AudioData|undefined),
 * } }
 */
export const InputPiece = {};
mojo.internal.Union(
    ResponseConstraintSpec.$, 'ResponseConstraint',
    {
      'jsonSchema': {
        'ordinal': 0,
        'type': mojo.internal.String,
      },
      'regex': {
        'ordinal': 1,
        'type': mojo.internal.String,
      },
      'unknownType': {
        'ordinal': 2,
        'type': mojo.internal.Bool,
      },
    });

/**
 * @typedef { {
 *   jsonSchema: (!string|undefined),
 *   regex: (!string|undefined),
 *   unknownType: (!boolean|undefined),
 * } }
 */
export const ResponseConstraint = {};
