// services/service_manager/public/mojom/service_manager.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';

import {
  Identity as serviceManager_mojom_Identity,
  IdentitySpec as serviceManager_mojom_IdentitySpec
} from './connector.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const InstanceStateSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const InstanceState = {
  
  kCreated: 0,
  kStarted: 1,
  kUnreachable: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class ServiceManagerListenerPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'service_manager.mojom.ServiceManagerListener', scope);
  }
}

/** @interface */
export class ServiceManagerListenerInterface {
  
  /**
   * @param { !Array<!RunningServiceInfo> } runningServices
   */

  onInit(runningServices) {}
  
  /**
   * @param { !RunningServiceInfo } service
   */

  onServiceCreated(service) {}
  
  /**
   * @param { !serviceManager_mojom_Identity } identity
   * @param { !number } pidDeprecated
   */

  onServiceStarted(identity, pidDeprecated) {}
  
  /**
   * @param { !serviceManager_mojom_Identity } identity
   * @param { !number } pid
   */

  onServicePIDReceived(identity, pid) {}
  
  /**
   * @param { !serviceManager_mojom_Identity } identity
   */

  onServiceFailedToStart(identity) {}
  
  /**
   * @param { !serviceManager_mojom_Identity } identity
   */

  onServiceStopped(identity) {}
}

/**
 * @implements { ServiceManagerListenerInterface }
 */
export class ServiceManagerListenerRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ServiceManagerListenerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ServiceManagerListenerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ServiceManagerListenerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Array<!RunningServiceInfo> } runningServices
   */

  onInit(
      runningServices) {
    this.proxy.sendMessage(
        0,
        ServiceManagerListener_OnInit_ParamsSpec.$,
        null,
        [
          runningServices
        ],
        false);
  }

  
  /**
   * @param { !RunningServiceInfo } service
   */

  onServiceCreated(
      service) {
    this.proxy.sendMessage(
        1,
        ServiceManagerListener_OnServiceCreated_ParamsSpec.$,
        null,
        [
          service
        ],
        false);
  }

  
  /**
   * @param { !serviceManager_mojom_Identity } identity
   * @param { !number } pidDeprecated
   */

  onServiceStarted(
      identity,
      pidDeprecated) {
    this.proxy.sendMessage(
        2,
        ServiceManagerListener_OnServiceStarted_ParamsSpec.$,
        null,
        [
          identity,
          pidDeprecated
        ],
        false);
  }

  
  /**
   * @param { !serviceManager_mojom_Identity } identity
   * @param { !number } pid
   */

  onServicePIDReceived(
      identity,
      pid) {
    this.proxy.sendMessage(
        3,
        ServiceManagerListener_OnServicePIDReceived_ParamsSpec.$,
        null,
        [
          identity,
          pid
        ],
        false);
  }

  
  /**
   * @param { !serviceManager_mojom_Identity } identity
   */

  onServiceFailedToStart(
      identity) {
    this.proxy.sendMessage(
        4,
        ServiceManagerListener_OnServiceFailedToStart_ParamsSpec.$,
        null,
        [
          identity
        ],
        false);
  }

  
  /**
   * @param { !serviceManager_mojom_Identity } identity
   */

  onServiceStopped(
      identity) {
    this.proxy.sendMessage(
        5,
        ServiceManagerListener_OnServiceStopped_ParamsSpec.$,
        null,
        [
          identity
        ],
        false);
  }
}

/**
 * An object which receives request messages for the ServiceManagerListener
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ServiceManagerListenerReceiver {
  /**
   * @param {!ServiceManagerListenerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ServiceManagerListenerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ServiceManagerListenerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ServiceManagerListenerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ServiceManagerListener_OnInit_ParamsSpec.$,
        null,
        impl.onInit.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        ServiceManagerListener_OnServiceCreated_ParamsSpec.$,
        null,
        impl.onServiceCreated.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        ServiceManagerListener_OnServiceStarted_ParamsSpec.$,
        null,
        impl.onServiceStarted.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        ServiceManagerListener_OnServicePIDReceived_ParamsSpec.$,
        null,
        impl.onServicePIDReceived.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        ServiceManagerListener_OnServiceFailedToStart_ParamsSpec.$,
        null,
        impl.onServiceFailedToStart.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        ServiceManagerListener_OnServiceStopped_ParamsSpec.$,
        null,
        impl.onServiceStopped.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class ServiceManagerListener {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "service_manager.mojom.ServiceManagerListener";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ServiceManagerListenerRemote}
   */
  static getRemote() {
    let remote = new ServiceManagerListenerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the ServiceManagerListener
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ServiceManagerListenerCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ServiceManagerListenerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ServiceManagerListenerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onInit =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ServiceManagerListener_OnInit_ParamsSpec.$,
        null,
        this.onInit.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onServiceCreated =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        ServiceManagerListener_OnServiceCreated_ParamsSpec.$,
        null,
        this.onServiceCreated.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onServiceStarted =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        ServiceManagerListener_OnServiceStarted_ParamsSpec.$,
        null,
        this.onServiceStarted.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onServicePIDReceived =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        ServiceManagerListener_OnServicePIDReceived_ParamsSpec.$,
        null,
        this.onServicePIDReceived.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onServiceFailedToStart =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        ServiceManagerListener_OnServiceFailedToStart_ParamsSpec.$,
        null,
        this.onServiceFailedToStart.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onServiceStopped =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        ServiceManagerListener_OnServiceStopped_ParamsSpec.$,
        null,
        this.onServiceStopped.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class ServiceManagerPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'service_manager.mojom.ServiceManager', scope);
  }
}

/** @interface */
export class ServiceManagerInterface {
  
  /**
   * @param { !ServiceManagerListenerRemote } listener
   */

  addListener(listener) {}
}

/**
 * @implements { ServiceManagerInterface }
 */
export class ServiceManagerRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ServiceManagerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ServiceManagerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ServiceManagerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !ServiceManagerListenerRemote } listener
   */

  addListener(
      listener) {
    this.proxy.sendMessage(
        0,
        ServiceManager_AddListener_ParamsSpec.$,
        null,
        [
          listener
        ],
        false);
  }
}

/**
 * An object which receives request messages for the ServiceManager
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ServiceManagerReceiver {
  /**
   * @param {!ServiceManagerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ServiceManagerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ServiceManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ServiceManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ServiceManager_AddListener_ParamsSpec.$,
        null,
        impl.addListener.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class ServiceManager {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "service_manager.mojom.ServiceManager";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ServiceManagerRemote}
   */
  static getRemote() {
    let remote = new ServiceManagerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the ServiceManager
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ServiceManagerCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ServiceManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ServiceManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addListener =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ServiceManager_AddListener_ParamsSpec.$,
        null,
        this.addListener.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RunningServiceInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceManagerListener_OnInit_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceManagerListener_OnServiceCreated_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceManagerListener_OnServiceStarted_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceManagerListener_OnServicePIDReceived_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceManagerListener_OnServiceFailedToStart_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceManagerListener_OnServiceStopped_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceManager_AddListener_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    RunningServiceInfoSpec.$,
    'RunningServiceInfo',
    [
      mojo.internal.StructField(
        'identity', 0,
        0,
        serviceManager_mojom_IdentitySpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'pid', 8,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'state', 12,
        0,
        InstanceStateSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class RunningServiceInfo {
  constructor() {
    /** @type { !serviceManager_mojom_Identity } */
    this.identity;
    /** @type { !number } */
    this.pid;
    /** @type { !InstanceState } */
    this.state;
  }
}



mojo.internal.Struct(
    ServiceManagerListener_OnInit_ParamsSpec.$,
    'ServiceManagerListener_OnInit_Params',
    [
      mojo.internal.StructField(
        'runningServices', 0,
        0,
        mojo.internal.Array(RunningServiceInfoSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ServiceManagerListener_OnInit_Params {
  constructor() {
    /** @type { !Array<!RunningServiceInfo> } */
    this.runningServices;
  }
}



mojo.internal.Struct(
    ServiceManagerListener_OnServiceCreated_ParamsSpec.$,
    'ServiceManagerListener_OnServiceCreated_Params',
    [
      mojo.internal.StructField(
        'service', 0,
        0,
        RunningServiceInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ServiceManagerListener_OnServiceCreated_Params {
  constructor() {
    /** @type { !RunningServiceInfo } */
    this.service;
  }
}



mojo.internal.Struct(
    ServiceManagerListener_OnServiceStarted_ParamsSpec.$,
    'ServiceManagerListener_OnServiceStarted_Params',
    [
      mojo.internal.StructField(
        'identity', 0,
        0,
        serviceManager_mojom_IdentitySpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'pidDeprecated', 8,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class ServiceManagerListener_OnServiceStarted_Params {
  constructor() {
    /** @type { !serviceManager_mojom_Identity } */
    this.identity;
    /** @type { !number } */
    this.pidDeprecated;
  }
}



mojo.internal.Struct(
    ServiceManagerListener_OnServicePIDReceived_ParamsSpec.$,
    'ServiceManagerListener_OnServicePIDReceived_Params',
    [
      mojo.internal.StructField(
        'identity', 0,
        0,
        serviceManager_mojom_IdentitySpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'pid', 8,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class ServiceManagerListener_OnServicePIDReceived_Params {
  constructor() {
    /** @type { !serviceManager_mojom_Identity } */
    this.identity;
    /** @type { !number } */
    this.pid;
  }
}



mojo.internal.Struct(
    ServiceManagerListener_OnServiceFailedToStart_ParamsSpec.$,
    'ServiceManagerListener_OnServiceFailedToStart_Params',
    [
      mojo.internal.StructField(
        'identity', 0,
        0,
        serviceManager_mojom_IdentitySpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ServiceManagerListener_OnServiceFailedToStart_Params {
  constructor() {
    /** @type { !serviceManager_mojom_Identity } */
    this.identity;
  }
}



mojo.internal.Struct(
    ServiceManagerListener_OnServiceStopped_ParamsSpec.$,
    'ServiceManagerListener_OnServiceStopped_Params',
    [
      mojo.internal.StructField(
        'identity', 0,
        0,
        serviceManager_mojom_IdentitySpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ServiceManagerListener_OnServiceStopped_Params {
  constructor() {
    /** @type { !serviceManager_mojom_Identity } */
    this.identity;
  }
}



mojo.internal.Struct(
    ServiceManager_AddListener_ParamsSpec.$,
    'ServiceManager_AddListener_Params',
    [
      mojo.internal.StructField(
        'listener', 0,
        0,
        mojo.internal.InterfaceProxy(ServiceManagerListenerRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ServiceManager_AddListener_Params {
  constructor() {
    /** @type { !ServiceManagerListenerRemote } */
    this.listener;
  }
}

