// services/viz/public/mojom/compositing/layer_context.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('viz.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
viz.mojom.LayerContextPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        viz.mojom.LayerContext.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { viz.mojom.LayerContextInterface }
 */
viz.mojom.LayerContextRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!viz.mojom.LayerContextPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          viz.mojom.LayerContextPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!viz.mojom.LayerContextPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !boolean } visible
   */

  setVisible(
      visible) {
    this.proxy.sendMessage(
        0,
        viz.mojom.LayerContext_SetVisible_ParamsSpec.$,
        null,
        [
          visible
        ],
        false);
  }

  
  /**
   * @param { !viz.mojom.LayerTreeUpdate } update
   */

  updateDisplayTree(
      update) {
    this.proxy.sendMessage(
        1,
        viz.mojom.LayerContext_UpdateDisplayTree_ParamsSpec.$,
        null,
        [
          update
        ],
        false);
  }

  
  /**
   * @param { !viz.mojom.Tiling } tiling
   * @param { !boolean } updateDamage
   */

  updateDisplayTiling(
      tiling,
      updateDamage) {
    this.proxy.sendMessage(
        2,
        viz.mojom.LayerContext_UpdateDisplayTiling_ParamsSpec.$,
        null,
        [
          tiling,
          updateDamage
        ],
        false);
  }
};

/**
 * An object which receives request messages for the LayerContext
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
viz.mojom.LayerContextReceiver = class {
  /**
   * @param {!viz.mojom.LayerContextInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!viz.mojom.LayerContextRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        viz.mojom.LayerContextRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!viz.mojom.LayerContextRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        viz.mojom.LayerContext_SetVisible_ParamsSpec.$,
        null,
        impl.setVisible.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        viz.mojom.LayerContext_UpdateDisplayTree_ParamsSpec.$,
        null,
        impl.updateDisplayTree.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        viz.mojom.LayerContext_UpdateDisplayTiling_ParamsSpec.$,
        null,
        impl.updateDisplayTiling.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
viz.mojom.LayerContext = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "viz.mojom.LayerContext";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!viz.mojom.LayerContextRemote}
   * @export
   */
  static getRemote() {
    let remote = new viz.mojom.LayerContextRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the LayerContext
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
viz.mojom.LayerContextCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      viz.mojom.LayerContextRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!viz.mojom.LayerContextRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setVisible =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        viz.mojom.LayerContext_SetVisible_ParamsSpec.$,
        null,
        this.setVisible.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateDisplayTree =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        viz.mojom.LayerContext_UpdateDisplayTree_ParamsSpec.$,
        null,
        this.updateDisplayTree.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateDisplayTiling =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        viz.mojom.LayerContext_UpdateDisplayTiling_ParamsSpec.$,
        null,
        this.updateDisplayTiling.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
viz.mojom.LayerContextClientPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        viz.mojom.LayerContextClient.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { viz.mojom.LayerContextClientInterface }
 */
viz.mojom.LayerContextClientRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!viz.mojom.LayerContextClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          viz.mojom.LayerContextClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!viz.mojom.LayerContextClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !viz.mojom.BeginFrameArgs } args
   */

  onRequestCommitForFrame(
      args) {
    this.proxy.sendMessage(
        0,
        viz.mojom.LayerContextClient_OnRequestCommitForFrame_ParamsSpec.$,
        null,
        [
          args
        ],
        false);
  }
};

/**
 * An object which receives request messages for the LayerContextClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
viz.mojom.LayerContextClientReceiver = class {
  /**
   * @param {!viz.mojom.LayerContextClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!viz.mojom.LayerContextClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        viz.mojom.LayerContextClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!viz.mojom.LayerContextClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        viz.mojom.LayerContextClient_OnRequestCommitForFrame_ParamsSpec.$,
        null,
        impl.onRequestCommitForFrame.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
viz.mojom.LayerContextClient = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "viz.mojom.LayerContextClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!viz.mojom.LayerContextClientRemote}
   * @export
   */
  static getRemote() {
    let remote = new viz.mojom.LayerContextClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the LayerContextClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
viz.mojom.LayerContextClientCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      viz.mojom.LayerContextClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!viz.mojom.LayerContextClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onRequestCommitForFrame =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        viz.mojom.LayerContextClient_OnRequestCommitForFrame_ParamsSpec.$,
        null,
        this.onRequestCommitForFrame.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
viz.mojom.TransferableUIResourceRequestSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
viz.mojom.LayerTreeUpdateSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
viz.mojom.PendingLayerContextSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
viz.mojom.LayerContext_SetVisible_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
viz.mojom.LayerContext_UpdateDisplayTree_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
viz.mojom.LayerContext_UpdateDisplayTiling_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
viz.mojom.LayerContextClient_OnRequestCommitForFrame_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
viz.mojom.TransferableUIResourceRequestSpec.TypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
viz.mojom.TransferableUIResourceRequest_Type = {
  
  kCreate: 0,
  kDelete: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};


mojo.internal.Struct(
    viz.mojom.TransferableUIResourceRequestSpec.$,
    'TransferableUIResourceRequest',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        viz.mojom.TransferableUIResourceRequestSpec.TypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'uid', 8,
        0,
        cc.mojom.UIResourceIdSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'transferableResource', 16,
        0,
        viz.mojom.TransferableResourceSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'opaque', 4,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
viz.mojom.TransferableUIResourceRequest = class {
  constructor() {
    /** @export { !viz.mojom.TransferableUIResourceRequest_Type } */
    this.type;
    /** @export { !cc.mojom.UIResourceId } */
    this.uid;
    /** @export { (viz.mojom.TransferableResource|undefined) } */
    this.transferableResource;
    /** @export { !boolean } */
    this.opaque;
  }
};



mojo.internal.Struct(
    viz.mojom.LayerTreeUpdateSpec.$,
    'LayerTreeUpdate',
    [
      mojo.internal.StructField(
        'beginFrameArgs', 0,
        0,
        viz.mojom.BeginFrameArgsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sourceFrameNumber', 8,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'traceId', 16,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'primaryMainFrameItemSequenceNumber', 24,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'selection', 32,
        0,
        cc.mojom.LayerSelectionSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'pageScaleFactor', 12,
        0,
        mojo.internal.Float,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'minPageScaleFactor', 40,
        0,
        mojo.internal.Float,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'maxPageScaleFactor', 44,
        0,
        mojo.internal.Float,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'externalPageScaleFactor', 48,
        0,
        mojo.internal.Float,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'deviceViewport', 56,
        0,
        gfx.mojom.RectSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'deviceScaleFactor', 52,
        0,
        mojo.internal.Float,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'paintedDeviceScaleFactor', 64,
        0,
        mojo.internal.Float,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'displayColorSpaces', 72,
        0,
        gfx.mojom.DisplayColorSpacesSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'localSurfaceIdFromParent', 80,
        0,
        viz.mojom.LocalSurfaceIdSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'currentLocalSurfaceId', 88,
        0,
        viz.mojom.LocalSurfaceIdSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'nextFrameToken', 68,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sendFrameTokenToEmbedder', 96,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'targetLocalSurfaceId', 104,
        0,
        viz.mojom.LocalSurfaceIdSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'backgroundColor', 112,
        0,
        skia.mojom.SkColor4fSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'overscrollElasticityTransform', 100,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'pageScaleTransform', 120,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'innerScroll', 124,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'outerClip', 128,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'outerScroll', 132,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'viewportDamageRect', 136,
        0,
        gfx.mojom.RectSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'fullTreeDamaged', 96,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'debugState', 144,
        0,
        cc.mojom.LayerTreeDebugStateSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'displayTransformHint', 152,
        0,
        gfx.mojom.OverlayTransformSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'maxSafeAreaInsetBottom', 156,
        0,
        mojo.internal.Float,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'browserControlsParams', 160,
        0,
        cc.mojom.BrowserControlsParamsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'browserControlsOffsetTagModifications', 168,
        0,
        cc.mojom.BrowserControlsOffsetTagModificationsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'topControlsShownRatio', 176,
        0,
        mojo.internal.Float,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'bottomControlsShownRatio', 180,
        0,
        mojo.internal.Float,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'uiResourceRequests', 184,
        0,
        mojo.internal.Array(viz.mojom.TransferableUIResourceRequestSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'layers', 192,
        0,
        mojo.internal.Array(viz.mojom.LayerSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'layerOrder', 200,
        0,
        mojo.internal.Array(mojo.internal.Int32, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'transformTreeUpdate', 208,
        0,
        viz.mojom.TransformTreeUpdateSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'scrollTreeUpdate', 216,
        0,
        viz.mojom.ScrollTreeUpdateSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'transformNodes', 224,
        0,
        mojo.internal.Array(viz.mojom.TransformNodeSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'clipNodes', 232,
        0,
        mojo.internal.Array(viz.mojom.ClipNodeSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'effectNodes', 240,
        0,
        mojo.internal.Array(viz.mojom.EffectNodeSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'scrollNodes', 248,
        0,
        mojo.internal.Array(viz.mojom.ScrollNodeSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'numTransformNodes', 256,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'numClipNodes', 260,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'numEffectNodes', 264,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'numScrollNodes', 268,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'tilings', 272,
        0,
        mojo.internal.Array(viz.mojom.TilingSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'surfaceRanges', 280,
        0,
        mojo.internal.Array(viz.mojom.SurfaceRangeSpec.$, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'viewTransitionRequests', 288,
        0,
        mojo.internal.Array(viz.mojom.ViewTransitionRequestSpec.$, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'animationTimelines', 296,
        0,
        mojo.internal.Array(viz.mojom.AnimationTimelineSpec.$, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'removedAnimationTimelines', 304,
        0,
        mojo.internal.Array(mojo.internal.Int32, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 320],]);





/** @record */
viz.mojom.LayerTreeUpdate = class {
  constructor() {
    /** @export { !viz.mojom.BeginFrameArgs } */
    this.beginFrameArgs;
    /** @export { !number } */
    this.sourceFrameNumber;
    /** @export { !bigint } */
    this.traceId;
    /** @export { !bigint } */
    this.primaryMainFrameItemSequenceNumber;
    /** @export { !cc.mojom.LayerSelection } */
    this.selection;
    /** @export { !number } */
    this.pageScaleFactor;
    /** @export { !number } */
    this.minPageScaleFactor;
    /** @export { !number } */
    this.maxPageScaleFactor;
    /** @export { !number } */
    this.externalPageScaleFactor;
    /** @export { !gfx.mojom.Rect } */
    this.deviceViewport;
    /** @export { !number } */
    this.deviceScaleFactor;
    /** @export { !number } */
    this.paintedDeviceScaleFactor;
    /** @export { !gfx.mojom.DisplayColorSpaces } */
    this.displayColorSpaces;
    /** @export { (viz.mojom.LocalSurfaceId|undefined) } */
    this.localSurfaceIdFromParent;
    /** @export { !viz.mojom.LocalSurfaceId } */
    this.currentLocalSurfaceId;
    /** @export { !number } */
    this.nextFrameToken;
    /** @export { !boolean } */
    this.sendFrameTokenToEmbedder;
    /** @export { (viz.mojom.LocalSurfaceId|undefined) } */
    this.targetLocalSurfaceId;
    /** @export { !skia.mojom.SkColor4f } */
    this.backgroundColor;
    /** @export { !number } */
    this.overscrollElasticityTransform;
    /** @export { !number } */
    this.pageScaleTransform;
    /** @export { !number } */
    this.innerScroll;
    /** @export { !number } */
    this.outerClip;
    /** @export { !number } */
    this.outerScroll;
    /** @export { !gfx.mojom.Rect } */
    this.viewportDamageRect;
    /** @export { !boolean } */
    this.fullTreeDamaged;
    /** @export { !cc.mojom.LayerTreeDebugState } */
    this.debugState;
    /** @export { !gfx.mojom.OverlayTransform } */
    this.displayTransformHint;
    /** @export { !number } */
    this.maxSafeAreaInsetBottom;
    /** @export { !cc.mojom.BrowserControlsParams } */
    this.browserControlsParams;
    /** @export { !cc.mojom.BrowserControlsOffsetTagModifications } */
    this.browserControlsOffsetTagModifications;
    /** @export { !number } */
    this.topControlsShownRatio;
    /** @export { !number } */
    this.bottomControlsShownRatio;
    /** @export { !Array<!viz.mojom.TransferableUIResourceRequest> } */
    this.uiResourceRequests;
    /** @export { !Array<!viz.mojom.Layer> } */
    this.layers;
    /** @export { (Array<!number>|undefined) } */
    this.layerOrder;
    /** @export { (viz.mojom.TransformTreeUpdate|undefined) } */
    this.transformTreeUpdate;
    /** @export { (viz.mojom.ScrollTreeUpdate|undefined) } */
    this.scrollTreeUpdate;
    /** @export { !Array<!viz.mojom.TransformNode> } */
    this.transformNodes;
    /** @export { !Array<!viz.mojom.ClipNode> } */
    this.clipNodes;
    /** @export { !Array<!viz.mojom.EffectNode> } */
    this.effectNodes;
    /** @export { !Array<!viz.mojom.ScrollNode> } */
    this.scrollNodes;
    /** @export { !number } */
    this.numTransformNodes;
    /** @export { !number } */
    this.numClipNodes;
    /** @export { !number } */
    this.numEffectNodes;
    /** @export { !number } */
    this.numScrollNodes;
    /** @export { !Array<!viz.mojom.Tiling> } */
    this.tilings;
    /** @export { (Array<!viz.mojom.SurfaceRange>|undefined) } */
    this.surfaceRanges;
    /** @export { (Array<!viz.mojom.ViewTransitionRequest>|undefined) } */
    this.viewTransitionRequests;
    /** @export { (Array<!viz.mojom.AnimationTimeline>|undefined) } */
    this.animationTimelines;
    /** @export { (Array<!number>|undefined) } */
    this.removedAnimationTimelines;
  }
};



mojo.internal.Struct(
    viz.mojom.PendingLayerContextSpec.$,
    'PendingLayerContext',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.AssociatedInterfaceRequest(viz.mojom.LayerContextPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'client', 4,
        0,
        mojo.internal.AssociatedInterfaceProxy(viz.mojom.LayerContextClientRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
viz.mojom.PendingLayerContext = class {
  constructor() {
    /** @export { !Object } */
    this.receiver;
    /** @export { !Object } */
    this.client;
  }
};



mojo.internal.Struct(
    viz.mojom.LayerContext_SetVisible_ParamsSpec.$,
    'LayerContext_SetVisible_Params',
    [
      mojo.internal.StructField(
        'visible', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
viz.mojom.LayerContext_SetVisible_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.visible;
  }
};



mojo.internal.Struct(
    viz.mojom.LayerContext_UpdateDisplayTree_ParamsSpec.$,
    'LayerContext_UpdateDisplayTree_Params',
    [
      mojo.internal.StructField(
        'update', 0,
        0,
        viz.mojom.LayerTreeUpdateSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
viz.mojom.LayerContext_UpdateDisplayTree_Params = class {
  constructor() {
    /** @export { !viz.mojom.LayerTreeUpdate } */
    this.update;
  }
};



mojo.internal.Struct(
    viz.mojom.LayerContext_UpdateDisplayTiling_ParamsSpec.$,
    'LayerContext_UpdateDisplayTiling_Params',
    [
      mojo.internal.StructField(
        'tiling', 0,
        0,
        viz.mojom.TilingSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'updateDamage', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
viz.mojom.LayerContext_UpdateDisplayTiling_Params = class {
  constructor() {
    /** @export { !viz.mojom.Tiling } */
    this.tiling;
    /** @export { !boolean } */
    this.updateDamage;
  }
};



mojo.internal.Struct(
    viz.mojom.LayerContextClient_OnRequestCommitForFrame_ParamsSpec.$,
    'LayerContextClient_OnRequestCommitForFrame_Params',
    [
      mojo.internal.StructField(
        'args', 0,
        0,
        viz.mojom.BeginFrameArgsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
viz.mojom.LayerContextClient_OnRequestCommitForFrame_Params = class {
  constructor() {
    /** @export { !viz.mojom.BeginFrameArgs } */
    this.args;
  }
};

