// services/viz/public/mojom/compositing/texture_releaser.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  SyncToken as gpu_mojom_SyncToken,
  SyncTokenSpec as gpu_mojom_SyncTokenSpec
} from '../../../../../gpu/ipc/common/sync_token.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class TextureReleaserPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'viz.mojom.TextureReleaser', scope);
  }
}

/** @interface */
export class TextureReleaserInterface {
  
  /**
   * @param { !gpu_mojom_SyncToken } syncToken
   * @param { !boolean } isLost
   */

  release(syncToken, isLost) {}
}

/**
 * @implements { TextureReleaserInterface }
 */
export class TextureReleaserRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!TextureReleaserPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          TextureReleaserPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!TextureReleaserPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !gpu_mojom_SyncToken } syncToken
   * @param { !boolean } isLost
   */

  release(
      syncToken,
      isLost) {
    this.proxy.sendMessage(
        0,
        TextureReleaser_Release_ParamsSpec.$,
        null,
        [
          syncToken,
          isLost
        ],
        false);
  }
}

/**
 * An object which receives request messages for the TextureReleaser
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class TextureReleaserReceiver {
  /**
   * @param {!TextureReleaserInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!TextureReleaserRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        TextureReleaserRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!TextureReleaserRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        TextureReleaser_Release_ParamsSpec.$,
        null,
        impl.release.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class TextureReleaser {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "viz.mojom.TextureReleaser";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!TextureReleaserRemote}
   */
  static getRemote() {
    let remote = new TextureReleaserRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the TextureReleaser
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class TextureReleaserCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      TextureReleaserRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!TextureReleaserRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.release =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        TextureReleaser_Release_ParamsSpec.$,
        null,
        this.release.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TextureReleaser_Release_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    TextureReleaser_Release_ParamsSpec.$,
    'TextureReleaser_Release_Params',
    [
      mojo.internal.StructField(
        'syncToken', 0,
        0,
        gpu_mojom_SyncTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isLost', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class TextureReleaser_Release_Params {
  constructor() {
    /** @type { !gpu_mojom_SyncToken } */
    this.syncToken;
    /** @type { !boolean } */
    this.isLost;
  }
}

