// services/viz/public/mojom/compositing/thread.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/viz/public/mojom/compositing/thread.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('viz.mojom');


  var ThreadType = {};
  ThreadType.kMain = 0;
  ThreadType.kIO = 1;
  ThreadType.kCompositor = 2;
  ThreadType.kVideo = 3;
  ThreadType.kOther = 4;
  ThreadType.MIN_VALUE = 0;
  ThreadType.MAX_VALUE = 4;

  ThreadType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
      return true;
    }
    return false;
  };

  ThreadType.toKnownEnumValue = function(value) {
    return value;
  };

  ThreadType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function Thread(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Thread.prototype.initDefaults_ = function() {
    this.id = 0;
    this.type = 0;
  };
  Thread.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Thread.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate Thread.type
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, ThreadType);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Thread.encodedSize = codec.kStructHeaderSize + 8;

  Thread.decode = function(decoder) {
    var packed;
    var val = new Thread();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.id =
        decoder.decodeStruct(codec.Uint32);
    val.type =
        decoder.decodeStruct(new codec.Enum(ThreadType));
    return val;
  };

  Thread.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Thread.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.id);
    encoder.encodeStruct(codec.Int32, val.type);
  };
  exports.ThreadType = ThreadType;
  exports.Thread = Thread;
})();